<?php

namespace BitApps\PiPro\src\Integrations\WPTravelEngine;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class WPTravelEngineHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'bookingCreated' => [
                'hook'          => 'wptravelengine.booking.created',
                'callback'      => [WPTravelEngineTrigger::class, 'bookingCreated'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'bookingUpdated' => [
                'hook'          => 'wptravelengine.booking.updated',
                'callback'      => [WPTravelEngineTrigger::class, 'bookingUpdated'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'enquiryCreated' => [
                'hook'          => 'wptravelengine.enquiry.created',
                'callback'      => [WPTravelEngineTrigger::class, 'enquiryCreated'],
                'priority'      => 10,
                'accepted_args' => 1,
            ]
        ];
    }
}
