<?php

namespace BitApps\PiPro\src\Integrations\WPTravelEngine;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}

use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class WPTravelEngineTrigger
{
    public static function bookingCreated($bookingData, $post)
    {
        return self::execute(
            'bookingCreated',
            [
                'booking_data' => $bookingData,
                'post_data'    => $post,
            ]
        );
    }

    public static function bookingUpdated($bookingData, $post)
    {
        return self::execute(
            'bookingUpdated',
            [
                'booking_data' => $bookingData,
                'post_data'    => $post,
            ]
        );
    }

    public static function enquiryCreated($enquiry)
    {
        return self::execute(
            'enquiryCreated',
            [
                'data'         => $enquiry->get_data() ?? [],
                'enquiry_data' => $enquiry->get_enquiry_data() ?? [],
                'post_data'    => $enquiry->post ?? [],
            ]
        );
    }

    private static function execute($machineSlug, $data)
    {
        $flows = FlowService::exists('WPTravelEngine', $machineSlug);

        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    // TODO:: need to implement
    private static function isPluginInstalled()
    {
        return class_exists('\WPTravelEngine\Plugin');
    }
}
