<?php

namespace BitApps\PiPro\src\Integrations\WPUserFrontend;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class WPUserFrontendTrigger
{
    public static function postFormSubmission($postId, $formId, $formSettings, $metaData)
    {
        $userData = \function_exists('wpuf_get_user') ? wpuf_get_user() : [];

        $postData = get_post($postId);
        $postMetadata = Utility::getPostMetadata($postId);
        $postCombineData = array_merge((array) $postData, $postMetadata);

        return self::execute(
            'postFormSubmission',
            [
                'post_id'      => $postId,
                'form_id'      => $formId,
                'post_data'    => $postCombineData,
                'user_data'    => $userData,
                'meta_data'    => $metaData,
                'formSettings' => $formSettings,
            ]
        );
    }

    public static function registrationFormSubmission($userId, $formId, $formSettings)
    {
        return self::execute(
            'registrationFormSubmission',
            [
                'user_id'       => $userId,
                'form_id'       => $formId,
                'user_data'     => Utility::getUserInfo($userId),
                'form_settings' => $formSettings,
            ]
        );
    }

    public static function subscriptionPackUpdated($id, $request, $post)
    {
        $subscription = !empty($request['subscription']) ? $request['subscription'] : '';

        return self::execute(
            'subscriptionPackUpdated',
            [
                'id'           => $id,
                'subscription' => $subscription,
                'post'         => $post
            ]
        );
    }

    public static function couponCreated($postId, $postData, $update, $postBefore = null)
    {
        if (
            (
                !empty($postBefore->post_status)
                && !\in_array($postBefore->post_status, ['draft', 'auto-draft'])
            )
            || $postData->post_status !== 'publish'
            || $postData->post_type != 'wpuf_coupon'
        ) {
            return;
        }

        return self::execute(
            'couponCreated',
            [
                'post_data' => $postData,
                'user_data' => Utility::getUserInfo($postData->post_author),
            ]
        );
    }

    public static function couponUpdated($postId, $postData)
    {
        return self::execute(
            'couponUpdated',
            [
                'post_data' => $postData,
                'user_data' => Utility::getUserInfo($postData['post_author']),
            ]
        );
    }

    public static function profileUpdated($userId, $formId, $formSettings, $metaData)
    {
        return self::execute(
            'profileUpdated',
            [
                'user_id'       => $userId,
                'form_id'       => $formId,
                'user_data'     => Utility::getUserInfo($userId),
                'meta_data'     => $metaData,
                'form_settings' => $formSettings,
            ]
        );
    }

    public static function userMetadataUpdated($userId, $postdata)
    {
        return self::execute(
            'userMetadataUpdated',
            [
                'user_data' => Utility::getUserInfo($userId),
                'post_data' => $postdata,
            ]
        );
    }

    private static function execute($machineSlug, $data)
    {
        $flows = FlowService::exists('WPUserFrontend', $machineSlug);

        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    // TODO:: need to implement
    private static function isPluginInstalled()
    {
        return class_exists('WPUF_Subscription');
    }
}
