<?php

namespace BitApps\SocialPro\Utils;

use BitApps\Social\Utils\SmartTag;

class ProSmartTagHandler
{
    public static function getProSmartTagValue($key, $postId)
    {
        // Handle custom_field_[key]
        if (preg_match('/^custom_field_\[([^\]]+)\]$/', $key, $matches)) {
            return self::getCustomFieldValue($postId, $matches[1]);
        }

        // Handle hashtags_[key]
        if (preg_match('/^hashtags_\[([^\]]+)\]$/', $key, $matches)) {
            return self::getHashtagsValue($postId, $matches[1]);
        }

        // Fallback: WooCommerce product info
        return (new WooCommerceProductInfo())->getWooCommerceInfo($key, $postId);
    }

    private static function getCustomFieldValue($postId, $customFieldKey)
    {
        $value = get_post_meta($postId, $customFieldKey, true);

        // Normalize arrays/objects to string
        if (\is_array($value) || \is_object($value)) {
            $value = implode(',', (array) $value);
        }

        return (string) $value;
    }

    private static function getHashtagsValue($postId, $tagKey)
    {
        static $smartTag;

        // Create SmartTag instance once
        if (!$smartTag) {
            $smartTag = new SmartTag();
        }

        $post = get_post($postId);
        if (!$post) {
            return '';
        }

        // Get raw tag value
        $rawValue = $smartTag->getSmartTagValue($tagKey, $post);

        // Convert to array
        $values = is_array($rawValue)
            ? $rawValue
            : (is_string($rawValue) ? preg_split('/[\s,]+/', trim($rawValue)) : []);

        // Clean up values and format as hashtags
        $hashtags = array_map(
            static fn($val) => '#' . strtolower(str_replace(' ', '_', trim($val))),
            array_filter($values)
        );

        return $hashtags ? implode(' ', $hashtags) : '';
    }
}