(function ($) {
    const $document = $(document);

    $document.ready(function () {
        const $eventColor = $('#event-color');
        const $saveButton = $('.settings-save-btn');
        const $eventContent = $('#event-content');
        const $eventRestoreButton = $('.event-restore-btn');
        const defaultEventContent = `
                <p>{appointment_start_time} - {appointment_end_time}</p>
                    <p>{service_name}</p>
                    <div class="flex">
                        <p>{customer_full_name}</p>
                        <i class="{appointment_status_icon_code}" style="background-color :{appointment_status_icon_color};"></i>
                    </div>
                    <div class="margin-top flex no-gap">
                       <div class="circle_image">
                         <img src="{staff_profile_image_url}" alt="{staff_name}">
                       </div>
                       <p>{staff_name}</p>
                </div>`;

        booknetic.summernote(
            $eventContent,
            [
                ['style', ['style']],
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['insert', ['link', 'picture']],
                ['view', ['codeview']],
                ['height', ['height']],
            ],
            eventContentShortCodesObject
        );

        $eventColor.select2({
            theme: 'bootstrap',
            placeholder: booknetic.__('Select color'),
        });

        $saveButton.on('click', function () {
            const eventContent = booknetic.summernoteReplace($eventContent, true);

            const plainText = $('<div>').html(eventContent).text().trim();

            if (plainText.length === 0) {
                booknetic.toast(booknetic.__('Please enter event content'), 'unsuccess');
                return;
            }


            const params = {
                appointmentCardColor: $eventColor.val(),
                eventContent
            }

            booknetic.ajax('save_calendar_settings', params, function () {
                booknetic.toast(booknetic.__('saved_successfully'), 'success');
            });
        });

        $eventRestoreButton.on('click', function (e) {
            e.preventDefault();
            booknetic.confirm(booknetic.__('are_you_sure'), 'warning', 'updates', function () {
                $eventContent.summernote('code', defaultEventContent);
            }, booknetic.__('restore'));
        });
    });

})(jQuery);