import { resolve } from "path";
import { defineConfig } from "vite";

export default defineConfig({
  build: {
    lib: {
      entry: resolve(__dirname, "src/index.ts"),
      name: "BreakdanceInteractions",
      fileName: "interactions",
      formats: ["umd"],
    },
    rollupOptions: {
      output: {
        assetFileNames: "interactions.[ext]",
      },
    },
    emptyOutDir: false,
  },
});