<?php

namespace Bricksforge\ProForms;

use Bricksforge\Helper\ElementsHelper as ElementsHelper;

if (!defined('ABSPATH')) {
    exit;
}

class Helper
{

    static function get_autocomplete_options()
    {
        return [
            "off" => "off",
            "on" => "on",
            "name" => "name",
            "honorific-prefix" => "honorific-prefix",
            "given-name" => "given-name",
            "additional-name" => "additional-name",
            "family-name" => "family-name",
            "honorific-suffix" => "honorific-suffix",
            "nickname" => "nickname",
            "email" => "email",
            "username" => "username",
            "new-password" => "new-password",
            "current-password" => "current-password",
            "one-time-code" => "one-time-code",
            "organization-title" => "organization-title",
            "organization" => "organization",
            "street-address" => "street-address",
            "address-line1" => "address-line1",
            "address-line2" => "address-line2",
            "address-line3" => "address-line3",
            "address-level4" => "address-level4",
            "address-level3" => "address-level3",
            "address-level2" => "address-level2",
            "address-level1" => "address-level1",
            "country" => "country",
            "country-name" => "country-name",
            "postal-code" => "postal-code",
            "cc-name" => "cc-name",
            "cc-given-name" => "cc-given-name",
            "cc-additional-name" => "cc-additional-name",
            "cc-family-name" => "cc-family-name",
            "cc-number" => "cc-number",
            "cc-exp" => "cc-exp",
            "cc-exp-month" => "cc-exp-month",
            "cc-exp-year" => "cc-exp-year",
            "cc-csc" => "cc-csc",
            "cc-type" => "cc-type",
            "transaction-currency" => "transaction-currency",
            "transaction-amount" => "transaction-amount",
            "language" => "language",
            "bday" => "bday",
            "bday-day" => "bday-day",
            "bday-month" => "bday-month",
            "bday-year" => "bday-year",
            "sex" => "sex",
            "tel" => "tel",
            "tel-country-code" => "tel-country-code",
            "tel-national" => "tel-national",
            "tel-area-code" => "tel-area-code",
            "tel-local" => "tel-local",
            "tel-local-prefix" => "tel-local-prefix",
            "tel-local-suffix" => "tel-local-suffix",
            "tel-extension" => "tel-extension",
            "impp" => "impp",
            "url" => "url",
            "photo" => "photo",
            "webauthn" => "webauthn",
        ];
    }

    static function get_submit_conditions()
    {
        return [
            'option'                   => esc_html__('Database: Option', 'bricksforge'),
            'post_meta'                => esc_html__('Post Meta Field', 'bricksforge'),
            'storage_item'             => esc_html__('Storage Item', 'bricksforge'),
            'form_field'               => esc_html__('Form Field', 'bricksforge'),
            'submission_count_reached' => esc_html__('Submission Limit Reached', 'bricksforge'),
            'submission_field'         => esc_html__('Submission Field (ID)', 'bricksforge'),
        ];
    }

    static function get_field_conditions($only_server_side = false)
    {
        $conditions = [
            'form_field'               => esc_html__('Form Field', 'bricksforge'),
            'storage_item'             => esc_html__('Storage Item', 'bricksforge'),
            'global_variable'          => esc_html__('Global Variable', 'bricksforge'),
        ];

        if ($only_server_side) {
            unset($conditions['storage_item']);
            unset($conditions['global_variable']);
        }

        return $conditions;
    }

    static function get_condition_operators()
    {
        return [
            '=='           => esc_html__('Is Equal', 'bricksforge'),
            '!='           => esc_html__('Is Not Equal', 'bricksforge'),
            '>'            => esc_html__('Is Greater Than', 'bricksforge'),
            '>='           => esc_html__('Is Greater Than or Equal', 'bricksforge'),
            '<'            => esc_html__('Is Less Than', 'bricksforge'),
            '<='           => esc_html__('Is Less Than or Equal', 'bricksforge'),
            'contains'     => esc_html__('Contains', 'bricksforge'),
            'not_contains' => esc_html__('Not Contains', 'bricksforge'),
            'contained_in' => esc_html__('Is Contained In', 'bricksforge'),
            'is_not_contained_in' => esc_html__('Is Not Contained In', 'bricksforge'),
            'starts_with'  => esc_html__('Starts With', 'bricksforge'),
            'ends_with'    => esc_html__('Ends With', 'bricksforge'),
            'empty'        => esc_html__('Is Empty', 'bricksforge'),
            'not_empty'    => esc_html__('Is Not Empty', 'bricksforge'),
            'exists'       => esc_html__('Exists', 'bricksforge'),
            'not_exists'   => esc_html__('Not Exists', 'bricksforge'),
        ];
    }

    static function get_condition_data_types()
    {
        return [
            'string' => esc_html__('String', 'bricksforge'),
            'number' => esc_html__('Number', 'bricksforge'),
            'array'  => esc_html__('Array', 'bricksforge'),
        ];
    }

    static function get_loop_controls()
    {
        $controls = [];

        $controls['hasLoop'] = [
            'label' => esc_html__('Use query loop', 'bricksforge'),
            'type'  => 'checkbox',
        ];

        $controls['query'] = [
            'label'    => esc_html__('Query', 'bricksforge'),
            'type'     => 'query',
            'popup'    => true,
            'inline'   => true,
            'required' => [
                'hasLoop',
                '=',
                true,
            ],
        ];

        return $controls;
    }

    static function get_selected_controls()
    {
        $controls = [];

        $controls['conditionallySelected'] = [
            'group' => 'general',
            'type'  => 'checkbox',
            'inline' => true,
            'label' => esc_html__('Conditionally Selected', 'bricksforge'),
        ];

        // Selected If
        $controls['selectedIf'] = [
            'group' => 'general',
            'type'  => 'select',
            'label' => esc_html__('Selected If', 'bricksforge'),
            'options' => [
                'value' => esc_html__('Option Value Is', 'bricksforge'),
                'value_contains' => esc_html__('Option Value Contains', 'bricksforge'),
                'contains_array' => esc_html__('Option Value Contains Array', 'bricksforge'),
                'taxonomy' => esc_html__('Is Enabled Post Taxonomy Term', 'bricksforge'),
            ],
            'required' => [['conditionallySelected', '=', true]],
        ];

        $controls['containsArrayInfo'] = [
            'group' => 'general',
            'type'  => 'info',
            'content' => esc_html__('The value must be an encoded array of values. For example: ["value1", "value2", "value3"]', 'bricksforge'),
            'required' => [['selectedIf', '=', 'contains_array']],
        ];

        $controls['selectedIfValue'] = [
            'group' => 'general',
            'type'  => 'text',
            'label' => esc_html__('Value', 'bricksforge'),
            'required' => [['conditionallySelected', '=', true], ['selectedIf', '=', ['value', 'value_contains', 'contains_array']]],
        ];

        $controls['selectedIfPostId'] = [
            'group' => 'general',
            'type'  => 'text',
            'label' => esc_html__('Post ID', 'bricksforge'),
            'required' => [['conditionallySelected', '=', true], ['selectedIf', '=', 'taxonomy']],
        ];

        $controls['selectedIfTaxonomy'] = [
            'group' => 'general',
            'type'  => 'text',
            'label' => esc_html__('Taxonomy Key', 'bricksforge'),
            'required' => [['conditionallySelected', '=', true], ['selectedIf', '=', 'taxonomy']],
        ];

        return $controls;
    }

    static function get_checked_controls()
    {
        $controls = [];
        $controls['checked'] = [
            'group' => 'general',
            'type'  => 'checkbox',
            'label' => esc_html__('Checked', 'bricksforge'),
        ];

        $controls['conditionallyChecked'] = [
            'group' => 'general',
            'type'  => 'checkbox',
            'inline' => true,
            'label' => esc_html__('Conditionally Checked', 'bricksforge'),
        ];

        // Checked If
        $controls['checkedIf'] = [
            'group' => 'general',
            'type'  => 'select',
            'label' => esc_html__('Checked If', 'bricksforge'),
            'options' => [
                'value' => esc_html__('Checkbox Value Is', 'bricksforge'),
                'value_contains' => esc_html__('Checkbox Value Contains', 'bricksforge'),
                'contains_array' => esc_html__('Checkboxes contain Array Values', 'bricksforge'),
                'taxonomy' => esc_html__('Is Enabled Post Taxonomy Term', 'bricksforge'),
            ],
            'required' => [['conditionallyChecked', '=', true]],
        ];

        // contains_array info
        $controls['containsArrayInfo'] = [
            'group' => 'general',
            'type'  => 'info',
            'content' => esc_html__('The value must be an encoded array of values. For example: ["value1", "value2", "value3"]', 'bricksforge'),
            'required' => [['checkedIf', '=', 'contains_array']],
        ];


        $controls['checkedIfValue'] = [
            'group' => 'general',
            'type'  => 'text',
            'label' => esc_html__('Value', 'bricksforge'),
            'required' => ['checkedIf', '=', ['value', 'value_contains', 'contains_array']],
        ];

        $controls['checkedIfPostId'] = [
            'group' => 'general',
            'type'  => 'text',
            'label' => esc_html__('Post ID', 'bricksforge'),
            'required' => [['checkedIf', '=', 'taxonomy']],
        ];

        $controls['checkedIfTaxonomy'] = [
            'group' => 'general',
            'type'  => 'text',
            'label' => esc_html__('Taxonomy Key', 'bricksforge'),
            'required' => [['checkedIf', '=', 'taxonomy']],
        ];

        return $controls;
    }

    static function get_default_controls($field_type = '')
    {
        $controls = [];

        $default_width = '100%';
        $default_width_selector = 'input';

        if ($field_type == 'checkbox' || $field_type == 'radio') {
            $default_width = 'auto';
            $default_width_selector = '&';
        }

        if ($field_type == 'checkbox_wrapper' || $field_type == 'radio_wrapper') {
            $default_width_selector = '&';
        }

        if ($field_type == 'textarea') {
            $default_width_selector = 'textarea';
        }

        if ($field_type == 'file') {
            $default_width_selector = '.choose-files';
        }

        if ($field_type == 'select') {
            $default_width_selector = '&';
        }

        $needs_width = !in_array($field_type, ['checkbox', 'radio', 'image-checkbox', 'image-radio', 'card-checkbox', 'card-radio', 'signature', 'rating']);
        $needs_initial_value = !in_array($field_type, ['checkbox_wrapper', 'radio_wrapper', 'signature', 'rating']);
        $needs_required = !in_array($field_type, ['checkbox_wrapper', 'radio_wrapper', 'hidden']);
        $needs_custom_required = in_array($field_type, ['checkbox_wrapper', 'radio_wrapper']);
        $needs_custom_required_count = in_array($field_type, ['checkbox_wrapper']);
        $needs_icon = !in_array($field_type, ['file', 'checkbox_wrapper', 'radio_wrapper', 'hidden', 'checkbox', 'radio', 'card-checkbox', 'card-radio', 'rating']);
        $needs_custom_id = !in_array($field_type, ['checkbox', 'radio', 'card-checkbox', 'card-radio', 'image-checkbox', 'image-radio']);
        $needs_pattern = in_array($field_type, ['text', 'email', 'number', 'tel', 'url', 'password', 'textarea']);
        $needs_style = in_array($field_type, ['text', 'email', 'number', 'tel', 'url', 'password', 'textarea', 'calculation', 'date', 'select', 'colorPicker']);
        $needs_disabled = in_array($field_type, ['text', 'email', 'number', 'tel', 'url', 'password', 'textarea', 'calculation', 'date', 'select']);
        $needs_readonly = in_array($field_type, ['text', 'email', 'number', 'tel', 'url', 'password', 'textarea']);
        $next_step_triggers = in_array($field_type, ['radio', 'card-radio', 'image-radio']);
        $needs_masking = in_array($field_type, ['text']);
        $needs_context = true;
        $needs_calculation_value = in_array($field_type, ['checkbox', 'radio', 'card-checkbox', 'card-radio', 'image-checkbox', 'image-radio', 'option']);

        $initial_value_default = '';

        // If types like checkboxes or radios or options, set the initial value to "value"
        if (in_array($field_type, ['checkbox', 'radio', 'card-checkbox', 'card-radio', 'image-checkbox', 'image-radio'])) {
            $initial_value_default = 'Value';
        }

        // ID
        $id_description = esc_html__('The ID is used to identify the field in the form submission. If not set, the element ID will be used.', 'bricksforge');

        if ($needs_custom_id) {
            $controls['id'] = [
                'group' => 'general',
                'label'          => esc_html__('Custom ID', 'bricksforge'),
                'description'    => $id_description,
                'type'           => 'text',
                'inline'         => true,
                'spellcheck'     => false,
                'hasDynamicData' => true,
                'default' => \Bricks\Helpers::generate_random_id(false)
            ];
        }

        if ($needs_masking) {
            $controls['enableInputMasking'] = [
                'group' => 'inputMasking',
                'label' => esc_html__('Input Masking', 'bricksforge'),
                'type'  => 'checkbox',
                'default' => false,
                'description' => esc_html__('Enable input masking.', 'bricksforge'),
            ];
            $controls['inputMaskingMethod'] = [
                'group' => 'inputMasking',
                'label' => esc_html__('Input Masking Method', 'bricksforge'),
                'type'  => 'select',
                'options' => [
                    'pattern' => esc_html__('Pattern', 'bricksforge'),
                ],
                'description' => esc_html__('Enter the input masking method.', 'bricksforge'),
                'required' => [['enableInputMasking', '=', true]],
            ];

            // Mask
            $controls['maskPattern'] = [
                'group' => 'inputMasking',
                'label' => esc_html__('Mask', 'bricksforge'),
                'type'  => 'text',
                'description' => esc_html__('Enter the input mask. 0 = Any Digit, a = Any Letter, * = Any Char ', 'bricksforge'),
                'required' => [['enableInputMasking', '=', true], ['inputMaskingMethod', '=', 'pattern']],
            ];

            // Repeater for Definitions
            $controls['maskDefinitions'] = [
                'group' => 'inputMasking',
                'label' => esc_html__('Mask Definitions', 'bricksforge'),
                'type'  => 'repeater',
                'titleProperty' => 'name',
                'fields' => [
                    'name' => [
                        'label' => esc_html__('Character', 'bricksforge'),
                        'type'  => 'text',
                    ],
                    'mask' => [
                        'label' => esc_html__('Mask', 'bricksforge'),
                        'type'  => 'text',
                        'placeholder' => '*',
                    ],
                    'placeholderChar' => [
                        'label' => esc_html__('Placeholder Character', 'bricksforge'),
                        'type'  => 'text',
                        'placeholder' => '_',
                    ],
                ],
                'required' => [['enableInputMasking', '=', true], ['inputMaskingMethod', '=', 'pattern']],
            ];

            // Lazy
            $controls['lazyMasking'] = [
                'group' => 'inputMasking',
                'label' => esc_html__('Lazy', 'bricksforge'),
                'type'  => 'checkbox',
                'default' => false,
                'description' => esc_html__('If checked, the mask will be applied only after the user starts typing.', 'bricksforge'),
                'required' => [['enableInputMasking', '=', true]],
            ];
        }

        // Pattern
        if ($needs_pattern) {
            $controls['pattern'] = [
                'group' => 'general',
                'label'          => esc_html__('Pattern', 'bricksforge'),
                'description'    => esc_html__('Expects a regular expression. (For example: [56]*)', 'bricksforge'),
                'type'           => 'text',
                'inline'         => true,
                'spellcheck'     => false,
                'hasDynamicData' => true,
            ];
        }

        // Label
        $controls['label'] = [
            'group' => 'general',
            'label'          => esc_html__('Label', 'bricksforge'),
            'type'           => 'text',
            'inline'         => true,
            'spellcheck'     => false,
            'hasDynamicData' => true,
            'default'        => esc_html__('Label', 'bricksforge'),
        ];

        // Initial Value
        if ($needs_initial_value) {
            $controls['value'] = [
                'group' => 'general',
                'label'          => esc_html__('Value', 'bricksforge'),
                'type'           => 'text',
                'inline'         => true,
                'spellcheck'     => false,
                'hasDynamicData' => true,
                'default'        => $initial_value_default,
            ];
        }

        if ($needs_calculation_value) {
            $controls['calculationValue'] = [
                'group' => 'general',
                'label'          => esc_html__('Calculation Value', 'bricksforge'),
                'type'           => 'number',
                'inline'         => true,
                'hasDynamicData' => true,
                'description'    => esc_html__('A numeric value that will be used for calculation fields.', 'bricksforge'),
            ];
        }

        // Show Label
        if ($field_type != "hidden") {
            $controls['showLabel'] = [
                'group' => 'general',
                'label'          => esc_html__('Show Label', 'bricksforge'),
                'type'           => 'checkbox',
                'default'        => true,
            ];
        }

        if ($needs_context) {
            $controls['postContext'] = [
                'group' => 'general',
                'label'          => esc_html__('Context', 'bricksforge'),
                'type'           => 'text',
                'inline'         => true,
                'hasDynamicData' => true,
                'description'    => esc_html__('If you dont get the data you expect, it sometimes helps to include a post id as context. This field allows dynamic data.', 'bricksforge'),
            ];
        }

        // Width
        if ($needs_width) {
            $controls['width'] = [
                'group' => 'general',
                'label'          => esc_html__('Width', 'bricksforge'),
                'type'           => 'text',
                'inline'         => true,
                'spellcheck'     => false,
                'default'        => $default_width,
                'units' => true,

                //'rerender' => true,
                'css' => [
                    [
                        'property' => 'width',
                        'selector' => $default_width_selector
                    ],
                ],
            ];
        }

        if ($field_type == 'textarea') {

            // Height
            $controls['height'] = [
                'group'    => 'general',
                'label'    => esc_html__('Height', 'bricksforge'),
                'type'     => 'number',
                'units'    => true,
                'css'      => [
                    [
                        'property' => 'height',
                    ],
                    // We set the min-height to 0 to allow the textarea to grow
                    [
                        'property' => 'min-height',
                        'selector' => '&.form-group textarea',
                        'value' => '0px',
                    ],
                ],
            ];
        }

        // Required
        if ($needs_required) {
            $controls['required'] = [
                'group' => 'general',
                'label'          => esc_html__('Required', 'bricksforge'),
                'type'           => 'checkbox',
                'default'        => false,
                'description'    => esc_html__('If checked, the field will be required.', 'bricksforge'),
            ];
        }

        // Custom Required
        if ($needs_custom_required) {
            $controls['customRequired'] = [
                'group' => 'general',
                'label'          => esc_html__('Required', 'bricksforge'),
                'type'           => 'checkbox',
                'default'        => false,
                'description'    => esc_html__('If checked, the field will be required.', 'bricksforge'),
            ];
        }

        // Required Count
        if ($needs_custom_required_count) {
            $controls['customRequiredCount'] = [
                'group' => 'general',
                'label'          => esc_html__('Required Count', 'bricksforge'),
                'type'           => 'number',
                'default'        => 1,
                'description'    => esc_html__('The minimum number of checkboxes that must be checked.', 'bricksforge'),
                'required' => [['customRequired', '=', true]],
            ];
        }

        if ($needs_icon) {
            $controls['icon'] = [
                'group' => 'general',
                'label' => esc_html__('Icon', 'bricksforge'),
                'type'  => 'icon',
                'description' => esc_html__('Icon Settings can be found under "Pro Forms" -> "Global Field Styles" -> "Icon".', 'bricksforge'),
            ];
        }

        // Disabled
        if ($needs_disabled) {
            $controls['disabled'] = [
                'group' => 'general',
                'label'          => esc_html__('Disabled', 'bricksforge'),
                'type'           => 'checkbox',
                'default'        => false,
                'description'    => esc_html__('If checked, the field will be disabled.', 'bricksforge'),
            ];
        }

        // Readonly
        if ($needs_readonly) {
            $controls['readonly'] = [
                'group' => 'general',
                'label'          => esc_html__('Readonly', 'bricksforge'),
                'type'           => 'checkbox',
                'default'        => false,
                'description'    => esc_html__('If checked, the field will be readonly.', 'bricksforge'),
            ];
        }

        // Triggers Next Step
        if ($next_step_triggers) {
            $controls['nextStepTrigger'] = [
                'group' => 'general',
                'label'          => esc_html__('Triggers Next Step', 'bricksforge'),
                'type'           => 'checkbox',
                'default'        => false,
                'description'    => esc_html__('If checked, the field will trigger the next step.', 'bricksforge'),
            ];
        }

        /**
         * Style
         */
        if ($needs_style) {
            // Background
            $controls['background'] = [
                'group' => 'style',
                'label'          => esc_html__('Background', 'bricksforge'),
                'type'           => 'background',
                'css' => [
                    [
                        'property' => 'background',
                        'selector' => '&.form-group input[name*="form-field-"], input[name*="brfr"], textarea[name*="brfr"], select[name*="brfr"], textarea[name*="form-field-"], select[name*="form-field-"], .choices, .choices .choices__inner, .choices .choices__item, .choices, .choices[data-type*=select-one] .choices__input, .choices__list--dropdown, .flatpickr.input',
                    ],
                ],
            ];

            // Typography
            $controls['typography'] = [
                'group' => 'style',
                'label'          => esc_html__('Typography', 'bricksforge'),
                'type'           => 'typography',
                'css' => [
                    [
                        'property' => 'typography',
                        'selector' => '&.form-group input[name*="form-field-"], textarea[name*="form-field-"], select[name*="form-field-"], input[name*="brfr"], textarea[name*="brfr"], select[name*="brfr"], .choices .choices__inner, .choices .choices__item, .choices, .choices[data-type*=select-one] .choices__input',
                    ],
                ],
            ];

            // Padding
            $controls['padding'] = [
                'group' => 'style',
                'label'          => esc_html__('Padding', 'bricksforge'),
                'type'           => 'spacing',
                'css' => [
                    [
                        'property' => 'padding',
                        'selector' => '&.form-group input[name*="form-field-"], textarea[name*="form-field-"], select[name*="form-field-"], input[name*="brfr"], textarea[name*="brfr"], select[name*="brfr"], .choices .choices__inner',
                    ],
                ],
            ];

            // Border
            $controls['border'] = [
                'group' => 'style',
                'label'          => esc_html__('Border', 'bricksforge'),
                'type'           => 'border',
                'css' => [
                    [
                        'property' => 'border',
                        'selector' => '&.form-group input[name*="form-field-"], textarea[name*="form-field-"], select[name*="form-field-"],input[name*="brfr"], textarea[name*="brfr"], select[name*="brfr"], .choices .choices__inner, .choices, .choices[data-type*=select-one] .choices__input',
                    ],
                ],
            ];

            // Box Shadow
            $controls['boxShadow'] = [
                'group' => 'style',
                'label'          => esc_html__('Box Shadow', 'bricksforge'),
                'type'           => 'box-shadow',
                'css' => [
                    [
                        'property' => 'box-shadow',
                        'selector' => '&.form-group input[name*="form-field-"], textarea[name*="form-field-"], select[name*="form-field-"],input[name*="brfr"], textarea[name*="brfr"], select[name*="brfr"], .choices .choices__inner, .choices, .choices[data-type*=select-one] .choices__input',
                    ],
                ],
            ];

            // Transform
            $controls['transform'] = [
                'group' => 'style',
                'label'          => esc_html__(' Transform', 'bricksforge'),
                'type'           => 'transform',
                'css' => [
                    [
                        'property' => 'transform',
                        'selector' => '&.form-group input[name*="form-field-"], textarea[name*="form-field-"], select[name*="form-field-"],input[name*="brfr"], textarea[name*="brfr"], select[name*="brfr"], .choices .choices__inner, .choices .choices__item, .choices, .choices[data-type*=select-one] .choices__input',
                    ],
                ],
            ];
        }

        return $controls;
    }

    static function get_validation_controls()
    {
        $controls = [];

        $controls['validation'] = [
            'group' => 'validation',
            'label' => esc_html__('Validation Rules', 'bricksforge'),
            'type'  => 'repeater',
            'titleProperty' => 'type',
            'fields' => [
                // Type
                'type' => [
                    'label' => esc_html__('Validation Type', 'bricksforge'),
                    'type'  => 'select',
                    'options' => [
                        'required' => esc_html__('Required', 'bricksforge'),
                        'email' => esc_html__('Email', 'bricksforge'),
                        'number' => esc_html__('Number', 'bricksforge'),
                        'url' => esc_html__('URL', 'bricksforge'),
                        'minChars' => esc_html__('Minimum Characters', 'bricksforge'),
                        'maxChars' => esc_html__('Maximum Characters', 'bricksforge'),
                        'value' => esc_html__('Value', 'bricksforge'),
                        'custom' => esc_html__('Custom (Regex)', 'bricksforge'),
                    ],
                ],

                // Chars
                'charsCount' => [
                    'label' => esc_html__('Characters', 'bricksforge'),
                    'type'  => 'number',
                    'required' => [['type', '=', ['minChars', 'maxChars']]],
                ],

                // Value
                'value' => [
                    'label' => esc_html__('Value', 'bricksforge'),
                    'type'  => 'text',
                    'required' => [['type', '=', ['value']]],
                ],

                // Custom (Regex)
                'regex' => [
                    'label' => esc_html__('Regex', 'bricksforge'),
                    'type'  => 'text',
                    'required' => [['type', '=', 'custom']],
                ],

                // Message
                'message' => [
                    'label' => esc_html__('Validation Message', 'bricksforge'),
                    'type'  => 'text',
                ],
            ],
        ];

        $controls['showMessageBelowField'] = [
            'group' => 'validation',
            'label' => esc_html__('Show Message Below Field', 'bricksforge'),
            'type'  => 'checkbox',
            'description' => esc_html__('If checked, the validation message will be shown below the field instead as alert below the form.', 'bricksforge'),
        ];

        $controls['enableLiveValidation'] = [
            'group' => 'validation',
            'label' => esc_html__('Live Validation', 'bricksforge'),
            'type'  => 'checkbox',
            'description' => esc_html__('Validates form fields on blur.', 'bricksforge'),
        ];

        // Show Message
        /* $controls['showValidationMessage'] = [
            'group' => 'validation',
            'label' => esc_html__('Show Validation Message', 'bricksforge'),
            'type'  => 'checkbox',
            'required' => [['enableLiveValidation', '=', true]],
        ]; */

        /* $controls['validationMessageTypography'] = [
            'group' => 'validation',
            'label' => esc_html__('Message Typography', 'bricksforge'),
            'type'  => 'typography',
            'required' => [['showValidationMessage', '=', true], ['enableLiveValidation', '=', true]],
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => '.brf-validation-message',
                ],
            ],
        ];

        $controls['validationFieldBorder'] = [
            'group' => 'validation',
            'label' => esc_html__('Invalid Field Border', 'bricksforge'),
            'type'  => 'border',
            'required' => [['showValidationMessage', '=', true], ['enableLiveValidation', '=', true]],
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.brf-invalid',
                ],
            ],
        ]; */

        return $controls;
    }
    static function get_accessibility_controls()
    {
        $controls = [];

        // Outline (Accessibility)
        $controls['outline'] = [
            'group' => 'accessibility',
            'label'          => esc_html__('Focus Outline', 'bricksforge'),
            'type'           => 'text',
            'css' => [
                [
                    'property' => 'outline',
                    'selector' => 'input:focus-visible + label',
                ],
            ],
        ];

        // Border
        $controls['border'] = [
            'group' => 'accessibility',
            'label'          => esc_html__('Focus Border', 'bricksforge'),
            'type'           => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => 'input:focus-visible + label',
                ],
            ],
        ];

        // Filter (Accessibility)
        $controls['filter'] = [
            'group' => 'accessibility',
            'label'          => esc_html__('Focus Filter', 'bricksforge'),
            'type'           => 'filters',
            'inline' => true,
            'css' => [
                [
                    'property' => 'filter',
                    'selector' => 'input:focus-visible + label',
                ],
            ],
        ];

        // Transform (Accessibility)
        $controls['transform'] = [
            'group' => 'accessibility',
            'label'          => esc_html__('Focus Transform', 'bricksforge'),
            'type'           => 'transform',
            'css' => [
                [
                    'property' => 'transform',
                    'selector' => 'input:focus-visible + label',
                ],
            ],
        ];

        return $controls;
    }

    static function to_camel_case($string)
    {
        // First convert to kebab case to standardize
        $string = preg_replace('/([a-z])([A-Z])/', '$1-$2', $string);
        $string = preg_replace('/[\s_-]+/', '-', $string);
        $string = strtolower(trim($string, '-'));

        // Then convert to camelCase
        return lcfirst(str_replace(' ', '', ucwords(str_replace('-', ' ', $string))));
    }

    /**
     * Helper function to concatenate prefix and suffix into camelCase.
     *
     * @param string $prefix The prefix string.
     * @param string $suffix The suffix string.
     * @return string The concatenated camelCase string if prefix exists, otherwise the suffix.
     */
    static function concat_camel_case($prefix, $suffix)
    {
        // Remove any non-alphanumeric characters from prefix
        $prefix = preg_replace('/[^a-zA-Z0-9]/', '', $prefix);

        if (!empty($prefix)) {
            // Ensure prefix starts with lowercase
            $prefix = lcfirst($prefix);

            // Capitalize the first letter of the suffix
            $suffix = ucfirst($suffix);

            return $prefix . $suffix;
        }

        // If no prefix, return suffix with first letter lowercase
        return lcfirst($suffix);
    }

    static function get_condition_controls($group = 'conditions', $title = "Add Conditions", $info = true, $additional_condition_fields = [], $with_relation = true, $idPrefix = '', $title_property = 'condition', $only_server_side = false)
    {
        $controls = [];

        // Ensure idPrefix is a string and trim any whitespace
        $idPrefix = is_string($idPrefix) ? trim($idPrefix) : '';

        // Info
        if ($info) {
            $controlId = self::concat_camel_case($idPrefix, 'conditionsInfo');
            $controls[$controlId] = [
                'group' => $group,
                'type'  => 'info',
                'content' => '<h2 style="color: var(--builder-color-info);font-size: 1.5rem;margin-bottom: 0.7rem;margin-top: 0.1rem;">' . esc_html__('Conditions', 'bricksforge') . '</h2><p>' . wp_kses('<br><br>With conditions, you can show or hide elements or steps based on certain conditions. <strong>Important: If the condition is met, the field/step will be shown, otherwise it will be hidden.</strong>', 'bricksforge') . '</p>',
            ];
        }

        // Has Conditions Checkbox
        $controlId = self::concat_camel_case($idPrefix, 'hasConditions');
        $controls[$controlId] = [
            'group' => $group,
            'label' => esc_html__($title, 'bricksforge'),
            'type'  => 'checkbox',
            'default' => false,
        ];

        // Conditions Repeater
        $conditionsControlId = self::concat_camel_case($idPrefix, 'conditions');
        $hasConditionsControlId = self::concat_camel_case($idPrefix, 'hasConditions');
        $controls[$conditionsControlId] = [
            'group' => $group,
            'label' => esc_html__('Conditions', 'bricksforge'),
            'type'  => 'repeater',
            'titleProperty' => $title_property,
            'required' => [[$hasConditionsControlId, '=', true]],
            'fields'        => array_merge(
                $additional_condition_fields,
                [
                    'postId'   => [
                        'label'       => esc_html__('Post ID', 'bricksforge'),
                        'type'        => 'text',
                        'placeholder' => 'Leave Empty For Current Post ID',
                        'required'    => [['condition', '=', 'post_meta']],
                    ],
                    'condition'         => [
                        'label' => esc_html__('Condition', 'bricksforge'),
                        'tab'     => 'content',
                        'group'   => 'submitButton',
                        'type'    => 'select',
                        'options' => self::get_field_conditions($only_server_side),
                        'default' => 'option'
                    ],

                    'value'    => [
                        'required' => [['condition'], ['condition', '!=', 'submission_count_reached']],
                        'tab'      => 'content',
                        'group'    => 'submitButton',
                        'type'     => 'text',
                        'default'  => ''
                    ],

                    'operator' => [
                        'required' => [['value'], ['condition', '!=', 'submission_count_reached']],
                        'tab'      => 'content',
                        'group'    => 'submitButton',
                        'type'     => 'select',
                        'options'  => self::get_condition_operators(),
                        'default'  => '=='
                    ],

                    'value2'   => [
                        'required' => [['operator'], ['value', '!=', ''], ['condition', '!=', 'submission_count_reached'], ['operator', '!=', ['exists', 'not_exists', 'empty', 'not_empty']]],
                        'tab'      => 'content',
                        'group'    => 'submitButton',
                        'type'     => 'text',
                        'default'  => ''
                    ],

                    'type'     => [
                        'required' => [['condition', '!=', 'submission_count_reached']],
                        'tab'      => 'content',
                        'group'    => 'submitButton',
                        'label'    => esc_html__('Data Type', 'bricksforge'),
                        'type'     => 'select',
                        'options'  => self::get_condition_data_types(),
                        'default'  => 'string'
                    ]
                ]
            )
        ];

        // Conditions Relation
        if ($with_relation) {
            $conditionsRelationId = self::concat_camel_case($idPrefix, 'conditionsRelation');
            $controls[$conditionsRelationId] = [
                'group' => $group,
                'label' => esc_html__('Conditions Relation', 'bricksforge'),
                'type'  => 'select',
                'required' => [[$hasConditionsControlId, '=', true]],
                'options' => [
                    'and' => esc_html__('AND', 'bricksforge'),
                    'or'  => esc_html__('OR', 'bricksforge'),
                ],
                'default' => 'and'
            ];
        }

        return $controls;
    }

    static function get_data_source_controls()
    {
        $controls = [];

        // Info
        $controls['dataSourceInfo'] = [
            'group' => 'options',
            'type'  => 'info',
            'content' => '<h2 style="color: var(--builder-color-info);font-size: 1.5rem;margin-bottom: 0.7rem;margin-top: 0.1rem;">' . esc_html__('Options', 'bricksforge') . '</h2><p>' . esc_html__('Populate options using static data, JSON, Dynamic Data or nestable elements for select, radio, and checkbox fields.', 'bricksforge') . '</p>',
        ];

        // Select
        $controls['dataSourceSelect'] = [
            'group' => 'options',
            'label' => esc_html__('Populate Options', 'bricksforge'),
            'type'  => 'select',
            'options' => [
                'static' => esc_html__('Static', 'bricksforge'),
                'json' => esc_html__('JSON', 'bricksforge'),
                'dynamic' => esc_html__('Dynamic Data', 'bricksforge'),
                'acf_array' => esc_html__('ACF Array', 'bricksforge'),
                'countries' => esc_html__('Countries', 'bricksforge'),
                'nestable' => esc_html__('Nestable', 'bricksforge'),
            ],
            'default' => 'nestable'
        ];

        $controls['dataSourceCustom'] = [
            'group' => 'options',
            'label' => esc_html__('Static Data', 'bricksforge'),
            'type'  => 'repeater',
            'titleProperty' => 'label',
            'fields' => [
                'value' => [
                    'label' => esc_html__('Value', 'bricksforge'),
                    'type'  => 'text',
                ],
                'label' => [
                    'label' => esc_html__('Label', 'bricksforge'),
                    'type'  => 'text',
                ]
            ],
            'required' => [['dataSourceSelect', '=', 'static']],
        ];

        // Dynamic Data

        $controls['dataSourceDynamic'] = [
            'group' => 'options',
            'label' => esc_html__('Dynamic Data', 'bricksforge'),
            'type'  => 'text',
            'description' => esc_html__('Use the Dynamic Data field to populate options from a dynamic data source. Important: You need to return a json encoded array of objects with a "value" and a "label" property. Use the key "checked" to populate checkboxes and radios.', 'bricksforge'),
            'required' => [['dataSourceSelect', '=', 'dynamic']],
        ];

        // ACF Array
        $controls['dataSourceAcfArray'] = [
            'group' => 'options',
            'label' => esc_html__('ACF Field Name', 'bricksforge'),
            'type'  => 'text',
            'required' => [['dataSourceSelect', '=', 'acf_array']],
        ];

        // Field Key (Optional)
        $controls['dataSourceAcfArrayFieldKey'] = [
            'group' => 'options',
            'label' => esc_html__('ACF Field Key (Optional)', 'bricksforge'),
            'type'  => 'text',
            'description' => esc_html__('In some circumstances it may be necessary to load a field by its key, such as when a value has not yet been saved. If entering the name works for you, you can leave this empty.', 'bricksforge'),
            'required' => [['dataSourceSelect', '=', 'acf_array']],
        ];

        // Context (Post Id)
        $controls['dataSourceAcfArrayContext'] = [
            'group' => 'options',
            'label' => esc_html__('Context (Post Id)', 'bricksforge'),
            'type'  => 'text',
            'description' => esc_html__('If you want to load the ACF field from a specific post, you can enter the post ID here.', 'bricksforge'),
            'required' => [['dataSourceSelect', '=', 'acf_array']],
        ];

        // Sync Fields (Load activated on page load)
        $controls['dataSourceSyncFields'] = [
            'group' => 'options',
            'label' => esc_html__('Sync Fields', 'bricksforge'),
            'type'  => 'checkbox',
            'description' => esc_html__('Select / Check the activated field values on page load.', 'bricksforge'),
            'required' => [['dataSourceSelect', '=', 'acf_array']],
        ];

        $controls['dataSourceJson'] = [
            'group' => 'options',
            'label' => esc_html__('JSON Data', 'bricksforge'),
            'type'  => 'code',
            'description' => esc_html__('Enter a JSON array of objects. Each object can have a "value" and a "label" property. If you use single values, the value will be used as label.', 'bricksforge'),
            'required' => [['dataSourceSelect', '=', 'json']],
        ];

        // If dataSourceJson is set, we offer alternative key label pairs
        $controls['dataSourceKeyLabel'] = [
            'group' => 'options',
            'label' => esc_html__('Alternative Label Key (JSON)', 'bricksforge'),
            'type'  => 'text',
            'description' => 'The default key is "label". Here, you can enter an alternative key to match the key in your JSON data.',
            'required' => [['dataSourceJson', '!=', ''], ['dataSourceSelect', '=', 'json']],
        ];

        $controls['dataSourceKeyValue'] = [
            'group' => 'options',
            'label' => esc_html__('Alternative Value Key (JSON)', 'bricksforge'),
            'type'  => 'text',
            'description' => 'The default key is "value". Here, you can enter an alternative key to match the key in your JSON data.',
            'required' => [['dataSourceJson', '!=', ''], ['dataSourceSelect', '=', 'json']],
        ];

        // Countries Configuration
        $controls['countriesWithFlags'] = [
            'group' => 'options',
            'label' => esc_html__('Show Flags', 'bricksforge'),
            'type'  => 'checkbox',
            'description' => esc_html__('Display country flags alongside country names. Important: Only works with "Modern Style" enabled. Flags are not loaded in the builder.', 'bricksforge'),
            'required' => [['dataSourceSelect', '=', 'countries']],
        ];

        $controls['countriesWithPhonePrefixes'] = [
            'group' => 'options',
            'label' => esc_html__('Show Phone Prefixes', 'bricksforge'),
            'type'  => 'checkbox',
            'description' => esc_html__('Display country phone prefixes (e.g., +49 for Germany).', 'bricksforge'),
            'required' => [['dataSourceSelect', '=', 'countries']],
        ];

        $controls['countriesLabelFormat'] = [
            'group' => 'options',
            'label' => esc_html__('Label Format', 'bricksforge'),
            'type'  => 'select',
            'options' => [
                'name' => esc_html__('Full Name (Germany)', 'bricksforge'),
                'code' => esc_html__('Country Code (DE)', 'bricksforge'),
                'both' => esc_html__('Both (Germany - DE)', 'bricksforge'),
                'hidden' => esc_html__('Hide Country Name (Flag only)', 'bricksforge'),
            ],
            'default' => 'name',
            'required' => [['dataSourceSelect', '=', 'countries']],
        ];

        $controls['countriesValueFormat'] = [
            'group' => 'options',
            'label' => esc_html__('Value Format', 'bricksforge'),
            'type'  => 'select',
            'options' => [
                'name' => esc_html__('Full Name (Germany)', 'bricksforge'),
                'code' => esc_html__('Country Code (DE)', 'bricksforge'),
            ],
            'default' => 'code',
            'required' => [['dataSourceSelect', '=', 'countries']],
        ];

        $controls['countriesSelection'] = [
            'group' => 'options',
            'label' => esc_html__('Country Selection', 'bricksforge'),
            'type'  => 'select',
            'options' => [
                'all' => esc_html__('All Countries', 'bricksforge'),
                'common' => esc_html__('Common Countries', 'bricksforge'),
                'europe' => esc_html__('European Countries', 'bricksforge'),
                'north_america' => esc_html__('North American Countries', 'bricksforge'),
                'south_america' => esc_html__('South American Countries', 'bricksforge'),
                'asia' => esc_html__('Asian Countries', 'bricksforge'),
                'africa' => esc_html__('African Countries', 'bricksforge'),
                'oceania' => esc_html__('Oceania Countries', 'bricksforge'),
                'include' => esc_html__('Include Specific Countries', 'bricksforge'),
                'exclude' => esc_html__('Exclude Specific Countries', 'bricksforge'),
            ],
            'default' => 'common',
            'required' => [['dataSourceSelect', '=', 'countries']],
        ];

        $controls['countriesInclude'] = [
            'group' => 'options',
            'label' => esc_html__('Include Countries', 'bricksforge'),
            'type'  => 'text',
            'description' => esc_html__('Enter country codes separated by commas (e.g., DE,US,FR,GB).', 'bricksforge'),
            'required' => [['dataSourceSelect', '=', 'countries'], ['countriesSelection', '=', 'include']],
        ];

        $controls['countriesExclude'] = [
            'group' => 'options',
            'label' => esc_html__('Exclude Countries', 'bricksforge'),
            'type'  => 'text',
            'description' => esc_html__('Enter country codes separated by commas (e.g., DE,US,FR,GB).', 'bricksforge'),
            'required' => [['dataSourceSelect', '=', 'countries'], ['countriesSelection', '=', 'exclude']],
        ];

        return $controls;
    }

    static function get_button_style_controls()
    {
        $controls = [];

        // Width
        $controls['width'] = [
            'group' => 'style',
            'label'          => esc_html__('Width', 'bricksforge'),
            'type'           => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'width',
                ],
                [
                    'property' => 'width',
                    'selector' => 'button',
                    'value' => '100%'
                ],
            ],
        ];

        // Height
        $controls['height'] = [
            'group' => 'style',
            'label'          => esc_html__('Height', 'bricksforge'),
            'type'           => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'height',
                    'selector' => 'button'
                ],
            ],
        ];

        // Background
        $controls['background'] = [
            'group' => 'style',
            'label'          => esc_html__('Background', 'bricksforge'),
            'type'           => 'background',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => 'button'
                ],
            ],
        ];

        // Typography
        $controls['typography'] = [
            'group' => 'style',
            'label'          => esc_html__('Typography', 'bricksforge'),
            'type'           => 'typography',
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => 'button'
                ],
            ],
        ];

        // Padding
        $controls['padding'] = [
            'group' => 'style',
            'label'          => esc_html__('Padding', 'bricksforge'),
            'type'           => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => 'button'
                ],
            ],
        ];

        // Border
        $controls['border'] = [
            'group' => 'style',
            'label'          => esc_html__('Border', 'bricksforge'),
            'type'           => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => 'button'
                ],
            ],
        ];

        // Transform
        $controls['transform'] = [
            'group' => 'style',
            'label'          => esc_html__('Transform', 'bricksforge'),
            'type'           => 'transform',
            'css' => [
                [
                    'property' => 'transform',
                    'selector' => 'button'
                ],
            ],
        ];

        return $controls;
    }

    static function get_advanced_controls()
    {
        $controls = [];

        // Custom CSS Class
        $controls['cssClass'] = [
            'group' => 'general',
            'label' => esc_html__('CSS Class', 'bricksforge'),
            'type'  => 'text',
            'inline'         => true,
        ];

        return $controls;
    }

    static function get_nestable_parent_settings($element,  $depth = 0)
    {
        if ($depth > 10) { // Maximum recursion depth
            return false;
        }

        $parent_id = !empty($element['parent']) ? $element['parent'] : false;

        if (bricks_is_builder_call()) {
            // $elements selbst befüllen mit den children
        }

        if (isset($parent_id)) {
            $parent_element = !empty(\Bricks\Frontend::$elements[$parent_id]) ? \Bricks\Frontend::$elements[$parent_id] : false;

            if (!$parent_element) {
                foreach (ElementsHelper::$page_data as $element) {
                    if ($element['id'] == $parent_id) {
                        $parent_element = $element;
                        break;
                    }
                }
            }

            if (!$parent_element && bricks_is_builder_call()) {
                $post_id = get_the_ID();

                $parent_element = \Bricks\Helpers::get_element_data($post_id, $parent_id);

                if (isset($parent_element) && isset($parent_element['element'])) {
                    $parent_element = $parent_element['element'];
                }
            }

            // If there is no parent element, we stop here
            if (!isset($parent_element) || !$parent_element) {
                return false;
            }

            if ($parent_element['name'] === 'brf-pro-forms') {
                return $parent_element['settings'];
            } else {
                // Return the result of the recursive call
                return self::get_nestable_parent_settings($parent_element, $depth + 1);
            }
        }

        return false;
    }

    static function get_parent($name = "brf-pro-forms-field-checkbox-wrapper", $element = [], $depth = 0)
    {
        if ($depth > 10) { // Maximum recursion depth
            return false;
        }

        $parent_id = !empty($element['parent']) ? $element['parent'] : false;

        if (isset($parent_id)) {
            $parent_element = !empty(\Bricks\Frontend::$elements[$parent_id]) ? \Bricks\Frontend::$elements[$parent_id] : false;

            // If there is no parent element, we stop here
            if (!isset($parent_element) || !$parent_element) {
                return false;
            }

            if ($parent_element['name'] === $name) {
                return $parent_element;
            } else {
                // Return the result of the recursive call
                return self::get_nestable_parent_settings($parent_element, $depth + 1);
            }
        }

        return false;
    }

    static function parse_options($settings)
    {
        $options = [];

        $selected_data_source = isset($settings['dataSourceSelect']) ? $settings['dataSourceSelect'] : false;

        $json_options = $selected_data_source == 'json' ? bricks_render_dynamic_data($settings['dataSourceJson']) : false;
        $dynamic_options = $selected_data_source == 'dynamic' ? bricks_render_dynamic_data($settings['dataSourceDynamic']) : false;
        $acf_array_options = $selected_data_source == 'acf_array' ? bricks_render_dynamic_data($settings['dataSourceAcfArray']) : false;

        if ($json_options) {
            $json_options = json_decode($json_options, true);
            $alternative_json_label_key = isset($settings['dataSourceKeyLabel']) ? $settings['dataSourceKeyLabel'] : false;
            $alternative_json_value_key = isset($settings['dataSourceKeyValue']) ? $settings['dataSourceKeyValue'] : false;

            if ($json_options) {

                $label_key = $alternative_json_label_key ? $alternative_json_label_key : 'label';
                $value_key = $alternative_json_value_key ? $alternative_json_value_key : 'value';

                foreach ($json_options as $option) {

                    // If is an array without objects, the value is the same as the label
                    if (!is_array($option)) {
                        $options[] = [
                            'value' => $option,
                            'label' => $option,
                        ];
                    } else {
                        $options[] = [
                            'value' => $option[$value_key],
                            'label' => $option[$label_key],
                        ];
                    }
                }
            }
        }

        // Custom
        if (isset($settings['dataSourceCustom']) && $settings['dataSourceCustom']) {
            foreach ($settings['dataSourceCustom'] as $option) {
                $options[] = [
                    'value' => $option['value'],
                    'label' => $option['label'],
                ];
            }
        }

        // Dynamic
        if ($dynamic_options) {
            // An decoded array of objects with a "value" and a "label" property

            if (is_string($dynamic_options)) {
                $dynamic_options = json_decode($dynamic_options, true);
            }

            if (!is_array($dynamic_options)) {
                return $options;
            }

            foreach ($dynamic_options as $option) {
                $options[] = [
                    'value' => $option['value'],
                    'label' => $option['label'],
                    'active' => $option['active'] ?? false
                ];
            }
        }

        // ACF Array
        if ($acf_array_options) {
            $acf_field_name = $acf_array_options;
            $acf_field_key = false;
            $acf_field_post_id = get_the_ID();
            $acf_field_sync = false;

            if (isset($settings['dataSourceAcfArrayFieldKey']) && $settings['dataSourceAcfArrayFieldKey']) {
                $acf_field_key = bricks_render_dynamic_data($settings['dataSourceAcfArrayFieldKey']);
            }

            if (isset($settings['dataSourceAcfArrayContext']) && $settings['dataSourceAcfArrayContext']) {
                $acf_field_post_id = bricks_render_dynamic_data($settings['dataSourceAcfArrayContext']);
            }

            if (isset($settings['dataSourceSyncFields']) && $settings['dataSourceSyncFields']) {
                $acf_field_sync = true;
            }

            $acf_field = get_field_object($acf_field_name);

            if (!$acf_field) {
                $acf_field = get_field_object($acf_field_key);
            }

            if (!$acf_field) {
                return $options;
            }

            if (!isset($acf_field['choices'])) {
                return $options;
            }

            foreach ($acf_field['choices'] as $value => $label) {
                $active = false;

                if ($acf_field_sync) {
                    $activated_fields = get_field($acf_field_key ? $acf_field_key : $acf_field_name, $acf_field_post_id);

                    // If there are no activated fields, we set the active flag to false
                    if (!isset($activated_fields) || empty($activated_fields)) {
                        $active = false;
                    } else {
                        // Handle both radio (single array) and checkbox (array of arrays) cases
                        if (isset($activated_fields['value'])) {
                            // Radio button case - single associative array
                            $active = ($value === $activated_fields['value']);
                        } else {
                            // Checkbox case - array of arrays
                            $activated_values = array_column($activated_fields, 'value');
                            $active = in_array($value, $activated_values);
                        }
                    }
                }

                $options[] = [
                    'value' => $value,
                    'label' => $label,
                    'active' => $active
                ];
            }
        }

        // Countries
        if ($selected_data_source == 'countries') {
            $countries_data = self::get_countries_data();
            $countries_selection = isset($settings['countriesSelection']) ? $settings['countriesSelection'] : 'all';
            $countries_include = isset($settings['countriesInclude']) ? $settings['countriesInclude'] : '';
            $countries_exclude = isset($settings['countriesExclude']) ? $settings['countriesExclude'] : '';
            $countries_with_flags = isset($settings['countriesWithFlags']) ? $settings['countriesWithFlags'] : false;
            $countries_with_phone_prefixes = isset($settings['countriesWithPhonePrefixes']) ? $settings['countriesWithPhonePrefixes'] : false;
            $countries_label_format = isset($settings['countriesLabelFormat']) ? $settings['countriesLabelFormat'] : 'name';
            $countries_value_format = isset($settings['countriesValueFormat']) ? $settings['countriesValueFormat'] : 'code';



            // Filter countries based on selection
            if ($countries_selection == 'common') {
                $common_countries = self::get_common_countries();
                $countries_data = array_filter($countries_data, function ($country) use ($common_countries) {
                    return in_array($country['code'], $common_countries);
                });
            } elseif ($countries_selection == 'europe') {
                $european_countries = self::get_european_countries();
                $countries_data = array_filter($countries_data, function ($country) use ($european_countries) {
                    return in_array($country['code'], $european_countries);
                });
            } elseif ($countries_selection == 'north_america') {
                $north_american_countries = self::get_north_american_countries();
                $countries_data = array_filter($countries_data, function ($country) use ($north_american_countries) {
                    return in_array($country['code'], $north_american_countries);
                });
            } elseif ($countries_selection == 'south_america') {
                $south_american_countries = self::get_south_american_countries();
                $countries_data = array_filter($countries_data, function ($country) use ($south_american_countries) {
                    return in_array($country['code'], $south_american_countries);
                });
            } elseif ($countries_selection == 'asia') {
                $asian_countries = self::get_asian_countries();
                $countries_data = array_filter($countries_data, function ($country) use ($asian_countries) {
                    return in_array($country['code'], $asian_countries);
                });
            } elseif ($countries_selection == 'africa') {
                $african_countries = self::get_african_countries();
                $countries_data = array_filter($countries_data, function ($country) use ($african_countries) {
                    return in_array($country['code'], $african_countries);
                });
            } elseif ($countries_selection == 'oceania') {
                $oceania_countries = self::get_oceania_countries();
                $countries_data = array_filter($countries_data, function ($country) use ($oceania_countries) {
                    return in_array($country['code'], $oceania_countries);
                });
            } elseif ($countries_selection == 'eu') {
                $eu_countries = self::get_eu_countries();
                $countries_data = array_filter($countries_data, function ($country) use ($eu_countries) {
                    return in_array($country['code'], $eu_countries);
                });
            } elseif ($countries_selection == 'dach') {
                $dach_countries = self::get_dach_countries();
                $countries_data = array_filter($countries_data, function ($country) use ($dach_countries) {
                    return in_array($country['code'], $dach_countries);
                });
            } elseif ($countries_selection == 'g7') {
                $g7_countries = self::get_g7_countries();
                $countries_data = array_filter($countries_data, function ($country) use ($g7_countries) {
                    return in_array($country['code'], $g7_countries);
                });
            } elseif ($countries_selection == 'g20') {
                $g20_countries = self::get_g20_countries();
                $countries_data = array_filter($countries_data, function ($country) use ($g20_countries) {
                    return in_array($country['code'], $g20_countries);
                });
            } elseif ($countries_selection == 'include' && !empty($countries_include)) {
                $include_codes = array_map('trim', explode(',', strtoupper($countries_include)));
                $countries_data = array_filter($countries_data, function ($country) use ($include_codes) {
                    return in_array($country['code'], $include_codes);
                });
            } elseif ($countries_selection == 'exclude' && !empty($countries_exclude)) {
                $exclude_codes = array_map('trim', explode(',', strtoupper($countries_exclude)));
                $countries_data = array_filter($countries_data, function ($country) use ($exclude_codes) {
                    return !in_array($country['code'], $exclude_codes);
                });
            }

            foreach ($countries_data as $country) {
                // Format label
                $label = '';
                switch ($countries_label_format) {
                    case 'code':
                        $label = $country['code'];
                        break;
                    case 'both':
                        $label = $country['name'] . ' - ' . $country['code'];
                        break;
                    case 'hidden':
                        // For hidden labels, only show fallback if no flags are enabled
                        $label = $countries_with_flags ? '' : $country['code'];
                        break;
                    case 'name':
                    default:
                        $label = $country['name'];
                        break;
                }

                // Add phone prefix to label if enabled (but not for hidden labels)
                if ($countries_with_phone_prefixes && isset($country['phone_prefix']) && $countries_label_format !== 'hidden') {
                    $label = $country['phone_prefix'] . ' ' . $label;
                }

                // Format value
                $value = ($countries_value_format == 'name') ? $country['name'] : $country['code'];

                $option = [
                    'value' => $value,
                    'label' => $label,
                ];

                // Add flag data if enabled
                if ($countries_with_flags) {
                    $option['flag'] = strtolower($country['code']);
                    $option['flag_svg'] = self::get_country_flag_svg($country['code']);
                }

                // Add phone prefix data if enabled
                if ($countries_with_phone_prefixes && isset($country['phone_prefix'])) {
                    $option['phone_prefix'] = $country['phone_prefix'];
                }

                $options[] = $option;
            }
        }

        return $options;
    }

    static function get_country_flag_svg($country_code)
    {
        $svg_path = BRICKSFORGE_ASSETS . '/svg/flags/' . strtolower($country_code) . '.svg';
        $file_path = BRICKSFORGE_PATH . '/assets/svg/flags/' . strtolower($country_code) . '.svg';

        // Check if SVG file exists
        if (file_exists($file_path)) {
            // Return inline SVG with proper styling for Choices.js
            return '<img src="' . esc_url($svg_path) . '" alt="' . esc_attr($country_code) . ' flag" style="width: 20px; height: 15px; margin-right: 8px; display: inline-block; vertical-align: middle;" />';
        }

        // Fallback if SVG doesn't exist
        return '';
    }

    static function get_common_countries()
    {
        return [
            'US',
            'GB',
            'CA',
            'AU',
            'DE',
            'FR',
            'IT',
            'ES',
            'NL',
            'BE',
            'CH',
            'AT',
            'SE',
            'NO',
            'DK',
            'FI',
            'IE',
            'PT',
            'PL',
            'CZ',
            'JP',
            'CN',
            'IN',
            'BR',
            'MX',
            'RU',
            'KR',
            'SG',
            'HK',
            'TW'
        ];
    }

    static function get_european_countries()
    {
        return [
            'AD',
            'AL',
            'AT',
            'BA',
            'BE',
            'BG',
            'BY',
            'CH',
            'CY',
            'CZ',
            'DE',
            'DK',
            'EE',
            'ES',
            'FI',
            'FR',
            'GB',
            'GE',
            'GR',
            'HR',
            'HU',
            'IE',
            'IS',
            'IT',
            'LI',
            'LT',
            'LU',
            'LV',
            'MC',
            'MD',
            'ME',
            'MK',
            'MT',
            'NL',
            'NO',
            'PL',
            'PT',
            'RO',
            'RS',
            'RU',
            'SE',
            'SI',
            'SK',
            'SM',
            'UA',
            'VA'
        ];
    }

    static function get_north_american_countries()
    {
        return [
            'US',
            'CA',
            'MX',
            'GT',
            'BZ',
            'SV',
            'HN',
            'NI',
            'CR',
            'PA'
        ];
    }

    static function get_south_american_countries()
    {
        return [
            'AR',
            'BO',
            'BR',
            'CL',
            'CO',
            'EC',
            'FK',
            'GF',
            'GY',
            'PE',
            'PY',
            'SR',
            'UY',
            'VE'
        ];
    }

    static function get_asian_countries()
    {
        return [
            'AF',
            'AM',
            'AZ',
            'BH',
            'BD',
            'BT',
            'BN',
            'KH',
            'CN',
            'CY',
            'GE',
            'IN',
            'ID',
            'IR',
            'IQ',
            'IL',
            'JP',
            'JO',
            'KZ',
            'KW',
            'KG',
            'LA',
            'LB',
            'MY',
            'MV',
            'MN',
            'MM',
            'NP',
            'KP',
            'OM',
            'PK',
            'PH',
            'QA',
            'SA',
            'SG',
            'KR',
            'LK',
            'SY',
            'TW',
            'TJ',
            'TH',
            'TL',
            'TR',
            'TM',
            'AE',
            'UZ',
            'VN',
            'YE'
        ];
    }

    static function get_african_countries()
    {
        return [
            'DZ',
            'AO',
            'BJ',
            'BW',
            'BF',
            'BI',
            'CM',
            'CV',
            'CF',
            'TD',
            'KM',
            'CG',
            'CD',
            'CI',
            'DJ',
            'EG',
            'GQ',
            'ER',
            'ET',
            'GA',
            'GM',
            'GH',
            'GN',
            'GW',
            'KE',
            'LS',
            'LR',
            'LY',
            'MG',
            'MW',
            'ML',
            'MR',
            'MU',
            'MA',
            'MZ',
            'NA',
            'NE',
            'NG',
            'RW',
            'ST',
            'SN',
            'SC',
            'SL',
            'SO',
            'ZA',
            'SS',
            'SD',
            'SZ',
            'TZ',
            'TG',
            'TN',
            'UG',
            'ZM',
            'ZW'
        ];
    }

    static function get_oceania_countries()
    {
        return [
            'AU',
            'FJ',
            'KI',
            'MH',
            'FM',
            'NR',
            'NZ',
            'PW',
            'PG',
            'WS',
            'SB',
            'TO',
            'TV',
            'VU'
        ];
    }

    static function get_eu_countries()
    {
        return [
            'AT',
            'BE',
            'BG',
            'HR',
            'CY',
            'CZ',
            'DK',
            'EE',
            'FI',
            'FR',
            'DE',
            'GR',
            'HU',
            'IE',
            'IT',
            'LV',
            'LT',
            'LU',
            'MT',
            'NL',
            'PL',
            'PT',
            'RO',
            'SK',
            'SI',
            'ES',
            'SE'
        ];
    }

    static function get_dach_countries()
    {
        return [
            'DE',
            'AT',
            'CH'
        ];
    }

    static function get_g7_countries()
    {
        return [
            'CA',
            'FR',
            'DE',
            'IT',
            'JP',
            'GB',
            'US'
        ];
    }

    static function get_g20_countries()
    {
        return [
            'AR',
            'AU',
            'BR',
            'CA',
            'CN',
            'FR',
            'DE',
            'IN',
            'ID',
            'IT',
            'JP',
            'KR',
            'MX',
            'RU',
            'SA',
            'ZA',
            'TR',
            'GB',
            'US'
        ];
    }

    static function get_countries_data()
    {
        $countries = [
            ['code' => 'AD', 'name' => 'Andorra', 'phone_prefix' => '+376'],
            ['code' => 'AE', 'name' => 'United Arab Emirates', 'phone_prefix' => '+971'],
            ['code' => 'AF', 'name' => 'Afghanistan', 'phone_prefix' => '+93'],
            ['code' => 'AG', 'name' => 'Antigua and Barbuda', 'phone_prefix' => '+1'],
            ['code' => 'AI', 'name' => 'Anguilla', 'phone_prefix' => '+1'],
            ['code' => 'AL', 'name' => 'Albania', 'phone_prefix' => '+355'],
            ['code' => 'AM', 'name' => 'Armenia', 'phone_prefix' => '+374'],
            ['code' => 'AO', 'name' => 'Angola', 'phone_prefix' => '+244'],
            ['code' => 'AQ', 'name' => 'Antarctica', 'phone_prefix' => '+672'],
            ['code' => 'AR', 'name' => 'Argentina', 'phone_prefix' => '+54'],
            ['code' => 'AS', 'name' => 'American Samoa', 'phone_prefix' => '+1'],
            ['code' => 'AT', 'name' => 'Austria', 'phone_prefix' => '+43'],
            ['code' => 'AU', 'name' => 'Australia', 'phone_prefix' => '+61'],
            ['code' => 'AW', 'name' => 'Aruba', 'phone_prefix' => '+297'],
            ['code' => 'AX', 'name' => 'Åland Islands', 'phone_prefix' => '+358'],
            ['code' => 'AZ', 'name' => 'Azerbaijan', 'phone_prefix' => '+994'],
            ['code' => 'BA', 'name' => 'Bosnia and Herzegovina', 'phone_prefix' => '+387'],
            ['code' => 'BB', 'name' => 'Barbados', 'phone_prefix' => '+1'],
            ['code' => 'BD', 'name' => 'Bangladesh', 'phone_prefix' => '+880'],
            ['code' => 'BE', 'name' => 'Belgium', 'phone_prefix' => '+32'],
            ['code' => 'BF', 'name' => 'Burkina Faso', 'phone_prefix' => '+226'],
            ['code' => 'BG', 'name' => 'Bulgaria', 'phone_prefix' => '+359'],
            ['code' => 'BH', 'name' => 'Bahrain', 'phone_prefix' => '+973'],
            ['code' => 'BI', 'name' => 'Burundi', 'phone_prefix' => '+257'],
            ['code' => 'BJ', 'name' => 'Benin', 'phone_prefix' => '+229'],
            ['code' => 'BL', 'name' => 'Saint Barthélemy', 'phone_prefix' => '+590'],
            ['code' => 'BM', 'name' => 'Bermuda', 'phone_prefix' => '+1'],
            ['code' => 'BN', 'name' => 'Brunei', 'phone_prefix' => '+673'],
            ['code' => 'BO', 'name' => 'Bolivia', 'phone_prefix' => '+591'],
            ['code' => 'BQ', 'name' => 'Caribbean Netherlands', 'phone_prefix' => '+599'],
            ['code' => 'BR', 'name' => 'Brazil', 'phone_prefix' => '+55'],
            ['code' => 'BS', 'name' => 'Bahamas', 'phone_prefix' => '+1'],
            ['code' => 'BT', 'name' => 'Bhutan', 'phone_prefix' => '+975'],
            ['code' => 'BV', 'name' => 'Bouvet Island', 'phone_prefix' => '—'],
            ['code' => 'BW', 'name' => 'Botswana', 'phone_prefix' => '+267'],
            ['code' => 'BY', 'name' => 'Belarus', 'phone_prefix' => '+375'],
            ['code' => 'BZ', 'name' => 'Belize', 'phone_prefix' => '+501'],
            ['code' => 'CA', 'name' => 'Canada', 'phone_prefix' => '+1'],
            ['code' => 'CC', 'name' => 'Cocos Islands', 'phone_prefix' => '+61'],
            ['code' => 'CD', 'name' => 'Democratic Republic of the Congo', 'phone_prefix' => '+243'],
            ['code' => 'CF', 'name' => 'Central African Republic', 'phone_prefix' => '+236'],
            ['code' => 'CG', 'name' => 'Republic of the Congo', 'phone_prefix' => '+242'],
            ['code' => 'CH', 'name' => 'Switzerland', 'phone_prefix' => '+41'],
            ['code' => 'CI', 'name' => 'Côte d\'Ivoire', 'phone_prefix' => '+225'],
            ['code' => 'CK', 'name' => 'Cook Islands', 'phone_prefix' => '+682'],
            ['code' => 'CL', 'name' => 'Chile', 'phone_prefix' => '+56'],
            ['code' => 'CM', 'name' => 'Cameroon', 'phone_prefix' => '+237'],
            ['code' => 'CN', 'name' => 'China', 'phone_prefix' => '+86'],
            ['code' => 'CO', 'name' => 'Colombia', 'phone_prefix' => '+57'],
            ['code' => 'CR', 'name' => 'Costa Rica', 'phone_prefix' => '+506'],
            ['code' => 'CU', 'name' => 'Cuba', 'phone_prefix' => '+53'],
            ['code' => 'CV', 'name' => 'Cape Verde', 'phone_prefix' => '+238'],
            ['code' => 'CW', 'name' => 'Curaçao', 'phone_prefix' => '+599'],
            ['code' => 'CX', 'name' => 'Christmas Island', 'phone_prefix' => '+61'],
            ['code' => 'CY', 'name' => 'Cyprus', 'phone_prefix' => '+357'],
            ['code' => 'CZ', 'name' => 'Czech Republic', 'phone_prefix' => '+420'],
            ['code' => 'DE', 'name' => 'Germany', 'phone_prefix' => '+49'],
            ['code' => 'DJ', 'name' => 'Djibouti', 'phone_prefix' => '+253'],
            ['code' => 'DK', 'name' => 'Denmark', 'phone_prefix' => '+45'],
            ['code' => 'DM', 'name' => 'Dominica', 'phone_prefix' => '+1'],
            ['code' => 'DO', 'name' => 'Dominican Republic', 'phone_prefix' => '+1'],
            ['code' => 'DZ', 'name' => 'Algeria', 'phone_prefix' => '+213'],
            ['code' => 'EC', 'name' => 'Ecuador', 'phone_prefix' => '+593'],
            ['code' => 'EE', 'name' => 'Estonia', 'phone_prefix' => '+372'],
            ['code' => 'EG', 'name' => 'Egypt', 'phone_prefix' => '+20'],
            ['code' => 'EH', 'name' => 'Western Sahara', 'phone_prefix' => '+212'],
            ['code' => 'ER', 'name' => 'Eritrea', 'phone_prefix' => '+291'],
            ['code' => 'ES', 'name' => 'Spain', 'phone_prefix' => '+34'],
            ['code' => 'ET', 'name' => 'Ethiopia', 'phone_prefix' => '+251'],
            ['code' => 'FI', 'name' => 'Finland', 'phone_prefix' => '+358'],
            ['code' => 'FJ', 'name' => 'Fiji', 'phone_prefix' => '+679'],
            ['code' => 'FK', 'name' => 'Falkland Islands', 'phone_prefix' => '+500'],
            ['code' => 'FM', 'name' => 'Micronesia', 'phone_prefix' => '+691'],
            ['code' => 'FO', 'name' => 'Faroe Islands', 'phone_prefix' => '+298'],
            ['code' => 'FR', 'name' => 'France', 'phone_prefix' => '+33'],
            ['code' => 'GA', 'name' => 'Gabon', 'phone_prefix' => '+241'],
            ['code' => 'GB', 'name' => 'United Kingdom', 'phone_prefix' => '+44'],
            ['code' => 'GD', 'name' => 'Grenada', 'phone_prefix' => '+1'],
            ['code' => 'GE', 'name' => 'Georgia', 'phone_prefix' => '+995'],
            ['code' => 'GF', 'name' => 'French Guiana', 'phone_prefix' => '+594'],
            ['code' => 'GG', 'name' => 'Guernsey', 'phone_prefix' => '+44'],
            ['code' => 'GH', 'name' => 'Ghana', 'phone_prefix' => '+233'],
            ['code' => 'GI', 'name' => 'Gibraltar', 'phone_prefix' => '+350'],
            ['code' => 'GL', 'name' => 'Greenland', 'phone_prefix' => '+299'],
            ['code' => 'GM', 'name' => 'Gambia', 'phone_prefix' => '+220'],
            ['code' => 'GN', 'name' => 'Guinea', 'phone_prefix' => '+224'],
            ['code' => 'GP', 'name' => 'Guadeloupe', 'phone_prefix' => '+590'],
            ['code' => 'GQ', 'name' => 'Equatorial Guinea', 'phone_prefix' => '+240'],
            ['code' => 'GR', 'name' => 'Greece', 'phone_prefix' => '+30'],
            ['code' => 'GS', 'name' => 'South Georgia and the South Sandwich Islands', 'phone_prefix' => '—'],
            ['code' => 'GT', 'name' => 'Guatemala', 'phone_prefix' => '+502'],
            ['code' => 'GU', 'name' => 'Guam', 'phone_prefix' => '+1'],
            ['code' => 'GW', 'name' => 'Guinea-Bissau', 'phone_prefix' => '+245'],
            ['code' => 'GY', 'name' => 'Guyana', 'phone_prefix' => '+592'],
            ['code' => 'HK', 'name' => 'Hong Kong', 'phone_prefix' => '+852'],
            ['code' => 'HM', 'name' => 'Heard Island and McDonald Islands', 'phone_prefix' => '—'],
            ['code' => 'HN', 'name' => 'Honduras', 'phone_prefix' => '+504'],
            ['code' => 'HR', 'name' => 'Croatia', 'phone_prefix' => '+385'],
            ['code' => 'HT', 'name' => 'Haiti', 'phone_prefix' => '+509'],
            ['code' => 'HU', 'name' => 'Hungary', 'phone_prefix' => '+36'],
            ['code' => 'ID', 'name' => 'Indonesia', 'phone_prefix' => '+62'],
            ['code' => 'IE', 'name' => 'Ireland', 'phone_prefix' => '+353'],
            ['code' => 'IL', 'name' => 'Israel', 'phone_prefix' => '+972'],
            ['code' => 'IM', 'name' => 'Isle of Man', 'phone_prefix' => '+44'],
            ['code' => 'IN', 'name' => 'India', 'phone_prefix' => '+91'],
            ['code' => 'IO', 'name' => 'British Indian Ocean Territory', 'phone_prefix' => '+246'],
            ['code' => 'IQ', 'name' => 'Iraq', 'phone_prefix' => '+964'],
            ['code' => 'IR', 'name' => 'Iran', 'phone_prefix' => '+98'],
            ['code' => 'IS', 'name' => 'Iceland', 'phone_prefix' => '+354'],
            ['code' => 'IT', 'name' => 'Italy', 'phone_prefix' => '+39'],
            ['code' => 'JE', 'name' => 'Jersey', 'phone_prefix' => '+44'],
            ['code' => 'JM', 'name' => 'Jamaica', 'phone_prefix' => '+1'],
            ['code' => 'JO', 'name' => 'Jordan', 'phone_prefix' => '+962'],
            ['code' => 'JP', 'name' => 'Japan', 'phone_prefix' => '+81'],
            ['code' => 'KE', 'name' => 'Kenya', 'phone_prefix' => '+254'],
            ['code' => 'KG', 'name' => 'Kyrgyzstan', 'phone_prefix' => '+996'],
            ['code' => 'KH', 'name' => 'Cambodia', 'phone_prefix' => '+855'],
            ['code' => 'KI', 'name' => 'Kiribati', 'phone_prefix' => '+686'],
            ['code' => 'KM', 'name' => 'Comoros', 'phone_prefix' => '+269'],
            ['code' => 'KN', 'name' => 'Saint Kitts and Nevis', 'phone_prefix' => '+1'],
            ['code' => 'KP', 'name' => 'North Korea', 'phone_prefix' => '+850'],
            ['code' => 'KR', 'name' => 'South Korea', 'phone_prefix' => '+82'],
            ['code' => 'KW', 'name' => 'Kuwait', 'phone_prefix' => '+965'],
            ['code' => 'KY', 'name' => 'Cayman Islands', 'phone_prefix' => '+1'],
            ['code' => 'KZ', 'name' => 'Kazakhstan', 'phone_prefix' => '+7'],
            ['code' => 'LA', 'name' => 'Laos', 'phone_prefix' => '+856'],
            ['code' => 'LB', 'name' => 'Lebanon', 'phone_prefix' => '+961'],
            ['code' => 'LC', 'name' => 'Saint Lucia', 'phone_prefix' => '+1'],
            ['code' => 'LI', 'name' => 'Liechtenstein', 'phone_prefix' => '+423'],
            ['code' => 'LK', 'name' => 'Sri Lanka', 'phone_prefix' => '+94'],
            ['code' => 'LR', 'name' => 'Liberia', 'phone_prefix' => '+231'],
            ['code' => 'LS', 'name' => 'Lesotho', 'phone_prefix' => '+266'],
            ['code' => 'LT', 'name' => 'Lithuania', 'phone_prefix' => '+370'],
            ['code' => 'LU', 'name' => 'Luxembourg', 'phone_prefix' => '+352'],
            ['code' => 'LV', 'name' => 'Latvia', 'phone_prefix' => '+371'],
            ['code' => 'LY', 'name' => 'Libya', 'phone_prefix' => '+218'],
            ['code' => 'MA', 'name' => 'Morocco', 'phone_prefix' => '+212'],
            ['code' => 'MC', 'name' => 'Monaco', 'phone_prefix' => '+377'],
            ['code' => 'MD', 'name' => 'Moldova', 'phone_prefix' => '+373'],
            ['code' => 'ME', 'name' => 'Montenegro', 'phone_prefix' => '+382'],
            ['code' => 'MF', 'name' => 'Saint Martin', 'phone_prefix' => '+590'],
            ['code' => 'MG', 'name' => 'Madagascar', 'phone_prefix' => '+261'],
            ['code' => 'MH', 'name' => 'Marshall Islands', 'phone_prefix' => '+692'],
            ['code' => 'MK', 'name' => 'North Macedonia', 'phone_prefix' => '+389'],
            ['code' => 'ML', 'name' => 'Mali', 'phone_prefix' => '+223'],
            ['code' => 'MM', 'name' => 'Myanmar', 'phone_prefix' => '+95'],
            ['code' => 'MN', 'name' => 'Mongolia', 'phone_prefix' => '+976'],
            ['code' => 'MO', 'name' => 'Macao', 'phone_prefix' => '+853'],
            ['code' => 'MP', 'name' => 'Northern Mariana Islands', 'phone_prefix' => '+1'],
            ['code' => 'MQ', 'name' => 'Martinique', 'phone_prefix' => '+596'],
            ['code' => 'MR', 'name' => 'Mauritania', 'phone_prefix' => '+222'],
            ['code' => 'MS', 'name' => 'Montserrat', 'phone_prefix' => '+1'],
            ['code' => 'MT', 'name' => 'Malta', 'phone_prefix' => '+356'],
            ['code' => 'MU', 'name' => 'Mauritius', 'phone_prefix' => '+230'],
            ['code' => 'MV', 'name' => 'Maldives', 'phone_prefix' => '+960'],
            ['code' => 'MW', 'name' => 'Malawi', 'phone_prefix' => '+265'],
            ['code' => 'MX', 'name' => 'Mexico', 'phone_prefix' => '+52'],
            ['code' => 'MY', 'name' => 'Malaysia', 'phone_prefix' => '+60'],
            ['code' => 'MZ', 'name' => 'Mozambique', 'phone_prefix' => '+258'],
            ['code' => 'NA', 'name' => 'Namibia', 'phone_prefix' => '+264'],
            ['code' => 'NC', 'name' => 'New Caledonia', 'phone_prefix' => '+687'],
            ['code' => 'NE', 'name' => 'Niger', 'phone_prefix' => '+227'],
            ['code' => 'NF', 'name' => 'Norfolk Island', 'phone_prefix' => '+672'],
            ['code' => 'NG', 'name' => 'Nigeria', 'phone_prefix' => '+234'],
            ['code' => 'NI', 'name' => 'Nicaragua', 'phone_prefix' => '+505'],
            ['code' => 'NL', 'name' => 'Netherlands', 'phone_prefix' => '+31'],
            ['code' => 'NO', 'name' => 'Norway', 'phone_prefix' => '+47'],
            ['code' => 'NP', 'name' => 'Nepal', 'phone_prefix' => '+977'],
            ['code' => 'NR', 'name' => 'Nauru', 'phone_prefix' => '+674'],
            ['code' => 'NU', 'name' => 'Niue', 'phone_prefix' => '+683'],
            ['code' => 'NZ', 'name' => 'New Zealand', 'phone_prefix' => '+64'],
            ['code' => 'OM', 'name' => 'Oman', 'phone_prefix' => '+968'],
            ['code' => 'PA', 'name' => 'Panama', 'phone_prefix' => '+507'],
            ['code' => 'PE', 'name' => 'Peru', 'phone_prefix' => '+51'],
            ['code' => 'PF', 'name' => 'French Polynesia', 'phone_prefix' => '+689'],
            ['code' => 'PG', 'name' => 'Papua New Guinea', 'phone_prefix' => '+675'],
            ['code' => 'PH', 'name' => 'Philippines', 'phone_prefix' => '+63'],
            ['code' => 'PK', 'name' => 'Pakistan', 'phone_prefix' => '+92'],
            ['code' => 'PL', 'name' => 'Poland', 'phone_prefix' => '+48'],
            ['code' => 'PM', 'name' => 'Saint Pierre and Miquelon', 'phone_prefix' => '+508'],
            ['code' => 'PN', 'name' => 'Pitcairn', 'phone_prefix' => '+64'],
            ['code' => 'PR', 'name' => 'Puerto Rico', 'phone_prefix' => '+1'],
            ['code' => 'PS', 'name' => 'Palestine', 'phone_prefix' => '+970'],
            ['code' => 'PT', 'name' => 'Portugal', 'phone_prefix' => '+351'],
            ['code' => 'PW', 'name' => 'Palau', 'phone_prefix' => '+680'],
            ['code' => 'PY', 'name' => 'Paraguay', 'phone_prefix' => '+595'],
            ['code' => 'QA', 'name' => 'Qatar', 'phone_prefix' => '+974'],
            ['code' => 'RE', 'name' => 'Réunion', 'phone_prefix' => '+262'],
            ['code' => 'RO', 'name' => 'Romania', 'phone_prefix' => '+40'],
            ['code' => 'RS', 'name' => 'Serbia', 'phone_prefix' => '+381'],
            ['code' => 'RU', 'name' => 'Russia', 'phone_prefix' => '+7'],
            ['code' => 'RW', 'name' => 'Rwanda', 'phone_prefix' => '+250'],
            ['code' => 'SA', 'name' => 'Saudi Arabia', 'phone_prefix' => '+966'],
            ['code' => 'SB', 'name' => 'Solomon Islands', 'phone_prefix' => '+677'],
            ['code' => 'SC', 'name' => 'Seychelles', 'phone_prefix' => '+248'],
            ['code' => 'SD', 'name' => 'Sudan', 'phone_prefix' => '+249'],
            ['code' => 'SE', 'name' => 'Sweden', 'phone_prefix' => '+46'],
            ['code' => 'SG', 'name' => 'Singapore', 'phone_prefix' => '+65'],
            ['code' => 'SH', 'name' => 'Saint Helena, Ascension and Tristan da Cunha', 'phone_prefix' => '+290'],
            ['code' => 'SI', 'name' => 'Slovenia', 'phone_prefix' => '+386'],
            ['code' => 'SJ', 'name' => 'Svalbard and Jan Mayen', 'phone_prefix' => '+47'],
            ['code' => 'SK', 'name' => 'Slovakia', 'phone_prefix' => '+421'],
            ['code' => 'SL', 'name' => 'Sierra Leone', 'phone_prefix' => '+232'],
            ['code' => 'SM', 'name' => 'San Marino', 'phone_prefix' => '+378'],
            ['code' => 'SN', 'name' => 'Senegal', 'phone_prefix' => '+221'],
            ['code' => 'SO', 'name' => 'Somalia', 'phone_prefix' => '+252'],
            ['code' => 'SR', 'name' => 'Suriname', 'phone_prefix' => '+597'],
            ['code' => 'SS', 'name' => 'South Sudan', 'phone_prefix' => '+211'],
            ['code' => 'ST', 'name' => 'São Tomé and Príncipe', 'phone_prefix' => '+239'],
            ['code' => 'SV', 'name' => 'El Salvador', 'phone_prefix' => '+503'],
            ['code' => 'SX', 'name' => 'Sint Maarten', 'phone_prefix' => '+1'],
            ['code' => 'SY', 'name' => 'Syria', 'phone_prefix' => '+963'],
            ['code' => 'SZ', 'name' => 'Eswatini', 'phone_prefix' => '+268'],
            ['code' => 'TC', 'name' => 'Turks and Caicos Islands', 'phone_prefix' => '+1'],
            ['code' => 'TD', 'name' => 'Chad', 'phone_prefix' => '+235'],
            ['code' => 'TF', 'name' => 'French Southern Territories', 'phone_prefix' => '—'],
            ['code' => 'TG', 'name' => 'Togo', 'phone_prefix' => '+228'],
            ['code' => 'TH', 'name' => 'Thailand', 'phone_prefix' => '+66'],
            ['code' => 'TJ', 'name' => 'Tajikistan', 'phone_prefix' => '+992'],
            ['code' => 'TK', 'name' => 'Tokelau', 'phone_prefix' => '+690'],
            ['code' => 'TL', 'name' => 'Timor-Leste', 'phone_prefix' => '+670'],
            ['code' => 'TM', 'name' => 'Turkmenistan', 'phone_prefix' => '+993'],
            ['code' => 'TN', 'name' => 'Tunisia', 'phone_prefix' => '+216'],
            ['code' => 'TO', 'name' => 'Tonga', 'phone_prefix' => '+676'],
            ['code' => 'TR', 'name' => 'Turkey', 'phone_prefix' => '+90'],
            ['code' => 'TT', 'name' => 'Trinidad and Tobago', 'phone_prefix' => '+1'],
            ['code' => 'TV', 'name' => 'Tuvalu', 'phone_prefix' => '+688'],
            ['code' => 'TW', 'name' => 'Taiwan', 'phone_prefix' => '+886'],
            ['code' => 'TZ', 'name' => 'Tanzania', 'phone_prefix' => '+255'],
            ['code' => 'UA', 'name' => 'Ukraine', 'phone_prefix' => '+380'],
            ['code' => 'UG', 'name' => 'Uganda', 'phone_prefix' => '+256'],
            ['code' => 'UM', 'name' => 'United States Minor Outlying Islands', 'phone_prefix' => '+1'],
            ['code' => 'US', 'name' => 'United States', 'phone_prefix' => '+1'],
            ['code' => 'UY', 'name' => 'Uruguay', 'phone_prefix' => '+598'],
            ['code' => 'UZ', 'name' => 'Uzbekistan', 'phone_prefix' => '+998'],
            ['code' => 'VA', 'name' => 'Vatican City', 'phone_prefix' => '+39'],
            ['code' => 'VC', 'name' => 'Saint Vincent and the Grenadines', 'phone_prefix' => '+1'],
            ['code' => 'VE', 'name' => 'Venezuela', 'phone_prefix' => '+58'],
            ['code' => 'VG', 'name' => 'British Virgin Islands', 'phone_prefix' => '+1'],
            ['code' => 'VI', 'name' => 'U.S. Virgin Islands', 'phone_prefix' => '+1'],
            ['code' => 'VN', 'name' => 'Vietnam', 'phone_prefix' => '+84'],
            ['code' => 'VU', 'name' => 'Vanuatu', 'phone_prefix' => '+678'],
            ['code' => 'WF', 'name' => 'Wallis and Futuna', 'phone_prefix' => '+681'],
            ['code' => 'WS', 'name' => 'Samoa', 'phone_prefix' => '+685'],
            ['code' => 'YE', 'name' => 'Yemen', 'phone_prefix' => '+967'],
            ['code' => 'YT', 'name' => 'Mayotte', 'phone_prefix' => '+262'],
            ['code' => 'ZA', 'name' => 'South Africa', 'phone_prefix' => '+27'],
            ['code' => 'ZM', 'name' => 'Zambia', 'phone_prefix' => '+260'],
            ['code' => 'ZW', 'name' => 'Zimbabwe', 'phone_prefix' => '+263'],
        ];

        /**
         * Filter to allow modification of countries data
         * 
         * @param array $countries Array of countries with 'code', 'name', and 'phone_prefix'
         * 
         * @example
         * // Translate country names to German
         * add_filter('bricksforge/pro_forms/countries_data', function($countries) {
         *     $translations = [
         *         'Germany' => 'Deutschland',
         *         'United States' => 'Vereinigte Staaten',
         *         'France' => 'Frankreich',
         *         'Spain' => 'Spanien',
         *         'Italy' => 'Italien',
         *     ];
         *     
         *     foreach ($countries as &$country) {
         *         if (isset($translations[$country['name']])) {
         *             $country['name'] = $translations[$country['name']];
         *         }
         *     }
         *     
         *     return $countries;
         * });
         */
        return apply_filters('bricksforge/pro_forms/countries_data', $countries);
    }

    static function get_quill_formats()
    {
        return [
            'header' => 'Headlines',
            'bold'           => 'Bold',
            'italic'         => 'Italic',
            'underline'      => 'Underline',
            'color' => 'Color',
            'background'       => 'Background Color',
            'strike'         => 'Strikethrough',
            'link' => 'Link',
            'code' => 'Code',

            'blockquote'     => 'Blockquote',
            'indent' => 'Indent',
            'outdent' => 'Outdent',
            'orderedList' => 'Ordered List',
            'bulletList' => 'Bullet List',
            'align' => 'Text Alignment',
            'direction' => 'Text Direction',
            'code-block' => 'Code Block',

            'image' => 'Image',
            'video' => 'Video'
        ];
    }

    /**
     * Get default color palette with Bricks version compatibility
     * In newer Bricks versions, the method moved from Builder to Database class
     *
     * @return array
     */
    static function get_default_color_palette()
    {
        // New location (Bricks RC / 2.0+)
        if (method_exists('\Bricks\Database', 'default_color_palette')) {
            return \Bricks\Database::default_color_palette();
        }

        // Old location (Bricks 1.x)
        if (method_exists('\Bricks\Builder', 'default_color_palette')) {
            return \Bricks\Builder::default_color_palette();
        }

        return [];
    }

    static function get_color_palettes()
    {

        $palettes = get_option(BRICKS_DB_COLOR_PALETTE, []);

        if (empty($palettes)) {
            $palettes = self::get_default_color_palette();
        }

        // Extract the "name" field for each palette in the array
        $palette_names = array_column($palettes, 'name');

        // Create an array with the palette names as keys and the palette names as values
        $palette_names = array_combine($palette_names, $palette_names);

        return $palette_names;
    }

    /**
     * Get Stripe supported currencies
     *
     * @return array
     * @since 3.1.8
     */
    static function get_stripe_currencies()
    {
        return [
            'usd' => 'USD - US Dollar',
            'eur' => 'EUR - Euro',
            'gbp' => 'GBP - British Pound',
            'cad' => 'CAD - Canadian Dollar',
            'aud' => 'AUD - Australian Dollar',
            'jpy' => 'JPY - Japanese Yen',
            'chf' => 'CHF - Swiss Franc',
            'nzd' => 'NZD - New Zealand Dollar',
            'sek' => 'SEK - Swedish Krona',
            'nok' => 'NOK - Norwegian Krone',
            'dkk' => 'DKK - Danish Krone',
            'pln' => 'PLN - Polish Złoty',
            'czk' => 'CZK - Czech Koruna',
            'huf' => 'HUF - Hungarian Forint',
            'ron' => 'RON - Romanian Leu',
            'bgn' => 'BGN - Bulgarian Lev',
            'hrk' => 'HRK - Croatian Kuna',
            'inr' => 'INR - Indian Rupee',
            'sgd' => 'SGD - Singapore Dollar',
            'hkd' => 'HKD - Hong Kong Dollar',
            'myr' => 'MYR - Malaysian Ringgit',
            'thb' => 'THB - Thai Baht',
            'php' => 'PHP - Philippine Peso',
            'mxn' => 'MXN - Mexican Peso',
            'brl' => 'BRL - Brazilian Real',
        ];
    }

    /**
     * Check if Stripe is configured
     *
     * @return boolean
     * @since 3.1.8
     */
    static function check_stripe_configured()
    {
        $activated_elements = get_option('brf_activated_elements');
        
        if (is_array($activated_elements)) {
            foreach ($activated_elements as $element) {
                if (isset($element->id) && $element->id === 5) {
                    $settings = isset($element->settings) ? $element->settings : null;
                    return !empty($settings) && !empty($settings->stripeSecretKey) && !empty($settings->stripeWebhookSecret);
                }
            }
        }
        
        return false;
    }

    /**
     * Get Mollie supported currencies
     *
     * @return array
     * @since 3.1.8
     */
    static function get_mollie_currencies()
    {
        return [
            'EUR' => 'EUR - Euro',
            'USD' => 'USD - US Dollar',
            'GBP' => 'GBP - British Pound',
            'AUD' => 'AUD - Australian Dollar',
            'BGN' => 'BGN - Bulgarian Lev',
            'CAD' => 'CAD - Canadian Dollar',
            'CHF' => 'CHF - Swiss Franc',
            'CZK' => 'CZK - Czech Koruna',
            'DKK' => 'DKK - Danish Krone',
            'HKD' => 'HKD - Hong Kong Dollar',
            'HRK' => 'HRK - Croatian Kuna',
            'HUF' => 'HUF - Hungarian Forint',
            'ILS' => 'ILS - Israeli New Shekel',
            'ISK' => 'ISK - Icelandic Króna',
            'JPY' => 'JPY - Japanese Yen',
            'MXN' => 'MXN - Mexican Peso',
            'MYR' => 'MYR - Malaysian Ringgit',
            'NOK' => 'NOK - Norwegian Krone',
            'NZD' => 'NZD - New Zealand Dollar',
            'PHP' => 'PHP - Philippine Peso',
            'PLN' => 'PLN - Polish Złoty',
            'RON' => 'RON - Romanian Leu',
            'RUB' => 'RUB - Russian Ruble',
            'SEK' => 'SEK - Swedish Krona',
            'SGD' => 'SGD - Singapore Dollar',
            'THB' => 'THB - Thai Baht',
            'TWD' => 'TWD - New Taiwan Dollar',
            'ZAR' => 'ZAR - South African Rand',
        ];
    }

    /**
     * Check if Mollie is configured
     *
     * @return boolean
     * @since 3.1.8
     */
    static function check_mollie_configured()
    {
        $activated_elements = get_option('brf_activated_elements');

        if (is_array($activated_elements)) {
            foreach ($activated_elements as $element) {
                if (isset($element->id) && $element->id === 5) {
                    $settings = isset($element->settings) ? $element->settings : null;
                    return !empty($settings) && !empty($settings->mollieApiKey);
                }
            }
        }

        return false;
    }

    /**
     * Check if Google Maps is configured
     *
     * @return boolean
     */
    static function check_google_maps_configured()
    {
        $activated_elements = get_option('brf_activated_elements');

        if (is_array($activated_elements)) {
            foreach ($activated_elements as $element) {
                if (isset($element->id) && $element->id === 5) {
                    $settings = isset($element->settings) ? $element->settings : null;
                    return !empty($settings) && !empty($settings->googleMapsApiKey);
                }
            }
        }

        return false;
    }

    /**
     * Get Google Maps API key (decrypted)
     *
     * @return string
     */
    static function get_google_maps_api_key()
    {
        $activated_elements = get_option('brf_activated_elements');

        if (is_array($activated_elements)) {
            foreach ($activated_elements as $element) {
                if (isset($element->id) && $element->id === 5) {
                    $settings = isset($element->settings) ? $element->settings : null;
                    if (!empty($settings->googleMapsApiKey)) {
                        $utils = new \Bricksforge\Api\Utils();
                        return $utils->decrypt($settings->googleMapsApiKey);
                    }
                }
            }
        }

        return '';
    }
}
