
jQuery(document).ready(function(){
	
	jQuery(".woocommerce-tabs").before(jQuery(".scwbtbsr_content").show());
	var url = jQuery(".smartcms_url").val();
	var proid = jQuery(".product_id").val();
	
	jQuery(".scw_options_select option:eq(0)").prop("selected", true);
	
	if(jQuery(".scw_schedules_daily").size() > 0){
		var array_dates = jQuery(".array_dates").val();
		var array_times = jQuery(".array_times").val().split(",");
		
		jQuery('#scw_schedules_picker').datetimepicker({
			disabledWeekDays: array_dates,
			allowTimes: array_times,
			format: 'd/m/Y H:i',
			onSelectTime:function(ct, $i){
				checkSchedule($i[0].value);
			},
			onSelectDate:function(ct,$i){
				checkSchedule($i[0].value);
			}
		});
	}else{
		jQuery(".scw_schedules_item").each(function(){
			var thische = jQuery(this);
			thische.click(function(){
				jQuery(".scw_schedules_item").removeClass("active");
				thische.addClass("active");
				
				checkSchedule(thische.text());
			});
		});
	}
	
	function checkSchedule(schedule){
		jQuery.ajax({
			type: "POST",
			url: url+"helper.php",
			data:{
				task: "check_schedule",
				schedule: schedule,
				proid: proid
			},
			beforeSend : function(data){
				jQuery(".scw_mapping").css("opacity", "0.5");
			},
			success : function(data){
				jQuery(".scw_mapping").css("opacity", "1");
				jQuery(".scw_mapping_column.disabled").each(function(key, val){
					jQuery(this).removeClass("disabled");
					
					var seat = jQuery(this).children(".scw_mapping_seat_vl").val().replace(".", "-");
					var readVl = jQuery("#seats"+seat).children(".scw_read_value").val();
					if(readVl){
						if(readVl.charAt(0) == "#"){
							jQuery("#seats"+seat).children(".scw_mapping_seat").empty();
							jQuery("#seats"+seat).children(".scw_mapping_seat").text(val);
							jQuery("#seats"+seat).children(".scw_mapping_seat").removeClass("scw_mapping_seat_icon");
							jQuery("#seats"+seat).children(".scw_mapping_seat").addClass("scw_mapping_seat_color");
							jQuery("#seats"+seat).children(".scw_mapping_seat").css("background", readVl);
						}else{
							jQuery("#seats"+seat).children(".scw_mapping_seat").empty();
							jQuery("#seats"+seat).children(".scw_mapping_seat").addClass("scw_mapping_seat_icon");
							jQuery("#seats"+seat).children(".scw_mapping_seat").removeClass("scw_mapping_seat_color");
							jQuery("#seats"+seat).children(".scw_mapping_seat").removeAttr("style");
							jQuery("#seats"+seat).children(".scw_mapping_seat").append('<img src="'+readVl+'">');
							jQuery("#seats"+seat).children(".scw_mapping_seat").append('<span>'+jQuery(this).children(".scw_mapping_seat_vl").val()+'</span>');
						}
					}
				});
				
				if(data){
					var seats = data.split(",");
					jQuery.each(seats, function(key, val){
						if(val){
							var seat = val.replace(".", "-");
							jQuery("#seats"+seat).addClass("disabled");
							
							var readVl = jQuery("#seats"+seat).children(".scw_booked_value").val();
							if(readVl){
								if(readVl.charAt(0) == "#"){
									jQuery("#seats"+seat).children(".scw_mapping_seat").empty();
									jQuery("#seats"+seat).children(".scw_mapping_seat").text(val);
									jQuery("#seats"+seat).children(".scw_mapping_seat").removeClass("scw_mapping_seat_icon");
									jQuery("#seats"+seat).children(".scw_mapping_seat").addClass("scw_mapping_seat_color");
									jQuery("#seats"+seat).children(".scw_mapping_seat").css("background", readVl);
								}else{
									jQuery("#seats"+seat).children(".scw_mapping_seat").empty();
									jQuery("#seats"+seat).children(".scw_mapping_seat").addClass("scw_mapping_seat_icon");
									jQuery("#seats"+seat).children(".scw_mapping_seat").removeClass("scw_mapping_seat_color");
									jQuery("#seats"+seat).children(".scw_mapping_seat").removeAttr("style");
									jQuery("#seats"+seat).children(".scw_mapping_seat").append('<img src="'+readVl+'">');
									jQuery("#seats"+seat).children(".scw_mapping_seat").append('<span>'+val+'</span>');
								}
							}
						}
					});
				}
			}
		});
	}
	
	jQuery(".scw_mapping_column").each(function(){
		var thiseat = jQuery(this);
		
		thiseat.click(function(){
			if(!thiseat.hasClass("disabled")){
				if(jQuery(".scw_schedules_daily").size() > 0 || jQuery(".scw_schedules_item").size() > 0){
					if(jQuery("#scw_schedules_picker").val() || jQuery(".scw_schedules_item.active").size() > 0){
						if(jQuery(".scw_options_select").val())
							checkSeats(thiseat);
						else
							alert("Please choose an option!");
					}else
						alert("Please choose schedule first!");
				}else
					checkSeats(thiseat);
			}
		});
	});
	
	function checkSeats(thiseat){
		if(thiseat.hasClass("active"))
			thiseat.removeClass("active");
		else
			thiseat.addClass("active");
		
		var seats = "";
		jQuery(".scw_mapping_column.active").each(function(){
			var seat = jQuery(this).children(".scw_mapping_seat_vl").val();
			if(seats)
				seats += "@"+seat;
			else
				seats += seat;
		});
		
		var option = jQuery(".scw_options_select").val();
		
		jQuery.ajax({
			type: "POST",
			url: url+"helper.php",
			data:{
				task: "check_seats",
				seats: seats,
				option: option,
				proid: proid
			},
			beforeSend : function(data){
				jQuery(".scw_mapping").css("opacity", "0.5");
			},
			success : function(data){
				jQuery(".scw_mapping").css("opacity", "1");
				
				if(data){
					var totalSeat = 0;
					var checkData = data.split("$");
					jQuery.each(checkData, function(k, v){
						var value = v.split("#");
						totalSeat += value[1].split("@").length;
					});
					jQuery(".input-text.qty").val(totalSeat);
				}else
					jQuery(".input-text.qty").val(0);
			}
		});
	}
	
	/////////
	jQuery(".scw_options_select").change(function(){
		var thisval = jQuery(this).val();
		jQuery.ajax({
			type: "POST",
			url: url+"helper.php",
			data:{
				task: "check_opseats",
				proid: proid
			},
			beforeSend : function(data){
				jQuery(".scw_mapping").css("opacity", "0.5");
			},
			success : function(data){
				jQuery(".scw_mapping").css("opacity", "1");
				jQuery(".scw_mapping_column").removeClass("tmpdisabled").removeClass("active");
				
				if(data){
					var checkop = data.split("$");
					jQuery.each(checkop, function(keyo, valo){
						if(valo){
							var checkseats = valo.split("#");
							if(checkseats[0] == thisval){
								var seats = checkseats[1].split("@");
								jQuery.each(seats, function(keys, vals){
									var nv = vals.replace(".", "-");
									jQuery("#seats"+nv).addClass("active");
								});
							}else{
								var seats = checkseats[1].split("@");
								jQuery.each(seats, function(keys, vals){
									var nv = vals.replace(".", "-");
									jQuery("#seats"+nv).addClass("tmpdisabled");
								});
							}
						}
					});
				}
			}
		});
	});
});