<?php
/**
* Plugin Name: Bus Ticket Booking and Seat Reservation for WooCommerce
* Plugin URI: http://codecanyon.net/user/smartcms
* Description: bus seat reservation for woocommerce product
* Version: 1.8
* Author: SmartCms Team
* Author URI: http://codecanyon.net/user/smartcms
* License: GPLv2 or later
*/

define ( 'SCWBTBSR', plugin_dir_url(__FILE__));

function scwbtbsr_session() {
  session_start();
}
add_action('wp_loaded','scwbtbsr_session');

register_activation_hook(__FILE__, 'scwbtbsr_install');
global $wnm_db_version;
$wnm_db_version = "1.0";

function scwbtbsr_install(){
	global $wpdb;
	global $wnm_db_version;
	
	$profileTB = $wpdb->prefix . 'scwbtbsr_profiles';
	$typesTB = $wpdb->prefix . 'scwbtbsr_types';
	$schedulesTB = $wpdb->prefix . 'scwbtbsr_schedules';
	$dailyschedulesTB = $wpdb->prefix . 'scwbtbsr_dailyschedules';
	$dailytimesTB = $wpdb->prefix . 'scwbtbsr_dailytimes';
	$pricetypesTB = $wpdb->prefix . 'scwbtbsr_pricetypes';
	$pricemappingTB = $wpdb->prefix . 'scwbtbsr_pricemapping';
	$mapsoTB = $wpdb->prefix . 'scwbtbsr_mapso';
	$mappingTB = $wpdb->prefix . 'scwbtbsr_mapping';
	$productsTB = $wpdb->prefix . 'scwbtbsr_products';
	$ordersTB = $wpdb->prefix . 'scwbtbsr_orders';
	
	$charset_collate = $wpdb->get_charset_collate();
	
	$profileSql = "CREATE TABLE $profileTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileName` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$typesSql = "CREATE TABLE $typesTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileid` int(11) DEFAULT NULL,
		`label` varchar(255) DEFAULT NULL,
		`color` varchar(255) DEFAULT NULL,
		`icon` varchar(255) DEFAULT NULL,
		`type` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$schedulesSql = "CREATE TABLE $schedulesTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileid` int(11) DEFAULT NULL,
		`schedule` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$dailyschedulesSql = "CREATE TABLE $dailyschedulesTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileid` int(11) DEFAULT NULL,
		`daily` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$dailytimesSql = "CREATE TABLE $dailytimesTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileid` int(11) DEFAULT NULL,
		`time` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$pricetypesSql = "CREATE TABLE $pricetypesTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileid` int(11) DEFAULT NULL,
		`type` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$pricemappingSql = "CREATE TABLE $pricemappingTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileid` int(11) DEFAULT NULL,
		`typeid` int(11) DEFAULT NULL,
		`pricetypeid` int(11) DEFAULT NULL,
		`price` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$mapsoSql = "CREATE TABLE $mapsoTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileid` int(11) DEFAULT NULL,
		`rows` text DEFAULT NULL,
		`columns` text DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$mappingSql = "CREATE TABLE $mappingTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileid` int(11) DEFAULT NULL,
		`seat` varchar(255) DEFAULT NULL,
		`label` varchar(255) DEFAULT NULL,
		`typeid` int(11) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$productsSql = "CREATE TABLE $productsTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileid` int(11) DEFAULT NULL,
		`productid` int(11) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$ordersSql = "CREATE TABLE $ordersTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`orderId` varchar(255) DEFAULT NULL,
		`productId` varchar(255) DEFAULT NULL,
		`schedule` varchar(255) DEFAULT NULL,
		`option` varchar(255) DEFAULT NULL,
		`seats` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($profileSql);
	dbDelta($typesSql);
	dbDelta($schedulesSql);
	dbDelta($dailyschedulesSql);
	dbDelta($dailytimesSql);
	dbDelta($pricetypesSql);
	dbDelta($pricemappingSql);
	dbDelta($mapsoSql);
	dbDelta($mappingSql);
	dbDelta($productsSql);
	dbDelta($ordersSql);
	add_option("wnm_db_version", $wnm_db_version);
}

add_action( 'admin_menu', 'scwbtbsr_admin_menu' );
function scwbtbsr_admin_menu() {
    add_menu_page(
        'Bus Seat Reservation',
        'Bus Seat Reservation',
        'manage_options',
        'bus-seat-reservation',
        'scwbtbsr_options_page'
    );
}
function scwbtbsr_options_page(  ) { 
	?>
	<form action='options.php' method='post'>
		<h2>SmartCms Bus Seat Reservation Configuration</h2>
		<?php
		settings_fields( 'scwbtbsrPage' );
		do_settings_sections( 'scwbtbsrPage' );
		submit_button();
		?>
	</form>
	<?php
}

add_action( 'admin_init', 'scwbtbsr_settings_init' );
function scwbtbsr_settings_init() {
	register_setting( 'scwbtbsrPage', 'scwbtbsr_settings' );
	add_settings_section(
		'smartcms_pluginPage_section', __( '', 'wordpress' ), '', 'scwbtbsrPage'
	);
	add_settings_field( 
		'','',
		'scwbtbsr_parameters', 
		'scwbtbsrPage', 
		'smartcms_pluginPage_section' 
	);
}
function scwbtbsr_parameters(){
	$options = get_option( 'scwbtbsr_settings' );
	global $wpdb;
	
	wp_enqueue_script('jquery');
	wp_enqueue_script('media-upload');
	wp_enqueue_script('thickbox');
	wp_enqueue_style('thickbox');
	
	wp_register_style('scwbtbsr-font-css', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css');
	wp_enqueue_style('scwbtbsr-font-css');
	
	wp_register_script('scwbtbsr-param-script', SCWBTBSR .'js/param.js');
	wp_enqueue_script('scwbtbsr-param-script');
	wp_register_style('scwbtbsr-param-css', SCWBTBSR .'css/param.css');
	wp_enqueue_style('scwbtbsr-param-css');
	
	wp_register_script('scwbtbsr-ui-datepicker', 'https://code.jquery.com/ui/1.12.1/jquery-ui.js');
	wp_enqueue_script( 'scwbtbsr-ui-datepicker' );
	wp_register_style( 'scwbtbsr-ui', '//code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css' );
    wp_enqueue_style( 'scwbtbsr-ui' );
	
	wp_register_script('scwbtbsr-timepicker', SCWBTBSR .'js/jquery-ui-timepicker-addon.js');
	wp_enqueue_script('scwbtbsr-timepicker');
	wp_register_style( 'scwbtbsr-style', SCWBTBSR .'css/jquery-ui-timepicker-addon.css' );
	wp_enqueue_style( 'scwbtbsr-style' );
	
	$tableProfile = $wpdb->prefix . 'scwbtbsr_profiles';
	$profiles = $wpdb->get_results( "SELECT * FROM $tableProfile" );
	?>
		<div class="scwbtbsr_content">
			<div class="scw_addprofile">
				<span class="scw_addprofile_header">Add Profile</span>
				<input class="scw_addprofile_name">
				<span class="scw_addprofile_submit"><i class="fa fa-plus" aria-hidden="true"></i> ADD</span>
			</div>
			<div class="scw_profiles">
				<?php
				if($profiles){
					foreach($profiles as $profile){
						?>
						<div class="scw_profile">
							<input class="scw_profile_id" value="<?php echo $profile->id ?>" type="hidden">
							<span class="scw_profile_head">
								<i class="fa fa-angle-double-right" aria-hidden="true"></i>
								<span class="scw_profile_head_name"><?php echo $profile->profileName ?></span>
								<span class="scw_profile_head_delete"><i class="fa fa-trash" aria-hidden="true"></i></span>
							</span>
							<span class="scw_profile_content">
								<span class="scw_profile_content_editname">
									<span class="scw_profile_content_editname_head">Edit Profile Name</span>
									<input class="scw_profile_content_editname_name" value="<?php echo $profile->profileName ?>">
									<span class="scw_profile_content_editname_save"><i class="fa fa-floppy-o" aria-hidden="true"></i> Save</span>
								</span>
								<span class="scw_addseattype">
									<span class="scw_addseattype_head">Add Type of Seat</span>
									<span class="scw_addseattype_label">
										<label>Type Label</label><br>
										<input class="scw_addseattype_label_input" type='text' />
									</span>
									<span class="scw_addseattype_color">
										<label>Color</label><br>
										<input class="scw_addseattype_color_input" type='color' />
									</span>
									<span class="scw_addseattype_or">OR</span>
									<span class="scw_addseattype_icon">
										<label>Icon Image</label><br>
										<input class="scw_addseattype_icon_input" type='text' />
										<span class="scw_addseattype_icon_upload scw_media_upload"><i class="fa fa-upload" aria-hidden="true"></i> Upload</span>
									</span>
									<span class="scw_addseattype_type">
										<select class="scw_addseattype_type_select">
											<option value="">-- Select a option --</option>
											<option value="isbooked">Is Booked Seat</option>
											<option value="ishallway">Is Hallway</option>
										</select>
									</span>
									<span class="scw_addseattype_button"><i class="fa fa-plus" aria-hidden="true"></i> ADD</span>
								</span>
								
								<!-- types -->
								<span class="scw_seattypes">
									<?php
										$tableTypes = $wpdb->prefix . 'scwbtbsr_types';
										$types = $wpdb->get_results( "SELECT * FROM $tableTypes where profileid = ".$profile->id );
										
										if($types){
											foreach($types as $type){
												?>
												<span class="scw_seattype">
													<input type="hidden" class="scw_seattype_id" value="<?php echo $type->id ?>">
													<span class="scw_seattype_label">
														<input value="<?php echo $type->label ?>" class="scw_seattype_label_input">
													</span>
													<span class="scw_seattype_color">
														<input value="<?php echo $type->color ?>" class="scw_seattype_color_input" type="color">
													</span>
													<span class="scw_seattype_icon">
														<input value="<?php echo $type->icon ?>" class="scw_seattype_icon_input">
														<span class="scw_seattype_icon_upload scw_media_upload"><i class="fa fa-upload" aria-hidden="true"></i> Upload</span>
													</span>
													<span class="scw_seattype_type">
														<select class="scw_seattype_type_select">
															<option value="">-- Select a option --</option>
															<option <?php if($type->type == "isbooked") echo "selected='selected'" ?> value="isbooked">Is Booked Seat</option>
															<option <?php if($type->type == "ishallway") echo "selected='selected'" ?> value="ishallway">Is Hallway</option>
														</select>
													</span>
													<span class="scw_seattype_save"><i class="fa fa-floppy-o" aria-hidden="true"></i> Save</span>
													<span class="scw_seattype_delete"><i class="fa fa-trash-o" aria-hidden="true"></i> Delete</span>
												</span>
												<?php
											}
										}
									?>
								</span>
								
								<!-- schedules -->
								<span class="scw_seatschedules">
									<span class="scw_seatschedules_head">Schedules</span>
									<span class="scw_seatschedules_content">
										<span class="scw_seatschedules_left">
											<span class="scw_seatschedules_left_head">Separate Schedules</span>
											<span class="scw_separate_schedules">
												<span class="scw_separate_schedules_add">
													<input class="scw_separate_schedules_add_input">
													<span class="scw_separate_schedules_add_button"><i class="fa fa-plus" aria-hidden="true"></i> ADD</span>
												</span>
												<span class="scw_separate_schedules_list">
													<?php
														$tableSchedules = $wpdb->prefix . 'scwbtbsr_schedules';
														$schedules = $wpdb->get_results( "SELECT * FROM $tableSchedules where profileid = ".$profile->id );
														
														if($schedules){
															foreach($schedules as $schedule){
																?>
																<span class="scw_separate_schedules_list_item">
																	<input type="hidden" value="<?php echo $schedule->id ?>" class="scw_separate_schedules_list_item_id">
																	<input class="scw_separate_schedules_list_item_schedule" value="<?php echo $schedule->schedule ?>">
																	<span class="scw_separate_schedules_list_item_save"><i class="fa fa-floppy-o" aria-hidden="true"></i> Save</span>
																	<span class="scw_separate_schedules_list_item_delete"><i class="fa fa-trash-o" aria-hidden="true"></i> Delete</span>
																</span>
																<?php
															}
														}
													?>
												</span>
											</span>
										</span>
										<span class="scw_seatschedules_or">OR</span>
										<span class="scw_seatschedules_right">
											<span class="scw_seatschedules_right_head">Daily Schedules</span>
											<span class="scw_daily_schedules">
												<?php
													$tableDailySchedules = $wpdb->prefix . 'scwbtbsr_dailyschedules';
													$dailies = $wpdb->get_results( "SELECT * FROM $tableDailySchedules where profileid = ".$profile->id );
													$dailies = explode(",", $dailies[0]->daily);
												?>
												<span class="scw_daily_schedules_week">
													<input <?php if(in_array("monday", $dailies)) echo "checked='checked'" ?> value="monday" type="checkbox" class="scw_daily_schedules_monday" id="scw_daily_schedules_monday">
													<label for="scw_daily_schedules_monday">Monday</label>
												</span>
												<span class="scw_daily_schedules_week">
													<input <?php if(in_array("tuesday", $dailies)) echo "checked='checked'" ?> value="tuesday" type="checkbox" class="scw_daily_schedules_tuesday" id="scw_daily_schedules_tuesday">
													<label for="scw_daily_schedules_tuesday">Tuesday</label>
												</span>
												<span class="scw_daily_schedules_week">
													<input <?php if(in_array("wednesday", $dailies)) echo "checked='checked'" ?> value="wednesday" type="checkbox" class="scw_daily_schedules_wednesday" id="scw_daily_schedules_wednesday">
													<label for="scw_daily_schedules_wednesday">Wednesday</label>
												</span>
												<span class="scw_daily_schedules_week">
													<input <?php if(in_array("thursday", $dailies)) echo "checked='checked'" ?> value="thursday" type="checkbox" class="scw_daily_schedules_thursday" id="scw_daily_schedules_thursday">
													<label for="scw_daily_schedules_thursday">Thursday</label>
												</span>
												<span class="scw_daily_schedules_week">
													<input <?php if(in_array("friday", $dailies)) echo "checked='checked'" ?> value="friday" type="checkbox" class="scw_daily_schedules_friday" id="scw_daily_schedules_friday">
													<label for="scw_daily_schedules_friday">Friday</label>
												</span>
												<span class="scw_daily_schedules_week">
													<input <?php if(in_array("saturday", $dailies)) echo "checked='checked'" ?> value="saturday" type="checkbox" class="scw_daily_schedules_saturday" id="scw_daily_schedules_saturday">
													<label for="scw_daily_schedules_saturday">Saturday</label>
												</span>
												<span class="scw_daily_schedules_week">
													<input <?php if(in_array("sunday", $dailies)) echo "checked='checked'" ?> value="sunday" type="checkbox" class="scw_daily_schedules_sunday" id="scw_daily_schedules_sunday">
													<label for="scw_daily_schedules_sunday">Sunday</label>
												</span>
											</span>
											<span class="scw_daily_schedules_times">
												<span class="scw_daily_schedules_times_add">
													<input class="scw_daily_schedules_times_add_input" placeholder="daily time">
													<span class="scw_daily_schedules_times_add_button"><i class="fa fa-plus" aria-hidden="true"></i> ADD</span>
												</span>
												<span class="scw_daily_schedules_times_list">
													<?php
														$tableDailyTimes = $wpdb->prefix . 'scwbtbsr_dailytimes';
														$times = $wpdb->get_results( "SELECT * FROM $tableDailyTimes where profileid = ".$profile->id );
														
														if($times){
															foreach($times as $time){
																?>
																<span class="scw_daily_schedules_times_list_item">
																	<input class="scw_daily_schedules_times_list_item_id" type="hidden" value="<?php echo $time->id ?>">
																	<input class="scw_daily_schedules_times_list_item_input" placeholder="daily time" value="<?php echo $time->time ?>">
																	<span class="scw_daily_schedules_times_list_item_button"><i class="fa fa-floppy-o" aria-hidden="true"></i> Save</span>
																	<span class="scw_daily_schedules_times_list_item_delete"><i class="fa fa-trash-o" aria-hidden="true"></i> Delete</span>
																</span>
																<?php
															}
														}
													?>
												</span>
											</span>
										</span>
									</span>
								</span>
								
								<!-- price -->
								<span class="scw_seatsprices">
									<span class="scw_seatsprices_head">Prices</span>
									<span class="scw_seatsprices_type">
										<span class="scw_seatsprices_type_head">Price Types</span>
										<span class="scw_seatsprices_type_add">
											<input class="scw_seatsprices_type_add_input">
											<span class="scw_seatsprices_type_add_button"><i class="fa fa-plus" aria-hidden="true"></i> ADD</span>
										</span>
										<span class="scw_seatsprices_type_list">
											<?php
												$tablePricetype = $wpdb->prefix . 'scwbtbsr_pricetypes';
												$pricetypes = $wpdb->get_results( "SELECT * FROM $tablePricetype where profileid = ".$profile->id );
												
												if($pricetypes){
													foreach($pricetypes as $pricetype){
														?>
															<span class="scw_seatsprices_type_list_item">
																<input type="hidden" class="scw_seatsprices_type_list_item_id" value="<?php echo $pricetype->id ?>">
																<input class="scw_seatsprices_type_list_item_price" value="<?php echo $pricetype->type ?>">
																<span class="scw_seatsprices_type_list_item_button"><i class="fa fa-floppy-o" aria-hidden="true"></i> Save</span>
																<span class="scw_seatsprices_type_list_item_delete"><i class="fa fa-trash-o" aria-hidden="true"></i> Delete</span>
															</span>
														<?php
													}
												}
											?>
										</span>
									</span>
									<span class="scw_seatsprices_mapping">
										<span class="scw_seatsprices_mapping_head">Price Mapping</span>
										<span class="scw_seatsprices_mapping_content">
											<?php
												$mtablePricetype = $wpdb->prefix . 'scwbtbsr_pricetypes';
												$mpricetypes = $wpdb->get_results( "SELECT * FROM $mtablePricetype where profileid = ".$profile->id );
												
												$mtableTypes = $wpdb->prefix . 'scwbtbsr_types';
												$mtypes = $wpdb->get_results( "SELECT * FROM $mtableTypes where profileid = ".$profile->id." and type not in ('isbooked', 'ishallway')" );
												
												if($mtypes && $mpricetypes){
													foreach($mtypes as $mtype){
														?>
														<span class="scw_seatsprices_mapping_item">
															<input type="hidden" class="scw_seatsprices_mapping_item_id" value="<?php echo $mtype->id ?>">
															<span class="scw_seatsprices_mapping_item_name">Type of Seat: <?php echo $mtype->label ?></span>
															<span class="scw_seatsprices_mapping_item_price">
																<?php
																	foreach($mpricetypes as $mprice){
																		
																		$pricemapTable = $wpdb->prefix . 'scwbtbsr_pricemapping';
																		$pricemap = $wpdb->get_results( "SELECT * FROM $pricemapTable where profileid = ".$profile->id." and typeid = ".$mtype->id." and pricetypeid = ".$mprice->id );
																		
																		?>
																		<span class="scw_seatsprices_mapping_item_price_item">
																			<input class="scw_seatsprices_mapping_item_price_id" type="hidden" value="<?php echo $mprice->id ?>">
																			<span class="scw_seatsprices_mapping_item_price_type" placeholder="price"><?php echo $mprice->type ?></span><br>
																			<input class="scw_seatsprices_mapping_item_price_input" value="<?php echo $pricemap[0]->price ?>">
																		</span>
																		<?php
																	}
																?>
															</span>
															<span class="scw_seatsprices_mapping_item_save"><i class="fa fa-floppy-o" aria-hidden="true"></i> Save</span>
														</span>
														<?php
													}
												}
											?>
										</span>
									</span>
								</span>
								
								<!-- mapping -->
								<span class="scw_seatsmapping">
									<span class="scw_seatsmapping_head">Seat Mapping</span>
									<?php
										$tableMapso = $wpdb->prefix . 'scwbtbsr_mapso';
										$mapso = $wpdb->get_results( "SELECT * FROM $tableMapso where profileid = ".$profile->id );
									?>
									<span class="scw_seatsmapping_so">
										<span class="scw_seatsmapping_so_rows">
											<label>Label of Rows (for example: A,B...,Z)</label><br>
											<input class="scw_seatsmapping_so_rows_input" value="<?php echo $mapso[0]->rows ?>">
										</span>
										<span class="scw_seatsmapping_so_columns">
											<label>Label of Columns (for example: 1,2...,n)</label><br>
											<input class="scw_seatsmapping_so_columns_input" value="<?php echo $mapso[0]->columns ?>">
										</span>
										<span class="scw_seatsmapping_so_save"><i class="fa fa-floppy-o" aria-hidden="true"></i> Save</span>
									</span>
									<?php
										$width = count(explode(",", $mapso[0]->columns)) * 250;
									?>
									<span class="scw_seatsmapping_content_bao">
										<input type="hidden" class="scw_seatsmapping_content_width" value="<?php echo $width ?>">
										<span class="scw_seatsmapping_content">
											<?php
												if($mapso){
													$rows = explode(",", $mapso[0]->rows);
													$columns = explode(",", $mapso[0]->columns);
													
													$tableTypes = $wpdb->prefix . 'scwbtbsr_types';
													$types = $wpdb->get_results( "SELECT * FROM $tableTypes where profileid = ".$profile->id );
											
													foreach($rows as $row){
														?>
														<span class="scw_seatsmapping_content_row">
															<?php
																foreach($columns as $column){
																	$seat = $row.".".$column;
																	
																	$tableMapping = $wpdb->prefix . 'scwbtbsr_mapping';
																	$mapping = $wpdb->get_results( "SELECT * FROM $tableMapping where profileid = ".$profile->id." and seat = '".$seat."'" );
																	
																	$labelinfontend = $mapping[0]->label?$mapping[0]->label:$seat;
																	?>
																	<span class="scw_seatsmapping_content_column">
																		<span class="scw_seatsmapping_content_text"><?php echo $seat ?></span>
																		<span class="scw_seatsmapping_content_label">
																			<span class="scw_seatsmapping_content_label_text">Label in Fontend</span><br>
																			<input class="scw_seatsmapping_content_label_input" value="<?php echo $labelinfontend ?>">
																		</span>
																		<span class="scw_seatsmapping_content_type">
																			<span class="scw_seatsmapping_content_type_text">Seat Type</span><br>
																			<select class="scw_seatsmapping_content_type_input">
																				<option value="">-- select type of seat --</option>
																				<?php
																					if($types){
																						foreach($types as $type){
																							?>
																							<option <?php if($mapping[0]->typeid == $type->id) echo "selected='selected'" ?> value="<?php echo $type->id ?>"><?php echo $type->label ?></option>
																							<?php
																						}
																					}
																				?>
																			</select>
																		</span>
																	</span>
																	<?php
																}
															?>
														</span>
														<?php
													}
												}
											?>
										</span>
									</span>
									<span class="scw_seatsmapping_content_action">
										<span class="scw_seatsmapping_content_action_save"><i class="fa fa-floppy-o" aria-hidden="true"></i> Save Mapping</span>
										<span class="scw_seatsmapping_content_action_reset"><i class="fa fa-recycle"></i> Reset Mapping</span>
									</span>
								</span>
							</span>
						</div>
						<?php
					}
				}
				?>
			</div>
		</div>
	<?php
}

add_action( 'widgets_init', 'scwbtbsr_widgets' );
add_action( 'plugins_loaded', 'scwbtbsr_load' );

function scwbtbsr_widgets(){
	register_widget('scwbtbsr_class');
}
function scwbtbsr_load(){
    global $mfpd;
    $mfpd = new scwbtbsr_class();
}
class scwbtbsr_class extends WP_Widget{
	function __construct(){
		parent::__construct(
			  'scwbtbsr_id',
			  'SmartCms Bus Seat Reservation',
			  array(
				  'description' => ''
			  )
		);
		add_action( 'add_meta_boxes', array( $this, 'scwbtbsr_add_tab_admin_product' ), 10, 2 );
	}
	function scwbtbsr_add_tab_admin_product($post_type, $post)
	{
		global $wp_meta_boxes;
		$wp_meta_boxes[ 'product' ][ 'normal' ][ 'core' ][ 'scwbtbsr' ][ 'title' ] = "SmartCms Bus Seat Reservation";
		$wp_meta_boxes[ 'product' ][ 'normal' ][ 'core' ][ 'scwbtbsr' ][ 'id' ] = "scwbtbsr";
		$wp_meta_boxes[ 'product' ][ 'normal' ][ 'core' ][ 'scwbtbsr' ][ 'callback' ] = "scwbtbsr_add_tab_admin_product_display";
	}
}

function scwbtbsr_add_tab_admin_product_display(){
	global $wpdb;

	$postId = $_GET['post'];
	
	wp_register_script('scwbtbsr-product-script', SCWBTBSR .'js/product.js');
	wp_enqueue_script('scwbtbsr-product-script');
	wp_register_style('scwbtbsr-product-css', SCWBTBSR .'css/product.css');
	wp_enqueue_style('scwbtbsr-product-css');
	
	$tableProfiles = $wpdb->prefix . 'scwbtbsr_profiles';
	$profiles = $wpdb->get_results( "SELECT * FROM $tableProfiles" );
	?>
	<div class="scw_content">
		<input type="hidden" class="scw_proid" value="<?php echo $postId ?>">
		<div class="scw_profile">
			<span class="scw_profile_add">Add Profile</span>
			<select class="scw_profile_choose">
				<option value="">-- Choose a profile --</option>
				<?php
					foreach($profiles as $pro){
						?><option value="<?php echo $pro->id ?>"><?php echo $pro->profileName ?></option><?php
					}
				?>
			</select>
			<span class="scw_profile_save">Save</span>
		</div>
		<?php
			$tableSelectedProfiles = $wpdb->prefix . 'scwbtbsr_products';
			$selectedProfile = $wpdb->get_results( "SELECT * FROM $tableSelectedProfiles where productid = ".$postId );
			$profileid = $selectedProfile[0]->profileid;

			if($profileid){
				$checkName = $wpdb->get_results( "SELECT * FROM $tableProfiles where id = ".$profileid );
				$profileName = $checkName[0]->profileName;
				
				?><div class="scw_mapping_name">Profile: <?php echo $profileName ?></div><?php
				
				$tableSchedules = $wpdb->prefix . 'scwbtbsr_schedules';
				$checkSchedules = $wpdb->get_results( "SELECT * FROM $tableSchedules where profileid = ".$profileid );
				if($checkSchedules){
					?>
					<div class="scw_schedules">
						<span class="scw_schedules_head">Schedules:</span>
						<?php
							foreach($checkSchedules as $sche){
								?><span class="scw_schedules_item"><?php echo $sche->schedule ?></span><?php
							}
						?>
					</div>
					<?php
				}else{
					$tableDailySchedules = $wpdb->prefix . 'scwbtbsr_dailyschedules';
					$checkDailySchedules = $wpdb->get_results( "SELECT * FROM $tableDailySchedules where profileid = ".$profileid );
					$dailies = explode(",", $checkDailySchedules[0]->daily);
					
					if($dailies){
						?>
						<div class="scw_schedules">
							<span class="scw_schedules_head">Schedules:</span>
						<?php	
							foreach($dailies as $daily){
								?><span class="scw_schedules_item"><?php echo $daily ?></span><?php
							}
						?>
						</div>
						<?php
					}
					
					$tableDailyTimes = $wpdb->prefix . 'scwbtbsr_dailytimes';
					$times = $wpdb->get_results( "SELECT * FROM $tableDailyTimes where profileid = ".$profileid );
					if($times){
						?>
						<div class="scw_schedulestimes">
							<span class="scw_schedulestimes_head">Times:</span>
						<?php	
							foreach($times as $time){
								?><span class="scw_schedulestimes_item"><?php echo $time->time ?></span><?php
							}
						?>
						</div>
						<?php
					}
				}
				
				$tablePrices = $wpdb->prefix . 'scwbtbsr_pricemapping';
				$checkPrices = $wpdb->get_results( "SELECT * FROM $tablePrices where profileid = ".$profileid );
				
				$tableTypes = $wpdb->prefix . 'scwbtbsr_types';
				$tablePriceTypes = $wpdb->prefix . 'scwbtbsr_pricetypes';
				
				if($checkPrices){
					?>
					<div class="scw_prices">
						<span class="scw_prices_head">Prices:</span>
						<?php
						foreach($checkPrices as $price){
							$typeid = $price->typeid;
							$pricetypeid = $price->pricetypeid;
							$gia = $price->price;
							
							$selectType = $wpdb->get_results( "SELECT * FROM $tableTypes where id = ".$typeid );
							$type = $selectType[0]->label;
							
							$selectPriceType = $wpdb->get_results( "SELECT * FROM $tablePriceTypes where id = ".$pricetypeid );
							$pricetype = $selectPriceType[0]->type;
							
							?><span class="scw_prices_item"><?php echo "Seat Type: <i>".$type."</i> - Price Type: <i>".$pricetype."</i> - Price: <i>".$gia."</i>" ?></span><?php
						}
					?>
					</div>
					<?php
				}
			}
		?>
		<div class="scw_mapping">
			<?php
				if($profileid){
					$tableMapso = $wpdb->prefix . 'scwbtbsr_mapso';
					$mapso = $wpdb->get_results( "SELECT * FROM $tableMapso where profileid = ".$profileid );
					$rows = explode(",", $mapso[0]->rows);
					$columns = explode(",", $mapso[0]->columns);
					
					$width = count($columns) * 200;
					?>
					<div class="scw_mapping_content" style="width: <?php echo $width ?>px"><?php
					foreach($rows as $row){
						?>
							<div class="scw_mapping_row">
								<?php
									foreach($columns as $column){
										$seat = $row.".".$column;
										
										$tableMapping = $wpdb->prefix . 'scwbtbsr_mapping';
										$mapping = $wpdb->get_results( "SELECT * FROM $tableMapping where profileid = ".$profileid." and seat = '".$seat."'" );
										
										$tableTypes = $wpdb->prefix . 'scwbtbsr_types';
										$types = $wpdb->get_results( "SELECT * FROM $tableTypes where id = '".$mapping[0]->typeid ."'" );
										$type = $types[0]->label?$types[0]->label:"";
										?>
										<span class="scw_mapping_column">
											<span class="scw_mapping_seat"><?php echo $seat ?></span>
											<span class="scw_mapping_label">Label in Fontend:<br><?php echo $mapping[0]->label ?></span>
											<span class="scw_mapping_type">Seat Type:<br><?php echo $type ?></span>
										</span>
										<?php
									}
								?>
							</div>
						<?php
					}
					?></div><?php
				}
			?>
		</div>
		<div class="scw_booked">
			<span class="scw_booked_head">Booked Seats Manage</span>
			<span class="scw_booked_content">
			<?php
				$tableOrders = $wpdb->prefix . 'scwbtbsr_orders';
				$orders = $wpdb->get_results( "SELECT * FROM $tableOrders where productId = ".$postId );
				
				if($orders){
					foreach($orders as $order){
						?>
						<div class="scw_booked_item">
							<input class="scw_booked_item_id" type="hidden" value="<?php echo $order->id ?>">
							<span class="scw_booked_item_order">Order: <a target="_blank" href="post.php?post=<?php echo $order->orderId ?>&action=edit"><?php echo $order->orderId ?></a></span>
							<span class="scw_booked_item_schedule">Schedule: <?php echo $order->schedule ?></span>
							<span class="scw_booked_item_option">Type: <?php echo $order->option ?></span>
							<span class="scw_booked_item_seats">Seats: <?php echo str_replace(",", " ", $order->seats) ?></span>
							<span class="scw_booked_item_delete">Delete</span>
						</div>
						<?php
					}
				}
			?>
			</span>
		</div>
	</div>
	<?php
}

add_action('woocommerce_after_single_product', 'scwbtbsr_fontend_single');
function scwbtbsr_fontend_single(){
	global $product;
	global $wpdb;
	$proId = $product->id;
	
	$tableSelectedProfiles = $wpdb->prefix . 'scwbtbsr_products';
	$selectedProfile = $wpdb->get_results( "SELECT * FROM $tableSelectedProfiles where productid = ".$proId );
	$profileid = $selectedProfile[0]->profileid;
	
	$currencyS = get_woocommerce_currency_symbol( $currency );
	
	if($profileid){
		wp_register_script('scwbtbsr-script-datetimepicker', SCWBTBSR .'datetimepicker/jquery.datetimepicker.full.min.js');
		wp_enqueue_script('scwbtbsr-script-datetimepicker');
		wp_register_style('scwbtbsr-style-datetimepicker', SCWBTBSR .'datetimepicker/jquery.datetimepicker.css');
		wp_enqueue_style('scwbtbsr-style-datetimepicker');
		
		wp_register_script('scwbtbsr-script-frontend', SCWBTBSR .'js/front.js');
		wp_enqueue_script('scwbtbsr-script-frontend');
		wp_register_style('scwbtbsr-style-frontend', SCWBTBSR .'css/front.css');
		wp_enqueue_style('scwbtbsr-style-frontend');
		
		$tableTypes = $wpdb->prefix . 'scwbtbsr_types';
		$types = $wpdb->get_results( "SELECT * FROM $tableTypes where profileid = ".$profileid." and type <> 'ishallway'" );
		
		$tableSchedules = $wpdb->prefix . 'scwbtbsr_schedules';
		$checkSchedules = $wpdb->get_results( "SELECT * FROM $tableSchedules where profileid = ".$profileid );
		
		$tablePriceType = $wpdb->prefix . 'scwbtbsr_pricetypes';
		$priceTypes = $wpdb->get_results( "SELECT * FROM $tablePriceType where profileid = ".$profileid );
		
		$tableOrders = $wpdb->prefix . 'scwbtbsr_orders';
		$orders = $wpdb->get_results( "SELECT * FROM $tableOrders where productId = ".$proId );
		$bookedSeats = array();
		if($orders){
			foreach($orders as $order){
				$cseats = explode(",", $order->seats);
				foreach($cseats as $s){
					array_push($bookedSeats, $s);
				}
			}
		}
		//echo "<pre>".print_r($_SESSION,1)."</pre>";
		?>
		<div class="scwbtbsr_content" style="display: none">
			<input type="hidden" value="<?php echo SCWBTBSR ?>" class="smartcms_url">
			<input type="hidden" value="<?php echo $proId ?>" class="product_id">
			<div class="scw_types">
				<?php
					foreach($types as $type){
						if($type->type != "hallway"){
							
							$tablePriceMapping = $wpdb->prefix . 'scwbtbsr_pricemapping';
							$priceMapping = $wpdb->get_results( "SELECT * FROM $tablePriceMapping where typeid = ".$type->id );
							?>
							<span class="scw_types_item">
								<span class="scw_types_item_name"><b><?php echo $type->label ?></b></span>
								<span class="scw_types_item_prices">
									<?php
										if($priceMapping){
											foreach($priceMapping as $pmap){
												$pricetypeid = $pmap->pricetypeid;
												$price = $pmap->price;
												
												$priceType = $wpdb->get_results( "SELECT * FROM $tablePriceType where id = ".$pricetypeid );
												$priceTypeName = $priceType[0]->type;
												?>
												<span class="scw_types_item_prices_item"><?php echo $priceTypeName.": ".$price.$currencyS ?></span>
												<?php
											}
										}
									?>
								</span>
								<?php
									if($type->icon){
										?>
										<span class="scw_types_item_icon"><img src="<?php echo $type->icon ?>"></span>
										<?php
									}else{
										?>
										<span class="scw_types_item_icon scw_types_item_icon_color" style="background: <?php echo $type->color ?>"><?php echo $type->color ?></span>
										<?php
									}
								?>
							</span>
							<?php
						}
					}
				?>
			</div>
			<div class="scw_schedules <?php if($checkSchedules){ ?>scw_schedules_special<?php }else{ ?>scw_schedules_daily<?php } ?>">
				<?php
				if($checkSchedules){
					?><div class="scw_schedules_header">Please choose schedule first!</div><?php
					foreach($checkSchedules as $sche){
						?><span class="scw_schedules_item"><?php echo $sche->schedule ?></span><?php
					}
				}else{
					$arroDay = array(0, 1, 2, 3, 4, 5, 6);
					$arrDay = array();
					$arrTime = "";
					
					$tableDailySchedules = $wpdb->prefix . 'scwbtbsr_dailyschedules';
					$checkDailySchedules = $wpdb->get_results( "SELECT * FROM $tableDailySchedules where profileid = ".$profileid );
					$dailies = explode(",", $checkDailySchedules[0]->daily);
					if($dailies){
						foreach($dailies as $dai){
							if($dai == "monday")
								array_push($arrDay, 1);
							elseif($dai == "tuesday")
								array_push($arrDay, 2);
							elseif($dai == "wednesday")
								array_push($arrDay, 3);
							elseif($dai == "thursday")
								array_push($arrDay, 4);
							elseif($dai == "friday")
								array_push($arrDay, 5);
							elseif($dai == "saturday")
								array_push($arrDay, 6);
							elseif($dai == "sunday")
								array_push($arrDay, 0);
						}
					}
					$arrfDay = array_diff($arroDay, $arrDay);
					
					$tableDailyTimes = $wpdb->prefix . 'scwbtbsr_dailytimes';
					$times = $wpdb->get_results( "SELECT * FROM $tableDailyTimes where profileid = ".$profileid );
					if($times){
						foreach($times as $time){
							if($arrTime)
								$arrTime .= ",".$time->time;
							else
								$arrTime .= $time->time;
						}
					}
	
					?>
					<div class="scw_schedules_header">Please choose schedule first!</div>
					<input class="array_dates" type="hidden" value='<?php echo json_encode($arrfDay, 1) ?>'>
					<input class="array_times" type="hidden" value="<?php echo $arrTime ?>">
					<input id="scw_schedules_picker" type="text">
					<?php
				}
				?>
			</div>
			<div class="scw_options">
				<?php
					if($priceTypes){
						?><div class="scw_options_header">Please choose an option!</div>
						<select class="scw_options_select">
							<option value="">-- Choose an option --</option>
							<?php
							foreach($priceTypes as $ptype){
								?><option value="<?php echo $ptype->type ?>"><?php echo $ptype->type ?></option><?php
							}
							?>
						</select>
						<?php
					}
				?>
			</div>
			<div class="scw_mapping">
				<?php
				$tableMapso = $wpdb->prefix . 'scwbtbsr_mapso';
				$mapso = $wpdb->get_results( "SELECT * FROM $tableMapso where profileid = ".$profileid );
				$rows = explode(",", $mapso[0]->rows);
				$columns = explode(",", $mapso[0]->columns);
				
				$width = 100 / count($columns);
				?>
				<div class="scw_mapping_content"><?php
				foreach($rows as $row){
					?>
						<div class="scw_mapping_row">
							<?php
								foreach($columns as $column){
									$seat = $row.".".$column;
									
									$tableMapping = $wpdb->prefix . 'scwbtbsr_mapping';
									$mapping = $wpdb->get_results( "SELECT * FROM $tableMapping where profileid = ".$profileid." and seat = '".$seat."'" );
									
									$tableTypes = $wpdb->prefix . 'scwbtbsr_types';
									$types = $wpdb->get_results( "SELECT * FROM $tableTypes where id = '".$mapping[0]->typeid ."'" );
									$type = $types[0]->label;
									$typeColor = $types[0]->color;
									$typeIcon = $types[0]->icon;
									$label = $mapping[0]->label;
									
									if(in_array($label, $bookedSeats)){
										$bookedtype = $wpdb->get_results( "SELECT * FROM $tableTypes where type = 'isbooked'" );
										$ftypeColor = $bookedtype[0]->color;
										$ftypeIcon = $bookedtype[0]->icon;
									}else{
										$ftypeColor = $types[0]->color;
										$ftypeIcon = $types[0]->icon;
									}
									?>
									<span id="seats<?php echo str_replace(".", "-", $label) ?>" class="scw_mapping_column scw_<?php echo $type ?> <?php if(in_array($label, $bookedSeats) || $types[0]->type == "isbooked") echo "disabled" ?> <?php if($types[0]->type == "ishallway") echo "scwhallway" ?>" style="width: <?php echo $width ?>%">
										<input type="hidden" value="<?php echo $label ?>" class="scw_mapping_seat_vl">
										<?php
											if($ftypeIcon){
												?>
												<input type="hidden" value="<?php echo $ftypeIcon ?>" class="scw_booked_value">
												<span class="scw_mapping_seat scw_mapping_seat_icon">
													<img src="<?php echo $ftypeIcon ?>">
													<span><?php echo $label ?></span>
												</span>
												<?php
											}else{
												?>
												<input type="hidden" value="<?php echo $ftypeColor ?>" class="scw_booked_value">
												<span class="scw_mapping_seat scw_mapping_seat_color" style="background: <?php echo $ftypeColor ?>"><?php echo $label ?></span>
												<?php
											}
											if($typeIcon){
												?><input type="hidden" value="<?php echo $typeIcon ?>" class="scw_read_value"><?php
											}else{
												?><input type="hidden" value="<?php echo $typeColor ?>" class="scw_read_value"><?php
											}
										?>
									</span>
									<?php
								}
							?>
						</div>
					<?php
				}
				?>
				</div>
			</div>
		</div>
		<?php
	}
}

add_filter( 'woocommerce_cart_item_price', 'scwbtbsr_change_product_price_display', 10, 3 );
function scwbtbsr_change_product_price_display( $price, $product ){
	global $wpdb;
	
	$proId = $product["product_id"];
	
	$customString = "";
	if(isset($_SESSION["seats".$proId])){
		$checkSeats = explode("$", $_SESSION["seats".$proId]);
		if($checkSeats){
			$customString .= "<br>Booked Seats:";
			foreach($checkSeats as $seat){
				$fseat = explode("#", $seat);
				$customString .= "<br>".$fseat[0].": ".str_replace("@", " ", $fseat[1]);
			}
		}
	}
	
	if(isset($_SESSION["schedule".$proId])){
		$customString .= "<br>";
		$customString .= "Schedule: ".$_SESSION["schedule".$proId];
	}
	
	echo $price.$customString;
}

add_action( 'woocommerce_before_calculate_totals', 'scwbtbsr_add_custom_price' );
function scwbtbsr_add_custom_price( $cart_object ){
	global $wpdb;
	
    if ( is_admin() && !defined('DOING_AJAX') )
        return;

    foreach ( $cart_object->get_cart() as $cart_item ) {
		$proId = $cart_item['data']->id;

		if(isset($_SESSION["seats".$proId])){
			$total = 0;
			
			$pricetypesTable = $wpdb->prefix . 'scwbtbsr_pricetypes';
			$mappingTable = $wpdb->prefix . 'scwbtbsr_mapping';
			$pricemappingTable = $wpdb->prefix . 'scwbtbsr_pricemapping';
			
			$tableSelectedProfiles = $wpdb->prefix . 'scwbtbsr_products';
			$selectedProfile = $wpdb->get_results( "SELECT * FROM $tableSelectedProfiles where productid = ".$proId );
			$profileid = $selectedProfile[0]->profileid;
			
			$checkSeats = explode("$", $_SESSION["seats".$proId]);
			if($checkSeats){
				foreach($checkSeats as $opseat){
					$checkopseat = explode("#", $opseat);
					$optionName = $checkopseat[0];
					$seats = explode("@", $checkopseat[1]);
					
					$typeSql = $wpdb->get_results("SELECT * from $pricetypesTable where type = '".$optionName."' and profileid = ".$profileid);
					$pricetypeid = $typeSql[0]->id;
					
					foreach($seats as $seat){
						$selectType = $wpdb->get_results( "SELECT * FROM $mappingTable where profileid = ".$profileid." and label = '".$seat."'" );
						$typeid = $selectType[0]->typeid;
						
						$selectPrice = $wpdb->get_results( "SELECT * FROM $pricemappingTable where profileid = ".$profileid." and typeid = ".$typeid." and pricetypeid = ".$pricetypeid );
						$price = $selectPrice[0]->price;
						
						$total += $price;
					}
				}
			}
		}
		
        $cart_item['data']->set_price( $total / $cart_item['quantity'] );
    }
}

add_filter( 'woocommerce_order_item_name', 'scwbtbsr_order_complete' , 10, 2 );
function scwbtbsr_order_complete( $link, $item ){
	global $wpdb;
	global $wp;
	
	$proId = $item["product_id"];
	$order_id  = absint($wp->query_vars['order-received']);
	
	$customString = "";
	if($proId && $order_id){
		$customString = "";
		$orderTable = $wpdb->prefix . 'scwbtbsr_orders';
		
		if(isset($_SESSION["seats".$proId])){
			$checkSeats = explode("$", $_SESSION["seats".$proId]);
			if($checkSeats){
				$customString .= "<br>Booked Seats:";
				foreach($checkSeats as $seat){
					$fseat = explode("#", $seat);
					$customString .= "<br>".$fseat[0].": ".str_replace("@", " ", $fseat[1]);
					
					$seats = explode("@", $fseat[1]);
					$insetArr = $seats;
					foreach($seats as $ks=>$s){
						$checkOrder = $wpdb->get_results("SELECT * from $orderTable where FIND_IN_SET('".$s."', seats) and productId = ".$proId." and schedule = '".$_SESSION["schedule".$proId]."'");
						$checkSeat = $checkOrder[0]->seats;
						
						if($checkSeat)
							unset($insetArr[$ks]);
					}
					if($insetArr){
						$wpdb->insert( $orderTable,
							array( 
								'productId' => $proId, 
								'orderId' => $order_id,
								'seats' => implode(",", $insetArr),
								'option' => $fseat[0],
								'schedule' => $_SESSION["schedule".$proId]
							) 
						);
					}
				}
			}
		}
		
		if(isset($_SESSION["schedule".$proId])){
			$customString .= "<br>";
			$customString .= "Schedule: ".$_SESSION["schedule".$proId];
		}
	}
	
	echo $link.$customString;
}

add_action( 'woocommerce_before_order_itemmeta', 'scwbtbsr_admin_edit_order', 10, 3 );
function scwbtbsr_admin_edit_order( $item_id, $item, $product ){
	global $wpdb;
	$proId = $product->id;
    $postId = $_GET['post'];
	
	$orderSeatTable = $wpdb->prefix . 'scwbtbsr_orders';
	$orderSeats = $wpdb->get_results("SELECT * from $orderSeatTable where productId = ".$proId." and orderId = '".$postId."'");
	
	if($orderSeats){
		echo "<br>";
		echo "Booked Seats:";
		foreach($orderSeats as $order){
			echo "<br>".$order->option .": ".str_replace(",", " ", $order->seats);
		}
		echo "<br>Schedule: ".$orderSeats[0]->schedule;
	}
}

add_filter( 'woocommerce_admin_order_actions', 'scwbtbsr_addactions_button', 100, 2 );
function scwbtbsr_addactions_button( $actions, $order ){
	$order_id = method_exists( $order, 'get_id' ) ? $order->get_id() : $order->id;
	
	$actions['scwbtbsr_print'] = array(
		'url'       => $order_id,
		'name'      => __( 'Print Tickets', 'woocommerce' ),
		'action'    => "view scwbtbsr_print",
	);
	
	return $actions;
}
add_action( 'admin_head', 'scwbtbsr_addactions_stylescript' );
function scwbtbsr_addactions_stylescript() {
    echo '<style>.view.scwbtbsr_print::after { font-family: woocommerce; content: "\e01e" !important; }</style>';
	echo '<script>
		jQuery(document).ready(function(){
			
			jQuery("#wpbody-content").append("<div id=\"scwbtbsr_print\"></div>");
			
			jQuery(".scwbtbsr_print").each(function(){
				var elthis = jQuery(this);
				elthis.click(function(event){
					event.preventDefault();
					
					var orderid = elthis.attr("href").replace("http://", "");
					jQuery.ajax({
						url: "../wp-content/plugins/scw-bus-seat-reservation/helper.php",
						data: {
							orderid : orderid,
							task : "print_tickets"
						},
						type: "POST",
						beforeSend: function(data){
							jQuery("#scwbtbsr_print").empty();
						},
						success: function(data){
							if(data){
								var checkDt = data.split("#");
								if(checkDt[5]){
									var total = checkDt[0];
									var name = checkDt[1];
									var email = checkDt[2];
									var phone = checkDt[3];
									var address = checkDt[4];
									var tickets = checkDt[5];
									
									tickets = tickets.split("&");
									var tproname = tickets[0];
									var tproqty = tickets[1];
									var tprotickets = tickets[2];
									tprotickets = tprotickets.split("%");
									
									jQuery("#scwbtbsr_print").append("<h1>Order: #"+orderid+"</h1>");
									jQuery("#scwbtbsr_print").append("<span><b>Customer Name:</b> "+name+"</span><br>");
									jQuery("#scwbtbsr_print").append("<span><b>Customer Email:</b> "+email+"</span><br>");
									jQuery("#scwbtbsr_print").append("<span><b>Customer Phone:</b> "+phone+"</span><br>");
									jQuery("#scwbtbsr_print").append("<span><b>Customer Address:</b> "+address+"</span><br><br>");
									jQuery("#scwbtbsr_print").append("<span><b>"+tproname+" x "+tproqty+"</b></span><br>");
									
									jQuery.each(tprotickets, function(k,v){
										if(v){
											var value = v.split("@");
											jQuery("#scwbtbsr_print").append("<span>"+value[0]+": "+value[1].replace(",", " ")+"</span><br>");
										}
									});
									jQuery("#scwbtbsr_print").append("<br><span><b>Total:</b> "+total+"</span><br>");
									
									var divToPrint=document.getElementById("scwbtbsr_print");
									var newWin=window.open("", "Print-Window");
									newWin.document.open();
									newWin.document.write("<html><body onload=\"window.print()\">"+divToPrint.innerHTML+"</body></html>");
									newWin.document.close();
								}
							}
						}
					});
				});
			});
		});
	</script>';
}