<?php
if (!defined('ABSPATH'))
    wp_die('No direct access allowed');

global $WPBE;
global $wp_version;

if (empty(WPBE_HELPER::filter_post_types())) {
    ?>
    <div class="notice notice-error">
        <p>
            <?php esc_html_e('No any post type permitted to edit for site editors. Ask please site administrators for details!', 'bulk-editor'); ?>
        </p>
    </div>
    <?php
    return;
}
?>

<div class="wpbe-admin-preloader">
    <div class="cssload-loader">
        <div class="cssload-inner cssload-one"></div>
        <div class="cssload-inner cssload-two"></div>
        <div class="cssload-inner cssload-three"></div>
    </div>
</div>

<!----------------------------- Filters ------------------------------------->

<?php echo WPBE_HELPER::render_html(WPBE_PATH . 'views/parts/top_panel.php'); ?>

<!----------------------------- Filters end ------------------------------------->

<div class="wrap nosubsub">

    <?php if (isset($_GET['settings_saved'])): ?>
        <div id="message" class="updated"><p><strong><?php esc_html_e("Your settings have been saved.", 'bulk-editor') ?></strong></p></div>
    <?php endif; ?>

    <section class="wpbe-section">

        <div class="wpbe-header">
            <div>

                <h3 class="wpbe-plugin-name"><?php printf('WOLF - WordPress Posts Bulk Editor and Manager Professional %s', '<span>v.' . WPBE_VERSION . '</span>') ?>
                    <svg viewBox="-57 117.2 480 607.7" fill="#2f55d4">
                    <g><path d="m181.4 693.9c0-6.2 0.1-7.7 0.5-8.2 0.3-0.4 0.5-1.3 0.5-2.4s0.2-2 0.5-2.4c0.3-0.3 0.5-1.2 0.5-2 0-0.9 0.2-1.4 0.5-1.6 0.3-0.1 0.5-0.6 0.5-1.4 0-0.7 0.2-1.4 0.5-1.6s0.5-0.8 0.5-1.3 0.2-1.1 0.5-1.3 0.5-0.7 0.5-1.1 0.2-0.9 0.5-1.1 0.5-0.6 0.5-0.9 0.2-0.8 0.5-1.2c0.3-0.3 0.5-0.9 0.5-1.3s0.2-0.9 0.5-1.2 0.5-0.6 0.5-0.8c0-0.6 4.4-8.9 5.5-10.3 0.3-0.4 0.6-0.9 0.6-1.2s0.2-0.6 0.5-0.8 0.5-0.7 0.5-1 0.2-0.7 0.5-1c0.3-0.2 0.5-0.7 0.5-1s0.2-0.7 0.5-1c0.3-0.2 0.5-0.7 0.5-1s0.2-0.7 0.5-1c0.3-0.2 0.5-0.7 0.5-1s0.2-0.7 0.5-1 0.5-0.7 0.5-1 0.2-0.7 0.5-1 0.5-0.7 0.5-1 0.2-0.7 0.5-1 0.5-0.7 0.5-1 0.2-0.7 0.5-1 0.5-0.7 0.5-1 0.2-0.7 0.5-1 0.5-0.7 0.5-1.2 0.2-0.9 0.5-1 0.5-0.6 0.5-1c0-0.5 0.2-1.1 0.5-1.5 0.3-0.3 0.5-0.9 0.5-1.3s0.2-0.9 0.5-1.1 0.5-0.9 0.5-1.4 0.2-1.3 0.5-1.6 0.5-1.3 0.5-2.1 0.2-1.7 0.5-2.1c0.4-0.5 0.5-2 0.5-8 0-6.6 0.1-7.4 0.6-7.9 0.8-0.7 5.7-3.1 6.4-3.1 0.3 0 0.8-0.2 1-0.5s0.7-0.5 1-0.5 0.7-0.2 1-0.5c0.2-0.3 0.7-0.5 1-0.5s1.3-0.4 2.1-1c0.8-0.5 1.6-1 1.8-1s0.7-0.3 1.2-0.7c1.4-1.1 3.3-2.2 3.6-2.2s3.2-2.5 5.9-5.1c2.8-2.7 5.6-6.2 6.4-7.8 0.5-1 1.1-2 1.3-2.2 0.6-0.5 2.1-3.4 2.1-4.1 0-0.3 0.2-0.8 0.5-1.2 0.3-0.3 0.5-0.9 0.5-1.2s0.2-0.7 0.5-0.9 0.5-0.7 0.5-1.1 0.2-1 0.5-1.3 0.5-1 0.5-1.4c0-0.5 0.2-1.1 0.5-1.4s0.5-1 0.5-1.4c0-0.5 0.2-1.1 0.5-1.4s0.5-1.2 0.5-1.9 0.2-1.6 0.5-1.9 0.5-1.3 0.5-2.1 0.2-1.8 0.5-2.1c0.3-0.4 0.5-1.3 0.5-2.2s0.2-1.9 0.5-2.2c0.3-0.4 0.5-1.4 0.5-2.7 0-1.5 0.2-2.2 0.5-2.5s0.5-1 0.5-2.4 0.1-2.1 0.5-2.4c0.3-0.3 0.5-1 0.5-2.2s0.2-2 0.5-2.2 0.5-1 0.5-2.2 0.2-2 0.5-2.2 0.5-0.9 0.5-1.6c0-0.6 0.2-1.4 0.5-1.8 0.3-0.3 0.5-1.2 0.5-1.8 0-0.7 0.2-1.4 0.5-1.6s0.5-0.9 0.5-1.5 0.2-1.3 0.5-1.5c0.3-0.3 0.5-0.9 0.5-1.4s0.2-1.2 0.5-1.4c0.3-0.3 0.5-0.6 0.5-0.9s0.6-1.6 1.3-2.9c0.2-0.3 0.5-0.9 0.8-1.4 0.8-1.6 1.6-2.9 2.8-4.5 0.6-0.8 1.2-1.6 1.2-1.7 0-0.3 5.1-4 6.6-4.8 0.8-0.4 1.6-0.7 2-0.7 0.3 0 0.8-0.2 1-0.5s0.7-0.5 1.1-0.5 1-0.2 1.3-0.5 0.9-0.5 1.3-0.5 0.9-0.2 1.1-0.5 0.6-0.5 1-0.5c0.3 0 1.4-0.4 2.4-1 1-0.5 2.1-1 2.6-1 0.4 0 0.9-0.2 1-0.5s0.6-0.5 1-0.5 0.9-0.2 1-0.5 0.5-0.5 1-0.5c0.4 0 0.9-0.2 1-0.5s1.2-1 2.5-1.6 2.4-1.3 2.4-1.4c0-0.2 0.3-0.4 0.7-0.5 1.7-0.5 11.8-8.7 11.8-9.5 0-0.2 0.7-1.1 1.6-2.1s1.6-1.9 1.6-2.1 0.4-0.8 0.9-1.5c1.1-1.4 1.7-2.5 1.7-2.9 0-0.5-1-0.4-1.7 0.2-0.3 0.3-1 0.5-1.4 0.5-0.5 0-1.1 0.2-1.4 0.5s-0.9 0.5-1.2 0.5-0.7 0.2-0.9 0.5-0.8 0.5-1.2 0.5c-0.5 0-1.1 0.2-1.5 0.5-0.3 0.3-0.9 0.5-1.2 0.5s-0.7 0.2-0.9 0.5-0.8 0.5-1.2 0.5c-0.5 0-1.1 0.2-1.5 0.5-0.3 0.3-1 0.5-1.4 0.5-0.5 0-1.1 0.2-1.4 0.5s-0.9 0.5-1.3 0.5-0.9 0.2-1.3 0.5c-0.3 0.3-1.1 0.5-1.6 0.5s-1.3 0.2-1.6 0.5-1.1 0.5-1.7 0.5-1.4 0.2-1.7 0.5-1.2 0.5-1.9 0.5-1.6 0.2-1.9 0.5c-0.4 0.3-1.4 0.5-2.5 0.5-1 0-2.4 0.2-3 0.5-1.7 0.7-3.7 0.6-4.4-0.2-0.6-0.6-0.5-0.7 2.3-3.6 1.6-1.6 3.5-3.4 4.3-3.9s2.4-1.9 3.7-3.1c1.2-1.2 2.9-2.6 3.7-3.1 2-1.4 14.3-13.8 14.6-14.6 0.1-0.4 0.9-1.4 1.8-2.2 0.8-0.9 1.8-2 2-2.6 0.3-0.6 0.8-1.3 1.2-1.6 0.6-0.6 3.2-4.2 3.2-4.5 0-0.1 0.4-0.7 1-1.5 0.5-0.7 1-1.5 1-1.7s0.2-0.6 0.5-0.8 0.5-0.7 0.5-1 0.1-0.6 0.3-0.6 0.4-0.4 0.5-0.9 0.4-1.1 0.6-1.3 0.4-0.7 0.4-1 0.2-0.8 0.5-1 0.5-0.7 0.5-1 0.2-0.7 0.5-1c0.3-0.2 0.5-0.7 0.5-1s0.2-0.7 0.5-1c0.3-0.2 0.5-0.9 0.5-1.6s0.2-1.4 0.5-1.6 0.5-0.9 0.5-1.4c0-0.6 0.2-1.2 0.5-1.4s0.5-0.9 0.5-1.7c0-0.7 0.2-1.7 0.5-2.1s0.5-1.6 0.5-2.6 0.2-2 0.5-2.4c0.6-0.8 0.7-8 0.1-8.4-0.4-0.3-2.5 2-3.3 3.6-0.3 0.5-0.8 1.3-1.2 1.6s-1.1 1.3-1.6 2.1c-1.2 1.8-16.2 17-16.9 17-0.3 0-1.1 0.6-1.9 1.4s-1.6 1.4-1.8 1.4c-0.4 0-2.2 1.1-3.7 2.2-0.5 0.4-1.1 0.7-1.3 0.7-0.3 0-0.6 0.2-0.9 0.5-0.2 0.3-0.7 0.5-1 0.5s-0.7 0.2-1 0.5-0.6 0.5-0.9 0.5c-0.4 0-1.4 0.4-5.4 2.3-0.7 0.3-1.7 0.6-2.2 0.6s-1.5 0.3-2.1 0.6c-0.7 0.3-1.4 0.5-1.7 0.4s-0.9 0.1-1.5 0.5c-0.8 0.6-1.2 0.7-2.4 0.5-1-0.1-2.1 0-3.4 0.4-1.2 0.4-2.9 0.6-4.3 0.6-1.3 0-3.1 0.2-4.2 0.5-1 0.3-3 0.5-4.4 0.5h-3.1c-0.5 0-0.6 0.4-0.6 2.3 0 1.3 0.2 3 0.5 3.9 0.3 1.1 0.5 3.1 0.5 6.6 0 3.7 0.1 5.2 0.5 5.8 0.6 1.1 0.6 1.6-0.2 1.6-0.7 0-1-0.3-3.5-3.2-1-1.1-2.6-2.9-3.6-4s-1.8-2-1.8-2.2-0.6-1.1-1.4-2-1.5-1.9-1.5-2.2c-0.1-0.4-0.3-0.6-0.6-0.6-0.7 0-0.9 7.6-0.2 8.7 0.3 0.5 0.5 1.6 0.5 3.4 0 2 0.1 2.8 0.5 3.1 0.3 0.3 0.5 1 0.5 2.5 0 1.4 0.2 2.3 0.5 2.7s0.5 1.3 0.5 2.4c0 1 0.2 2.2 0.5 2.7 0.7 1.4 0.6 2.4-0.2 2.4-0.7 0-6.8-5.9-7.5-7.4-0.2-0.5-1.2-1.6-2-2.5-0.9-0.9-1.8-2-2-2.5s-1-1.5-1.8-2.3-1.4-1.6-1.4-1.8-0.6-1.1-1.4-2-1.4-1.7-1.4-1.9-0.6-1-1.4-2-1.4-2-1.4-2.2-0.4-0.7-1-1.2c-0.5-0.5-1-1.2-1-1.4 0-0.3-0.4-0.9-1-1.4-0.5-0.5-1-1.1-1-1.2s-0.7-1.3-1.5-2.6-1.5-2.5-1.6-2.7c0-0.2-0.5-0.9-1-1.5s-1-1.3-1-1.5-0.4-0.8-1-1.4c-0.5-0.6-1-1.3-1-1.5s-0.3-0.7-0.8-1.1c-0.6-0.6-0.8-0.6-1-0.3-0.1 0.2-0.2 3.7-0.2 7.6 0.1 5.7 0.2 7.4 0.5 7.9s0.5 1.6 0.5 3.6c0 1.8 0.2 3.3 0.5 4s0.5 2.1 0.5 3.5c0 1.6 0.2 2.6 0.5 3s0.5 1.4 0.5 2.7 0.2 2.3 0.5 2.7 0.5 1.4 0.5 2.6 0.2 2.2 0.5 2.6 0.5 1.4 0.5 2.7c0 1.5 0.2 2.2 0.5 2.5s0.5 1 0.5 2.4 0.1 2.1 0.5 2.4c0.3 0.3 0.5 1 0.5 2.5 0 1.4 0.2 2.3 0.5 2.7s0.5 1.4 0.5 3.1c0 1.6 0.2 2.6 0.5 3.1 0.3 0.4 0.5 1.5 0.5 3.4s0.2 2.9 0.5 3.4c0.3 0.4 0.5 1.5 0.5 3.7 0 1.8 0.2 3.6 0.5 4.3 0.3 0.9 0.5 2.7 0.5 6.3s0.1 5.4 0.5 6.4c0.3 0.8 0.5 2.5 0.5 4.4 0 3.2 0.4 4.5 1.4 4.5 0.5 0 3.4-2.9 3.6-3.6 0.1-0.2 0.5-0.9 1-1.5s0.9-1.4 0.9-1.6c0-0.3 0.2-0.7 0.5-0.9s0.5-0.7 0.5-1 0.2-0.7 0.5-1c0.3-0.2 0.5-0.6 0.5-0.9s0.2-0.8 0.5-1.2c0.3-0.3 0.5-0.9 0.5-1.3s0.2-0.9 0.5-1.3c0.3-0.3 0.5-0.9 0.5-1.1 0-0.3 0.2-0.7 0.5-0.9s0.5-0.8 0.5-1.3 0.2-1.1 0.5-1.5c0.3-0.3 0.5-0.9 0.5-1.2s0.2-0.6 0.4-0.8c0.5-0.3 1.6 0.9 1.6 1.7 0 0.3 0.2 0.8 0.5 1s0.5 0.8 0.5 1.3 0.2 1.1 0.5 1.3c0.3 0.3 0.5 1 0.5 2.5 0 1.4 0.2 2.4 0.5 2.8 0.4 0.5 0.5 1.6 0.5 4.7 0 2.6 0.2 4.6 0.5 5.6 0.7 2.3 0.7 17 0 17.9-0.3 0.4-0.5 1.4-0.5 2.9s-0.2 2.5-0.5 2.9c-0.3 0.3-0.5 1.1-0.5 1.8s-0.2 1.4-0.5 1.8c-0.3 0.3-0.5 1-0.5 1.4 0 0.5-0.2 1.1-0.5 1.4s-0.5 1-0.5 1.5-0.2 1-0.5 1.2-0.5 0.8-0.5 1.3-0.2 1.1-0.5 1.3-0.5 0.7-0.5 1-0.2 0.7-0.5 1c-0.3 0.2-0.5 0.6-0.5 0.8s-0.6 1.4-1.4 2.5c-0.8 1.2-1.4 2.3-1.4 2.5 0 0.6-8.4 8.9-9 8.9-0.3 0-0.9 0.4-1.4 1s-1.3 1-1.7 1c-0.5 0-1.1 0.2-1.4 0.5s-0.9 0.5-1.3 0.5-0.9 0.2-1.3 0.5c-0.3 0.3-1.3 0.5-2.1 0.5s-1.7 0.2-2.1 0.5c-0.3 0.3-1.2 0.5-1.8 0.5-0.7 0-1.4 0.2-1.6 0.5s-0.7 0.5-1.1 0.5c-0.8 0-1.6 0.5-3.1 1.9-0.6 0.5-1.2 0.9-1.4 0.9s-1 0.6-1.8 1.4-1.7 1.4-1.9 1.4-0.9 0.4-1.4 0.9c-1.1 1-2.8 2-3.5 2-0.2 0-0.6 0.2-0.8 0.5s-0.7 0.5-1.2 0.5c-0.4 0-0.9 0.2-1 0.5s-0.6 0.5-1 0.5-1.1 0.2-1.5 0.5c-0.3 0.3-1.3 0.5-2.2 0.5s-1.9 0.2-2.2 0.4c-0.4 0.3-1.9 0.5-3.8 0.6-1.8 0.1-3.6 0.3-4.1 0.5-1.4 0.5-7.3 0.4-8.4-0.1-0.6-0.3-1.9-0.5-3.7-0.5-2.1 0-2.9-0.1-3.2-0.5-0.3-0.3-1-0.5-1.9-0.5s-1.7-0.2-1.9-0.5-0.6-0.5-0.9-0.5c-0.7 0-4.4-1.9-5.4-2.7-1.4-1.1-3.3-3.2-3.3-3.6 0-0.2 0.3-0.4 0.8-0.4s0.9-0.2 1.1-0.4c0.3-0.3 1.8-0.5 6.7-0.6 4.2-0.1 6.5-0.3 7-0.5 0.5-0.3 2.5-0.4 6.5-0.4 3.9 0 6-0.1 6.5-0.4 0.4-0.2 1.3-0.5 2-0.6 1.1-0.2 1.3-0.3 1.3-1 0-0.8-0.1-0.8-2.7-1-1.5-0.1-2.8-0.4-3-0.6s-6-0.3-18-0.3c-14.6 0-17.9-0.1-19.5-0.5-1-0.3-3.1-0.5-4.6-0.5-2.2 0-3-0.1-3.7-0.6-0.6-0.4-1.2-0.6-1.7-0.4-0.4 0.1-1.1 0-1.5-0.3s-1.1-0.5-1.4-0.5-0.8-0.2-1-0.5-0.6-0.5-0.8-0.5-0.9-0.4-1.6-1c-0.7-0.5-1.4-1-1.6-1-0.5 0-4.9-4.7-4.9-5.3 0-0.2-0.2-0.6-0.5-0.8s-0.5-0.9-0.5-1.4c0-0.6-0.2-1.2-0.5-1.4-0.4-0.3-0.5-1.3-0.5-5 0-2.5 0.1-4.6 0.2-4.5s0.8 0.4 1.4 0.7 1.3 0.7 1.4 0.9 0.5 0.3 0.8 0.3 0.8 0.2 1 0.5 0.7 0.5 1 0.5 0.7 0.2 1 0.5c0.2 0.3 0.7 0.5 1 0.5s0.7 0.2 1 0.5c0.2 0.3 0.9 0.5 1.4 0.5s1.2 0.2 1.4 0.5 0.9 0.5 1.4 0.5 1.2 0.2 1.4 0.5c0.3 0.4 1.1 0.5 3.2 0.5 1.5 0 3.4 0.2 4.2 0.4 1.2 0.4 1.6 0.4 2.5 0 0.6-0.2 2.1-0.4 3.3-0.4 1.5 0 2.5-0.2 2.9-0.5 0.3-0.3 0.9-0.5 1.3-0.5 0.8 0 2.5-0.8 3.3-1.6 0.3-0.3 1.3-1.3 2.2-2.3 1.6-1.7 1.7-1.9 1.7-3.5 0-1.2-0.2-1.9-0.5-2.1s-0.5-0.7-0.5-1-0.1-0.7-0.3-0.8-0.7-1.1-1.3-2.2c-0.5-1.1-1.3-2.4-1.8-2.8-0.4-0.4-0.8-1-0.8-1.3s-0.4-0.9-1-1.4-1-1.2-1-1.4-0.4-0.9-1-1.4-1-1.2-1-1.5-0.2-0.7-0.5-0.9-0.5-0.7-0.5-1-0.2-0.7-0.5-1c-0.4-0.3-0.5-1.2-0.5-4.3s0.1-4 0.5-4.3c0.3-0.2 0.5-0.6 0.5-0.9s0.6-1.2 1.4-2.1 1.4-1.8 1.4-2c0-0.5 3.7-4 5.8-5.5 2.9-2.1 5.1-3.3 5.9-3.3 0.4 0 0.9-0.2 1.2-0.5 0.2-0.3 0.9-0.5 1.4-0.5s1.2-0.2 1.4-0.5c0.3-0.3 1-0.5 2.4-0.5s2.1-0.1 2.4-0.5 2.2-0.5 13.3-0.5 12.9 0.1 13.3 0.5c0.3 0.3 1 0.5 2.2 0.5s2 0.2 2.2 0.5 0.9 0.5 1.4 0.5 1.2 0.2 1.4 0.5 0.8 0.5 1.2 0.5c0.5 0 1.1 0.2 1.5 0.5 0.3 0.3 1.1 0.5 1.6 0.5s1.2 0.2 1.4 0.5 0.8 0.5 1.2 0.4c0.7-0.1 0.8-0.3 0.9-1.2 0.1-0.8-0.1-1.3-0.8-2.1-0.5-0.5-1.6-1.9-2.4-3-1.5-2-5.9-6.2-6.5-6.2-0.2 0-0.8-0.5-1.4-1.1s-1.3-1.1-1.6-1.1-0.7-0.2-0.9-0.5-0.7-0.5-1-0.5-0.7-0.2-1-0.5c-0.2-0.3-0.7-0.5-1-0.5s-0.7-0.2-1-0.5c-0.2-0.3-0.9-0.5-1.4-0.5s-1.2-0.2-1.4-0.5-1-0.5-1.9-0.5-1.7-0.2-2-0.5c-0.8-0.7-10.9-0.7-12 0-0.4 0.3-1.1 0.5-1.5 0.5s-1 0.2-1.2 0.5-0.9 0.5-1.4 0.5-1.2 0.2-1.5 0.5c-0.5 0.6-1.7 0.5-1.9-0.3-0.1-0.7 3.4-4.3 4.8-4.8 0.5-0.2 0.9-0.4 0.9-0.6 0-0.5 2.1-1.6 3-1.6 0.5 0 0.9-0.2 1-0.5s0.6-0.5 1.7-0.5c1 0 1.7-0.2 1.9-0.5 0.6-0.7 9.4-0.7 10.6 0 0.4 0.3 1.5 0.5 2.4 0.5s1.9 0.2 2.2 0.5 1.2 0.5 1.9 0.5 1.6 0.2 1.9 0.5 1.2 0.5 1.9 0.5 1.6 0.2 2 0.5c1 0.7 1.7 0.4 1.7-1 0-1-0.4-1.5-3.6-4.8-2-2-4.1-3.9-4.7-4.2s-1.9-1.1-3-1.8-2.3-1.3-2.8-1.3-1.2-0.3-1.6-0.7c-0.5-0.4-1.2-0.6-2.1-0.6-0.7 0-1.6-0.2-2-0.5-0.5-0.4-1.8-0.5-6.3-0.5s-5.7-0.1-5.7-0.4c0-0.5 1.5-2 3.8-3.7 1-0.7 2.5-2.1 3.5-3.1 1.6-1.7 1.7-1.9 1.5-2.8-0.1-0.6-0.3-9.7-0.5-20.4-0.2-11.7-0.4-19.9-0.6-20.8-0.2-0.8-0.4-5.3-0.4-10.4 0-7.1-0.1-9.1-0.5-9.8-0.3-0.4-0.5-1.2-0.5-1.8s-0.3-1.2-0.7-1.7c-1.1-1-4.1-3-4.5-3-0.2 0-0.8-0.4-1.3-1-0.5-0.5-1.1-1-1.4-1s-1-0.4-1.6-1c-0.6-0.5-1.3-0.9-1.5-0.9s-0.6-0.2-0.8-0.5-0.6-0.5-0.9-0.5-1-0.4-1.5-1c-0.5-0.5-1.1-1-1.4-1s-1-0.4-1.6-1c-0.6-0.5-1.3-0.9-1.5-0.9s-0.7-0.4-1.1-0.8-1.2-1-1.6-1.3-2.1-1.5-3.6-2.8-3.3-2.8-4-3.3-1.9-1.8-2.7-2.8-2.1-2.6-2.9-3.5-1.5-1.9-1.5-2.2-0.2-0.7-0.5-0.9-0.5-0.7-0.5-1-0.2-0.7-0.5-1c-0.3-0.2-0.5-0.7-0.5-1s-0.2-0.7-0.5-1c-0.3-0.2-0.5-0.9-0.5-1.4s-0.2-1.2-0.5-1.4-0.5-0.7-0.5-1-0.2-0.7-0.5-1c-0.3-0.2-0.5-0.9-0.5-1.4s-0.2-1.2-0.5-1.4-0.5-0.9-0.5-1.4-0.2-1.2-0.5-1.4-0.5-0.7-0.5-1.1-0.2-1-0.5-1.3-0.5-0.9-0.5-1.3-0.2-0.9-0.5-1.2-0.5-0.9-0.5-1.4-0.2-1.2-0.5-1.4c-0.3-0.3-0.5-0.8-0.5-1.2s-0.2-1.1-0.4-1.5c-0.2-0.5-1-2.1-1.8-3.6s-1.5-2.9-1.6-3c-0.2-0.1-0.3-0.5-0.3-0.8s-0.2-0.8-0.5-1-0.5-0.6-0.5-0.9-0.4-0.9-1-1.5c-0.5-0.6-1-1.2-1-1.5 0-0.7-8.1-8.8-10.1-10.1-0.9-0.6-1.9-1.3-2.2-1.7s-0.8-0.7-1-0.7-1.4-0.6-2.5-1.4c-1.2-0.8-2.3-1.4-2.5-1.4s-0.6-0.2-0.9-0.4c-0.6-0.5-2.9-0.9-3.5-0.6-0.5 0.3 0.1 1.7 1.4 3.5 0.4 0.6 0.8 1.2 0.8 1.5s0.2 0.6 0.5 0.9c0.3 0.2 0.5 0.7 0.5 1.1s0.2 1 0.5 1.3 0.5 0.9 0.5 1.2 0.2 1 0.5 1.5c0.8 1.3 0.4 2-0.9 1.7-0.6-0.1-1.3-0.4-1.6-0.6s-0.7-0.4-0.8-0.4c-0.2 0-0.5-0.2-0.7-0.5s-0.7-0.5-1.1-0.5-0.9-0.2-1.1-0.5-0.7-0.5-1-0.5-0.7-0.2-1-0.5c-0.2-0.3-0.8-0.5-1.3-0.5s-1.1-0.2-1.3-0.5-0.7-0.5-1.1-0.5-0.9-0.2-1.1-0.5-0.9-0.5-1.4-0.5-1.2-0.2-1.4-0.5-0.9-0.5-1.4-0.5-1.2-0.2-1.4-0.5-0.7-0.5-1-0.5c-1.1 0-3.2-1.5-3.2-2.4s2.6-3.6 5-5.3c0.9-0.6 2.3-1.8 3.1-2.6s1.7-1.5 2-1.5c0.2 0 1.1-0.6 2-1.4s1.7-1.4 1.9-1.4 0.6-0.3 1.1-0.7c1.4-1.2 7.4-5.1 7.7-5.1 0.2 0 0.8-0.3 1.3-0.8 0.6-0.4 1.7-1.1 2.6-1.5s2-0.9 2.4-1.2c0.5-0.2 1.1-0.4 1.3-0.4s0.7-0.2 0.9-0.5 0.7-0.5 1-0.5 0.7-0.2 1-0.5 0.6-0.5 1-0.5c0.3 0 1.4-0.4 2.4-1 1-0.5 2.1-1 2.5-1s1-0.2 1.3-0.5 0.9-0.5 1.3-0.5 0.9-0.2 1.1-0.5 0.7-0.5 1.1-0.5 1-0.2 1.3-0.5 1-0.5 1.5-0.5 1-0.2 1.1-0.5 0.4-0.5 0.7-0.5c0.9 0 2.9-1.1 2.9-1.5 0-0.9-1.4-1.6-3.4-1.7-1.2 0-2.2-0.2-2.5-0.5-0.5-0.4-1.6-0.5-4.5-0.5-2.7 0-4.2-0.1-5-0.5-0.8-0.3-2.3-0.5-4.8-0.5h-3.7v-0.8c0-0.4 0.2-0.8 0.4-0.8s0.9-0.4 1.5-0.8 1.9-1.2 2.8-1.6c1-0.5 1.9-1 2.2-1.3 0.2-0.2 0.7-0.4 0.9-0.4 0.3 0 0.7-0.2 0.9-0.5 0.4-0.5 7.9-4.3 8.5-4.3 0.3 0 1.7-0.6 2.9-1.3 0.3-0.1 0.7-0.3 1-0.4s1.3-0.6 2.4-1.1 2.2-0.9 2.6-0.9 0.8-0.2 1.1-0.5c0.2-0.3 0.7-0.5 1.1-0.5s0.9-0.2 1.1-0.5 0.8-0.5 1.3-0.5c0.9 0 2.8-1.1 2.8-1.7 0-0.1-3.6-0.3-8.1-0.2-6.2 0-8.4 0.1-9.4 0.5-0.7 0.3-2.5 0.5-4 0.5-1.7 0-3 0.2-3.5 0.5-0.4 0.3-1.5 0.5-2.4 0.5s-1.9 0.2-2.2 0.5c-0.4 0.3-1.3 0.5-2.3 0.5-1.1 0-1.8 0.2-2 0.5-0.3 0.3-1 0.5-1.9 0.5-0.8 0-1.8 0.2-2.1 0.5s-1.1 0.5-1.6 0.5c-0.6 0-1.2 0.2-1.4 0.5s-0.8 0.5-1.3 0.5-1.1 0.2-1.3 0.5-0.9 0.5-1.4 0.5-1.2 0.2-1.4 0.5-0.9 0.5-1.4 0.5-1.2 0.2-1.4 0.5-0.7 0.5-1 0.5-0.7 0.2-1 0.5-0.7 0.5-1 0.5-0.7 0.2-1 0.5-0.7 0.5-1 0.5-0.7 0.2-1 0.5-0.8 0.5-1.3 0.5-1.3 0.4-2 0.9c-0.6 0.5-1.3 1-1.5 1-0.4 0-2.2 1.1-3.7 2.2-0.5 0.4-1.1 0.7-1.3 0.7s-1.1 0.6-2 1.4c-0.8 0.8-1.7 1.4-2 1.4-0.2 0-0.8 0.4-1.3 0.9s-1.5 1.3-2.2 1.8c-1.6 1-7.8 7.1-8.1 7.9-0.1 0.3-0.8 1.2-1.6 2.1-1.4 1.6-4 5.4-5.2 7.7-0.4 0.7-0.8 1.5-1 1.8s-0.4 0.8-0.6 1.1-0.5 0.9-0.6 1.2c-0.2 0.4-0.5 0.8-0.6 0.9-0.2 0.1-0.3 0.5-0.3 1 0 0.4-0.2 0.9-0.5 1.1s-0.5 0.6-0.5 0.9-0.2 0.8-0.5 1.2-2.4 1.8-2.4 2.5c0 0.8-0.2 1.5-0.5 1.7-0.7 0.6-0.7 9.1 0 10.1 0.3 0.4 0.5 1.4 0.5 2.6s0.2 2.2 0.5 2.6c0.3 0.3 0.5 0.9 0.5 1.3s0.2 0.9 0.5 1.1 0.5 0.8 0.5 1.3 0.2 1.1 0.5 1.3 0.5 0.6 0.5 0.8c0 1.2 7.6 10.1 8.6 10.1 0.2 0 1.1 0.6 1.9 1.4s1.8 1.5 2.1 1.6c0.4 0.1 1 0.5 1.5 1 0.5 0.4 1.2 0.9 1.6 1s1 0.4 1.2 0.7c0.2 0.2 0.7 0.4 1 0.4 0.7-0.1 0.8-1.6 0.2-2.2-0.3-0.2-0.5-0.9-0.5-1.5s-0.2-1.2-0.5-1.4-0.5-0.7-0.5-1-0.2-0.7-0.5-1c-0.4-0.3-0.5-0.9-0.4-2 0.1-1.6 0.1-1.6 1.1-1.7 0.5 0 2-0.3 3.2-0.6 1.9-0.4 2.6-0.5 4.8-0.1 1.4 0.2 4.4 0.5 6.6 0.6 2.6 0.1 4.2 0.4 4.5 0.6 0.2 0.2 1.1 0.4 2.1 0.4 1.1 0 1.8 0.2 2.1 0.5 0.2 0.3 0.9 0.5 1.6 0.5 0.6 0 1.5 0.2 1.8 0.5s0.9 0.5 1.3 0.5 0.9 0.2 1.1 0.5 0.7 0.5 1 0.5 0.7 0.2 1 0.5 0.6 0.5 0.9 0.5 0.8 0.3 1.1 0.6c0.3 0.4 0.8 0.6 1 0.6s1 0.6 1.8 1.2c0.8 0.7 1.6 1.4 1.9 1.5 0.7 0.4 5.4 5.7 6.1 7 0.3 0.6 0.9 1.3 1.2 1.7s0.6 0.9 0.6 1.2 0.2 0.7 0.5 0.9 0.5 0.7 0.5 1 0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.9 0.5 1.6 0 0.8 0.2 1.3 0.5 1.4s0.5 0.6 0.5 1.4 0.2 1.3 0.5 1.4 0.5 0.6 0.5 1.4c0 0.7 0.2 1.5 0.5 1.8 0.6 0.8 0.6 2.4 0 2.4-0.3 0-0.6-0.1-0.7-0.3s-0.6-0.3-1-0.3-1.2-0.3-1.6-0.6c-0.4-0.4-1.2-0.6-1.7-0.7-0.5 0-1.1-0.2-1.5-0.5s-1.4-0.5-3-0.5-2.6-0.2-3-0.5c-0.5-0.4-1.6-0.5-4.6-0.5-2.7 0-4.4-0.2-5.3-0.5s-2.8-0.5-6.9-0.5c-4.4 0-5.8-0.1-6.2-0.5-0.4-0.3-1.5-0.5-3.5-0.5-2.2 0-3-0.1-3.3-0.5-0.3-0.3-1-0.5-1.9-0.5s-1.7-0.2-1.9-0.5-0.9-0.5-1.4-0.5-1.2-0.2-1.4-0.5-0.7-0.5-1.1-0.5c-1.3 0-8.7-4.4-10.4-6.2-0.4-0.5-1.5-1.4-2.4-2s-2.5-2-3.6-3-2.2-1.8-2.4-1.8c-0.6 0.2-0.7 1.7-0.1 2.3 0.3 0.3 0.5 0.8 0.5 1.1s0.2 0.8 0.5 1 0.5 0.7 0.5 1 0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.6 0.5 0.8s0.7 1.2 1.6 2.2 1.6 1.9 1.6 2.1c0 0.5 6.1 6.7 6.5 6.7 0.2 0 0.9 0.4 1.5 0.9s1.3 1 1.6 1 0.9 0.4 1.4 1c0.6 0.7 1.2 1 1.9 1 0.6 0 1.2 0.2 1.4 0.5s0.8 0.5 1.3 0.5 1.1 0.2 1.3 0.5 0.9 0.5 1.4 0.5c1.1 0 1.8 0.5 1.8 1.2 0 0.5-1.3 1.6-1.8 1.7-0.2 0-1.3 0.7-2.5 1.5s-2.3 1.4-2.5 1.4-0.6 0.2-0.8 0.4c-0.4 0.5-3.9 2.2-5.3 2.7-1.3 0.4-1.8 1.2-1 2 0.9 1 3 2 4.2 2 0.6 0 1.6 0.2 2.2 0.5 1.7 0.7 15.6 0.7 17 0 0.5-0.3 1.7-0.5 2.7-0.5s2.2-0.2 2.7-0.5 1.6-0.5 2.5-0.5c1 0 2-0.3 2.8-0.7 2.2-1.2 4.3 0 2.7 1.5-0.3 0.3-0.5 0.7-0.5 1.1s-0.2 0.8-0.5 1-0.5 0.7-0.5 1-0.2 0.7-0.5 1c-0.3 0.2-0.5 0.7-0.5 1s-0.2 0.7-0.5 1-0.5 0.8-0.4 1.6l0.1 1.1 2.3 0.1c1.7 0.1 2.4 0 2.7-0.4 0.3-0.3 0.9-0.5 1.8-0.5 0.8 0 1.5-0.2 1.8-0.5 0.2-0.3 0.8-0.5 1.3-0.5s1.1-0.2 1.5-0.5 1-0.5 1.4-0.5c0.5 0 1.1-0.2 1.4-0.5s0.9-0.5 1.3-0.5 0.9-0.2 1.1-0.5 0.7-0.5 1-0.5 0.7-0.2 1-0.5 0.6-0.5 0.9-0.5 1-0.4 1.6-0.9 1.7-1.1 2.4-1.4l1.2-0.4 1.2 1.4c0.7 0.8 1.2 1.7 1.2 2s0.1 0.6 0.3 0.7c0.3 0.2 1.6 2.8 1.6 3.3 0 0.2 0.3 0.7 0.6 1s0.5 0.9 0.4 1.2c-0.1 0.2 0.1 0.9 0.5 1.5s0.7 1.4 0.7 1.8 0.2 1 0.5 1.4 0.5 1.3 0.5 2.4 0.2 2 0.5 2.4c0.4 0.5 0.5 1.7 0.5 5.1s-0.1 4.7-0.5 5.1c-0.3 0.4-0.5 1.3-0.5 2.4s-0.2 2-0.5 2.4c-0.3 0.3-0.5 0.9-0.5 1.2s-0.3 1.1-0.6 1.8-0.6 1.3-0.6 1.5c0 0.4-1 2.7-1.4 3.4-0.2 0.3-0.6 1.2-1.1 2-0.4 0.8-0.9 1.6-1.1 1.7s-0.3 0.5-0.3 0.8-0.4 1-1 1.5-1 1.1-1 1.4c0 0.6-12.8 13.6-14 14.2-0.5 0.2-1.3 0.7-1.7 1s-1 0.5-1.2 0.4c-0.5-0.3-0.4-1.8 0.1-2.6 0.3-0.3 0.5-1.3 0.5-2.1s0.2-1.7 0.5-2.1 0.5-1.3 0.5-2.2 0.2-1.9 0.5-2.2c0.3-0.4 0.5-1.5 0.5-3.4 0-1.7 0.2-3.3 0.5-4.1 0.6-1.6 0.6-3.6 0.1-5.1-0.2-0.6-0.4-1.8-0.6-2.7-0.1-1.1-0.4-1.6-0.7-1.6s-0.5 0.3-0.6 0.6c-0.1 0.4-0.5 1.2-1 1.8s-0.9 1.3-0.9 1.4-0.4 0.8-1 1.4-1 1.4-1 1.5c0 0.2-0.6 1-1.4 1.9s-1.4 1.8-1.4 2-1.2 1.6-2.7 3.1c-2.7 2.7-3.7 3.2-4.6 2.3-0.5-0.5-0.5-2.3 0.1-2.8 0.3-0.3 0.5-1 0.5-1.9 0-1 0.2-1.7 0.5-1.9 0.3-0.3 0.5-1 0.5-2.2 0-1 0.2-2.1 0.4-2.4 0.5-0.7 1-9.6 0.7-10.9-0.2-0.6-0.4-0.7-3.6-0.8-2.4-0.1-3.7-0.3-4.1-0.6-0.5-0.4-1.3-0.5-3-0.3-1.8 0.1-2.6 0-3.6-0.4-0.8-0.4-2-0.6-3.4-0.6-1.6 0-2.3-0.2-2.7-0.6s-1.1-0.6-2.1-0.6c-0.9 0-1.6-0.2-1.9-0.5s-0.7-0.4-1.3-0.3-1.1 0-1.6-0.5c-0.4-0.3-1.1-0.6-1.6-0.6s-1.1-0.2-1.3-0.5-0.8-0.5-1.3-0.5-1.1-0.2-1.5-0.5-0.9-0.5-1.2-0.5-0.8-0.2-1.1-0.5-0.8-0.5-1.1-0.5-0.6-0.1-0.6-0.3-0.4-0.5-0.9-0.7c-1.2-0.5-3.6-1.9-4.9-3-0.6-0.5-1.3-0.9-1.4-0.9-0.2 0-0.8-0.4-1.4-1-0.6-0.5-1.2-0.9-1.4-0.9s-1.3-1-2.6-2.2-2.7-2.5-3.2-3c-1.3-1.2-6.5-6.9-7.7-8.5-0.5-0.7-1.6-2-2.3-2.8-0.8-0.9-1.4-1.7-1.4-1.9s-0.4-0.7-0.8-1.2c-0.5-0.4-1.5-1.7-2.3-2.8-1.1-1.5-1.6-2-2.1-1.9-0.6 0.1-0.7 0.3-0.8 1.9-0.1 1.3 0.1 2.1 0.4 2.6s0.5 1.5 0.5 3.2c0 1.8 0.1 2.6 0.5 2.8 0.3 0.3 0.5 1 0.5 2s0.2 1.9 0.5 2.4c0.7 1 0.5 4.3-0.2 4.5-0.7 0.1-3.7-1.9-4.7-3.2-0.4-0.6-1.1-1.4-1.5-1.8s-0.7-0.9-0.7-1-0.6-0.9-1.4-1.7-1.5-1.8-1.6-2.1-0.8-1.2-1.5-2-1.3-1.6-1.3-1.9-0.4-0.9-1-1.4c-0.5-0.5-1-1.2-1-1.5s-0.2-0.7-0.5-0.8-0.5-0.5-0.5-1c0-0.4-0.2-0.9-0.5-1s-0.5-0.4-0.5-0.8c0-0.3-0.2-0.7-0.5-1-0.3-0.2-0.5-0.6-0.5-0.9s-0.2-0.8-0.5-1.2c-0.3-0.3-0.5-1.1-0.5-1.6 0-0.6-0.2-1.2-0.5-1.4-0.3-0.3-0.5-1.1-0.5-2.8 0-1.4-0.2-2.8-0.5-3.5-0.7-1.6-0.7-15.4 0-18.2 0.3-1.1 0.5-2.7 0.5-3.7s0.2-2.2 0.5-2.7 0.5-1.6 0.5-2.4c0-0.9 0.2-1.6 0.5-1.9s0.5-1 0.5-2.1c0-0.9 0.2-2.1 0.5-2.7 0.6-1.3 0.4-2.1-0.4-1.7-1.1 0.6-8.9 8.9-9.5 10.1-0.4 0.7-0.8 1.3-1 1.4s-0.4 0.4-0.4 0.7-0.1 0.7-0.3 0.8c-0.3 0.2-1.6 2.8-1.6 3.3 0 0.2-0.2 0.5-0.5 0.7s-0.5 0.7-0.5 1.1-0.2 0.9-0.5 1.1-0.5 0.6-0.5 0.9-0.2 0.8-0.5 1.2c-0.3 0.3-0.5 1-0.5 1.5s-0.2 1-0.5 1.2-0.5 0.6-0.5 0.9c0 0.7-0.9 2-1.5 2-0.3 0-0.5-0.3-0.5-0.7s-0.2-0.9-0.5-1.2c-0.4-0.5-0.5-2.2-0.5-12.9 0-10.9 0-12.4 0.5-13.1 0.3-0.5 0.5-1.4 0.5-2.7 0-1.2 0.2-2.2 0.5-2.5 0.3-0.4 0.5-1.4 0.5-2.6s0.2-2.2 0.5-2.6c0.3-0.3 0.5-1.2 0.5-1.8 0-0.7 0.2-1.4 0.5-1.6s0.5-0.9 0.5-1.6c0-0.6 0.2-1.5 0.5-1.8s0.5-1.1 0.5-1.7 0.2-1.4 0.5-1.7 0.5-1 0.5-1.5 0.2-1.1 0.5-1.4 0.5-0.8 0.5-1.1 0.2-0.9 0.5-1.2 0.5-1 0.5-1.5 0.2-1 0.5-1.2 0.5-0.8 0.5-1.3 0.2-1.1 0.5-1.5c0.3-0.3 0.5-0.9 0.5-1.1 0-0.3 0.2-0.7 0.5-0.9s0.5-0.7 0.5-1.1 0.2-0.9 0.5-1.1 0.5-0.7 0.5-1c0-0.5 1.4-3.6 2.3-5.1 0.2-0.3 0.4-0.7 0.5-1 0.5-1.3 1.6-3.4 2-3.8 0.2-0.2 0.4-0.6 0.4-0.9s0.2-0.7 0.5-1 0.5-0.8 0.5-1.1 0.1-0.6 0.3-0.6c0.1 0 0.7-0.8 1.1-1.8 1.2-2.5 2.4-4.6 2.9-5.2 0.3-0.3 0.5-0.7 0.5-0.9s0.6-1.3 1.4-2.5 1.4-2.3 1.4-2.5 0.4-0.8 1-1.3c0.5-0.5 1-1.2 1-1.5s0.2-0.7 0.5-0.9 0.5-0.5 0.5-0.7 0.4-0.9 1-1.5 1-1.3 1-1.4 0.4-0.8 1-1.4 1-1.4 1-1.7c0-0.2 0.4-0.9 1-1.4s1-1.2 1-1.5 0.2-0.7 0.5-0.9c0.6-0.5 0.6-2.7 0-3.2-0.3-0.2-0.5-0.7-0.5-1.1s-0.2-1-0.5-1.3-0.5-0.9-0.5-1.3-0.2-0.9-0.5-1.1-0.5-0.7-0.5-1-0.2-0.7-0.5-1c-0.3-0.2-0.5-0.9-0.5-1.4s-0.2-1.2-0.5-1.4-0.5-0.9-0.5-1.4-0.2-1.2-0.5-1.4-0.5-0.9-0.5-1.4-0.2-1.2-0.5-1.4c-0.3-0.3-0.5-1-0.5-2 0-0.9-0.2-1.9-0.5-2.3s-0.5-1.4-0.5-2.6c0-1.1-0.2-2.2-0.4-2.6-0.4-0.6-0.8-7.7-0.9-13.9 0-4 0.6-13.4 0.9-14 0.2-0.4 0.4-1.5 0.4-2.6 0-1.2 0.2-2.1 0.5-2.5s0.5-1.3 0.5-2.2 0.2-1.9 0.5-2.2 0.5-1.3 0.5-2.1c0-0.9 0.3-1.9 0.7-2.5 0.7-1.1 1.3-1.1 1.3-0.1 0 0.3 0.2 0.8 0.5 1s0.5 0.9 0.5 1.4c0 0.6 0.2 1.2 0.5 1.4s0.5 0.9 0.5 1.4c0 0.6 0.2 1.2 0.5 1.4s0.5 0.7 0.5 1.1 0.2 0.9 0.5 1.1 0.5 0.8 0.5 1.3 0.2 1.1 0.5 1.3 0.5 0.8 0.5 1.3 0.2 1.1 0.5 1.5 0.5 0.9 0.5 1.1c0 0.3 0.2 0.7 0.5 0.9s0.5 0.7 0.5 1.1 0.2 1 0.5 1.3 0.5 0.9 0.5 1.3 0.2 0.9 0.5 1.1 0.5 0.7 0.5 1.2 0.2 0.9 0.5 1 0.5 0.5 0.5 0.9 0.2 0.9 0.5 1.1 0.5 0.7 0.5 1 0.2 0.7 0.5 1 0.5 0.7 0.5 1 0.1 0.7 0.3 0.8 1 1.5 1.8 3.2 1.6 3.1 1.8 3.2 0.3 0.4 0.3 0.8 0.2 0.8 0.5 1 0.5 0.6 0.5 0.9 0.4 1 1 1.6c0.5 0.6 1 1.3 1 1.5s0.2 0.6 0.5 0.8 0.5 0.6 0.5 0.9 0.4 1 1 1.6c0.5 0.6 1 1.2 1 1.4s0.4 0.8 1 1.4c0.5 0.6 1 1.3 1 1.5s0.4 0.8 1 1.3c0.5 0.5 1 1.1 1 1.4s0.6 1.2 1.4 2.1 1.4 1.8 1.4 2 0.4 0.8 1 1.3c0.5 0.6 1 1.2 1 1.4s0.2 0.6 0.4 0.9c0.3 0.5 0.2 0.8-0.5 1.8-0.5 0.7-0.8 1.4-0.8 1.6s-0.2 0.5-0.5 0.8c-0.3 0.2-0.5 0.6-0.5 0.8s-0.4 1-0.9 1.8-1.2 1.9-1.5 2.5-1.2 2-1.9 3-1.4 2.2-1.6 2.5c-1.1 1.9-4.3 6.3-5.9 8.2-0.5 0.6-1.2 1.5-1.5 2.1-0.4 0.6-1.3 1.7-2 2.5s-1.4 1.7-1.4 1.9-0.4 0.8-0.8 1.2c-0.9 0.9-1 1.6-0.2 1.6 0.6 0 12.6-6 12.9-6.4 0.1-0.1 0.5-0.4 1-0.5 0.4-0.1 1.2-0.5 1.6-0.9 1.3-1 3.2-2.2 3.5-2.2 0.2 0 1.1-0.6 2.1-1.3 2-1.4 2.5-1.7 5.6-3.7 1.2-0.7 2.4-1.7 2.7-2 0.3-0.4 0.8-0.7 0.9-0.7 0.2 0 1.2-0.7 2.2-1.6s2-1.6 2.1-1.6 1.2-0.9 2.4-1.9c1.2-1.1 2.3-1.9 2.5-1.9 0.5 0 10.5-9.9 10.5-10.4 0-0.2 0.6-1.1 1.4-2s1.4-1.8 1.4-2 0.3-0.6 0.6-0.8c0.5-0.4 0.4-0.5-0.9-2-0.8-0.8-3.1-3.3-5.1-5.5s-6.2-6.6-9.3-9.8-5.7-6-5.7-6.2-1.1-1.5-2.4-2.9-2.4-2.7-2.4-2.9-0.9-1.2-1.9-2.3-1.9-2.1-1.9-2.3-0.7-1.2-1.6-2.2-1.6-1.9-1.6-2.1-0.6-1.1-1.4-1.9-1.4-1.7-1.4-2-0.4-0.8-0.8-1.2-1-1.2-1.3-1.7-1-1.5-1.6-2.2-1.1-1.4-1.1-1.6-0.4-0.9-1-1.5c-0.5-0.7-1-1.3-1-1.4s-0.4-0.8-1-1.4-1-1.3-1-1.4-0.4-0.8-1-1.4c-0.5-0.7-1-1.3-1-1.4s-0.6-1.1-1.4-2.3-1.4-2.3-1.4-2.5-0.4-0.9-1-1.4c-0.5-0.6-1-1.2-1-1.5s-0.4-0.9-0.8-1.4c-0.5-0.5-1-1.3-1.2-1.8s-0.5-0.9-0.6-0.9c-0.2 0-0.3-0.2-0.3-0.4s-0.5-1.1-1.1-2-1.1-1.8-1.1-2-0.1-0.4-0.3-0.4-0.4-0.3-0.5-0.7-0.6-1.2-1.1-1.9c-0.5-0.6-0.9-1.4-0.9-1.6s-0.4-0.9-1-1.4-1-1.1-1-1.3c0-0.4-3.3-4.3-4-4.7s-1.7 0-1.7 0.7c0 0.3-0.4 1-1 1.5s-1 1.2-1 1.5-0.2 0.7-0.5 0.9-0.5 0.7-0.5 1-0.2 0.7-0.5 1-0.5 0.7-0.5 1-0.2 0.7-0.5 1-0.5 0.6-0.5 1c0 0.3-0.3 0.9-0.6 1.3-0.4 0.4-0.6 1-0.7 1.2 0 0.3-0.2 0.8-0.5 1.1s-0.5 0.9-0.5 1.2-0.2 1-0.4 1.5c-0.9 1.8-1.5 3.3-1.5 3.9 0 0.3-0.2 0.8-0.5 1s-2.4 0.1-2.4 0.6c0 0.6-0.2 1.2-0.5 1.4s-0.5 0.9-0.5 1.5-0.2 1.2-0.5 1.4c-0.3 0.3-0.5 1-0.5 1.9 0 1-0.2 1.7-0.5 1.9-0.3 0.3-0.5 1-0.5 1.9 0 1-0.2 1.7-0.5 1.9-0.3 0.3-0.5 1-0.5 2 0 0.9-0.2 1.9-0.5 2.3s-0.5 1.5-0.5 3.5c0 1.9-0.2 3.2-0.5 3.7-0.4 0.6-0.5 2.5-0.4 9.3 0 4.7 0.2 9.2 0.3 10.1 0.2 0.9 0.4 4.3 0.5 7.5 0.1 3.8 0.4 6.2 0.6 6.6s0.4 1.9 0.4 4c0 2.4 0.1 3.5 0.5 3.9 0.3 0.4 0.5 1.4 0.5 2.7s0.2 2.3 0.5 2.7 0.5 1.3 0.5 2.4 0.2 2.1 0.5 2.5c0.3 0.5 0.5 1.2 0.4 2.2-0.1 1.4-0.2 1.5-1 1.6-0.6 0.1-1.2-0.2-2.1-0.9-0.7-0.5-1.4-1-1.5-1-0.2 0-0.6-0.3-1-0.7-0.3-0.4-1.6-1.4-2.8-2.4-3-2.3-13-12.2-14.4-14.3-0.6-0.9-1.4-2-1.8-2.3s-0.7-0.8-0.7-1-0.6-1.4-1.4-2.5c-0.8-1.2-1.4-2.3-1.5-2.5 0-0.2-0.2-0.7-0.5-1s-0.5-1-0.5-1.5-0.2-1-0.5-1.3-0.5-0.7-0.5-1.1-0.2-1-0.5-1.3c-0.3-0.4-0.5-1.3-0.5-2.3 0-1.1-0.2-1.8-0.5-2.1s-0.5-1-0.5-2.6c0-1.9-0.1-2.2-0.6-2.3s-0.6-0.4-0.6-2c0-1.4 0.1-1.8 0.5-1.8 0.5 0 2.7 2.2 2.7 2.7 0 0.2 0.6 1 1.4 1.9s1.7 2.1 2.1 2.7c0.8 1.3 6.2 6.7 6.8 6.7 0.4 0 0.5-2.1 0-2.4-0.2-0.1-0.3-1.4-0.3-2.9 0-2-0.1-2.8-0.5-3.1s-0.5-1.2-0.5-3.7c0-2.4-0.1-3.4-0.5-3.9-0.5-0.7-0.6-2.9-0.2-5.9 0.2-1.1 0.4-4 0.5-6.4 0.1-2.5 0.4-4.6 0.7-5.1 0.2-0.5 0.4-1.7 0.4-2.7 0-1.2 0.2-2.2 0.5-2.5s0.5-1.3 0.5-2.1 0.2-1.8 0.5-2.1 0.5-1.3 0.5-2.1c0-0.9 0.2-1.6 0.5-1.9 0.3-0.2 0.5-0.9 0.5-1.4 0-0.6 0.2-1.2 0.5-1.4s0.5-0.9 0.5-1.4c0-0.6 0.2-1.2 0.5-1.4s0.5-0.9 0.5-1.4c0-0.6 0.2-1.2 0.5-1.4s0.5-0.8 0.5-1.3 0.2-1.1 0.5-1.3 0.5-0.6 0.5-0.9 0.2-0.8 0.5-1.1 0.5-1 0.5-1.5 0.2-1 0.5-1.3 0.5-0.7 0.5-1 0.2-0.7 0.5-1 0.5-0.7 0.5-1.1 0.2-0.9 0.5-1.1 0.5-0.6 0.5-0.8 0.2-0.6 0.5-0.8 0.5-0.7 0.5-1 0.2-0.7 0.5-1 0.5-0.7 0.5-1 0.2-0.8 0.5-1.1 0.5-0.7 0.5-0.9 0.2-0.6 0.5-0.9 0.5-0.6 0.5-0.8c0-0.4 1.6-2.9 2.7-4.5 0.3-0.3 0.5-0.8 0.5-1s0.4-0.8 1-1.4c0.5-0.6 1-1.2 1-1.4s0.4-0.9 0.9-1.5 1-1.3 1-1.6 0.7-1.1 1.5-1.9 1.4-1.6 1.4-1.9 1.4-1.9 3.1-3.7 4.3-4.4 5.7-5.9c3.4-3.6 8.7-8.4 9.9-9.1 0.5-0.3 1.2-0.7 1.4-1 0.6-0.7 2.7-0.7 3.3 0.1 0.6 0.7 1.9 3.2 1.9 3.6 0 0.2 0.2 0.5 0.5 0.8s0.5 0.9 0.5 1.4 0.2 1.1 0.5 1.3 0.5 0.7 0.5 1 0.2 0.8 0.5 1.1 0.5 0.8 0.5 1.1 0.1 0.6 0.3 0.6 0.4 0.3 0.5 0.7 0.6 1.2 1.1 1.8 1 1.4 1.2 1.7c1.1 1.9 3 4.5 4.1 5.6 0.7 0.8 1.5 1.7 1.7 2.1 0.9 1.7 15 16.5 19.2 20.2 1.4 1.2 4.5 4.1 6.9 6.5 2.4 2.3 5.1 4.8 6.1 5.5s3 2.5 4.5 3.9 2.9 2.6 3 2.6c0.2 0 1.3 0.9 2.5 2.1 1.2 1.1 2.8 2.5 3.6 3s2.1 1.7 3 2.5c0.9 0.9 2.2 1.9 3 2.4s2.2 1.6 3.1 2.6c0.9 0.9 2 1.8 2.4 1.9s1.3 0.8 2.1 1.6 1.6 1.4 1.8 1.4 1.1 0.6 1.9 1.4 1.8 1.4 2.1 1.4 0.7 0.2 0.8 0.4 0.8 0.6 1.4 0.9 1.7 0.8 2.3 1.1c1.1 0.6 1.3 0.6 2.1 0.1 0.5-0.3 1.4-0.5 2-0.5s1.4-0.2 1.7-0.5 1.1-0.5 1.6-0.5 1.3-0.2 1.6-0.5 1.1-0.5 1.8-0.5c0.6 0 1.4-0.2 1.8-0.5 0.3-0.3 1.2-0.5 1.9-0.5s1.6-0.2 1.9-0.5 1.2-0.5 1.9-0.5 1.6-0.2 1.9-0.5c0.4-0.3 1.3-0.5 2.3-0.5 0.9 0 2-0.2 2.4-0.4 0.5-0.3 2-0.5 4.2-0.6 1.9-0.1 3.8-0.3 4.2-0.5 1.1-0.6 44-0.4 44.6 0.2 0.3 0.3 1.6 0.4 4.1 0.4 2.8 0 3.9 0.1 4.3 0.5 0.4 0.3 1.3 0.5 2.4 0.5s2 0.2 2.4 0.5c0.3 0.3 1.2 0.5 1.9 0.5s1.6 0.2 1.9 0.5 1.2 0.5 1.9 0.5 1.6 0.2 1.9 0.5 1.1 0.5 1.8 0.5c0.6 0 1.3 0.2 1.6 0.5 0.2 0.3 0.9 0.5 1.7 0.5 0.7 0 1.6 0.2 2 0.5 0.3 0.3 1.1 0.5 1.7 0.5s1.5 0.2 2 0.5c1.7 0.9 2.9 0.7 4.4-0.8 0.8-0.7 1.6-1.3 1.8-1.3s1.1-0.7 2-1.5 2.2-1.9 3-2.4 1.9-1.4 2.4-1.9c0.6-0.6 1.7-1.5 2.6-2.1s2.2-1.7 2.9-2.4 1.9-1.7 2.7-2.2 2.3-1.7 3.3-2.7 2.6-2.3 3.4-2.8c0.8-0.6 2.2-1.7 3-2.7 0.9-0.9 2.2-2.1 3-2.6s2.7-2.2 4.3-3.7 3.8-3.5 4.9-4.3c2.5-2 26-25.6 26-26.1 0-0.2 0.9-1.3 1.9-2.5s1.9-2.2 1.9-2.4 0.6-1 1.4-1.9 1.4-1.8 1.4-2 0.4-0.8 1-1.3c0.5-0.6 1-1.2 1-1.5s0.1-0.6 0.3-0.7c0.2-0.2 0.7-1 1.1-1.8s0.9-1.7 1.1-2.1c1-1.8 1.7-3.4 1.7-3.9 0-0.3 0.2-0.8 0.5-1.2 0.3-0.3 0.5-1.2 0.5-1.8 0-0.9 0.2-1.3 1-1.9 0.5-0.4 1-0.9 1-1.1 0-0.7 0.5-0.5 0.7 0.2 0.1 0.4 0.4 0.6 0.9 0.6 0.4 0 1.1 0.3 1.4 0.7s1.3 1.1 2.2 1.7c2.1 1.3 14.1 13.3 15.4 15.4 0.6 0.9 1.5 2.1 2.2 2.8s1.1 1.3 1.1 1.5 0.5 0.9 1.1 1.8 1.1 1.6 1.1 1.7 0.4 0.7 1 1.3c0.5 0.6 1 1.2 1 1.4s0.4 0.9 1 1.6c0.5 0.7 1 1.4 1 1.7s0.2 0.6 0.5 0.7 0.5 0.4 0.5 0.7 0.4 1.1 1 1.7c0.5 0.7 1 1.4 1 1.7s0.2 0.6 0.5 0.7 0.5 0.5 0.5 1 0.2 0.9 0.5 1 0.5 0.6 0.5 1 0.2 0.9 0.5 1 0.5 0.5 0.5 0.9 0.2 0.9 0.5 1.1 0.5 0.7 0.5 1 0.2 0.7 0.5 1 0.5 0.7 0.5 1.1 0.2 1 0.5 1.3 0.5 0.9 0.5 1.1c0 0.3 0.2 0.7 0.5 0.9s0.5 0.7 0.5 1.1 0.2 0.9 0.5 1.1 0.5 0.8 0.5 1.3 0.2 1.1 0.5 1.4 0.5 0.8 0.5 1.1 0.2 0.8 0.5 1 0.5 0.9 0.5 1.4c0 0.6 0.2 1.2 0.5 1.4s0.5 0.9 0.5 1.4 0.2 1.3 0.5 1.6 0.5 1.1 0.5 1.8c0 0.6 0.2 1.4 0.5 1.8 0.3 0.3 0.5 1.2 0.5 1.9s0.2 1.6 0.5 1.9 0.5 1.3 0.5 2.2 0.2 2 0.5 2.6 0.5 2.6 0.6 5.2c0.1 2.7 0.4 4.7 0.7 5.7 0.8 2.1 0.6 14.2-0.3 16-0.3 0.7-0.5 1.9-0.5 2.7s-0.2 1.8-0.5 2.2-0.5 1.3-0.5 2.3c0 2.5 0.7 2.6 2.6 0.4 0.8-0.9 1.5-1.9 1.5-2.1s0.9-1.2 1.9-2.2 1.9-2.1 1.9-2.4 0.7-1.1 1.5-1.9 1.7-2 2.1-2.6c0.6-1.2 1.2-1.6 1.3-0.8v6.1c0 4.3-0.2 6-0.5 6.6-0.3 0.5-0.5 1.8-0.5 3.2 0 1.5-0.2 2.5-0.5 3-0.3 0.4-0.5 1.3-0.5 2.4 0 1.2-0.2 1.9-0.5 2.2-0.3 0.2-0.5 0.9-0.5 1.6s-0.2 1.4-0.5 1.6-0.5 0.9-0.5 1.4-0.2 1.2-0.5 1.4-0.5 0.8-0.5 1.3-0.2 1.1-0.5 1.4-0.5 0.8-0.5 1.1-0.2 0.8-0.5 1-0.5 0.7-0.5 1-0.2 0.7-0.5 1c-0.3 0.2-0.5 0.7-0.5 1s-0.2 0.7-0.5 1c-0.3 0.2-0.5 0.6-0.5 0.8s-0.4 1-0.9 1.8-1.2 2-1.6 2.7-0.9 1.5-1.2 1.7-0.5 0.5-0.5 0.7c0 0.5-2.6 4.1-4.7 6.3-2.1 2.3-2.6 3.6-1.5 4.5 0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.6 0.5 0.8s0.6 1.4 1.4 2.5 1.5 2.3 1.6 2.6 0.5 1 1 1.4c0.4 0.5 0.8 1 0.8 1.2s0.7 1.3 1.5 2.5 1.6 2.4 1.8 2.8c0.5 1.1 2 3.5 2.4 3.9 0.2 0.2 0.4 0.6 0.4 0.8s0.2 0.6 0.5 0.8 0.5 0.6 0.5 0.8 0.4 1 1 1.8c0.5 0.7 1 1.5 1 1.7s0.2 0.5 0.5 0.6 0.5 0.5 0.5 1c0 0.4 0.2 1 0.5 1.2s0.5 0.7 0.5 1 0.2 0.7 0.5 0.8 0.5 0.4 0.5 0.8 0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1.1s0.2 0.9 0.5 1.1 0.5 0.7 0.5 1 0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1s0.2 0.7 0.5 1c0.3 0.2 0.5 0.7 0.5 1.2s0.4 1.6 1 2.6c0.5 1 1 1.9 1 2.1s0.2 0.6 0.5 0.9 0.6 1 0.6 1.5c0.1 0.5 0.6 1.7 1.1 2.7s1 2.2 1 2.6 0.2 0.9 0.5 1.2c0.3 0.2 0.5 0.9 0.5 1.4s0.2 1.2 0.5 1.4 0.5 0.9 0.5 1.4 0.2 1.2 0.5 1.4 0.5 0.9 0.5 1.4 0.2 1.2 0.5 1.4 0.5 0.9 0.5 1.4 0.2 1.2 0.5 1.4 0.5 0.9 0.5 1.4 0.2 1.2 0.5 1.4 0.5 0.9 0.5 1.6 0.2 1.4 0.5 1.6c0.3 0.3 0.5 1 0.5 1.9 0 1 0.2 1.7 0.5 1.9s0.5 0.9 0.5 1.6 0.2 1.4 0.5 1.6c0.3 0.3 0.5 1 0.5 1.9 0 1 0.2 1.7 0.5 1.9 0.3 0.3 0.5 1 0.5 2.3 0 1.7 0.1 1.9 0.8 2.2 0.8 0.3 0.8 0.4 0.8 3v2.6l-1.2 0.6c-1.5 0.7-3.5 0.7-4.3 0.1-0.4-0.3-1.5-0.5-3.4-0.5s-2.9-0.2-3.4-0.5c-0.8-0.6-4-0.6-4.6-0.1-0.5 0.5-0.5 2.6 0.1 3.3 0.3 0.3 0.5 1 0.5 1.4 0 0.5 0.2 1.1 0.5 1.4s0.5 1 0.5 1.4 0.2 1.1 0.4 1.6 0.7 1.3 1 1.9 0.5 1.4 0.5 1.8 0.3 1.1 0.6 1.5c0.4 0.4 0.6 1.2 0.7 1.6 0 0.4 0.2 1 0.5 1.4 0.3 0.3 0.5 1 0.5 1.4 0 0.5 0.2 1.1 0.5 1.4s0.5 1 0.5 1.5 0.2 1.1 0.5 1.4 0.5 1 0.5 1.5 0.2 1.2 0.5 1.5 0.5 0.9 0.5 1.4 0.2 1.2 0.5 1.4c0.3 0.3 0.5 1 0.5 1.9s0.2 1.7 0.5 1.9c0.3 0.3 0.5 1 0.5 2 0 0.9 0.2 1.9 0.5 2.3s0.5 1.3 0.5 2.4 0.2 2 0.5 2.4 0.5 1.4 0.5 3.3c0 1.7 0.2 2.9 0.5 3.4s0.5 2.4 0.6 7.4c0.1 4 0.3 7.1 0.5 7.6 0.6 1.4 0.5 18.8-0.1 22.5-0.3 1.9-0.5 5.2-0.5 9.5 0 5.3-0.1 6.7-0.5 7.2-0.3 0.4-0.5 1.4-0.5 2.8 0 1.3-0.2 2.6-0.5 3-0.3 0.5-0.5 1.1-0.6 1.4-0.2 0.7-0.8 0.4-0.8-0.4 0-0.3-0.2-0.8-0.5-1s-0.5-0.7-0.5-1-0.2-0.7-0.5-1c-0.3-0.2-0.5-0.7-0.5-1s-0.2-0.7-0.5-1c-0.3-0.2-0.5-0.7-0.5-1s-0.2-0.7-0.5-1c-0.3-0.2-0.5-0.7-0.5-1s-0.2-0.7-0.5-1c-0.3-0.2-0.5-0.7-0.5-1s-0.2-0.7-0.5-1c-0.3-0.2-0.5-0.6-0.5-0.9s-0.4-1-1-1.7c-0.5-0.7-1-1.4-1-1.5s-0.2-0.5-0.5-0.7-0.5-0.6-0.5-0.9-0.4-1-0.9-1.6-1-1.5-1.1-1.9-0.3-0.7-0.5-0.7-0.3-0.3-0.4-0.7-0.6-1.2-1.2-1.8c-0.5-0.6-1-1.2-1-1.4s-0.3-0.7-0.7-1.1-1-1.4-1.4-2.1-0.9-1.3-1.2-1.4c-0.5-0.1-0.5 0.3-0.5 2.6 0 1.7-0.2 3-0.5 3.5-0.3 0.6-0.5 2-0.5 4.8s-0.2 4.2-0.5 4.8-0.5 1.9-0.5 4.8c0 3-0.1 4.2-0.5 4.6-0.3 0.5-0.5 1.5-0.5 4 0 2.6-0.1 3.5-0.5 3.8s-0.5 1.2-0.5 3.6c0 2.3-0.1 3.4-0.5 3.9-0.3 0.4-0.5 1.4-0.5 2.9s-0.2 2.5-0.5 2.9-0.5 1.3-0.5 2.3c0 1.1-0.2 1.8-0.5 2-0.3 0.3-0.5 1-0.5 2.3 0 1.2-0.2 2-0.5 2.3s-0.5 1.1-0.5 1.9-0.2 1.6-0.5 1.9-0.5 0.9-0.5 1.4-0.2 1.2-0.5 1.5-0.5 1.1-0.5 1.8c0 0.6-0.2 1.4-0.5 1.8-0.3 0.3-0.5 1.1-0.5 1.6s-0.2 1.3-0.5 1.6-0.5 0.8-0.5 1.1-0.2 0.9-0.5 1.4-0.5 1.2-0.6 1.6-0.4 1.1-0.6 1.6c-0.3 0.5-0.5 1.3-0.5 1.6 0 0.4-0.2 0.9-0.5 1.1s-0.5 0.8-0.5 1.2c0 0.5-0.2 1.1-0.5 1.5-0.3 0.3-0.5 0.9-0.5 1.2s-0.1 0.6-0.3 0.6-0.4 0.3-0.5 0.7c-0.2 0.7-0.8 2.2-1.6 3.9-0.2 0.5-0.4 1.2-0.4 1.5s-0.2 0.8-0.5 1-0.5 0.7-0.5 1-0.2 0.7-0.5 1c-0.3 0.2-0.5 0.7-0.5 1s-0.2 0.7-0.5 1c-0.3 0.2-0.5 0.7-0.5 1s-0.2 0.7-0.5 1c-0.3 0.2-0.5 0.7-0.5 1s-0.2 0.7-0.5 1c-0.3 0.2-0.5 0.6-0.5 0.8s-0.4 1-0.8 1.6c-0.5 0.7-1 1.5-1.1 1.9-0.3 0.7-0.5 1-2.4 3.9-0.7 1.1-1.4 2.2-1.4 2.3 0 0.3-4 6.3-5.1 7.7-0.4 0.4-0.6 0.9-0.7 1.1 0 0.2-0.5 0.8-1.1 1.5s-1.1 1.4-1.1 1.7c0 0.2-0.7 1.1-1.6 2s-1.8 2-2 2.4c-0.2 0.5-1.2 1.7-2.2 2.8s-2.1 2.4-2.4 2.8c-0.8 1.3-24.2 24.7-24.7 24.7-0.2 0-2 1.5-3.9 3.4s-4.1 3.8-4.9 4.3-2 1.6-2.9 2.5-1.8 1.6-2 1.6-1.1 0.6-2 1.4c-1.7 1.6-2 1.7-2.6 1-0.3-0.4-0.2-0.7 0.6-1.7 0.5-0.7 1.1-1.6 1.3-2 0.5-1.2 1.6-2.9 2.3-3.7 0.3-0.4 0.6-0.9 0.6-1.1s0.4-0.9 1-1.4c0.5-0.5 1-1.2 1-1.5s0.2-0.7 0.5-0.9 0.5-0.5 0.5-0.7 0.4-0.9 1-1.5c0.5-0.7 1-1.4 1-1.7 0-0.2 0.4-0.9 1-1.4 0.5-0.5 1-1.2 1-1.5s0.2-0.7 0.5-0.9 0.5-0.5 0.5-0.7 0.4-0.9 1-1.5c0.5-0.7 1-1.4 1-1.7s0.2-0.7 0.5-0.9 0.5-0.5 0.5-0.7 0.4-0.9 1-1.5c0.5-0.7 1-1.4 1-1.7s0.2-0.7 0.5-0.9 0.5-0.7 0.5-1 0.2-0.7 0.5-1c0.3-0.2 0.5-0.7 0.5-1s0.2-0.7 0.5-1c0.3-0.2 0.5-0.5 0.5-0.7s0.6-1.4 1.4-2.7 1.4-2.4 1.4-2.5c0-0.3 1.2-3 2.3-5 0.5-1 0.9-2.1 0.9-2.3 0-0.3 0.1-0.5 0.3-0.5s0.4-0.4 0.5-0.9 0.4-1.1 0.6-1.3 0.4-0.7 0.4-1 0.2-0.8 0.5-1 0.5-0.7 0.5-1.1 0.2-1.2 0.5-1.7 0.7-1.4 1-2c0.3-0.5 0.5-1.3 0.5-1.7s0.2-0.9 0.5-1.1 0.5-0.8 0.5-1.3 0.2-1.1 0.5-1.3 0.5-0.8 0.5-1.3 0.2-1.1 0.5-1.3 0.5-0.9 0.5-1.6 0.2-1.4 0.5-1.6 0.5-0.9 0.5-1.6 0.2-1.4 0.5-1.6 0.5-0.9 0.5-1.6 0.2-1.4 0.5-1.6c0.3-0.3 0.5-1 0.5-1.9 0-1 0.2-1.7 0.5-1.9 0.3-0.3 0.5-1 0.5-2.2s0.2-2 0.5-2.2c0.3-0.3 0.5-1 0.5-2 0-0.9 0.2-1.9 0.5-2.3 0.3-0.5 0.5-1.5 0.5-3.9 0-2.3 0.1-3.6 0.5-4.3 0.4-0.8 0.5-2.6 0.4-12.1-0.1-7.2-0.2-11.2-0.4-11.2s-0.4 0.5-0.4 1.1-0.3 1.3-0.6 1.5-0.5 0.8-0.5 1.2c0 0.5-0.2 1.1-0.5 1.5-0.3 0.3-0.5 1.1-0.5 1.6 0 0.6-0.2 1.2-0.5 1.4s-0.5 0.6-0.5 0.9-0.2 0.8-0.5 1.2c-0.3 0.3-0.5 1-0.5 1.5s-0.2 1-0.5 1.2-0.5 0.7-0.5 1.1-0.2 1-0.5 1.3-0.5 0.9-0.5 1.3-0.2 0.9-0.5 1.1-0.5 0.7-0.5 1.1-0.2 1-0.5 1.3-0.5 0.9-0.5 1.2-0.6 1.8-1.4 3.4-1.8 3.7-2.3 4.7c-1.3 3-3.4 7.3-3.7 7.8-0.2 0.3-0.4 0.7-0.5 1s-0.6 1-1.1 1.6-0.9 1.4-0.9 1.6c0 0.3-0.2 0.7-0.5 0.9s-0.5 0.7-0.5 1-0.2 0.7-0.5 1-0.5 0.5-0.5 0.7-0.4 0.9-1 1.5c-0.5 0.7-1 1.4-1 1.5 0 0.3-2 3.4-3.2 4.9-0.4 0.4-0.7 0.9-0.7 1.1s-0.4 0.8-1 1.4c-0.5 0.6-1 1.3-1 1.4 0 0.2-0.4 0.8-1 1.4-0.5 0.6-0.9 1.2-0.9 1.4s-0.4 0.8-1 1.5c-1.1 1.3-2.8 3.5-4.1 5.3-0.5 0.7-1.7 2.2-2.7 3.3s-1.8 2.2-1.8 2.4-1.4 1.7-3 3.5c-1.7 1.7-3 3.3-3 3.6 0 0.6-26 26.5-26.5 26.5-0.2 0-2.4 1.9-4.8 4.3s-4.6 4.3-4.9 4.3-2.4 1.9-4.8 4.3-4.5 4.3-4.7 4.3-3.4 2.9-6.9 6.4c-3.6 3.5-6.7 6.4-6.9 6.4-0.6 0-22.1 21.5-24.3 24.3-1 1.3-3 3.5-4.3 4.8s-2.4 2.6-2.4 2.9-0.9 1.4-1.9 2.4c-1.1 1-1.9 2.1-1.9 2.2 0 0.4-3.2 4-3.5 4-2.3 0.6-2.4-2.6-2.4-7zm68.1-266.9c0.1-0.8-0.1-1.4-0.9-2.3-0.5-0.7-1-1.3-1-1.4s-0.6-1.1-1.4-2.3c-1.3-1.9-1.8-3.3-1.2-3.4 1.7-0.3 3-0.2 3.5 0.4 0.4 0.4 1 0.6 1.7 0.6s1.7 0.2 2.4 0.5c1.1 0.4 3 0.5 14.2 0.5 12.7 0 13 0 14.3-0.7 0.7-0.4 1.6-1 1.9-1.3 0.6-0.6 0.5-0.7-0.2-1.4-0.5-0.5-1.1-0.8-1.8-0.8-0.6 0-1.2-0.2-1.4-0.5s-0.7-0.5-1-0.5-0.7-0.2-1-0.5-0.7-0.5-1-0.5-0.7-0.2-1-0.5-0.6-0.5-0.8-0.5-1.4-0.6-2.5-1.4-2.3-1.4-2.5-1.4-0.6-0.2-0.8-0.5-0.7-0.5-1-0.5-0.7-0.2-0.8-0.5c-0.3-0.8 0.5-1.4 2-1.4 0.8 0 1.5-0.2 1.8-0.5 0.2-0.3 0.9-0.5 1.6-0.5s1.4-0.2 1.6-0.5 0.8-0.5 1.3-0.5 1.1-0.2 1.3-0.5 0.6-0.5 0.9-0.5 1-0.4 1.6-1 1.2-0.9 1.4-0.9c0.3 0 3.1-2.3 4.6-3.8 3.7-3.9 6.2-6.7 6.2-7.1 0-0.3 0.4-0.9 1-1.4 0.5-0.5 1-1.2 1-1.5s0.2-0.7 0.5-0.9 0.5-0.7 0.5-1 0.2-0.7 0.5-1c0.3-0.2 0.5-0.7 0.5-1.1s0.2-0.9 0.5-1.1 0.5-0.8 0.5-1.3 0.2-1.1 0.5-1.3c0.6-0.5 0.6-1.9 0-1.9-0.2 0-0.6 0.2-0.8 0.5s-0.6 0.5-0.8 0.5-1.5 1.1-2.9 2.4-2.7 2.4-2.9 2.4-1.3 0.9-2.4 1.9-2.2 1.9-2.4 1.9-0.8 0.4-1.4 1c-0.6 0.5-1.3 1-1.5 1s-1.1 0.4-1.8 0.9c-0.8 0.5-1.8 1-2.3 1.1s-0.9 0.4-0.9 0.5-0.4 0.3-0.9 0.3-1.2 0.2-1.5 0.5-1 0.5-1.4 0.5c-0.5 0-1.1 0.2-1.4 0.5-0.4 0.3-1.3 0.5-2.3 0.5-0.9 0-2.2 0.2-2.8 0.5-0.8 0.3-2.3 0.5-4.5 0.5-1.9 0-5.4 0.2-7.9 0.5s-6.9 0.5-9.9 0.5-6 0.2-6.7 0.3c-0.7 0.2-2 0.5-2.9 0.6s-2 0.5-2.6 0.8c-0.5 0.3-1.1 0.5-1.2 0.5s-0.5 0.2-0.7 0.5c-0.6 0.6-0.7 0.6-1.4 0.2-0.6-0.4-0.6-4.7 0.1-5.5 0.3-0.3 0.5-1 0.5-1.5s0.2-1.2 0.5-1.4 0.5-0.7 0.5-1.1 0.2-0.9 0.5-1.1 0.5-0.6 0.5-0.9 0.2-0.8 0.5-1.2c0.3-0.3 0.5-0.9 0.5-1.3s0.2-0.9 0.5-1.1 0.5-0.6 0.5-0.8 0.4-1 1-1.7c0.5-0.7 1-1.5 1-1.8 0-0.2 0.4-0.8 0.8-1.2 0.5-0.4 1-1.2 1.2-1.7 0.5-1.2 6.9-7.5 8.5-8.4 1.2-0.7 3.7-1.9 5.5-2.7 0.6-0.3 1.7-0.5 2.3-0.5s1.3-0.2 1.5-0.5c0.3-0.3 1-0.5 2.3-0.5 1.1 0 2.3-0.2 2.9-0.5 1.4-0.7 18.9-0.8 19.7-0.1 0.3 0.3 0.9 0.6 1.3 0.7 0.8 0.3 1 1.2 0.2 1.8-0.3 0.2-0.5 0.5-0.5 0.7s-0.4 1-1 1.7c-0.5 0.8-1 1.6-1 1.9 0 0.8 1 0.9 2 0.3 0.5-0.3 1.1-0.5 1.3-0.5 0.3 0 2-0.8 9.3-4.4 1.2-0.6 3.1-1.6 4.2-2.2s2.1-1.2 2.4-1.3 0.6-0.3 0.8-0.3c0.9-0.4 2.9-1.7 3.2-2.1 0.4-0.7-0.3-1.5-1.3-1.5-0.4 0-0.9-0.2-1.1-0.5s-0.7-0.5-1.1-0.5-1-0.2-1.3-0.5-1.1-0.5-1.6-0.5-1.3-0.2-1.6-0.5-1.1-0.5-1.6-0.5-1.3-0.2-1.6-0.5-1.1-0.5-1.6-0.5c-0.6 0-1.2-0.2-1.4-0.5-0.3-0.3-1-0.5-1.9-0.5s-1.7-0.2-2-0.5-1.1-0.5-2.2-0.5c-1.2 0-2-0.2-2.7-0.6-0.6-0.4-1.2-0.6-1.8-0.5s-1.2 0-2-0.5c-0.7-0.5-1.6-0.7-2.8-0.7-1 0-2-0.2-2.3-0.5-0.4-0.3-1.3-0.5-2.5-0.5s-2-0.2-2.4-0.5c-0.3-0.3-0.8-0.5-1.1-0.5-1.3 0-0.7-0.9 5.4-7.4 1.8-1.9 3.2-3.6 3.1-3.8s-1.1-0.3-2.3-0.3c-1.5 0-2.1 0.1-2.3 0.5-0.1 0.3-0.6 0.5-1.5 0.5-0.7 0-1.6 0.2-2 0.5s-1 0.5-1.4 0.5c-0.5 0-1.1 0.2-1.4 0.5s-0.9 0.5-1.3 0.5-0.9 0.2-1.1 0.5-0.7 0.5-1.1 0.5-1 0.2-1.3 0.5-0.9 0.5-1.3 0.5-0.9 0.2-1.1 0.5-0.7 0.5-1 0.5-1.4 0.4-2.4 1c-1 0.5-2 1-2.4 1-0.3 0-0.7 0.2-1 0.5-0.4 0.5-2.4 0.7-2.7 0.2-0.1-0.2 0-0.5 0.3-0.7s0.5-0.7 0.5-1.1 0.2-0.9 0.5-1.1 0.5-0.8 0.5-1.3 0.2-1.1 0.5-1.3 0.5-0.7 0.5-1 0.2-0.7 0.5-1c0.3-0.2 0.5-0.7 0.5-1s0.2-0.7 0.5-1c0.3-0.2 0.5-0.7 0.5-1.1s0.2-0.9 0.5-1.1c0.8-0.6 0.6-1.6-0.3-1.6-0.4 0-0.9 0.1-1 0.3s-0.8 0.6-1.6 1-1.5 0.9-1.6 1.1c-0.1 0.3-0.5 0.5-1 0.5s-0.9 0.2-1 0.5-0.3 0.5-0.5 0.5c-0.6 0-5.4 3.4-6.6 4.6-0.6 0.6-1.3 1.2-1.5 1.2-0.4 0-3.9 3.6-4.8 4.9-0.3 0.4-1 1.4-1.6 2.2-1.2 1.5-1.5 2-2.7 4.1-0.4 0.8-0.9 1.7-1.1 1.9-0.2 0.3-0.4 0.7-0.5 1s-0.5 1.1-1 1.9c-0.4 0.8-0.8 1.6-0.8 1.9 0 0.5-0.2 0.9-1.5 3.5-0.4 0.7-0.7 1.7-0.7 2.1s-0.2 1-0.5 1.4c-0.3 0.3-0.5 0.9-0.5 1.3s-0.2 0.9-0.5 1.3c-0.3 0.3-0.5 1-0.5 1.5s-0.2 1.1-0.5 1.4-0.5 1-0.5 1.5-0.2 1.2-0.5 1.5c-0.3 0.2-0.5 0.6-0.5 0.9s-0.2 0.8-0.5 1.1-0.5 1-0.5 1.5-0.2 1-0.5 1.3c-0.3 0.2-0.5 0.6-0.5 0.9s-0.2 0.8-0.5 1.1-0.5 0.9-0.5 1.1c0 0.6-2.6 5.7-3.9 7.6-0.5 0.8-0.9 1.5-0.9 1.7s-0.6 1.1-1.4 2-1.4 1.8-1.4 2-1.9 2.3-4.3 4.6c-2.4 2.4-4.3 4.5-4.3 4.7 0 0.6 3.2 0.5 4-0.1 0.5-0.4 1.6-0.5 4.8-0.5h4.2l5.2 5.3c2.9 2.9 5.4 5.3 5.6 5.3s1 0.5 1.7 1.1 1.5 1.1 1.7 1.1 0.7 0.4 1.1 0.8 0.9 0.8 1.1 0.8 0.7 0.3 1.2 0.6c0.4 0.4 1 0.6 1.2 0.6s0.9 0.4 1.7 1c0.7 0.5 1.6 1 2 1s0.9 0.2 1.1 0.5 0.7 0.5 1.1 0.5 0.8 0.2 0.9 0.5 0.6 0.5 1.4 0.5 1.3 0.2 1.4 0.5 0.6 0.5 1.4 0.5c0.7 0 1.4 0.2 1.6 0.5s0.9 0.5 1.6 0.5c0.6 0 1.5 0.2 1.8 0.5 0.4 0.3 1.2 0.5 2.4 0.4 1.6 0 1.6-0.1 1.7-1.1zm-150.2-35.4c0.5-0.3 1.2-0.5 1.4-0.5 0.6 0 2.9-2.2 2.9-2.9 0-0.3 0.2-0.8 0.5-1.1s0.5-1.1 0.5-1.8c0-0.6 0.2-1.4 0.5-1.8 0.7-0.9 0.6-4.3-0.2-5.2-0.3-0.4-0.8-0.7-1-0.7-0.6 0-1.5 1.7-1.5 2.9 0 1.9-1.4 3.2-4.6 4.3-2 0.7-4.6 0.7-4.9 0.1-0.1-0.3-0.5-0.5-0.8-0.5-0.8 0-2.1-1.2-2.1-1.9 0-0.3-0.2-0.7-0.5-0.9s-0.5-0.6-0.5-0.8c0-0.7-1.7-3-2.3-3-0.7 0-1.4 4.3-1 5.6 0.2 0.5 0.3 1.3 0.3 1.8s0.2 1.1 0.4 1.3 0.5 0.7 0.6 1.1c0.2 0.7 4 3.7 4.7 3.7 0.2 0 0.9 0.3 1.5 0.6 1.5 0.5 4.7 0.5 6.1-0.3zm153-0.1c3.7-1.2 6.9-3.1 6.9-4.1 0-0.2 0.2-0.6 0.4-0.9 1.1-1.2 1.6-2.8 1.6-5.2 0-1.8-0.1-2.6-0.6-3.2-0.7-1-1.2-0.9-1.3 0.2-0.1 0.5-0.3 1-0.6 1.2s-0.5 0.6-0.5 0.9-0.4 1-1 1.7c-0.5 0.7-1 1.3-1 1.5s-0.6 0.6-1.3 1c-1 0.6-1.7 0.7-4 0.7-2.7 0-2.7 0-4.5-1.3-1-0.7-1.8-1.5-1.8-1.7s-0.2-0.6-0.5-0.8-0.5-0.9-0.5-1.4c0-1.3-0.7-1.9-1.6-1.5-0.6 0.3-0.7 0.6-0.7 3.8 0 2 0.1 3.6 0.3 3.7s0.5 0.7 0.8 1.2c0.7 1.7 3.1 3.8 4.5 3.9 0.7 0.1 1.4 0.3 1.6 0.5 0.7 0.5 1.8 0.4 3.8-0.2zm64.3-85.7c0-0.4-1-1.8-2.3-3.1-1.3-1.4-2.3-2.6-2.3-2.8s-0.6-1-1.4-1.9-1.4-1.8-1.4-2-0.5-0.8-1.1-1.4-1.4-1.6-1.7-2.1-1.2-1.8-1.9-2.9c-1.4-2.2-2.7-4.5-2.7-5s1.8-0.3 2.2 0.2c0.2 0.3 0.7 0.5 1.1 0.5s1 0.2 1.3 0.5 1 0.5 1.5 0.5 1 0.2 1.3 0.5c0.2 0.3 0.8 0.5 1.4 0.5s1.3 0.2 1.6 0.5 1.3 0.5 2.1 0.5 1.8 0.2 2.1 0.5c0.4 0.3 1.3 0.5 2.4 0.5s2 0.2 2.4 0.5c0.8 0.6 2.4 0.6 2.6 0 0.1-0.3-0.5-1.2-1.8-2.6-1.1-1.1-2-2.2-2-2.4s-0.9-1.3-2.1-2.6c-1.1-1.3-2.1-2.4-2.1-2.6s-0.9-1.2-1.9-2.4-1.9-2.3-1.9-2.5-0.4-0.8-1-1.3c-0.5-0.5-1-1.1-1-1.3s-0.6-1.2-1.4-2.1-1.4-1.9-1.4-2.1-0.4-0.8-1-1.4c-0.5-0.6-1-1.3-1-1.5s-0.3-0.7-0.6-1c-0.8-0.6-0.8-2.1-0.2-2.6 0.3-0.2 0.5-0.6 0.5-0.8s0.4-1 0.9-1.6c0.5-0.7 1.5-2.5 2.3-4s1.5-2.9 1.6-3.2 0.4-0.7 0.5-1 0.3-0.7 0.5-1c1.4-2.5 3.2-6.1 3.2-6.5 0-0.2 0.2-0.6 0.5-0.8s0.5-0.7 0.5-1 0.2-0.7 0.5-1 0.5-0.7 0.5-1 0.2-0.7 0.5-1 0.5-0.7 0.5-1.1 0.2-0.9 0.5-1.1 0.5-0.7 0.5-1.1 0.2-1 0.5-1.3 0.5-0.9 0.5-1.2 0.2-0.7 0.5-0.9 0.5-0.7 0.5-1.1 0.2-1 0.5-1.3 0.5-0.9 0.5-1.3 0.2-0.9 0.5-1.1 0.5-0.7 0.5-1.1 0.2-1 0.5-1.3 0.5-1 0.5-1.5 0.2-1.1 0.5-1.5c0.3-0.3 0.5-1 0.5-1.5s0.2-1 0.5-1.2 0.5-0.8 0.5-1.3 0.2-1.1 0.5-1.5c0.3-0.3 0.5-1 0.5-1.5s0.2-1.1 0.5-1.3c0.3-0.3 0.5-0.8 0.5-1.1s0.2-0.7 0.3-0.9c0.6-0.4 1.6 0.8 1.6 1.9 0 0.6 0.2 1.3 0.5 1.6s0.5 1 0.5 1.4c0 0.5 0.2 1.1 0.5 1.4s0.5 1.1 0.5 1.6c0 0.6 0.2 1.2 0.5 1.4 0.3 0.3 0.5 1 0.5 1.9 0 1 0.2 1.7 0.5 1.9 0.3 0.3 0.5 1 0.5 1.9 0 1 0.2 1.7 0.5 1.9 0.3 0.3 0.5 1 0.5 2.4s0.1 2.1 0.5 2.4 0.5 1 0.5 2.4 0.1 2.1 0.5 2.4c0.3 0.3 0.5 1 0.5 2.5 0 1.1 0.2 2.5 0.5 3.1 0.2 0.6 0.5 2.2 0.6 3.6s0.3 2.8 0.5 3.1c0.2 0.2 0.4 1.7 0.5 3.3 0.1 2 0.2 3.1 0.6 3.5 0.3 0.4 0.5 1.7 0.6 4.8 0.1 2.3 0.3 4.4 0.4 4.6 0.6 0.7 1.5-0.1 1.5-1.3 0-0.6 0.2-1.2 0.5-1.5 0.3-0.2 0.5-0.9 0.5-1.6 0-0.6 0.2-1.4 0.5-1.8 0.3-0.3 0.5-1.1 0.5-1.8 0-0.6 0.2-1.4 0.5-1.8s0.5-1.4 0.5-2.6c0-1.1 0.2-2.5 0.5-3.1 0.7-1.7 0.7-29.7 0-30.9-0.3-0.5-0.5-1.7-0.5-3.2 0-1.8-0.1-2.6-0.5-2.8-0.3-0.3-0.5-1-0.5-1.9 0-0.8-0.2-1.8-0.5-2.1s-0.5-1.1-0.5-1.6c0-0.6-0.2-1.2-0.5-1.4s-0.5-0.9-0.5-1.4c0-0.6-0.2-1.2-0.5-1.4s-0.5-0.8-0.5-1.3-0.2-1.1-0.5-1.4-0.5-1-0.5-1.6c0-0.7-0.2-1.2-0.5-1.3s-0.5-0.5-0.5-0.9-0.2-0.9-0.5-1.1-0.5-0.8-0.5-1.3-0.2-1.1-0.5-1.3-0.5-0.7-0.5-1.1-0.1-0.8-0.3-0.9-1.2-2-2.3-4.2-2.1-4.1-2.3-4.2-0.3-0.4-0.3-0.8c0-0.3-0.2-0.8-0.5-1s-0.5-0.6-0.5-0.9c0-0.6-1.9-2.6-2.5-2.6-0.2 0-0.4 0.4-0.4 0.8s-0.1 0.8-0.3 0.8-0.6 0.6-1 1.4c-0.4 0.7-0.9 1.5-1.2 1.6-0.2 0.1-0.4 0.5-0.4 0.7s-0.4 1.1-1 1.8c-0.5 0.7-1 1.5-1 1.7s-0.2 0.5-0.4 0.7-0.7 0.8-1 1.5-0.8 1.3-1 1.4-0.4 0.4-0.4 0.7-0.3 0.9-0.6 1.3c-0.4 0.4-0.6 0.9-0.6 1.1s-0.4 0.8-0.8 1.4-0.8 1.2-0.8 1.3-0.7 1.3-1.6 2.6-1.6 2.5-1.6 2.6-0.4 0.7-0.9 1.4c-0.5 0.6-1 1.3-1 1.5s-0.7 1.3-1.5 2.5-1.4 2.2-1.4 2.3-0.4 0.7-1 1.4c-0.5 0.7-1 1.3-1 1.4s-0.4 0.8-1 1.4c-0.5 0.7-1 1.3-1 1.4s-0.4 0.8-1 1.4c-0.5 0.7-1 1.3-1 1.4s-0.6 1.1-1.4 2.1-1.4 2-1.4 2.2-0.4 0.7-1 1.2c-0.5 0.5-1 1.1-1 1.3s-0.5 0.9-1 1.6c-0.6 0.6-1.5 1.8-2 2.5-2.4 3.4-3 4.1-4.3 5.6-0.8 0.9-1.6 2-1.9 2.5s-1.4 1.8-2.4 2.9c-1 1-1.9 2.2-2.1 2.5s-3.6 4.1-7.7 8.4c-4.1 4.2-7.7 8.1-8 8.6s-1.7 2-3.1 3.4-2.6 2.7-2.6 2.9c0 1.1 3.1 4.7 8.8 10.3 3.5 3.4 6.4 6.2 6.6 6.2s1.2 0.8 2.3 1.9c1.1 1 2.5 2.2 3.1 2.5s1.5 1.1 2.1 1.7c0.5 0.5 1.2 1 1.5 1s0.9 0.4 1.4 1c0.5 0.5 1.2 1 1.4 1s0.9 0.4 1.4 1c0.5 0.5 1.1 1 1.4 1s1 0.4 1.6 1c0.6 0.5 1.2 0.9 1.4 0.9s0.8 0.4 1.5 1c0.7 0.5 1.3 1 1.5 1s0.6 0.3 1 0.6c0.4 0.4 0.9 0.6 1.2 0.6 0.2 0 0.8 0.4 1.3 0.8s1 0.8 1.2 0.8 0.7 0.3 1.1 0.6c0.4 0.4 0.9 0.6 1.2 0.6 0.2 0 0.7 0.2 0.9 0.5 0.3 0.3 0.8 0.5 1.1 0.5s0.6 0.1 0.6 0.3c0 0.1 0.7 0.7 1.6 1.1 0.9 0.5 1.7 1 1.8 1.2s0.5 0.3 0.8 0.3 0.8 0.2 1 0.5 0.9 0.5 1.4 0.5c0.7 0 1.1 0.2 1.2 0.5 0 0.6 0.7 0.3 0.7-0.5z"/></g>
                    </svg>
                </h3>
                <i><?php printf(esc_html__('Compatible with WordPress v.%s', 'bulk-editor'), $wp_version) ?></i><br />


            </div>

            <?php if ($WPBE->show_notes): ?>
                <div>
                    <br><a href="https://pluginus.net/affiliate/wordpress-posts-bulk-editor" target="_blank" class="wpbe-button button"><span class="icon-upload"></span>Upgrade</a>
                </div>
            <?php endif; ?>

            <?php echo apply_filters('wpbe_right_top_notice', '') ?>

        </div>





        <input type="hidden" name="wpbe_settings" value="" />

        <?php if (version_compare($wp_version, WPBE_MIN_WP_VERSION, '<')): ?>

            <div id="message" class="error fade"><p><strong><?php esc_html_e("ATTENTION! Your version of the WordPress is obsolete. There is no warranty of normal working with the plugin!!", 'bulk-editor') ?></strong></p></div>

        <?php endif; ?>

        <?php echo apply_filters('wpbe_top_notice', '') ?>

        <div id="tabs" class="wpbe-tabs wpbe-tabs-style-shape">

            <nav>
                <ul>
                    <li class="tab-current">
                        <a href="#tabs-posts" onclick="return wpbe_init_js_intab('tabs-posts')">
                            <span class="icon-book"></span>
                            <span><?php esc_html_e("Posts Editor", 'bulk-editor') ?></span>
                        </a>
                    </li>

                    <?php if (apply_filters('wpbe_show_tabs', true, 'settings')): ?>
                        <li>
                            <a href="#tabs-settings" onclick="return wpbe_init_js_intab('tabs-settings')">
                                <span class="icon-cog"></span>
                                <span><?php esc_html_e("Settings", 'bulk-editor') ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php do_action('wpbe_ext_panel_tabs'); //including extensions scripts          ?>

                </ul>
            </nav>

            <div class="content-wrap">

                <section id="tabs-posts" class="content-current">

                    <?php
                    $table_labels = array();
                    $edit_views = array();
                    $edit_sanitize = array();
                    $fields_types = array();
                    if (!empty($active_fields)) {
                        foreach ($active_fields as $key => $f) {
                            $title = $f['title'];
                            if (isset($f['title_static']) AND $f['title_static']) {
                                $title = $settings_fields[$key]['title'];
                            }
                            $table_labels[] = array('title' => $title, 'desc' => isset($f['desc']) ? $f['desc'] : '');
                            $edit_views[] = $f['edit_view'];
                            $edit_sanitize[] = isset($f['sanitize']) ? $f['sanitize'] : 'no';
                        }
                    }
                    $fk = $settings_fields_keys;

//***

                    if (empty($edit_views)) {
                        echo '<strong class="wpbe_set_attention">' . esc_html__('Select some columns in tab "Settings"', 'bulk-editor') . '</strong><br /><br />';
                    }

                    $table_labels[] = array('title' => esc_html__('Actions', 'bulk-editor'), 'desc' => '');
                    echo WPBE_HELPER::render_html(WPBE_PATH . 'views/parts/advanced-table.php', array(
                        'table_data' => array(
                            'editable' => implode(',', $editable),
                            'default-sort-by' => $default_sortby_col_num,
                            'sort' => $default_sort,
                            'no-order' => implode(',', $no_order),
                            'per-page' => $per_page,
                            'extend_per-page' => $extend_per_page,
                            'additional' => '',
                            'start-page' => isset($_GET['start_page']) ? intval($_GET['start_page']) : 0,
                            'fields' => implode(',', $fk),
                            'edit_views' => (!empty($edit_views) ? implode(',', $edit_views) : ''),
                            'edit_sanitize' => (!empty($edit_sanitize) ? implode(',', $edit_sanitize) : ''),
                        ),
                        'table_labels' => $table_labels
                    ));
                    ?>


                    <?php if (!empty($tax_keys)): ?>
                        <div id="taxonomies_popup" style="display: none;">

                            <div class="wpbe-modal wpbe-modal2 wpbe-style">
                                <div class="wpbe-modal-inner">
                                    <div class="wpbe-modal-inner-header">
                                        <h3 class="wpbe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="wpbe-modal-close wpbe-modal-close1"></a>
                                    </div>
                                    <div class="wpbe-modal-inner-content">
                                        <div class="wpbe-form-element-container">
                                            <div class="wpbe-name-description">
                                                <strong><?php esc_html_e('Quick search', 'bulk-editor') ?></strong>
                                                <span><?php esc_html_e('Quick terms search by its name', 'bulk-editor') ?></span>
                                            </div>
                                            <div class="wpbe-form-element">
                                                <input type="text" class="wpbe_popup_option" id="term_quick_search" value="" /><br />
                                                <a href="#" class="wpbe_create_new_term"><?php esc_html_e('create new term', 'bulk-editor') ?></a>&nbsp;|&nbsp;
                                                <input type="checkbox" id="taxonomies_popup_list_checked_only" value="0" /><label for="taxonomies_popup_list_checked_only"><?php esc_html_e('selected only', 'bulk-editor') ?></label>
                                                <input type="checkbox" id="taxonomies_popup_select_all_terms" value="0" /><label for="taxonomies_popup_select_all_terms"><?php esc_html_e('Select all terms', 'bulk-editor') ?></label>

                                            </div>
                                        </div>

                                        <div class="wpbe-form-element-container">
                                            <ul id="taxonomies_popup_list"></ul>
                                        </div>
                                    </div>
                                    <div class="wpbe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="wpbe-modal-close1 button button-primary button-large button-large-2"><?php esc_html_e('Cancel', 'bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="wpbe-modal-save1 button button-primary button-large button-large-1"><?php esc_html_e('Apply', 'bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="wpbe-modal-backdrop"></div>

                        </div>
                    <?php endif; ?>

                    <?php if (isset($is_popupeditor) && $is_popupeditor): ?>
                        <div id="popupeditor_popup" style="display: none;">
                            <div class="wpbe-modal wpbe-modal2 wpbe-style">
                                <div class="wpbe-modal-inner">
                                    <div class="wpbe-modal-inner-header">
                                        <h3 class="wpbe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="wpbe-modal-close wpbe-modal-close2"></a>
                                    </div>
                                    <div class="wpbe-modal-inner-content">
                                        <div class="wpbe-form-element-container2">
                                            <div id="wpbe-modal-content-popupeditor">
                                                <div class="wpbe-form-element-container">
                                                    <?php
                                                    wp_editor('', 'popupeditor', array(
                                                        'editor_height' => 515
                                                    ));
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="wpbe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="wpbe-modal-close2 button button-primary button-large button-large-2"><?php esc_html_e('Cancel', 'bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="wpbe-modal-save2 button button-primary button-large button-large-1"><?php esc_html_e('Apply', 'bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="wpbe-modal-backdrop"></div>

                        </div>
                    <?php endif; ?>
                    <?php if (isset($is_popupeditor) && $is_popupeditor): ?>
                        <div id="popupeditor_gutemberg_popup" style="display: none;">
                            <div class="wpbe-modal wpbe-modal2 wpbe-style">
                                <div class="wpbe-modal-inner">
                                    <div class="wpbe-modal-inner-header">
                                        <h3 class="wpbe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="wpbe-modal-close wpbe-modal-close2"></a>
                                    </div>
                                    <div class="wpbe-modal-inner-content">
                                        <div class="wpbe-form-element-container2">
                                            <div id="wpbe-modal-content-popupeditor">
                                                <div class="wpbe-form-element-container">

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="wpbe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="wpbe-modal-close2 button button-primary button-large button-large-2"><?php esc_html_e('Cancel', 'bulk-editor') ?></a>                                    
                                        <a href="javascript:void(0)" class="wpbe-modal-save3 button button-primary button-large button-large-1"><?php esc_html_e('Apply', 'bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="wpbe-modal-backdrop"></div>

                        </div>
                    <?php endif; ?>
                    <?php if (isset($is_gallery) AND $is_gallery): ?>
                        <div id="gallery_popup_editor" style="display: none;">
                            <div class="wpbe-modal wpbe-modal2 wpbe-style">
                                <div class="wpbe-modal-inner">
                                    <div class="wpbe-modal-inner-header">
                                        <h3 class="wpbe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="wpbe-modal-close wpbe-modal-close4"></a>
                                    </div>
                                    <div class="wpbe-modal-inner-content">
                                        <div class="wpbe-form-element-container2">
                                            <div id="wpbe-modal-content-popupeditor">
                                                <div class="wpbe-form-element-container">
                                                    <a href="#" class="wpbe-button wpbe_insert_gall_file" data-place="top"><?php esc_html_e('Add Image', 'bulk-editor') ?></a><br />
                                                    <br />
                                                    <div id="wpbe_gallery_bulk_operations">
                                                        <div class="col-lg-12">

                                                            <select id="wpbe_gall_operations">
                                                                <option value="new"><?php esc_html_e('Replace all posts images by the selected ones', 'bulk-editor') ?></option>
                                                                <option value="add"><?php esc_html_e('Add selected images to the already existed ones', 'bulk-editor') ?></option>
                                                                <option value="delete"><?php esc_html_e('Delete selected images from the posts', 'bulk-editor') ?></option>
                                                                <option value="delete_forever"><?php esc_html_e('Delete selected images from the posts, also delete them from the media library forever', 'bulk-editor') ?></option>
                                                            </select>


                                                        </div>

                                                        <div class="clear"></div>

                                                    </div>


                                                    <form method="post" action="" id="posts_gallery_form"></form>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="wpbe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="wpbe-modal-close4 button button-primary button-large button-large-2"><?php esc_html_e('Cancel', 'bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="wpbe-modal-save4 button button-primary button-large button-large-1"><?php esc_html_e('Apply', 'bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="wpbe-modal-backdrop"></div>

                        </div>

                        <template id="wpbe_gallery_li_tpl">
                            <li>
                                <img src="__IMG_URL__" alt="" class="wpbe_gal_img_block" data-attachment-id="__ATTACHMENT_ID__" />
                                <a href="#" class="wpbe_gall_file_delete"><span class="icon-trash button"></span></a>
                                <input type="hidden" name="__KEY__[]" value="__ATTACHMENT_ID__" />
                            </li>
                        </template>

                    <?php endif; ?>

                    <?php $meta_popup_editor = TRUE; //for bulk edit    ?>
                    <?php if ($meta_popup_editor): ?>
                        <div id="meta_popup_editor" style="display: none;">
                            <div class="wpbe-modal wpbe-modal2 wpbe-style">
                                <div class="wpbe-modal-inner">
                                    <div class="wpbe-modal-inner-header">
                                        <h3 class="wpbe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="wpbe-modal-close wpbe-modal-close10"></a>
                                    </div>
                                    <div class="wpbe-modal-inner-content">

                                        <div class="wpbe-form-element-container">
                                            <div class="row">
                                                <div class="col-lg-10">
                                                    <h4><?php esc_html_e('REMEMBER: sequence of data maybe have sense (and maybe not), so be attentive! Do not mix in the same popup window data of array and object data!', 'bulk-editor') ?></h4>
                                                </div>
                                                <div class="col-lg-2">
                                                    &nbsp;<a href="https://bulk-editor.pro/document/bulk-edit-of-serialized-jsoned-meta-data/" target="_blank" class="button button-primary wpbe-info-btn"><span class="icon-book"></span>&nbsp;<?php esc_html_e('Documentation', 'bulk-editor') ?></a>
                                                </div>
                                            </div>

                                            <div class="clear"></div>


                                            <a href="#" class="wpbe-button meta_popup_editor_insert_new" data-place="top"><?php esc_html_e('Prepend array key/value', 'bulk-editor') ?></a>&nbsp;
                                            <a href="#" class="wpbe-button meta_popup_editor_insert_new_o" data-place="top"><?php esc_html_e('Prepend object set', 'bulk-editor') ?></a><br />

                                            <form method="post" action="" id="meta_popup_editor_form"></form>

                                            <a href="#" class="wpbe-button meta_popup_editor_insert_new" data-place="bottom"><?php esc_html_e('Append array key/value', 'bulk-editor') ?></a>&nbsp;
                                            <a href="#" class="wpbe-button meta_popup_editor_insert_new_o" data-place="bottom"><?php esc_html_e('Append object set', 'bulk-editor') ?></a><br />

                                        </div>
                                    </div>
                                    <div class="wpbe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="wpbe-modal-close10 button button-primary button-large button-large-2"><?php esc_html_e('Cancel', 'bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="wpbe-modal-save10 button button-primary button-large button-large-1"><?php esc_html_e('Apply', 'bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="wpbe-modal-backdrop"></div>

                        </div>


                        <div style="display: none;" id="meta_popup_editor_li">
                            <li class="wpbe_options_li">
                                <a href="#" class="help_tip wpbe_drag_and_drope wpbe_drag_and_drope_moved" title="<?php esc_html_e('drag and drop', 'bulk-editor') ?>"><img src="<?php echo WPBE_ASSETS_LINK ?>images/move.png" alt="<?php esc_html_e('move', 'bulk-editor') ?>" /></a>
                                <small><?php esc_html_e('key', 'bulk-editor') ?>:</small><input type="text" value="__KEY__" class="meta_popup_editor_li_key" name="keys[]" /><br />
                                <small><?php esc_html_e('value', 'bulk-editor') ?>:</small><input type="text" value="__VALUE__" class="meta_popup_editor_li_value" name="values[]" />
                                <a href="#" class="wpbe_prod_delete"><img src="<?php echo WPBE_ASSETS_LINK . 'images/delete2.png' ?>" alt="" /></a>
                                __CHILD_LIST__
                            </li>
                        </div>

                        <div style="display: none;" id="meta_popup_editor_li_o">
                            <li class="wpbe_options_li">
                                <a href="#" class="help_tip wpbe_drag_and_drope wpbe_drag_and_drope_moved" title="<?php esc_html_e('drag and drop', 'bulk-editor') ?>"><img src="<?php echo WPBE_ASSETS_LINK ?>images/move.png" alt="<?php esc_html_e('move', 'bulk-editor') ?>" /></a>
                                <small><?php esc_html_e('key', 'bulk-editor') ?>:</small><input type="text" value="__KEY__" class="meta_popup_editor_li_key" name="keys[]" /><br />
                                <a href="#" class="wpbe_prod_delete"><img src="<?php echo WPBE_ASSETS_LINK . 'images/delete2.png' ?>" alt="" /></a>
                                __CHILD_LIST__
                            </li>
                        </div>

                        <div style="display: none;" id="meta_popup_editor_li_object">
                            <li class="wpbe_options_li">
                                <small><?php esc_html_e('key', 'bulk-editor') ?>:</small><br /><input type="text" value="__KEY__" class="meta_popup_editor_li_key meta_popup_editor_li_key2" name="keys2[]" /><br />
                                <small><?php esc_html_e('value', 'bulk-editor') ?>:</small><br /><textarea class="meta_popup_editor_li_value meta_popup_editor_li_value2" name="values2[]">__VALUE__</textarea>
                                <a href="#" class="wpbe_prod_delete"><img src="<?php echo WPBE_ASSETS_LINK . 'images/delete2.png' ?>" alt="" /></a>
                            </li>
                        </div>

                    <?php endif; ?>

                    <div class="row clear">
                        <div class="col-lg-3">
                            <a href="https://bulk-editor.pro/document/posts-editor/" target="_blank" class="button button-primary wpbe-info-btn"><span class="icon-book"></span>&nbsp;<?php esc_html_e('Documentation', 'bulk-editor') ?></a><br />
                        </div>

                        <!-- <div class="col-lg-9 wpbe-text-align-right">
                            <small>* <i class="wpbe_set_attention"><?php esc_html_e('Note: if horizontal scroll disappeared when it must be visible, click on tab Posts Editor to make it visible', 'bulk-editor') ?></i></small><br />
                        </div> -->

                    </div>
                    <br />


                </section>

                <section id="tabs-settings">
                    <form id="mainform" method="post" action="">
                        <table class="wpbe-full-width">
                            <tr>
                                <td class="general-settings-td-2">
                                    <?php
                                    $fields_all = $settings_fields;
                                    $fields_all_checked = array();
                                    $fields_all_unchecked = array();

                                    foreach ($fields_all as $key => $f) {
                                        if (intval($f['show']) === 1) {
                                            $fields_all_checked[$key] = $f;
                                        } else {
                                            $fields_all_unchecked[$key] = $f;
                                        }
                                    }
                                    ?>
                                    <h4><?php printf(esc_html__('Columns settings%s, columns enabled %s', 'bulk-editor'), ($show_notes ? '' : ' ' . (count($fields_all) - 1)), count($fields_all_checked) - 1) ?></h4>
                                    <ul class="wpbe_fields">
                                        <li class="unsortable">
                                            <input type="text" value="" class="wpbe-full-width" placeholder="<?php esc_html_e('columns finder ...', 'bulk-editor') ?>" id="wpbe_columns_finder" /><br />
                                        </li>
                                        <?php
                                        //***
                                        //lets show selected columns on the top
                                        $columns_colors = array();

                                        foreach (array($fields_all_checked, $fields_all_unchecked) as $counter => $ff):

                                            if ($counter > 0 AND !empty($fields_all_unchecked)):
                                                ?>
                                                <li class="wpbe_options_li">
                                                    <a href="#" id="show_all_columns"><?php esc_html_e('Show all columns', 'bulk-editor') ?></a>
                                                </li>
                                                <?php
                                            endif;
                                            if (!empty($ff)):
                                                foreach ($ff as $key => $f) :
                                                    if (!$f['direct']) {
                                                        //continue;
                                                    }
                                                    ?>
                                                    <?php if (!empty($f['title'])): ?>
                                                        <li class="wpbe_options_li <?php if (isset($f['move'])): ?>unsortable<?php endif; ?>" <?php if ($counter > 0): ?>style="display: none;"<?php endif; ?>>

                                                            <div class="col-lg-6">
                                                                <div class="wpbe-h7px"></div>

                                                                <?php if (!isset($f['move'])): ?>
                                                                    <a href="#" class="help_tip wpbe_drag_and_drope" title="<?php esc_html_e('drag and drop', 'bulk-editor') ?><?php echo ($show_notes ? ' - ' . esc_html__('premium version', 'bulk-editor') : '') ?>"><img src="<?php echo WPBE_ASSETS_LINK ?>images/move.png" alt="<?php esc_html_e('move', 'bulk-editor') ?>" /></a>
                                                                <?php endif; ?>

                                                                <?php if ($f['field_type'] !== 'none'): ?>
                                                                    <?php if (isset($f['title_static']) AND $f['title_static']): ?>
                                                                        <input type="text" name="wpbe_options[fields][<?php echo $key ?>][title]" value="<?php echo $settings_fields[$key]['title'] ?>" readonly="" class="wpbe_column_li_option" /><br />
                                                                    <?php else: ?>
                                                                        <input type="text" name="wpbe_options[fields][<?php echo $key ?>][title]" value="<?php echo $f['title'] ?>" class="wpbe_column_li_option" /><br />
                                                                    <?php endif; ?>
                                                                <?php else: ?>
                                                                    <?php echo $f['desc'] ?><br />
                                                                    <input type="hidden" name="wpbe_options[fields][<?php echo $key ?>][title]" value="" /><br />
                                                                    <div class="wpbe-h10px"></div>
                                                                <?php endif; ?>

                                                                <br />

                                                                <?php if (!in_array($key, array('__checker', 'ID')) AND in_array($current_user_role, apply_filters('wpbe_permit_special_roles', ['administrator']))): ?>

                                                                    <?php if ($show_notes): ?>

                                                                        <input type="checkbox" value="1" disabled="" <?php checked($f['site_editor_visibility']) ?> class="site_editor_visibility" data-key="<?php echo esc_html__($key) ?>" id="site_editor_visibility_<?php echo $key ?>" />
                                                                        &nbsp;<label for="site_editor_visibility_<?php echo $key ?>"><?php esc_html_e('visible for the site editor', 'bulk-editor') ?>
                                                                            <br /><small class="wpbe-free-version">(<?php esc_html_e('premium version', 'bulk-editor') ?>)</small></label><br />

                                                                    <?php else: ?>

                                                                        <input type="checkbox" value="1" <?php checked($f['site_editor_visibility']) ?> class="site_editor_visibility" data-key="<?php echo esc_html__($key) ?>" id="site_editor_visibility_<?php echo $key ?>" />
                                                                        &nbsp;<label for="site_editor_visibility_<?php echo $key ?>"><?php esc_html_e('visible for the site editor', 'bulk-editor') ?></label><br />

                                                                    <?php endif; ?>

                                                                    <input type="hidden" name="wpbe_options[fields][<?php echo $key ?>][site_editor_visibility]" value="<?php echo $f['site_editor_visibility'] ?>" />


                                                                <?php endif; ?>
                                                            </div>


                                                            <div class="col-lg-3">

                                                                <?php
                                                                $col_color = '';
                                                                $txt_color = '';
                                                                $font_size = 14;

                                                                if (isset($options['fields'][$key]['col_color'])) {
                                                                    $col_color = $options['fields'][$key]['col_color'];
                                                                }

                                                                if (isset($options['fields'][$key]['txt_color'])) {
                                                                    $txt_color = $options['fields'][$key]['txt_color'];
                                                                }

                                                                if (isset($options['fields'][$key]['font_size'])) {
                                                                    $font_size = $options['fields'][$key]['font_size'];
                                                                }

                                                                $columns_colors[$key] = array(
                                                                    'col_color' => $col_color,
                                                                    'txt_color' => $txt_color,
                                                                    'font_size' => $font_size
                                                                );
                                                                ?>
                                                                <div class="wpbe_column_color_pickers">
                                                                    <input type="text" name="wpbe_options[fields][<?php echo $key ?>][col_color]" value="<?php echo $col_color ?>" class="wpbe-color-picker" />
                                                                    <input type="text" name="wpbe_options[fields][<?php echo $key ?>][txt_color]" value="<?php echo $txt_color ?>" class="wpbe-color-picker" />
                                                                    <input type="number" name="wpbe_options[fields][<?php echo $key ?>][font_size]" placeholder="<?php esc_html_e('cell text or number size', 'bulk-editor') ?>" value="<?php echo $font_size ?>" />
                                                                </div>


                                                            </div>

                                                            <?php if (isset($f['move'])): ?>
                                                                <!-------------------- always visible and not switchable ----------------------------->
                                                                <input type="hidden" value="1" name="wpbe_options[fields][<?php echo $key ?>][show]" />
                                                            <?php else: ?>
                                                                <div class="col-lg-2 wpbe-text-align-right">

                                                                    <?php echo WPBE_HELPER::draw_advanced_switcher(intval(isset($active_fields[$key])), $key, 'wpbe_options[fields][' . $key . '][show]', array('true' => '', 'false' => ''), array('true' => 1, 'false' => 0), 'wpbe_fshow_' . $key); ?>

                                                                </div>
                                                            <?php endif; ?>



                                                            <div class="col-lg-1 wpbe-text-align-right">
                                                                <?php if (isset($f['desc'])): ?>
                                                                    <div class="wpbe_options_li_desc">
                                                                        <br />
                                                                        <div style="position: absolute; right: 5px;"><?php echo WPBE_HELPER::draw_tooltip($f['desc']); ?></div>
                                                                    </div>
                                                                <?php endif; ?>
                                                            </div>

                                                            <div class="clear"></div>


                                                        </li>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                            <?php endif; ?>


                                        <?php endforeach; ?>


                                    </ul>


                                    <br />

                                    <input type="submit" class="button button-primary button-primary" value="<?php esc_html_e('Save all settings', 'bulk-editor') ?>" />


                                </td>
                                <td class="general-settings-td">

                                    <h4 class="wpbe-documentation"><a href="https://bulk-editor.pro/document/settings/" target="_blank" class="button button-primary"><span class="icon-book"></span></a>&nbsp;<?php esc_html_e('General settings', 'bulk-editor') ?></h4>


                                    <?php foreach ($total_settings as $k => $o) : ?>
                                        <div class="wpbe-control-section">
                                            <h5><?php echo $o['title'] ?></h5>
                                            <div class="wpbe-control-container">
                                                <div class="wpbe-control">

                                                    <?php
                                                    switch ($o['type']) {
                                                        case 'select':
                                                            ?>
                                                            <div class="select-wrap">
                                                                <select name="wpbe_options[options][<?php echo $k ?>]">
                                                                    <?php foreach ($o['select_options'] as $kk => $vv) : ?>
                                                                        <option <?php selected($kk == $o['value']) ?> value="<?php echo $kk ?>"><?php echo $vv['title'] ?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </div>
                                                            <?php
                                                            break;

                                                        case 'number':
                                                            ?>


                                                            <?php if ($show_notes && $k === 'per_page'): ?>

                                                                <input type="number" readonly value="10" />
                                                                <br /><small class="wpbe-free-version">(<?php esc_html_e('premium version', 'bulk-editor') ?>)</small>

                                                            <?php else: ?>

                                                                <input type="number" name="wpbe_options[options][<?php echo $k ?>]" value="<?php echo $o['value'] ?>" />

                                                            <?php endif; ?>

                                                            <?php
                                                            break;

                                                        default:
                                                            //textinput
                                                            if (is_array($o['value'])) {
                                                                $val = explode(',', $o['value']);
                                                            } else {
                                                                $val = $o['value'];
                                                            }
                                                            ?>
                                                            <input type="text" name="wpbe_options[options][<?php echo $k ?>]" value="<?php echo $val ?>" />
                                                            <?php
                                                            break;
                                                    }
                                                    ?>

                                                </div>
                                                <div class="wpbe-description">
                                                    <p class="description"><?php echo $o['desc'] ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>


                                    <?php if (in_array($WPBE->settings->current_user_role, apply_filters('wpbe_permit_special_roles', ['administrator']))) : ?>

                                        <div class="wpbe-control-section">
                                            <h5><?php esc_html_e('Site editors post types', 'bulk-editor') ?></h5>
                                            <div class="wpbe-control-container">
                                                <div class="wpbe-control">

                                                    <input type="text" name="wpbe_site_editors_post_types" value="<?php echo WPBE_HELPER::get_site_editors_post_types() ?>">

                                                </div>
                                                <div class="wpbe-description">
                                                    <p class="description"><?php esc_html_e('What post types can edit site editors in the tab Posts Editor. Use comma, example: post,car,page', 'bulk-editor') ?></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="wpbe-control-section">
                                            <h5><?php esc_html_e('Separate columns and meta for post types', 'bulk-editor') ?></h5>
                                            <div class="wpbe-control-container">
                                                <div class="wpbe-control">


                                                    <div class="select-wrap">
                                                        <?php
                                                        $opt = array(
                                                            0 => esc_html__('No', 'bulk-editor'),
                                                            1 => esc_html__('Yes', 'bulk-editor'),
                                                        );

                                                        if ($show_notes) {
                                                            unset($opt[1]);
                                                        }

                                                        $current_opt = WPBE_HELPER::get_site_separate_settings();
                                                        ?>
                                                        <select name="wpbe_site_separate_settings" <?php if ($show_notes): ?>disabled<?php endif; ?>>
                                                            <?php foreach ($opt as $key => $val) : ?>
                                                                <option <?php selected($key == $current_opt) ?> value="<?php echo $key ?>"><?php echo $val ?></option>
                                                            <?php endforeach; ?>
                                                        </select>

                                                    </div>


                                                    <?php if ($show_notes): ?>
                                                        (<small class="wpbe-free-version"><?php esc_html_e('premium version', 'bulk-editor') ?></small>)
                                                    <?php endif; ?>

                                                </div>
                                                <div class="wpbe-description">
                                                    <p class="description"><?php esc_html_e('Each post type has its own set of columns and meta fields.', 'bulk-editor') ?></p>
                                                </div>
                                            </div>
                                        </div>	
                                        <div class="wpbe-control-section">
                                            <h5><?php esc_html_e('Show content and excerpt text partly', 'bulk-editor') ?></h5>
                                            <div class="wpbe-control-container">
                                                <div class="wpbe-control">


                                                    <div class="select-wrap">
                                                        <?php
                                                        $opt = array(
                                                            0 => esc_html__('No', 'bulk-editor'),
                                                            1 => esc_html__('Yes', 'bulk-editor'),
                                                        );

                                                        if ($show_notes) {
                                                            unset($opt[1]);
                                                        }

                                                        $current_opt = WPBE_HELPER::get_show_text_editor();
                                                        ?>
                                                        <select name="wpbe_show_text_editor" <?php if ($show_notes): ?>disabled<?php endif; ?>>
                                                            <?php foreach ($opt as $key => $val) : ?>
                                                                <option <?php selected($key == $current_opt) ?> value="<?php echo $key ?>"><?php echo $val ?></option>
                                                            <?php endforeach; ?>
                                                        </select>

                                                    </div>

                                                    <?php if ($show_notes): ?>
                                                        (<small class="wpbe-free-version"><?php esc_html_e('premium version', 'bulk-editor') ?></small>)
                                                    <?php endif; ?>

                                                </div>
                                                <div class="wpbe-description">
                                                    <p class="description"><?php esc_html_e('Show part of the text in the content and excerpt edit button', 'bulk-editor') ?></p>
                                                </div>
                                            </div>
                                        </div>										

                                    <?php endif; ?>

                                    <hr />


                                    <br />
                                    

                                    <div style="display: flex; justify-content: space-between">

                                        <div>
                                            <input type="submit" class="button button-primary button-primary" value="<?php esc_html_e('Save all settings', 'bulk-editor') ?>" />
											<input type="hidden"  id="wpbe_settings_nonce" value="<?php echo  wp_create_nonce( 'wpbe_settings_nonce' ); ?>"  />  
                                        </div>

                                        <div>
                                            <a href="https://bulk-editor.pro/document/more-settings-implicit/" target="_blank" class="button button-primary"><?php esc_html_e('More settings (implicit)', 'bulk-editor') ?></a>
                                        </div>
										
                                    </div>


                                </td>
                            </tr>
                        </table>

                    </form>
                </section>


                <!--------------------------------- taxonomies terms data ---------------------------------------------->
                <div style="display: none;">
                    <div id="taxonomies_popup_list_li_tpl">
                        <li data-search-value="__SEARCH_TXT__" class="quick_search_element __TOP_LI__">
                            <div class="quick_search_element_container">
                                <input type="checkbox" __CHECK__ name="wpbe_tax_terms[]" value="__TERM_ID__" id="term___TERM_ID__">&nbsp;<label class="wpbe_term_label" for="term___TERM_ID__">__LABEL__</label>
                                <div class="tax_description wpbe-wrap-collabsible">
                                    <input id="wpbe_collapsible___TERM_ID__" class="wpbe_toggle_btn" type="checkbox">
                                    <label for="wpbe_collapsible___TERM_ID__" class="wpbe_lbl-toggle"><?php esc_html_e('Show description', 'bulk-editor') ?></label>
                                    <div class="wpbe_collapsible-content">
                                        <p>
                                            __DESC__
                                        </p>
                                    </div>									
                                </div>
                                <div class="wpbe_taxonomy_management">
                                    <span class="edit_tax_terms" data-term_id="__TERM_ID__">
                                        <?php esc_html_e('Edit', 'bulk-editor'); ?>															
                                    </span>									
                                    <span class="dashicons dashicons-trash delete_tax_terms" data-term_id="__TERM_ID__"></span>

                                </div>	
                            </div>
                            __CHILDS__
                        </li>
                    </div>
                </div>



                <script>
                    var taxonomies_terms = {};

<?php if (!empty($tax_keys)): ?>
    <?php foreach ($tax_keys as $tax_key) : ?>

                            taxonomies_terms['<?php echo $tax_key ?>'] =<?php echo json_encode(WPBE_HELPER::get_taxonomies_terms_hierarchy($tax_key)) ?>;

    <?php endforeach; ?>
<?php endif; ?>



                    var wpbe_active_fields =<?php echo json_encode($settings_fields_full) ?>;
                </script>



                <?php do_action('wpbe_ext_panel_tabs_content'); //including extensions scripts            ?>


                <div class="clear"></div>


            </div>

        </div>


    </section><!--/ .wpbe-section-->
    <div class="made_by">
        <a href="https://pluginus.net/" target="_blank">Created by PluginUs.NET</a><br />
    </div>
    <div class="clear"></div>


    <div id="wpbe_buffer" style="display: none;"></div>

    <div id="wpbe_html_buffer" class="wpbe_info_popup" style="display: none;"></div>


    <!-------------------------------- advanced panel popups ------------------------------------------->

    <div id="wpbe_tools_panel_profile_popup" style="display: none;">
        <div class="wpbe-modal wpbe-modal2 wpbe-style">
            <div class="wpbe-modal-inner">
                <div class="wpbe-modal-inner-header">
                    <h3 class="wpbe-modal-title"><?php esc_html_e('Columns profile', 'bulk-editor') ?></h3>
                    <a href="javascript:void(0)" class="wpbe-modal-close wpbe-modal-close8"></a>
                </div>
                <div class="wpbe-modal-inner-content">

                    <div class="wpbe-form-element-container">
                        <div class="wpbe-name-description">
                            <strong><?php esc_html_e('Columns profiles', 'bulk-editor') ?></strong>
                            <span><?php esc_html_e('Here you can load previously saved columns profile. After pressing on the load button, page reloading will start immediately!', 'bulk-editor') ?></span>

                            <?php if (isset($current_profile['title'])): ?>
                                <span class="current_profile_disclaimer"><?php
                                    printf(esc_html__('Current profile is: %s %s', 'bulk-editor'), $current_profile['title'], WPBE_HELPER::draw_link(array(
                                                'href' => $current_profile['key'],
                                                'title' => WPBE_HELPER::draw_image(WPBE_ASSETS_LINK . 'images/delete.png', '', '', 15),
                                                'class' => 'wpbe_delete_profile',
                                                'title_attr' => esc_html__('remove current columns profile', 'bulk-editor')
                                            )))
                                    ?></span>
                            <?php endif; ?>

                        </div>
                        <div class="wpbe-form-element">
                            <div class="posts_search_container">
                                <select id="wpbe_load_profile">
                                    <option value="0"><?php esc_html_e('Select profile to load', 'bulk-editor') ?></option>
                                    <?php foreach ($profiles as $pkey => $pvalue) : ?>
                                        <option <?php selected((isset($current_profile['key']) ? $current_profile['key'] === trim($pkey) : false)) ?> value="<?php echo esc_html($pkey) ?>"><?php echo esc_html($pvalue['title']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <div class="cssload-container" style="display: none;">
                                    <div class="cssload-whirlpool"></div>
                                </div><br />

                                <div style="display: none;"  id="wpbe_load_profile_actions">
                                    <a href="javascript:void(0)" class="button button-primary button" id="wpbe_load_profile_btn"><?php esc_html_e('load', 'bulk-editor') ?></a>&nbsp;
                                    <a href="#" class="button button-primary button wpbe_delete_profile"><?php esc_html_e('remove', 'bulk-editor') ?></a>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="wpbe-form-element-container">
                        <div class="wpbe-name-description">
                            <strong><?php esc_html_e('New Profile', 'bulk-editor') ?></strong>
                            <span><?php esc_html_e('Here you can type any title and save current columns set and their order. Type here any title and then press Save button OR press Enter button on your keyboard!', 'bulk-editor') ?></span>
                        </div>
                        <div class="wpbe-form-element">
                            <div class="posts_search_container">
                                <input type="text" value="" id="wpbe_new_profile" />
                            </div>
                        </div>
                    </div>

                    <!-- <div class="wpbe-form-element-container"></div> -->
                </div>
                <div class="wpbe-modal-inner-footer">
                    <a href="javascript:void(0)" class="button button-primary button-large button-large-1"  id="wpbe_new_profile_btn"><?php esc_html_e('Create', 'bulk-editor') ?></a>
                    <a href="javascript:void(0)" class="wpbe-modal-close8 button button-primary button-large button-large-2"><?php esc_html_e('Close', 'bulk-editor') ?></a>
                </div>
            </div>
        </div>

        <div class="wpbe-modal-backdrop"></div>

    </div>


    <div id="wpbe_new_term_popup" style="display: none;">
        <div class="wpbe-modal wpbe-modal2 wpbe-style">
            <div class="wpbe-modal-inner">
                <div class="wpbe-modal-inner-header">
                    <h3 class="wpbe-modal-title"><?php printf(esc_html__('New term for [%s]', 'bulk-editor'), '<span></span>') ?></h3>
                    <a href="javascript:void(0)" class="wpbe-modal-close wpbe-modal-close9"></a>
                </div>
                <div class="wpbe-modal-inner-content">

                    <div class="wpbe-form-element-container">
                        <div class="wpbe-name-description">
                            <strong><?php esc_html_e('New Term(s)', 'bulk-editor') ?></strong>
                            <span><?php esc_html_e('Here you can write title for the new term. Use comma to create some new tags on the same time! New terms with already existed names will not be created!', 'bulk-editor') ?></span>
                        </div>
                        <div class="wpbe-form-element">
                            <input type="text" value="" id="wpbe_new_term_title" class="wpbe-full-width" />
                        </div>
                    </div>


                    <div class="wpbe-form-element-container">
                        <div class="wpbe-name-description">
                            <strong><?php esc_html_e('Slug(s) of the new term', 'bulk-editor') ?></strong>
                            <span><?php esc_html_e('Here you can write slug for the the new term (optionally). Use comma for slug(s) when you create some on the same time terms, or leave slug field empty to create slug(s) automatically', 'bulk-editor') ?></span>
                        </div>
                        <div class="wpbe-form-element">
                            <input type="text" value="" id="wpbe_new_term_slug" class="wpbe-full-width" />
                        </div>
                    </div>


                    <div class="wpbe-form-element-container">
                        <div class="wpbe-name-description">
                            <strong><?php esc_html_e('Parent of the new term(s)', 'bulk-editor') ?></strong>
                            <span><?php esc_html_e('Here you can select parent for the the new term (optionally)', 'bulk-editor') ?></span>
                        </div>
                        <div class="wpbe-form-element">
                            <select id="wpbe_new_term_parent"></select>
                        </div>
                    </div>

                </div>
                <div class="wpbe-modal-inner-footer">
                    <a href="#" class="button button-primary button-large button-large-1" id="wpbe_new_term_create"><?php esc_html_e('Create', 'bulk-editor') ?></a>
                    <a href="javascript:void(0)" class="wpbe-modal-close9 button button-primary button-large button-large-2"><?php esc_html_e('Cancel', 'bulk-editor') ?></a>
                </div>
            </div>
        </div>

        <div class="wpbe-modal-backdrop wpbe-modal-backdrop2"></div>

    </div>

    <?php do_action('wpbe_page_end') ?>


    <div class="external-scroll_wrapper">
        <div class="external-scroll_x">
            <div class="scroll-element_outer">
                <div class="scroll-element_size"></div>
                <div class="scroll-element_track"></div>
                <div class="scroll-bar"></div>
            </div>
        </div>
    </div>

</div>



<?php if ($show_notes): ?>
    <hr />

    <table class="wpbe-full-width">
        <tr>

            <td class="wpbe-width-33">
                <h3 class="wpbe-full-upgrade"><?php esc_html_e("UPGRADE TO FULL VERSION", 'bulk-editor') ?>:</h3>
                <a href="https://bulk-editor.pro/downloads" target="_blank"><img src="<?php echo WPBE_LINK ?>assets/images/wpbe_banner.png" width="300" alt="<?php esc_html_e("WOLF - Posts Bulk Editor Professional", 'bulk-editor'); ?>" /></a>
            </td>

            <td class="wpbe-width-33">
                <h3><?php esc_html_e("BEAR - WooCommerce Bulk Editor Professional", 'bulk-editor') ?>:</h3>
                <a href="https://bulk-editor.com/" target="_blank"><img src="<?php echo WPBE_LINK ?>assets/images/woobe_banner.png" width="300" alt="<?php esc_html_e("BEAR - WooCommerce Bulk Editor Professional", 'bulk-editor'); ?>" /></a>
            </td>

            <td class="wpbe-width-33">
                <h3><?php esc_html_e("WPCS - WordPress Currency Switcher", 'bulk-editor') ?>:</h3>
                <a href="https://wp-currency.com/" target="_blank"><img src="<?php echo WPBE_LINK ?>assets/images/wpcs_banner.png" width="300" alt="<?php esc_html_e("WPCS - WordPress Currency Switcher", 'bulk-editor'); ?>" /></a>
            </td>



        </tr>
    </table>
<?php endif; ?>


<script>
    var wpbe_current_post_type = '<?= $WPBE->settings->current_post_type ?>';
</script>


<?php if (!empty($columns_colors)): ?>

    <style type="text/css">

        <?php foreach ($columns_colors as $key => $colors) : ?>

            <?php if (!empty($colors['col_color'])): ?>
                td[data-field="<?php echo esc_html__($key) ?>"] {
                    background-color: <?php echo $colors['col_color'] ?>;
                }
            <?php endif; ?>


            <?php if (!empty($colors['txt_color'])): ?>
                td[data-field="<?php echo esc_html__($key) ?>"],
                td[data-field="<?php echo esc_html__($key) ?>"] a{
                    color: <?php echo $colors['txt_color'] ?> !important;
                }

                td[data-field="<?php echo esc_html__($key) ?>"] select,
                td[data-field="<?php echo esc_html__($key) ?>"] li.search-choice span,
                td[data-field="<?php echo esc_html__($key) ?>"] li.wpbe_li_tag,
                td[data-field="<?php echo esc_html__($key) ?>"] .wpbe-button,
                td[data-field="<?php echo esc_html__($key) ?>"] input.wpbe_calendar,
                td[data-field="<?php echo esc_html__($key) ?>"] .wpbe_btn_gal_block{
                    color: <?php echo $colors['txt_color'] ?> !important;
                }
            <?php endif; ?>

            <?php if (!empty($colors['font_size'])): ?>
                td[data-field="<?php echo $key ?>"] {
                    font-size: <?php echo $colors['font_size'] ?>px !important;
                    line-height: <?php echo ($colors['font_size'] + intval($colors['font_size'] / 2)) ?>px !important;
                }
            <?php endif; ?>

        <?php endforeach; ?>

    </style>

    <?php
endif;
?>