import { get, post } from "../utils/ajax";
import FormDataJson from "form-data-json-convert";
import notificationToast from "../utils/notification-toast";

export default class ZoomAdminSetting {
    constructor() {
        this.init();
    }

    init() {
        jQuery(document).ready(($) => {
            this.bindEvents($);
        });
    }

    bindEvents($) {
        jQuery(document).on('click', '.wpb-zoom-remove-oauth-connection', (e) => {
            this.handleRemoveOAuthConnection(e, $);
        });
        jQuery(document.body).on("submit", ".wpb_zoom_setting_form", this.zoomSettingFormSubmit.bind(this));
        // Change Event For Booking Type Change URL
    }

    handleRemoveOAuthConnection(e, $) {
        e.preventDefault();
        const __this = jQuery(e.currentTarget);
        if (confirm('Are you sure you want to remove the OAuth connection and delete the credential file?')) {
            __this.prop('disabled', true);
            __this.find('.wpb-zoom-remove-oauth-connection-spinner').removeClass('d-none');
            
            get('wpb_zoom_remove_oauth_connection').then(res=>{
                __this.prop('disabled', false);
                __this.find('.wpb-zoom-remove-oauth-connection-spinner').addClass('d-none');

                notificationToast[res.status](res.message, res.status.toUpperCase(), { autoClose: true })
                setTimeout(() => {
                    location.reload();
                }, 200);
            })
        }
    }

    zoomSettingFormSubmit(e) {
        e.preventDefault();
        const __this = jQuery(e.currentTarget);
        let is_error= false
     
        let data= FormDataJson.toJson(document.querySelector('.wpb_zoom_setting_form'))
        if(!data.wpb_zoom_client_id){
            __this.find('[name="wpb_zoom_client_id"]').addClass('is-invalid')
            is_error=true
        }else{
            __this.find('[name="wpb_zoom_client_id"]').removeClass('is-invalid')
        }
        if(!data.wpb_zoom_client_secret){
            is_error=true
            __this.find('[name="wpb_zoom_client_secret"]').addClass('is-invalid')
        }else{
            __this.find('[name="wpb_zoom_client_secret"]').removeClass('is-invalid')
        }
        if(is_error){
            return ;
        }

        __this.find('.wpb_zoom_setting_sub_button').prop('disabled', true);
        __this.find('.wpb-zoom-settings-submit-spinner').removeClass('d-none');
        
        post('wpb_zoom_save_settings',data).then(res=>{
            __this.find('.wpb_zoom_setting_sub_button').prop('disabled', false);
            __this.find('.wpb-zoom-settings-submit-spinner').addClass('d-none');

            notificationToast[res.status](res.message, res.status.toUpperCase(), { autoClose: true })
            setTimeout(() => {
                location.reload();
            }, 200);
        })
    }

}
