<?php

final class WPB_Payment_Controller
{

    public function get_payment_list(WP_REST_Request $request)
    {

        $paged = $request->get_param('paged') ?? 1;

        $args = array(
            'per_page' => $request->get_param('length'),
            'offset'        => $request->get_param('start'),
        );
        if ($request->has_param('order')) {
            $args['order'] = strtoupper($request->get_param('order')[0]['dir'] ?? '');
            $args['order_by'] = $request->get_param('order')[0]['name'] ?? "";
        }


        if ($request->has_param('advanceFilter')) {
            $advanceFilter = $request->get_param('advanceFilter');

            // Parse wpb_booking_daterange if present
            if (isset($advanceFilter['date_from']) && isset($advanceFilter['date_to'])) {
                $args['date_from'] = date('Y-m-d', strtotime($advanceFilter['date_from']));
                $args['date_to'] = date('Y-m-d', strtotime($advanceFilter['date_to']));
            }
            if (!empty($advanceFilter['wpb_payment_mode'])) {
                $args['payment_mode'] = $advanceFilter['wpb_payment_mode'];
            }
            if (!empty($advanceFilter['wpb_payment_name'])) {
                $args['payment_name'] = "%{$advanceFilter['wpb_payment_name']}%";
            }
            if (!empty($advanceFilter['wpb_payment_status'])) {
                $args['payment_status'] = $advanceFilter['wpb_payment_status'];
            }
            if (!empty($advanceFilter['wpb_payment_amount'])) {
                $args['payment_amount'] = $advanceFilter['wpb_payment_amount'];
            }
        }

        $args['staff'] = in_array(WPBOOKIT()->helpers->get_staff_role(),wp_get_current_user( )->roles) ? get_current_user_id() : 0;

        $payment_data = wpb_get_payments($args);
        $is_woo_active =  is_plugin_active('woocommerce/woocommerce.php');

        $payment_data['payments'] = array_map(function ($item) use ($is_woo_active) {
            global $wpdb;
            
            if ($item->payment_mode == 'wpb_wc_payment_gateway' && $is_woo_active) {
                $post_id = $wpdb->get_var("SELECT `{$wpdb->prefix}postmeta`.`post_id` FROM `{$wpdb->prefix}posts` LEFT JOIN  `{$wpdb->prefix}postmeta` ON `{$wpdb->prefix}posts`.`ID` =`{$wpdb->prefix}postmeta`.`post_id` WHERE `{$wpdb->prefix}posts`.`post_type` LIKE 'shop_order_placehold' AND   `{$wpdb->prefix}postmeta`.`meta_key` LIKE 'wpb_booking_id' AND   `{$wpdb->prefix}postmeta`.`meta_value` LIKE '{$item->id}'  ");

                $order = wc_get_order($post_id);
                if ($order) {
                    $item->transaction_id = sprintf("Order ID: %s", $post_id);
                    $item->order_link = $order->get_edit_order_url();
                }
            }
            if(empty($item->transaction_id)){
                $item->transaction_id='-';
            } 
            
            if($item->payment_mode == 'wpb_wc_payment_gateway' && $order){
                $item->payment_mode = wpb_get_booking_modes()[$item->payment_mode] . ' - '  .$order->get_payment_method_title() ;
            }else{
                $item->payment_mode = wpb_get_booking_modes()[$item->payment_mode] ?? $item->payment_mode;
            }

            $item->total_amount =  wpb_get_prefix_postfix_price($item->total_amount);
            $booking_instace = new WPB_Booking($item->bookings_id);

            $item->duration =  sprintf("%s %s", $booking_instace->get_booking_type('view', ['duration'])['duration'], esc_html__("Min", 'wpbookit'));
            if ($item->paid_amount == 0) {
                $item->payment_status = false;
                $item->total_amount = esc_html__("Free", 'wpbookit');
            } else {
                $item->payment_status = [
                    'key' => $item->payment_status,
                    'label' => $item->payment_status == '1' ? esc_html__("Paid", 'wpbookit') : esc_html__("Unpaid", 'wpbookit'),
                ];
            }
            $item->paid_amount =  wpb_get_prefix_postfix_price( number_format( $item->paid_amount, 2 ,'.','') );
            return $item;
        }, $payment_data['payments']);
       
        wp_send_json(
            array(
                "recordsTotal"      => $payment_data['total_count'] ?? 0,
                "recordsFiltered"   => $payment_data['total_count'] ?? 0,
                "data"              => $payment_data['payments']
            )
        );
    }

    public function get_filter_payment_data(WP_REST_Request $request)
    {

        $paged = $request->get_param('paged') ?? 1;
        $date_range = $request->get_param('wpb-payment_datas-advanced-filter-flatpiker');
        $payment_name = $request->get_param('wpb_payment_name');
        $payment_amount = $request->get_param('wpb_payment_amount');
        $payment_status = $request->get_param('wpb_payment_status');
        $payment_mode = $request->get_param('wpb_payment_mode');


        $payment_setting_method = new WPB_Settings_Payment();
        $columns = $payment_setting_method->get_payment_column();
        $get_payment_status = $payment_setting_method->get_payment_status();

        $args = array(
            'paged' => $paged,
            'per_page' => $payment_setting_method->item_per_list,
            'date_range' => $date_range,
            'payment_name' => $payment_name,
            'payment_amount' => $payment_amount,
            'payment_status' => $payment_status,
            'payment_mode' => $payment_mode,
        );

        $payment_data = $payment_setting_method->get_payments($args);
        $payment_data_count = $payment_data['total_count'];
        $payment_data = $payment_data['payments'];
        $result_total_payment = count($payment_data);
        $payment_status = $payment_setting_method->get_payment_status();
        $payment_pagination = $payment_setting_method->get_payments_pagination_var();
        $total_item = $payment_pagination['total_no_of_items'];
        $total_page = ceil($payment_data_count / $payment_setting_method->item_per_list);
        $total_payment = ($result_total_payment < $args['per_page']) ? $result_total_payment : $args['per_page'];

        //$pagination_output	= wpb_get_pagination( $total_item_page, $args1['paged'], 'payment' );
        ob_start();
        require_once IQWPB_PLUGIN_PATH . "core/admin/views/settings/payment/payment-table.php";
        $table_content = ob_get_clean();
        $table_pagination = wpb_get_payment_pagination($total_page, $paged);
        $table_showing_print = sprintf('Showing ' . $total_payment . ' of ' . $payment_data_count . ' entries');

        wp_send_json(
            array(
                "table_content" => $table_content,
                "table_pagination" => $table_pagination,
                "table_showing_print" => $table_showing_print,
                "paged" => @$args1['paged'],
            )
        );
    }

    public function refresh_payment_data(WP_REST_Request $request)
    {
        $pageID = $request->get_param('pageID');
        $payment_setting_method = new WPB_Settings_Payment();
        $columns = $payment_setting_method->get_payment_column();
        $get_payment_status = $payment_setting_method->get_payment_status();
        $payment_pagination = $payment_setting_method->get_payments_pagination_var();
        $total_item = ceil($payment_pagination['total_no_of_items'] / $payment_setting_method->item_per_list);
        $pagination_output = wpb_get_payment_pagination($total_item, $current_page, $payment_setting_method->item_per_list);
        $args = array(
            'paged' => $pageID,
            'per_page' => $payment_setting_method->item_per_list,
        );

        $payment_method = new WPB_Payment();
        $payment_data = $payment_method->get_payments($args);

        ob_start();
        require_once IQWPB_PLUGIN_PATH . "core/admin/views/settings/payment/payment-table.php";
        $table_content = ob_get_clean();

        wp_send_json(
            array(
                "table_content" => $table_content,
                "paged" => @$args['paged'],
            )
        );
    }

    public function change_payment_status(WP_REST_Request $request)
    {
        $data_id = $request->get_param('data_id');
        $status_value = $request->get_param('status_value');

        $args = array(
            'payment_id' => $data_id,
            'payment_status' => $status_value
        );

        $payment_setting_method = new WPB_Settings_Payment();
        $status = $payment_setting_method->change_payment_status($args);
        if ($status) {
            wp_send_json_success('status change successfully');
        } else {
            wp_send_json_error('something went wrong');
        }
    }
    public function get_invoice_data(WP_REST_Request $request)
    {
        $data_id = $request->get_param('data_id');
        $args = array('payment_id' => $data_id);

        $invoice_data = $this->get_invoice_data_list($args);

        wp_send_json($invoice_data);
    }

    public function print_invoice_data(WP_REST_Request $request)
    {
        $data_id = $request->get_param('data_id');

        $invoice_data = [];
        $payment_setting_method = new WPB_Settings_Payment();
        $customer_details_column = $payment_setting_method->get_customer_details_column();
        $booking_details_column = $payment_setting_method->get_booking_details_column();
        $args = array('payment_id' => $data_id);
        $invoice_data = $this->get_invoice_data_list($args);

        extract( json_decode(get_metadata('wpb_bookings', $invoice_data['booking_id'], 'tax_data', true),true) ?? [] );
        $tax_data		= iqwpb_generate_html_output($tax_data??[] ,$price_excluding_tax ,$main_total, $invoice_data['total_amount'],'',$invoice_data['booking_id']);
        $args = array(
            'invoice_data' => $invoice_data,
            'customer_details_column' => $customer_details_column,
            'booking_details_column' => $booking_details_column,
            'tax_data' => $tax_data,
        );

        ob_start();
        wpb_get_template('payment/invoice.php', $args);
        $invoice_template = ob_get_clean();
        wp_send_json($invoice_template);
        exit;
    }
    public function get_invoice_data_list($args)
    {
        $payment_details = wpb_get_payments($args);

        $payment_datas = $payment_details['payments'];
        $invoice_id = esc_html__('Invoice Id # ', 'wpbookit');
        $payment_status = esc_html__('Payment status', 'wpbookit');

        $invoice_data = array(); // Initialize an empty array to hold invoice data

        foreach ($payment_datas as $payment_data) {

            $booking = new WPB_Booking($payment_data->bookings_id);
            $price= $booking->get_raw_booking_sub_price();
            $booking_type = $booking->get_booking_type()['name'];
            $booking_type_id = $booking->get_booking_type_id();
            $html_content = iqwpb_get_booking_totals_and_html($booking_type_id,$price>0?$price:null,$booking->get_id() ,false,$booking->get_raw_booking_price());
            $booking_type_instance = new WPB_Booking_Type($booking_type_id);
            $booking_type_instance->get_meta('price');
            $invoice_data = array(
                "payment_id" => isset($payment_data->payment_id) ? $payment_data->payment_id : '',
                "booking_id" => $booking->get_id(),
                "customer_name" => isset($payment_data->customer_name) ? $payment_data->customer_name : '',
                'customer_email' => isset($payment_data->customer_email) ? $payment_data->customer_email : '',
                'sr_id' => $booking->get_id(),
                "payment_mode" => isset($payment_data->payment_mode) ? $payment_data->payment_mode : '',
                "invoice_id" => isset($payment_data->payment_id) ? $invoice_id . $payment_data->payment_id : $invoice_id,
                "booking_date" => isset($payment_data->booking_date) ? $payment_data->booking_date : '',
                "date_created" => isset($payment_data->date_created) ? $payment_data->date_created : '',
                "payment_status" => isset($payment_data->payment_status) ?  ($payment_data->payment_status == 1 ? " Paid" : " Unpaid") : $payment_status,
                "booking_type" => isset($booking_type) ? $booking_type : '',
                "booking_type_id" => isset($booking_type_id) ? $booking_type_id : '',
                "customer_gender" => isset($payment_data->customer_gender) ? $payment_data->customer_gender : '-',
                "customer_birthdate" => isset($payment_data->customer_birthday) ? $payment_data->customer_birthday : '-',
                "booking_price" => wpb_get_prefix_postfix_price($booking_type_instance->get_meta('price')) ,
                "booking_duration" => sprintf("%s %s", $booking->get_booking_type('view', ['duration'])['duration'], esc_html__("Min", 'wpbookit')),
                "booking_quantity" => isset($payment_data->booking_quantity) ? $payment_data->booking_quantity : '1',
                "customer_address" => isset($payment_data->customer_address) ? $payment_data->customer_address : '-',
                "total_amount" => isset($payment_data->total_amount) ? $payment_data->total_amount : '-',
            );
            $invoice_data["booking_total"] = '';
            if (isset($invoice_data['booking_price']) && isset($invoice_data['booking_quantity'])) {
                // Check if the booking price is "FREE" and treat it as 0
                $booking_price = $invoice_data['booking_price'] === 'FREE' ? 0 : $invoice_data['booking_price'];

                // Ensure both booking price and quantity are numeric values
                if (is_numeric($booking_price) && is_numeric($invoice_data['booking_quantity'])) {
                    $invoice_data["booking_total"] = $booking_price * $invoice_data['booking_quantity'];
                }
            }

            ob_start(); ?>
            <table class="table custome-table wpb-datatable dataTable no-footer table-custom-border tax-module-invoice">
                <tbody>
                    <?php foreach ($html_content['tax_values'] as $tax_data_key => $tax_data_value):
                        $display_key = ucwords(str_replace('_', ' ', $tax_data_key)); ?>
                        <tr class="">
                            <th scope="col" class="sorting" tabindex="0">
                                <span class="nobr small"><?php echo esc_html($display_key); ?></span>
                            </th>
                            <td scope="col" class="sorting" tabindex="0" id="<?php echo esc_attr($tax_data_key); print_r($tax_data_key);?>">
                                <span class="nobr small fw-bolder">
                                <?php
                                if ($tax_data_value === esc_html__("Free", 'wpbookit-coupon')) {
                                    echo esc_html($tax_data_value);
                                } else {
                                    if(is_numeric($tax_data_value)){
                                        echo ($tax_data_value < 0) ?  ('- '. wpb_get_prefix_postfix_price(abs($tax_data_value))) : wpb_get_prefix_postfix_price($tax_data_value) ; 
                                    }else{
                                        echo esc_html($tax_data_value);
                                    }
                                }
                                ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php
            $html_content = ob_get_clean();

            $invoice_data['html_content'] = $html_content;
        }
        return apply_filters('iqwpb_filter_get_invoice_data_list',$invoice_data);
    }
}
