<?php
final class WPB_Setting_Controller
{
    public function add_general_setting(WP_REST_Request $request){
        global $wpdb;
        $request_data = $request->get_params();
        update_option( 'wpb_general_setting_data', $request_data);
        $permalink_Handler = new Booking_Type_Handler();
        $permalink_Handler->add_booking_type_rewrite_rule([ ]);
        
        // Update the column for all rows.
        $wpdb->query(
            $wpdb->prepare(
                "UPDATE $wpdb->wpb_tax SET `inclusive_tax` = %s",
                ($request_data['include_exclude_tax']??"incl")=="incl"?'yes':'no'
            )
        );

        $response_data = array(
            "status"    => 'success',
            'message' => esc_html__("Settings Saved Successfully!", 'wpbookit')
        );
        wp_send_json_success($response_data);
    }
    
    public function add_theme_setting(WP_REST_Request $request){
        $request_data = $request->get_params();
        $file_params  = $request->get_file_params();

        // Allowed Keys
        $Allowedkeys = array('copyright_text', 'old_site_logo','dashboard_name');

        // Create a new array without the unwanted keys
        $filteredArray = array_filter(
            $request_data,
            function($key) use ($Allowedkeys) {
                return in_array($key, $Allowedkeys);
            },
            ARRAY_FILTER_USE_KEY
        );

        $old_site_logo = $filteredArray['old_site_logo'] ?? null;
        
        $filteredArray['site_logo'] = $old_site_logo;
        
        $edit_image_url = isset($file_params["site_logo"]) ? $file_params["site_logo"] : null;

        if (!empty($edit_image_url["tmp_name"])) {
            $image_upload = $this->image_upload_handle($edit_image_url["tmp_name"], $edit_image_url);
            if (is_wp_error($image_upload)) {
                wp_send_json_error(
                    array(
                        'status'  => 'error',
                        'message' => __('Fail To Upload Media', 'wpbookit')
                    )
                );
            }else{
                $filteredArray['site_logo'] = (int)$image_upload;
            }
        }

        update_option( 'wpb_theme_setting_data', $filteredArray);
		flush_rewrite_rules();

        $response_data = array(
            "status"    => 'success',
            'message' => esc_html__("Theme settings data saved successfully.", 'wpbookit')
        );
        wp_send_json_success($response_data);
    }
    
    public function save_custome_code(WP_REST_Request $request){
        // Require administrator permission
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error(array(
                "status"    => 'error',
                'message' => esc_html__("Insufficient permissions.", 'wpbookit')
            ));
        }

        // Verify nonce
        if ( ! wp_verify_nonce( $request->get_param('_ajax_nonce'), 'wpb_ajax_nonce' ) ) {
            wp_send_json_error(array(
                "status"    => 'error',
                'message' => esc_html__("Security verification failed.", 'wpbookit')
            ));
        }

        // Get custom code
        $css_code = $request->get_param('css_code');
        $js_code = $request->get_param('js_code');
        
        // Sanitize CSS: Remove all HTML tags and dangerous CSS
        $css_code = wp_strip_all_tags( $css_code );
        $css_code = preg_replace('/javascript\s*:/i', '', $css_code);
        $css_code = preg_replace('/expression\s*\(/i', '', $css_code);
        $css_code = preg_replace('/-moz-binding\s*:/i', '', $css_code);
        
        // Sanitize JS: Remove HTML tags but preserve JavaScript code
        $js_code = wp_strip_all_tags( $js_code );
        
        update_option( 'wpb_custom_code_data', [  'css_code' => $css_code,  'js_code' => $js_code ]);
        flush_rewrite_rules();
 
        wp_send_json_success(array(
            "status"    => 'success',
            'message' => esc_html__("Custom Code Saved Successfully.", 'wpbookit')
        ));
    }
    public function get_payment_gateways_list(WP_REST_Request $request) {
        
        $data = get_option("wpb_offline_payment_modes", []);
        
        // Loop through the data and modify the description
        foreach ($data as $key => $value) {
            // Limit the description to 5 words
            $words = explode(' ', $value['desc']);
            if (count($words) > 5) {
                $data[$key]['desc'] = implode(' ', array_slice($words, 0, 5)) . '...';
            }
            // Assign an ID and actions
            $data[$key]['id'] = $key + 1;
            $data[$key]['actions'] = true;
        }
    
        // Sort data by ID based on order direction from request
        $order = $request->get_param('order');
        $dir = isset($order[0]['dir']) && strtolower($order[0]['dir']) === 'asc' ? 'asc' : 'desc';
        usort($data, function($a, $b) use ($dir) {
            return $dir === 'asc' ? ($a['id'] <=> $b['id']) : ($b['id'] <=> $a['id']);
        });
    
        // Send JSON response
        wp_send_json(array(
            "recordsTotal"    => count($data) ?? 0,
            "recordsFiltered" => count($data) ?? 0,
            "data"            => $data
        ));
    }
    

    public function image_upload_handle($tmp_file_path, $add_image_url)
    {
        $file_name = basename($add_image_url["name"]);

        $uploads_dir = wp_upload_dir();
        $destination_file_path = $uploads_dir["path"] . "/" . $file_name;

        // Move the uploaded file to the destination path
        if (move_uploaded_file($tmp_file_path, $destination_file_path)) :
            $file_url = $uploads_dir["url"] . "/" . $file_name;

            // Attempt to sideload the image
            $return_type = "id";
            $attachment_id = media_sideload_image($file_url, "", "avatar", $return_type);

            return $attachment_id;
        else :
            // Move uploaded file failed, handle the error
            return new WP_Error('fail');
        endif;
    }
    public function add_offline_payment_list   (WP_REST_Request $request)  {
        $name= $request->get_param('payment_mode_name');
        $desc= $request->get_param('payment_mode_desc');
        $payment_mode= get_option('wpb_offline_payment_modes',[]);
        if (empty($request->get_param('payment_gateway_id'))) {
            $payment_mode[] = ['name' => $name, 'desc' => $desc, 'status' => true];
        } else {
            if (isset($payment_mode[$request->get_param('payment_gateway_id') - 1])) {
                $payment_mode[$request->get_param('payment_gateway_id') - 1] = ['name' => $name, 'desc' => $desc, 'status' => true];
            } else {
                wp_send_json_error([
                    'status' => 'error',
                    'message' => esc_html__("Something Went Wrong", 'wpbookit'),
                ], 404);
            }
        }

        $result = update_option('wpb_offline_payment_modes', $payment_mode);

        wp_send_json_success([
            'status'=>'success',
            'message'=> esc_html__("Payment Mode Added Successfully",'wpbookit') ,
        ]);
    }
  
    public function update_payment_mode_status(WP_REST_Request $request)  {

        if(!empty($request->get_param('id')) || $request->get_param('id')== '0' ){
           
            $payment_mode= get_option('wpb_offline_payment_modes',[]);

            if(!isset($payment_mode[$request->get_param('id')])){
                wp_send_json_error([
                    'status'=>'error',
                    'message'=> esc_html__("Something Went Wrong",'wpbookit') ,
                ],404);
            }

            $payment_mode[$request->get_param('id')]['status'] = $request->get_param('value');
            $result= update_option('wpb_offline_payment_modes',$payment_mode);
            
            if($result){
                wp_send_json_success([
                    'status'=>'success',
                    'message'=> esc_html__("Payment Mode Status Updated Successfully",'wpbookit') ,
                ]);
            }
        }
        wp_send_json_error([
            'status'=>'error',
            'message'=> esc_html__("Something Went Wrong",'wpbookit') ,
        ],404);

     
    }
    public function delete_payment_mode(WP_REST_Request $request)  {

        if(!empty($request->get_param('id'))){
           
            $payment_mode= get_option('wpb_offline_payment_modes',[]);

            if(!isset($payment_mode[($request->get_param('id')-1) ] )){
                wp_send_json_error([
                    'status'=>'error',
                    'message'=> esc_html__("Something Went Wrong",'wpbookit') ,
                ],404);
            }

            unset($payment_mode[($request->get_param('id')-1)]);
            $result= update_option('wpb_offline_payment_modes',array_values($payment_mode));
            
            if($result){
                wp_send_json_success([
                    'status'=>'success',
                    'message'=> esc_html__("Payment Mode Delete Successfully",'wpbookit') ,
                ]);
            }
        }
        wp_send_json_error([
            'status'=>'error',
            'message'=> esc_html__("Something Went Wrong",'wpbookit') ,
        ],404);

     
    }
    public function wpb_zoom_remove_oauth_connection(WP_REST_Request $request) {

		$current_user = wp_get_current_user();
		$success = false;

        // Handle token deletion based on user role
        if ( in_array( 'administrator', (array) $current_user->roles ) ) {
            $token_data = get_option( 'wpb_zoom_access_token' );
            if ( $token_data ) {
                delete_option( 'wpb_zoom_access_token' );
            }
            $success = true;
        } else {
            $token_data = get_user_meta( $current_user->ID, 'wpb_zoom_access_token', true );
            if ( $token_data ) {
                delete_user_meta( $current_user->ID, 'wpb_zoom_access_token' );
            }
            $success = true;
        }

        if ($success) {
			wp_send_json( array( 'status' => 'success', 'message' => __( 'OAuth connection removed.', 'wpbookit' ) ) );
		} else {
			wp_send_json(array('status' => 'error', 'message' => __('Failed to remove OAuth connection.','wpbookit') ) );
		}
    }
    public function wpb_zoom_save_settings(WP_REST_Request $request)  {

		$settings = $request->get_params();

		// Sanitize and retrieve values from $_POST
        $wpb_zoom_status              = isset($settings['wpb_zoom_status']) ? $settings['wpb_zoom_status'] : 'off';
		$wpb_zoom_client_id           = isset($settings['wpb_zoom_client_id']) ? $settings['wpb_zoom_client_id'] : '';
		$wpb_zoom_client_secret       = isset($settings['wpb_zoom_client_secret']) ? $settings['wpb_zoom_client_secret'] : '';
		$wpb_zoom_client_redirect_uri = isset($settings['wpb_zoom_client_redirect_uri']) ? $settings['wpb_zoom_client_redirect_uri'] : '';

		$zoom_data = array(
			'wpb_zoom_status'                => $wpb_zoom_status,
			'wpb_zoom_client_id'             => $wpb_zoom_client_id,
			'wpb_zoom_client_secret'         => $wpb_zoom_client_secret,
			'wpb_zoom_client_redirect_uri'   => $wpb_zoom_client_redirect_uri
		);
		$current_user = wp_get_current_user();
		if ( in_array( 'administrator', (array) $current_user->roles ) ) {
            delete_option( 'wpb_zoom_settings' );
			$updated = update_option( 'wpb_zoom_settings', $zoom_data );
		} else{
            delete_user_meta($current_user->ID, 'wpb_zoom_settings');
			$updated = update_user_meta($current_user->ID, 'wpb_zoom_settings', $zoom_data);
		}

		if ($updated) {
			wp_send_json(array('status' => 'success', 'message' => esc_html__('Settings Saved Successfully','wpbookit')));
		} else {
			wp_send_json(array('status' => 'error', 'message' => esc_html__('Failed to save settings','wpbookit')));
		}
    }
    public function save_woocommerce_payment_gateway(WP_REST_Request $request)  {

		$request_params = $request->get_params();

        require_once(ABSPATH . 'wp-admin/includes/plugin.php');
        if (!is_plugin_active('woocommerce/woocommerce.php')) {
            wp_send_json(array('status' => 'error', 'message' => esc_html__('Woocommerce Plugin Is Not Active','wpbookit'),'option_value' => false));
        }

        $payment_gateways= get_option('wpb_payment_gateways');
        
        
        $payment_gateways['wpb_wc_payment_gateway'] = ['status'=> ($request_params['data']['wpb_woocommerce_payment_gateway_status']) =="on" , 'label' =>  $request_params['data']['wpb_change_woocommerce_payment_gateway_label']??esc_html__("WooCommerce payment gateway",'wpbookit') ];

		update_option('wpb_payment_gateways',$payment_gateways); 
        wp_send_json(array('status' => 'success', 'message' => esc_html__('WooCommerce payment gateway status updated','wpbookit'),'option_value' => true));
	
    }
    
    public function save_payment_setting(WP_REST_Request $request) {
        $request_params = $request->get_params();
        
        $current_payment_gateway = $request_params['wpb_payment_gateway'];
        $payment_gateways = get_option('wpb_payment_gateways', array());
    
        // Prepare array to store updated settings
        $updated_settings = array();
    
        // Iterate through request params to collect relevant settings
        foreach ($request_params as $key => $value) {
            if (strpos($key, "wpb_{$current_payment_gateway}") === 0 || $key == 'status') {
                $updated_settings[$key] = $value;
            }
        }
    
        // Check if there are any changes
        if (isset($payment_gateways[$current_payment_gateway]) && $payment_gateways[$current_payment_gateway] == $updated_settings) {
            wp_send_json(array(
                'status' => 'success',
                'message' => esc_html__('No changes made. Settings remain the same.', 'wpbookit'),
                'option_value' => true
            ));
            return;
        }
    
        // Update the payment gateway settings
        $payment_gateways[$current_payment_gateway] = $updated_settings;
    
        // Attempt to update the option
        if (update_option('wpb_payment_gateways', $payment_gateways)) {
            wp_send_json(array(
                'status' => 'success',
                'message' => esc_html__('Payment gateway settings have been saved successfully!', 'wpbookit'),
                'option_value' => true
            ));
        } else {
            wp_send_json(array(
                'status' => 'error',
                'message' => esc_html__('Failed to save settings', 'wpbookit'),
                'option_value' => false
            ));
        }
    }

    public function store_holiday_dates() {
        global $wpdb;
    
        // Check if dates to add are provided
        if (!empty($_POST['dates_to_add'])) {
            $dates_to_add = array_unique(explode(', ', sanitize_text_field($_POST['dates_to_add'])));
            $user_role = current_user_can('administrator') ? 'admin' : 'staff';
            $user_id = get_current_user_id();
    
            foreach ($dates_to_add as $date) {
                $formatted_date = date('Y-m-d', strtotime($date));
    
                if (!$this->is_date_stored($formatted_date, $user_id)) {
                    $wpdb->insert(
                        "{$wpdb->prefix}wpb_holidays",
                        [
                            'holiday_dates' => $formatted_date,
                            'user_role' => $user_role,
                            'user_id' => $user_id
                        ],
                        ['%s', '%s', '%d']
                    );
                }
            }
        }
    
        // Check if dates to remove are provided
        if (!empty($_POST['dates_to_remove'])) {
            $dates_to_remove = array_unique(explode(', ', sanitize_text_field($_POST['dates_to_remove'])));
            $user_role = current_user_can('administrator') ? 'admin' : 'staff';
            $user_id = get_current_user_id();
    
            foreach ($dates_to_remove as $date) {
                $formatted_date = date('Y-m-d', strtotime($date));
    
                $wpdb->delete(
                    "{$wpdb->prefix}wpb_holidays",
                    [
                        'holiday_dates' => $formatted_date,
                        'user_role' => $user_role,
                        'user_id' => $user_id
                    ],
                    ['%s', '%s', '%d']
                );
            }
        }
    
        wp_send_json(array(
            'status' => 'success',
            'message' => esc_html__('Holidays settings have been saved successfully.', 'wpbookit'),
            'option_value' => true
        ));
    }
    

    public function get_holiday_dates() {
        global $wpdb;

        $user_role = current_user_can('administrator') ? 'admin' : 'staff';
        $user_id = get_current_user_id();
        
        $year = isset($_GET['year']) ? intval($_GET['year']) : null;

        if ($year) {
            $query = $wpdb->prepare(
                "SELECT holiday_dates FROM {$wpdb->prefix}wpb_holidays WHERE YEAR(holiday_dates) = %d AND user_role = %s AND user_id = %d",
                $year, $user_role, $user_id
            );
        } else {
            $query = $wpdb->prepare(
                "SELECT holiday_dates FROM {$wpdb->prefix}wpb_holidays WHERE user_role = %s AND user_id = %d",
                $user_role, $user_id
            );
        }

        // Execute the query
        $results = $wpdb->get_col($query);

        if ($results) {
            wp_send_json_success($results);
        } else {
            wp_send_json_error('No dates found.');            
        }
    }

    public function get_existing_holiday_dates($user_id) {
        global $wpdb;

        return $wpdb->get_col($wpdb->prepare(
            "SELECT holiday_dates FROM {$wpdb->prefix}wpb_holidays WHERE user_id = %d",
            $user_id
        ));
    }

    // Helper function
    private function is_date_stored($date, $user_id) {
        global $wpdb;

        $result = $wpdb->get_var($wpdb->prepare(
            "SELECT COUNT(*) FROM {$wpdb->prefix}wpb_holidays WHERE holiday_dates = %s AND user_id = %d",
            $date, $user_id
        ));

        return $result > 0;
    }

    public function get_holiday_dates_staff() {
        global $wpdb;
        $user_id = get_current_user_id();
        $staff_id = isset($_GET['staff_id']) ? intval($_GET['staff_id']) : $user_id;
        $year = isset($_GET['year']) ? intval($_GET['year']) : null;
    
        if ($year) {
            $query = $wpdb->prepare(
                "SELECT holiday_dates FROM {$wpdb->prefix}wpb_holidays WHERE YEAR(holiday_dates) = %d AND user_id = %d",
                $year, $staff_id
            );
        } else {
            $query = $wpdb->prepare(
                "SELECT holiday_dates FROM {$wpdb->prefix}wpb_holidays WHERE user_id = %d",
                $staff_id
            );
        }
    
        // Execute the query
        $results = $wpdb->get_col($query);
    
        if ($results) {
            wp_send_json_success($results);
        } else {
            wp_send_json_error('No dates found.');            
        }
    }
    
    
}
