<?php
final class WPB_Staff_Controller
{
    public function get_staff_callback(WP_REST_Request $request) {

        
         
        $args = array(
            'status'        => [],
            'per_page'      => $request->get_param('length'),
            'order'         => 'DESC',
            'order_by'      => 'user_registered',
            'offset'        => $request->get_param('start'),
            'role'          => WPBOOKIT()->helpers->get_staff_role(),
            'paged'         => $request->get_param('paged') ?? 1,
        );
        
        if ($request->has_param('customer_search')) {
            $args['search'] = '*'.esc_attr($request->get_param('customer_search')).'*';
            $args['search_columns'] = array('display_name','user_email');
        }

        if ($request->has_param('order')) {
            if ($request->get_param('order')[0]['name'] == 'staff-dob' ) {
                $args['meta_key'] = 'date_of_birth';
                $args['order'] = strtoupper($request->get_param('order')[0]['dir'] ?? '');   
                $args['orderby'] = 'meta_value';
            }elseif($request->get_param('order')[0]['name'] == 'staff-name'){
                $args['order'] = strtoupper($request->get_param('order')[0]['dir'] ?? '');   
                $args['orderby'] = 'email';
            }elseif($request->get_param('order')[0]['name'] == 'staff-id'){
                $args['order'] = strtoupper($request->get_param('order')[0]['dir'] ?? '');   
                $args['orderby'] = 'ID';
            } 
            else{
                $args['order'] = strtoupper($request->get_param('order')[0]['dir'] ?? '');
                $args['order_by'] = $request->get_param('order')[0]['name'] ?? "";
            }
        }
        if ($request->has_param('include')) {
            $args['include'] = $request->get_param('include') ?? null;
        }

        $user_query = new WP_User_Query( $args );
        $users = $user_query->get_results();
        $data = array_map(function ($item) {
            $user__profile_url =  wp_get_attachment_url(get_user_meta($item->ID, "wp_user_avatar", true)??0);
            return [
                'id'        => $item->ID,
                'custom_note' => empty(get_user_meta($item->ID, "custom_note", true)) ? '' : get_user_meta($item->ID, "custom_note", true),
                'name'      => $item->display_name,
                'profile_img' => $user__profile_url === false ?get_avatar_url(0, ['size' => 50]) :$user__profile_url,
                'is_staff_image' => $user__profile_url === false ? false : true,
                'tddob'     => get_user_meta($item->ID, "date_of_birth", true),
                'dob'       => empty(get_user_meta($item->ID, "date_of_birth", true)) ? '-' : wpb_get_formated_date_time(get_user_meta($item->ID, "date_of_birth", true), ''),
                'phone'     => empty(get_user_meta($item->ID, "phone", true)) ? '-' : get_user_meta($item->ID, "phone", true),
                'email'     => $item->user_email,
                'gender'    => empty(get_user_meta($item->ID, "gender", true)) ?  '-' : get_user_meta($item->ID, "gender", true),
                'user_registred' => wpb_get_formated_date_time($item->user_registered, ''),
                'dialCode'    => empty(get_user_meta($item->ID, "dialCode", true)) ?  '' : get_user_meta($item->ID, "dialCode", true),
                'iso2'    => empty(get_user_meta($item->ID, "iso2", true)) ?  '' : get_user_meta($item->ID, "iso2", true),
                'actions'   => [
                    "edit"      => true,
                    "delete"    => true,
                ],
            ];
        }, $users);

        wp_send_json(array(
            "recordsTotal" =>  count($users) ?? 0,
            "recordsFiltered" =>   count($users) ?? 0,
            "data" => $data
        ));}
    public function refresh_staff_table_callback(WP_REST_Request $request)
    {
        $paged              = $request->get_param('paged') ?? 1;
        $staffObj           = new WPB_Settings_Staff();
        $columns            = $staffObj->get_staff_column();
        $staff_user         = $staffObj->get_staffs($paged);
        $staffs             = $staff_user->get_results();
        $total_users 		= $staff_user->get_total();
        $staff_page_total   = count($staffs);
        $total_pages 		= ceil( $total_users / $staffObj->users_per_page);
        $staff_total_page   = ($staff_page_total < $staffObj->users_per_page) ? $staff_page_total : $staffObj->users_per_page;

        $pagination_output  = wpb_get_pagination( $total_pages,$paged, 'staff' );
        ob_start();
        require_once IQWPB_PLUGIN_PATH ."core/admin/views/settings/html-admin-settings-staff.php";
        $html_content = ob_get_clean();
        wp_send_json_success([
            "html_content" => $html_content,
            "paged" => $paged,
        ]); 
    }
    public function delete_staff_callback(WP_REST_Request $request)
    {
        $user_id = $request->get_param("delete_user_id");
        if (wp_verify_nonce( $data['_ajax_nonce'], 'wpb_ajax_nonce' ) ) :
            if (!is_numeric($user_id)):
                $response_data = [
                    "status" => 'error',
                    "message" => esc_html__('Invalid user ID','wpbookit'),
                ];
            endif;
            // Delete the user
            if (wp_delete_user($user_id)):
                $response_data = [
                    "status" => 'success',
                    "message" => esc_html__("Staff Deleted Successfully.",'wpbookit'),
                ];
            else:
                $response_data = [
                    "status" => 'error',
                    "message" => esc_html__("Error Deleting Customer.",'wpbookit'),
                ];
            endif;
        else:
            $response_data = [
                "status"    => 'error',
                "message"   => esc_html__("Token Verification Failed.",'wpbookit'),
            ];
            
        endif;
        wp_send_json( $response_data );
    }
    public function edit_newdata_staff_callback(WP_REST_Request $request)
    {
            $data = $request->get_params();
            if (wp_verify_nonce( $data['_ajax_nonce'], 'wpb_ajax_nonce' ) ) :
            $image_url      = $request->get_file_params();
            $first_name     = isset($data["first-name"]) ? sanitize_text_field($data["first-name"]) : '';
            $last_name      = isset($data["last-name"]) ? sanitize_text_field($data["last-name"]) : '';
            $display_name   = trim($first_name . ' ' . $last_name);
            $edit_email     = $data["email"];
            $edit_gender    = isset($data["gender"]) ? sanitize_text_field($data["gender"]) : '';
            $edit_dob       = isset($data["dob"]) ? sanitize_text_field($data["dob"]) : '';
            $edit_phone     = isset($data["phone"]) ? sanitize_text_field($data["phone"]) : '';
            $edit_notes     = isset($data["notes"]) ? sanitize_text_field($data["notes"]) : '';
            $user_id        = isset($data["edit-staff-id"]) ? $data["edit-staff-id"] : null;
            $edit_image_url = isset($image_url["add-image"])? $image_url["add-image"]: null;
            $iso2              = sanitize_text_field($data["iso2"]);
            $dialCode              = sanitize_text_field($data["dialCode"]);
            $default_img_url =    IQWPB_PLUGIN_URL . "core/admin/assets/images/avatar.png";
          
            if (is_null($user_id)):
                $response_data = [
                    "status" => 'error',
                    "message" => esc_html__("Missing Customer ID",'wpbookit'),
                ];
            else:
                $tmp_file_path = $edit_image_url["tmp_name"];
                if ($tmp_file_path == ""):
                    $response = wp_update_user([
                        "ID" => $user_id,
                        "display_name" =>$display_name,
                        "user_email" => $edit_email,
                        "first_name" => $first_name,
                        "last_name" => $last_name,
                        "meta_input" => [
                            "phone" => $edit_phone,
                            "custom_note" => $edit_notes,
                            "gender" =>$edit_gender,
                            "date_of_birth" =>$edit_dob,
                            "wp_user_avatar" => $default_img_url,
                            'iso2' => $iso2,
                            'dialCode' => $dialCode,
                        ],
                    ]);
                
                    if (is_wp_error($response)):
                        $response_data = [
                            "status" => 'error',
                            "message" => esc_html__("Failed to update staff.",'wpbookit'),
                        ];
                       
                    elseif ($response === false):
                        $response_data = [
                            "status" =>  'error',
                            "message" => esc_html__("Staff Update failed.",'wpbookit'),
                        ];
                       
                    else:
                        $response_data = [
                            "status" => 'success',
                            "message" => esc_html__("Staff Updated Successfully.",'wpbookit'),
                        ];
                     
                    endif;
                
                else:
                    $image_upload = $this->image_upload_handle($user_id,$tmp_file_path,$edit_image_url);
                    if ($image_upload == "error"):
                        $response_data = [
                            "status" =>  'error',
                            "message" => esc_html__("Error sideloading image",'wpbookit'),
                        ];
                        
                    else:
                        $response = wp_update_user([
                            "ID" => $user_id,
                            "display_name" => $display_name,
                            "user_email" => $edit_email,
                            "first_name" => $first_name,
                            "last_name" => $last_name,
                            "meta_input" => [
                                "phone" => $edit_phone,
                                "custom_note" => $edit_notes,
                                "gender" =>$edit_gender,
                                "date_of_birth" =>$edit_dob,
                                'iso2' => $iso2,
                                'dialCode' => $dialCode,
                            ],
                        ]);

                        if (is_wp_error($response)):
                            $response_data = [
                                "status" =>  'error',
                                "message" => esc_html__("Failed to update staff.",'wpbookit'),
                            ];
                            
                        elseif ($response === false):
                            $response_data = [
                                "status" =>  'error',
                                "message" => esc_html__("Staff Update Failed.",'wpbookit'),
                            ];
                           
                        else:
                            
                            $response_data = [
                                "status" => 'success',
                                "message" => esc_html__("Staff Updated Successfully.",'wpbookit'),
                            ];
                        endif;
                    endif;
                endif;
            endif;
        else:
            $response_data = [
                "status"    =>  'error',
                "message"   => esc_html__("Token Verification Failed.",'wpbookit'),
            ];
            
        endif;
        wp_send_json( $response_data );
    }
    public function add_newdata_staff_callback(WP_REST_Request $request)
    {
        $data = $request->get_params();
        if (wp_verify_nonce( $data['_ajax_nonce'], 'wpb_ajax_nonce' ) ) :
           
            $image_url = $request->get_file_params();
            $first_name = sanitize_text_field($data["first-name"]);
            $last_name = sanitize_text_field($data["last-name"]);
            $email = strtolower(sanitize_email($data["email"]));
            $phone = sanitize_text_field($data["phone"]);
            $gender = sanitize_text_field($data["gender"]);
            $dob = sanitize_text_field($data["dob"]);
            $notes = sanitize_text_field($data["notes"]);
            $add_image_url = isset($image_url["add-image"]) ? $image_url["add-image"] : null;
            $iso2              = sanitize_text_field($data["iso2"]);
            $dialCode              = sanitize_text_field($data["dialCode"]);

            $password = wp_generate_password();
            // $hashed_password = wp_hash_password($password);
            $user_data = apply_filters("wpb_insert_staff", [
                "user_login" => $email, // The username for the new user
                "user_email" => $email, // The email address of the new user
                "user_pass" => $password, // The password for the new user
                "first_name" => $first_name, // The first name of the new user
                "last_name" => $last_name, // The last name of the new user
                "role" => WPBOOKIT()->helpers->get_staff_role(),
                "meta_input" => [
                    "phone" => $phone,
                    "gender" => $gender,
                    "date_of_birth" => $dob,
                    "custom_note" => $notes,
                    'iso2' => $iso2,
                    'dialCode' => $dialCode,
                ],
                "user_registered" => date("Y-m-d H:i:s"),
            ]);
            $user_id = wp_insert_user($user_data);
            if (is_wp_error($user_id)) :
                $error_message = $user_id->get_error_message();
                wp_send_json([
                    "status" => 'error',
                    "message" => str_replace("username", "email", $error_message),
                ]);
            else:
                $wp_user_instance = get_user_by('ID', $user_id);

                do_action('wpb_staff_registration', $wp_user_instance, $password);
                $tmp_file_path = $add_image_url["tmp_name"];
                if ($tmp_file_path == ""):
                    $response_data = [
                        "status" =>  'success',
                        "message" =>  esc_html__("Staff Created Successfully.",'wpbookit'),
                    ];

                else:
                    $image_upload = $this->image_upload_handle($user_id,$tmp_file_path,$add_image_url);
                    if ($image_upload == "error"):
                        $response_data = [
                            "status" =>  'error',
                            "message" =>  esc_html__("Error Image Uploading",'wpbookit'),
                        ];
                       
                    else:
                        $response_data = [
                            "status" =>  'success',
                            "message" =>  esc_html__("Staff Created Successfully.",'wpbookit'),
                        ];
          
                    endif;
                endif;
            endif;
        else:
            $response_data = [
                "status"    => 'error',
                "message"   => esc_html__("Token Verification Failed.",'wpbookit'),
            ];
   
        endif;
        wp_send_json( $response_data );
    }
    public function image_upload_handle($user_id,$tmp_file_path,$add_image_url) {
        $file_name = basename($add_image_url["name"]);
        $uploads_dir = wp_upload_dir();
        $destination_file_path = $uploads_dir["path"] . "/" . $file_name;

        // Move the uploaded file to the destination path
        if (move_uploaded_file($tmp_file_path, $destination_file_path)):
            $file_url = $uploads_dir["url"] . "/" . $file_name;

            // Attempt to sideload the image
            $return_type = "id";
            $attachment_id = media_sideload_image($file_url,"","avatar",$return_type);
            $attachment_url = wp_get_attachment_url($attachment_id);

            // Check if sideloading was successful
            if (!is_wp_error($attachment_id) && $attachment_id):
                // Image successfully sideloaded, update user meta with attachment ID
                update_user_meta($user_id, "wp_user_avatar", $attachment_id);
                return $attachment_url; // Return the attachment ID
            else:
                // Sideload failed, handle the error
                return "error"; // Return an error message
            endif;
        else:
            // Move uploaded file failed, handle the error
            return "error";
        endif;
    }

    
}
