<?php

/**
 * WPB Admin Settings Design Class
 */

if (!class_exists('WPB_Settings_Staff', false)) :

	/**
	 * WPB_Settings_Staff Class.
	 */
	class WPB_Settings_Staff extends WPB_Setting_Page
	{
		public $paged;
		public $users_per_page;
		function __construct()
		{
			$this->id    			= 'staff';
			$this->label 			= esc_html__('Staff', 'wpbookit');
			$this->icon 			= IQWPB_PLUGIN_PATH . '/core/admin/assets/images/menu-icons/customer-icon.svg';
			$this->type 			= esc_html__('USER', 'wpbookit');
			$this->paged 			= $_GET['paged'] ?? 1;
			$this->users_per_page 	= 5;
			$this->priority         = 60;

			if( current_user_can( 'administrator' ) ) :
				parent::__construct();
			endif;
		}

		public function get_settings_html()
		{
			$user_per_page = 5;
			$columns 			= $this->get_staff_column();
			$staff_user 				= $this->get_staffs($this->paged);
			$staffs 			= $staff_user->get_results();
			$per_page_user = $this->users_per_page;
			$total_users 		= $staff_user->get_total();
			$staff_total_page		= count($staffs);
			$total_pages 		= ceil($total_users / $this->users_per_page);
			$pagination_output  = wpb_get_pagination($total_pages, $this->paged, $this->id);

			include IQWPB_PLUGIN_PATH . '/core/admin/views/settings/html-admin-settings-staff.php';
		}

		public function get_staff_column()
		{
			return apply_filters(
				'wpb_add_staff_columns',
				array(
					'staff-id'  		=> esc_html__('ID', 'wpbookit'),
					'staff-name'  		=> esc_html__('User', 'wpbookit'),
					'staff-dob'    		=> esc_html__('Date of Birth', 'wpbookit'),
					'staff-phone'    	=> esc_html__('Phone', 'wpbookit'),
					'staff-gender'   	=> esc_html__('Gender', 'wpbookit'),
					'staff-date-time'   => esc_html__('Created', 'wpbookit'),
					'staff-actions' 	=> esc_html__('Action', 'wpbookit'),
				)
			);
		}
		public function get_staffs($current_page)
		{
			return new WP_User_Query(
				apply_filters(
					'wpb_get_staffs_query_args',
					array(
						'role'    => WPBOOKIT()->helpers->get_staff_role(),
						'orderby' => 'ID',
						'order'   => 'DESC',
						'number' => $this->users_per_page,
						'paged' =>  $current_page,
					)
				)
			);
		}
		public function get_all_staffs()
		{
			return new WP_User_Query(
				apply_filters(
					'wpb_get_all_staffs_query_args',
					array(
						'role'    => WPBOOKIT()->helpers->get_staff_role(),
						'orderby' => 'ID',
						'order'   => 'DESC',

					)
				)
			);
		}
	}
	new WPB_Settings_Staff();
endif;
