<?php

/**
 * JT Admin Settings Design Class
 */

if (!class_exists('WPB_Settings_Tax', false)) :

	/**
	 * WPB_Settings_calender Class.
	 */
	class WPB_Settings_Tax extends WPB_Setting_Page
	{
		public $per_page;
		public $id;

		function __construct()
		{
			$this->id 			= 'taxes';
			$this->label 		= esc_html__('Taxes', 'wpbookit');
			$this->icon 		= IQWPB_PLUGIN_PATH . 'core/admin/assets/images/menu-icons/tax-icon.svg';
			$this->per_page 	= 5;
			$this->priority     = 90;
			$this->type         = esc_html__( 'FINANCE', 'wpbookit' );

			parent::__construct();
		}

		public static function get_table_column()
		{
			return apply_filters(
				'wpb_tax_columns',
				array(
					'tax_name'    			=> esc_html__('Tax Name', 'wpbookit'),
					'tax_rate'    			=> esc_html__('Tax Rate', 'wpbookit'),
					'tax_booking_type'  	=> esc_html__('Booking Type', 'wpbookit'),
					'tax_priority'  		=> esc_html__('Tax Priority', 'wpbookit'),
					'status' 				=> esc_html__('Status', 'wpbookit'),
					'actions' 				=> esc_html__('Actions', 'wpbookit'),
				)
			);
		}

		public function get_taxes($current_page = 1)
		{
			return  (object)['results' => [], 'total' => 25, 'maxnumpages' => 10];
		}

		public function get_settings_html()
		{
			$current_page 	= $_GET['paged'] ?? 1;
			$columns 		= self::get_table_column();
			$taxes 			= $this->get_taxes($current_page);

			$booking_types  = wpb_get_all_booking_types(
				array(
					'staff'	=> current_user_can('administrator') ? false : get_current_user_id(),
					'charges' => 'paid',
					'per_page'  => 99,
				)
			);
			include IQWPB_PLUGIN_PATH . '/core/admin/views/settings/html-admin-settings-tax.php';
		}
	}
	if(apply_filters('iqwpb_has_access',current_user_can( 'administrator' ))){
		new WPB_Settings_Tax();
	}
endif;
