<?php
/**
 * Regular Payment
 *
 */

defined( 'ABSPATH' ) || exit;

/**
 * Payment Class.
 */
class WPB_Calendar_Feed {
	
    public function __construct() {
		add_action('init', array($this, 'wpb_ical_feed') );

        $secure_hash = md5( 'wpb_ical_feed_' . get_site_url() );
        
        define('WPB_SECURE_HASH',$secure_hash);
	}

    public function wpb_ical_feed(){
		if (isset($_GET['wpbookit_ical'])){
			// Get the directory path of the current file
			$current_dir = dirname(__FILE__);
	
			// Construct the path to wpb-calendar-feed.php
			$calendar_feed_file = $current_dir . '/../wpb-calendar-feed.php';
	
			// Check if the file exists before including it
			if (file_exists($calendar_feed_file)) {
				include($calendar_feed_file);
				exit;
			} else {
				// Handle the case where the file doesn't exist
				echo 'Error: wpb-calendar-feed.php not found.';
				exit;
			}
		}
	}
	
}
