<?php

/**
 * WPBookit PayPal Payment Integration
 *
 */

use Omnipay\Omnipay;

defined('ABSPATH') || exit;


class WPB_Paypal_Init
{

	public $payment_gateway = 'paypal';

	private $depandancy_files=[];

	public function __construct()
	{
		add_filter('wpb_booking_shortcode_active_payment_gateway', array($this, 'wp_add_paypal_payment_gateway'));
		add_filter("wpb_booking_" . $this->payment_gateway, array($this, 'wpb_paypal_booking_payment'), 10, 4);

		add_action('wp_ajax_wpb_paypal_payment',[$this,'wpb_capture_paypal_payment']);
		add_action('wp_ajax_nopriv_wpb_paypal_payment',[$this,'wpb_capture_paypal_payment']);
	}
	public function wp_add_paypal_payment_gateway($active_payments)
	{
		$active_payments[$this->payment_gateway] = esc_html__("PayPal", 'wpbookit');
		return $active_payments;
	}

	public function  wpb_paypal_booking_payment($errormsg, WPB_Booking_Type $booking_type_instance,WPB_Booking $wpb_booking,$payment_id)
	{
		global $wpdb;

		try {
			$gateway= $this->wpb_get_paypal_config();
			if($gateway==false){
				throw new Exception("PayPal Payment Gateway Not Config");
			}
			$general_setting_data = get_option('wpb_general_setting_data');
			// Add or modify query arguments
			$payment_redirect_url = add_query_arg( array(
				'action' => 'wpb_paypal_payment',
				'wpb_payment_id' => $payment_id,
			), admin_url('admin-ajax.php') );

			$paid_amount= $wpdb->get_var("SELECT `paid_amount` FROM {$wpdb->wpb_payments} WHERE `id` LIKE {$payment_id}");
			
			$params = array(
                'amount' => (double)$paid_amount,
                'currency' => $general_setting_data['currency']??"USD",
                'returnUrl' => add_query_arg( array(
					'payment_status' => 'success',
				), $payment_redirect_url ),
                'cancelUrl' => add_query_arg( array(
					'payment_status' => 'cancle',
				), $payment_redirect_url ),
            );
			
			$response = $gateway->purchase($params)->send();
			if(!$response->isSuccessful()){
				return [
					'status'  => 'error',
					'message'  => $response->getMessage() ,
				];
			}
			
			return [
				'status'  => 'success',
				'message'  => esc_html__("Your reservation has been successfully booked!. Please wait for open payment window.",'wpbookit') ,
				'payment_redirect' => $response->getRedirectUrl()
			];
		} catch (Throwable $th) {
			return [
				'status'  => 'error',
				'message'  => current_user_can('administrator') ? sprintf( esc_html__( "Paypal ERROR: Booking creation failed with the message: %s" ), $th->getMessage() ) : esc_html__( 'There was an issue processing your payment. please contact site admin.', 'wpbookit' ),
			];
		}
		
	}

	private function wpb_get_paypal_config()  {

		$payment_gateway_config= get_option('wpb_payment_gateways')['paypal']??false;

		if($payment_gateway_config==false && $payment_gateway_config['wpb_paypal_status']??false != "on" ){
			return false;
		}

		
		$gateway = Omnipay::create('PayPal_Rest');
        $gateway->setClientId(trim($payment_gateway_config['wpb_paypal_payment_client_id']));
        $gateway->setSecret( trim($payment_gateway_config['wpb_paypal_payment_client_secret']) );
        $mode = $payment_gateway_config['wpb_paypal_payment_mode'] ;
        $developerMode = $mode == 'sandbox';
        if($developerMode){
            if (method_exists($gateway, 'setDeveloperMode')) {
                $gateway->setDeveloperMode(true);
            } else {
                $gateway->setTestMode(true);
            }
        }else{
            $gateway->setTestMode(false);
        }
        return $gateway;
	}

	public function wpb_capture_paypal_payment() {
		if(isset($_GET['payment_status'])&& !empty($_GET['payment_status']) && isset($_GET['wpb_payment_id'])&& !empty($_GET['wpb_payment_id']) ){
			global $wpdb;
				
			$booking_id= $wpdb->get_var("SELECT `bookings_id` FROM {$wpdb->wpb_payments} WHERE id LIKE {$_GET['wpb_payment_id']}");
			
			$booking_instance= new WPB_Booking($booking_id);
			$booking_type_instance= $booking_instance->get_booking_type('view',['id'],false);
			$booking_type_instance= (new WPB_Booking_Type($booking_type_instance['id']));

			if($_GET['payment_status'] == 'success'){
				$wpdb->update($wpdb->wpb_payments,['payment_status' => 1,'transaction_id'=>$_GET['paymentId']],['id' => $_GET['wpb_payment_id']]);
				$default_booking_status = 'wpb-' . wpb_get_general_settings()['booking_status'];
				if ($default_booking_status === 'wpb-approved') {
					do_action('wpb_customer_booking_confirmation', (int) $booking_id);
					wpb_booking_reminder($booking_id);
				} else if ($default_booking_status === 'wpb-pending') {
					do_action('wpb_staff_booking_request', (int) $booking_id);
				}
				$wpdb->update($wpdb->wpb_bookings, ['status' => 'wpb-approved'], ['id' => (int)$booking_id]);
				wp_redirect(wpb_iq_get_booking_redirect_url($booking_instance,$booking_type_instance));
				die;
			}else{
				$wpdb->update($wpdb->wpb_bookings, ['status' => 'wpb-cancelled'], ['id' => (int)$booking_id]);
				$wpdb->update($wpdb->wpb_payments,['transaction_id'=>false],['id' => $_GET['wpb_payment_id']]);
				wp_redirect(wpb_iq_get_booking_redirect_url($booking_instance,$booking_type_instance,false));
				die;
			}
		}
		wp_redirect(home_url());
		die;
	}
	
	
}
new WPB_Paypal_Init();
