<?php

if (!isset($_GET['sh']) || isset($_GET['sh']) && $_GET['sh'] != WPB_SECURE_HASH)
	wp_die('<strong>Calendar Feed Requirements:</strong><br>The Booked calendar feeds now require a secure hash to access. Please take a look at your "Bookings > Calendar Feeds" page for the updated feed URLs.');

header('Content-type: text/calendar; charset=utf-8');
header('Content-Disposition: attachment; filename=wpb-booking-feed-' . IQWPB_VERSION . '.ics');

if (isset($_GET['calendar']) && $_GET['calendar']) :
	$calendar_id = esc_html($_GET['calendar']);
else :
	$calendar_id = false;
endif;

// 1 year ago to 5 years later.
$from_timestamp = strtotime(date('Y-m-01', strtotime("-1 year")));
$to_timestamp = strtotime(date('Y-m-d', strtotime("+5 years")));

if ($calendar_id) :
	$calendar_name = get_term_by('id', $calendar_id, IQWPB_BOOKING_TAXONOMY_TYPE);
	$calendar_name = $calendar_name->name;
endif;

$appts_in_this_timeslot = $bookings_array = array();

$_REQUEST['booking_type']=isset($_REQUEST['booking_type']) ? [sanitize_text_field($_REQUEST['booking_type'])] : [];

$booking_timestamp_range = array($from_timestamp, $to_timestamp);
$bookedBookings = wpb_booking_list($calendar_id, $booking_timestamp_range, -1,$_REQUEST['booking_type']);
if (!empty($bookedBookings->results)) {
    foreach ($bookedBookings->results as $bookedBooking) {

        // Get booking ID
        $booking_id = $bookedBooking->get_id();

        // Get other booking properties similarly
        $booking_status = $bookedBooking->get_status();
        $booking_user_id = $bookedBooking->get_customer_id();
        $booking_booking_date = $bookedBooking->get_booking_date();
        $booking_booking_date_timestamp = strtotime($booking_booking_date);
        $booking_booking_timeslot = $bookedBooking->get_timeslot();
        $booking_booking_duration = $bookedBooking->get_duration();
        $booking_booking_type = $bookedBooking->get_booking_type()['name'];
		
        // Store booking information in the $bookings_array or any other logic as needed
        $bookings_array[$booking_id]['timestamp'] = $booking_booking_date_timestamp;
        $bookings_array[$booking_id]['timeslot'] = $booking_booking_timeslot;
        $bookings_array[$booking_id]['duration'] = $booking_booking_duration;
        $bookings_array[$booking_id]['status'] = $booking_status;
        $bookings_array[$booking_id]['user'] = $booking_user_id;
        $bookings_array[$booking_id]['type'] = $booking_booking_type;
        $appts_in_this_timeslot[] = $booking_id;
    }
}

// Output the beginning of the iCalendar file
echo "BEGIN:VCALENDAR\r\n";
echo "VERSION:2.0\r\n";
echo "PRODID:-//getbooked.io//Booked Calendar\r\n";
echo "CALSCALE:GREGORIAN\r\n";

if (!empty($appts_in_this_timeslot)) :
    // Iterate through each booking
    foreach ($appts_in_this_timeslot as $appt_id) :
        // Start a new event
        echo "BEGIN:VEVENT\r\n";

		// Get booking details
		$timestamp = $bookings_array[$appt_id]['timestamp'];
		$timeslot = $bookings_array[$appt_id]['timeslot'];
		$duration = $bookings_array[$appt_id]['duration'];
		$email = $bookings_array[$appt_id]['user'];
		

		$formatted_start_date = formatDateTimeWithTimezone($timestamp, $timeslot) . 'Z';
    	$formatted_end_date = formatDateTimeWithTimezone($timestamp, $timeslot, $duration) . 'Z';

		$summary = !empty($calendar_name) ? $calendar_name : (!empty($bookings_array[$appt_id]['type']) ? $bookings_array[$appt_id]['type'] : 'Bookings');

		// Format the description
		$description = $email ? $email . "\r\n" : "";
		$description = str_replace("\r\n", "\\n", $description);

		// Output event properties
		echo "DTSTAMP:" . dateToCal(time()) . "Z\r\n";
		echo "DTSTART:" . $formatted_start_date . "\r\n";
		echo "DTEND:" . $formatted_end_date . "\r\n";
		echo "SUMMARY:" . $summary . "\r\n";
		echo "DESCRIPTION:" . $description . "\r\n";
		echo "UID:booked-booking-" . $appt_id . "\r\n";

		// End the event
		echo "END:VEVENT\r\n";
		
    endforeach;
endif;

// Output the end of the iCalendar file
echo "END:VCALENDAR";

/* Convert Dates */
function dateToCal($timestamp, $all_day = false)
{
    if ($all_day) {
        return date('Ymd', strtotime(get_gmt_from_date(date('Y-m-d H:i:s', $timestamp))));
    } else {
        return date('Ymd\THis', strtotime(get_gmt_from_date(date('Y-m-d H:i:s', $timestamp))));
    }
}

function clean_calendarString($string = false)
{
	if ($string) :
		preg_match_all("/<\!--([\\s\\S]*?)-->/", $string, $matches);
		if (isset($matches[0]) && !empty($matches[0])) :
			foreach ($matches[0] as $match) :
				$string = str_replace($match, '', $string);
			endforeach;
		endif;

		if (function_exists('mb_convert_encoding')) :
			$string = mb_convert_encoding($string, 'UTF-8');
		else :
			$string = htmlspecialchars_decode(utf8_decode(htmlentities($string, ENT_COMPAT, 'utf-8', false)));
		endif;

		return preg_replace("/([\,\;])/", "\\\$1", $string);

	else :

		return false;

	endif;
}

/* Convert Custom Fields */
function display_customFields($cf_fields)
{
	ob_start();

	foreach ($cf_fields as $field) :
		echo esc_html(trim($field['title'])) . "\\n";
		echo wp_kses_post(trim($field['content'])) . "\r\n";
	endforeach;

	return ob_get_clean();
}

function wpb_booking_list(
	int|bool|string $calendar_id = false,
	array $booking_timestamp_range = array(),
	int $limit = -1,
	$booking_type =[] ,
) {
	$args = $bookings = [];
	$bookings =  wpb_get_bookings(
		array(
			'booking_timestamp_range' => $booking_timestamp_range,
			'status' => array('Approved'),
			'booking_type'=> $booking_type
		)
	);

	return apply_filters('wpb_bookings_array', $bookings);
}


// Function to convert time to 24-hour format and remove colon
function convertTo24HourFormat($time) {
    // Extract hours and minutes
    list($hours, $minutes) = explode(":", $time);
    
    // Convert hours to 24-hour format
    $hours = intval($hours);
    
    // If the hours are in PM range, add 12 to the hours
    if ($hours < 12) {
        $hours += 12;
    }

    // Convert hours to 2 digits
    $hours = sprintf("%02d", $hours);

    // Concatenate hours and minutes without colon
    $time_24hour = $hours . $minutes;
    
    return $time_24hour;
}

// Add this function at the bottom of the file
function formatDateTimeWithTimezone($timestamp, $time, $duration = 0) {
    // Get WordPress timezone setting
    $wp_timezone = wp_timezone();
    
    // Create DateTime object with WordPress timezone
    $datetime = new DateTime();
    $datetime->setTimestamp($timestamp);
    $datetime->setTimezone($wp_timezone);
    
    // Set the time component
    list($hours, $minutes) = explode(':', $time);
    $datetime->setTime($hours, $minutes);

	// Add duration minutes if provided
    if ($duration > 0) {
        $datetime->modify("+{$duration} minutes");
    }
    
    // Convert to UTC for iCal format
    $datetime->setTimezone(new DateTimeZone('UTC'));
    
    // Format for iCal
    return $datetime->format('Ymd\THis');
    
}