<?php
/**
 * Template Name: WPB Booking Footer Template
 * Description: Custom footer template for WPB Booking plugin dynamic pages
 * 
 * This template file is designed to work with the WPB Booking plugin. It handles
 * the display of the footer section, including conditional rendering based on
 * general settings and allowing for custom footer content through hooks.
 *
 * @package WPB Booking Plugin
 * @subpackage Templates
 * @since 1.0
 */

// Security check
defined('ABSPATH') || exit;

// Get general settings
$general_settings = wpb_get_general_settings();

// Check if footer should be hidden
$hide_footer = isset($general_settings['hide-footer']) && $general_settings['hide-footer'] == '1';

// End of PHP code block
?>
        </div><!-- #content -->

         <?php if (!$hide_footer):
            do_action('wpb_footer_content');
        endif; ?>
       
        </div><!-- #page -->

        <?php wp_footer(); ?>

    </body>

</html>