<div>
    <?php
    $invoice_data = $args['invoice_data'];
    $customer_details_column = $args['customer_details_column'];
    $booking_details_column = $args['booking_details_column'];
    $tax_data = $args['tax_data']; ?>
    <div class="mt-4 pt-4 border-top">
        <div class="d-flex align-items-center justify-content-between gap-2 mb-2">
            <h6 class="mb-0" id="wpb_booking_type"><?php echo esc_html($invoice_data['customer_name']); ?></h6 class="mb-0">
            <span id="wpb_customer_address"><?php echo esc_html($invoice_data['customer_address']); ?></span>
        </div>
        <div class="d-flex align-items-center justify-content-between gap-2 mb-2">
            <h6 class="mb-0" id="wpb_payment_id"><?php echo esc_html($invoice_data['invoice_id']); ?></h6>
            <span id="wpb_customer_email"><?php echo esc_html($invoice_data['customer_email']); ?></span>
        </div>
        <div class="d-flex align-items-center justify-content-between gap-2 mb-2">
            <?php
            if (isset($invoice_data['payment_status']) && trim($invoice_data['payment_status']) === 'Paid') {
                esc_html_e($invoice_data['date_created']);
            } else {
                esc_html_e($invoice_data['booking_date']);
            }
            ?>
            </h6>
            <span id="wpb_booking_status"><?php esc_html_e('Payment Status: ', 'wpbookit'); ?><?php echo esc_html($invoice_data['payment_status']); ?></span>
        </div>
        <?php do_action('iqwpb_print_invoice_add_extra_fields',$invoice_data); ?>
    </div>
    <div class="mt-4 pt-4">
        <h5 class="mb-4"><?php esc_html_e('Customer Details', 'wpbookit'); ?></h5>
        <table id="datatable" class="table custome-table wpb-datatable dataTable no-footer table-custom-border" data-toggle="data-table" aria-describedby="datatable_info">
            <thead>
                <tr>
                    <?php foreach ($customer_details_column as $customer_details_id => $customer_details_name) : ?>
                        <th scope="col" class="sorting" tabindex="0">
                            <span class="nobr"><?php echo esc_html($customer_details_name); ?></span>
                        </th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <?php foreach ($customer_details_column as $customer_details_id => $customer_details_name) : ?>
                        <td scope="col" class="sorting" tabindex="0" id="<?php echo esc_attr($customer_details_id); ?>">
                            <span class="nobr"><?php echo esc_html($invoice_data[$customer_details_id]); ?></span>
                        </td>
                    <?php endforeach; ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="mt-4 pt-4">
        <h5 class="mb-3"><?php esc_html_e('Booking Details', 'wpbookit'); ?></h5>
        <table id="datatable" class="table custome-table wpb-datatable dataTable no-footer table-custom-border" data-toggle="data-table" aria-describedby="datatable_info">
            <thead>
                <tr>
                    <?php foreach ($booking_details_column as $booking_details_id => $booking_details_name) : ?>

                        <th scope="col" class="sorting" tabindex="0">
                            <span class="nobr"><?php echo esc_html($booking_details_name); ?></span>
                        </th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <?php foreach ($booking_details_column as $booking_details_id => $booking_details_name) : ?>
                        <td scope="col" class="sorting" tabindex="0" id="<?php echo esc_attr($booking_details_id); ?>">
                            <span class="nobr"><?php echo esc_html($invoice_data[$booking_details_id]); ?></span>
                        </td>
                    <?php endforeach; ?>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="mt-4 pt-4">
        <h5 class="mb-3"><?php esc_html_e('Payment Details', 'wpbookit'); ?></h5>
        <?php echo $invoice_data['html_content']; ?>
    </div>
</div>