<?php

defined('ABSPATH') || exit;

?>
<div class="row">
    <?php do_action('wpb_booking_shortcode_before_payment_tab_content', $args); 

    if ((int)($shortcode_instance->booking_type->get_meta('price')) > 0) : ?>
        <div class="col-lg-12 mb-2 pb-2">
            <div class="mt-2 pt-2 border-top">
                <label class="form-label d-block "><?php esc_html_e('Booking Summary', 'wpbookit'); ?></label>
                <div class="row">
                    <div class="col-md-12">
                        <div class="tax-module-table-wrapper" id="iqwpb-booking-summary">
                            <?php echo wp_kses_post($shortcode_instance->booking_totals_and_html['html_output']);?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php
if (($shortcode_instance->booking_type->get_meta('price')) > 0 && count($shortcode_instance->payment) > 0) : ?>
    <div class="row">
        <div class="col-lg-12">
            <label class="form-label"><?php esc_html_e("Payments", 'wpbookit') ?></label>
            <?php foreach ($shortcode_instance->payment as $key => $value) : ?>
                <div class="form-check">
                    <input class="form-check-input" required type="radio" name="wpb_payments_gateways" value="<?php echo esc_attr($key) ?>" id="<?php echo esc_html($key) ?>">
                    <label class="form-check-label" for="<?php echo esc_html($key) ?>"> <?php echo esc_html(wpb_get_payment_gateway_name($key)) ?> </label>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>