import flatpickr from "flatpickr";
import { get, post } from "../utils/ajax";
import notificationToast from "../utils/notification-toast";
import { Offcanvas } from 'bootstrap';
import FormDataJson from "form-data-json-convert";

export default class Payment {
    advancedFilterFlatpikerInstance;
    paymentDatatable
    paymentFilterSettings
    constructor() {

        const urlParams = new URLSearchParams(window.location.search);
        const start = urlParams.get('start');
        const end = urlParams.get('end');  
        if(start && end){
            this.paymentFilterSettings = {date_from: start, date_to: end}  
        }             
        this.init()
        this.loadDashboard()
        this.event_Handler();
        this.advanceFilter = jQuery('#payment-filters');
        this.payment_table = jQuery('#wpb-payment-tbl');
        this.paymentInvoice = jQuery('#payment_invoice');
        this.offcanvasElement = jQuery('.payment-filters');
        this.paginate = jQuery('#datatable_paginate');
        this.showing_msg = jQuery('#wpb-payment-paginate');
        this.offcanvas = new Offcanvas(this.offcanvasElement);
        this.paymentInvoiceOffcanvas = new Offcanvas('#payment_invoice');
        this.opencanvas();

        this.selectedDates = [];

    }
    init() {
        this.paymentDatatable = new DataTable('#wpb-payment-tbl', {
            "searching": false,
            "processing": true,
            "serverSide": true,
            "order": [
                [0, 'DESC']
            ],
            "paging": true,
            "lengthChange": false,
            "ajax": (data, callback, settings) => {
                if (this.paymentFilterSettings) {
                    data = { ...data, ...{ advanceFilter: this.paymentFilterSettings } }
                }
                return get('get_payment_list', data).then(resData => {
                    callback(resData)
                })
            },
            "columns": [
                {
                    "data": "payment_id",
                    "name": "payments.id",
                    "searchable": false
                },
                {
                    "data": "customer_name",
                    "name": 'bookings.booking_name',
                    "searchable": false,
                    "render": function (data, type, row) {
                        return `<div class="d-flex align-items-center gap-3">
                            <img class="rounded-pill img-fluid avatar-40" src="${row.customer_avatar}" alt="" loading="lazy">
                            <div class="media-support-info">
                                <h6 class="iq-sub-label">${data}</h6>
                                <p class="mb-0">${row.customer_email}</p>
                            </div>
                        </div>`;

                    },
                },

                {
                    "data": "payment_mode",
                    "name": 'payment_mode',
                    "orderable": false,
                    "searchable": false,

                },
                {
                    "data": "paid_amount",
                    "name": 'paid_amount',
                    "searchable": false,
                    "render": function(data, type, row) {
                        if (row.payment_status && row.payment_status.key === "0") {
                            return "-";
                        }
                        return data;
                    }
                },
                
                {
                    "data": "transaction_id",
                    "name": 'transaction_id',
                    "searchable": false,
                    "orderable": false,
                    "render": function (data, type, row) {
                        if (row.order_link) {
                            let a = document.createElement('a');
                            a.setAttribute('href', row.order_link)
                            a.setAttribute('target', '_blank')
                            a.classList.add('btn-link')
                            a.innerText = data;
                            return a
                        }

                        return data;
                    },
                },
                {
                    "data": "date_created",
                    "name": 'payments.date_created',
                    "searchable": false,
                },

                {
                    "data": "payment_status",
                    "name": 'payment_status',
                    "searchable": false,
                    "render": function (data, type, row) {
                        if (data === false) {
                            return '-'
                        }
                        let status = {
                            "1": 'primary',
                            "0": 'danger',
                        }

                        return `<span class="badge bg-${status[data.key]}-subtle p-2 text-${status[data.key]}">${data.label}</span>`;

                    },
                },

                {
                    "data": "action",
                    "render": function (data, type, row) {

                        let render = '';

                        render += `
                                <a href="#" data-id="${row.payment_id}" class=" payment_invoice-booking-button">
                                <img src="${wpbookit.wpb_plugin_url}core/admin/assets/images/Document.svg" alt="checked">
                                <svg class="spinner wpb-notification-svg" style="display:none;" height="18" width="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                        <path fill="#d3d3d3" d="M304 48c0 26.5-21.5 48-48 48s-48-21.5-48-48 21.5-48 48-48 48 21.5 48 48zm-48 368c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48zm208-208c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48zM96 256c0-26.5-21.5-48-48-48S0 229.5 0 256s21.5 48 48 48 48-21.5 48-48zm12.9 99.1c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48c0-26.5-21.5-48-48-48zm294.2 0c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48c0-26.5-21.5-48-48-48zM108.9 60.9c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48z"></path>
                                    </svg>
                            </a>`;


                        return `<div class="d-flex align-items-center gap-3">${render}</div>`;
                    },
                    "searchable": false,
                    "orderable": false,
                },
            ],
            language: window.wpbookit.datatable_language
        });

    }
    event_Handler() {
        jQuery(document).ready(this.intialize_datepicker());
        jQuery(document).ready(this.addEventListeners());

        jQuery(document.body).on("submit", "#payment_filters_form", (e) => this.SubmitbtnEventHandlers(e));
        jQuery(document.body).on("click", "#payments_paginations ul li", (e) => this.PaginatepaymentTable(e));
        jQuery(document.body).on("click", "#payment_inner #export-file", (e) => this.exporteventHandlers(e));
        jQuery(document.body).on("click", ".payment_invoice-booking-button", (e) => this.Payment_Invoice(e));

        jQuery(document.body).on("click", "#payment_canvas", (e) => this.Paymentinvoice(e));

        jQuery(document.body).on("click", "#wpb_invoice_submit", (e) => this.printinvoice(e));
        jQuery(document.body).on("click", "#wpb_apply_payment_reset", (e) => this.filters_reset(e));


    }
    filters_reset(e) {
        e.preventDefault();
        this.paymentFilterSettings = '';
        this.selectedDates = [];
        this.paymentDatatable.ajax.reload()
        jQuery('#payment_filters_form')[0].reset();
        jQuery('#payment_filters_form select').val(null).trigger('change');

    }

    exporteventHandlers(e) {
        e.preventDefault();

        post('export_payment_table').then(response => {
            var filename = 'payments.csv';
            var blob = new Blob([response], { type: 'text/csv' });
            var downloadLink = document.createElement('a');
            downloadLink.href = window.URL.createObjectURL(blob);
            downloadLink.download = filename;
            document.body.appendChild(downloadLink);
            downloadLink.click();
            document.body.removeChild(downloadLink);
        });
    }

    intialize_datepicker() {
        const self = this;
        this.advancedFilterFlatpikerInstance = flatpickr('#wpb-bookings-advanced-filter-flatpiker', {
            inline: true,
            disableMobile: true, 
            dateFormat: window.wpbookit.date_format,
            mode: "range",
            onChange: function (selectedDates, dateStr, instance) {
                self.handleDateRange(selectedDates, instance);
            },
            locale:window.wpbookit.flatpicker
        });

        this.bookingDateFlatpickerInstance = flatpickr('#wpb-datepicker', {
            dateFormat: window.wpbookit.date_format,
            disableMobile: true, 
            onChange: function (selectedDates, dateStr, instance) {
                self.handleDateRange(selectedDates, instance);
            },
            locale:window.wpbookit.flatpicker
        });
        document.getElementById('wpb_apply_payment_reset').addEventListener('click', function () {
            self.advancedFilterFlatpikerInstance.clear();
            self.bookingDateFlatpickerInstance.clear();
        });
    }
    loadDashboard() {
    }
    addEventListeners() {
        const dateRangeItems = document.querySelectorAll('.range-list li');
        dateRangeItems.forEach(item => {
            item.addEventListener('click', () => {
                this.handleDateRange(null, item.id);
            });
        });
    }
    OnChangePaymentStatus(value, id) {
        var data = [];
        data['status_value'] = value;
        data['data_id'] = id;
        this.status_ajax(data);


    }
    status_ajax(data) {
        post('change_payment_status', data).then(response => {
            // Success - no action needed
        }).catch(error => {
            console.error('Error fetching email details:', error);
        });
    }
    setStartEndDate(startDate, endDate) {
        // set start date and end date
        this.selectedDates[0] = startDate.toLocaleDateString('en-US', { year: 'numeric', day: '2-digit', month: 'long' });
        this.selectedDates[1] = endDate.toLocaleDateString('en-US', { year: 'numeric', day: '2-digit', month: 'long' });

        document.getElementById('wpb_filter_from_date').textContent = startDate.toLocaleDateString('en-US', { day: '2-digit', month: 'long', year: 'numeric' });
        document.getElementById('wpb_filter_to_date').textContent = endDate.toLocaleDateString('en-US', { day: '2-digit', month: 'long', year: 'numeric' });
    }
    handleDateRange(selectedDates, clickedItemId) {
        const dateRangeItems = document.querySelectorAll('.range-list li');
        dateRangeItems.forEach(item => {
            item.classList.remove('active');
        })

        const clickedItem = document.getElementById(clickedItemId);
        if (clickedItem) {
            clickedItem.classList.add('active');
        }

        const dateRangeHandlers = {
            'wpb_today_btn': this.getToDay,
            'wpb_get_last_30_days': this.getLast30DaysRange,
            'wpb_this_month_btn': this.getMonthDateRange,
            'wpb_last_month_btn': this.getLastMonthDateRange,
            'wpb_get_last_90_days': this.getLast90DaysRange,
            'wpb_get_last_6_months': this.getLast6MonthsRange,
            'wpb_get_last_1_year': this.getLast1YearRange
        };

        const dateRangeHandler = dateRangeHandlers[clickedItemId];
        if (dateRangeHandler) {
            const dateRange = dateRangeHandler.call(this);
            this.advancedFilterFlatpikerInstance.setDate(dateRange);
        } else if (selectedDates) {
            const startDate = selectedDates[0];
            const endDate = selectedDates[selectedDates.length - 1];
            this.setStartEndDate(startDate, endDate);
        }
    }
    getToDay() {
        const startDate = new Date();
        this.setStartEndDate(startDate, startDate);
        return [startDate, startDate];
    }

    getLast30DaysRange() {
        const endDate = new Date(); // Today's date
        const startDate = new Date();
        startDate.setDate(startDate.getDate() - 29); // Subtract 29 days to get 30 days range
        this.setStartEndDate(startDate, endDate);
        return [startDate, endDate];
    }

    getMonthDateRange() {
        const today = new Date();
        const startDate = new Date(today.getFullYear(), today.getMonth(), 1); // First day of the current month
        const endDate = new Date(today.getFullYear(), today.getMonth() + 1, 0); // Last day of the current month
        this.setStartEndDate(startDate, endDate);
        return [startDate, endDate];
    }

    getLastMonthDateRange() {
        const today = new Date();
        const startDate = new Date(today.getFullYear(), today.getMonth() - 1, 1);
        const endDate = new Date(today.getFullYear(), today.getMonth(), 0);
        this.setStartEndDate(startDate, endDate);
        return [startDate, endDate];
    }

    getLast90DaysRange() {
        const endDate = new Date(); // Today's date
        const startDate = new Date();
        startDate.setDate(startDate.getDate() - 90); // Subtract 89 days to get 90 days range
        this.setStartEndDate(startDate, endDate);
        return [startDate, endDate];
    }

    getLast6MonthsRange() {
        const today = new Date();
        const startDate = new Date(today.getFullYear(), today.getMonth() - 5, 1); // First day of the month 6 months ago
        const endDate = new Date(today.getFullYear(), today.getMonth() + 1, 0); // Last day of the current month
        this.setStartEndDate(startDate, endDate);
        return [startDate, endDate];
    }

    getLast1YearRange() {
        const today = new Date();
        const startDate = new Date(today.getFullYear() - 1, today.getMonth(), today.getDate()); // Exactly 1 year ago from today
        const endDate = new Date(today.getFullYear(), today.getMonth(), today.getDate()); // Today's date
        this.setStartEndDate(startDate, endDate);
        return [startDate, endDate];
    }


    getUrlParameter(name) {
        name = name.replace(/[[]/, '\\[').replace(/[\]]/, '\\]');
        const regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
        const results = regex.exec(location.search);
        return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
    }
    opencanvas() {
        const params = new URLSearchParams(window.location.search);
        if (params.has("offcanvas")) {
            this.offcanvas.show();
        }
    }

    PaginatepaymentTable(e) {
        e.preventDefault();
        const __this = jQuery(e.currentTarget);
        var paged = __this.data('id');
        var form = jQuery("#payment_filters_form")[0],
            formData = new FormData(form);
        formData.append("paged", paged);
        this.call_ajax(formData);

    }
    SubmitbtnEventHandlers(e) {
        var self = this;
        e.preventDefault();
        const form = jQuery(e.currentTarget).closest('form')[0];

        let formData = FormDataJson.toJson(form)
        this.paymentFilterSettings = { ...formData, date_from: this.selectedDates[0], date_to: this.selectedDates[1] }
        this.paymentDatatable.ajax.reload()
        this.offcanvas.hide()

    }


    call_ajax(formData) {

        post('get_filter_payment_data', formData).then(response => {

            this.advanceFilter.offcanvas('hide');
            this.payment_table.replaceWith(response.table_content);
            this.paginate.replaceWith(response.table_pagination);
            this.showing_msg.text(response.table_showing_print);

            this.payment_table = jQuery('#wpb-payment-tbl');
            this.paginate = jQuery('#datatable_paginate');
            this.showing_msg = jQuery('#wpb-payment-paginate');
            jQuery('select').not('.not-init-select').select2({
                width: '100%'
            });


        }).catch(error => {
            console.error('Error fetching email details:', error);
        });
    }

    transformTaxData(taxData) {
        const transformedData = {};
        for (const key in taxData) {
            if (taxData.hasOwnProperty(key)) {
                let taxHeaderLabel = {
                    sub_total : window.wpbookit.dashbord_language.validation.sub_total,
                    total : window.wpbookit.dashbord_language.validation.total
                }
                let label = taxHeaderLabel[key] || key
                const transformedKey = label.replace(/_/g, ' ');
                transformedData[transformedKey] = taxData[key];
            }
        }
        return transformedData;
    }

    Payment_Invoice(e) {
        e.preventDefault();
        const __this = jQuery(e.currentTarget);
        const editButton = __this.closest('.payment_invoice-booking-button');
        const data = this.paymentDatatable.row(editButton.closest('tr')).data();
        this.paymentInvoice.find('#wpb_booking_type').text(data['customer_name']);
        this.paymentInvoice.find('#wpb_customer_address').text('-');
        if(data['payment_status']['label'] == 'Paid'){
            this.paymentInvoice.find('#wpb_booking_date').text(data['date_created']);   
        }else{
            this.paymentInvoice.find('#wpb_booking_date').text(data['booking_date']); 
        }
        this.paymentInvoice.find('#wpb_payment_id').text('Invoice Id #' + data['payment_id']);
        this.paymentInvoice.find('#wpb_customer_email').text(data['customer_email']);	
        this.paymentInvoice.find('#wpb_booking_status').text('Payment Status: ' + data['payment_status']['label']);
        this.paymentInvoice.find('#customer_name').text(data['customer_name']);
        this.paymentInvoice.find('#customer_gender').text(data['customer_gender']);
        this.paymentInvoice.find('#customer_birthdate').text(data['customer_birthday']);
        this.paymentInvoice.find('#booking_type').text(data['booking_type']);
        this.paymentInvoice.find('#sr_id').text(data['bookings_id']);
        this.paymentInvoice.find('#booking_duration').text(data['duration']);
        this.paymentInvoice.find('#booking_price').text(data['total_amount']);
        this.paymentInvoice.find('#wpb_invoice_submit').attr("data-id", data['payment_id']);

        const transformedTaxData = this.transformTaxData(data.tax_data);
        const prefix = data.prefix || '';
        const postfix = data.postfix || '';

        jQuery('.tax-module-invoice tbody').empty();
        const payment_id = __this.data('id');
        if (payment_id) {
            post('get_invoice_data',{data_id:payment_id})
                .then(res=>{
                    jQuery('.spinner').hide();
                    this.paymentInvoiceOffcanvas.show()
                    this.paymentInvoice.find("#payment-details-data").innerHTML = ''
                    document.getElementById('payment-details-data').innerHTML = ''
                    document.getElementById('payment-details-data').innerHTML = res.html_content
                    this.paymentInvoice.find('#booking_price').text(res.booking_price);
                    window.wp.hooks.doAction('iqwpb_get_invoice_detail',res)
                    
                })
        }
        for (const key in transformedTaxData) {
            if (transformedTaxData.hasOwnProperty(key)) {
                let value = transformedTaxData[key];
                if (value !== 'Free') {
                    value = `${prefix}${value}${postfix}`;
                }
                jQuery('.tax-module-invoice tbody').append(`
                    <tr>
                        <th scope="col" class="sorting" tabindex="0">${key}</th>
                        <td scope="col" class="sorting" tabindex="0"><span class="nobr">${value}</span></td>
                    </tr>
                `);
            }
        }
    }

    printinvoice(e) {
        var self = this;
        e.preventDefault();

        jQuery('#wpb_invoice_submit').find('.spinner').toggleClass('d-none')
        jQuery('#wpb_invoice_submit').attr('disabled','disabled')
        var data = [];
        data['data_id'] = e.target.getAttribute('data-id');
        self.print_ajax(data);
    }

    print_ajax(data) {
        const pluginUrl = wpbookit.wpb_plugin_url;
        post('print_invoice_data', data).then(response => {
            jQuery('#wpb_invoice_submit').find('.spinner').toggleClass('d-none')
            jQuery('#wpb_invoice_submit').removeAttr('disabled','disabled')
          
            jQuery(response).printArea({
                'popTitle': 'Payment Invoice',
                'extraCss': pluginUrl + '/core/admin/assets/vendor/css/bootstrap.css?v=5.2.3, ' + pluginUrl + '/core/admin/assets/vendor/css/printarea.css?v=1.1.1',
            });

        }).catch(error => {
            console.error('Something went wrong');
        });
    }
}