import notificationToast from "../utils/notification-toast";
import { get, post } from "../utils/ajax";
import flatpickr from "flatpickr";
import { Offcanvas } from "bootstrap";
import intlTelInput from "intl-tel-input";
import importModule from "../components/importModule";

export default class Customer {

    addStaffOffCanvas
    staffDataTable;
    constructor() {


        this.addModule = jQuery('#new-staff');
        this.genderSelect = jQuery('#gender');
        this.toastSelect = jQuery('#table-main .toast');
        this.tablecustomer = jQuery('table.customer tbody');
        this.mainContent = jQuery('.main-content');
        this.submitnbtn = jQuery('#add-customer-form #submit-customer-button');

        this.eventHandlers();
        this.initFlatpickr();

        this.firstNameRegex = /^[A-Za-z\s]+$/;
        this.lastNameRegex = /^[A-Za-z\s]+$/;
        this.emailRegex = /^[\w-]+(\.[\w-]+)*@([\w-]+\.)+[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*$/;
        this.phoneNumberRegex = /^\d+$/;
        jQuery('#phone').on('input', (e) => {
            e.target.value = e.target.value.replace(/[^0-9]/g, '');
        });
        

        this.showError = this.showError.bind(this);
        this.hideError = this.hideError.bind(this);
        this.validateField = this.validateField.bind(this);

        this.addStaffOffCanvas = new Offcanvas(document.querySelector('#new-staff'))

        // Error messages
        this.errorMessages = {
            firstName: {
                selector: "#first-name-error",
                blank: window.wpbookit.dashbord_language.validation.first_name_required,
                invalid: window.wpbookit.dashbord_language.validation.first_name_invalid
            },
            lastName: {
                selector: "#last-name-error",
                blank: window.wpbookit.dashbord_language.validation.last_name_required,
                invalid: window.wpbookit.dashbord_language.validation.last_name_invalid
            },
            email: {
                selector: "#email-error",
                blank: window.wpbookit.dashbord_language.validation.email_required,
                invalid: window.wpbookit.dashbord_language.validation.email_invalid
            },
            phoneNumber: {
                selector: "#phone-error",
                invalid: window.wpbookit.dashbord_language.validation.phone_invalid
            },
            gender: {
                selector: "#gender-error",
            },
            dob: {
                selector: "#dob-error",
            }
        };

        this.staffDataTable = new DataTable('table', {
            "searching": false,
            "processing": true,
            "serverSide": true,
            "order": [
                [0, 'DESC']
            ],
            "paging": true,
            "lengthChange": false,
            "ajax": (data, callback, settings) => {
                if (this.staffFilterSearch) {
                    data = { ...data, ...{ customer_search: this.staffFilterSearch } }
                }
                return get('get_staff_list', data).then(resData => {
                    callback(resData)
                })
            },
            "columns": [
                {
                    "data": "id",
                    "name": "staff-id",
                    "searchable": false
                },
                {
                    "data": "name",
                    "render": function (data, type, row) {
                        return ` <div class="d-flex align-items-center gap-3">
                            <img class="rounded-pill img-fluid avatar-40" src="${row.profile_img}" alt="" loading="lazy">
                            <div class="media-support-info">
                                <h6 class="iq-sub-label">${data}</h6>
                                <p class="mb-0">${row.email}</p>
                            </div>
                        </div>`;

                    },
                    "name": 'staff-name',
                    "searchable": false
                },
                {
                    "data": "dob",
                    "name": 'staff-dob',
                    "searchable": false

                },
                {
                    "data": "phone",
                    "name": 'staff-phone',
                    "searchable": false,
                    "orderable": false,
                    "render": function (data, type, row) {
                        if(data=='-'){
                            return data
                        }
                        if(row.dialCode)
                            return "+"+row.dialCode+" "+data; 

                        return data;
                    },
                },
                {
                    "data": "gender",
                    "name": 'staff-gender',
                    "searchable": false,
                    "orderable": false,
                    "render": function (data) {
                        return `<span class="text-capitalize">${data}</span>`;
                    }

                },
                {
                    "data": "user_registred",
                    "name": 'staff-date-time',
                    "searchable": false,
                },
                {
                    "data": "actions",
                    "render": function (data, type, row) {

                        let render = '';

                        render += ` <a href="#" data-id="${row.id}" class="edit-staff-button">
                                        <img src="${wpbookit.wpb_plugin_url}core/admin/assets/images/edit-icon.svg" alt="checked">
                                    </a>`;

                        render += `<a class=" delete-staff-button" href="#" data-id="${row.id}" data-name="${row.name}">
                                        <img src="${wpbookit.wpb_plugin_url}core/admin/assets/images/delete-icon.svg" alt="checked">
                                   </a>`;

                        return `<div class="d-flex align-items-center gap-3">${render}</div>`;
                    },
                    "searchable": false,
                    "orderable": false,
                },
            ],

            language: window.wpbookit.datatable_language
        })

        this.staff_country= intlTelInput(document.querySelector('#phone'),{
            containerClass:'wpb-country-container',
            initialCountry: "auto",
            geoIpLookup: (success, failure)=> {
                fetch("https://ipapi.co/json")
                  .then((res) =>{ return res.json(); })
                  .then((data)=> {
                        this.defaultCountry= data.country_code
                        success(data.country_code);
                    })
                  .catch(() =>{ failure(); });
              },
        });
        new importModule(document.querySelector('#wpb-staff-import'),this.staffDataTable.ajax.reload)
    }
    search_filter(e) {
        this.staffFilterSearch = e.target.value;
        this.staffDataTable.ajax.reload()
    }
    eventHandlers() {
        jQuery(document.body).on("click", ".edit-staff-button", this.EditeventHandlers.bind(this));
        jQuery(document.body).on("click", ".offcanvas-end .btn-close", this.PopupCloseEvent.bind(this));
        jQuery(document.body).on("change", "#edit-image", this.ChangeImageeventHandlers.bind(this));
        jQuery(document.body).on("click", "#add-staff-form #submit-button", this.SubmitbtnEventHandlers.bind(this));
        jQuery(document.body).on("click", "#offcanvas #remove-btn", this.EditpopupRemoveeventHandlers.bind(this));
        jQuery(document.body).on("click", ".delete-staff-button", this.DeletePopupeventHandlers.bind(this));
        jQuery(document.body).on("click", "#add-staff-click", this.Addstaffbtn.bind(this));
        jQuery(document.body).on("change", "#new-staff #add-image", this.AddImageeventHandlers.bind(this));
        jQuery(document.body).on("click", "#new-staff #remove-btn", this.AddpopupRemoveeventHandlers.bind(this));
        jQuery(document.body).on("click", "#staff_inner #export-file", this.exporteventHandlers.bind(this));
        jQuery(document.querySelector('#new-staff')).on("hidden.bs.offcanvas", () => {
            jQuery('.error-message').html('')
            this.staff_country.setCountry(this.defaultCountry)
        });
        this.flatpickrElement = document.querySelector('#wpb-range-flatpicker');
        this.flatpickrSubmitElement = document.querySelector('#flatpickr-submit');
        jQuery('.dt-search').on("input", _.debounce(e => {
            this.search_filter(e)
        }, 500));
    }

    initFlatpickr() {
        flatpickr(this.flatpickrElement, {
            disableMobile: true, 
            dateFormat: 'Y-m-d',
            maxDate: 'today',
            allowInput: false, 
            onChange: (selectedDates, dateStr, instance) => {
                if (selectedDates.length === 2) {
                    this.flatpickrSelectedDate = selectedDates.map((item) => item.toLocaleDateString());
                }
            }
        });
    }

    exporteventHandlers(e) {
        e.preventDefault();
        var urlParams = new URLSearchParams(window.location.search);
        var tab = urlParams.get('tab');

        post('export_user_table', { 'tab': tab }).then(response => {
            // Create a Blob object containing the CSV data
            var blob = new Blob([response], { type: 'text/csv' });

            // Create a download link
            var downloadLink = document.createElement('a');
            downloadLink.href = window.URL.createObjectURL(blob);
            downloadLink.download = 'staff.csv';
            

            // Append the link to the body and click it to trigger download
            document.body.appendChild(downloadLink);
            downloadLink.click();

            // Clean up
            document.body.removeChild(downloadLink);
        });
    }

    SubmitbtnEventHandlers(e) {

        e.preventDefault();
        const _this = this;
        const __this = jQuery(e.currentTarget);
        __this.prop('disabled', true);
        __this.find('.wpb-staff-submit-svg').removeClass('d-none');
        const user_id = jQuery('input[name="edit-staff-id"]').val();

        var formFields = {
            'firstName': jQuery("#first-name").val(),
            'lastName': jQuery("#last-name").val(),
            'email': jQuery("#email").val(),
            'phoneNumber': jQuery("#phone").val(),
            'gender': jQuery("#gender").val(),
            'dob': jQuery("#wpb-range-flatpicker").val()
        }

        let isValid = [];
        jQuery.each(formFields, function (fieldName, fieldValue) {
            var regex = _this[fieldName + 'Regex']; 
            var error = _this.validateField(
                fieldValue,
                regex, 
                _this.errorMessages[fieldName].selector,
                _this.errorMessages[fieldName].blank,
                _this.errorMessages[fieldName].invalid
            );
            if (error === undefined) {
                document.querySelector(_this.errorMessages[fieldName].selector).innerHTML = ''
            }
            isValid.push(error);
        });

        if (!user_id) {

            if (isValid.indexOf(false) !== -1) {
                __this.prop('disabled', false);
                __this.find('.wpb-staff-submit-svg').addClass('d-none');
                return
                false;
            }

            const form = jQuery(e.currentTarget).closest('form')[0];
            const formData = new FormData(form);

            let {dialCode,iso2}= this.staff_country.getSelectedCountryData();
            formData.append('dialCode', dialCode);
            formData.append('iso2', iso2);

            post('add_new_staff', formData)
                .then(response => {
                    const resStatus = response.status;
                    if (resStatus === 'success') {
                        this.PopupCloseEvent();
                        this.RefreshTableeventHandlers();
                        notificationToast[resStatus](response.message, resStatus.toUpperCase(), { autoClose: true });
                    } else {
                        notificationToast[resStatus](response.message, resStatus.toUpperCase(), { autoClose: true });
                    }
                    __this.prop('disabled', false);
                    __this.find('.wpb-staff-submit-svg').addClass('d-none');
                });

        } else {
            const __this = jQuery(e.currentTarget);
            if (isValid.indexOf(false) !== -1) {
                __this.prop('disabled', false);
                __this.find('.wpb-staff-submit-svg').addClass('d-none');
                return
                false;
            }
            const form = __this.closest('form')[0];
            const formData = new FormData(form);
            let {dialCode,iso2}= this.staff_country.getSelectedCountryData();
            formData.append('dialCode', dialCode);
            formData.append('iso2', iso2);


            post('edit_newdata_staff', formData)
                .then(response => {
                    const resStatus = response.status;
                    if (resStatus === 'success') {
                        this.PopupCloseEvent();
                        this.RefreshTableeventHandlers();
                        this.addModule.find('input[type=text], textarea').val('');
                        this.addModule.find('select').val('');
                        this.addModule.find('#add-image-preview').attr('src', '');
                        const imgsrc = this.addModule.find('#add-image-preview').attr('data-attr');
                        this.addModule.find('#add-image-preview').attr('src', imgsrc);
                        notificationToast[resStatus](response.message, resStatus.toUpperCase(), { autoClose: true });
                    } else {
                        notificationToast[resStatus](response.message, resStatus.toUpperCase(), { autoClose: true });
                    }
                    __this.prop('disabled', false);
                    __this.find('.wpb-staff-submit-svg').addClass('d-none');
                });

        }
    }

    Addstaffbtn(e) {
        e.preventDefault();
        this.addModule.find('#new-staff-label').text('Add New Staff');
        // this.addModule.find('#submit-button').text('Save');
        this.addModule.find('#edit-staff-id').val('');
        this.addModule.find('input[type=text], textarea').val('');
        this.addModule.find('select').val('').trigger('change');
        this.addModule.find('#add-image-preview').attr('src', '');
        const imgsrc = this.addModule.find('#add-image-preview').attr('data-attr');
        this.addModule.find('#add-image-preview').attr('src', imgsrc);
        this.addModule.find('#remove-btn').addClass('d-none');
    }
    RefreshTableeventHandlers() {
        this.staffDataTable.ajax.reload()
    }

    getUrlParameter(name) {
        name = name.replace(/[[]/, '\\[').replace(/[\]]/, '\\]');
        const regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
        const results = regex.exec(location.search);
        return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
    }

    EditeventHandlers(e) {
        e.preventDefault();

        const __this = jQuery(e.currentTarget);
        const editButton = __this.closest('.edit-staff-button');
        const staff = this.staffDataTable.row(editButton.closest('tr')).data();
        this.staff_country.setCountry(staff.iso2)
        const __tablegrandparent = __this.closest('.staff');
        const user_id = __this.data('id');
        const trName = staff['name'];
        const [firstName, lastName] = trName.split(' ');
        const tdEmail = staff['email'];
        const tdPhone = staff['phone'];
        const tdGender = staff['gender'];
        const tdnotes = staff['custom_note'];
        const tddob = staff['tddob'];
        const avatarSrc = staff['profile_img'];
        // this.addModule.addClass('show');
        this.addStaffOffCanvas.show();
        const fname = firstName ? firstName.trim() : '';
        const lname = lastName ? lastName.trim() : '';
        const email = tdEmail ? tdEmail.trim() : '';
        const phone = tdPhone ? tdPhone.trim() : '';
        const gender = tdGender ? tdGender.trim() : '';
        const notes = tdnotes ? tdnotes.trim() : '';
        const dob = tddob ? tddob.trim() : '';
        this.addModule.find('#wpb-range-flatpicker')
            .val(dob) // Set the value directl
            .flatpickr({
                disableMobile: true, 
                dateFormat: 'Y-m-d',
                defaultDate: dob,
                maxDate: 'today',
                locale:window.wpbookit.flatpicker
            });

        this.addModule.find('#first-name').val(fname);
        this.addModule.find('#last-name').val(lname);
        this.addModule.find('#email').val(email);
        this.addModule.find('#phone').val(phone);
        this.addModule.find('#notes').val(notes);
        this.addModule.find('#edit-staff-id').val(user_id);
        this.addModule.find('#add-image-preview').attr('src', avatarSrc);
        const sgender = gender.toLowerCase();
        this.genderSelect.val(sgender=='-'?'':sgender).trigger('change');
        if(staff['is_staff_image']){
            this.addModule.find('#remove-btn').removeClass('d-none');
        }else{
            this.addModule.find('#remove-btn').addClass('d-none');
        }
        this.addModule.find('#new-staff-label').text('Edit Staff ' + fname + ' ' + lname);
        // this.addModule.find('#submit-button').text('Update');

    }

    PopupCloseEvent() {
    
        this.addStaffOffCanvas.hide();
        
        try {
            const offCanvasElement = document.querySelector('#new-staff'); 
            const form = offCanvasElement.querySelector('form');
            const errorMessage = offCanvasElement.querySelectorAll('.error-message');
            
            
            if (errorMessage.length > 0) {
                errorMessage.forEach(element => {
                    if (element.textContent.trim() !== '') {
                        element.textContent = '';
                    }
                });
            }
    
            
            if (form) {
                form.reset();
                jQuery(form).find('select').trigger('change');
            }
        } catch (error) {
            console.error("Error in PopupCloseEvent:", error);
        }
    }
    

    ChangeImageeventHandlers(e) {
        e.preventDefault();
        const __this = jQuery(e.currentTarget);
        const preview_img = this.addModule.find('.img-fluid');
        if (__this.prop('files') && __this.prop('files')[0]) {
            const reader = new FileReader();
            reader.onload = function (event) {
                preview_img.attr('src', event.target.result);
            };
            reader.readAsDataURL(__this.prop('files')[0]);
        }
        else {
            // Clear the src attribute when no file is selected
            var imgsrc = preview_img.attr('data-attr');
            preview_img.attr('src', imgsrc);
        }
    }

    AddImageeventHandlers(e) {
        e.preventDefault();
        const allowedExtensions = ["jpg", "jpeg", "png", "gif"]; // List of allowed extensions
        const file = e.target.files[0]; // Get the selected file
        const errorMessage = document.getElementById("image-preview-error");

        // Clear previous error messages
        errorMessage.textContent = "";

        if (file) {
            const fileExtension = file.name.split(".").pop().toLowerCase(); // Get the file extension

            // Check if the file extension is in the allowed list
            if (!allowedExtensions.includes(fileExtension)) {
                errorMessage.textContent =  window.wpbookit.dashbord_language.validation.invalid_file_type
                e.target.value = ""; // Clear the input value
                return;
            }
        }
        
        const __this = jQuery(e.currentTarget);
        const preview_img = this.addModule.find('#add-image-preview');
        const remove_btn = this.addModule.find('#remove-btn');

        if (__this.prop('files') && __this.prop('files')[0]) {
            const reader = new FileReader();
            reader.onload = function (event) {
                preview_img.attr('src', event.target.result);
                remove_btn.removeClass('d-none');
            };
            reader.readAsDataURL(__this.prop('files')[0]);
        } else {
            var imgsrc = preview_img.attr('data-attr');
            preview_img.attr('src', imgsrc);
            remove_btn.addClass('d-none');
        }
        remove_btn.one('click', function () {
            remove_btn.addClass('d-none');
            var imgsrc = preview_img.attr('data-attr');
            preview_img.attr('src', imgsrc);
        });
    }

    validateField(value, regex, errorSelector, blankErrorMessage, invalidErrorMessage) {
        if(blankErrorMessage===undefined && (value=='' || value== null) ){
            return true;
        }
        if (!value) {
            this.showError(errorSelector, blankErrorMessage);
            return false;
        } else if (regex !== undefined) {
            if (!regex.test(value)) {
                this.showError(errorSelector, invalidErrorMessage);
                return false;
            }
        } else {
            this.hideError(errorSelector);
            return true;
        }
    }

    showError(elementId, errorMessage) {
        jQuery(elementId).text(errorMessage).show();
    }

    hideError(elementId) {
        jQuery(elementId).hide();
    }

    popupRemoveEventHandlers(module, imageId) {
        const imgsrc = module.find(imageId).attr('data-attr');
        module.find(imageId).attr('src', imgsrc);
        module.find('input[type="file"]').val('');
    }

    EditpopupRemoveeventHandlers(e) {
        this.popupRemoveEventHandlers(this.addModule, '#image-preview');
    }

    AddpopupRemoveeventHandlers(e) {
        this.popupRemoveEventHandlers(this.addModule, '#add-image-preview');
    }

    DeleteeventHandlers(e) {
        e.preventDefault();
        const __this = jQuery(e.currentTarget);
        const user_id = __this.data('id');
        this.delete_user_ajax(user_id);
    }

    delete_user_ajax(delete_user_id) {
        post('delete_staff', { 'delete_user_id': delete_user_id }).then(response => {
            const resStatus = response.status;
            this.RefreshTableeventHandlers();
            notificationToast[resStatus](response.message, resStatus.toUpperCase(), { autoClose: true });
        });
    }
    DeletePopupeventHandlers(e) {
        e.preventDefault();
        const __this = jQuery(e.currentTarget);
        const __tablegrandparent = __this.closest('.staff');
        const imagePath = __tablegrandparent.find('img.photo').attr('src');
        const staffName = __tablegrandparent.find('.staff-name h6').text();
        var urlParams = new URLSearchParams(window.location.search);
        var tab = urlParams.get('tab');
        const user_name = __this.data('name');

        var cMessage = window.wpbookit.dashbord_language.staff.confirm_delete_staff + user_name + "?";
        if (confirm(cMessage) == true) {
            const user_id = __this.data('id');
            this.delete_user_ajax(user_id);
        }
    }
}
