
function get(route, Dataparams,  args= {}) {
    return jQuery.ajax({
        url: window.ajaxurl,
        type: 'GET',
        data: {
            ...Dataparams,
            action: 'wpb_ajax_get',
            route_name: route
        },
        ...args
    })
}

function post(route, Dataparams, args = {}) {
    let ajaxOptions = {
        url: window.ajaxurl,
        type: 'POST',
    };
    
    if (Dataparams instanceof FormData) {
        Dataparams.append('action', 'wpb_ajax_post');
        Dataparams.append('route_name', route);
        // Add this line - the nonce is missing for FormData!
        Dataparams.append('_ajax_nonce', window.wpbookit._ajax_nonce);
        
        ajaxOptions.data = Dataparams;
        ajaxOptions.processData = false;
        ajaxOptions.contentType = false;
    } else {
        ajaxOptions.data = {
            ...Dataparams,
            action: 'wpb_ajax_post',
            _ajax_nonce: window?.wpbookit?._ajax_nonce ?? wpb_nounce,
            route_name: route
        };
    }
    
    return jQuery.ajax({
        ...ajaxOptions,
        ...args
    });
}

export { get, post } 