<?php
final class WPB_Exportcsv_Controller
{ 
    
    public function export_user_table_callback(WP_REST_Request $request) {

        $tab  = $request->get_param('tab');

        if($tab==='bookings'){
            $args = array(
                'user_id'       => 0,
                'paged'         => 1,
                'status'        => [],
                'booking_type'  => [],
                'per_page'      => 9999,
                'date_from'     => '',
                'date_to'       => '',
                'booking_name'  => '',
                'order'         => 'DESC',
                'order_by'      => 'id',
                'offset'        => 0,
                'staff'         => current_user_can('administrator') ? 0 : get_current_user_id(),
            );
    
            if ($request->has_param('advanceFilter')) {
                $advanceFilter = $request->get_param('advanceFilter');
    
                if (isset($advanceFilter['wpb_booking_daterange'])) {
                    $dateRange = explode(' to ', $advanceFilter['wpb_booking_daterange']);
                    if (count($dateRange) == 2) {
                        $args['date_from'] = date('Y-m-d', strtotime($dateRange[0]));
                        $args['date_to'] = date('Y-m-d', strtotime($dateRange[1]));
                    }
                }
    
                $args['date_from'] = $args['date_from'] ?: $advanceFilter['date_from'];
                $args['date_to'] = $args['date_to'] ?: $advanceFilter['date_to'];
    
                $args = array_merge($args, [
                    'status'        => $advanceFilter['wpb_status'],
                    'booking_type'  => $advanceFilter['wpb_booking_type'],
                ]);
            }
    
            if ($request->has_param('customer_search')) {
                $args['booking_name'] = $request->get_param('customer_search');
            }
    
            if ($request->has_param('order')) {
                $args['order'] = strtoupper($request->get_param('order')[0]['dir'] ?? '');
                $args['order_by'] = $request->get_param('order')[0]['name'] ?? "";
            }
    
            $booking = wpb_get_bookings($args);
    
            $appointments_array = array_map(function ($item) {
                $user_id = 0;
                if ($user = get_user_by('email', $item->get_booking_email())) {
                    $user_id = $user->ID;
                }
                global $wpdb;
                $booking_query = $wpdb->prepare("SELECT booking_type FROM $wpdb->wpb_bookings WHERE id = %d", $item->get_id());
                $booking_type_title = $wpdb->get_var($booking_query);
    
                $booking_type = $item->get_booking_type('view', ['name', 'id'], true);
    
                $locations = [
                    'physical_address' => esc_html__("Address", 'wpbookit'),
                    'online_video' => esc_html__("Meeting URL", 'wpbookit'),
                    'phone_number' => esc_html__("Phone Number", 'wpbookit')
                ];
    
                $user__profile_url = wp_get_attachment_url(get_user_meta($user_id, "wp_user_avatar", true) ?? 0);
                $tax_data_json = $item->get_meta('tax_data');
                $tax_data = is_array($tax_data_json) ?$tax_data_json : json_decode($tax_data_json, true);
                $price = isset($tax_data['main_total']) ? $tax_data['main_total'] : 0;
                $free_label = __("Free", 'wpbookit');
                $booking_data = [
                    'id' => $item->get_id(),
                    'name' => $item->get_booking_name(),
                    'payment_id' => $item->get_payment_id(),
                    'gender' => empty(get_user_meta($user_id, "gender", true)) ? '-' : get_user_meta($user_id, "gender", true),
                    'dob' => empty(get_user_meta($user_id, "date_of_birth", true)) ? '-' : wpb_get_formated_date_time(get_user_meta($user_id, "date_of_birth", true), ''),
                    'profile_img' => $user__profile_url === false ? get_avatar_url(0, ['size' => 50]) : $user__profile_url,
                    'is_customer_image' => $user__profile_url === false ? false : true,
                    'duration' => sprintf("%s %s", $item->get_booking_type('view', ['duration']) ? $item->get_booking_type('view', ['duration'])['duration'] : $item->get_meta('booking_duration') ?? 0, esc_html__("Min", 'wpbookit')),
                    'email' => $item->get_booking_email(),
                    'datetime' => $item->get_formated_booking_datetime(),
                    'type' => $booking_type_title,
                    'price' => $price ? wpb_get_general_settings()['prefix'].number_format( $item->get_dis_booking_price(),2,'.','').wpb_get_general_settings()['postfix'] : $free_label ,
                    'date_created' => sprintf("%s %s", wp_date(get_option('date_format'), strtotime($item->get_date_created())), wp_date(get_option('time_format'), strtotime($item->get_date_created())), new DateTimeZone(wpb_get_timezone())),
                    'staff' => get_user_by('ID', $booking_type ? $booking_type['meta']['staff'] : $item->get_meta('staff_id'))->display_name,
                    'location' => $locations[$item->get_meta('location')] ?? false,
                    'location_source' => $item->get_meta('location_source'),
                    'status' => [
                        'key' => $item->get_status(),
                        'label' => wpb_booking_status_label($item->get_status())
                    ],
                    'questions_answers' => array_map(function ($item) {
                        $item['question'] = wpb_unicode_to_utf8($item['question']);
                        $item['ans'] = wpb_unicode_to_utf8($item['ans']);
                        return $item;
                    }, json_decode($item->get_meta('questions_answers') ?? '{}', true)),
                    'actions' => [
                        "edit" => true,
                        "delete" => true,
                    ],
                ];
                $booking_data = apply_filters('wpb_after_actions_modify_booking_data', $booking_data, $item);
                return $booking_data;
            }, $booking->results);

            $csv_file = "appointments_" . date('YmdHis') . ".csv";

            // Set CSV headers
            header("Content-type: text/csv");
            header("Content-Disposition: attachment; filename={$csv_file}");

            // Open output stream
            $output = fopen('php://output', 'w');

            // Write CSV headers for appointments
            fputcsv($output, [
                'ID', 
                'Name', 
                'Email', 
                'Appointment Date', 
                'Duration', 
                'Type', 
                'Status', 
                'Price', 
                'Staff', 
                'Date Created',
            ]);

            // Write appointment data to CSV
            foreach ($appointments_array as $appointment) {
                fputcsv($output, [
                    $appointment['id'],
                    $appointment['name'],
                    $appointment['email'],
                    $appointment['datetime'],
                    $appointment['duration'],
                    $appointment['type'],
                    $appointment['status']['label'],  // Access nested status label
                    $appointment['price'],
                    $appointment['staff'] ?? 'N/A',   // Handle null staff
                    $appointment['date_created'],
                ]);
            }

            // Close output stream
            fclose($output);
            // Exit to prevent WordPress from adding extra content
            exit;
        }

        
        if ( isset($tab) ) {

            
            $user_role = sanitize_text_field( $tab );
    
            // WP_User_Query arguments
            $args = array (
                'role' => $user_role,
                'order' => 'ASC',
                'orderby' => 'display_name',
                'fields'  => 'all',
            );
            
            $get_users = get_users( $args );
    
            $csv_file = "users" . date('YmdHis') . ".csv";
    
            // Set CSV headers
            header("Content-type: text/csv");
            header("Content-Disposition: attachment; filename={$csv_file}");
    
            // Open output stream
            $output = fopen('php://output', 'w');
    
            // Write CSV headers
            fputcsv($output, array('First Name', 'Last Name', 'Email', 'Role','Phone','Notes','Profile Image','Gender','Date of Birth'));
    
            // Write user data to CSV
            foreach ( $get_users as $user ) {
                $meta = get_user_meta($user->ID);
                $role = $user->roles;
                $email = $user->user_email;
                $phone = $meta['phone'];
                $custom_note = $meta['custom_note'];
                $avtar_attachment_id = $meta['wp_user_avatar'][0];
                $attachment_url = wp_get_attachment_url($avtar_attachment_id);
                
                
                $attachment_id = $meta['wp_user_avatar'][0] ?? '';
                $attachment_url = $attachment_id ? wp_get_attachment_url($attachment_id) : '';

                $first_name = ( isset($meta['first_name'][0]) && $meta['first_name'][0] != '' ) ? $meta['first_name'][0] : '' ;
                $last_name  = ( isset($meta['last_name'][0]) && $meta['last_name'][0] != '' ) ? $meta['last_name'][0] : '' ;
                $phone  = ( isset($meta['phone'][0]) && $meta['phone'][0] != '' ) ? $meta['phone'][0] : '' ;
                $dialCode  = ( isset($meta['dialCode'][0]) && $meta['dialCode'][0] != '' ) ? ('+'.$meta['dialCode'][0]) : '' ;
                $custom_note  = ( isset($meta['custom_note'][0]) && $meta['custom_note'][0] != '' ) ? $meta['custom_note'][0] : '' ;

                $gender  = ( isset($meta['gender'][0]) && $meta['gender'][0] != '' ) ? $meta['gender'][0] : '' ;
                $date_of_birth  = ( isset($meta['date_of_birth'][0]) && $meta['date_of_birth'][0] != '' ) ? wpb_get_formated_date_time($meta['date_of_birth'][0], '') : '' ;
               
               

    
                fputcsv($output, array($first_name, $last_name, $email, ucfirst($role[0]), $dialCode.$phone ,$custom_note,$attachment_url,$gender,$date_of_birth));
            }
    
            // Close output stream
            fclose($output);
    
            // Exit to prevent WordPress from adding extra content
            exit;
        } else {
            wp_send_json_error( 'Tab parameter missing' );
        }
    }
    
    public function export_payment_table_callback(WP_REST_Request $request)
    {
        global $wpdb;
       
            $query = $wpdb->prepare(
                "SELECT payments.*, bookings.*
                FROM %i AS payments 
                INNER JOIN %i AS bookings ON payments.bookings_id = bookings.id 
                WHERE 1 = 1",
                $wpdb->wpb_payments,
                $wpdb->wpb_bookings
            );
            $payments = $wpdb->get_results($query, ARRAY_A);
            $csv_file = "payments" . date('YmdHis') . ".csv";
    
            // Set CSV headers
            header("Content-type: text/csv");
            header("Content-Disposition: attachment; filename={$csv_file}");
            $output = fopen('php://output', 'w');

            $all_tax = $wpdb->get_results($wpdb->prepare(
                "SELECT * FROM {$wpdb->wpb_tax}"
            ));
            
            // Initial CSV columns
            $csv_col = array('Payment ID', 'Booking Type', 'Booking name', 'Booking Email', 'Booking Date', 'Mode Of Payment', 'Total Amount');
            
            // Dynamically add tax name(s) to the CSV columns
            if (!empty($all_tax)) {
                foreach ($all_tax as $tax) {
                    $csv_col[] = $tax->tax_name; // Add tax name from the database
                }
            }
            
            $csv_col = array_merge($csv_col,['Paid Amount', 'Payment Status']) ;
            // Output the CSV columns
            
            fputcsv($output,$csv_col );

            foreach ( $payments as $payment ) {

                $booking = new WPB_Booking($payment['bookings_id']);
                $html_content = iqwpb_get_booking_totals_and_html($payment['booking_type_id'],$booking->get_raw_booking_sub_price(),$booking->get_id() ,false,$booking->get_raw_booking_price());

                $payment_id = ( isset($payment['id']) && $payment['id'] != '' ) ? $payment['id'] : '' ;
                $booking_type = ( isset($payment['booking_type_id']) && $payment['booking_type_id'] != '' ) ? $payment['booking_type_id'] : '' ;
                $booking_name = ( isset($payment['booking_name']) && $payment['booking_name'] != '' ) ? $payment['booking_name'] : '' ;
                $booking_email = ( isset($payment['booking_email']) && $payment['booking_email'] != '' ) ? $payment['booking_email'] : '' ;
                $booking_date = ( isset($payment['booking_date']) && $payment['booking_date'] != '' ) ? $payment['booking_date'] : '' ;
                $payment_mode = ( isset($payment['payment_mode']) && $payment['payment_mode'] != '' ) ? $payment['payment_mode'] : '' ;
                $total_amount = ( isset($html_content['tax_values']['sub_total']) && $html_content['tax_values']['sub_total'] != '' ) ?wpb_get_prefix_postfix_price( $html_content['tax_values']['sub_total']) : '' ;


                $csv_col_val= array($payment_id, $booking_type,$booking_name,$booking_email,$booking_date,$payment_mode,$total_amount);
                
                $tax_val = array_fill(0,count($all_tax), '-'); 
                
                foreach ($html_content['tax_values']  as $key => $value) {

                    foreach ($all_tax as  $tax_key =>$item) {
                        if (isset($item->tax_name) && $item->tax_name === str_replace('_',' ',$key)) {
                            $tax_val[$tax_key]=wpb_get_prefix_postfix_price( $value);
                            break;
                        }
                    }
                }
            
                $paid_amount = ( isset($payment['paid_amount']) && $payment['paid_amount'] != '' ) ? wpb_get_prefix_postfix_price($payment['paid_amount']) : '' ;
                $payment_status = ( isset($payment['payment_status']) && $payment['payment_status'] != '' ) ? ($payment['payment_status']?__("paid",'wpbookit'):__("Unpaid",'wpbookit')) : '' ;
              
                $csv_col_val = array_merge($csv_col_val,$tax_val,[$paid_amount,$payment_status]);
                fputcsv($output, $csv_col_val);
            }
            fclose($output);
            exit;

    }
    public function export_guest_user_table_callback(WP_REST_Request $request)
    {
        $guest_users = wpb_get_guest_users( array( 'per_page'  => -1 ));
        $csv_file = "guest-users" . date('YmdHis') . ".csv";
            // Set CSV headers
            header("Content-type: text/csv");
            header("Content-Disposition: attachment; filename={$csv_file}");
    
            // Open output stream
            $output = fopen('php://output', 'w');
    
            // Write CSV headers
            fputcsv($output, array('ID', 'Name', 'Email','Phone Number' ) );

            // // Write user data to CSV
            if( !empty( $guest_users->results ) ) :
                foreach ( $guest_users->results as $user ) :
                    $guest_id   = $user->get_id();
                    $name       = $user->get_guest_name();
                    $email      = $user->get_guest_email();
                    $phone_number      = $user->get_guest_phone_number();

                    fputcsv( $output, array( $guest_id, $name, $email,$phone_number ) );
                endforeach;
            endif;
    
            // Close output stream
            fclose($output);
    
            // Exit to prevent WordPress from adding extra content
            exit;
    }
}