<?php

final class WPB_Import_Controller
{
    public function wpb_import(WP_REST_Request $res)
    {
        global $wpdb;
        $uploaded_csv =  $res->get_file_params();
        $import_file_type=  $res->get_param('wpb_file');
        $is_guest_user=  $res->get_param('wpb_guest_user');
        $import_type = $res->get_param('wp_import_module');

        if (!isset($uploaded_csv['wpb_import_file'])) {
            wp_send_json(['status' => 'error', esc_html__("Import Find Not Avalible", 'wpbookit')]);
        }

        $file_extension = pathinfo($uploaded_csv['wpb_import_file']['full_path'], PATHINFO_EXTENSION);
        $available_files = array_column(wpb_available_import_file_type(), 'key');
        if (!in_array(strtolower($file_extension), $available_files) && $import_file_type == strtolower($file_extension) ) {
            wp_send_json(['status' => 'error', esc_html__("Import File Type Not Support", 'wpbookit')]);
        }


        $upload_dir = wp_upload_dir();
        $target_file = $upload_dir['path'] . '/' . basename($uploaded_csv['wpb_import_file']["name"]);

        if (move_uploaded_file($uploaded_csv['wpb_import_file']["tmp_name"], $target_file)) {
            $file_content = apply_filters("wpb_get_{$import_file_type}_content",$target_file,$import_type);
            if(is_wp_error($file_content)){
                wp_send_json([
                    'status' => 'error',
                    'message'=> sprintf(
                        esc_html__("Missing Required Field: %s",'wpbookit'),
                        implode(', ',$file_content->get_error_data())) 
                ]);
            }
            switch ($import_type) {
                case 'customer':
                case 'staff':
                    $this->importCustomer($file_content, $import_type);
                    break;
                case 'booking_from_old_wpbookit_plugin':
                    $this->importBookingFromOld($file_content, $import_type);
                    break;
                default:
                    $this->importBooking($file_content,$is_guest_user);
                    break;
            }
        
        } else {
            wp_send_json(['status' => 'error', 'message'=>  esc_html__('Error uploading file.', 'wpbookit')]);
        }
    }

    public function importCustomer($file_content, $import_type)
    {
        $results = [];
        $totalCustomer = count($file_content);
        $importedCustomer =  $emailNotFound = $nameNotFound = 0;
        
        foreach ($file_content as $customer) {
            $missingFields = 0;
            try {
                if (!isset($customer['email']) || empty($customer['email'])) {
                    $emailNotFound++;
                    $missingFields++;
                }

                if (!isset($customer['first_name']) || empty($customer['first_name']) || !isset($customer['last_name']) || empty($customer['last_name'])) {
                    $nameNotFound++;
                    $missingFields++;
                }
                if ($missingFields > 0) {
                    continue;
                }
                $email = $customer['email'];
                $user = get_user_by('email', $email);
    
                if (!$user) {
                    $user_data = apply_filters(
                        "wpb_insert_customer",
                        [
                            "user_login"    => sanitize_user($customer['email']),
                            "user_email"    => sanitize_email($customer['email']),
                            "user_pass"     => wp_generate_password(),
                            "first_name"    => sanitize_text_field($customer['first_name']),
                            "last_name"     => sanitize_text_field($customer['last_name']),
                            "role"          => $import_type == 'staff' ? WPBOOKIT()->helpers->get_staff_role() : WPBOOKIT()->helpers->get_customer_role(),
                            "meta_input"    => [
                                "phone"         => sanitize_text_field($customer['phone']),
                                "gender"        => sanitize_text_field($customer['gender']),
                                "date_of_birth" => sanitize_text_field($customer['date_of_birth']),
                                "custom_note"   => sanitize_textarea_field($customer['custom_note']),
                                'iso2'          => sanitize_text_field($customer['iso2']),
                                'dialCode'      => sanitize_text_field($customer['dialCode']),
                            ],
                            "user_registered" => date("Y-m-d H:i:s"),
                        ]
                    );
    
                    do_action('wpb_insert_customer', $user_data);
    
                    $user_id = wp_insert_user($user_data);
    
                    if (is_wp_error($user_id)) {
                        throw new Exception($user_id->get_error_message());
                    } else {
                        $importedCustomer++;
    
                        // Handle avatar upload
                        if (isset($customer['avatar_url']) && !empty($customer['avatar_url'])) {
                            $avatar_url = esc_url($customer['avatar_url']);
                            $avatar_id = $this->upload_user_avatar($avatar_url);
                            if (!is_wp_error($avatar_id)) {
                                update_user_meta($user_id, 'wp_user_avatar', $avatar_id);
                            }
                        }
    
                        $results[] = [
                            'status' => 'success',
                            'message' => sprintf(
                                esc_html__("User %s has been added successfully.", 'wpbookit'),
                                $customer['email']
                            )
                        ];
                    }
                } else {
                    $results[] = [
                        'status' => 'error',
                        'message' => sprintf(
                            esc_html__("User %s already exists.", 'wpbookit'),
                            $customer['email']
                        )
                    ];
                }
            } catch (Exception $e) {
                $results[] = [
                    'status' => 'error',
                    'message' => $e->getMessage()
                ];
            }
        }

        $response = [
            'total'             => $totalCustomer,
            'importedData'  => $importedCustomer,
            'nameNotFound'      => $nameNotFound,
            'emailNotFound'     => $emailNotFound
        ];
    
        if ($importedCustomer == 0) {
            $response['status'] = 'error';
            $response['message'] = esc_html__('Error uploading file.');
        } else {
            $response['status'] = 'success';
            $response['message'] = $importedCustomer == $totalCustomer ?
                esc_html__('All customers imported', 'wpbookit') :
                sprintf(esc_html__("User %d imported.", 'wpbookit'), $importedCustomer);
        }
    
        wp_send_json($response);
    }
    
    public function upload_user_avatar($avatar_url)
    {
        $temp_file = download_url($avatar_url);
        
        if (is_wp_error($temp_file)) {
            return $temp_file;
        }
    
        $file = array(
            'name'     => basename($avatar_url),
            'type'     => mime_content_type($temp_file),
            'tmp_name' => $temp_file,
            'error'    => 0,
            'size'     => filesize($temp_file),
        );
    
        $overrides = array(
            'test_form' => false,
            'test_size' => true,
        );
    
        $results = wp_handle_sideload($file, $overrides);
    
        if (!empty($results['error'])) {
            @unlink($temp_file);
            return new WP_Error('upload_error', $results['error']);
        }
    
        $attachment = array(
            'post_mime_type' => $results['type'],
            'post_title'     => sanitize_file_name($results['file']),
            'post_content'   => '',
            'post_status'    => 'inherit'
        );
    
        $attachment_id = wp_insert_attachment($attachment, $results['file']);
    
        if (!is_wp_error($attachment_id)) {
            require_once(ABSPATH . 'wp-admin/includes/image.php');
            $attachment_data = wp_generate_attachment_metadata($attachment_id, $results['file']);
            wp_update_attachment_metadata($attachment_id, $attachment_data);
        }
    
        return $attachment_id;
    }
    
    public function importBooking ($file_content,$is_guest_user) {
        global $wpdb;
        $totalBooking = count($file_content);
        $importedBookings =  $emailNotFound = $bookingType = 0;
        foreach ($file_content as  $booking) {
            extract($booking);
            $missingFields = 0;          
            if (!isset($customer_email) || empty($customer_email)) {
                $emailNotFound++;
                $missingFields++;
            }
            if (empty($booking_type_id)) {
                $bookingType++;
                $missingFields++;
            }
            if (empty($date) || empty($start_time)) {
                $missingFields++;
            }
            if ($missingFields > 0) {
                continue;
            }
            $user = get_user_by('email',$customer_email??'');
            if($user){
                $customer_name= $user ->user_email; 
                $customer_id= $user->ID; 
            }else{
                if ($is_guest_user == 1) {
                    $customer_name = $customer_name ?? 'Guest';
                    $wpdb->insert(
                        "{$wpdb->wpb_guest_users}",
                        array(
                            'guest_name'  => $customer_name,
                            'guest_email' => $customer_email
                        ),
                        array(
                            '%s',  
                            '%s'    
                        )
                    );
                    $customer_id = $wpdb->insert_id;
                }else{
                    $emailNotFound++;
                    continue;
                }
            }
            $timestamp = strtotime($date);
            $booking_type_instance = new WPB_Booking_Type($booking_type_id);
            $maximumbooking = $booking_type_instance->get_meta('maximum_booking');
            $wpb_booking = (new WPB_Booking())->get_bookings(
                array(
                    'paged' => 1,
                    'per_page' => 99,
                    'order_by' => 'ID',
                    'status'=> ['wpb-approved'],
                    'order' => 'DESC',
                    'booking_type' => [$booking_type_instance->get_id()],
                    'date' => date('Y-m-d', $timestamp),
                )
            );
    
            $booked_timeslot = array_count_values(array_map(function ($wpbooking_instance) {
                return $wpbooking_instance->get_timeslot();
            }, $wpb_booking->results));
            $maximumbookingSlots = 0;
            if (isset($booked_timeslot) && !empty($booked_timeslot)) { 
                foreach ($booked_timeslot as $key => $value) {
                    if ($key == $start_date) {
                        continue;
                    }
                    $maximumbookingSlots += $value;
                }
                if (isset($maximumbooking) && $maximumbooking < $maximumbookingSlots) {
                    continue;
                } else if($maximumbooking == null) {
                    continue;
                }
            }
            $booking_type =  wpb_get_booking_type( (int)$booking_type_id, ["name",'id'], true);
            if (!is_array($booking_type)){
                $bookingType++;
                continue;
            }
            $status= $status??'approved';
            $booking_data = array(
                'booking_type_id'   => $booking_type_id,
                'customer_id'       => $customer_id,
                'booking_name'      => $customer_name??'',
                'booking_email'     => $customer_email,
                'booking_date'      => $date,
                'booking_type'      => $booking_type['name'],
                'timeslot'          => $start_time,
                'status'            => 'wpb-'.$status,
                'date_created'      => current_time('mysql',1)
            );
            $wpdb->insert($wpdb->wpb_bookings, $booking_data);
            $booking_id = $wpdb->insert_id;
            isset($booking_id) ? $importedBookings++ : '';
            if (isset($booking_notes) && !empty($booking_notes)) {
                add_metadata('wpb_bookings', $booking_id, 'booking_notes', sanitize_textarea_field($booking_notes), true);
            }
            $booking_payment_data = array(
                'bookings_id'       => $booking_id,
                'payment_mode'      => $payment_mode??'cash',
                'total_amount'      => $booking_type['meta']['price']??0,
                'paid_amount'       => $booking_type['meta']['price']??0,
                'payment_status'    => $payment_status=='paid'?'1':'0',
                'date_created'      => current_time('mysql',1)
            );
            $wpdb->insert($wpdb->wpb_payments, $booking_payment_data);
        }
        $response = [
            'total'             => $totalBooking,
            'importedData'      => $importedBookings,
            'nameNotFound'      => $bookingType,
            'emailNotFound'    => $emailNotFound
        ];
    
        if ($importedBookings == 0) {
            $response['status'] = 'error';
            $response['message'] = esc_html__('Error uploading file.');
        } else {
            $response['status'] = 'success';
            $response['message'] = $importedBookings == $totalBooking ?
                esc_html__('All bookings imported', 'wpbookit') :
                sprintf(esc_html__("%d bookings imported.", 'wpbookit'), $importedBookings);
        }
        wp_send_json($response);
    }
    private function importBookingFromOld($file_content,$is_guest_user) {
        global $wpdb;
        $totalBooking = count($file_content);
        $importedBookings =  $emailNotFound = $bookingType = 0;
        foreach ($file_content as  $booking) {
            $missingFields = 0;          
            if (!isset($booking["Email"]) || empty($booking["Email"])) {
                $emailNotFound++;
                $missingFields++;
            }
         
            if (empty($booking["Email"]) || empty($booking["Start Time"])) {
                $missingFields++;
            }
            if ($missingFields > 0) {
                continue;
            }
           
            $customer_name = ($booking['First Name'].' '.$booking['Last Name']) ?? 'Guest';
            $wpdb->insert(
                "{$wpdb->wpb_guest_users}",
                array(
                    'guest_name'  => $customer_name,
                    'guest_email' => $booking["Email"]
                ),
                array(
                    '%s',  
                    '%s'    
                )
            );
            $customer_id = $wpdb->insert_id;
          
            $status= $status??'approved';
            $booking_data = array(
                'booking_type_id'   => 0,
                'customer_id'       => $customer_id,
                'booking_name'      => $customer_name??'',
                'booking_email'     => $booking["Email"],
                'booking_date'      => date('Y-m-d', strtotime($booking["Date"])),
                'booking_type'      => $booking["Calendar"] && !empty($booking["Calendar"])?$booking["Calendar"]: esc_html__('Import','wpbookit'),
                'timeslot'          =>date('H:i:s', strtotime($booking["Start Time"])),
                'status'            => 'wpb-'.$status,
                'date_created'      => current_time('mysql',1)
            );
            $wpdb->insert($wpdb->wpb_bookings, $booking_data);
            $booking_id = $wpdb->insert_id;
            isset($booking_id) ? $importedBookings++ : '';
          
            $booking_payment_data = array(
                'bookings_id'       => $booking_id,
                'payment_mode'      => $payment_mode??'cash',
                'total_amount'      => $booking_type['meta']['price']??0,
                'paid_amount'       => $booking_type['meta']['price']??0,
                'payment_status'    => '0',
                'date_created'      => current_time('mysql',1)
            );
            $wpdb->insert($wpdb->wpb_payments, $booking_payment_data);
        }
        $response = [
            'total'             => $totalBooking,
            'importedData'      => $importedBookings,
            'nameNotFound'      => $bookingType,
            'emailNotFound'    => $emailNotFound
        ];
    
        if ($importedBookings == 0) {
            $response['status'] = 'error';
            $response['message'] = esc_html__('Error uploading booking.','wpbookit');
        } else {
            $response['status'] = 'success';
            $response['message'] = ($importedBookings == $totalBooking) ? esc_html__('All bookings imported', 'wpbookit') : sprintf(esc_html__("%d bookings imported.", 'wpbookit'), $importedBookings);
        }
        wp_send_json($response);
    }
}
