<?php

final class WPB_Tax_Controller
{
    public function get_taxes(WP_REST_Request $request)
    {
        global $wpdb;

        // Get parameters from the request
        $draw              = intval($request->get_param('draw'));
        $start             = intval($request->get_param('start'));
        $length            = intval($request->get_param('length'));
        $orderColumnIndex  = intval($request->get_param('order')[0]['column']);
        $orderDirection    = $request->get_param('order')[0]['dir'];
        $inclusive_tax     = $request->get_param('inclusive_tax');
        $tax_priority      = $request->get_param('tax_priority');

        // Map the order column index to the column name
        $columns = ['id','status','tax_name', 'tax_rate', 'tax_type', 'tax_booking_type', 'inclusive_tax', 'tax_priority'];
        $orderColumn = isset($columns[$orderColumnIndex]) ? $columns[$orderColumnIndex] : 'id';

        // Retrieve total records count
        $totalRecords = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->wpb_tax}");

        // Retrieve filtered records count
        $filteredRecords = $totalRecords;

        // Retrieve the data for the current page
        $data = $wpdb->get_results($wpdb->prepare(
            "SELECT * FROM {$wpdb->wpb_tax} ORDER BY $orderColumn $orderDirection LIMIT %d, %d",
            $start,
            $length
        ));

        // Format the data for DataTables
        $formattedData = array_map(function ($row) {
            $wpb_prefix = wpb_get_general_settings()['prefix'] ?? '';
            $wpb_postfix = wpb_get_general_settings()['postfix'] ?? '';
            $tax_booking_types = $this->get_booking_type_names($row->tax_booking_type);
            // Foramtted Rate
            $formatted_rate = $row->tax_type == 'fixed' ? $wpb_prefix . $row->tax_rate . $wpb_postfix : $row->tax_rate . '%';
            // Foramtted Rate Type
            $formatted_type = $row->tax_type == 'fixed' ? $wpb_prefix : '%';

            return [
                'id'            => $row->id,
                'status'        => $row->status,
                'name'          => $row->tax_name,
                'rate'          => $formatted_rate,
                'type'          => $formatted_type,
                'booking_type'  => $tax_booking_types,
                'inclusive_tax' => $row->inclusive_tax,
                'tax_priority'  => $row->tax_priority,
                'actions'       => [
                    "edit"   => true,
                    "delete" => true,
                ],
            ];
        }, $data);

        // Return the response
        wp_send_json([
            'recordsTotal' => $totalRecords,
            'recordsFiltered' => $filteredRecords,
            'data' => $formattedData,
        ]);
    }

    public function add_tax(WP_REST_Request $request)
    {
        global $wpdb;

        $status             = 1;
        $tax_name           = $request->get_param('tax_name');
        $tax_rate           = floatval($request->get_param('tax_rate'));
        $tax_type           = $request->get_param('tax_type');
        $tax_booking_type   = $request->get_param('tax_booking_type');
        $tax_priority       = $request->get_param('tax_priority');

        $include_exclude_tax=  (wpb_get_general_settings()['include_exclude_tax']??"incl" )=="incl"?"yes":"no"  ;
        $data = array(
            'status' => $status,
            'tax_name' => $tax_name,
            'tax_rate' => $tax_rate,
            'tax_type' => $tax_type,
            'tax_booking_type' => $tax_booking_type,
            'inclusive_tax' => $include_exclude_tax,
            'tax_priority' => $tax_priority,
        );

        $wpdb->insert($wpdb->wpb_tax, $data);

        if ($wpdb->insert_id) {
            return wp_send_json(array('message' => esc_html__('Tax Added Successfully','wpbookit') , 'status' => 'success'));
        } else {
            return wp_send_json(array('message' => esc_html__('Failed to add tax','wpbookit'), 'status' => 'error'));
        }
    }

    public function edit_tax_details(WP_REST_Request $request)
    {
        global $wpdb;
        $tax_id = intval($request->get_param('tax_id'));

        $tax = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->wpb_tax} WHERE id = %d", $tax_id));

        if ($tax) {
            $tax_booking_type_ids = explode(',', $tax->tax_booking_type);
            $tax_booking_types = $this->get_booking_type_names($tax->tax_booking_type);

            return wp_send_json([
                'status'                => 'success',
                'id'                    => $tax->id,
                'tax_name'              => $tax->tax_name,
                'tax_rate'              => $tax->tax_rate,
                'tax_type'              => $tax->tax_type,
                'tax_booking_type'      => $tax_booking_types,
                'tax_booking_type_ids'  => $tax_booking_type_ids,
                'inclusive_tax'         => $tax->inclusive_tax,
                'tax_priority'          => $tax->tax_priority,
            ]);
        } else {
            return wp_send_json([
                'status' => 'error',
                'message' => 'Tax not found',
            ]);
        }
    }

    public function update_tax(WP_REST_Request $request)
    {
        global $wpdb;

        $tax_id             = intval($request->get_param('edit-tax-id'));
        $tax_name           = $request->get_param('tax_name');
        $tax_rate           = floatval($request->get_param('tax_rate'));
        $tax_type           = $request->get_param('tax_type');
        $tax_booking_type   = $request->get_param('tax_booking_type');
        $inclusive_tax      = $request->get_param('inclusive_tax');
        $tax_priority       = $request->get_param('tax_priority');

        $data = array(
            'tax_name'          => $tax_name,
            'tax_rate'          => $tax_rate,
            'tax_type'          => $tax_type,
            'tax_booking_type'  => $tax_booking_type,
            'tax_priority'      => $tax_priority,
        );

        $where = array('id' => $tax_id);

        $count= $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM %i  WHERE tax_priority LIKE %d AND id NOT LIKE %d",$wpdb->wpb_tax,$tax_priority,$tax_id));
        if($count>0){
            return wp_send_json(array('message' => esc_html__('Tax Priority already set','wpbookit'), 'status' => 'error'));
        }
        $updated = $wpdb->update($wpdb->wpb_tax, $data, $where);
        

        if ($updated !== false) {
            return wp_send_json(array('message' => 'Tax Updated Successfully', 'status' => 'success'));
        } else {
            return wp_send_json(array('message' => 'Failed to update tax', 'status' => 'error'));
        }
    }

    public function delete_tax(WP_REST_Request $request)
    {
        global $wpdb;
        $request_data = $request->get_params();

        try {
            $tax_id = intval($request_data['tax_id']) ?? 0;
            if ($tax_id) {
                $response = $wpdb->delete(
                    $wpdb->wpb_tax,
                    array('id' => $tax_id),
                    array('%d')
                );

                if ($response) {
                    $response = [
                        'status'  => 'success',
                        'message' => esc_html__('Tax Deleted Successfully.', 'wpbookit')
                    ];
                } else {
                    $response = [
                        'status' => 'error',
                        'message' => esc_html__('Error while deleting tax.', 'wpbookit')
                    ];
                }
            } else {
                $response = array(
                    'status'  => 'error',
                    'message' => esc_html__('Invalid tax ID.', 'wpbookit')
                );
            }
        } catch (Exception $e) {
            $response = [
                'status'  => 'error',
                'message' => $e->getMessage()
            ];
        }
        wp_send_json($response);
    }

    public function update_tax_status(WP_REST_Request $request)
    {
        global $wpdb;

        $tax_id = intval($request->get_param('tax_id'));
        $status = intval($request->get_param('status'));

        $data = array(
            'status' => $status,
        );

        $where = array('id' => $tax_id);

        $updated = $wpdb->update($wpdb->wpb_tax, $data, $where);

        if ($updated !== false) {
            return wp_send_json(array('message' => 'Tax Status Updated Successfully', 'status' => 'success'));
        } else {
            return wp_send_json(array('message' => 'Failed to update tax status', 'status' => 'error'));
        }
    }

    public function get_booking_type_names($tax_booking_type_ids)
    {
        global $wpdb;
        $tax_booking_type_ids = explode(',', $tax_booking_type_ids);
        $tax_booking_types = [];

        if (in_array('0', $tax_booking_type_ids)) {
            $tax_booking_types[] = 'All';
        } else {
            foreach ($tax_booking_type_ids as $type_id) {
                $type_name = $wpdb->get_var($wpdb->prepare(
                    "SELECT name FROM {$wpdb->prefix}wpb_booking_type WHERE id = %d",
                    $type_id
                ));
                if ($type_name) {
                    $tax_booking_types[] = $type_name;
                }
            }
        }

        return $tax_booking_types;
    }
}
