<?php

/**
 * WPB Admin Settings Design Class
 */

if (!class_exists('WPB_Settings_Payment', false)):

	/**
	 * WPB_Settings_Payment Class.
	 */
	class WPB_Settings_Payment extends WPB_Setting_Page
	{

		public $item_per_list;

		function __construct()
		{
			$this->id               = 'payment';
			$this->label            = esc_html__('Payments', 'wpbookit');
			$this->icon             = IQWPB_PLUGIN_PATH . '/core/admin/assets/images/menu-icons/payment-icon.svg';
			$this->type             = esc_html__('FINANCE', 'wpbookit');
			$this->item_per_list    = 5;
			$this->priority         = 80;


			parent::__construct();
		}

		public function get_settings_html()
		{
			$columns = $this->get_payment_column();
			$payment_status = $this->get_payment_status();
			$current_page = isset($_GET['paged']) ? intval($_GET['paged']) : 1;
			
			$customer_details_column = $this->get_customer_details_column();
			$booking_details_column = $this->get_booking_details_column();
			$payment_statuses 		= wpb_get_booking_payment_statuses();

			$customer_list = wpb_get_customers();
			

			include IQWPB_PLUGIN_PATH . '/core/admin/views/settings/html-admin-settings-payment.php';
		}

		public function get_payment_column()
		{
			return apply_filters(
				'wpb_add_payment_columns',
				array(
					'id' => esc_html__('ID', 'wpbookit'),
					'payment-customer' => esc_html__('Customer', 'wpbookit'),
					'payment-mode' => esc_html__('Mode of Payment', 'wpbookit'),
					'payment-paid-amount ' => esc_html__('Paid Amount', 'wpbookit'),
					'payment-transactions-id' => esc_html__('Transactions ID', 'wpbookit'),
					'payment-create-date' => esc_html__('Created At', 'wpbookit'),
					'payment-status' => esc_html__('Payment Status', 'wpbookit'),
					'customer-actions' => esc_html__('Action', 'wpbookit'),
				)
			);
		}
		public function get_payment_status()
		{
			return apply_filters(
				'wpb_add_payment_status',
				array(
					'1' => esc_html__('Paid', 'wpbookit'),
					'0' => esc_html__('Unpaid', 'wpbookit')
				)
			);
		}

		

		public function get_payments_pagination_var()
		{
			global $wpdb;

			//$query = $wpdb->prepare("SELECT COUNT(*) FROM %i", $wpdb->wpb_payments);
			$query = $wpdb->prepare(
				"SELECT COUNT(*) 
				FROM %i AS payments 
				INNER JOIN %i AS bookings ON payments.bookings_id = bookings.id 
				INNER JOIN %i AS users ON bookings.customer_id = users.ID 
				WHERE 1 = 1",
				$wpdb->wpb_payments,
				$wpdb->wpb_bookings,
				$wpdb->users
			);

			return [
				'total_no_of_items' => $wpdb->get_var($query),
				'item_per_page' => $this->item_per_list
			];

		}

		public function get_revenue()
		{
			global $wpdb;
			$table_name = $wpdb->wpb_payments;

			$query = $wpdb->prepare("
                SELECT paid_amount
                FROM $table_name
                WHERE payment_status = %d
            ", 1);

			$paid_amounts = $wpdb->get_results($query);
			$total_paid_amount = 0;

			foreach ($paid_amounts as $amount) {
				$total_paid_amount += empty($amount->paid_amount) || $amount->paid_amount == 'Free' ?0:$amount->paid_amount;
			}

			return $total_paid_amount;

		}

		public function change_payment_status($args)
		{
			global $wpdb;

			$payment_status = $args['payment_status'] ;
			$payment_id = !empty($args['payment_id']) ? $args['payment_id'] : '';
			$table_name = $wpdb->wpb_payments;
			$data = array(
				'payment_status' => $payment_status,
			);
			// Where condition
			$where = array(
				'id' => $payment_id,
			);

			// Run the update query
			return $wpdb->update($table_name, $data, $where);
		}


		public function get_customer_details_column()
		{
			return apply_filters(
				'wpb_add_customer_details_columns',
				array(
					'customer_name' => esc_html__('Customer Name', 'wpbookit'),
					'customer_gender' => esc_html__('Gender', 'wpbookit'),
					'customer_birthdate' => esc_html__('DOB', 'wpbookit'),
				)
			);
		}

		public function get_booking_details_column()
		{
			return apply_filters(
				'wpb_add_booking_details_columns',
				array(
					'sr_id' => esc_html__('SR NO', 'wpbookit'),
					'booking_type' => esc_html__('Booking Type', 'wpbookit'),
					'booking_duration' => esc_html__('Duration','wpbookit'),
					'booking_price' => esc_html__('Price', 'wpbookit'),
				)
			);
		}
	}

	new WPB_Settings_Payment();

endif;