<div class="content-inner container-fluid pb-0" id="payment_inner">
    <div class="d-flex justify-content-between align-items-center flex-wrap mb-4 gap-3">
        <div class="d-flex flex-column">
            <h4 class="mb-0"><?php esc_html_e('Payments', 'wpbookit'); ?></h4>
        </div>
        <div class="d-flex justify-content-between align-items-center rounded flex-wrap gap-3">
            <a class="btn bg-white" data-bs-toggle="offcanvas" data-bs-target="#payment-filters" role="button" aria-controls="payment-filters">
                <img src="<?php echo esc_url(IQWPB_PLUGIN_URL . '/core/admin/assets/images/filter-icons.svg'); ?>" />
                <span class="align-middle"><?php esc_html_e('ADVANCED FILTER', 'wpbookit'); ?></span>
            </a>
            <button type="button" class="btn bg-white" id="export-file">
                <img src="<?php echo esc_url(IQWPB_PLUGIN_URL . 'core/admin/assets/images/export-icon.svg'); ?>" alt="checked">
                <span class="align-middle"><?php esc_html_e('Export Payment', 'wpbookit'); ?></span>

            </button>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="table-wrapper rounded mb-4">
                <div id="datatable_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                    <div class="table-responsive">
                        <?php require_once "payment/payment-table.php"; ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="d-flex justify-content-between align-items-center rounded flex-wrap gap-3">
        <div class="offcanvas <?php echo esc_html(wpb_append_class_base_on_rtl('offcanvas-end', 'offcanvas-start')) ?> advance-filter payment_invoice" tabindex="-1" id="payment_invoice" data-bs-scroll="true" data-bs-backdrop="true" aria-labelledby="advance-filter-label">
            <div class="offcanvas-header">
                <div class="d-flex align-items-center">
                    <h4 class="offcanvas-title" id="advance-filter-label">
                        <?php esc_html_e('Payment Invoice', 'wpbookit'); ?>
                    </h4>
                </div>
                <button type="button" class="btn-close add-btn-close text-reset shadow-none me-0" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body data-scrollbar">
                <form id="invoice_form">
                    <div class="mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center justify-content-between gap-2 mb-2">
                            <h6 id="wpb_booking_type" class="m-0">

                            </h6>
                            <span id="wpb_customer_address">

                            </span>
                        </div>
                        <div class="d-flex align-items-center justify-content-between gap-2 mb-2">
                            <h6 id="wpb_payment_id" class="m-0">

                            </h6>
                            <span id="wpb_customer_email">

                            </span>
                        </div>
                        <div class="d-flex align-items-center justify-content-between gap-2">
                            <h6 id="wpb_booking_date" class="m-0">

                            </h6>
                            <span id="wpb_booking_status"></span>
                        </div>
                        <?php do_action('iqwpb_add_extra_fields'); ?>
                     
                    </div>
                    <div class="form-group">
                        <h6 class="mb-3"><?php esc_html_e('Customer Details', 'wpbookit'); ?></h6>
                        <div class="table-responsive">
                            <table id="datatable" class="table custome-table table-style-gray wpb-datatable dataTable no-footer" data-toggle="data-table" aria-describedby="datatable_info">
                                <thead>
                                    <tr>
                                        <?php foreach ($customer_details_column as $customer_details_id => $customer_details_name) : ?>
                                            <th scope="col" class="sorting" tabindex="0" aria-label="Names: activate to sort column ascending">
                                                <span class="nobr"><?php echo esc_html($customer_details_name); ?></span>
                                            </th>
                                        <?php endforeach; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <?php foreach ($customer_details_column as $customer_details_id => $customer_details_name) : ?>
                                            <td scope="col" class="sorting" tabindex="0" aria-label="Names: activate to sort column ascending" id="<?php echo esc_attr($customer_details_id); ?>">
                                                <span class="nobr"></span>
                                            </td>
                                        <?php endforeach; ?>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="form-group">
                        <h6 class="mb-3"><?php esc_html_e('Booking Details', 'wpbookit'); ?></h6>
                        <div class="table-reponsive">
                            <table id="datatable" class="table custome-table table-style-gray wpb-datatable dataTable no-footer" data-toggle="data-table" aria-describedby="datatable_info">
                                <thead>
                                    <tr>
                                        <?php foreach ($booking_details_column as $booking_details_id => $booking_details_name) : ?>
                                            <th scope="col" class="sorting" tabindex="0" aria-label="Names: activate to sort column ascending">
                                                <span class="nobr"><?php echo esc_html($booking_details_name); ?></span>
                                            </th>
                                        <?php endforeach; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <?php foreach ($booking_details_column as $booking_details_id => $booking_details_name) : ?>
                                            <td scope="col" class="sorting" tabindex="0" aria-label="Names: activate to sort column ascending" id="<?php echo esc_attr($booking_details_id); ?>">
                                                <span class="nobr"></span>
                                            </td>
                                        <?php endforeach; ?>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="form-group">
                        <h6 class="mt-5 mb-3"><?php esc_html_e('Payment Details', 'wpbookit'); ?></h6>
                        <div class="table-reponsive" id="payment-details-data">
                            <table id="datatable" class="table custome-table wpb-datatable dataTable no-footer table-custom-border tax-module-invoice" data-toggle="data-table" aria-describedby="datatable_info">
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </form>
            </div>
            <div class="offcanvas-footer">
                <div class=" d-flex mb-3">
                    <div class="col-sm-6 d-flex align-items-center mx-1">
                        <button id="cancel-update" class="btn btn-secondary w-100" type="button" data-bs-dismiss="offcanvas" aria-label="Close"><?php esc_html_e('Cancel', 'wpbookit'); ?></button>
                    </div>
                    <div class="col-sm-6 d-flex align-items-center mx-1">
                        
                        <button type="submit" id="wpb_invoice_submit" name="wpb_invoice_submit" data-id="" class="btn btn-primary w-100">
                            <svg class="spinner d-none wpb-customer-submit-svg" height="20" width="20" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                <path fill="#d3d3d3" d="M304 48c0 26.5-21.5 48-48 48s-48-21.5-48-48 21.5-48 48-48 48 21.5 48 48zm-48 368c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48zm208-208c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48zM96 256c0-26.5-21.5-48-48-48S0 229.5 0 256s21.5 48 48 48 48-21.5 48-48zm12.9 99.1c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48c0-26.5-21.5-48-48-48zm294.2 0c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48c0-26.5-21.5-48-48-48zM108.9 60.9c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48z" />
                            </svg>
                            <span>
                                <?php esc_html_e('Print', 'wpbookit'); ?>
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<form id="payment_filters_form">
    <div class="offcanvas <?php echo esc_html(wpb_append_class_base_on_rtl('offcanvas-end', 'offcanvas-start')) ?> advance-filter payment-filters" tabindex="-1" id="payment-filters" data-bs-scroll="true" data-bs-backdrop="true" aria-labelledby="advance-filter-label">
        <div class="offcanvas-header">
            <div class="d-flex align-items-center">
                <h4 class="offcanvas-title" id="advance-filter-label">
                    <?php esc_html_e('Advanced Filter', 'wpbookit'); ?>
                </h4>
            </div>
            <button type="button" class="btn-close add-btn-close text-reset shadow-none" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body data-scrollbar">

            <div class="bg-body ranges rounded mb-4">
                <div class="row p-0 m-0">
                    <div class=" col-lg-4 p-0">
                        <ul class="list-unstyled m-0 range-list">
                            <li class="active" id="wpb_today_btn">
                                <a href="#">
                                    <?php esc_html_e('Today', 'wpbookit'); ?>
                                </a>
                            </li>
                            <li id="wpb_get_last_30_days">
                                <a href="#">
                                    <?php esc_html_e('Last 30 Days', 'wpbookit'); ?>
                                </a>
                            </li>
                            <li id="wpb_this_month_btn">
                                <a href="#">
                                    <?php esc_html_e('This Month', 'wpbookit'); ?>
                                </a>
                            </li>
                            <li id="wpb_last_month_btn">
                                <a href="#">
                                    <?php esc_html_e('Last Month', 'wpbookit'); ?>
                                </a>
                            </li>
                            <li id="wpb_get_last_90_days">
                                <a href="#">
                                    <?php esc_html_e('Last 90 Days', 'wpbookit'); ?>
                                </a>
                            </li>
                            <li id="wpb_get_last_6_months">
                                <a href="#">
                                    <?php esc_html_e('Last 6 Months', 'wpbookit'); ?>
                                </a>
                            </li>
                            <li id="wpb_get_last_1_year">
                                <a href="#">
                                    <?php esc_html_e('Last 1 Year', 'wpbookit'); ?>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="calender-list-box col-lg-8 p-0">
                        <div class="calender-header rounded-top-end bg-primary p-2">
                            <div class="d-flex justify-content-between">
                                <div class="btn bg-white text-primary pe-none" id="wpb_filter_from_date">
                                    -
                                </div>
                                <div class="btn text-white pe-none">
                                    <?php esc_html_e('To', 'wpbookit'); ?>
                                </div>
                                <div class="btn bg-white text-primary pe-none" id="wpb_filter_to_date">
                                    -
                                </div>
                            </div>
                        </div>
                        <div class="calander-body">
                            <div class="form-group mb-lg-3 mb-5">
                                <input type="hidden" name="wpb-bookings-advanced-filter-flatpiker" class="d-none inline_flatpickr" id="wpb-bookings-advanced-filter-flatpiker">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="form-label"><?php esc_html_e('Customer Name*', 'wpbookit'); ?></label>
                <input class="form-control" type="customer_name" name="wpb_payment_name" value="" />
                <small class="fst-italic fw-medium"><?php esc_html_e('*You can enter customer name', 'wpbookit'); ?></small>

            </div>
            <div class="form-group">
                <?php $payments = apply_filters('wpb_booking_shortcode_active_payment_gateway', []);

                ?>

                <?php if (count($payments) > 0) : ?>
                    <label class="form-label"><?php esc_html_e('Payment Mode*', 'wpbookit'); ?></label>
                    <select class="select2-basic-multiple js-states form-control" name="wpb_payment_mode[]" style="width: 100%;" multiple>
                        <?php foreach ($payments as $key => $value) : ?>
                            <option value="<?php echo esc_html($key); ?>">
                                <?php echo esc_html($value); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <small class="fst-italic fw-medium"><?php esc_html_e('*You can select multiple paymemnt mode', 'wpbookit'); ?></small>
                <?php endif; ?>

            </div>
            <div class="form-group">
                <label class="form-label"><?php esc_html_e('Paid Amount*', 'wpbookit'); ?></label>
                <input class="form-control" type="number" name="wpb_payment_amount" value="" />
            </div>
            <div class="form-group">
                <label class="form-label"><?php esc_html_e('Payment Status*', 'wpbookit'); ?></label>
                <select class="select2-basic-multiple js-states form-control" name="wpb_payment_status[]" style="width: 100%;" multiple>
                    <?php foreach ($payment_statuses as $paymentStatusKey => $paymentStatussval) : ?>
                        <option value="<?php echo esc_attr($paymentStatusKey); ?>">
                            <?php echo esc_html($paymentStatussval); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <small class="fst-italic fw-medium"><?php esc_html_e('*You can select multiple payment status', 'wpbookit'); ?></small>
            </div>

        </div>
        <div class="offcanvas-footer">
            <div class="row">
                <div class="col-6">
                    <button id="wpb_apply_payment_reset" type="button" class="btn btn-secondary  w-100 mt-5">
                        <?php esc_html_e('Reset filters', 'wpbookit'); ?>
                    </button>
                </div>
                <div class="col-6">
                    <button id="wpb_apply_payment_filters" type="submit" class="btn btn-primary  w-100 mt-5">
                        <?php esc_html_e('Apply filters', 'wpbookit'); ?>
                    </button>
                </div>

            </div>
        </div>
    </div>
</form>