
<form id="add-tax-form" class="add-tax-form">
<div class="offcanvas offcanvas-end tax-form" tabindex="-1" id="tax-form" data-bs-scroll="true" data-bs-backdrop="true" aria-labelledby="tax-form-label">
        <div class="offcanvas-header">
            <div class="d-flex align-items-center">
                <h4 class="offcanvas-title offcanvas-title-add d-none" id="tax-form-label"><?php esc_html_e('Create Tax', 'wpbookit'); ?></h4>
                <h4 class="offcanvas-title offcanvas-title-edit d-none"><?php esc_html_e('Edit Tax', 'wpbookit'); ?></h4>
            </div>
            <button type="button" class="btn-close add-btn-close text-reset shadow-none" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body data-scrollbar">
            <div class="form-group">
                <label for="time" class="form-label"><?php esc_html_e('Tax Name', 'wpbookit'); ?>*</label>
                <input type="text" name="tax_name" id="tax_name" style="width: 100%;" class="form-control" placeholder="<?php esc_html_e("Enter tax name", 'wpbookit') ?>">
                <span id="tax_name_error" class="error-message"></span>
            </div>
            <div class="form-group">
                <div class="align-items-center" id="static_url_field">
                    <label class="form-label text-capitalize me-2" for="tax_type"><?php esc_html_e("Tax Rates", 'wpbookit') ?>*</label>
                    <div class="input-group align-item-center" id="tax_rates">
                        <input type="text" min="1" name="tax_rate" id="tax_rate" class="form-control custom_link tax-rate-control" placeholder="<?php esc_html_e("Enter tax amount here", 'wpbookit') ?>">
                        <span class="input-group-text">
                            <select class="form-select" id="tax_type" name="tax_type">
                                <?php
                                $wpb_prefix = wpb_get_general_settings()['prefix'] ?? '';
                                $wpb_postfix = wpb_get_general_settings()['postfix'] ?? '';
                                ?>
                                <option value="fixed"><?php esc_html_e($wpb_prefix, 'wpbookit') ?></option>
                                <option value="percentage"><?php esc_html_e("%", 'wpbookit') ?></option>
                            </select>
                        </span>
                    </div>
                    <span class="error" id="tax_rate_error"></span>
                </div>
            </div>
            <div class="form-group">
                <label class="form-label"><?php esc_html_e('Booking Type', 'wpbookit'); ?>*</label>
                <select class="select2-basic-multiple js-states form-control" id="tax_booking_type" name="tax_booking_type[]" multiple style="width: 100%;">
                    <option value="0"><?php esc_html_e('All', 'wpbookit'); ?></option>
                    <?php
                    foreach ($booking_types as $bookingTypesStatus) :?>
                        <option value="<?php echo esc_attr($bookingTypesStatus->get_id()); ?>">
                            <?php esc_html_e($bookingTypesStatus->get_name()); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <span id="booking_type_error" class="error-message"></span>
            </div>
            <div class="form-group">
                <label for="priority" class="form-label"><?php esc_html_e('Priority', 'wpbookit'); ?>*</label>
                <input type="number" name="tax_priority" min="1" id="tax_priority" class="form-control" placeholder="<?php esc_html_e("Enter priority", 'wpbookit') ?>">
                <span id="priority_error" class="error-message"></span>
            </div>
        </div>
        <div class="offcanvas-footer">
            <div class="d-flex align-items-center">
                <input type="hidden" id="edit-tax-id" name="edit-tax-id">
                <button type="submit" class="btn btn-primary w-100" id="wpb-submit-tax">
                    <svg class="spinner d-none wpb-tax-submit-svg" height="20" width="20" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                        <path fill="#d3d3d3" d="M304 48c0 26.5-21.5 48-48 48s-48-21.5-48-48 21.5-48 48-48 48 21.5 48 48zm-48 368c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48zm208-208c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48zM96 256c0-26.5-21.5-48-48-48S0 229.5 0 256s21.5 48 48 48 48-21.5 48-48zm12.9 99.1c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48c0-26.5-21.5-48-48-48zm294.2 0c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48c0-26.5-21.5-48-48-48zM108.9 60.9c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48z" />
                    </svg>
                    <?php esc_html_e('Save', 'wpbookit'); ?>
                </button>
            </div>
        </div>
    </div>
</form>