<?php 

class Booking_Type_Handler {

    public function __construct() {
        add_filter( 'rewrite_rules_array', array( $this, 'add_booking_type_rewrite_rule'));
        add_filter( 'query_vars', array($this, 'register_query_vars'));
        add_action( 'template_redirect', array($this, 'template_redirect'), 10 );
        add_action( 'init', array( $this, 'add_permalink_tag' ) );

        add_action( 'wpb_enqueue_script',[$this,'wpb_enqueue_script']);
        
        register_activation_hook(__FILE__, 'flush_rewrite_rules');
        register_deactivation_hook(__FILE__, 'flush_rewrite_rules');

        /**
         * Initializes PHP sessions during WordPress initialization if sessions are enabled.
         *
         * This hook callback checks the current session status and starts a new session
         * if one hasn't been started yet and sessions aren't disabled on the server.
         * 
         * @since [version] (Replace with actual version number)
         * @hook init
         * 
         * @return void
         */
        add_action( 'init', function() {
            $status = session_status();
            if ( PHP_SESSION_DISABLED === $status ) {
                // That's why you cannot rely on sessions!
                return;
            }

            if ( PHP_SESSION_NONE === $status ) {
                session_start();
            }
        });
    }

    public function add_booking_type_rewrite_rule($rules) {
        global $wp_rewrite;
    
        // Get general settings
        $general_setting = wpb_get_general_settings();
        $base_url = isset($general_setting['permalink_strcture']) ? $general_setting['permalink_strcture'] : 'booking';
    
        // Add new rewrite rules
        $new_rules = array(
            $base_url . '/([^/]+)/?$' => 'index.php?booking_type_slug=$matches[1]',
            'oauth-zoom-token/([^/]+)/?$' => 'index.php?oauth_zoom_token=1',
        );
        $wp_generated_rewrite_rules         = $wp_rewrite->generate_rewrite_rules( $base_url . '/([^/]+)/?$', EP_PAGES, true, true, false, false );

        // Merge new rules with existing rules
        $rules = array_merge($new_rules, $rules);
        return $rules;
    }

    public function add_permalink_tag() {
        add_rewrite_tag('%booking_type_slug%', '([^&]+)');
        add_rewrite_tag('%oauth_zoom_token%', '([^&]+)');
    }

    public function register_query_vars($vars) {
        // Register custom query variable
        $vars[] = 'booking_type_slug';
        $vars[] = 'oauth_zoom_token';
        return $vars;
    }

    public function template_redirect() {
        global $wp;
        // Check for the presence of the query variable and handle the request
        $general_setting = wpb_get_general_settings();
        $base_url = isset($general_setting['permalink_strcture']) ? $general_setting['permalink_strcture'] : 'booking';
        
        $booking_type_slug = get_query_var('booking_type_slug');

        if (preg_match("/^{$base_url}(\/[a-zA-Z0-9_-]+)?$/", $wp->request)) {
            if (!empty($booking_type_slug)) {
                $booking_type = wpb_get_booking_type($booking_type_slug, ['id']);

                if (isset($booking_type['id'])) {
                    $booking_type_id = $booking_type['id'];
                    add_action('template_include', function() use($booking_type_id, $general_setting) {
                        // Enqueue scripts before header
                        do_action('wpb_enqueue_script', [
                            'hide_header' => $general_setting['hide-header'] ?? false,
                            'hide_footer' => $general_setting['hide-footer'] ?? false
                        ]);

                        // Check if using block theme
                        if (wp_is_block_theme()) {
                            ?><!DOCTYPE html>
                            <html <?php language_attributes(); ?>>
                            <head>
                                <?php wp_head(); ?>
                            </head>
                            <body <?php body_class(); ?>>
                            <?php wp_body_open(); ?>
                            <?php 
                            if (!wpb_get_custom_header()) {
                                block_header_area();
                            }
                            ?>
                            <?php
                        } else {
                            wpb_get_header();
                        }
                        ?>
                        <div class="wpb-booking-dynamic-shortcode">
                            <?php 
                            do_action('wpb_before_booking_shortcode', $booking_type_id);
                            echo do_shortcode("[wpb-booking id='" . $booking_type_id . "']"); 
                            do_action('wpb_after_booking_shortcode', $booking_type_id);
                            ?>
                        </div>
                        <?php
                        if (wp_is_block_theme()) {
                            if (!wpb_get_custom_footer()) {
                                block_footer_area();
                            }
                            wp_footer();
                            ?></body></html><?php
                        } else {
                            wpb_get_footer();
                        }
                        exit;
                    });
                } else {
                    wp_redirect(site_url() . '/' . $base_url . '/');
                    exit;
                }
            } else {
                global $wp_query;
                $wp_query->is_404 = false;
                add_action('template_include', function() use($general_setting) {
                    do_action('wpb_enqueue_script', [
                        'hide_header' => $general_setting['hide-header'] ?? false,
                        'hide_footer' => $general_setting['hide-footer'] ?? false
                    ]);

                    if (wp_is_block_theme()) {
                        ?><!DOCTYPE html>
                        <html <?php language_attributes(); ?>>
                        <head>
                            <?php wp_head(); ?>
                        </head>
                        <body <?php body_class(); ?>>
                        <?php wp_body_open(); ?>
                        <?php 
                        if (!wpb_get_custom_header()) {
                            block_header_area();
                        }
                        ?>
                        <?php
                    } else {
                        get_header();
                    }
                    ?>
                    <div class="wpb-booking-dynamic-shortcode">
                        <?php echo do_shortcode("[wpb-booking-types]"); ?>
                    </div>
                    <?php
                    if (wp_is_block_theme()) {
                        if (!wpb_get_custom_footer()) {
                            block_footer_area();
                        }
                        wp_footer();
                        ?></body></html><?php
                    } else {
                        get_footer();
                    }
                    exit;
                });
            }
        }

        $oauth_zoom_token = get_query_var('oauth_zoom_token');
        if (isset($oauth_zoom_token)) {
            flush_rewrite_rules();
            $wpb_zoom_booking_create_addon = new Wpb_Zoom_Booking_Create_Addon();
            $wpb_zoom_booking_create_addon->wpb_handle_zoom_callback();
        }
    }

    public function wpb_enqueue_script($booking_args){
       
        if($booking_args['hide_footer']=="1"  || $booking_args['hide_header'] == "1"){
            wp_register_style( 'wpb-booking', false );
            wp_enqueue_style( 'wpb-booking' );

            $header_element = apply_filters("wpb_shortcode_page_header_element","#header,header");
            $footer_element = apply_filters("wpb_shortcode_page_footer_element","#footer,footer");

            ob_start();
            if($booking_args['hide_footer']=='1'){
                echo "{$footer_element}{display:none !important}";
            }
            if($booking_args['hide_header']=='1'){
                echo "{$header_element}{display:none !important}";
                echo ".storefront-breadcrumb{display:none !important}";
            }

            echo ".col-full {
                max-width: 100% !important;
            }
            ";
            $css= ob_get_clean();
    
            wp_add_inline_style( 'wpb-booking', $css );
        }
    }
}

// Instantiate the class to register hooks
new Booking_Type_Handler();
