<?php

/**
 * WPBookit Woocommerce Payment Integration
 *
 */

defined('ABSPATH') || exit;


class WPB_WC_Init
{

	public $payment_gateway = 'wpb_wc_payment_gateway';
	public function __construct()
	{
		add_filter('wpb_booking_shortcode_active_payment_gateway', array($this, 'wp_add_woocommerce_payment_gateway'));
		add_filter("wpb_booking_" . $this->payment_gateway, array($this, 'wpb_wc_booking_payment'), 10, 3);

		// Hook After Booking Woocommerce Booking Order Completed
		add_action('woocommerce_order_status_completed', [$this, 'wpb_woo_payment_complete'], 10, 1);
		add_action('woocommerce_order_status_changed', [$this, 'wpb_woo_order_status_change_custom'], 10, 3);

		add_filter('woocommerce_prevent_admin_access', '__return_false');
		add_action('woocommerce_thankyou', [$this, 'wpb_checkout_redirect_widget_payment']);

		// Function to transfer cart item meta to order item meta
		add_action('woocommerce_checkout_create_order_line_item', [$this, 'add_cart_item_meta_to_order'], 10, 4);

        add_action('woocommerce_cart_calculate_fees', [$this, 'add_custom_tax_fee']);
		add_filter('woocommerce_product_is_taxable',  [$this, 'make_booking_product_non_taxable'],10,2);

		
	}

	  /**
     * Mark specific booking products as non-taxable
     */
    public function make_booking_product_non_taxable($is_taxable, $product_instance) {
        if ($product_instance->get_meta('_wpbookit_booking_product') === "yes") {
            // Remove tax from cart fees
			add_filter('woocommerce_calc_tax', '__return_false');
            add_filter('woocommerce_cart_totals_get_fees_from_cart_taxes', fn() => []);
            return false;
        }
        return $is_taxable;
    }
	
    /**
     * Apply custom tax at checkout
     */
    public function add_custom_tax_fee() {
        if (is_admin() && !defined('DOING_AJAX')) {
            return;
        }

        foreach (WC()->cart->get_cart() as  $cart_item) {
            if (isset($cart_item['wpb_booking_tax']) && is_array($cart_item['wpb_booking_tax'])) {
				foreach ($cart_item['wpb_booking_tax'] as $tax_name => $tax) {
					WC()->cart->add_fee( ucwords(str_replace('_', ' ', $tax_name)), $tax, true); // 'true' marks it as taxable
				}
            }
        }
    
    }


	public function wp_add_woocommerce_payment_gateway($active_payments)
	{
		$payment_gateways = get_option('wpb_payment_gateways');

		$active_payments[$this->payment_gateway] = isset($payment_gateways[$this->payment_gateway]['label']) && !empty($payment_gateways[$this->payment_gateway]['label']) ? $payment_gateways[$this->payment_gateway]['label'] : esc_html__("WooCommerce payment gateway", 'wpbookit');
		return $active_payments;
	}
	public function add_cart_item_meta_to_order(WC_Order_Item_Product $item, $cart_item_key, $values, $order)
	{

		if (isset($values['wpb_booking_tax'])) {
			$order->update_meta_data('wpb_booking_tax', $values['wpb_booking_tax']);
		}

		
		if (isset($values['wpb_booking_id'])) {
			$order->update_meta_data('wpb_booking_id', $values['wpb_booking_id']);
		}
	}
	
	public function wpb_wc_booking_payment($errormsg, WPB_Booking_Type $booking_type_instance, WPB_Booking $wpb_booking)
	{
		$booking_type_id = $booking_type_instance->get_id();
		$original_price  = apply_filters('wpb_booking_type_price', $booking_type_instance->get_meta('price'));
		$tax_data        = iqwpb_get_booking_totals_and_html($booking_type_id, $original_price, $wpb_booking->get_id());

		$product_id = self::wpb_wc_get_product_id($booking_type_instance);

		WC()->cart->empty_cart();
		unset($tax_data['tax_values']['sub_total']);
		unset($tax_data['tax_values']['total']);


		WC()->cart->add_to_cart($product_id, 1, 0, [], ['wpb_booking_id' => $wpb_booking->get_id(), 'wpb_booking_tax' => $tax_data['tax_values']]);

		return [
			'status'  => 'success',
			'message'  => esc_html__("Your appointment has been booked. Please wait to be redirected.", 'wpbookit'),
			'woo_payment_redirect' => wc_get_checkout_url()
		];
	}

	public function wpb_woo_order_status_change_custom($order_id, $old_status, $new_status)
	{
		global $wpdb;
		if (!empty($order_id) && get_post_status($order_id)) {
			$order = wc_get_order($order_id);
			$booking_id = $order->get_meta('wpb_booking_id');
			if (!empty($booking_id)) {
				$status = ['status' => 'wpb-pending'];
				$payment_status = ['payment_status' => 0];

				if (!empty($new_status)) {
					if ($new_status == 'completed') {

						$default_booking_status = wpb_get_general_settings()['booking_status'];
						$default_status = 'wpb-' . $default_booking_status;
						$status = ['status' => $default_status];
						$payment_status = ['payment_status' => 1];
						if ($default_status === 'wpb-approved') {
							// do_action('wpb_booking_zoom_create', (array) $booking_data, (int) $booking_id);
							do_action('wpb_customer_booking_confirmation', (int) $booking_id);
							wpb_booking_reminder($booking_id);
						} else if ($default_status === 'wpb-pending') {
							do_action('wpb_staff_booking_request', (int) $booking_id);
						}
					} elseif ($new_status == 'wpb-cancelled') {
						$status = ['status' => 'wpb-cancelled'];

						// customer cancellation hook
						do_action('wpb_customer_cancel_booking', (int) $booking_id);

						// staff cancellation hook
						do_action('wpb_staff_booking_cancellation', (int) $booking_id);
					}
				}

				$wpdb->update($wpdb->wpb_bookings, $status, ['id' => $booking_id]);
				$wpdb->update($wpdb->wpb_payments, $payment_status, ['bookings_id' => $booking_id]);
			}
		}
	}
	public function  wpb_woo_payment_complete($order_id, $type = 'woocommerce')
	{
		global $wpdb;
		$booking_id = '';
		if ($type === 'woocommerce') {
			if (!empty($order_id) && get_post_status($order_id)) {
				$booking_id = get_post_meta((int)$order_id, 'wpb_booking_id', true);
			}
		}

		if (empty($booking_id)) {
			return;
		}
	}
	public function wpb_checkout_redirect_widget_payment($order_id)
	{
		$order = wc_get_order($order_id);
		$booking_id = get_post_meta($order_id, 'wpb_booking_id', true);
		if (!empty($booking_id)) {
			if (!$order->has_status('failed')) {
				$booking_instance =  new WPB_Booking($booking_id);
				$booking_type_instance = new WPB_Booking_Type($booking_instance->get_booking_type_id());
				wp_redirect(wpb_iq_get_booking_redirect_url($booking_instance, $booking_type_instance));
				exit;
			}
		}
	}

	public static function wpb_wc_get_product_id(WPB_Booking_Type $booking_type)
	{
	
		$booking_type_id = $booking_type->get_id();
		$original_price  = $booking_type->get_meta('price');
		$html_output     = iqwpb_get_booking_totals_and_html($booking_type_id, $original_price);
		$price           = isset($html_output['tax_values']['sub_total']) ? $html_output['tax_values']['sub_total'] : 0;

		if ($id = get_metadata('wpb_booking_type', $booking_type->get_id(), 'product_id', true)) {
			$product = get_post($id);
			if ($product && $product->post_type === 'product') {
				update_post_meta($id, '_price', $price);
				return $id;
			}
		}
	

		$wpb_booking_type_wc_product_id = wp_insert_post([
			'post_title'    => $booking_type->get_name(),
			'post_type'     => 'product',
			'post_status'   => 'publish'
		]);


		wp_set_object_terms($wpb_booking_type_wc_product_id, 'simple', 'product_type');

		update_post_meta($wpb_booking_type_wc_product_id, '_visibility', 'hidden');
		update_post_meta($wpb_booking_type_wc_product_id, '_stock_status', 'instock');
		update_post_meta($wpb_booking_type_wc_product_id, 'total_sales', '0');
		update_post_meta($wpb_booking_type_wc_product_id, '_downloadable', 'yes');
		update_post_meta($wpb_booking_type_wc_product_id, '_virtual', 'yes');
		update_post_meta($wpb_booking_type_wc_product_id, '_regular_price', '');
		update_post_meta($wpb_booking_type_wc_product_id, '_sale_price', $price);
		update_post_meta($wpb_booking_type_wc_product_id, '_purchase_note', '');
		update_post_meta($wpb_booking_type_wc_product_id, '_featured', 'no');
		update_post_meta($wpb_booking_type_wc_product_id, '_weight', '');
		update_post_meta($wpb_booking_type_wc_product_id, '_length', '');
		update_post_meta($wpb_booking_type_wc_product_id, '_width', '');
		update_post_meta($wpb_booking_type_wc_product_id, '_height', '');
		update_post_meta($wpb_booking_type_wc_product_id, '_sku', '');
		update_post_meta($wpb_booking_type_wc_product_id, '_product_attributes', []);
		update_post_meta($wpb_booking_type_wc_product_id, '_sale_price_dates_from', '');
		update_post_meta($wpb_booking_type_wc_product_id, '_sale_price_dates_to', '');
		update_post_meta($wpb_booking_type_wc_product_id, '_price', $price);
		update_post_meta($wpb_booking_type_wc_product_id, '_sold_individually', 'yes');
		update_post_meta($wpb_booking_type_wc_product_id, '_manage_stock', 'no');
		update_post_meta($wpb_booking_type_wc_product_id, '_backorders', 'no');
		wc_update_product_stock($wpb_booking_type_wc_product_id, 0, 'set');
		update_post_meta($wpb_booking_type_wc_product_id, '_stock', '');
		update_post_meta($wpb_booking_type_wc_product_id, '_wpbookit_booking_product', 'yes');
		update_post_meta($wpb_booking_type_wc_product_id, '_wpbookit_booking_type_id', $booking_type->get_id());
		

		update_post_meta($wpb_booking_type_wc_product_id, '_tax_status', 'none');

		update_metadata('wpb_booking_type',$booking_type->get_id(), 'product_id', (int)$wpb_booking_type_wc_product_id );

		return $wpb_booking_type_wc_product_id;
	}
}
new WPB_WC_Init();
