<?php
/**
 * Template Name: WPB Booking Header Template
 * Description: Custom header template for WPB Booking plugin dynamic pages
 * 
 * This template file is designed to work with the WPB Booking plugin. It handles
 * the display of the header section, including conditional rendering based on
 * general settings and allowing for custom header content through hooks.
 *
 * @package WPB Booking Plugin
 * @subpackage Templates
 * @since 1.0
 */

// Security check
defined('ABSPATH') || exit;

// Get general settings
$general_settings = wpb_get_general_settings();

// Check if header should be hidden
$hide_header = isset($general_settings['hide-header']) && $general_settings['hide-header'] == '1';

// End of PHP code block
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
</head>

<body <?php body_class('wpb-booking-page'); ?>>
    <?php
    if (function_exists('wp_body_open')) {
        wp_body_open();
    }
    ?>

    <div id="page" class="wpb-site">
        <?php if (!$hide_header):
            do_action('wpb_header_content');
        endif; ?>

        <div id="content" class="wpb-site-content">