(function($){
  "use strict";

  jQuery(document).ready(function($){

    function waitForButtons() {
      const bookFlip = document.getElementById('bookFlip');
      const spreadOdd = document.getElementById('spreadOdd');
      const spreadEven = document.getElementById('spreadEven');

      if (!bookFlip || !spreadOdd || !spreadEven) {
        setTimeout(waitForButtons, 500);
        return;
      }

      // Observe class changes for all 3 buttons
      [bookFlip, spreadOdd, spreadEven].forEach(btn => observeToggle(btn));
    }

    function observeToggle(element) {
      const observer = new MutationObserver(() => {
        checkOverflow();
      });

      observer.observe(element, { attributes: true, attributeFilter: ['class'] });
    }

    // Check how many buttons are toggled and apply overflow
    function checkOverflow() {
      const bookFlip = document.getElementById('bookFlip');
      const spreadOdd = document.getElementById('spreadOdd');
      const spreadEven = document.getElementById('spreadEven');

      if (!bookFlip || !spreadOdd || !spreadEven) return;

      // Count toggled buttons
      let toggledCount = 0;
      if (bookFlip.classList.contains('toggled')) toggledCount++;
      if (spreadOdd.classList.contains('toggled')) toggledCount++;
      if (spreadEven.classList.contains('toggled')) toggledCount++;

      // Apply overflow hidden if at least 2 toggled
      if (toggledCount >= 2) {
        $('#viewer').css({'overflow': 'hidden'});
        
      } else {
        
      }
    }

    waitForButtons();
  });

})(jQuery);

