<?php

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @package    ConsentMagic
 * @subpackage ConsentMagic/includes
 */

namespace ConsentMagicPro;

class CS_Uninstall {

	/**
	 *
	 * @since    1.0.0
	 */
	public static function deactivation( $license = true ) {
		global $wpdb;
		if ( ConsentMagic()->getOption( 'cs_deactivation_db_clear' ) == 1 ) {
			// Remove settings:

			$download_langs = ConsentMagic()->getOption( 'cs_iab_download_langs' );

			if ( !is_multisite() ) {
				delete_option( 'cs_plugin_do_activation_redirect' );
				delete_option( 'cs_autodetect_email' );
				delete_option( 'cs_send_important_emails' );
				delete_option( 'cs_send_proof_deleting_email' );
				delete_option( 'cs_policy_existing_page' );
				delete_option( 'cs_privacy_overview_content_settings' );
				delete_option( 'csmart_admin_modules' );
				delete_option( 'wt_cs_consent_version' );
				delete_option( 'wt_cs_consent_version_test' );
				delete_option( 'cs_admin_permissions' );
				delete_option( 'necessary_cat_id' );
				delete_option( 'analytics_cat_id' );
				delete_option( 'marketing_cat_id' );
				delete_option( 'embedded_video_cat_id' );
				delete_option( 'googlefonts_cat_id' );
				delete_option( 'unassigned_cat_id' );
				delete_option( 'cs_common_modules' );
				delete_option( 'cs_sb_buffer_type' );
				delete_option( 'cs_sb_buffer_option' );
				delete_option( 'csconsent-magic' );
				delete_option( 'cs_proof_show_count' );
				delete_option( CMPRO_SETTINGS_DESIGN_FIELD );
				delete_option( 'cs_active_rule_id' );
				delete_option( 'cs_auto_scan_type' );
				delete_option( 'cs_admin_ignore_users' );
				delete_option( 'cs_admin_ignore_users_ip' );
				delete_option( 'cs_active_rule_id_first' );
				delete_option( 'cs_scan_status' );
				delete_option( 'cs_check_unblock_ip_tables' );

				if ( !empty( $download_langs ) ) {
					foreach ( $download_langs as $download_lang ) {
						delete_option( 'cmpro_purpose_list_option_' . $download_lang );
						delete_option( 'cmpro_purpose_list_option_' . $download_lang . '_cache' );
					}
				}
				delete_option( 'cmpro_vendor_list_option' );
				delete_option( 'cmpro_vendor_list_option_cache' );
				delete_option( 'cmpro_iab_settings' );
				delete_option( 'cmpro_additional_vendor_list_option_cache' );

				if ( $license ) {
					delete_option( 'wc_am_client_consent_magic_pro_activated' );
					delete_option( 'wc_am_client_consent_magic_pro_instance' );
					delete_option( 'wc_am_client_consent_magic_pro' );
					delete_option( 'wc_am_client_consent_magic_pro_deactivate_checkbox' );
					delete_option( 'wc_am_product_id_' . CMPRO_LICENSE_PLUGIN_NAME );
					delete_option( 'edd_license_key' );
					delete_option( 'edd_consent_magic_pro' );
					delete_option( 'edd_consent_magic_pro_activated' );
					delete_option( 'edd_consent_magic_pro_deactivate_checkbox' );
				}
			} else {

				$blog_ids = $wpdb->get_col( $wpdb->prepare( 'SELECT blog_id FROM %1$s', $wpdb->blogs ) );
				$original_blog_id = get_current_blog_id();

				foreach ( $blog_ids as $blog_id ) {
					switch_to_blog( $blog_id );
					delete_site_option( 'cs_plugin_do_activation_redirect' );
					delete_site_option( 'cs_autodetect_email' );
					delete_site_option( 'cs_send_important_emails' );
					delete_site_option( 'cs_send_proof_deleting_email' );
					delete_site_option( 'cs_policy_existing_page' );
					delete_site_option( 'cs_privacy_overview_content_settings' );
					delete_site_option( 'csmart_admin_modules' );
					delete_site_option( 'wt_cs_consent_version' );
					delete_site_option( 'wt_cs_consent_version_test' );
					delete_site_option( 'cs_admin_permissions' );
					delete_site_option( 'necessary_cat_id' );
					delete_site_option( 'analytics_cat_id' );
					delete_site_option( 'marketing_cat_id' );
					delete_site_option( 'embedded_video_cat_id' );
					delete_site_option( 'googlefonts_cat_id' );
					delete_site_option( 'unassigned_cat_id' );
					delete_site_option( 'cs_common_modules' );
					delete_site_option( 'cs_sb_buffer_type' );
					delete_site_option( 'cs_sb_buffer_option' );
					delete_site_option( 'csconsent-magic' );
					delete_site_option( 'cs_proof_show_count' );
					delete_site_option( CMPRO_SETTINGS_DESIGN_FIELD );
					delete_site_option( 'cs_active_rule_id' );
					delete_site_option( 'cs_auto_scan_type' );
					delete_site_option( 'cs_admin_ignore_users' );
					delete_site_option( 'cs_admin_ignore_users_ip' );
					delete_site_option( 'cs_active_rule_id_first' );
					delete_site_option( 'cs_scan_status' );
					delete_site_option( 'cs_check_unblock_ip_tables' );

					if ( !empty( $download_langs ) ) {
						foreach ( $download_langs as $download_lang ) {
							delete_site_option( 'cmpro_purpose_list_option_' . $download_lang );
							delete_site_option( 'cmpro_purpose_list_option_' . $download_lang . '_cache' );
						}
					}
					delete_site_option( 'cmpro_vendor_list_option' );
					delete_site_option( 'cmpro_vendor_list_option_cache' );
					delete_site_option( 'cmpro_iab_settings' );
					delete_site_option( 'cmpro_additional_vendor_list_option_cache' );

					if ( $license ) {
						delete_site_option( 'wc_am_client_consent_magic_pro_activated' );
						delete_site_option( 'wc_am_client_consent_magic_pro_instance' );
						delete_site_option( 'wc_am_client_consent_magic_pro' );
						delete_site_option( 'wc_am_client_consent_magic_pro_deactivate_checkbox' );
						delete_site_option( 'wc_am_product_id_' . CMPRO_LICENSE_PLUGIN_NAME );
						delete_site_option( 'edd_license_key' );
						delete_site_option( 'edd_consent_magic_pro' );
						delete_site_option( 'edd_consent_magic_pro_activated' );
						delete_site_option( 'edd_consent_magic_pro_deactivate_checkbox' );
					}
				}

				switch_to_blog( $original_blog_id );
			}

			$args = array();
			$args[ 'posts_per_page' ] = -1;
			$args[ 'numberposts' ] = -1;

			// Remove custom meta:
			$args [ 'post_type' ] = CMPRO_POST_TYPE;
			$posts = get_posts( $args );
			if ( $posts ) {
				foreach ( $posts as $post ) {
					wp_delete_post( $post->ID, true );
				}
			}

			// Remove custom meta:
			$args [ 'post_type' ] = CMPRO_TEMPLATE_POST_TYPE;
			$posts = get_posts( $args );
			if ( $posts ) {
				foreach ( $posts as $post ) {
					wp_delete_post( $post->ID, true );
				}
			}

			// Remove custom meta:
			$args [ 'post_type' ] = CMPRO_POST_TYPE_COOKIES;
			$posts = get_posts( $args );
			if ( $posts ) {
				foreach ( $posts as $post ) {
					if ( !is_multisite() ) {
						delete_option( 'cs_' . $post->ID . '_cookie_cat' );
					} else {
						delete_site_option( 'cs_' . $post->ID . '_cookie_cat' );
					}
					wp_delete_post( $post->ID, true );
				}
			}

			// Remove custom meta:
			$args [ 'post_type' ] = CMPRO_POST_TYPE_SCRIPTS;
			$posts = get_posts( $args );
			if ( $posts ) {
				foreach ( $posts as $post ) {
					wp_delete_post( $post->ID, true );
				}
			}

			// Remove script categories
			$args = array(
				'taxonomy'   => 'cs-cookies-category',
				'hide_empty' => false,
			);
			$categories = get_terms( $args );
			if ( $categories ) {
				foreach ( $categories as $category ) {
					if ( !is_multisite() ) {
						delete_option( 'cs_' . $category->name . '_' . $category->term_id . '_script_enable' );
						delete_option( 'cs_' . $category->term_id . '_script_cat' );
						delete_option( $category->term_id . '_cat_id' );
					} else {
						delete_site_option( 'cs_' . $category->name . '_' . $category->term_id . '_script_enable' );
						delete_site_option( 'cs_' . $category->term_id . '_script_cat' );
						delete_site_option( $category->term_id . '_cat_id' );
					}
					wp_delete_term( $category->term_id, 'cs-cookies-category' );
				}
			}

			//remove old statictics table ========================
			$table_name_old_statistics = $wpdb->prefix . 'cs_statistics_consent';
			$sql = $wpdb->prepare( 'DROP TABLE IF EXISTS %1$s;', $table_name_old_statistics );
			$wpdb->query( $sql );

			//remove statictics table ========================
			$table_cs_stats_consent = $wpdb->prefix . 'cs_stats_consent';
			$sql = $wpdb->prepare( 'DROP TABLE IF EXISTS %1$s;', $table_cs_stats_consent );
			$wpdb->query( $sql );

			//remove cs_proof_consent table ========================
			$table_cs_proof_consent = $wpdb->prefix . 'cs_proof_consent';
			$sql = $wpdb->prepare( 'DROP TABLE IF EXISTS %1$s;', $table_cs_proof_consent );
			$wpdb->query( $sql );

			//remove cs_scan_cookies table ========================
			$table_cookies = $wpdb->prefix . 'cs_scan_cookies';
			$sql = $wpdb->prepare( 'DROP TABLE IF EXISTS %1$s;', $table_cookies );
			$wpdb->query( $sql );

			//remove cs_scan table ========================
			$table_cookies = $wpdb->prefix . 'cs_scan';
			$sql = $wpdb->prepare( 'DROP TABLE IF EXISTS %1$s;', $table_cookies );
			$wpdb->query( $sql );

			//remove cs_scan_scripts table ========================
			$table_cookies = $wpdb->prefix . 'cs_scan_scripts';
			$sql = $wpdb->prepare( 'DROP TABLE IF EXISTS %1$s;', $table_cookies );
			$wpdb->query( $sql );

			//remove cs_unblock_ip table ========================
			$table_cookies = $wpdb->prefix . 'cs_unblock_ip';
			$sql = $wpdb->prepare( 'DROP TABLE IF EXISTS %1$s;', $table_cookies );
			$wpdb->query( $sql );
		}

		db_cron_deactivate();
	}

}
