<?php

namespace ConsentMagicPro;

// If this file is called directly, abort.
if ( !defined( 'WPINC' ) ) {
	die;
}

function render_notice_message( $message, $font_weight = 600 ) {
	switch ( $font_weight ) {
		case 600:
			$class = 'fw-600';
			break;
		case 500:
			$class = 'fw-500';
			break;
		default:
			$class = 'fw-400';
			break;
	}
	?>

    <div class="notice-message">
        <div class="notice-icon"><i class="icon-info"></i></div>
        <p class="message-content <?php echo esc_attr( $class ); ?>"> <?php echo wp_kses_post( $message ); ?></p>
    </div>

	<?php
}

function render_warning_message( $message ) {
	?>
    <div class="cm-message warning-message">
        <div class="notice-icon">
            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g id="Alert Circle">
                    <path id="Glyph"
                          d="M10.0003 1.6665C7.75033 1.6665 5.66699 2.58317 4.08366 4.1665C2.50033 5.74984 1.66699 7.9165 1.66699 10.1665C1.66699 14.6665 5.33366 18.3332 9.83366 18.3332H10.0003C14.6662 18.2498 18.3337 14.4998 18.3337 9.83317C18.3337 5.33317 14.6662 1.6665 10.167 1.6665H10.0003ZM9.33366 6.31659C9.33366 5.89992 9.66699 5.64992 10.0003 5.64992C10.417 5.64992 10.667 5.98325 10.667 6.31659V10.4833C10.667 10.8999 10.3337 11.1499 10.0003 11.1499C9.58366 11.1499 9.33366 10.8999 9.33366 10.4833V6.31659ZM10.0002 14.3583C9.40185 14.3583 8.91682 13.8733 8.91682 13.275C8.91682 12.6767 9.40185 12.1917 10.0002 12.1917C10.5985 12.1917 11.0835 12.6767 11.0835 13.275C11.0835 13.8733 10.5985 14.3583 10.0002 14.3583Z"
                          fill="#DF7B00"/>
                </g>
            </svg>
        </div>
        <p class="message-content fw-700"> <?php echo wp_kses_post( $message ); ?></p>
    </div>
	<?php
}

function render_warning_info_message( $message ) {
	?>
    <div class="cm-info-message warning-info-message">
        <div class="warning-info-icon">
            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M9.99997 6.75C10.4142 6.75 10.75 7.08579 10.75 7.5V11C10.75 11.4142 10.4142 11.75 9.99997 11.75C9.58576 11.75 9.24997 11.4142 9.24997 11V7.5C9.24997 7.08579 9.58576 6.75 9.99997 6.75Z"/>
                <path d="M11 13.5C11 14.0523 10.5523 14.5 10 14.5C9.44775 14.5 9.00003 14.0523 9.00003 13.5C9.00003 12.9477 9.44775 12.5 10 12.5C10.5523 12.5 11 12.9477 11 13.5Z"/>
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M10.0001 3.5C8.95474 3.5 8.21619 4.20232 7.84765 4.94672C7.65568 5.33448 6.75987 7.0441 5.84308 8.79353L5.81534 8.84646C4.92293 10.5493 4.01717 12.2777 3.80719 12.702C3.43513 13.4537 3.32934 14.4519 3.89956 15.316C4.46914 16.1791 5.44225 16.5 6.3636 16.5L13.6364 16.5C14.5577 16.5 15.5309 16.1791 16.1005 15.316C16.6707 14.4519 16.5649 13.4537 16.1928 12.702C15.9832 12.2784 15.08 10.555 14.189 8.85476L14.1569 8.79352C13.24 7.044 12.3443 5.33454 12.1525 4.94693C11.784 4.20242 11.0455 3.5 10.0001 3.5ZM9.19193 5.61225C9.59608 4.79592 10.4041 4.79592 10.8081 5.61225C11.0102 6.02061 11.9201 7.75686 12.8297 9.49243C13.7383 11.2262 14.6466 12.9594 14.8485 13.3673C15.2525 14.1837 14.8485 15 13.6364 15L6.3636 15C5.15153 15 4.74749 14.1837 5.15153 13.3673C5.35379 12.9587 6.26471 11.2205 7.17483 9.4838C8.08286 7.75111 8.99008 6.01994 9.19193 5.61225Z"/>
            </svg>
        </div>
        <p class="message-content"> <?php echo wp_kses_post( $message ); ?></p>
    </div>
	<?php
}

function render_info_message( $message ) {
	?>
    <div class="cm-info-message info-message">
        <div class="info-icon">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                <path d="M9.99998 14C9.58577 14 9.24999 13.6642 9.25 13.25L9.25006 9.74999C9.25007 9.33577 9.58586 8.99999 10.0001 9C10.4143 9.00001 10.7501 9.3358 10.7501 9.75001L10.75 13.25C10.75 13.6642 10.4142 14 9.99998 14Z"
                      fill="#00527C"/>
                <path d="M9 7C9 6.44772 9.44772 6 10 6C10.5523 6 11 6.44772 11 7C11 7.55228 10.5523 8 10 8C9.44772 8 9 7.55228 9 7Z"
                      fill="#00527C"/>
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M17 10C17 13.866 13.866 17 10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10ZM15.5 10C15.5 13.0376 13.0376 15.5 10 15.5C6.96243 15.5 4.5 13.0376 4.5 10C4.5 6.96243 6.96243 4.5 10 4.5C13.0376 4.5 15.5 6.96243 15.5 10Z"
                      fill="#00527C"/>
            </svg>
        </div>
        <p class="message-content"> <?php echo wp_kses_post( $message ); ?></p>
    </div>
	<?php
}

function render_info_message_type2( $message ) {
	?>
    <div class="cm-info-message info-message-type2">
        <div class="info-icon">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                <path d="M9.99998 14C9.58577 14 9.24999 13.6642 9.25 13.25L9.25006 9.74999C9.25007 9.33577 9.58586 8.99999 10.0001 9C10.4143 9.00001 10.7501 9.3358 10.7501 9.75001L10.75 13.25C10.75 13.6642 10.4142 14 9.99998 14Z"
                      fill="#00527C"/>
                <path d="M9 7C9 6.44772 9.44772 6 10 6C10.5523 6 11 6.44772 11 7C11 7.55228 10.5523 8 10 8C9.44772 8 9 7.55228 9 7Z"
                      fill="#00527C"/>
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M17 10C17 13.866 13.866 17 10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10ZM15.5 10C15.5 13.0376 13.0376 15.5 10 15.5C6.96243 15.5 4.5 13.0376 4.5 10C4.5 6.96243 6.96243 4.5 10 4.5C13.0376 4.5 15.5 6.96243 15.5 10Z"
                      fill="#00527C"/>
            </svg>
        </div>
        <p class="message-content"> <?php echo wp_kses_post( $message ); ?></p>
    </div>
	<?php
}

function render_critical_message( $message ) {
	?>
    <div class="cm-message critical-message">
        <div class="notice-icon">
            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g id="Alert Octagon">
                    <path id="Glyph"
                          d="M13.4521 1.66675H6.54855L1.66699 6.5483V13.4519L6.54855 18.3334H13.4521L18.3337 13.4519V6.5483L13.4521 1.66675ZM10.0005 5.65008C10.4172 5.65008 10.6672 5.98341 10.6672 6.31674V10.4834C10.6672 10.9001 10.3338 11.1501 10.0005 11.1501C9.58384 11.1501 9.33384 10.9001 9.33384 10.4834V6.31674C9.33384 5.90008 9.66717 5.65008 10.0005 5.65008ZM11.0837 13.2752C11.0837 13.8735 10.5986 14.3585 10.0003 14.3585C9.40203 14.3585 8.917 13.8735 8.917 13.2752C8.917 12.6769 9.40203 12.1918 10.0003 12.1918C10.5986 12.1918 11.0837 12.6769 11.0837 13.2752Z"
                          fill="#D21C1C"/>
                </g>
            </svg>
        </div>
        <p class="message-content fw-700"> <?php echo wp_kses_post( $message ); ?></p>
    </div>
	<?php
}

function render_success_message( $message ) {
	?>
    <div class="cm-message success-message">
        <div class="notice-icon">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                <path d="M7.03713 10.5556C6.75121 10.2559 6.27647 10.2447 5.97676 10.5306C5.67706 10.8165 5.66588 11.2913 5.9518 11.591L8.09561 13.8783C8.40217 14.1997 8.91925 14.1857 9.20805 13.8483L13.8673 7.9845C14.1367 7.66983 14.0999 7.19638 13.7853 6.92702C13.4706 6.65767 12.9971 6.69441 12.7278 7.00908L8.8488 11.9368C8.73494 12.0814 8.52536 12.1064 8.38071 11.9925C8.36725 11.9819 8.35462 11.9703 8.34295 11.9578L7.03713 10.5556ZM1.66602 9.99935C1.66602 5.41602 5.41602 1.66602 9.99935 1.66602C14.5827 1.66602 18.3327 5.41602 18.3327 9.99935C18.3327 14.5827 14.5827 18.3327 9.99935 18.3327C5.41602 18.3327 1.66602 14.5827 1.66602 9.99935Z"
                      fill="#28A138"/>
            </svg>

        </div>
        <p class="message-content fw-700"> <?php echo wp_kses_post( $message ); ?></p>
    </div>
	<?php
}