<?php

namespace ConsentMagicPro;

// If this file is called directly, abort.
if ( !defined( 'WPINC' ) ) {
	die;
}

function get_cm_settings_keys( $parts ) {

	$settings_keys = array(
		'general_settings' => array(
			'cm_options' => array(
				//settings page
				'cs_test_mode'                              => '',
				'cs_deactivation_db_clear'                  => '',
				'cs_store_consent_for_wc_orders'            => '',
				'cs_admin_email_consent_for_wc_orders'      => '',
				'cs_customer_email_consent_for_wc_orders'   => '',
				'cs_customer_email_consent_type_lang'       => '',
				'cs_customer_email_rule_name_lang'          => '',
				'cs_customer_email_consent_expressed_lang'  => '',
				'cs_store_consent_for_edd_orders'           => '',
				'cs_consent_for_pys'                        => '',
				'cs_track_before_consent_expressed_for_pys' => '',
				'cs_fb_woo_capi_enabled'                    => '',
				'cs_block_video_personal_data'              => '',
				'cs_enable_translations'                    => '',
				'cs_enable_site_cache'                      => '',
				'cs_expire_days'                            => '',
				'cs_scanner_module'                         => '',
				'cs_default_close_on_scroll'                => '',
				'cs_bar_verified_link'                      => '',
				'cs_options_verified_link'                  => '',
				'cs_options_single_verified_link'           => '',
				'cs_send_important'                         => '',
				'cs_disable_for_knonw_crawlers'             => '',
				'cs_ignore_users_ip'                        => '',
				'cs_cross_domain_tracking'                  => '',
				'cs_cross_domain_tracking_domain'           => '',
				'cs_user_default_language'                  => '',
				'cs_language_availability'                  => '',

				//proof consent
				'cs_proof_consent_enable'                   => '',
				'cs_proof_just_inform'                      => '',
				'cs_proof_inform_and_optout'                => '',
				'cs_proof_ask_before_tracking'              => '',
				'cs_proof_iab'                              => '',
				'cs_stored_consent_for'                     => '',
				'cs_proof_auto_delete'                      => '',
				'cs_proof_entries_count'                    => '',
				'cs_email_before_delete_consent'            => '',
				'cs_send_proof_deleting_email'              => '',

				//other settings
				'cs_hide_shortcode_cm_options'              => '',
				'cs_plugin_activation'                      => '',
				'cs_script_blocking_enabled'                => '',
				'cs_free'                                   => '',
				'cs_auto_scan_type'                         => '',
				'cs_scan_url_per_request'                   => '',
				'cs_auto_scan_interval'                     => '',
				'cs_auto_scan_email_enabled'                => '',
				'cs_auto_scan_email'                        => '',
				'cs_admin_email_privacy_title'              => '',
			),

			'wp_options' => array(
				'cs_admin_ignore_users'    => '',
				'cs_admin_permissions'     => '',
				'cs_send_important_emails' => '',
				'cs_autodetect_email'      => '',
			),
		),

		'script_types' => array(
			'cm_options'   => array(
				'default_font'                            => '',
				'cs_not_block_unassigned_cookies'         => '',
				'cs_advanced_matching_consent_enabled'    => '',
				'cs_server_side_consent_enabled'          => '',
				'cs_advanced_matching_description_lang'   => '',
				'cs_server_side_consent_description_lang' => '',
			),
			'script_types' => array(
				'cs_primary_term'              => '',
				'cs_necessary_term'            => '',
				'cs_ignore_this_category'      => '',
				'cs_edit_cat_description_lang' => '',
				'_cs_iab_cat'                  => '',
			)
		),

		'design_settings' => array(
			'design' => array(
				'design_templates' => array(
					'cs_backend_color'                    => '',
					'cs_border_style'                     => '',
					'cs_border_weight'                    => '',
					'cs_border_color'                     => '',
					'cs_text_color'                       => '',
					'cs_links_color'                      => '',
					'cs_titles_text_color'                => '',
					'cs_subtitles_text_color'             => '',
					'cs_accept_all_buttons_bg'            => '',
					'cs_accept_all_buttons_text_color'    => '',
					'cs_custom_button_buttons_bg'         => '',
					'cs_custom_button_buttons_text_color' => '',
					'cs_deny_all_buttons_bg'              => '',
					'cs_deny_all_buttons_text_color'      => '',
					'cs_options_buttons_bg'               => '',
					'cs_options_buttons_text_color'       => '',
					'cs_confirm_buttons_bg'               => '',
					'cs_confirm_buttons_text_color'       => '',
					'cs_sticky_bg'                        => '',
					'cs_sticky_link_color'                => '',
					'cs_logo'                             => '',
					'cs_logo_size'                        => '',
					'cs_position_vertical_list'           => '',
					'cs_position_horizontal_list'         => '',
					'cs_cat_color'                        => '',
					'cs_active_toggle_color'              => '',
					'cs_active_toggle_text_color'         => '',
					'cs_text_block_bg'                    => '',
					'cs_shortcodes_text_color'            => '',
					'cs_main_template'                    => '',
				),
				'adjust_sizes'     => array(
					'cs_d_sb_min_height'                      => '',
					'cs_d_sb_padding_top'                     => '',
					'cs_d_sb_padding_bottom'                  => '',
					'cs_d_sb_padding_left'                    => '',
					'cs_d_sb_padding_right'                   => '',
					'cs_d_sb_font_size'                       => '',
					'cs_d_sb_font_weight'                     => '',
					'cs_d_sb_btn_pd_t'                        => '',
					'cs_d_sb_btn_pd_bt'                       => '',
					'cs_d_sb_btn_pd_r'                        => '',
					'cs_d_sb_btn_pd_l'                        => '',
					'cs_d_sb_btn_mg_t'                        => '',
					'cs_d_sb_btn_mg_bt'                       => '',
					'cs_d_sb_btn_mg_r'                        => '',
					'cs_d_sb_btn_mg_l'                        => '',
					'cs_d_sb_btn_font_size'                   => '',
					'cs_d_sb_btn_font_weight'                 => '',
					'cs_d_lb_min_height'                      => '',
					'cs_d_lb_padding_top'                     => '',
					'cs_d_lb_padding_bottom'                  => '',
					'cs_d_lb_padding_left'                    => '',
					'cs_d_lb_padding_right'                   => '',
					'cs_d_lb_font_size'                       => '',
					'cs_d_lb_font_weight'                     => '',
					'cs_d_lb_btn_pd_t'                        => '',
					'cs_d_lb_btn_pd_bt'                       => '',
					'cs_d_lb_btn_pd_r'                        => '',
					'cs_d_lb_btn_pd_l'                        => '',
					'cs_d_lb_btn_mg_t'                        => '',
					'cs_d_lb_btn_mg_bt'                       => '',
					'cs_d_lb_btn_mg_l'                        => '',
					'cs_d_lb_btn_mg_r'                        => '',
					'cs_d_lb_btn_font_size'                   => '',
					'cs_d_lb_btn_font_weight'                 => '',
					'cs_d_sp_min_height'                      => '',
					'cs_d_sp_padding_top'                     => '',
					'cs_d_sp_padding_bottom'                  => '',
					'cs_d_sp_padding_left'                    => '',
					'cs_d_sp_padding_right'                   => '',
					'cs_d_sp_font_size'                       => '',
					'cs_d_sp_font_weight'                     => '',
					'cs_d_sp_btn_pd_t'                        => '',
					'cs_d_sp_btn_pd_bt'                       => '',
					'cs_d_sp_btn_pd_r'                        => '',
					'cs_d_sp_btn_pd_l'                        => '',
					'cs_d_sp_btn_mg_t'                        => '',
					'cs_d_sp_btn_mg_bt'                       => '',
					'cs_d_sp_btn_mg_r'                        => '',
					'cs_d_sp_btn_mg_l'                        => '',
					'cs_d_sp_btn_font_size'                   => '',
					'cs_d_sp_btn_font_weight'                 => '',
					'cs_d_lp_min_height'                      => '',
					'cs_d_lp_padding_top'                     => '',
					'cs_d_lp_padding_bottom'                  => '',
					'cs_d_lp_padding_left'                    => '',
					'cs_d_lp_padding_right'                   => '',
					'cs_d_lp_font_size'                       => '',
					'cs_d_lp_font_weight'                     => '',
					'cs_d_lp_btn_pd_t'                        => '',
					'cs_d_lp_btn_pd_bt'                       => '',
					'cs_d_lp_btn_pd_r'                        => '',
					'cs_d_lp_btn_pd_l'                        => '',
					'cs_d_lp_btn_mg_t'                        => '',
					'cs_d_lp_btn_mg_bt'                       => '',
					'cs_d_lp_btn_mg_l'                        => '',
					'cs_d_lp_btn_mg_r'                        => '',
					'cs_d_lp_btn_font_size'                   => '',
					'cs_d_lp_btn_font_weight'                 => '',
					'cs_d_op_min_height'                      => '',
					'cs_d_op_padding_top'                     => '',
					'cs_d_op_padding_bottom'                  => '',
					'cs_d_op_padding_left'                    => '',
					'cs_d_op_padding_right'                   => '',
					'cs_d_op_font_size'                       => '',
					'cs_d_op_font_weight'                     => '',
					'cs_d_op_btn_pd_t'                        => '',
					'cs_d_op_btn_pd_bt'                       => '',
					'cs_d_op_btn_pd_r'                        => '',
					'cs_d_op_btn_pd_l'                        => '',
					'cs_d_op_btn_mg_t'                        => '',
					'cs_d_op_btn_mg_bt'                       => '',
					'cs_d_op_btn_mg_r'                        => '',
					'cs_d_op_btn_mg_l'                        => '',
					'cs_d_op_btn_font_size'                   => '',
					'cs_d_op_btn_font_weight'                 => '',
					'cs_d_op_titles_font_size'                => '',
					'cs_d_op_titles_font_weight'              => '',
					'cs_d_op_subtitles_font_size'             => '',
					'cs_d_op_subtitles_font_weight'           => '',
					'cs_d_stp_min_height'                     => '',
					'cs_d_stp_padding_top'                    => '',
					'cs_d_stp_padding_bottom'                 => '',
					'cs_d_stp_padding_left'                   => '',
					'cs_d_stp_padding_right'                  => '',
					'cs_d_stp_font_size'                      => '',
					'cs_d_stp_font_weight'                    => '',
					'cs_d_stp_desktop_position'               => '',
					'cs_d_stp_sticky_position_vertical'       => '',

					//single design
					'cs_d_single_op_padding_top'              => '',
					'cs_d_single_op_padding_bottom'           => '',
					'cs_d_single_op_padding_left'             => '',
					'cs_d_single_op_padding_right'            => '',
					'cs_d_single_op_font_size'                => '',
					'cs_d_single_op_font_weight'              => '',
					'cs_d_single_op_second_font_size'         => '',
					'cs_d_single_op_second_font_weight'       => '',
					'cs_d_single_op_titles_font_size'         => '',
					'cs_d_single_op_titles_font_weight'       => '',
					'cs_d_single_op_subtitles_font_size'      => '',
					'cs_d_single_op_subtitles_font_weight'    => '',
					'cs_d_single_op_subsubtitles_font_size'   => '',
					'cs_d_single_op_subsubtitles_font_weight' => '',
					'cs_d_single_op_btn_pd_t'                 => '',
					'cs_d_single_op_btn_pd_b'                 => '',
					'cs_d_single_op_btn_pd_r'                 => '',
					'cs_d_single_op_btn_pd_l'                 => '',
					'cs_d_single_op_btn_mg_t'                 => '',
					'cs_d_single_op_btn_mg_b'                 => '',
					'cs_d_single_op_btn_mg_r'                 => '',
					'cs_d_single_op_btn_mg_l'                 => '',
					'cs_d_single_op_btn_font_size'            => '',
					'cs_d_single_op_btn_font_weight'          => '',

					'cs_d_single_stp_min_height'               => '',
					'cs_d_single_stp_padding_top'              => '',
					'cs_d_single_stp_padding_bottom'           => '',
					'cs_d_single_stp_padding_left'             => '',
					'cs_d_single_stp_padding_right'            => '',
					'cs_d_single_stp_font_size'                => '',
					'cs_d_single_stp_font_weight'              => '',
					'cs_d_single_stp_desktop_position'         => '',
					'cs_d_single_stp_sticky_position_vertical' => ''
				)
			),
		),

		'geolocation_settings' => array(
			'cm_options' => array(
				'cs_geo_licence_key'        => '',
				'cs_geo_licence_account_id' => '',
				'cs_geolocation'            => '',
				'cs_geo_activated'          => '',
				'cs_often_update'           => '',
			),
		),

		'predefined_scripts' => array(
			'cm_options' => array(
				'cs_block_pre_defined_scripts'              => '',
				'cs_block_ad_storage_scripts_cat'           => '',
				'cs_block_ad_storage_scripts'               => '',
				'cs_block_ad_storage_scripts_descr'         => '',
				'cs_block_analytics_storage_scripts_cat'    => '',
				'cs_block_analytics_storage_scripts'        => '',
				'cs_block_analytics_storage_scripts_descr'  => '',
				'cs_block_ad_user_data_scripts'             => '',
				'cs_block_ad_user_data_scripts_cat'         => '',
				'cs_block_ad_user_data_scripts_descr'       => '',
				'cs_block_ad_personalization_scripts'       => '',
				'cs_block_ad_personalization_scripts_cat'   => '',
				'cs_block_ad_personalization_scripts_descr' => '',
				'cs_block_url_passthrough_scripts'          => '',
				'cs_block_url_passthrough_scripts_cat'      => '',
				'cs_block_url_passthrough_scripts_descr'    => '',
				'cs_block_google_analytics_scripts'         => '',
				'cs_block_google_analytics_scripts_cat'     => '',
				'cs_block_google_analytics_scripts_descr'   => '',
				'cs_block_google_ads_tag_scripts'           => '',
				'cs_block_google_ads_tag_scripts_cat'       => '',
				'cs_block_google_ads_tag_scripts_descr'     => '',
				'cs_block_google_adsense_scripts'           => '',
				'cs_block_google_adsense_scripts_cat'       => '',
				'cs_block_google_adsense_scripts_descr'     => '',
				'cs_block_google_maps_scripts'              => '',
				'cs_block_google_maps_scripts_cat'          => '',
				'cs_block_google_maps_scripts_descr'        => '',
				'cs_block_googlefonts_scripts'              => '',
				'cs_block_googlefonts_scripts_cat'          => '',
				'cs_block_googlefonts_scripts_descr'        => '',
				'cs_block_fb_pixel_scripts'                 => '',
				'cs_block_fb_pixel_scripts_cat'             => '',
				'cs_block_fb_pixel_scripts_descr'           => '',
				'cs_block_tiktok_scripts'                   => '',
				'cs_block_tiktok_scripts_cat'               => '',
				'cs_block_tiktok_scripts_descr'             => '',
				'cs_block_twitter_scripts'                  => '',
				'cs_block_twitter_scripts_cat'              => '',
				'cs_block_twitter_scripts_descr'            => '',
				'cs_block_tw_tag_scripts'                   => '',
				'cs_block_tw_tag_scripts_cat'               => '',
				'cs_block_tw_tag_scripts_descr'             => '',
				'cs_block_big_tag_scripts'                  => '',
				'cs_block_big_tag_scripts_cat'              => '',
				'cs_block_big_tag_scripts_descr'            => '',
				'cs_block_pin_tag_scripts'                  => '',
				'cs_block_pin_tag_scripts_cat'              => '',
				'cs_block_pin_tag_scripts_descr'            => '',
				'cs_block_ln_tag_scripts'                   => '',
				'cs_block_ln_tag_scripts_cat'               => '',
				'cs_block_ln_tag_scripts_descr'             => '',
				'cs_block_instagram_scripts'                => '',
				'cs_block_instagram_scripts_cat'            => '',
				'cs_block_instagram_scripts_descr'          => '',
				'cs_block_yt_embedded_scripts'              => '',
				'cs_block_yt_embedded_scripts_cat'          => '',
				'cs_block_yt_embedded_scripts_descr'        => '',
				'cs_block_vimeo_embedded_scripts'           => '',
				'cs_block_vimeo_embedded_scripts_cat'       => '',
				'cs_block_vimeo_embedded_scripts_descr'     => '',
				'cs_block_soundcloud_scripts'               => '',
				'cs_block_soundcloud_scripts_cat'           => '',
				'cs_block_soundcloud_scripts_descr'         => '',
				'cs_block_slideshare_scripts'               => '',
				'cs_block_slideshare_scripts_cat'           => '',
				'cs_block_slideshare_scripts_descr'         => '',
				'cs_block_hubspot_scripts'                  => '',
				'cs_block_hubspot_scripts_cat'              => '',
				'cs_block_hubspot_scripts_descr'            => '',
				'cs_block_matomo_scripts'                   => '',
				'cs_block_matomo_scripts_cat'               => '',
				'cs_block_matomo_scripts_descr'             => '',
				'cs_block_addthis_scripts'                  => '',
				'cs_block_addthis_scripts_cat'              => '',
				'cs_block_addthis_scripts_descr'            => '',
				'cs_block_sharethis_scripts'                => '',
				'cs_block_sharethis_scripts_cat'            => '',
				'cs_block_sharethis_scripts_descr'          => '',
				'cs_block_hotjar_scripts'                   => '',
				'cs_block_hotjar_scripts_cat'               => '',
				'cs_block_hotjar_scripts_descr'             => '',
				'cs_block_pys_scripts'                      => '',
				'cs_block_pys_scripts_cat'                  => '',
				'cs_block_pys_scripts_descr'                => '',
				'cs_block_google_captcha_scripts'           => '',
				'cs_block_google_captcha_scripts_cat'       => '',
				'cs_block_google_captcha_scripts_descr'     => ''
			),
		),

		'custom_scripts' => array(
			'cm_options'     => array(
				'cs_block_manually_added_cookies' => '',
			),
			'custom_scripts' => array(
				'cs_default_script_js_heedle' => '',
				'cs_default_script_desc'      => '',
			),
		),

		'text' => array(
			'cm_options' => array(
				'cs_text_in_small_bar_popup_lang'                 => '',
				'cs_text_in_large_bar_popup_lang'                 => '',
				'cs_btn_text_allow_all_lang'                      => '',
				'cs_btn_text_disable_all_lang'                    => '',
				'cs_btn_text_customize_lang'                      => '',
				'cs_btn_text_privacy_cookie_lang'                 => '',
				'cs_btn_text_sticky_cookie_lang'                  => '',
				'cs_btn_text_custom_button_lang'                  => '',
				'cs_text_in_options_popup_lang'                   => '',
				'cs_consent_lang'                                 => '',
				'cs_text_consent_lang'                            => '',
				'cs_title_in_options_popup_lang'                  => '',
				'cs_subtitle_in_options_popup_lang'               => '',
				'cs_btn_text_allow_all_in_options_popup_lang'     => '',
				'cs_btn_text_disable_all_in_options_popup_lang'   => '',
				'cs_btn_text_confirm_in_options_popup_lang'       => '',
				'cs_always_on_in_options_popup_lang'              => '',
				'cs_video_consent_general_text_lang'              => '',
				'cs_video_consent_rule_text_lang'                 => '',
				'cs_text_in_single_design_lang'                   => '',
				'cs_title_in_single_design_lang'                  => '',
				'cs_subtitle_in_single_design_lang'               => '',
				'cs_btn_text_allow_all_in_single_design_lang'     => '',
				'cs_btn_text_disable_all_in_single_design_lang'   => '',
				'cs_btn_text_confirm_in_single_design_lang'       => '',
				'cs_always_on_in_single_design_lang'              => '',
				'cs_btn_text_custom_button_in_single_design_lang' => '',
			)
		),

		'default_rules' => array(
			'rules' => array(
				'default' => array(
					'_cs_type'                                         => '',
					'_cs_sticky'                                       => '',
					'_cs_smart_sticky'                                 => '',
					'_cs_smart_sticky_'                                => '',
					'_cs_smart_sticky_mobile'                          => '',
					'_cs_smart_sticky_mobile_'                         => '',
					'_cs_mobile_side_sticky'                           => '',
					'_cs_custom_button'                                => '',
					'_cs_custom_button_'                               => '',
					'_cs_bars_position'                                => '',
					'_cs_bars_type'                                    => '',
					'_cs_top_push'                                     => '',
					'_cs_privacy_link'                                 => '',
					'_cs_close_on_scroll'                              => '',
					'_cs_theme'                                        => '',
					'_cs_deny_all_btn'                                 => '',
					'_cs_hide_close_btn'                               => '',
					'_cs_deny_consent_for_close'                       => '',
					'_cs_predefined_rule'                              => '',
					'_cs_target'                                       => '',
					'_cs_us_states_target'                             => '',
					'_cs_use_meta_ldu'                                 => '',
					'_cs_google_consent_mode'                          => '',
					'_cs_bing_consent_mode'                            => '',
					'_cs_custom_text'                                  => '',
					'_cs_text_in_small_bar_popup_lang'                 => '',
					'_cs_text_in_large_bar_popup_lang'                 => '',
					'_cs_btn_text_allow_all_lang'                      => '',
					'_cs_btn_text_customize_lang'                      => '',
					'_cs_btn_text_privacy_cookie_lang'                 => '',
					'_cs_btn_text_sticky_cookie_lang'                  => '',
					'_cs_btn_text_custom_button_lang'                  => '',
					'_cs_title_in_options_popup_lang'                  => '',
					'_cs_subtitle_in_options_popup_lang'               => '',
					'_cs_btn_text_allow_all_in_options_popup_lang'     => '',
					'_cs_btn_text_disable_all_lang'                    => '',
					'_cs_text_in_options_popup_lang'                   => '',
					'_cs_btn_text_disable_all_in_options_popup_lang'   => '',
					'_cs_btn_text_confirm_in_options_popup_lang'       => '',
					'_cs_always_on_in_options_popup_lang'              => '',
					'_cs_order'                                        => '',
					'_cs_enable_rule'                                  => '',
					'_cs_no_ip_rule'                                   => '',
					'_cs_track_analytics'                              => '',
					'_cs_block_content'                                => '',
					'_cs_refresh_after_consent'                        => '',
					'_excluded_from_consent_storing'                   => '',
					'_cs_showing_rule_until_express_consent'           => '',
					'_cs_design_type'                                  => '',
					'_cs_native_scripts'                               => '',
					'_cs_text_in_single_design_lang'                   => '',
					'_cs_title_in_single_design_lang'                  => '',
					'_cs_subtitle_in_single_design_lang'               => '',
					'_cs_btn_text_allow_all_in_single_design_lang'     => '',
					'_cs_btn_text_disable_all_in_single_design_lang'   => '',
					'_cs_btn_text_confirm_in_single_design_lang'       => '',
					'_cs_always_on_in_single_design_lang'              => '',
					'_cs_btn_text_custom_button_in_single_design_lang' => '',
				),
			),
		),

		'custom_rules' => array(
			'rules' => array(
				'custom' => array(
					'_cs_type'                                         => '',
					'_cs_sticky'                                       => '',
					'_cs_smart_sticky'                                 => '',
					'_cs_smart_sticky_'                                => '',
					'_cs_smart_sticky_mobile'                          => '',
					'_cs_smart_sticky_mobile_'                         => '',
					'_cs_mobile_side_sticky'                           => '',
					'_cs_custom_button'                                => '',
					'_cs_custom_button_'                               => '',
					'_cs_bars_position'                                => '',
					'_cs_bars_type'                                    => '',
					'_cs_top_push'                                     => '',
					'_cs_privacy_link'                                 => '',
					'_cs_close_on_scroll'                              => '',
					'_cs_theme'                                        => '',
					'_cs_deny_all_btn'                                 => '',
					'_cs_hide_close_btn'                               => '',
					'_cs_deny_consent_for_close'                       => '',
					'_cs_predefined_rule'                              => '',
					'_cs_target'                                       => '',
					'_cs_us_states_target'                             => '',
					'_cs_use_meta_ldu'                                 => '',
					'_cs_google_consent_mode'                          => '',
					'_cs_bing_consent_mode'                            => '',
					'_cs_custom_text'                                  => '',
					'_cs_text_in_small_bar_popup_lang'                 => '',
					'_cs_text_in_large_bar_popup_lang'                 => '',
					'_cs_btn_text_allow_all_lang'                      => '',
					'_cs_btn_text_customize_lang'                      => '',
					'_cs_btn_text_privacy_cookie_lang'                 => '',
					'_cs_btn_text_sticky_cookie_lang'                  => '',
					'_cs_btn_text_custom_button_lang'                  => '',
					'_cs_title_in_options_popup_lang'                  => '',
					'_cs_subtitle_in_options_popup_lang'               => '',
					'_cs_btn_text_allow_all_in_options_popup_lang'     => '',
					'_cs_btn_text_disable_all_lang'                    => '',
					'_cs_text_in_options_popup_lang'                   => '',
					'_cs_btn_text_disable_all_in_options_popup_lang'   => '',
					'_cs_btn_text_confirm_in_options_popup_lang'       => '',
					'_cs_always_on_in_options_popup_lang'              => '',
					'_cs_order'                                        => '',
					'_cs_enable_rule'                                  => '',
					'_cs_no_ip_rule'                                   => '',
					'_cs_track_analytics'                              => '',
					'_cs_block_content'                                => '',
					'_cs_refresh_after_consent'                        => '',
					'_excluded_from_consent_storing'                   => '',
					'_cs_showing_rule_until_express_consent'           => '',
					'_cs_design_type'                                  => '',
					'_cs_native_scripts'                               => '',
					'_cs_text_in_single_design_lang'                   => '',
					'_cs_title_in_single_design_lang'                  => '',
					'_cs_subtitle_in_single_design_lang'               => '',
					'_cs_btn_text_allow_all_in_single_design_lang'     => '',
					'_cs_btn_text_disable_all_in_single_design_lang'   => '',
					'_cs_btn_text_confirm_in_single_design_lang'       => '',
					'_cs_always_on_in_single_design_lang'              => '',
					'_cs_btn_text_custom_button_in_single_design_lang' => '',
				),
			),
		),
		'iab_settings' => array(
			'wp_options' => array(
				'cmpro_iab_settings' => '',
			),
			'cm_options' => array(
				'cs_iab_show_only_vendors'            => '',
				'cs_iab_show_only_additional_vendors' => '',
			),
		),
	);

	$settings = array();

	foreach ( $parts as $part ) {
		$settings = array_merge_recursive( $settings, $settings_keys[ $part ] );
	}

	return $settings;
}

function get_language_keys() {
	$langs = array(
		'cm_options'   => array(
			'cs_text_in_small_bar_popup'                 => '',
			'cs_text_in_large_bar_popup'                 => '',
			'cs_btn_text_allow_all'                      => '',
			'cs_btn_text_disable_all'                    => '',
			'cs_btn_text_customize'                      => '',
			'cs_btn_text_privacy_cookie'                 => '',
			'cs_btn_text_sticky_cookie'                  => '',
			'cs_btn_text_custom_button'                  => '',
			'cs_text_in_options_popup'                   => '',
			'cs_consent'                                 => '',
			'cs_text_consent'                            => '',
			'cs_title_in_options_popup'                  => '',
			'cs_subtitle_in_options_popup'               => '',
			'cs_btn_text_allow_all_in_options_popup'     => '',
			'cs_btn_text_disable_all_in_options_popup'   => '',
			'cs_btn_text_confirm_in_options_popup'       => '',
			'cs_always_on_in_options_popup'              => '',
			'cs_video_consent_general_text'              => '',
			'cs_video_consent_rule_text'                 => '',
			'cs_advanced_matching_description'           => '',
			'cs_server_side_consent_description'         => '',
			'cs_customer_email_consent_type'             => '',
			'cs_customer_email_rule_name'                => '',
			'cs_customer_email_consent_expressed'        => '',
			'cs_text_in_single_design'                   => '',
			'cs_title_in_single_design'                  => '',
			'cs_subtitle_in_single_design'               => '',
			'cs_btn_text_allow_all_in_single_design'     => '',
			'cs_btn_text_disable_all_in_single_design'   => '',
			'cs_btn_text_confirm_in_single_design'       => '',
			'cs_always_on_in_single_design'              => '',
			'cs_btn_text_custom_button_in_single_design' => '',
		),
		'rules'        => array(
			'_cs_text_in_small_bar_popup'                 => '',
			'_cs_text_in_large_bar_popup'                 => '',
			'_cs_btn_text_allow_all'                      => '',
			'_cs_btn_text_customize'                      => '',
			'_cs_btn_text_privacy_cookie'                 => '',
			'_cs_btn_text_sticky_cookie'                  => '',
			'_cs_btn_text_custom_button'                  => '',
			'_cs_title_in_options_popup'                  => '',
			'_cs_subtitle_in_options_popup'               => '',
			'_cs_btn_text_allow_all_in_options_popup'     => '',
			'_cs_btn_text_disable_all'                    => '',
			'_cs_text_in_options_popup'                   => '',
			'_cs_btn_text_disable_all_in_options_popup'   => '',
			'_cs_btn_text_confirm_in_options_popup'       => '',
			'_cs_always_on_in_options_popup'              => '',
			'_cs_text_in_single_design'                   => '',
			'_cs_title_in_single_design'                  => '',
			'_cs_subtitle_in_single_design'               => '',
			'_cs_btn_text_allow_all_in_single_design'     => '',
			'_cs_btn_text_disable_all_in_single_design'   => '',
			'_cs_btn_text_confirm_in_single_design'       => '',
			'_cs_always_on_in_single_design'              => '',
			'_cs_btn_text_custom_button_in_single_design' => '',
		),
		'script_types' => array(
			'cs_edit_cat_description' => '',
		)
	);

	return $langs;
}
