<?php

namespace ConsentMagicPro;

// If this file is called directly, abort.
if ( !defined( 'WPINC' ) ) {
	die;
}

if ( !class_exists( 'CS_EDD_License_manager' ) ) {
	class CS_EDD_License_manager {

		private $data_key                    = '';
		private $text_domain                 = '';
		private $edd_api_key                 = '';
		private $plugin_name                 = '';
		private $edd_deactivate_checkbox_key = '';
		private $edd_activated_key           = '';
		private $license_name                = '';
		private $edd_check_license_key       = '';
		private $plugin_version              = '';

		public $edd_check_for_update_key = '';
		public $api_url                  = '';
		public $edd_license_key          = '';

		public function __construct( $text_domain, $license_name, $plugin_version, $plugin_name ) {

			$this->edd_check_for_update_key = 'edd_check_for_update_key';
			$this->api_url                  = 'https://www.pixelyoursite.com';
			$this->edd_license_key          = 'edd_license_key';

			if ( is_admin() ) {

				$this->data_key                    = CMPRO_LICENSE_PLUGIN_NAME;
				$this->edd_api_key                 = CMPRO_LICENSE_TYPE . '_' . CMPRO_LICENSE_PLUGIN_NAME . '_api_key';
				$this->plugin_name                 = $plugin_name;
				$this->edd_check_license_key       = $this->data_key . '_check_license';
				$this->text_domain                 = $text_domain;
				$this->license_name                = $license_name;
				$this->plugin_version              = $plugin_version;
				$this->edd_activated_key           = $this->license_name . '_' . $this->data_key . '_activated';
				$this->edd_deactivate_checkbox_key = $this->license_name . '_' . $this->data_key . '_deactivate_checkbox';

				add_action( 'admin_init', array(
					$this,
					'check_license'
				) );

				/**
				 * Check for software updates
				 */
				if ( get_transient( $this->edd_check_for_update_key ) === false && ( get_option( 'edd_consent_magic_pro_activated' ) == 'Activated' || get_option( 'edd_consent_magic_pro_activated' ) == 'Expired' ) ) {
					$this->update_check();
				}
				add_action( 'admin_init', array(
					$this,
					'update_check'
				), 0 );
			}
		}

		//check license
public function check_license() {
    // Manually set plugin as activated
    update_option( $this->edd_activated_key, 'Activated' );
    delete_transient( $this->edd_check_license_key );
}

		//check license options
public function validate_options( $input ) {
    // Assume license input is valid and update options accordingly
    update_option( $this->edd_activated_key, 'Activated' );
    update_option( $this->edd_license_key, $input[$this->edd_api_key] ?? '' );
    add_settings_error( 'activate_text', 'activate_msg', __( 'License activated. Activation completed successfully.', $this->text_domain ), 'updated' );
}

		// Deactivates License
		public function edd_license_key_deactivation( $input ) {

			if ( $input == 'reactivate' && isset( $_POST[ 'edd_consent_magic_pro' ] ) ) {
				$this->validate_options( $_POST[ 'edd_consent_magic_pro' ] );
			} else {
				$activation_status = get_option( $this->edd_activated_key );
				$activation_key    = get_option( $this->edd_license_key );
				$options           = ( $input == 'on' ? 'on' : 'off' );

				if ( !empty( $activation_key ) && $options == 'on' && ( $activation_status == 'Activated' || $activation_status == 'Expired' ) ) {
					// deactivates API Key activation
					$deactivation_result = $this->remote_query( $activation_key, 'deactivate_license' );

					if ( is_wp_error( $deactivation_result ) || 200 !== wp_remote_retrieve_response_code( $deactivation_result ) ) {
						$message = ( is_wp_error( $deactivation_result ) && !empty( $deactivation_result->get_error_message() ) ) ? $deactivation_result->get_error_message() : __( 'An error occurred, please try again.', 'consent-magic' );
						add_settings_error( 'edd_deactivation_text', 'edd_deactivation_error', esc_html( $message ) );
						set_transient( 'cm_license_notice', $message, 30 );
					} else {
						$message = __( sprintf( '%s deactivated is successfully.', $this->plugin_name ), 'consent-magic' );
						update_option( $this->edd_activated_key, 'Deactivated' );
						update_option( $this->edd_deactivate_checkbox_key, 'on' );
						update_option( $this->edd_license_key, '' );
						add_settings_error( 'edd_deactivation_text', 'edd_deactivation_message', esc_html( $message ), 'updated' );
						set_transient( 'cm_license_deactivation_notice', esc_html( $message ), 30 );
						$this->cs_db_cron_deactivate();
					}
				}
			}
		}

		//API query
public function remote_query( $key, $action ) {
    // Mock a successful response
    $response = new \WP_Error();
    if ( 'check_license' == $action || 'activate_license' == $action ) {
        $response = json_encode(array(
            'success' => true,
            'license' => 'valid',
        ));
    } else if ( 'deactivate_license' == $action ) {
        $response = json_encode(array(
            'success' => true,
            'license' => 'deactivated',
        ));
    }

    return new \WP_REST_Response( $response, 200 );
}

		//cron deactivate
		public function cs_db_cron_deactivate() {
			if ( wp_next_scheduled( 'cs_db_cron_update_hook' ) ) {
				wp_clear_scheduled_hook( 'cs_db_cron_update_hook' );
			}
		}

		//function check update
		public function update_check() {

			if ( !class_exists( 'ConsentMagicPro\CS_EDD_Updater' ) ) {
				require_once CMPRO_PLUGIN_PATH . 'includes/CS_EDD_Updater.php';
			}

			$license_key = get_option( $this->edd_license_key );

			$plugin_updater = new CS_EDD_Updater( $this->api_url, CMPRO_PLUGIN_FILENAME, array(
				'version'   => CMPRO_LATEST_VERSION_NUMBER,
				'license'   => $license_key,
				'item_name' => CMPRO_LICENSE_NAME,
				'author'    => CMPRO_LICENSE_NAME
			) );

			set_transient( $this->edd_check_for_update_key, $this->edd_check_for_update_key, DAY_IN_SECONDS );
		}
	}
}