<?php
if (!defined('ABSPATH')) {
    exit;
}
/**
 *
 * get coins_id by coin symbol
 *
 * This is just a function wrapper
 * @param string|array $symbol Symbol can be a single coin symbol or an array of symbols
 *
 * @return string|array a coin id is return in case of string or array if an array of symbols is passed
 */

function ccpwp_get_coin_ids($symbol)
{
    $DB = new ccpwp_database;
    return $DB->get_coin_id_by_symbol($symbol);
}

// Function to get the CoinGecko API key
function get_coingecko_api_key() {
    $api_option = get_option("openexchange-api-settings");
    $api_key =(isset($api_option['coingecko_api'])) ? $api_option['coingecko_api'] : ""; // Default API key
    // Apply filter to allow changing the API key
    $api_key = apply_filters('coingecko_api_key', $api_key);
    return $api_key;
}

/*
|--------------------------------------------------------------------------
| gathering coin(s) details from database.
| $coin_id can be single coin's id or an array of coins's id
|--------------------------------------------------------------------------
 */
function ccpwp_coins_data($coin_id)
{
    $DB = new ccpwp_database;

    // create a table and gather all data in case the table is removed somehow
    // if (false === $DB->is_table_exists()) {
    //     //$api_obj=new CCPWP_api_data();
    //     CCPWP_api_data::ccpwp_get_api_data();
    // }
    $limit = 1;
    if (is_array($coin_id)) {
        $limit = count($coin_id);
    }
    $coin_data = $DB->get_coins(array('coin_id' => $coin_id, 'number' => $limit));
    if (is_array($coin_data) && isset($coin_data)) {
        $coin_data = ccpwp_objectToArray($coin_data);
        return $coin_data;
    } else {
        return false;
    }

}

// supported donation coin array by metamask
function donation_supported_coins_meta()
{
    return $coins = array(
        'mainnet_ethereum' => 'ETH-(ERC20)',
        'mainnet_tether' => 'USDT-(ERC20)',
        'mainnet_binance-usd' => 'BUSD-(ERC20)',
        'mainnet_binancecoin' => 'BNB-(ERC20)',
        'bsc_binancecoin' => 'BNB-(BEP20)',
        'bsc_binance-usd' => 'BUSD-(BEP20)',
        'bsc_tether' => 'USDT-(BEP20)',
        'bsc_ethereum' => 'ETH-(BEP20)',
        'sepolia_ethereum_testnet' => 'ETH-(ERC20 Test Net)',
        'sepolia_tether_testnet' => 'USDT-(ERC20 Test Net)',
        'bscTestnet_binancecoin_testnet' => 'BNB-(BEP20 Test Net)',
        'bscTestnet_binance-usd_testnet' => 'BUSD-(BEP20 Test Net)',
    );
}

function ccpwp_donation_get_contract($coin)
{
    $contract_address = array(
        'sepolia_tether_testnet' => '0x6175a8471C2122f778445e7E07A164250a19E661',
        'bscTestnet_binance-usd_testnet' => '0xeD24FC36d5Ee211Ea25A80239Fb8C4Cfd80f12Ee',
        'mainnet_tether' => '0xdac17f958d2ee523a2206206994597c13d831ec7',
        'mainnet_binance-usd' => '0x4Fabb145d64652a948d72533023f6E7A623C7C53',
        'mainnet_binancecoin' => '0xB8c77482e45F1F44dE1745F52C74426C631bDD52',
        'bsc_binance-usd' => '0xe9e7cea3dedca5984780bafc599bd69add087d56',
        'bsc_tether' => '0x55d398326f99059ff775485246999027b3197955',
        'bsc_ethereum' => '0x2170ed0880ac9a755fd29b2688956bd959f933f8',

    );

    return isset($contract_address[$coin]) ? $contract_address[$coin] : false;
}

/*
|--------------------------------------------------------------------------
| checks new or old user
|--------------------------------------------------------------------------
 */
function ccpwp_check_user()
{
    $coingecko_api_key = "";
    $fresh_install = get_option('ccpw-fresh-installation');
    $get_license = get_option('ccpw_license_registration');
    $purchased_code = isset($get_license["ccpw-purchase-code"]) ? $get_license["ccpw-purchase-code"] : '';
    $api_option = get_option("openexchange-api-settings");
    $api_type = (isset($api_option['select_api'])) ? $api_option['select_api'] : "coingecko";
    if ($api_type == "coingecko") {
        $coingecko_api_key =get_coingecko_api_key();
       // $coingecko_api_key = ($fresh_install) ? $coingecko_api_key : 'true';

    } else if ($api_type == "coinmarketcap") {
        $coingecko_api_key = (isset($api_option['coinmarketcap_api'])) ? $api_option['coinmarketcap_api'] : "";
        //$coingecko_api_key = ($fresh_install) ? $coingecko_api_key : 'true';

    } else if ($api_type == "both_coingecko" || $api_type == "both_coinmarketcap") {
        $cg_api_key = get_coingecko_api_key();
        $cmc_api_key = (isset($api_option['coinmarketcap_api'])) ? $api_option['coinmarketcap_api'] : "";
        $coingecko_api_key = (!empty($cg_api_key) && !empty($cmc_api_key)) ? "true" : "";

    }

    if (!empty($purchased_code) && !empty($coingecko_api_key)) {
        return true;
    } else {
        return false;
    }
}

/*
|--------------------------------------------------------------------------
| creating coins array for settings
|--------------------------------------------------------------------------
 */
function ccpwp_coin_arr($ids = '', $type = 'all')
{
    $c_list = array();
    $coins_data = array();
    $all_coins = array();
    $limits = 2500;
    if (isset($GLOBALS['CoinMarketCap'])) {
        $limits = 3000;

    }
    $DB = new ccpwp_database();

    // create a table and gather all data in case the table is removed somehow

    if (CCPWP_api_data::ccpwp_get_selected_api_data()) {
        //$api_obj=new CCPWP_api_data();
        CCPWP_api_data::ccpwp_get_selected_api_data();
    }

    switch ($type) {
        case 'all':
            $all_coins = ccpwp_coins_data($ids);
            if (!empty($all_coins) && is_array($all_coins)) {
                $coins_data = array();
                foreach ($all_coins as $coin) {
                    $coins_data[$coin['coin_id']] = $coin;
                }
                return $coins_data;
            }
            break;
        case 'options':
            $all_coins = $DB->get_coins(array('number' => $limits));
            return ccpwp_objectToArray($all_coins);
            break;
        case 'list':
            /** This is responsible for returning CryptoCurrencies for settings panel */
            if (get_transient('ccpw_widget_pro_coin_list')) {
                return get_transient('ccpw_widget_pro_coin_list');
            }

            $all_coins = $DB->get_column_specific_data(array('number' => $limits, 'column' => 'coin_id,name'));
            foreach ($all_coins as $coin) {
                if ($coin->coin_id) {
                    $c_list[$coin->coin_id] = $coin->name;
                }
            }
            set_transient('ccpw_widget_pro_coin_list', $c_list, 60 * MINUTE_IN_SECONDS);
            return $c_list;
            break;
        case "top":
            // if (get_transient('ccpw_widget_pro_top_coins' . $ids)) {
            //     return get_transient('ccpw_widget_pro_top_coins' . $ids);
            // }

            $order_col_name = 'market_cap';
            $order_type = 'DESC';
            $coin_rs = $DB->get_coins(array("number" => $ids, 'offset' => 0, 'orderby' => $order_col_name,
                'order' => $order_type,
            ));
            $coin_data = array();
            if (is_array($coin_rs) && isset($coin_rs)) {
                $coin_data = ccpwp_objectToArray($coin_rs);
               // set_transient('ccpw_widget_pro_top_coins' . $ids, $coin_data, 5 * MINUTE_IN_SECONDS);
                return $coin_data;
            } else {
                return false;
            }
            break;
        default:
            $all_coins = $DB->get_coins(array('number' => $limits));
            foreach ($all_coins as $coin) {
                $c_list[$coin->coin_id] = $coin->name;
            }
            return $c_list;
            break;
    }

}

/*
|--------------------------------------------------------------------
|    This function will update unavailable coins in db
|--------------------------------------------------------------------
|    This must be called for specific post-type only
|--------------------------------------------------------------------
 */
function ccpwp_update_ua_coins_on_save_post($post_id)
{

    $available_coins = get_option('ccpwp-available-coins');
    $curr = get_post_meta($post_id, 'display_currencies', true);
    $curr = $curr !== "" ? $curr : array();
    $custom_idss = get_post_meta($post_id, 'custom_coins_id', true);
    $curr = (isset($custom_idss) && !empty($custom_idss)) ? array_merge($curr, explode(",", str_replace(' ', '', $custom_idss))) : $curr;
    $curr = $curr == '' ? get_post_meta($post_id, 'display_currencies_for_table', true) : $curr;
    if (!isset($curr) || !is_array($curr) || count($curr) < 0
        || !isset($available_coins) || !is_array($available_coins) || count($available_coins) < 0
    ) {
        return;
    }

    $unavailable_coins = array_diff($curr, $available_coins);

    if (is_array($unavailable_coins) && !empty($unavailable_coins)) {
        //$api_obj=new CCPWP_api_data();
        $api_option = get_option("openexchange-api-settings");
        $api_type = (isset($api_option['select_api'])) ? $api_option['select_api'] : "coingecko";
        $ua_coins_name = ($api_type == "both_coinmarketcap" || $api_type == "coinmarketcap") ? 'ccpwp-unavailable-coins-cmc' : 'ccpwp-unavailable-coins';
        $saved_ua_coins = get_option($ua_coins_name, []);
        $unavailable_coins = $saved_ua_coins == '' ? $unavailable_coins : array_diff($unavailable_coins, $saved_ua_coins);
        CCPWP_api_data::ccpwp_get_selected_api_ua_data($unavailable_coins);
        delete_transient('ccpw_widget_pro_coin_list');
    }

}

/*
|--------------------------------------------------------------------------
| server side processing ajax callback for table-widget (Datatable)
|--------------------------------------------------------------------------
 */
function ccpwp_get_coins_list()
{
    if (!isset($_POST['nonce']) || !wp_verify_nonce(sanitize_text_field($_POST['nonce']), 'ccpwf-tbl-widget')) {
        $response = array("draw" => 1, "recordsTotal" => 1, "recordsFiltered" => 1, "data" => [], 'error' => 'nonce_failed');
        echo json_encode($response);
        die();

    }
    require_once CCPWP_PATH . 'includes/ccpw-serverside-processing.php';
    ccpwp_get_ajax_data();
    wp_die();
}

function ccpwp_generate_tranasaction_table()
{

    $table = '<table class="wp-list-table widefat striped" >
    <thead>
        <tr>
            <th style="padding-left:6px;">' . __('Amount', 'ccpw') . '</th>
            <th style="padding-left:6px;">' . __('Hash', 'ccpw') . '</th>
            <th style="padding-left:6px;">' . __('From', 'ccpw') . '</th>
            <th style="padding-left:6px;">' . __('To', 'ccpw') . '</th>
            <th style="padding-left:6px;">' . __('Symbol', 'ccpw') . '</th>
            <th style="padding-left:6px;">' . __('Chain', 'ccpw') . '</th>
            <th style="padding-left:6px;">' . __('Date', 'ccpw') . '</th>
        </tr>
    </thead>';
    $data = get_option('ccpwp_savetransaction', array());
    // Table rows
    if (!empty($data)) {
        foreach ($data as $row) {
            $table .= "<tr>";
            $columns = [
                'amount' => isset($row['amount']) ? $row['amount'] . ' ' . (isset($row['symbol']) ? $row['symbol'] : '') : '-',
                'hash' => isset($row['hash']) ? ccpwp_getBlockExplorerLink($row['hash'], isset($row['chain']) ? $row['chain'] : '') : '-',
                'from' => isset($row['from']) ? $row['from'] : '-',
                'to' => isset($row['to']) ? $row['to'] : '-',
                'symbol' => isset($row['symbol']) ? $row['symbol'] : '-',
                'chain' => isset($row['chain']) ? $row['chain'] : '-',
                'timestamp' => isset($row['timestamp']) ? $row['timestamp'] : '-',
            ];
            foreach ($columns as $key => $value) {
                $displayValue = empty($value) ? '-' : $value;
                if ($key === 'hash' && !empty($row['hash'])) {
                    $displayValue = ccpwp_getBlockExplorerLink($row['hash'], isset($row['chain']) ? $row['chain'] : '');
                }
                $table .= "<td style='overflow: hidden; max-width: 150px; white-space: normal;'>" . esc_html($displayValue) . "</td>";
            }
            $table .= "</tr>";
        }
    }
    $table .= "</table>";
    $tabless = '<div style="overflow-x:auto;">' . $table . '</div>';
    if (!empty($data)) {
        return $tabless;
    } else {
        return __('No Transaction found', 'ccpw');
    }
}
function ccpwp_getBlockExplorerLink($hash, $network)
{
    switch ($network) {
        case 'BNB Smart Chain':
            return "<a href=\"" . esc_url("https://bscscan.com/tx/$hash") . "\" target=\"_blank\" style=\"width: '100%'\">" . esc_html($hash) . "</a>";
        case 'Binance Smart Chain Testnet':
            return "<a href=\"" . esc_url("https://testnet.bscscan.com/tx/$hash") . "\" target=\"_blank\" style=\"width: '100%'\">" . esc_html($hash) . "</a>";
        case 'Ethereum':
            return "<a href=\"" . esc_url("https://etherscan.io/tx/$hash") . "\" target=\"_blank\" style=\"width: '100%'\">" . esc_html($hash) . "</a>";
        case 'Sepolia':
            // Replace 'sepolia-explorer-url' with the actual URL of the Sepolia explorer
            return "<a href=\"" . esc_url("https://sepolia.etherscan.io/tx/$hash") . "\" target=\"_blank\" style=\"width: '100%'\">" . esc_html($hash) . "</a>";
        default:
            return "-";
    }
}

/*
|-------------------------------------------------------------
|     Check if provided $value is empty or not.
|-------------------------------------------------------------
|    Return $default if $value is empty
|-------------------------------------------------------------
 */
function ccpwp_set_default_if_empty($value, $default = 'N/A')
{
    return ($value ?? 0) == 0 ? $default : $value;
}

function get_fiat_symbol($fiat_currency)
{
    $fiat_symbol = '';
    $icon_array = array(
        'USD' => 'fa fa-usd',
        'GBP' => 'fa fa-gbp',
        'EUR' => 'fa fa-eur',
        'INR' => 'fa fa-inr',
        'JPY' => 'fa fa-jpy',
        'CNY' => 'fa fa-cny',
        'ILS' => 'fa fa-ils',
        'KRW' => 'fa fa-krw',
        'RUB' => 'fa fa-rub',
    );

    if (isset($icon_array[$fiat_currency])) {
        $icon_cls = $icon_array[$fiat_currency];
        $fiat_symbol = '<i class="' . $icon_cls . '" aria-hidden="true"></i>';
    } else {
        $fiat_symbol = '<i class="fa fa-usd" aria-hidden="true"></i>';
    }
    return $fiat_symbol;
}

// currencies symbol
function ccpwp_get_currency_symbol($name)
{
    $cc = strtoupper($name);
    $currency = array(
        "USD" => "&#36;", //U.S. Dollar
        "AUD" => "&#36;", //Australian Dollar
        "BRL" => "R&#36;", //Brazilian Real
        "CAD" => "C&#36;", //Canadian Dollar
        "CZK" => "K&#269;", //Czech Koruna
        "DKK" => "kr", //Danish Krone
        "EUR" => "&euro;", //Euro
        "HKD" => "&#36;", //Hong Kong Dollar
        "HUF" => "Ft", //Hungarian Forint
        "ILS" => "&#x20aa;", //Israeli New Sheqel
        "INR" => "&#8377;", //Indian Rupee
        "JPY" => "&yen;", //Japanese Yen
        "MYR" => "RM", //Malaysian Ringgit
        "MXN" => "&#36;", //Mexican Peso
        "NOK" => "kr", //Norwegian Krone
        "NZD" => "&#36;", //New Zealand Dollar
        "PHP" => "&#x20b1;", //Philippine Peso
        "PLN" => "&#122;&#322;", //Polish Zloty
        "GBP" => "&pound;", //Pound Sterling
        "SEK" => "kr", //Swedish Krona
        "CHF" => "Fr", //Swiss Franc
        "TWD" => "&#36;", //Taiwan New Dollar
        "THB" => "&#3647;", //Thai Baht
        "TRY" => "&#8378;", //Turkish Lira
        "CNY" => "&#165;", //China Yuan Renminbi
        "KRW" => "&#8361;", //South Korean Won
        "RUB" => "&#8381;", //Russian Ruble
        "SGD" => "S&#36;", //Singapore Dollar
        "CLP" => "&#36;", //Chilean peso
        "IDR" => "Rp", //Indonesian rupiah
        "PKR" => "Rs", //Pakistani rupee
        "ZAR" => "R", //South African rand
        "NGN" => "&#8358;",
        "JMD" => "J&#36;",

    );

    if (array_key_exists($cc, $currency)) {
        return $currency[$cc];
    }
}

// creating coins logo html
function ccpwp_coin_logo_html($coin_id, $size = 32, $GETHTML = true)
{
    $logo_html = '';
    $coin_icon = '';
    $coin_svg = CCPWP_PATH . 'assets/coin-logos/' . $coin_id . '.svg';
    $coin_png = CCPWP_PATH . 'assets/coin-logos/' . $coin_id . '.png';
    $coin_alt = $coin_id;
    if (is_file($coin_svg)) {

        $coin_icon = CCPWP_URL . 'assets/coin-logos/' . $coin_id . '.svg';
        $logo_html = '<img style="width:' . $size . 'px;" id="' . esc_attr($coin_id) . '" alt="' . esc_attr($coin_alt) . '" src="' . esc_url($coin_icon) . '">';

    } else if (is_file($coin_png)) {

        if ($size == 32) {
            $index = "32x32";
        } else {
            $index = "128x128";
        }
        $coin_icon = CCPWP_URL . 'assets/coin-logos/' . strtolower($coin_id) . '.png';
        $logo_html = '<img id="' . esc_attr($coin_id) . '" alt="' . esc_attr($coin_alt) . '" src="' . esc_url($coin_icon) . '">';

    } else {

        if ($size == 32) {
            $index = "32x32";
        } else {
            $index = "128x128";
        }
        $DB = new ccpwp_database();
        $coin_icon = $DB->get_coin_logo($coin_id);

        // if (isset($coin_icon['logo']) && !empty($coin_icon['logo'])) {
        //     $coin_icon = CCPWP_COINS_LOGO . $coin_icon['logo'];
        // } 
        
        $logo_data = isset($coin_icon['logo']) ? $coin_icon['logo'] : '';
        $logo_extracted = substr($logo_data, strpos($logo_data, "images/") + 7);
        if (isset($logo_extracted) && !empty($logo_extracted)) {
            $coin_icon = CCPWP_COINS_LOGO . $logo_extracted;
        }else if (isset($coin_icon['extradata']) && !empty($coin_icon['extradata'])) {
            $decode = maybe_unserialize($coin_icon['extradata']);
            $coin_icon = 'https://s2.coinmarketcap.com/static/img/coins/64x64/' . $decode['cmc_id'] . '.png';
        } else {
            if (ccpwp_coin_array($coin_id, true)) {
                $coin_icon = 'https://static.coinpaprika.com/coin/' . ccpwp_coin_array($coin_id, true) . '/logo.png';
            }

        }
        $logo_html = '<img id="' . esc_attr($coin_id) . '" alt="' . esc_attr($coin_alt) . '" src="' . esc_url($coin_icon) . '" onerror="this.src = \'https://res.cloudinary.com/pinkborder/image/upload/coinmarketcap-coolplugins/' . $index . '/default-logo.png\';">';
    }

    return $GETHTML == true ? $logo_html : $coin_icon;

}
/*
|--------------------------------------------------------------------------
| objectToArray conversion helper function
|--------------------------------------------------------------------------
 */

function ccpwp_objectToArray($d)
{
    if (is_object($d)) {
        // Gets the properties of the given object
        // with get_object_vars function
        $d = get_object_vars($d);
    }

    if (is_array($d)) {
        /*
         * Return array converted to object
         * Using __FUNCTION__ (Magic constant)
         * for recursive call
         */
        return array_map(__FUNCTION__, $d);
    } else {
        // Return array
        return $d;
    }
}
// small chart ajax handler
function ccpw_small_chart_data()
{
    if (isset($_POST['coinid'])) {
        //$api_obj=new CCPWP_api_data();
        $coin_id = sanitize_key($_POST['coinid']);
        $period = sanitize_text_field($_POST['period']);
        $history = CCPWP_api_data::ccpw_coin_period_historical($coin_id, $period);
        if (!empty($history) && count($history) > 0) {
            echo json_encode(array("type" => "success", "data" => $history));
        } else {
            echo json_encode(array("type" => "error", "data" => $history));
        }
    }
    wp_die();
}
/**
 * charts ajax handled
 *
 */
function ccpw_charts_data()
{

    if (!isset($_POST['nonce']) || !wp_verify_nonce(sanitize_text_field($_POST['nonce']), 'ccpw-chart-ajax-nonce')) {
        $response = array('error' => 'nonce_failed');
        echo json_encode($response);
        die();
    }
    $allowed_origin=get_site_url();
    // Origin verification
    $origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';

    if (!(strpos($allowed_origin, $origin) !== false)) {
         $response = array('error' => 'nonce_failed');
        echo json_encode($response);
        die();
    }

    // Referer verification
    $referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';

    if (strpos($referer, $allowed_origin) !== 0) {
        $response = array('error' => 'nonce_failed');
        echo json_encode($response);
        die();
    }

    $coin_d_arr = array();
    $coin_id = esc_sql($_POST['coin_id']);
    $chart_data = ccpwp_full_chart_data($coin_id);
    echo json_encode(array('status' => 'success', 'data' => $chart_data));
    exit();
}
/*
single page chart data array
 */

function ccpwp_full_chart_data($coin_id)
{
    $coin_d_arr = array();
    //$api_obj=new CCPWP_api_data();
    $historical_all_data = CCPWP_api_data::ccpwp_select_historical_data_api($coin_id);
    if (!empty($historical_all_data)) {
        $count = isset($historical_all_data->prices) ? count($historical_all_data->prices) : "";
        for ($i = 0; $i < $count; $i++) {
            $at_time = $historical_all_data->prices[$i][0];
            $coin_price = $historical_all_data->prices[$i][1];
            $coin_vol = $historical_all_data->total_volumes[$i][1];
            $coin_d_arr[] = array('date' => $at_time, 'value' => $coin_price, 'volume' => $coin_vol);
        }
        return $coin_d_arr;
    }
}

function ccpw_generate_svg_chart($coin_id,
    $coin_price,
    $small_chart_color,
    $small_chart_bgcolor,
    $period = '7d',
    $points = 0,
    $currency_symbol = "$",
    $currency_price = 0,
    $chart_fill = "true"
) {

    $chart_html = '';
    $chart_cache = false; //ccpw_get_chart_cache_data($coin_id, $period);
    $cachedata = '';
    $content = '';
    $no_data_lbl = __('No Graphical Data', 'cmc');
    if ($chart_cache === false) {
        $cachedata = 'false';
    } else {
        $cachedata = 'true';
        if ($coin_price) {
            $chart_cache[] = (float) str_replace(",", "", $coin_price);
        }
        $content = json_encode($chart_cache);
    }

    if ($period == '7d' && is_array($chart_cache)) {
        $last = count($chart_cache);
        if ($chart_cache[0] > $chart_cache[$last - 1]) {
            $small_chart_color = ccpw_hex2rgba('#ff0000', 0.70);
            $small_chart_bgcolor = ccpw_hex2rgba('#ff9999', 0.30);
        } else {
            $small_chart_color = ccpw_hex2rgba('#006400', 0.70);
            $small_chart_bgcolor = ccpw_hex2rgba('#90EE90', 0.30);
        }

    }
    $chart_html .= '<div class="ccpw-chart-container">
		<canvas data-bg-color="' . esc_attr($small_chart_bgcolor) . '"
			data-color="' . esc_attr($small_chart_color) . '"
			data-msz="' . esc_attr($no_data_lbl) . '"
			data-content="' . esc_attr($content) . '"
			data-cache="' . esc_attr($cachedata) . '"
			data-coin-id="' . esc_attr($coin_id) . '"
			data-period="' . esc_attr($period) . '"
			data-points="' . esc_attr($points) . '"
			data-currency-symbol="' . esc_attr($currency_symbol) . '"
			data-currency-price="' . esc_attr($currency_price) . '"
			data-chart-fill="' . esc_attr($chart_fill) . '"
		  class="ccpw-sparkline-charts"></canvas>
		  </div>';
    //$chart_html .= '<img class="ccpw-small-preloader" src="' . CCPWP_URL . 'images/chart-loading.svg">';
    return $chart_html;
}

function ccpwp_track_coingecko_api_hit()
{
    $api_hits = get_option('cmc_coingecko_api_hits');
    if ($api_hits === false) {
        // Option doesn't exist, so initialize it with a value of 0
        add_option('cmc_coingecko_api_hits', 0);
    }
    $api_hits = (int) $api_hits + 1; // Increment the value by 1
    update_option('cmc_coingecko_api_hits', $api_hits);
}

function ccpwp_format_number($n)
{

    if ($n <= 0.00001 && $n > 0) {
        return $formatted = number_format($n, 8, '.', ',');
    } else if ($n <= 0.0001 && $n > 0.00001) {
        return $formatted = number_format($n, 6, '.', ',');
    } else if ($n <= 0.001 && $n > 0.0001) {
        return $formatted = number_format($n, 5, '.', ',');
    } else if ($n <= 0.01 && $n > 0.001) {
        return $formatted = number_format($n, 4, '.', ',');
    } else if ($n <= 1 && $n > 0.01) {
        return $formatted = number_format($n, 3, '.', ',');
    } else {
        return $formatted = number_format($n, 2, '.', ',');
    }
}

function ccpw_format_coin_values($value, $precision = 2)
{
    if ($value < 1000000) {
        // Anything less than a million
        $formated_str = number_format($value, $precision);
    } else if ($value < 1000000000) {
        // Anything less than a billion
        $formated_str = number_format($value / 1000000, $precision) . 'M';
    } else {
        // At least a billion
        $formated_str = number_format($value / 1000000000, $precision) . 'B';
    }

    return $formated_str;
}

function ccpw_nice_number($n)
{
    if (!isset($n)) {
        return;
    }

    // first strip any formatting;
    $n = (0 + str_replace(",", "", $n));
    // is this a number?

    // now filter it;
    if ($n > 1000000000000) {
        return round(($n / 1000000000000), 2) . ' T';
    } elseif ($n > 1000000000) {
        return round(($n / 1000000000), 2) . ' B';
    } elseif ($n > 1000000) {
        return round(($n / 1000000), 2) . ' M';
    } elseif ($n > 1000) {
        return round(($n / 1000), 2) . ' K';
    }

    return number_format($n);
}

//Function to generate RSS feed
function ccpw_rss_feed($rss_desc_length, $rss_url, $rss_no_of_news)
{

    /* SimplePie RSS parsing engine */
    include_once ABSPATH . WPINC . '/feed.php';
    /* Build the SimplePie object */
    $rss = fetch_feed($rss_url);
    // $rss =fetch_feed('https://cointelegraph.com/feed/');
    /* Check for errors in the RSS XML */
    if (!is_wp_error($rss)) {

        $maxitems = $rss->get_item_quantity($rss_no_of_news);
        $rss_items = $rss->get_items(0, $maxitems);

        // $total_entries = count($rss_items);
        //$i = 1;
        $news_data = array();

        foreach ($rss_items as $index => $item) {
            //    $rss2 = simplexml_load_file($rss_url);
            $news_data[$index]['title'] = $item->get_title();
            $news_data[$index]['link'] = $item->get_permalink();
            $desc = $item->get_description();

            $news_data[$index]['first-image'] = firstImg($desc);
            $news_data[$index]['date_posted'] = $item->get_date();
            $news_data[$index]['date-time'] = strtotime($item->get_date());
            if ($enclosure = $item->get_enclosure()) {
                $news_data[$index]['image-url'] = $enclosure->get_link();
            }

            $news_data[$index]['channel'] = $rss->get_title();

            $desc = wp_kses(trim($desc), array());
            $desc = strip_tags(apply_filters('the_excerpt', $desc));
            $desc = wp_trim_words($desc, $rss_desc_length);
            $desc = trim(preg_replace('!\s+!', ' ', $desc));
            $news_data[$index]['description'] = $desc;
        }
        return $news_data;

    }

}
// sorting RSS feed by date

function cccpw_date_compare($a, $b)
{

    if ($a['date-time'] < $b['date-time']) {
        return 1;
    } else if ($a['date-time'] > $b['date-time']) {
        return -1;
    } else {
        return 0;
    }

}

/*grabing first image from RSS feed */
function firstImg($post_content)
{
    $matches = array();
    $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post_content, $matches);
    if (isset($matches[1][0])) {
        $first_img = $matches[1][0];
    }

    if (empty($first_img)) {
        return '';
    }
    return $first_img;
}

function ccpw_sort_by_gainers($a, $b)
{

    if ($a['percent_change_24h'] < $b['percent_change_24h']) {
        return 1;
    } else if ($a['percent_change_24h'] > $b['percent_change_24h']) {
        return -1;
    } else {
        return 0;
    }

}

function ccpw_sort_by_losers($a, $b)
{

    return $a['percent_change_24h'] - $b['percent_change_24h'];

}

function ccpw_get_chart_cache_data($coin_id, $period)
{
    $DB = new ccpwp_database();

    // create a table and gather all data in case the table is removed somehow
    // if (false === $DB->is_table_exists()) {
    //     //$api_obj=new CCPWP_api_data();
    //     CCPWP_api_data::ccpwp_get_api_data();
    // }
    if ($period == "7d") {
        $historical_data = get_transient('7d-historical-' . $coin_id);
    } else {
        $historical_data = get_transient('24h-historical-' . $coin_id);
    }
    if (is_array($historical_data) && count($historical_data) > 0) {
        //    return json_decode( unserialize( $historical_data) );
    } else {
        return false;
    }

}

function ccpw_generate_column($column)
{
    if (preg_match("/12$/", $column, $match)) {
        $column2 = 1;
    } else if (preg_match("/6$/", $column, $match)) {
        $column2 = 2;
    } else if (preg_match("/4$/", $column, $match)) {
        $column2 = 3;
    } else if (preg_match("/3$/", $column, $match)) {
        $column2 = 4;
    } else {
        $column2 = 6;
    }
    return $column2;
}

/* Convert hexdec color string to rgb(a) string */
function ccpw_hex2rgba($color, $opacity = false)
{

    $default = 'rgb(0,0,0)';

    //Return default if no color provided
    if (empty($color)) {
        return $default;
    }

    //Sanitize $color if "#" is provided
    if ($color[0] == '#') {
        $color = substr($color, 1);
    }

    //Check if color has 6 or 3 characters and get values
    if (strlen($color) == 6) {
        $hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
    } elseif (strlen($color) == 3) {
        $hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
    } else {
        return $default;
    }

    //Convert hexadec to rgb
    $rgb = array_map('hexdec', $hex);

    //Check if opacity is set(rgba or rgb)
    if ($opacity) {
        if (abs($opacity) > 1) {
            $opacity = 1.0;
        }

        $output = 'rgba(' . implode(",", $rgb) . ',' . $opacity . ')';
    } else {
        $output = 'rgb(' . implode(",", $rgb) . ')';
    }

    //Return rgb(a) color string
    return $output;
}

function ccpw_HTMLpluginVersion()
{
    return '<!-- Cryptocurrency Widgets PRO ' . CCPWP_VERSION . '  !-->';
}

function get_cpt()
{
    global $post, $typenow, $current_screen;

    /*if ( $post && $post->post_type ){
    return $post->post_type;
    }*/
    if ($typenow) {
        return $typenow;
    } elseif ($current_screen && $current_screen->post_type) {
        return $current_screen->post_type;
    } elseif (isset($_REQUEST['post_type'])) {
        return sanitize_key($_REQUEST['post_type']);
    } elseif (isset($_REQUEST['post'])) {
        return get_post_type($_REQUEST['post']);
    }
    return null;
}

/**
 * Wrapper function around cmb2_get_option
 * @since  0.1.0
 * @param  string $key     Options array key
 * @param  mixed  $default Optional default value
 * @return mixed           Option value
 */
function ccpwp_get_option($key = '', $default = false)
{
    if (function_exists('cmb2_get_option')) {
        // Use cmb2_get_option as it passes through some key filters.
        return cmb2_get_option('ccpw_widget_settings', $key, $default);
    }

    // Fallback to get_option if CMB2 is not loaded yet.
    $opts = get_option('ccpw_widget_settings', $default);

    $val = $default;

    if ('all' == $key) {
        $val = $opts;
    } elseif (is_array($opts) && array_key_exists($key, $opts) && false !== $opts[$key]) {
        $val = $opts[$key];
    }

    return $val;
}

function get_cmc_single_page_slug()
{
    // Initialize cmb2 for cmc links
    $cmc_slug = '';
    if (function_exists('cmc_extra_get_option')) {
        $cmc_slug = cmc_extra_get_option('single-page-slug');
        if (empty($cmc_slug)) {
            $cmc_slug = 'currencies';
        }
    } else {
        $cmc_slug = 'currencies';
    }
    return $cmc_slug;
}
function ccpwp_get_api_end_point()
{
    // Get coingecko api end point

    $api_option = get_option("openexchange-api-settings");
    $endpoint = (isset($api_option['api_end_point'])) ? $api_option['api_end_point'] : "free";
    if ($endpoint == "pro") {
        return "https://pro-api.coingecko.com/api/v3/";
    } else {
        return 'https://api.coingecko.com/api/v3/';
    }

}
function ccpwp_get_api_key_end_point()
{
    // Get coingecko api end point

    $api_option = get_option("openexchange-api-settings");
    $endpoint = (isset($api_option['api_end_point'])) ? $api_option['api_end_point'] : "free";
    if ($endpoint == "pro") {
        return "x_cg_pro_api_key";
    } else {
        return "x_cg_demo_api_key";
    }

}
function ccpwp_check_api_errors($api_data)
{
    // Get coingecko api end point
    $error_codes = [429, 10006];
    if (isset($api_data->status->error_code) && in_array($api_data->status->error_code, $error_codes)) {
        return true;
    } else {
        return false;
    }

}

function ccpwp_coin_array($coin_id, $flip = false)
{
    // Read the JSON file
    $json_data = file_get_contents(CCPWP_PATH . 'assets/coinpaprika-ids.json');
    // Decode the JSON data into an associative array
    $coin_list = json_decode($json_data, true);

    if ($flip == true) {
        $fliped_array = array_flip($coin_list);
        return (isset($fliped_array[$coin_id])) ? $fliped_array[$coin_id] : $coin_id;
    } else {
        return (isset($coin_list[$coin_id])) ? $coin_list[$coin_id] : $coin_id;

    }

}

/**
 * Retrieves coin data from the coin array list JSON file.
 *
 * @param string $coin_id The ID of the coin to retrieve data for.
 * @param bool $flip Whether to flip the array or not.
 * @return mixed Coin data if found, otherwise the provided coin ID.
 */
function ccpwp_cmc_coin_array($coin_id, $flip = false)
{
    // Read the JSON file
    $json_data = file_get_contents(CCPWP_PATH . 'assets/cmc-coins-ids.json');

    // Decode the JSON data into an associative array
    $coin_list = json_decode($json_data, true);

    // Flip the array if required
    if ($flip) {
        $coin_list = array_flip($coin_list);
    }

    // Return coin data if found, otherwise return the provided coin ID
    return isset($coin_list[$coin_id]) ? $coin_list[$coin_id] : $coin_id;
}

//  For Get User Extra Data And Server Infomation

function ccpwp_get_user_info() {

    global $wpdb;

    // Server and WP environment details
    $server_info = [
        'server_software'        => isset($_SERVER['SERVER_SOFTWARE']) ? sanitize_text_field($_SERVER['SERVER_SOFTWARE']) : 'N/A',
        'mysql_version'          => $wpdb ? sanitize_text_field($wpdb->get_var("SELECT VERSION()")) : 'N/A',
        'php_version'            => sanitize_text_field(phpversion() ?: 'N/A'),
        'wp_version'             => sanitize_text_field(get_bloginfo('version') ?: 'N/A'),
        'wp_debug'               => (defined('WP_DEBUG') && WP_DEBUG) ? 'Enabled' : 'Disabled',
        'wp_memory_limit'        => sanitize_text_field(ini_get('memory_limit') ?: 'N/A'),
        'wp_max_upload_size'     => sanitize_text_field(ini_get('upload_max_filesize') ?: 'N/A'),
        'wp_permalink_structure' => sanitize_text_field(get_option('permalink_structure') ?: 'Default'),
        'wp_multisite'           => is_multisite() ? 'Enabled' : 'Disabled',
        'wp_language'            => sanitize_text_field(get_option('WPLANG') ?: get_locale()),
        'wp_prefix'              => isset($wpdb->prefix) ? sanitize_key($wpdb->prefix) : 'N/A',
    ];

    // Theme details
    $theme = wp_get_theme();

    $theme_data = [
        'name'      => sanitize_text_field($theme->get('Name')),
        'version'   => sanitize_text_field($theme->get('Version')),
        'theme_uri' => esc_url($theme->get('ThemeURI')),
    ];

    // Ensure plugin functions are loaded
    if ( ! function_exists('get_plugins') ) {

        require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }

    // Active plugins details
    $active_plugins = get_option('active_plugins', []);
    $plugin_data = [];

    foreach ( $active_plugins as $plugin_path ) {

        $plugin_info = get_plugin_data(WP_PLUGIN_DIR . '/' . sanitize_text_field($plugin_path));

        $author_url = ( isset( $plugin_info['AuthorURI'] ) && !empty( $plugin_info['AuthorURI'] ) ) ? esc_url( $plugin_info['AuthorURI'] ) : 'N/A';
        $plugin_url = ( isset( $plugin_info['PluginURI'] ) && !empty( $plugin_info['PluginURI'] ) ) ? esc_url( $plugin_info['PluginURI'] ) : 'N/A';
        
        $plugin_data[] = [
            'name'       => sanitize_text_field($plugin_info['Name']),
            'version'    => sanitize_text_field($plugin_info['Version']),
            'plugin_uri' => !empty($plugin_url) ? $plugin_url : $author_url,
        ];
    }

    return [
        'server_info'   => $server_info,
        'extra_details' => [
            'wp_theme'       => $theme_data,
            'active_plugins' => $plugin_data,
        ],
    ];
}