<?php
if (!defined('ABSPATH')) {
    exit;
}
/**
 * Generating Chart for coins
 */
$chart_html = '';
$coin_symbol = $coin['symbol'] ?? null;
$coin_id = $coin['coin_id'] ?? null;
$coin_name = $coin['name'] ?? null;

$coin_price = isset($coin['price']) ? ccpwp_format_number($coin['price']) : null;
$market_cap = isset($coin['market_cap']) ? ccpwp_format_number($coin['market_cap']) : null;
$volume = isset($coin['total_volume']) ? ccpwp_format_number($coin['total_volume']) : null;
$unique_id = uniqid();
$c_height = $chart_height ? $chart_height . "px" : "400px";
if ($mainChartType == "cryptocompare") {
    if ($coin_symbol) {
        $color = isset($chart_color) ? $chart_color : '#919191';
        $color = ccpw_hex2rgba($color, 0.85);
        $color_light = ccpw_hex2rgba($color, 0.50);
        $chart_html .= '<div id="ccc-chart-block"><div class="ccc-chart-header">' . esc_html($coin_name) . ' ' . __('Chart', 'ccpw') . '<div class="ccc-logo-right">' . __('Chart by', 'ccpw') . '<a href="http://cryptocompare.com" target="_blank" rel="nofollow">CryptoCompare</a></div></div>
		<script type="text/javascript">
		baseUrl = "https://widgets.cryptocompare.com/";
		var scripts = document.getElementsByTagName("script");
		var embedder = scripts[ scripts.length - 1 ];
		var cccTheme = {
			"General":{"borderWidth":"0px","borderColor":"#FFF","showExport":true},
			"Tabs":{"borderColor":"#FFF","activeBorderColor":"' . esc_js($color) . '"},
			"Chart":{"fillColor":"#222","borderColor":"' . esc_js($color) . '"},
			"Conversion":{"lineHeight":"10px"}};
		(function (){
		var appName = encodeURIComponent(window.location.hostname);
		if(appName==""){appName="local";}
		var s = document.createElement("script");
		s.type = "text/javascript";
		s.async = true;
		var theUrl = baseUrl+\'serve/v3/coin/chart?fsym=' . esc_js($coin_symbol) . '&tsyms=USD,EUR,GBP\';
		s.src = theUrl + ( theUrl.indexOf("?") >= 0 ? "&" : "?") + "app=" + appName;
		embedder.parentNode.appendChild(s);
		})();
		</script></div>
		';
    }

} else if ($mainChartType == "tradingview" || $trading_view) {

    $coin_symbol = $coin_symbol == 'MIOTA' ? 'IOTA' : $coin_symbol;

    switch ($coin_symbol) {
        case "STEEM":
        case "USDT":
        case "ADA":
            $tsymbol = "BITTREX:" . $coin_symbol . "USD";
            break;
        case "SBD":
            $tsymbol = "BITTREX:SBDBTC";
            break;
        case "BCH":
            $tsymbol = "BITSTAMP:BCHUSD";
            break;
        case "BNB":
        case "XEM":
            $tsymbol = "BINANCE:" . $coin_symbol . "BTC";
            break;
        case "DASH":
        case "IOTA":
        case "ONT":
            $tsymbol = "BINANCE:" . $coin_symbol . "USD";
            break;
        case "USDC":
            $tsymbol = "BINANCE:BTCUSDC";
            break;
        case "SKL":
            $tsymbol = "BINANCE:" . $coin_symbol . "USDT";
            break;
        default:
            $tsymbol = "BITFINEX:" . $coin_symbol . "USD";
    }

    $chart_html .= '<!-- TradingView Widget BEGIN -->
			<div class="tradingview-widget-container">
			  <div id="tradingview_' . esc_attr($coin_symbol) . '-'.$unique_id.'"></div>
			  <div class="tradingview-widget-copyright"></div>
			  <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
			  <script type="text/javascript">
			  new TradingView.widget(
			  {
			   "width":"100%",
			  "height": ' . esc_js($chart_height) . ',
			  "symbol":"' . esc_js($tsymbol) . '",
			  "interval": "D",
			  "timezone": "Etc/UTC",
			  "theme": "Light",
			  "style": "1",
			  "locale": "en",
			  "toolbar_bg": "#f1f3f6",
			  "enable_publishing": false,
			  "allow_symbol_change": true,
			  "hideideas": true,
			  "container_id": "tradingview_' . esc_js($coin_symbol) . '"
			}
			  );
			  </script>
			</div>
			<div style="display:block;font-size:13px;text-align: center;">Powered by <a href="https://www.tradingview.com/" rel="noopener" target="_blank">TradingView</a></div>
			<!-- TradingView Widget END -->';
} else {
    $coin_logo = ccpwp_coin_logo_html($coin_id, $size = 128);
    $coin_released = '';
    if ($coin_symbol == "MIOTA") {
        $coin_symbol = 'IOT';
        $coin_released = '90day';
    } else {
        $coin_released = '365day';
    }

    $coin_price_html = "";
    $coin_price_html .= '<span class="ticker-price">' . esc_html($fiat_symbol) . esc_html($coin_price) . '</span>';

    if (in_array($coin_symbol, array("BTX", "NAS", "GBYTE", "BCN"))) {
        $chart_html .= '<div class="no-data">' . __(
            'It is a new coin.API\'s have no available data',
            'ccpw'
        ) . '</div>';
    } else {

        //$chart_data = ccpwp_full_chart_data($coin_symbol);
        //$data_json = json_encode($chart_data);
        // $chart_html .= '<script id ="' . $coin_symbol . '-chart-data" type = "application/json" >' . $data_json . '</script>';
        $no_formatting = "'$'#.########";
        if ($coin_price < 0.0001) {
            $no_formatting = "'$'#.########";
        } else if ($coin_price < 0.01) {
            $no_formatting == "'$'#.#####";
        } else if ($coin_price < 0.50) {
            $no_formatting = "'$'#.####";
        } else if ($coin_price > 1000) {
            $no_formatting = "'$'#,###.##";
        } else {
            $no_formatting = "'$'#,###.###";
        }

        $data_1D = __('24H', 'cmc');
        $data_7D = __('7D', 'cmc');
        $data_1M = __('1M', 'cmc');
        $data_3M = __('3M', 'cmc');
        $data_6M = __('6M', 'cmc');
        $data_1Y = __('1Y', 'cmc');
        $chart_from_lbl = __('From', 'ccpw');
        $chart_to_lbl = __('To', 'ccpw');
        $chart_zoom_lbl = __('Zoom', 'ccpw');
        $chart_price_lbl = __('Price', 'ccpw');
        $chart_volume_lbl = __('Volume', 'ccpw');
        $color = isset($chart_color) ? $chart_color : '#2196F3';
  
        $chart_cont = '<div
			class="ccpw-chart"
			data-no-formatting="' . esc_attr($no_formatting) . '"
			data-coin-period="' . esc_attr($coin_released) . '"
			data-coin-id="' . esc_attr($coin_id) . '"
			data-chart-color="' . esc_attr($color) . '"
			data-from-lbl="' . esc_attr($chart_from_lbl) . '"
			data-zoom-lbl="' . esc_attr($chart_zoom_lbl) . '"
			data-to-lbl="' . esc_attr($chart_to_lbl) . '"
			data-price-lbl="' . esc_attr($chart_price_lbl) . '"
			data-volume-lbl="' . esc_attr($chart_volume_lbl) . '"
			 data-1d="' . esc_attr($data_1D) . '" data-7d="' . esc_attr($data_7D) . '" data-1m="' . esc_attr($data_1M) . '" data-3m="' . esc_attr($data_3M) . '"
            data-6m="' . esc_attr($data_6M) . '" data-1y="' . esc_attr($data_1Y) . '" data-coinid="' . esc_attr($coin_id) . '"
            data-unique-id="'.$unique_id.'"></div>';
        $chart_html .= '<div class="coin_details"><ul>
            <li><div class="ccpw_icon">' . $coin_logo . '</div></li>
            <li><div class="ticker-name"><strong>' . esc_html($coin_name) . '<br/>(' . esc_html($coin_symbol) . ')</strong></div>
            </li>
            <li class="c_info"><strong>' . __('Price ', 'ccpw') . '</strong> <div class="chart_coin_price CCP-' . esc_attr($coin_id) . '">' . $coin_price_html . '</div></li>
            <li  class="c_info"><strong>' . __('Market Cap', 'ccpw') . '</strong>
            <div class="coin_market_cap"><span class="CCMC">' . esc_html($fiat_symbol) . esc_html(ccpw_nice_number($market_cap)) . '</span></div></li>
            </ul></div>';

        $chart_html .= '<div id="ccpw-default-chart-' . esc_attr($coin_id) . '-'.$unique_id.'" class="ccpw-default-chart"></div>';

        $chart_html .= '<div class="chart-wrp"  id="CCPW-CHART-' . esc_attr($coin_id) . '-'.$unique_id.'" style="width:100%; height:' . esc_attr($c_height) . ';" >';
        $chart_html .= $chart_cont;
        $chart_html .= '<img class="ccpw-preloader" src="' . CCPWP_URL . 'images/chart-loading.svg"><span class="ccpw-no-data"></span>
</div>';

    }
}
