<?php
if (!defined('ABSPATH')) {
    exit;
}

$donation_design_type = get_post_meta($post_id, 'donation_box_type', true);
$donation_main_title = get_post_meta($post_id, 'donation_main_title', true);
$donation_main_description = get_post_meta($post_id, 'donation_main_description', true);
$donation_meta_amount = get_post_meta($post_id, 'donation_meta_amount', true);
$donation_meta_title = get_post_meta($post_id, 'donation_meta_title', true);
$donation_meta_description = get_post_meta($post_id, 'donation_meta_description', true);
$wallet_data = get_post_meta($post_id, 'donation_group_data', true); // all wallet data
$success_msg = get_post_meta($post_id, 'donation_meta_success', true);
$success_msg = !empty($success_msg) ? $success_msg : __('Thank you for your generous contribution. We are delighted to inform you that your transaction has been successfully confirmed.', 'ccpw');

$get_meta_symbol = donation_supported_coins_meta();

$main_title = !empty($donation_main_title) ? $donation_main_title : __('Donate [coin-name] to this address', 'ccpw');
$description = !empty($donation_main_description) ? $donation_main_description : __('Scan the QR code or copy the address below into your wallet to send some [coin-name]', 'ccpw');
$metamask_amount = ($donation_meta_amount == false) ? "0.005" : $donation_meta_amount;
$metamask_title = !empty($donation_meta_title) ? $donation_meta_title : __('Donate With MetaMask', 'ccpw');
$metamask_description = !empty($donation_meta_description) ? $donation_meta_description : '';
$enabledCurrency = array();
$popularCurrency = array();

$error = '';
$names = donation_supported_coins_meta();
$wallet_logo = CCPWP_URL . 'assets/';
if (is_array($wallet_data)) {
    foreach ($wallet_data as $key => $value) {
        if ($value['coin_type'] == "coin_type_metamask" && !empty($value['meta_wallet_address']) && strlen($value['meta_wallet_address']) == "42") {
            $coin_info = explode("_", $value['meta_coin']);
            $contract = ccpwp_donation_get_contract($value['meta_coin']);
            $image_url = ccpwp_coin_logo_html($coin_info[1], 32, false);

            $enabledCurrency[$value['meta_coin']] = array('symbol' => $names[$value['meta_coin']], 'price' => $metamask_amount, 'url' => $image_url, 'network' => $coin_info[0], 'address' => $value['meta_wallet_address'], 'contract' => $contract);
        }
        $popularCurrency[] = array('logo' => isset($value['coin']) ? ccpwp_coin_logo_html($value['coin'], 32, false) : false, 'coin_type' => $value['coin_type'], 'coin' => isset($value['coin']) ? $value['coin'] : null, 'wallet_address' => isset($value['wallet_address']) ? $value['wallet_address'] : null, 'tag_note' => isset($value['tag_note']) ? $value['tag_note'] : null);

    }}
$wallet_data = $popularCurrency;

$data = array(
    'type' => $type,
    'walletDataMeta' => $enabledCurrency,
    'amount' => $metamask_amount,
    'title' => $metamask_title,
    'description' => $metamask_description,
    'logo' => $wallet_logo,
    'post_id' => $post_id,
    'donationDesignType' => $donation_design_type,
    'walletData' => $wallet_data,
    'main_title' => $main_title,
    'main_desc' => $description,
    'successMsg' => $success_msg,
    'ccpwp_url' => CCPWP_URL,
);
$random_id = rand();
$output = "<div class=\"ccpw_react_widget\" id=\"ccpw_react_widgets_" . $post_id . $random_id . "\" data-attribute='" . json_encode($data) . "'></div>";
