/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/CustomerInfoModal.tsx":
/*!*********************************************************************************************************!*\
  !*** ./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/CustomerInfoModal.tsx ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @dokan/components */ "@dokan/components");
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_dokan_components__WEBPACK_IMPORTED_MODULE_3__);




const CustomerInfoModal = ({
  isOpen,
  onClose,
  onSave,
  customer
}) => {
  const [formData, setFormData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({
    id: 0,
    name: '',
    email: '',
    phone: '',
    company: ''
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (customer) {
      setFormData(customer);
    }
  }, [customer]);
  const handleChange = (field, value) => {
    setFormData({
      ...formData,
      [field]: value
    });
  };
  const handleSave = () => {
    onSave(formData);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_3__.DokanModal, {
    isOpen: isOpen,
    onClose: onClose,
    className: "w-[620px]",
    namespace: "customer-info-modal",
    onConfirm: handleSave,
    dialogTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Editing Customer Information', 'dokan'),
    confirmButtonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Update', 'dokan'),
    cancelButtonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Cancel', 'dokan'),
    dialogContent: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "space-y-4"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Quote user', 'dokan'), ' ', (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "text-red-500"
    }, "(Required)")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      type: "text",
      value: formData.name,
      onChange: e => handleChange('name', e.target.value),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Mr. John Doe', 'dokan'),
      className: "w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Full Name', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      type: "text",
      value: formData.name,
      onChange: e => handleChange('name', e.target.value),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Mr. John Doe', 'dokan'),
      className: "w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Email', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      type: "email",
      value: formData.email,
      onChange: e => handleChange('email', e.target.value),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('udbyfunni@gmail.com', 'dokan'),
      className: "w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Company Name', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      type: "text",
      value: formData.company,
      onChange: e => handleChange('company', e.target.value),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Write here', 'dokan'),
      className: "w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Phone Number', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      type: "tel",
      value: formData.phone,
      onChange: e => handleChange('phone', e.target.value),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('e.g +1 555-123-4567', 'dokan'),
      className: "w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
    })))
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomerInfoModal);

/***/ }),

/***/ "./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/HeaderCard.tsx":
/*!**************************************************************************************************!*\
  !*** ./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/HeaderCard.tsx ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var tailwind_merge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tailwind-merge */ "./node_modules/tailwind-merge/dist/bundle-mjs.mjs");


const Card = ({
  active,
  icon,
  title,
  href,
  redirectTo
}) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
  className: (0,tailwind_merge__WEBPACK_IMPORTED_MODULE_1__.twMerge)('flex items-center gap-3 rounded-lg border p-3 !bg-white transition h-20 w-80 hover:border-[#7047EB] hover:shadow', active ? 'border-[#7047EB] shadow' : 'border-gray-200'),
  href: `#${href.replace(/^#/, '')}`,
  onClick: e => {
    e.preventDefault();
    redirectTo(href);
  }
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
  className: (0,tailwind_merge__WEBPACK_IMPORTED_MODULE_1__.twMerge)('w-10 h-10 rounded-md flex items-center justify-center border hover:bg-[#EFEAFF] hover:text-[#7047EB] hover:border-[#CEBEFC]', active ? 'bg-[#EFEAFF] text-[#7047EB] border-[#CEBEFC]' : 'bg-[#F8F9F8] text-[#828282] border-[#E9E9E9]')
}, icon), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
  className: "text-sm font-semibold text-[#25252D]"
}, title));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Card);

/***/ }),

/***/ "./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/HeaderSection.tsx":
/*!*****************************************************************************************************!*\
  !*** ./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/HeaderSection.tsx ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/plus.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/settings.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/shopping-bag.js");
/* harmony import */ var _HeaderCard__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./HeaderCard */ "./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/HeaderCard.tsx");




const HeaderSection = ({
  active
}) => {
  const redirectTo = hashPath => {
    if (hashPath.startsWith('#')) {
      window.location.hash = hashPath;
    } else {
      window.location.hash = `#${hashPath.replace(/^#/, '')}`;
    }
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between mb-6"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_HeaderCard__WEBPACK_IMPORTED_MODULE_5__["default"], {
    redirectTo: redirectTo,
    active: active !== 'rules',
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_4__["default"], {
      size: 24
    }),
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Quote List', 'dokan'),
    href: "/request-for-quote"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_HeaderCard__WEBPACK_IMPORTED_MODULE_5__["default"], {
    redirectTo: redirectTo,
    active: active !== 'quotes',
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_3__["default"], {
      size: 24
    }),
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Quote Rules List', 'dokan'),
    href: "/request-for-quote/quote-rules"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: active !== 'rules' ? '#/request-for-quote/add-new-quote' : '#/request-for-quote/add-new-rule',
    className: "skip-color-module inline-flex items-center gap-2.5 rounded-md bg-[#7047EB] hover:bg-primary-700 text-white px-6 py-3 text-sm"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_2__["default"], {
    size: 16
  }), ' ', active !== 'rules' ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('New Quote', 'dokan') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('New Quote Rules', 'dokan')));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeaderSection);

/***/ }),

/***/ "./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/ShippingDetailsModal.tsx":
/*!************************************************************************************************************!*\
  !*** ./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/ShippingDetailsModal.tsx ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @dokan/components */ "@dokan/components");
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_dokan_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);




const ShippingDetailsModal = ({
  isOpen,
  onClose,
  onSave,
  shippingDetails
}) => {
  const [formData, setFormData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({
    country: '',
    state_name: '',
    address_line_1: '',
    address_line_2: '',
    post_code: '',
    expected_delivery: ''
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (shippingDetails) {
      setFormData(shippingDetails);
    }
  }, [shippingDetails]);
  const handleChange = (field, value) => {
    setFormData({
      ...formData,
      [field]: value
    });
  };
  const handleSave = () => {
    onSave(formData);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_2__.DokanModal, {
    isOpen: isOpen,
    onClose: onClose,
    className: "w-[620px]",
    namespace: "shipping-details-modal",
    dialogTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Editing Shipping Details', 'dokan'),
    onConfirm: handleSave,
    confirmButtonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Update', 'dokan'),
    cancelButtonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Cancel', 'dokan'),
    dialogContent: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "space-y-4"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Country', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("select", {
      value: formData.country,
      onChange: e => handleChange('country', e.target.value),
      className: "w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      value: ""
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Select country', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      value: "BD"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Bangladesh', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      value: "US"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('United States', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      value: "CA"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Canada', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      value: "GB"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('United Kingdom', 'dokan')))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('State', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("select", {
      value: formData.state_name,
      onChange: e => handleChange('state_name', e.target.value),
      className: "w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      value: ""
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Select state', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      value: "Dhaka"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Dhaka', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      value: "CA"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('California', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      value: "NY"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('New York', 'dokan')))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Address Line 1', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      type: "text",
      value: formData.address_line_1,
      onChange: e => handleChange('address_line_1', e.target.value),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Road, Area etc', 'dokan'),
      className: "w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Address Line 2', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      type: "text",
      value: formData.address_line_2,
      onChange: e => handleChange('address_line_2', e.target.value),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Apartment, Suite etc', 'dokan'),
      className: "w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "block text-sm font-medium text-gray-700 mb-1"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Expected Delivery Date', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      type: "date",
      value: formData.expected_delivery,
      onChange: e => handleChange('expected_delivery', e.target.value),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('e.g 10', 'dokan'),
      className: "w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
    })))
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ShippingDetailsModal);

/***/ }),

/***/ "./modules/request-for-quotation/assets/src/js/admin-panel/index.tsx":
/*!***************************************************************************!*\
  !*** ./modules/request-for-quotation/assets/src/js/admin-panel/index.tsx ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _scss_style_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./scss/style.scss */ "./modules/request-for-quotation/assets/src/js/admin-panel/scss/style.scss");
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/dom-ready */ "@wordpress/dom-ready");
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _pages_AddNewQuote__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pages/AddNewQuote */ "./modules/request-for-quotation/assets/src/js/admin-panel/pages/AddNewQuote.tsx");
/* harmony import */ var _pages_RequestQuoteList__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./pages/RequestQuoteList */ "./modules/request-for-quotation/assets/src/js/admin-panel/pages/RequestQuoteList.tsx");
/* harmony import */ var _pages_QuoteRulesList__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./pages/QuoteRulesList */ "./modules/request-for-quotation/assets/src/js/admin-panel/pages/QuoteRulesList.tsx");
/* harmony import */ var _pages_AddNewQuoteRule__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./pages/AddNewQuoteRule */ "./modules/request-for-quotation/assets/src/js/admin-panel/pages/AddNewQuoteRule.tsx");







_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_2___default()(() => {
  // @ts-ignore
  wp.hooks.addFilter('dokan-admin-dashboard-routes', 'dokan-admin-request-quote-panel', routes => {
    routes.push({
      id: 'request-quote',
      element: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_pages_RequestQuoteList__WEBPACK_IMPORTED_MODULE_4__["default"], null),
      path: '/request-for-quote'
    });
    routes.push({
      id: 'request-quote-rules-list',
      element: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_pages_QuoteRulesList__WEBPACK_IMPORTED_MODULE_5__["default"], null),
      path: '/request-for-quote/quote-rules'
    });
    routes.push({
      id: 'request-new-quote',
      element: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_pages_AddNewQuote__WEBPACK_IMPORTED_MODULE_3__["default"], null),
      path: '/request-for-quote/add-new-quote'
    });
    routes.push({
      id: 'add-new-quote-rule',
      element: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_pages_AddNewQuoteRule__WEBPACK_IMPORTED_MODULE_6__["default"], null),
      path: '/request-for-quote/add-new-rule'
    });
    routes.push({
      id: 'edit-quote-rule',
      element: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_pages_AddNewQuoteRule__WEBPACK_IMPORTED_MODULE_6__["default"], null),
      path: '/request-for-quote/edit-quote-rule/:id'
    });
    return routes;
  });
});

/***/ }),

/***/ "./modules/request-for-quotation/assets/src/js/admin-panel/pages/AddNewQuote.tsx":
/*!***************************************************************************************!*\
  !*** ./modules/request-for-quotation/assets/src/js/admin-panel/pages/AddNewQuote.tsx ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/calendar.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/chevron-left.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/landmark.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/mail.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/map-pin.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/phone.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/plus.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/search.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/store.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/trash-2.js");
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @dokan/components */ "@dokan/components");
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_dokan_components__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _dokan_utilities__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @dokan/utilities */ "@dokan/utilities");
/* harmony import */ var _dokan_utilities__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_dokan_utilities__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _components_Common_CustomerInfoModal__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../components/Common/CustomerInfoModal */ "./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/CustomerInfoModal.tsx");
/* harmony import */ var _components_Common_ShippingDetailsModal__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../components/Common/ShippingDetailsModal */ "./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/ShippingDetailsModal.tsx");
/* harmony import */ var _getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @getdokan/dokan-ui */ "./node_modules/@getdokan/dokan-ui/dist/index.js");










const AddNewQuote = () => {
  const [quoteTitle, setQuoteTitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  const [selectedVendor, setSelectedVendor] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
  const [selectedCustomer, setSelectedCustomer] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
  const [shippingDetails, setShippingDetails] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({
    country: '',
    state_name: '',
    address_line_1: '',
    address_line_2: '',
    post_code: '',
    expected_delivery: ''
  });
  const [products, setProducts] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const [selectedProduct, setSelectedProduct] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
  const [shippingCost, setShippingCost] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(0);
  const [isCustomerModalOpen, setIsCustomerModalOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const [isShippingModalOpen, setIsShippingModalOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const [isSubmitting, setIsSubmitting] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const [errors, setErrors] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const shippingAddress = shippingDetails?.address_line_1 || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('None', 'dokan');
  const handleAddProduct = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    if (selectedProduct) {
      const newProduct = {
        id: selectedProduct.value,
        name: selectedProduct.label,
        image: selectedProduct.raw?.images?.[0]?.src || '',
        price: Number(selectedProduct.raw?.price) || 0,
        quantity: 1,
        offer_price: Number(selectedProduct.raw?.price) || 0
      };
      setProducts([...products, newProduct]);
      setSelectedProduct(null);
    }
  }, [selectedProduct, products]);
  const handleRemoveProduct = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(index => {
    setProducts(products.filter((_, i) => i !== index));
  }, [products]);
  const handleQuantityChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)((index, quantity) => {
    const updatedProducts = [...products];
    updatedProducts[index].quantity = quantity;
    setProducts(updatedProducts);
  }, [products]);
  const handleOfferPriceChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)((index, price) => {
    const updatedProducts = [...products];
    updatedProducts[index].offer_price = price;
    setProducts(updatedProducts);
  }, [products]);
  const calculateSubtotal = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    return products.reduce((sum, product) => {
      return sum + product.offer_price * product.quantity;
    }, 0);
  }, [products]);
  const handleSaveCustomer = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(customer => {
    setSelectedCustomer(customer);
    setIsCustomerModalOpen(false);
  }, []);
  const handleSaveShipping = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(shipping => {
    setShippingDetails(shipping);
    setIsShippingModalOpen(false);
  }, []);
  const validate = () => {
    const errs = [];
    if (!quoteTitle.trim()) errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Quote Title is required.', 'dokan'));
    if (!selectedVendor?.value) errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Vendor is required.', 'dokan'));
    if (!selectedCustomer?.id) errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customer is required.', 'dokan'));
    if (products.length === 0) errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('At least one product is required.', 'dokan'));
    products.forEach((p, i) => {
      if (p.quantity <= 0) errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Quantity must be greater than 0 for row #%d', 'dokan'), i + 1));
      if (p.offer_price < 0) errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Offer price cannot be negative for row #%d', 'dokan'), i + 1));
    });
    if (selectedCustomer) {
      if (!selectedCustomer.name?.trim()) errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customer full name is required.', 'dokan'));
      if (!selectedCustomer.email?.trim()) errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customer email is required.', 'dokan'));
    }
    if (shippingCost < 0) errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Shipping cost cannot be negative.', 'dokan'));
    setErrors(errs);
    return errs.length === 0;
  };
  const handleCreateQuote = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async (status = 'publish') => {
    if (!validate()) return;
    try {
      setIsSubmitting(true);
      const payload = {
        quote_title: quoteTitle.trim(),
        status,
        user_id: selectedCustomer.id,
        store_info: {
          store_id: selectedVendor.value
        },
        customer_info: {
          name_field: selectedCustomer.name || '',
          email_field: selectedCustomer.email || '',
          company_field: selectedCustomer.company || '',
          phone_field: selectedCustomer.phone || '',
          post_code: shippingDetails.post_code || '',
          addr_line_1: shippingDetails.address_line_1 || '',
          addr_line_2: shippingDetails.address_line_2 || ''
        },
        country: shippingDetails.country || '',
        state_name: shippingDetails.state_name || '',
        shipping_cost: Number(shippingCost) || 0,
        product_ids: products.map(p => p.id),
        offer_product_quantity: products.map(p => p.quantity),
        offer_price: products.map(p => Number(p.offer_price) || 0)
      };
      const res = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
        path: 'dokan/v1/request-for-quote',
        method: 'POST',
        data: payload
      });

      // On success, redirect to list for now
      window.location.hash = '#/request-for-quote';
    } catch (e) {
      const msg = e?.message || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Failed to create quote.', 'dokan');
      setErrors(prev => [...prev, msg]);
    } finally {
      setIsSubmitting(false);
    }
  }, [quoteTitle, selectedVendor, selectedCustomer, products, shippingDetails, shippingCost]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wrap"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between mb-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: "#/request-for-quote",
    className: "flex items-center gap-1 text-sm text-[#828282] hover:text-[#7047EB] mb-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_5__["default"], {
    size: 16
  }), ' ', (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Request for Quotation', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", {
    className: "text-2xl font-semibold"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Add New Quote', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: "#/request-for-quote",
    className: "px-4 py-2 text-gray-700 bg-white border border-gray-300 rounded hover:bg-gray-50"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Cancel', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => handleCreateQuote('draft'),
    className: "px-4 py-2 text-purple-700 bg-purple-50 border border-purple-200 rounded hover:bg-purple-100",
    disabled: isSubmitting
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Save as Draft', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => handleCreateQuote('publish'),
    className: "px-4 py-2 text-white bg-purple-600 rounded hover:bg-purple-700 flex items-center gap-2",
    disabled: isSubmitting
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Create Quote', 'dokan')))), errors.length > 0 && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mb-4 p-4 bg-red-50 border border-red-200 rounded text-red-700"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
    className: "list-disc list-inside text-sm"
  }, errors.map((err, i) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    key: i
  }, err)))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-6"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex-1"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white p-7 rounded-lg shadow mb-6 space-y-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "dokan-quote-title"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "dokan-rfq-quote-title",
    className: "block text-sm font-medium text-[#25252D] mb-2.5"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Quote Title', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_18__.SimpleInput, {
    className: "focus:outline-0",
    onChange: e => setQuoteTitle(e.target.value),
    input: {
      type: 'text',
      value: quoteTitle,
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Write here', 'dokan')
    },
    disabled: isSubmitting
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "dokan-quote-vendor"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    className: "block text-sm font-medium text-[#25252D] mb-2.5"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Select Vendor', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_14__.VendorAsyncSelect, {
    value: selectedVendor,
    onChange: setSelectedVendor,
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Search Vendor', 'dokan'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_12__["default"], {
      size: 16
    }),
    iconPosition: "left",
    isClearable: true,
    defaultOptions: true
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white p-6 rounded-lg shadow"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between mb-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-lg font-semibold"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Products', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mb-4 flex gap-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex-1"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_14__.ProductAsyncSelect, {
    value: selectedProduct,
    onChange: setSelectedProduct,
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Search Product', 'dokan'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_11__["default"], {
      size: 16
    }),
    iconPosition: "left",
    isClearable: true,
    defaultOptions: true,
    extraQuery: {
      vendor_id: selectedVendor?.value
    }
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: handleAddProduct,
    className: "px-4 py-2 text-white bg-purple-600 rounded hover:bg-purple-700",
    disabled: !selectedProduct
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_10__["default"], {
    size: 16
  }))), products.length === 0 && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-center py-8 text-gray-500"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_11__["default"], {
    size: 48,
    className: "mx-auto mb-2 opacity-50"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('No products added yet', 'dokan')))), products.length > 0 && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "border border-gray-200 rounded"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("table", {
    className: "w-full"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("thead", {
    className: "bg-gray-50"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("tr", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("th", {
    className: "px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Products & Cost', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("th", {
    className: "px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('QTY.', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("th", {
    className: "px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Offer Price', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("th", {
    className: "px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Subtotal', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("th", {
    className: "px-4 py-3"
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("tbody", {
    className: "divide-y divide-gray-200"
  }, products.map((product, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("tr", {
    key: index
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", {
    className: "px-4 py-3"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-3"
  }, product.image && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: product.image,
    alt: product.name,
    className: "w-12 h-12 object-cover rounded"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "font-medium text-purple-600"
  }, product.name), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-sm text-gray-500"
  }, "$", product.price)))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", {
    className: "px-4 py-3"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "number",
    min: "1",
    value: product.quantity,
    onChange: e => handleQuantityChange(index, parseInt(e.target.value) || 1),
    className: "w-20 px-2 py-1 border border-gray-300 rounded"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", {
    className: "px-4 py-3"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "mr-1"
  }, "$"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "number",
    min: "0",
    step: "0.01",
    value: product.offer_price,
    onChange: e => handleOfferPriceChange(index, parseFloat(e.target.value) || 0),
    className: "w-24 px-2 py-1 border border-gray-300 rounded"
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", {
    className: "px-4 py-3"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "font-medium"
  }, "$", (product.offer_price * product.quantity).toFixed(2))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", {
    className: "px-4 py-3"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => handleRemoveProduct(index),
    className: "text-red-600 hover:text-red-800"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_13__["default"], {
    size: 16
  }))))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-4 border-t border-gray-200"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex justify-between items-center mb-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-sm text-gray-600"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Shipping Cost', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "mr-1"
  }, "$"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "number",
    min: "0",
    step: "0.01",
    value: shippingCost,
    onChange: e => setShippingCost(parseFloat(e.target.value) || 0),
    className: "w-24 px-2 py-1 border border-gray-300 rounded"
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex justify-between items-center pt-2 border-t border-gray-200"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "font-semibold"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Subtotal', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "font-semibold text-lg"
  }, "$", (calculateSubtotal() + shippingCost).toFixed(2))))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-80"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white rounded-lg shadow"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-5 border-b border-gray-200 space-y-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-lg font-semibold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customer Information', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_14__.CustomerAsyncSelect, {
    value: selectedCustomer ? {
      value: selectedCustomer.id,
      label: selectedCustomer.name,
      raw: selectedCustomer
    } : null,
    onChange: opt => {
      if (opt) {
        setSelectedCustomer({
          id: opt.value,
          name: opt.label,
          email: opt.raw?.email || '',
          phone: opt.raw?.phone || selectedCustomer?.phone || '',
          company: opt.raw?.company || selectedCustomer?.company || ''
        });
      } else {
        setSelectedCustomer(null);
      }
    },
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Select Customer', 'dokan'),
    isClearable: true,
    defaultOptions: true
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-5 border-b border-gray-200 space-y-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "text-sm font-semibold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Overview', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => setIsCustomerModalOpen(true),
    className: "text-[#7047EB] text-sm font-medium hover:underline"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Edit', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-2.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "min-w-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], {
    size: 16,
    color: '#7C7C7C'
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-sm text-[#828282]"
  }, selectedCustomer?.email || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Email', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-2.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "min-w-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_9__["default"], {
    size: 16,
    color: '#7C7C7C'
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-sm text-[#828282]"
  }, selectedCustomer?.phone || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Phone Number', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-2.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "min-w-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
    size: 16,
    color: '#7C7C7C'
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-sm text-[#828282]"
  }, selectedCustomer?.company || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Company Name', 'dokan'))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-5 space-y-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "text-sm font-semibold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Shipping Details', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => setIsShippingModalOpen(true),
    className: "text-[#7047EB] text-sm font-medium hover:underline"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Edit', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-2.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "min-w-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_8__["default"], {
    size: 16,
    color: '#7C7C7C'
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-sm text-[#828282]"
  }, shippingAddress?.length <= 22 ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.RawHTML, null, shippingAddress) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_14__.DokanTooltip, {
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.RawHTML, null, shippingAddress)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.RawHTML, null, _dokan_utilities__WEBPACK_IMPORTED_MODULE_15__.truncate ? (0,_dokan_utilities__WEBPACK_IMPORTED_MODULE_15__.truncate)(shippingAddress, 22) : shippingAddress))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-2.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "min-w-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_4__["default"], {
    size: 16,
    color: '#7C7C7C'
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-sm text-[#828282]"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Expected Delivery on', 'dokan')), shippingDetails.expected_delivery && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, shippingDetails.expected_delivery)))))))), isCustomerModalOpen && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Common_CustomerInfoModal__WEBPACK_IMPORTED_MODULE_16__["default"], {
    isOpen: isCustomerModalOpen,
    onClose: () => setIsCustomerModalOpen(false),
    onSave: handleSaveCustomer,
    customer: selectedCustomer
  }), isShippingModalOpen && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Common_ShippingDetailsModal__WEBPACK_IMPORTED_MODULE_17__["default"], {
    isOpen: isShippingModalOpen,
    onClose: () => setIsShippingModalOpen(false),
    onSave: handleSaveShipping,
    shippingDetails: shippingDetails
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddNewQuote);

/***/ }),

/***/ "./modules/request-for-quotation/assets/src/js/admin-panel/pages/AddNewQuoteRule.tsx":
/*!*******************************************************************************************!*\
  !*** ./modules/request-for-quotation/assets/src/js/admin-panel/pages/AddNewQuoteRule.tsx ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/chevron-left.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/info.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/x.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @dokan/components */ "@dokan/components");
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_dokan_components__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @getdokan/dokan-ui */ "./node_modules/@getdokan/dokan-ui/dist/index.js");
/* harmony import */ var tailwind_merge__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tailwind-merge */ "./node_modules/tailwind-merge/dist/bundle-mjs.mjs");









const AddNewQuoteRule = ({
  params
}) => {
  const id = parseInt(params?.id || 0);
  const isEditMode = !!id;
  const [rule, setRule] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({
    rule_name: '',
    store_ids: [],
    product_ids: [],
    category_ids: [],
    hide_price: 1,
    expire_limit: 30,
    hide_price_text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Price is hidden', 'dokan'),
    button_text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Add to quote', 'dokan'),
    rule_priority: 0,
    hide_cart_button: 'replace',
    exclude_store_ids: [],
    selected_user_role: [],
    exclude_product_ids: [],
    apply_on_all_product: 0,
    switches: {
      vendor_switch: false,
      expire_switch: false,
      product_switch: false,
      category_switch: false
    }
  });
  const [allRoles, setAllRoles] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
  const [categories, setCategories] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const [isSubmitting, setIsSubmitting] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const [errors, setErrors] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const [selectedProducts, setSelectedProducts] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const [selectedExcludeProducts, setSelectedExcludeProducts] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const [showProductsDropdown, setShowProductsDropdown] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(true);

  // Fetch roles
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
      path: '/dokan/v1/request-for-quote/roles'
    }).then(response => {
      const roles = {
        ...response.role_names,
        dokan_wholesale_customer: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Wholesale customer', 'dokan'),
        guest: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Guest', 'dokan')
      };
      setAllRoles(roles);
    }).catch(console.error);
  }, []);

  // Fetch categories
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
      path: '/dokan/v1/products/multistep-categories'
    }).then(response => {
      const cats = [];
      Object.values(response).forEach(item => {
        if (item.parent_id != 0) return;
        const catData = {
          id: Number(item.term_id),
          name: item.name,
          hasChildren: false
        };
        if (item.children?.length > 0) {
          catData.hasChildren = true;
          catData.children = getChildCategories(response, item.children);
        }
        cats.push(catData);
      });
      setCategories(cats);
    }).catch(console.error);
  }, []);

  // Fetch rule data if editing
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (isEditMode && id) {
      _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
        path: `/dokan/v1/request-for-quote/quote-rule/${id}`
      }).then(response => {
        setRule({
          ...response,
          hide_price: parseInt(response.hide_price),
          apply_on_all_product: parseInt(response.apply_on_all_product),
          store_ids: response.store_ids?.map(store => ({
            id: store.store_id,
            name: store.store_name
          })) || [],
          exclude_store_ids: response.exclude_store_ids?.map(store => ({
            id: store.store_id,
            name: store.store_name
          })) || [],
          switches: {
            vendor_switch: response.switches?.vendor_switch === 'true' || response.switches?.vendor_switch === true,
            expire_switch: response.switches?.expire_switch === 'true' || response.switches?.expire_switch === true,
            product_switch: response.switches?.product_switch === 'true' || response.switches?.product_switch === true,
            category_switch: response.switches?.category_switch === 'true' || response.switches?.category_switch === true
          }
        });
        if (response.apply_on_all_product) {
          setShowProductsDropdown(false);
        }
      }).catch(console.error);
    }
  }, [isEditMode, id]);
  const getChildCategories = (data, children) => {
    return children.map(item => {
      const childCategory = {
        id: Number(data[item].term_id),
        name: data[item].name,
        hasChildren: false
      };
      if (data[item].children?.length > 0) {
        childCategory.hasChildren = true;
        childCategory.children = getChildCategories(data, data[item].children);
      }
      return childCategory;
    });
  };
  const handleRoleChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(roleKey => {
    setRule(prev => ({
      ...prev,
      selected_user_role: prev.selected_user_role.includes(roleKey) ? prev.selected_user_role.filter(r => r !== roleKey) : [...prev.selected_user_role, roleKey]
    }));
  }, []);
  const handleCategoryChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(categoryId => {
    setRule(prev => ({
      ...prev,
      category_ids: prev.category_ids.includes(categoryId) ? prev.category_ids.filter(c => c !== categoryId) : [...prev.category_ids, categoryId]
    }));
  }, []);
  const renderCategoryTree = (cats, depth = 0) => {
    return cats.map(cat => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "space-y-5",
      key: cat.id,
      style: {
        marginLeft: `${depth * 28}px`
      }
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      className: "inline-flex items-center gap-1 py-1"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.SimpleCheckbox, {
      className: "m-0 focus:ring-0 w-[18px] h-[18px]",
      checked: rule.category_ids.includes(cat.id),
      onChange: () => handleCategoryChange(cat.id),
      input: {}
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "text-sm text-[#575757]"
    }, cat.name)), cat.children && renderCategoryTree(cat.children, depth + 1)));
  };
  const validateForm = () => {
    const errs = [];
    if (!rule.rule_name.trim()) {
      errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Please enter rule name.', 'dokan'));
    }
    if (rule.selected_user_role.length === 0) {
      errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Please select at least one user role.', 'dokan'));
    }
    if (!rule.hide_price_text.trim()) {
      errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Please enter hide price text.', 'dokan'));
    }
    if (!rule.button_text.trim()) {
      errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Please enter button text.', 'dokan'));
    }
    if (rule.switches.expire_switch) {
      const expireLimit = rule.expire_limit;
      if (isNaN(expireLimit) || expireLimit < 1 || !/^[1-9]\d*$/.test(String(expireLimit))) {
        errs.push((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Please enter a valid positive integer for quote expiration days limit.', 'dokan'));
      }
    }
    setErrors(errs);
    return errs.length === 0;
  };
  const handleSubmit = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async status => {
    if (!validateForm()) return;
    setIsSubmitting(true);
    const payload = {
      ...rule,
      status,
      product_ids: !rule.apply_on_all_product ? rule.product_ids.map(p => p.id) : [],
      exclude_product_ids: !rule.apply_on_all_product ? rule.exclude_product_ids.map(p => p.id) : [],
      store_ids: !rule.apply_on_all_product ? rule.store_ids.map(s => s.id) : [],
      exclude_store_ids: !rule.apply_on_all_product ? rule.exclude_store_ids.map(s => s.id) : [],
      category_ids: !rule.apply_on_all_product ? rule.category_ids : []
    };
    try {
      if (isEditMode && id) {
        await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
          path: `/dokan/v1/request-for-quote/quote-rule/${id}`,
          method: 'PUT',
          data: payload
        });
      } else {
        await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
          path: '/dokan/v1/request-for-quote/quote-rule',
          method: 'POST',
          data: payload
        });
      }
      window.location.hash = '#/request-for-quote/quote-rules';
    } catch (e) {
      const msg = e?.message || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Failed to save quote rule.', 'dokan');
      setErrors(prev => [...prev, msg]);
    } finally {
      setIsSubmitting(false);
    }
  }, [rule, isEditMode, id]);
  const handleProductSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(product => {
    if (product) {
      const newProduct = {
        id: product.value,
        name: product.label,
        imageObj: product?.raw?.images?.[0] || {}
      };
      setRule(prev => {
        // prevent duplicate in include
        const alreadyIncluded = prev.product_ids.some(p => String(p.id) === String(newProduct.id));
        const filteredExcluded = prev.exclude_product_ids.filter(p => String(p.id) !== String(newProduct.id));
        return {
          ...prev,
          product_ids: alreadyIncluded ? prev.product_ids : [...prev.product_ids, newProduct],
          exclude_product_ids: filteredExcluded
        };
      });
    }
  }, []);
  const handleExcludeProductSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(product => {
    if (product) {
      const newProduct = {
        id: product.value,
        name: product.label
      };
      setRule(prev => {
        // prevent duplicate in exclude
        const alreadyExcluded = prev.exclude_product_ids.some(p => String(p.id) === String(newProduct.id));
        const filteredIncluded = prev.product_ids.filter(p => String(p.id) !== String(newProduct.id));
        return {
          ...prev,
          exclude_product_ids: alreadyExcluded ? prev.exclude_product_ids : [...prev.exclude_product_ids, newProduct],
          product_ids: filteredIncluded
        };
      });
    }
  }, []);

  // Build loadOptions for product selects to exclude items already chosen in the opposite list
  const loadIncludeProductOptions = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async inputValue => {
    try {
      const data = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
        path: (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.addQueryArgs)('/dokan/v1/products', {
          search: inputValue || '',
          per_page: 20
        })
      });
      const excludeIds = new Set(rule.exclude_product_ids.map(p => String(p.id)));
      const selfIds = new Set(rule.product_ids.map(p => String(p.id)));
      return data.filter(product => {
        const id = String(product.id);
        // hide if present in exclude list or already included
        return !excludeIds.has(id) && !selfIds.has(id);
      }).map(product => ({
        value: product.id,
        label: product.name || `Product #${product.id}`,
        raw: product
      }));
    } catch (e) {
      return [];
    }
  }, [rule.exclude_product_ids, rule.product_ids]);
  const loadExcludeProductOptions = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async inputValue => {
    try {
      const data = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
        path: (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.addQueryArgs)('/dokan/v1/products', {
          search: inputValue || '',
          per_page: 20
        })
      });
      const includeIds = new Set(rule.product_ids.map(p => String(p.id)));
      const selfIds = new Set(rule.exclude_product_ids.map(p => String(p.id)));
      return data.filter(product => {
        const id = String(product.id);
        // hide if present in include list or already excluded
        return !includeIds.has(id) && !selfIds.has(id);
      }).map(product => ({
        value: product.id,
        label: product.name || `Product #${product.id}`,
        raw: product
      }));
    } catch (e) {
      return [];
    }
  }, [rule.product_ids, rule.exclude_product_ids]);
  const handleVendorSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(vendor => {
    if (vendor) {
      const newVendor = {
        id: vendor.value,
        name: vendor.label
      };
      setRule(prev => ({
        ...prev,
        store_ids: [...prev.store_ids, newVendor]
      }));
    }
  }, []);
  const handleExcludeVendorSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(vendor => {
    if (vendor) {
      const newVendor = {
        id: vendor.value,
        name: vendor.label
      };
      setRule(prev => ({
        ...prev,
        exclude_store_ids: [...prev.exclude_store_ids, newVendor]
      }));
    }
  }, []);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wrap"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between mb-4"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: "#/request-for-quote/quote-rules",
    className: "flex items-center gap-1 text-sm text-[#828282] hover:text-[#7047EB] mb-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_4__["default"], {
    size: 16
  }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Quote Rules', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", {
    className: "text-2xl font-semibold text-[#25252D]"
  }, isEditMode ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Edit Rule', 'dokan') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Add New Rules', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: "#/request-for-quote/quote-rules",
    className: "px-4 py-2 text-gray-700 bg-white border border-gray-300 rounded hover:bg-gray-50"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Cancel', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => handleSubmit('draft'),
    className: "px-4 py-2 text-purple-700 bg-purple-50 border border-purple-200 rounded hover:bg-purple-100",
    disabled: isSubmitting
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Save as Draft', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => handleSubmit('publish'),
    className: "px-4 py-2 text-white bg-[#7047EB] rounded hover:bg-purple-700",
    disabled: isSubmitting
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Publish', 'dokan')))), errors.length > 0 && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mb-4 p-4 bg-red-50 border border-red-200 rounded text-red-700"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
    className: "list-disc list-inside text-sm"
  }, errors.map((err, i) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    key: i
  }, err)))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex-1"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white p-7 rounded-lg shadow mb-5 space-y-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'space-y-2.5'
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "rule-name",
    className: "block text-sm font-medium text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Quote Rule Title', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.SimpleInput, {
    className: "p-4",
    onChange: e => setRule(prev => ({
      ...prev,
      rule_name: e.target.value
    })),
    input: {
      type: 'text',
      value: rule.rule_name,
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Title here', 'dokan')
    },
    disabled: isSubmitting
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white rounded-lg shadow mb-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-7 py-5 border-b border-gray-200"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-lg font-bold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Rule Setting', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-7 py-5 border-b border-gray-200"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm font-semibold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Apply on All Products', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-xs text-[#575757]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Apply this rule to all products in your catalog.', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.ToggleSwitch, {
    checked: rule.apply_on_all_product === 1,
    onChange: checked => {
      setRule(prev => ({
        ...prev,
        apply_on_all_product: checked ? 1 : 0
      }));
      setShowProductsDropdown(!checked);
    }
  }))), showProductsDropdown && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-7 py-5 border-b border-gray-200 space-y-3.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm font-semibold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Specific Products', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-xs text-[#575757]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Apply this rule to a selection of products.', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.ToggleSwitch, {
    checked: rule.switches.product_switch,
    onChange: checked => setRule(prev => ({
      ...prev,
      switches: {
        ...prev.switches,
        product_switch: checked
      }
    }))
  })), rule.switches.product_switch && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "quote-rule-included-product-selection-section"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "block text-sm text-[#575757] mb-1.5"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Include Products', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_8__.ProductAsyncSelect, {
    value: null,
    onChange: handleProductSelect,
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Search product', 'dokan'),
    isClearable: true,
    defaultOptions: true,
    loadOptions: loadIncludeProductOptions
  }), rule.product_ids.length > 0 && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-2 space-y-2"
  }, rule.product_ids.map((product, idx) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    key: idx,
    className: "flex items-center justify-between px-3.5 py-2 bg-[#E4E4EB] rounded border border-gray-200"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-3.5"
  }, product?.imageObj?.src && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-6 h-6 rounded overflow-hidden border border-[#E9E9E9]"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: product?.imageObj?.src,
    alt: product?.imageObj?.name
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-sm text-[#828282]"
  }, product.name)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => setRule(prev => ({
      ...prev,
      product_ids: prev.product_ids.filter((_, i) => i !== idx)
    })),
    className: "text-[#828282]"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
    size: 20,
    color: '#828282'
  })))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "quote-rule-excluded-product-selection-section"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "block text-sm text-[#575757] mb-1.5"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Exclude Products', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_8__.ProductAsyncSelect, {
    value: null,
    onChange: handleExcludeProductSelect,
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Search product', 'dokan'),
    isClearable: true,
    defaultOptions: true,
    loadOptions: loadExcludeProductOptions
  }), rule.exclude_product_ids.length > 0 && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-2 space-y-2"
  }, rule.exclude_product_ids.map((product, idx) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    key: idx,
    className: "flex items-center justify-between p-3 bg-[#E4E4EB] rounded border border-gray-200"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-3.5"
  }, product?.imageObj?.src && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-6 h-6 rounded overflow-hidden border border-[#E9E9E9]"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: product?.imageObj?.src,
    alt: product?.imageObj?.name
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-sm text-[#828282]"
  }, product.name)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => setRule(prev => ({
      ...prev,
      exclude_product_ids: prev.exclude_product_ids.filter((_, i) => i !== idx)
    })),
    className: "text-[#828282]"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
    size: 20,
    color: '#828282'
  })))))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-7 py-5 border-b border-gray-200"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: (0,tailwind_merge__WEBPACK_IMPORTED_MODULE_10__.twMerge)('flex items-center justify-between', rule.switches.category_switch && 'mb-4')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm font-semibold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Specific Categories', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-xs text-[#575757]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Apply this rule to products in select categories.', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.ToggleSwitch, {
    checked: rule.switches.category_switch,
    onChange: checked => setRule(prev => ({
      ...prev,
      switches: {
        ...prev.switches,
        category_switch: checked
      }
    }))
  })), rule.switches.category_switch && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "max-h-96 overflow-y-auto space-y-5"
  }, renderCategoryTree(categories))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-7 py-5 border-b border-gray-200 space-y-3.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm font-semibold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Specific Vendors', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-xs text-[#575757]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Apply this rule to products from specific vendors.', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.ToggleSwitch, {
    checked: rule.switches.vendor_switch,
    onChange: checked => setRule(prev => ({
      ...prev,
      switches: {
        ...prev.switches,
        vendor_switch: checked
      }
    }))
  })), rule.switches.vendor_switch && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "quote-rule-included-vendor-selection-section"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "block text-sm text-[#575757] mb-1.5"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Include Vendors', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_8__.VendorAsyncSelect, {
    value: null,
    onChange: handleVendorSelect,
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Type to search', 'dokan'),
    isClearable: true,
    defaultOptions: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-wrap gap-2"
  }, rule.store_ids.map((vendor, idx) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    key: idx,
    className: "inline-flex items-center gap-1 px-3 py-1 bg-blue-100 text-blue-700 rounded-full text-sm"
  }, vendor.name, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => setRule(prev => ({
      ...prev,
      store_ids: prev.store_ids.filter((_, i) => i !== idx)
    })),
    className: "ml-1 text-blue-600 hover:text-blue-800"
  }, "\xD7"))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "quote-rule-excluded-vendor-selection-section"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "block text-sm text-[#575757] mb-1.5"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Exclude Vendors', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_8__.VendorAsyncSelect, {
    value: null,
    onChange: handleExcludeVendorSelect,
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Type to search', 'dokan'),
    isClearable: true,
    defaultOptions: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-wrap gap-2"
  }, rule.exclude_store_ids.map((vendor, idx) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    key: idx,
    className: "inline-flex items-center gap-1 px-3 py-1 bg-red-100 text-red-700 rounded-full text-sm"
  }, vendor.name, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => setRule(prev => ({
      ...prev,
      exclude_store_ids: prev.exclude_store_ids.filter((_, i) => i !== idx)
    })),
    className: "ml-1 text-red-600 hover:text-red-800"
  }, "\xD7")))))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-7 py-5 border-b border-gray-200 space-y-3.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm font-semibold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Expire Limit', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-xs text-[#575757]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Quote remains valid for a set number of days after approval.', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.ToggleSwitch, {
    checked: rule.switches.expire_switch,
    onChange: checked => setRule(prev => ({
      ...prev,
      switches: {
        ...prev.switches,
        expire_switch: checked
      }
    }))
  })), rule.switches.expire_switch && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.SimpleInput, {
    addOnRight: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Days', 'dokan'),
    className: "focus:outline-0",
    onChange: e => setRule(prev => ({
      ...prev,
      expire_limit: parseInt(e.target.value) || 0
    })),
    input: {
      type: 'number',
      value: rule.expire_limit,
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Type expiration day', 'dokan'),
      min: 1
    }
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-7 py-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm font-semibold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Hide Price', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-xs text-[#575757]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Hide the price of products when this rule applies.', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.ToggleSwitch, {
    checked: rule.hide_price === 1,
    onChange: checked => {
      setRule(prev => ({
        ...prev,
        hide_price: checked ? 1 : 0,
        hide_cart_button: checked ? 'replace' : prev.hide_cart_button
      }));
    }
  })))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white rounded-lg shadow"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-7 py-5 border-b border-gray-200"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-lg font-bold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Add to Cart Button Customization', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "border-b border-gray-200"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-7 py-5 space-y-3.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "quote-rule-hide-cart-button",
    className: "text-sm font-semibold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Add to Cart Button Visibility', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.SimpleRadio, {
    name: "hide_cart_button",
    options: [{
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Replace Add to Cart button with a Quote Button', 'dokan'),
      value: 'replace'
    }, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Keep Add to Cart button and add a new Quote Button', 'dokan'),
      value: 'keep_and_add_new'
    }],
    value: rule.hide_cart_button,
    onChange: e => {
      setRule(prevState => {
        return {
          ...prevState,
          hide_cart_button: e.target.value
        };
      });
    }
    // disabled={ rule.hide_price === 1 }
    ,
    input: {
      type: 'radio',
      id: 'quote-rule-hide-cart-button'
    },
    optionClass: "p-0 first:h-8 block text-[#575757] text-sm !font-normal"
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-7 py-5 space-y-3.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "block text-sm font-semibold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Custom Button Label', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-xs text-[#575757]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Display the above label on custom button, e.g "Request a Quote"', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.SimpleInput, {
    className: "focus:outline-0 px-4",
    onChange: e => setRule(prev => ({
      ...prev,
      button_text: e.target.value
    })),
    input: {
      type: 'text',
      value: rule.button_text,
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Add to quote', 'dokan')
    }
  }))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-80"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white rounded-lg shadow mb-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-5 border-b border-[#E9E9E9]"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-lg font-bold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Apply quote for', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "max-h-96 overflow-y-auto space-y-3 p-5"
  }, allRoles && Object.entries(allRoles).map(([key, name]) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    key: key,
    className: "flex items-center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    className: "inline-flex items-center gap-1 py-1"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.SimpleCheckbox, {
    className: "m-0 focus:ring-0 w-[18px] h-[18px]",
    checked: rule.selected_user_role.includes(key),
    onChange: () => handleRoleChange(key),
    input: {}
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-sm text-[#575757]"
  }, name)))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "bg-white rounded-lg shadow"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-5 border-b border-[#E9E9E9]"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-lg font-bold text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Apply quote for', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-5 space-y-2.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center gap-2.5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "quote-rule-order",
    className: "text-sm font-medium text-[#25252D]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Order', 'dokan')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative group"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_5__["default"], {
    size: 16,
    className: "text-gray-400 cursor-help"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "invisible group-hover:visible absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 w-64 p-3 bg-gray-900 text-white text-xs rounded shadow-lg z-10"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Order Priority will be 0>1>2>3… Last one in the list will get priority when two (or more) rules have same priority 0,0,0…', 'dokan')))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_9__.SimpleInput, {
    className: "focus:outline-0",
    onChange: e => setRule(prev => ({
      ...prev,
      rule_priority: parseInt(e.target.value) || 0
    })),
    input: {
      type: 'number',
      id: 'quote-rule-order',
      value: rule.rule_priority,
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Rule order', 'dokan')
    }
  }))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddNewQuoteRule);

/***/ }),

/***/ "./modules/request-for-quotation/assets/src/js/admin-panel/pages/QuoteRulesList.tsx":
/*!******************************************************************************************!*\
  !*** ./modules/request-for-quotation/assets/src/js/admin-panel/pages/QuoteRulesList.tsx ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @dokan/components */ "@dokan/components");
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_dokan_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @getdokan/dokan-ui */ "./node_modules/@getdokan/dokan-ui/dist/index.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/search.js");
/* harmony import */ var _components_Common_HeaderSection__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../components/Common/HeaderSection */ "./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/HeaderSection.tsx");









const RULE_STATUS_STYLES = {
  publish: 'bg-[#D4FBEF] text-[#00563F]',
  published: 'bg-[#D4FBEF] text-[#00563F]',
  // legacy alias
  draft: 'bg-[#F1F1F4] text-[#393939]',
  trash: 'bg-[#F8E3E6] text-[#9F2225]',
  pending: 'bg-[#F8DDA7] text-[#94660C]',
  future: 'bg-[#E5E7EB] text-[#111827]',
  private: 'bg-[#E5E7EB] text-[#111827]'
};
const STATUS_LABELS = {
  publish: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Published', 'dokan'),
  draft: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Draft', 'dokan'),
  trash: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Trash', 'dokan'),
  pending: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Pending', 'dokan'),
  future: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Scheduled', 'dokan'),
  private: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Private', 'dokan')
};
const StatusPill = ({
  value
}) => {
  const label = STATUS_LABELS[value] || (value ? value.charAt(0).toUpperCase() + value.slice(1) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Draft', 'dokan'));
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: `inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium ${RULE_STATUS_STYLES[value] || 'bg-gray-100 text-gray-700'}`
  }, label);
};
const TABS = [{
  name: 'all',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('All', 'dokan')
}, {
  name: 'published',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Published', 'dokan')
}, {
  name: 'draft',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Draft', 'dokan')
}, {
  name: 'trash',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Trash', 'dokan')
}];
const QuoteRulesList = () => {
  const [data, setData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)([]);
  const [isLoading, setIsLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  const defaultLayouts = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => ({
    table: {
      density: 'comfortable'
    },
    grid: {},
    list: {}
  }), []);
  const [selection, setSelection] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)([]);
  const [totalItems, setTotalItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
  const [activeTab, setActiveTab] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('all');
  const [search, setSearch] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');
  const [statusCounts, setStatusCounts] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({
    all: 0,
    publish: 0,
    draft: 0,
    trash: 0
  });
  const fields = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => [{
    id: 'rules',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Rules', 'dokan'),
    render: ({
      item
    }) => {
      const ruleName = item?.rule_name || item?.title || item?.name || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('—', 'dokan');
      const ruleId = item?.id || item?.rule_id;
      const isTrash = item?.status === 'trash';
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex flex-col gap-1"
      }, isTrash ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "font-medium text-gray-900"
      }, ruleName) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        href: `#/request-for-quote/edit-quote-rule/${ruleId}`,
        className: "font-medium text-purple-600 hover:text-purple-800 hover:underline"
      }, ruleName), (item?.created_at || item?.date) && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "text-xs text-gray-500"
      }, item?.created_at || item?.date));
    }
  }, {
    id: 'status',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Status', 'dokan'),
    render: ({
      item
    }) => {
      var _ref, _item$status;
      const raw = (_ref = (_item$status = item?.status) !== null && _item$status !== void 0 ? _item$status : item?.post_status) !== null && _ref !== void 0 ? _ref : item?.rule_status;
      const normalized = (() => {
        const str = raw == null ? '' : String(raw).trim().toLowerCase();
        if (!str) return 'draft';
        if (str === 'published') return 'publish';
        return str;
      })();
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(StatusPill, {
        value: normalized
      });
    }
  }, {
    id: 'price_visibility',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Price Visibility', 'dokan'),
    render: ({
      item
    }) => {
      const hidden = item?.hide_price === 'Yes' || item?.hide_price === 1 || item?.hide_price === true;
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, hidden ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Hidden', 'dokan') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Visible', 'dokan'));
    }
  }, {
    id: 'priority',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Priority', 'dokan'),
    render: ({
      item
    }) => {
      var _ref2, _item$rule_priority;
      return String((_ref2 = (_item$rule_priority = item?.rule_priority) !== null && _item$rule_priority !== void 0 ? _item$rule_priority : item?.priority) !== null && _ref2 !== void 0 ? _ref2 : 0);
    }
  }], []);
  const filterFields = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => [{
    id: 'search',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Search', 'dokan'),
    render: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_6__.SimpleInput, {
      addOnLeft: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], {
        size: 16
      }),
      className: "border rounded px-3 py-1.5 w-full bg-white",
      input: {
        type: 'search',
        value: search,
        placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Search rules…', 'dokan'),
        onChange: e => setSearch(e.target.value)
      }
    })
  }], [search]);
  const tabs = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => TABS.map(t => {
    const countKey = t.name === 'published' ? 'publish' : t.name;
    const count = statusCounts[countKey] || 0;
    return {
      id: t.name,
      name: t.name,
      icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center gap-1.5 px-2"
      }, t.label, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "text-xs font-light text-[#A5A5AA]"
      }, "(", count, ")")),
      title: t.label
    };
  }), [statusCounts]);
  const [view, setView] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({
    perPage: 20,
    page: 1,
    search: '',
    type: 'table',
    status: 'all',
    layout: {
      density: 'comfortable'
    },
    fields: ['rules', 'status', 'price_visibility', 'priority']
  });
  const fetchData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)(async () => {
    setIsLoading(true);
    try {
      const apiStatus = activeTab === 'published' ? 'publish' : activeTab;
      const params = {
        page: view.page,
        per_page: view.perPage,
        status: apiStatus !== 'all' ? apiStatus : undefined,
        search: search || undefined
      };
      const path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_4__.addQueryArgs)('dokan/v1/request-for-quote/quote-rule', params);
      const response = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
        path,
        parse: false
      }).catch(() => null);
      if (response) {
        const items = await response.json().catch(() => []);
        setData(Array.isArray(items) ? items : []);
        const headers = response.headers;
        const totalFromHeader = parseInt(headers.get('X-WP-Total') || '0', 10);
        setTotalItems(totalFromHeader || (Array.isArray(items) ? items.length : 0));

        // Update status counts from response headers (fallbacks applied)
        const allCount = parseInt(headers.get('X-Status-All') || '0', 10);
        const publishCount = parseInt(headers.get('X-Status-Publish') || '0', 10);
        const draftCount = parseInt(headers.get('X-Status-Draft') || '0', 10);
        const trashCount = parseInt(headers.get('X-Status-Trash') || '0', 10);
        setStatusCounts({
          all: Number.isFinite(allCount) && allCount >= 0 ? allCount : Array.isArray(items) ? items.length : 0,
          publish: Number.isFinite(publishCount) && publishCount >= 0 ? publishCount : 0,
          draft: Number.isFinite(draftCount) && draftCount >= 0 ? draftCount : 0,
          trash: Number.isFinite(trashCount) && trashCount >= 0 ? trashCount : 0
        });
      } else {
        setData([]);
        setTotalItems(0);
        setStatusCounts({
          all: 0,
          publish: 0,
          draft: 0,
          trash: 0
        });
      }
    } finally {
      setIsLoading(false);
    }
  }, [view.page, view.perPage, activeTab, search]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    fetchData();
  }, [fetchData]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "dokan-rfq-admin-quote-rules-list p-2 md:p-0"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mb-6 flex items-center justify-between"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-2xl font-semibold text-gray-900"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Quote Rules List', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Common_HeaderSection__WEBPACK_IMPORTED_MODULE_8__["default"], {
    active: "rules"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_5__.AdminDataViews, {
    data: data,
    namespace: "rfq-quote-rules-list",
    defaultLayouts: {
      table: {
        perPage: 20,
        fields: ['quote', 'status', 'price_visibility', 'priority']
      }
    },
    fields: fields,
    getItemId: item => item?.id || item?.rule_id,
    onChangeView: setView,
    paginationInfo: {
      totalItems,
      totalPages: Math.max(1, Math.ceil(totalItems / view.perPage))
    },
    view: view,
    selection: selection,
    onChangeSelection: setSelection,
    isLoading: isLoading,
    tabs: {
      tabs,
      onSelect: tabName => {
        setActiveTab(tabName);
        setView(prev => ({
          ...prev,
          page: 1
        }));
      },
      initialTabName: activeTab
    },
    actions: [{
      id: 'trash',
      label: () => (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Trash', 'dokan'),
      supportsBulk: true,
      callback: async items => {
        const ids = items.map(i => i.id || i.rule_id);
        if (!ids.length) return;
        await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
          path: 'dokan/v1/request-for-quote/quote-rule/batch',
          method: 'POST',
          data: {
            trash: ids
          }
        }).catch(() => {});
        setSelection([]);
        fetchData();
      }
    }, {
      id: 'restore',
      label: () => (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Restore', 'dokan'),
      supportsBulk: true,
      callback: async items => {
        const ids = items.map(i => i.id || i.rule_id);
        if (!ids.length) return;
        await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
          path: 'dokan/v1/request-for-quote/quote-rule/batch',
          method: 'POST',
          data: {
            restore: ids
          }
        }).catch(() => {});
        setSelection([]);
        fetchData();
      }
    }, {
      id: 'delete',
      label: () => (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Delete Permanently', 'dokan'),
      supportsBulk: true,
      callback: async items => {
        const ids = items.map(i => i.id || i.rule_id);
        if (!ids.length) return;
        if (!window.confirm((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Delete selected rules permanently?', 'dokan'))) return;
        await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
          path: 'dokan/v1/request-for-quote/quote-rule/batch',
          method: 'POST',
          data: {
            delete: ids
          }
        }).catch(() => {});
        setSelection([]);
        fetchData();
      }
    }],
    filter: {
      fields: filterFields,
      onFilterRemove: () => {},
      onReset: () => {
        setSearch('');
        setActiveTab('all');
      }
    }
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (QuoteRulesList);

/***/ }),

/***/ "./modules/request-for-quotation/assets/src/js/admin-panel/pages/RequestQuoteList.tsx":
/*!********************************************************************************************!*\
  !*** ./modules/request-for-quotation/assets/src/js/admin-panel/pages/RequestQuoteList.tsx ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @dokan/components */ "@dokan/components");
/* harmony import */ var _dokan_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_dokan_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @getdokan/dokan-ui */ "./node_modules/@getdokan/dokan-ui/dist/index.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/calendar.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/search.js");
/* harmony import */ var _components_Common_HeaderSection__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../components/Common/HeaderSection */ "./modules/request-for-quotation/assets/src/js/admin-panel/components/Common/HeaderSection.tsx");










// Status pill helpers — colors provided in the issue
const STATUS_STYLES = {
  pending: 'bg-[#FAEDCD] text-[#8A610F]',
  converted: 'bg-[#D4FBEF] text-[#00563F]',
  accepted: 'bg-[#EFF6FF] text-[#2563EB]',
  cancelled: 'bg-[#F8E3E6] text-[#9F2225]',
  approved: 'bg-[#EFEAFF] text-[#461ACA]',
  expired: 'bg-[#F1F1F4] text-[#393939]',
  draft: 'bg-[#F1F1F4] text-[#393939]',
  trash: 'bg-[#F1F1F4] text-[#393939]',
  rejected: 'bg-[#FDF2F8] text-[#9D174D]',
  updated: 'bg-[#DBEAFE] text-[#2947BF]'
};
const StatusPill = ({
  value
}) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
  className: `inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium ${STATUS_STYLES[value] || 'bg-gray-100 text-gray-700'}`
}, value?.charAt(0).toUpperCase() + value?.slice(1));
const QUOTE_TABS = [{
  name: 'all',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('All', 'dokan')
}, {
  name: 'pending',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Pending', 'dokan')
}, {
  name: 'updated',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Updated', 'dokan')
}, {
  name: 'accepted',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Accepted', 'dokan')
}, {
  name: 'cancelled',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancelled', 'dokan')
}, {
  name: 'approved',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Approved', 'dokan')
}, {
  name: 'expired',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Expired', 'dokan')
}, {
  name: 'draft',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Draft', 'dokan')
}, {
  name: 'trash',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Trash', 'dokan')
}, {
  name: 'rejected',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Rejected', 'dokan')
}, {
  name: 'converted',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Converted', 'dokan')
}];
const RequestQuoteList = () => {
  const [data, setData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)([]);
  const [isLoading, setIsLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  // Match Dokan Admin DataViews expected view shape
  const defaultLayouts = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => ({
    table: {
      density: 'comfortable'
    },
    grid: {},
    list: {}
  }), []);
  const [selection, setSelection] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)([]);
  const [totalItems, setTotalItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
  const [totalPages, setTotalPages] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(1);
  const [activeTab, setActiveTab] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('all');
  const [statusCounts, setStatusCounts] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({
    all: 0,
    pending: 0,
    approved: 0,
    cancelled: 0,
    draft: 0,
    trash: 0,
    updated: 0,
    accepted: 0,
    rejected: 0,
    expired: 0,
    converted: 0
  });

  // Filters state (follow withdraw page patterns)
  const [search, setSearch] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');
  const [vendor, setVendor] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
  const [after, setAfter] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');
  const [before, setBefore] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');
  const fields = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => [{
    id: 'quote',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Quote', 'dokan'),
    render: ({
      item
    }) => {
      var _item$id;
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex flex-col gap-1"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "font-medium text-gray-900"
      }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Quote #', 'dokan'), (_item$id = item?.id) !== null && _item$id !== void 0 ? _item$id : '—'), item?.created_at && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "text-xs text-gray-500"
      }, item.created_at));
    }
  }, {
    id: 'customer',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Customer', 'dokan'),
    render: ({
      item
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex items-center gap-2"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "w-6 h-6 rounded-full bg-gray-200"
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex flex-col"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "text-sm text-gray-900"
    }, item?.customer_name || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('N/A', 'dokan'))))
  }, {
    id: 'status',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Status', 'dokan'),
    render: ({
      item
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(StatusPill, {
      value: (item?.status || 'pending').toLowerCase()
    })
  }, {
    id: 'vendor',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Vendor', 'dokan'),
    render: ({
      item
    }) => item?.store_name || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('N/A', 'dokan')
  }], []);
  const [view, setView] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({
    perPage: 20,
    page: 1,
    search: '',
    type: 'table',
    status: 'all',
    layout: {
      density: 'comfortable'
    },
    fields: ['quote', 'customer', 'status', 'vendor']
  });
  const fetchData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)(async () => {
    setIsLoading(true);
    try {
      const params = {
        page: view.page,
        per_page: view.perPage,
        status: activeTab !== 'all' ? activeTab : undefined,
        customer: search || undefined,
        'date[from_date]': after || undefined,
        'date[to_date]': before || undefined
      };
      const path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_4__.addQueryArgs)('dokan/v1/request-for-quote', params);
      const response = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
        path,
        parse: false
      }).catch(() => null);
      if (response) {
        const items = await response.json().catch(() => []);
        setData(Array.isArray(items) ? items : []);
        const headers = response.headers;
        const getNum = key => parseInt(headers.get(key) || '0', 10);

        // Per-status counts (best effort; header casing is case-insensitive)
        const totals = {
          all: getNum('X-Status-All'),
          pending: getNum('X-Status-Pending'),
          approved: getNum('X-Status-Approved'),
          cancelled: getNum('X-Status-Cancelled'),
          draft: getNum('X-Status-Draft'),
          trash: getNum('X-Status-Trash'),
          updated: getNum('X-Status-Updated'),
          accepted: getNum('X-Status-Accepted'),
          rejected: getNum('X-Status-Rejected'),
          expired: getNum('X-Status-Expired'),
          converted: getNum('X-Status-Converted')
        };
        setStatusCounts(totals);

        // Prefer the standard WP collection headers when available
        const totalFromHeader = parseInt(headers.get('X-WP-Total') || '0', 10);
        const totalPagesFromHeader = parseInt(headers.get('X-WP-TotalPages') || '0', 10);
        setTotalItems(totalFromHeader || (activeTab === 'all' ? totals.all : totals[activeTab] || 0) || (Array.isArray(items) ? items.length : 0));
        setTotalPages(totalPagesFromHeader || Math.max(1, Math.ceil((totalFromHeader || totals.all || 0) / (view.perPage || 20))));
      } else {
        setData([]);
        setTotalItems(0);
      }
    } finally {
      setIsLoading(false);
    }
  }, [view.page, view.perPage, activeTab, search, after, before]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    fetchData();
  }, [fetchData]);
  const filterFields = () => [{
    id: 'search',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Search', 'dokan'),
    render: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_6__.SimpleInput, {
      addOnLeft: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_8__["default"], {
        size: 16
      }),
      className: "border rounded px-3 py-1.5 w-full bg-white",
      input: {
        type: 'search',
        value: search,
        placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Search quotes…', 'dokan'),
        onChange: e => setSearch(e.target.value)
      }
    })
  }, {
    id: 'vendor',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Vendor', 'dokan'),
    render: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_5__.VendorAsyncSelect, {
      value: vendor,
      onChange: v => setVendor(v),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select vendor', 'dokan')
    })
  }, {
    id: 'date',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Date', 'dokan'),
    render: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_5__.DateRangePicker, {
      onChange: ({
        after: a,
        before: b
      }) => {
        setAfter(a);
        setBefore(b);
      },
      onOk: () => {
        /* trigger fetch by state effect */
      }
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_getdokan_dokan_ui__WEBPACK_IMPORTED_MODULE_6__.SimpleInput, {
      addOnLeft: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], {
        size: 16
      }),
      className: "border rounded px-3 py-1.5 w-full bg-white",
      input: {
        type: 'text',
        readOnly: true,
        value: !after || !before ? '' : `${after} - ${before}`,
        placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Date', 'dokan')
      }
    }))
  }];
  const tabs = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => QUOTE_TABS.map(t => ({
    id: t.name,
    name: t.name,
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex items-center gap-1.5 px-2"
    }, t.label, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "text-xs font-light text-[#A5A5AA]"
    }, "(", statusCounts[t.name] || 0, ")")),
    title: t.label
  })), [statusCounts]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "dokan-rfq-admin-quote-list p-2 md:p-0"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mb-6"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-2xl font-semibold text-gray-900"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Request for Quotation', 'dokan'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_Common_HeaderSection__WEBPACK_IMPORTED_MODULE_9__["default"], {
    active: "quotes"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_dokan_components__WEBPACK_IMPORTED_MODULE_5__.AdminDataViews, {
    data: data,
    namespace: "rfq-quote-list",
    defaultLayouts: defaultLayouts,
    fields: fields,
    getItemId: item => item?.id || item?.quote_id,
    onChangeView: setView,
    paginationInfo: {
      totalItems,
      totalPages
    },
    view: view,
    selection: selection,
    onChangeSelection: setSelection,
    isLoading: isLoading,
    tabs: {
      tabs,
      onSelect: tabName => {
        setActiveTab(tabName);
        setView(prev => ({
          ...prev,
          page: 1
        }));
      },
      initialTabName: activeTab
    },
    actions: [{
      id: 'pending',
      label: () => (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Mark Pending', 'dokan'),
      supportsBulk: true,
      callback: async items => {
        const ids = items.map(i => i.id || i.quote_id);
        if (!ids.length) return;
        await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
          path: 'dokan/v1/request-for-quote/batch',
          method: 'POST',
          data: {
            action: 'pending',
            items: ids
          }
        }).catch(() => {});
        setSelection([]);
        fetchData();
      }
    }, {
      id: 'approve',
      label: () => (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Approve', 'dokan'),
      supportsBulk: true,
      callback: async items => {
        const ids = items.map(i => i.id || i.quote_id);
        if (!ids.length) return;
        await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
          path: 'dokan/v1/request-for-quote/batch',
          method: 'POST',
          data: {
            action: 'approve',
            items: ids
          }
        }).catch(() => {});
        setSelection([]);
        fetchData();
      }
    }, {
      id: 'trash',
      label: () => (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Trash', 'dokan'),
      supportsBulk: true,
      callback: async items => {
        const ids = items.map(i => i.id || i.quote_id);
        if (!ids.length) return;
        if (!window.confirm((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Move selected quotes to Trash?', 'dokan'))) return;
        await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
          path: 'dokan/v1/request-for-quote/batch',
          method: 'POST',
          data: {
            action: 'trash',
            items: ids
          }
        }).catch(() => {});
        setSelection([]);
        fetchData();
      }
    }, {
      id: 'restore',
      label: () => (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Restore', 'dokan'),
      supportsBulk: true,
      callback: async items => {
        const ids = items.map(i => i.id || i.quote_id);
        if (!ids.length) return;
        await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
          path: 'dokan/v1/request-for-quote/batch',
          method: 'POST',
          data: {
            action: 'restore',
            items: ids
          }
        }).catch(() => {});
        setSelection([]);
        fetchData();
      }
    }, {
      id: 'delete',
      label: () => (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Delete Permanently', 'dokan'),
      supportsBulk: true,
      callback: async items => {
        const ids = items.map(i => i.id || i.quote_id);
        if (!ids.length) return;
        if (!window.confirm((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Delete selected quotes permanently?', 'dokan'))) return;
        await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
          path: 'dokan/v1/request-for-quote/batch',
          method: 'POST',
          data: {
            action: 'delete',
            items: ids
          }
        }).catch(() => {});
        setSelection([]);
        fetchData();
      }
    }],
    filter: {
      fields: filterFields(),
      onFilterRemove: () => {},
      onReset: () => {
        setSearch('');
        setVendor(null);
        setAfter('');
        setBefore('');
      }
    }
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestQuoteList);

/***/ }),

/***/ "./modules/request-for-quotation/assets/src/js/admin-panel/scss/style.scss":
/*!*********************************************************************************!*\
  !*** ./modules/request-for-quotation/assets/src/js/admin-panel/scss/style.scss ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/@getdokan/dokan-ui/dist/index.js":
/*!*******************************************************!*\
  !*** ./node_modules/@getdokan/dokan-ui/dist/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

var react__WEBPACK_IMPORTED_MODULE_0___namespace_cache;
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AsyncSearchableSelect: () => (/* binding */ Z_),
/* harmony export */   Badge: () => (/* binding */ p_),
/* harmony export */   Box: () => (/* binding */ g_),
/* harmony export */   Button: () => (/* binding */ xd),
/* harmony export */   Card: () => (/* binding */ sr),
/* harmony export */   ConfirmModal: () => (/* binding */ V_),
/* harmony export */   Container: () => (/* binding */ h_),
/* harmony export */   Divider: () => (/* binding */ m_),
/* harmony export */   DokanIcon: () => (/* binding */ DN),
/* harmony export */   DokanToaster: () => (/* binding */ k_),
/* harmony export */   Drawer: () => (/* binding */ y_),
/* harmony export */   Dropdown: () => (/* binding */ Tc),
/* harmony export */   ErrorIcon: () => (/* binding */ TC),
/* harmony export */   ErrorMessage: () => (/* binding */ Nu),
/* harmony export */   FancyCheckbox: () => (/* binding */ $_),
/* harmony export */   FormInput: () => (/* binding */ LF),
/* harmony export */   FormLabel: () => (/* binding */ F5),
/* harmony export */   FormSelect: () => (/* binding */ Y_),
/* harmony export */   FormTextarea: () => (/* binding */ GF),
/* harmony export */   GoogleIcon: () => (/* binding */ x_),
/* harmony export */   GooglePlaceAutocomplete: () => (/* binding */ G_),
/* harmony export */   Loader: () => (/* binding */ j_),
/* harmony export */   MaskedInput: () => (/* binding */ W_),
/* harmony export */   Modal: () => (/* binding */ wt),
/* harmony export */   MultipleTextInput: () => (/* binding */ C_),
/* harmony export */   Popover: () => (/* binding */ hr),
/* harmony export */   RadioGroup: () => (/* binding */ M_),
/* harmony export */   ReactSelect: () => (/* binding */ w_),
/* harmony export */   SearchableSelect: () => (/* binding */ I_),
/* harmony export */   Select: () => (/* binding */ eu),
/* harmony export */   SimpleAlert: () => (/* binding */ E_),
/* harmony export */   SimpleCheckbox: () => (/* binding */ _N),
/* harmony export */   SimpleCheckboxGroup: () => (/* binding */ A_),
/* harmony export */   SimpleHeader: () => (/* binding */ S_),
/* harmony export */   SimpleInput: () => (/* binding */ P_),
/* harmony export */   SimpleRadio: () => (/* binding */ N_),
/* harmony export */   SimpleSelect: () => (/* binding */ T_),
/* harmony export */   TaggableSelect: () => (/* binding */ R_),
/* harmony export */   TextArea: () => (/* binding */ O_),
/* harmony export */   ToggleSwitch: () => (/* binding */ __),
/* harmony export */   Tooltip: () => (/* binding */ L_),
/* harmony export */   TrailingInput: () => (/* binding */ D_),
/* harmony export */   useToast: () => (/* binding */ H_)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "react-dom");




var Jn = typeof globalThis < "u" ? globalThis : typeof window < "u" ? window : typeof global < "u" ? global : typeof self < "u" ? self : {};
function oa(l) {
  return l && l.__esModule && Object.prototype.hasOwnProperty.call(l, "default") ? l.default : l;
}
var yd = { exports: {} }, Dr = {};
/**
 * @license React
 * react-jsx-runtime.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var Hf;
function Nb() {
  if (Hf) return Dr;
  Hf = 1;
  var l = react__WEBPACK_IMPORTED_MODULE_0__, n = Symbol.for("react.element"), u = Symbol.for("react.fragment"), t = Object.prototype.hasOwnProperty, r = l.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner, o = { key: !0, ref: !0, __self: !0, __source: !0 };
  function s(d, a, c) {
    var p, g = {}, m = null, v = null;
    c !== void 0 && (m = "" + c), a.key !== void 0 && (m = "" + a.key), a.ref !== void 0 && (v = a.ref);
    for (p in a) t.call(a, p) && !o.hasOwnProperty(p) && (g[p] = a[p]);
    if (d && d.defaultProps) for (p in a = d.defaultProps, a) g[p] === void 0 && (g[p] = a[p]);
    return { $$typeof: n, type: d, key: m, ref: v, props: g, _owner: r.current };
  }
  return Dr.Fragment = u, Dr.jsx = s, Dr.jsxs = s, Dr;
}
var Mr = {};
/**
 * @license React
 * react-jsx-runtime.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var Zf;
function Tb() {
  return Zf || (Zf = 1,  true && function() {
    var l = react__WEBPACK_IMPORTED_MODULE_0__, n = Symbol.for("react.element"), u = Symbol.for("react.portal"), t = Symbol.for("react.fragment"), r = Symbol.for("react.strict_mode"), o = Symbol.for("react.profiler"), s = Symbol.for("react.provider"), d = Symbol.for("react.context"), a = Symbol.for("react.forward_ref"), c = Symbol.for("react.suspense"), p = Symbol.for("react.suspense_list"), g = Symbol.for("react.memo"), m = Symbol.for("react.lazy"), v = Symbol.for("react.offscreen"), $ = Symbol.iterator, b = "@@iterator";
    function E(D) {
      if (D === null || typeof D != "object")
        return null;
      var nl = $ && D[$] || D[b];
      return typeof nl == "function" ? nl : null;
    }
    var S = l.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;
    function A(D) {
      {
        for (var nl = arguments.length, gl = new Array(nl > 1 ? nl - 1 : 0), _l = 1; _l < nl; _l++)
          gl[_l - 1] = arguments[_l];
        x("error", D, gl);
      }
    }
    function x(D, nl, gl) {
      {
        var _l = S.ReactDebugCurrentFrame, Ql = _l.getStackAddendum();
        Ql !== "" && (nl += "%s", gl = gl.concat([Ql]));
        var un = gl.map(function(zl) {
          return String(zl);
        });
        un.unshift("Warning: " + nl), Function.prototype.apply.call(console[D], console, un);
      }
    }
    var I = !1, P = !1, O = !1, _ = !1, j = !1, z;
    z = Symbol.for("react.module.reference");
    function Y(D) {
      return !!(typeof D == "string" || typeof D == "function" || D === t || D === o || j || D === r || D === c || D === p || _ || D === v || I || P || O || typeof D == "object" && D !== null && (D.$$typeof === m || D.$$typeof === g || D.$$typeof === s || D.$$typeof === d || D.$$typeof === a || // This needs to include all possible module reference object
      // types supported by any Flight configuration anywhere since
      // we don't know which Flight build this will end up being used
      // with.
      D.$$typeof === z || D.getModuleId !== void 0));
    }
    function el(D, nl, gl) {
      var _l = D.displayName;
      if (_l)
        return _l;
      var Ql = nl.displayName || nl.name || "";
      return Ql !== "" ? gl + "(" + Ql + ")" : gl;
    }
    function U(D) {
      return D.displayName || "Context";
    }
    function ul(D) {
      if (D == null)
        return null;
      if (typeof D.tag == "number" && A("Received an unexpected object in getComponentNameFromType(). This is likely a bug in React. Please file an issue."), typeof D == "function")
        return D.displayName || D.name || null;
      if (typeof D == "string")
        return D;
      switch (D) {
        case t:
          return "Fragment";
        case u:
          return "Portal";
        case o:
          return "Profiler";
        case r:
          return "StrictMode";
        case c:
          return "Suspense";
        case p:
          return "SuspenseList";
      }
      if (typeof D == "object")
        switch (D.$$typeof) {
          case d:
            var nl = D;
            return U(nl) + ".Consumer";
          case s:
            var gl = D;
            return U(gl._context) + ".Provider";
          case a:
            return el(D, D.render, "ForwardRef");
          case g:
            var _l = D.displayName || null;
            return _l !== null ? _l : ul(D.type) || "Memo";
          case m: {
            var Ql = D, un = Ql._payload, zl = Ql._init;
            try {
              return ul(zl(un));
            } catch {
              return null;
            }
          }
        }
      return null;
    }
    var il = Object.assign, rl = 0, tl, sl, ll, H, V, X, dl;
    function fl() {
    }
    fl.__reactDisabledLog = !0;
    function $l() {
      {
        if (rl === 0) {
          tl = console.log, sl = console.info, ll = console.warn, H = console.error, V = console.group, X = console.groupCollapsed, dl = console.groupEnd;
          var D = {
            configurable: !0,
            enumerable: !0,
            value: fl,
            writable: !0
          };
          Object.defineProperties(console, {
            info: D,
            log: D,
            warn: D,
            error: D,
            group: D,
            groupCollapsed: D,
            groupEnd: D
          });
        }
        rl++;
      }
    }
    function cl() {
      {
        if (rl--, rl === 0) {
          var D = {
            configurable: !0,
            enumerable: !0,
            writable: !0
          };
          Object.defineProperties(console, {
            log: il({}, D, {
              value: tl
            }),
            info: il({}, D, {
              value: sl
            }),
            warn: il({}, D, {
              value: ll
            }),
            error: il({}, D, {
              value: H
            }),
            group: il({}, D, {
              value: V
            }),
            groupCollapsed: il({}, D, {
              value: X
            }),
            groupEnd: il({}, D, {
              value: dl
            })
          });
        }
        rl < 0 && A("disabledDepth fell below zero. This is a bug in React. Please file an issue.");
      }
    }
    var xl = S.ReactCurrentDispatcher, ol;
    function ml(D, nl, gl) {
      {
        if (ol === void 0)
          try {
            throw Error();
          } catch (Ql) {
            var _l = Ql.stack.trim().match(/\n( *(at )?)/);
            ol = _l && _l[1] || "";
          }
        return `
` + ol + D;
      }
    }
    var Sl = !1, Ol;
    {
      var Cl = typeof WeakMap == "function" ? WeakMap : Map;
      Ol = new Cl();
    }
    function Q(D, nl) {
      if (!D || Sl)
        return "";
      {
        var gl = Ol.get(D);
        if (gl !== void 0)
          return gl;
      }
      var _l;
      Sl = !0;
      var Ql = Error.prepareStackTrace;
      Error.prepareStackTrace = void 0;
      var un;
      un = xl.current, xl.current = null, $l();
      try {
        if (nl) {
          var zl = function() {
            throw Error();
          };
          if (Object.defineProperty(zl.prototype, "props", {
            set: function() {
              throw Error();
            }
          }), typeof Reflect == "object" && Reflect.construct) {
            try {
              Reflect.construct(zl, []);
            } catch (su) {
              _l = su;
            }
            Reflect.construct(D, [], zl);
          } else {
            try {
              zl.call();
            } catch (su) {
              _l = su;
            }
            D.call(zl.prototype);
          }
        } else {
          try {
            throw Error();
          } catch (su) {
            _l = su;
          }
          D();
        }
      } catch (su) {
        if (su && _l && typeof su.stack == "string") {
          for (var kl = su.stack.split(`
`), Xn = _l.stack.split(`
`), wn = kl.length - 1, Sn = Xn.length - 1; wn >= 1 && Sn >= 0 && kl[wn] !== Xn[Sn]; )
            Sn--;
          for (; wn >= 1 && Sn >= 0; wn--, Sn--)
            if (kl[wn] !== Xn[Sn]) {
              if (wn !== 1 || Sn !== 1)
                do
                  if (wn--, Sn--, Sn < 0 || kl[wn] !== Xn[Sn]) {
                    var au = `
` + kl[wn].replace(" at new ", " at ");
                    return D.displayName && au.includes("<anonymous>") && (au = au.replace("<anonymous>", D.displayName)), typeof D == "function" && Ol.set(D, au), au;
                  }
                while (wn >= 1 && Sn >= 0);
              break;
            }
        }
      } finally {
        Sl = !1, xl.current = un, cl(), Error.prepareStackTrace = Ql;
      }
      var Zu = D ? D.displayName || D.name : "", xi = Zu ? ml(Zu) : "";
      return typeof D == "function" && Ol.set(D, xi), xi;
    }
    function Xl(D, nl, gl) {
      return Q(D, !1);
    }
    function Bl(D) {
      var nl = D.prototype;
      return !!(nl && nl.isReactComponent);
    }
    function Kl(D, nl, gl) {
      if (D == null)
        return "";
      if (typeof D == "function")
        return Q(D, Bl(D));
      if (typeof D == "string")
        return ml(D);
      switch (D) {
        case c:
          return ml("Suspense");
        case p:
          return ml("SuspenseList");
      }
      if (typeof D == "object")
        switch (D.$$typeof) {
          case a:
            return Xl(D.render);
          case g:
            return Kl(D.type, nl, gl);
          case m: {
            var _l = D, Ql = _l._payload, un = _l._init;
            try {
              return Kl(un(Ql), nl, gl);
            } catch {
            }
          }
        }
      return "";
    }
    var fn = Object.prototype.hasOwnProperty, dn = {}, Fn = S.ReactDebugCurrentFrame;
    function sn(D) {
      if (D) {
        var nl = D._owner, gl = Kl(D.type, D._source, nl ? nl.type : null);
        Fn.setExtraStackFrame(gl);
      } else
        Fn.setExtraStackFrame(null);
    }
    function gn(D, nl, gl, _l, Ql) {
      {
        var un = Function.call.bind(fn);
        for (var zl in D)
          if (un(D, zl)) {
            var kl = void 0;
            try {
              if (typeof D[zl] != "function") {
                var Xn = Error((_l || "React class") + ": " + gl + " type `" + zl + "` is invalid; it must be a function, usually from the `prop-types` package, but received `" + typeof D[zl] + "`.This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.");
                throw Xn.name = "Invariant Violation", Xn;
              }
              kl = D[zl](nl, zl, _l, gl, null, "SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED");
            } catch (wn) {
              kl = wn;
            }
            kl && !(kl instanceof Error) && (sn(Ql), A("%s: type specification of %s `%s` is invalid; the type checker function must return `null` or an `Error` but returned a %s. You may have forgotten to pass an argument to the type checker creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and shape all require an argument).", _l || "React class", gl, zl, typeof kl), sn(null)), kl instanceof Error && !(kl.message in dn) && (dn[kl.message] = !0, sn(Ql), A("Failed %s type: %s", gl, kl.message), sn(null));
          }
      }
    }
    var _n = Array.isArray;
    function Zn(D) {
      return _n(D);
    }
    function ue(D) {
      {
        var nl = typeof Symbol == "function" && Symbol.toStringTag, gl = nl && D[Symbol.toStringTag] || D.constructor.name || "Object";
        return gl;
      }
    }
    function _e(D) {
      try {
        return Tu(D), !1;
      } catch {
        return !0;
      }
    }
    function Tu(D) {
      return "" + D;
    }
    function ee(D) {
      if (_e(D))
        return A("The provided key is an unsupported type %s. This value must be coerced to a string before before using it here.", ue(D)), Tu(D);
    }
    var Qn = S.ReactCurrentOwner, vu = {
      key: !0,
      ref: !0,
      __self: !0,
      __source: !0
    }, R, G, W;
    W = {};
    function al(D) {
      if (fn.call(D, "ref")) {
        var nl = Object.getOwnPropertyDescriptor(D, "ref").get;
        if (nl && nl.isReactWarning)
          return !1;
      }
      return D.ref !== void 0;
    }
    function Pl(D) {
      if (fn.call(D, "key")) {
        var nl = Object.getOwnPropertyDescriptor(D, "key").get;
        if (nl && nl.isReactWarning)
          return !1;
      }
      return D.key !== void 0;
    }
    function Fl(D, nl) {
      if (typeof D.ref == "string" && Qn.current && nl && Qn.current.stateNode !== nl) {
        var gl = ul(Qn.current.type);
        W[gl] || (A('Component "%s" contains the string ref "%s". Support for string refs will be removed in a future major release. This case cannot be automatically converted to an arrow function. We ask you to manually fix this case by using useRef() or createRef() instead. Learn more about using refs safely here: https://reactjs.org/link/strict-mode-string-ref', ul(Qn.current.type), D.ref), W[gl] = !0);
      }
    }
    function on(D, nl) {
      {
        var gl = function() {
          R || (R = !0, A("%s: `key` is not a prop. Trying to access it will result in `undefined` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://reactjs.org/link/special-props)", nl));
        };
        gl.isReactWarning = !0, Object.defineProperty(D, "key", {
          get: gl,
          configurable: !0
        });
      }
    }
    function Cn(D, nl) {
      {
        var gl = function() {
          G || (G = !0, A("%s: `ref` is not a prop. Trying to access it will result in `undefined` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://reactjs.org/link/special-props)", nl));
        };
        gl.isReactWarning = !0, Object.defineProperty(D, "ref", {
          get: gl,
          configurable: !0
        });
      }
    }
    var Dn = function(D, nl, gl, _l, Ql, un, zl) {
      var kl = {
        // This tag allows us to uniquely identify this as a React Element
        $$typeof: n,
        // Built-in properties that belong on the element
        type: D,
        key: nl,
        ref: gl,
        props: zl,
        // Record the component responsible for creating this element.
        _owner: un
      };
      return kl._store = {}, Object.defineProperty(kl._store, "validated", {
        configurable: !1,
        enumerable: !1,
        writable: !0,
        value: !1
      }), Object.defineProperty(kl, "_self", {
        configurable: !1,
        enumerable: !1,
        writable: !1,
        value: _l
      }), Object.defineProperty(kl, "_source", {
        configurable: !1,
        enumerable: !1,
        writable: !1,
        value: Ql
      }), Object.freeze && (Object.freeze(kl.props), Object.freeze(kl)), kl;
    };
    function Hu(D, nl, gl, _l, Ql) {
      {
        var un, zl = {}, kl = null, Xn = null;
        gl !== void 0 && (ee(gl), kl = "" + gl), Pl(nl) && (ee(nl.key), kl = "" + nl.key), al(nl) && (Xn = nl.ref, Fl(nl, Ql));
        for (un in nl)
          fn.call(nl, un) && !vu.hasOwnProperty(un) && (zl[un] = nl[un]);
        if (D && D.defaultProps) {
          var wn = D.defaultProps;
          for (un in wn)
            zl[un] === void 0 && (zl[un] = wn[un]);
        }
        if (kl || Xn) {
          var Sn = typeof D == "function" ? D.displayName || D.name || "Unknown" : D;
          kl && on(zl, Sn), Xn && Cn(zl, Sn);
        }
        return Dn(D, kl, Xn, Ql, _l, Qn.current, zl);
      }
    }
    var at = S.ReactCurrentOwner, pi = S.ReactDebugCurrentFrame;
    function ge(D) {
      if (D) {
        var nl = D._owner, gl = Kl(D.type, D._source, nl ? nl.type : null);
        pi.setExtraStackFrame(gl);
      } else
        pi.setExtraStackFrame(null);
    }
    var Rt;
    Rt = !1;
    function vr(D) {
      return typeof D == "object" && D !== null && D.$$typeof === n;
    }
    function gi() {
      {
        if (at.current) {
          var D = ul(at.current.type);
          if (D)
            return `

Check the render method of \`` + D + "`.";
        }
        return "";
      }
    }
    function La(D) {
      return "";
    }
    var hi = {};
    function mi(D) {
      {
        var nl = gi();
        if (!nl) {
          var gl = typeof D == "string" ? D : D.displayName || D.name;
          gl && (nl = `

Check the top-level render call using <` + gl + ">.");
        }
        return nl;
      }
    }
    function bi(D, nl) {
      {
        if (!D._store || D._store.validated || D.key != null)
          return;
        D._store.validated = !0;
        var gl = mi(nl);
        if (hi[gl])
          return;
        hi[gl] = !0;
        var _l = "";
        D && D._owner && D._owner !== at.current && (_l = " It was passed a child from " + ul(D._owner.type) + "."), ge(D), A('Each child in a list should have a unique "key" prop.%s%s See https://reactjs.org/link/warning-keys for more information.', gl, _l), ge(null);
      }
    }
    function yi(D, nl) {
      {
        if (typeof D != "object")
          return;
        if (Zn(D))
          for (var gl = 0; gl < D.length; gl++) {
            var _l = D[gl];
            vr(_l) && bi(_l, nl);
          }
        else if (vr(D))
          D._store && (D._store.validated = !0);
        else if (D) {
          var Ql = E(D);
          if (typeof Ql == "function" && Ql !== D.entries)
            for (var un = Ql.call(D), zl; !(zl = un.next()).done; )
              vr(zl.value) && bi(zl.value, nl);
        }
      }
    }
    function Ga(D) {
      {
        var nl = D.type;
        if (nl == null || typeof nl == "string")
          return;
        var gl;
        if (typeof nl == "function")
          gl = nl.propTypes;
        else if (typeof nl == "object" && (nl.$$typeof === a || // Note: Memo only checks outer props here.
        // Inner props are checked in the reconciler.
        nl.$$typeof === g))
          gl = nl.propTypes;
        else
          return;
        if (gl) {
          var _l = ul(nl);
          gn(gl, D.props, "prop", _l, D);
        } else if (nl.PropTypes !== void 0 && !Rt) {
          Rt = !0;
          var Ql = ul(nl);
          A("Component %s declared `PropTypes` instead of `propTypes`. Did you misspell the property assignment?", Ql || "Unknown");
        }
        typeof nl.getDefaultProps == "function" && !nl.getDefaultProps.isReactClassApproved && A("getDefaultProps is only used on classic React.createClass definitions. Use a static property named `defaultProps` instead.");
      }
    }
    function br(D) {
      {
        for (var nl = Object.keys(D.props), gl = 0; gl < nl.length; gl++) {
          var _l = nl[gl];
          if (_l !== "children" && _l !== "key") {
            ge(D), A("Invalid prop `%s` supplied to `React.Fragment`. React.Fragment can only have `key` and `children` props.", _l), ge(null);
            break;
          }
        }
        D.ref !== null && (ge(D), A("Invalid attribute `ref` supplied to `React.Fragment`."), ge(null));
      }
    }
    function $i(D, nl, gl, _l, Ql, un) {
      {
        var zl = Y(D);
        if (!zl) {
          var kl = "";
          (D === void 0 || typeof D == "object" && D !== null && Object.keys(D).length === 0) && (kl += " You likely forgot to export your component from the file it's defined in, or you might have mixed up default and named imports.");
          var Xn = La();
          Xn ? kl += Xn : kl += gi();
          var wn;
          D === null ? wn = "null" : Zn(D) ? wn = "array" : D !== void 0 && D.$$typeof === n ? (wn = "<" + (ul(D.type) || "Unknown") + " />", kl = " Did you accidentally export a JSX literal instead of a component?") : wn = typeof D, A("React.jsx: type is invalid -- expected a string (for built-in components) or a class/function (for composite components) but got: %s.%s", wn, kl);
        }
        var Sn = Hu(D, nl, gl, Ql, un);
        if (Sn == null)
          return Sn;
        if (zl) {
          var au = nl.children;
          if (au !== void 0)
            if (_l)
              if (Zn(au)) {
                for (var Zu = 0; Zu < au.length; Zu++)
                  yi(au[Zu], D);
                Object.freeze && Object.freeze(au);
              } else
                A("React.jsx: Static children should always be an array. You are likely explicitly calling React.jsxs or React.jsxDEV. Use the Babel transform instead.");
            else
              yi(au, D);
        }
        return D === t ? br(Sn) : Ga(Sn), Sn;
      }
    }
    function yr(D, nl, gl) {
      return $i(D, nl, gl, !0);
    }
    function ja(D, nl, gl) {
      return $i(D, nl, gl, !1);
    }
    var Wa = ja, Va = yr;
    Mr.Fragment = t, Mr.jsx = Wa, Mr.jsxs = Va;
  }()), Mr;
}
 false ? 0 : yd.exports = Tb();
var y = yd.exports;
function M3(l) {
  var n, u, t = "";
  if (typeof l == "string" || typeof l == "number") t += l;
  else if (typeof l == "object") if (Array.isArray(l)) {
    var r = l.length;
    for (n = 0; n < r; n++) l[n] && (u = M3(l[n])) && (t && (t += " "), t += u);
  } else for (u in l) l[u] && (t && (t += " "), t += u);
  return t;
}
function Rb() {
  for (var l, n, u = 0, t = "", r = arguments.length; u < r; u++) (l = arguments[u]) && (n = M3(l)) && (t && (t += " "), t += n);
  return t;
}
var Bo = { exports: {} };
/**
 * @license
 * Lodash <https://lodash.com/>
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */
Bo.exports;
(function(l, n) {
  (function() {
    var u, t = "4.17.21", r = 200, o = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.", s = "Expected a function", d = "Invalid `variable` option passed into `_.template`", a = "__lodash_hash_undefined__", c = 500, p = "__lodash_placeholder__", g = 1, m = 2, v = 4, $ = 1, b = 2, E = 1, S = 2, A = 4, x = 8, I = 16, P = 32, O = 64, _ = 128, j = 256, z = 512, Y = 30, el = "...", U = 800, ul = 16, il = 1, rl = 2, tl = 3, sl = 1 / 0, ll = 9007199254740991, H = 17976931348623157e292, V = NaN, X = 4294967295, dl = X - 1, fl = X >>> 1, $l = [
      ["ary", _],
      ["bind", E],
      ["bindKey", S],
      ["curry", x],
      ["curryRight", I],
      ["flip", z],
      ["partial", P],
      ["partialRight", O],
      ["rearg", j]
    ], cl = "[object Arguments]", xl = "[object Array]", ol = "[object AsyncFunction]", ml = "[object Boolean]", Sl = "[object Date]", Ol = "[object DOMException]", Cl = "[object Error]", Q = "[object Function]", Xl = "[object GeneratorFunction]", Bl = "[object Map]", Kl = "[object Number]", fn = "[object Null]", dn = "[object Object]", Fn = "[object Promise]", sn = "[object Proxy]", gn = "[object RegExp]", _n = "[object Set]", Zn = "[object String]", ue = "[object Symbol]", _e = "[object Undefined]", Tu = "[object WeakMap]", ee = "[object WeakSet]", Qn = "[object ArrayBuffer]", vu = "[object DataView]", R = "[object Float32Array]", G = "[object Float64Array]", W = "[object Int8Array]", al = "[object Int16Array]", Pl = "[object Int32Array]", Fl = "[object Uint8Array]", on = "[object Uint8ClampedArray]", Cn = "[object Uint16Array]", Dn = "[object Uint32Array]", Hu = /\b__p \+= '';/g, at = /\b(__p \+=) '' \+/g, pi = /(__e\(.*?\)|\b__t\)) \+\n'';/g, ge = /&(?:amp|lt|gt|quot|#39);/g, Rt = /[&<>"']/g, vr = RegExp(ge.source), gi = RegExp(Rt.source), La = /<%-([\s\S]+?)%>/g, hi = /<%([\s\S]+?)%>/g, mi = /<%=([\s\S]+?)%>/g, bi = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, yi = /^\w*$/, Ga = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g, br = /[\\^$.*+?()[\]{}|]/g, $i = RegExp(br.source), yr = /^\s+/, ja = /\s/, Wa = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, Va = /\{\n\/\* \[wrapped with (.+)\] \*/, D = /,? & /, nl = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g, gl = /[()=,{}\[\]\/\s]/, _l = /\\(\\)?/g, Ql = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g, un = /\w*$/, zl = /^[-+]0x[0-9a-f]+$/i, kl = /^0b[01]+$/i, Xn = /^\[object .+?Constructor\]$/, wn = /^0o[0-7]+$/i, Sn = /^(?:0|[1-9]\d*)$/, au = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g, Zu = /($^)/, xi = /['\n\r\u2028\u2029\\]/g, su = "\\ud800-\\udfff", m9 = "\\u0300-\\u036f", v9 = "\\ufe20-\\ufe2f", b9 = "\\u20d0-\\u20ff", b0 = m9 + v9 + b9, y0 = "\\u2700-\\u27bf", $0 = "a-z\\xdf-\\xf6\\xf8-\\xff", y9 = "\\xac\\xb1\\xd7\\xf7", $9 = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", x9 = "\\u2000-\\u206f", C9 = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", x0 = "A-Z\\xc0-\\xd6\\xd8-\\xde", C0 = "\\ufe0e\\ufe0f", w0 = y9 + $9 + x9 + C9, ka = "['’]", w9 = "[" + su + "]", I0 = "[" + w0 + "]", Ci = "[" + b0 + "]", E0 = "\\d+", I9 = "[" + y0 + "]", A0 = "[" + $0 + "]", S0 = "[^" + su + w0 + E0 + y0 + $0 + x0 + "]", Ha = "\\ud83c[\\udffb-\\udfff]", E9 = "(?:" + Ci + "|" + Ha + ")", P0 = "[^" + su + "]", Za = "(?:\\ud83c[\\udde6-\\uddff]){2}", Xa = "[\\ud800-\\udbff][\\udc00-\\udfff]", Ot = "[" + x0 + "]", N0 = "\\u200d", T0 = "(?:" + A0 + "|" + S0 + ")", A9 = "(?:" + Ot + "|" + S0 + ")", R0 = "(?:" + ka + "(?:d|ll|m|re|s|t|ve))?", O0 = "(?:" + ka + "(?:D|LL|M|RE|S|T|VE))?", F0 = E9 + "?", _0 = "[" + C0 + "]?", S9 = "(?:" + N0 + "(?:" + [P0, Za, Xa].join("|") + ")" + _0 + F0 + ")*", P9 = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])", N9 = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])", D0 = _0 + F0 + S9, T9 = "(?:" + [I9, Za, Xa].join("|") + ")" + D0, R9 = "(?:" + [P0 + Ci + "?", Ci, Za, Xa, w9].join("|") + ")", O9 = RegExp(ka, "g"), F9 = RegExp(Ci, "g"), za = RegExp(Ha + "(?=" + Ha + ")|" + R9 + D0, "g"), _9 = RegExp([
      Ot + "?" + A0 + "+" + R0 + "(?=" + [I0, Ot, "$"].join("|") + ")",
      A9 + "+" + O0 + "(?=" + [I0, Ot + T0, "$"].join("|") + ")",
      Ot + "?" + T0 + "+" + R0,
      Ot + "+" + O0,
      N9,
      P9,
      E0,
      T9
    ].join("|"), "g"), D9 = RegExp("[" + N0 + su + b0 + C0 + "]"), M9 = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/, B9 = [
      "Array",
      "Buffer",
      "DataView",
      "Date",
      "Error",
      "Float32Array",
      "Float64Array",
      "Function",
      "Int8Array",
      "Int16Array",
      "Int32Array",
      "Map",
      "Math",
      "Object",
      "Promise",
      "RegExp",
      "Set",
      "String",
      "Symbol",
      "TypeError",
      "Uint8Array",
      "Uint8ClampedArray",
      "Uint16Array",
      "Uint32Array",
      "WeakMap",
      "_",
      "clearTimeout",
      "isFinite",
      "parseInt",
      "setTimeout"
    ], L9 = -1, hn = {};
    hn[R] = hn[G] = hn[W] = hn[al] = hn[Pl] = hn[Fl] = hn[on] = hn[Cn] = hn[Dn] = !0, hn[cl] = hn[xl] = hn[Qn] = hn[ml] = hn[vu] = hn[Sl] = hn[Cl] = hn[Q] = hn[Bl] = hn[Kl] = hn[dn] = hn[gn] = hn[_n] = hn[Zn] = hn[Tu] = !1;
    var pn = {};
    pn[cl] = pn[xl] = pn[Qn] = pn[vu] = pn[ml] = pn[Sl] = pn[R] = pn[G] = pn[W] = pn[al] = pn[Pl] = pn[Bl] = pn[Kl] = pn[dn] = pn[gn] = pn[_n] = pn[Zn] = pn[ue] = pn[Fl] = pn[on] = pn[Cn] = pn[Dn] = !0, pn[Cl] = pn[Q] = pn[Tu] = !1;
    var G9 = {
      // Latin-1 Supplement block.
      À: "A",
      Á: "A",
      Â: "A",
      Ã: "A",
      Ä: "A",
      Å: "A",
      à: "a",
      á: "a",
      â: "a",
      ã: "a",
      ä: "a",
      å: "a",
      Ç: "C",
      ç: "c",
      Ð: "D",
      ð: "d",
      È: "E",
      É: "E",
      Ê: "E",
      Ë: "E",
      è: "e",
      é: "e",
      ê: "e",
      ë: "e",
      Ì: "I",
      Í: "I",
      Î: "I",
      Ï: "I",
      ì: "i",
      í: "i",
      î: "i",
      ï: "i",
      Ñ: "N",
      ñ: "n",
      Ò: "O",
      Ó: "O",
      Ô: "O",
      Õ: "O",
      Ö: "O",
      Ø: "O",
      ò: "o",
      ó: "o",
      ô: "o",
      õ: "o",
      ö: "o",
      ø: "o",
      Ù: "U",
      Ú: "U",
      Û: "U",
      Ü: "U",
      ù: "u",
      ú: "u",
      û: "u",
      ü: "u",
      Ý: "Y",
      ý: "y",
      ÿ: "y",
      Æ: "Ae",
      æ: "ae",
      Þ: "Th",
      þ: "th",
      ß: "ss",
      // Latin Extended-A block.
      Ā: "A",
      Ă: "A",
      Ą: "A",
      ā: "a",
      ă: "a",
      ą: "a",
      Ć: "C",
      Ĉ: "C",
      Ċ: "C",
      Č: "C",
      ć: "c",
      ĉ: "c",
      ċ: "c",
      č: "c",
      Ď: "D",
      Đ: "D",
      ď: "d",
      đ: "d",
      Ē: "E",
      Ĕ: "E",
      Ė: "E",
      Ę: "E",
      Ě: "E",
      ē: "e",
      ĕ: "e",
      ė: "e",
      ę: "e",
      ě: "e",
      Ĝ: "G",
      Ğ: "G",
      Ġ: "G",
      Ģ: "G",
      ĝ: "g",
      ğ: "g",
      ġ: "g",
      ģ: "g",
      Ĥ: "H",
      Ħ: "H",
      ĥ: "h",
      ħ: "h",
      Ĩ: "I",
      Ī: "I",
      Ĭ: "I",
      Į: "I",
      İ: "I",
      ĩ: "i",
      ī: "i",
      ĭ: "i",
      į: "i",
      ı: "i",
      Ĵ: "J",
      ĵ: "j",
      Ķ: "K",
      ķ: "k",
      ĸ: "k",
      Ĺ: "L",
      Ļ: "L",
      Ľ: "L",
      Ŀ: "L",
      Ł: "L",
      ĺ: "l",
      ļ: "l",
      ľ: "l",
      ŀ: "l",
      ł: "l",
      Ń: "N",
      Ņ: "N",
      Ň: "N",
      Ŋ: "N",
      ń: "n",
      ņ: "n",
      ň: "n",
      ŋ: "n",
      Ō: "O",
      Ŏ: "O",
      Ő: "O",
      ō: "o",
      ŏ: "o",
      ő: "o",
      Ŕ: "R",
      Ŗ: "R",
      Ř: "R",
      ŕ: "r",
      ŗ: "r",
      ř: "r",
      Ś: "S",
      Ŝ: "S",
      Ş: "S",
      Š: "S",
      ś: "s",
      ŝ: "s",
      ş: "s",
      š: "s",
      Ţ: "T",
      Ť: "T",
      Ŧ: "T",
      ţ: "t",
      ť: "t",
      ŧ: "t",
      Ũ: "U",
      Ū: "U",
      Ŭ: "U",
      Ů: "U",
      Ű: "U",
      Ų: "U",
      ũ: "u",
      ū: "u",
      ŭ: "u",
      ů: "u",
      ű: "u",
      ų: "u",
      Ŵ: "W",
      ŵ: "w",
      Ŷ: "Y",
      ŷ: "y",
      Ÿ: "Y",
      Ź: "Z",
      Ż: "Z",
      Ž: "Z",
      ź: "z",
      ż: "z",
      ž: "z",
      Ĳ: "IJ",
      ĳ: "ij",
      Œ: "Oe",
      œ: "oe",
      ŉ: "'n",
      ſ: "s"
    }, j9 = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&#39;"
    }, W9 = {
      "&amp;": "&",
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&#39;": "'"
    }, V9 = {
      "\\": "\\",
      "'": "'",
      "\n": "n",
      "\r": "r",
      "\u2028": "u2028",
      "\u2029": "u2029"
    }, k9 = parseFloat, H9 = parseInt, M0 = typeof Jn == "object" && Jn && Jn.Object === Object && Jn, Z9 = typeof self == "object" && self && self.Object === Object && self, zn = M0 || Z9 || Function("return this")(), Ya = n && !n.nodeType && n, st = Ya && !0 && l && !l.nodeType && l, B0 = st && st.exports === Ya, Ua = B0 && M0.process, Ru = function() {
      try {
        var B = st && st.require && st.require("util").types;
        return B || Ua && Ua.binding && Ua.binding("util");
      } catch {
      }
    }(), L0 = Ru && Ru.isArrayBuffer, G0 = Ru && Ru.isDate, j0 = Ru && Ru.isMap, W0 = Ru && Ru.isRegExp, V0 = Ru && Ru.isSet, k0 = Ru && Ru.isTypedArray;
    function bu(B, Z, k) {
      switch (k.length) {
        case 0:
          return B.call(Z);
        case 1:
          return B.call(Z, k[0]);
        case 2:
          return B.call(Z, k[0], k[1]);
        case 3:
          return B.call(Z, k[0], k[1], k[2]);
      }
      return B.apply(Z, k);
    }
    function X9(B, Z, k, vl) {
      for (var Dl = -1, ql = B == null ? 0 : B.length; ++Dl < ql; ) {
        var jn = B[Dl];
        Z(vl, jn, k(jn), B);
      }
      return vl;
    }
    function Ou(B, Z) {
      for (var k = -1, vl = B == null ? 0 : B.length; ++k < vl && Z(B[k], k, B) !== !1; )
        ;
      return B;
    }
    function z9(B, Z) {
      for (var k = B == null ? 0 : B.length; k-- && Z(B[k], k, B) !== !1; )
        ;
      return B;
    }
    function H0(B, Z) {
      for (var k = -1, vl = B == null ? 0 : B.length; ++k < vl; )
        if (!Z(B[k], k, B))
          return !1;
      return !0;
    }
    function De(B, Z) {
      for (var k = -1, vl = B == null ? 0 : B.length, Dl = 0, ql = []; ++k < vl; ) {
        var jn = B[k];
        Z(jn, k, B) && (ql[Dl++] = jn);
      }
      return ql;
    }
    function wi(B, Z) {
      var k = B == null ? 0 : B.length;
      return !!k && Ft(B, Z, 0) > -1;
    }
    function Ja(B, Z, k) {
      for (var vl = -1, Dl = B == null ? 0 : B.length; ++vl < Dl; )
        if (k(Z, B[vl]))
          return !0;
      return !1;
    }
    function $n(B, Z) {
      for (var k = -1, vl = B == null ? 0 : B.length, Dl = Array(vl); ++k < vl; )
        Dl[k] = Z(B[k], k, B);
      return Dl;
    }
    function Me(B, Z) {
      for (var k = -1, vl = Z.length, Dl = B.length; ++k < vl; )
        B[Dl + k] = Z[k];
      return B;
    }
    function Ka(B, Z, k, vl) {
      var Dl = -1, ql = B == null ? 0 : B.length;
      for (vl && ql && (k = B[++Dl]); ++Dl < ql; )
        k = Z(k, B[Dl], Dl, B);
      return k;
    }
    function Y9(B, Z, k, vl) {
      var Dl = B == null ? 0 : B.length;
      for (vl && Dl && (k = B[--Dl]); Dl--; )
        k = Z(k, B[Dl], Dl, B);
      return k;
    }
    function Qa(B, Z) {
      for (var k = -1, vl = B == null ? 0 : B.length; ++k < vl; )
        if (Z(B[k], k, B))
          return !0;
      return !1;
    }
    var U9 = qa("length");
    function J9(B) {
      return B.split("");
    }
    function K9(B) {
      return B.match(nl) || [];
    }
    function Z0(B, Z, k) {
      var vl;
      return k(B, function(Dl, ql, jn) {
        if (Z(Dl, ql, jn))
          return vl = ql, !1;
      }), vl;
    }
    function Ii(B, Z, k, vl) {
      for (var Dl = B.length, ql = k + (vl ? 1 : -1); vl ? ql-- : ++ql < Dl; )
        if (Z(B[ql], ql, B))
          return ql;
      return -1;
    }
    function Ft(B, Z, k) {
      return Z === Z ? sh(B, Z, k) : Ii(B, X0, k);
    }
    function Q9(B, Z, k, vl) {
      for (var Dl = k - 1, ql = B.length; ++Dl < ql; )
        if (vl(B[Dl], Z))
          return Dl;
      return -1;
    }
    function X0(B) {
      return B !== B;
    }
    function z0(B, Z) {
      var k = B == null ? 0 : B.length;
      return k ? ns(B, Z) / k : V;
    }
    function qa(B) {
      return function(Z) {
        return Z == null ? u : Z[B];
      };
    }
    function ls(B) {
      return function(Z) {
        return B == null ? u : B[Z];
      };
    }
    function Y0(B, Z, k, vl, Dl) {
      return Dl(B, function(ql, jn, cn) {
        k = vl ? (vl = !1, ql) : Z(k, ql, jn, cn);
      }), k;
    }
    function q9(B, Z) {
      var k = B.length;
      for (B.sort(Z); k--; )
        B[k] = B[k].value;
      return B;
    }
    function ns(B, Z) {
      for (var k, vl = -1, Dl = B.length; ++vl < Dl; ) {
        var ql = Z(B[vl]);
        ql !== u && (k = k === u ? ql : k + ql);
      }
      return k;
    }
    function us(B, Z) {
      for (var k = -1, vl = Array(B); ++k < B; )
        vl[k] = Z(k);
      return vl;
    }
    function lh(B, Z) {
      return $n(Z, function(k) {
        return [k, B[k]];
      });
    }
    function U0(B) {
      return B && B.slice(0, q0(B) + 1).replace(yr, "");
    }
    function yu(B) {
      return function(Z) {
        return B(Z);
      };
    }
    function es(B, Z) {
      return $n(Z, function(k) {
        return B[k];
      });
    }
    function $r(B, Z) {
      return B.has(Z);
    }
    function J0(B, Z) {
      for (var k = -1, vl = B.length; ++k < vl && Ft(Z, B[k], 0) > -1; )
        ;
      return k;
    }
    function K0(B, Z) {
      for (var k = B.length; k-- && Ft(Z, B[k], 0) > -1; )
        ;
      return k;
    }
    function nh(B, Z) {
      for (var k = B.length, vl = 0; k--; )
        B[k] === Z && ++vl;
      return vl;
    }
    var uh = ls(G9), eh = ls(j9);
    function th(B) {
      return "\\" + V9[B];
    }
    function rh(B, Z) {
      return B == null ? u : B[Z];
    }
    function _t(B) {
      return D9.test(B);
    }
    function ih(B) {
      return M9.test(B);
    }
    function oh(B) {
      for (var Z, k = []; !(Z = B.next()).done; )
        k.push(Z.value);
      return k;
    }
    function ts(B) {
      var Z = -1, k = Array(B.size);
      return B.forEach(function(vl, Dl) {
        k[++Z] = [Dl, vl];
      }), k;
    }
    function Q0(B, Z) {
      return function(k) {
        return B(Z(k));
      };
    }
    function Be(B, Z) {
      for (var k = -1, vl = B.length, Dl = 0, ql = []; ++k < vl; ) {
        var jn = B[k];
        (jn === Z || jn === p) && (B[k] = p, ql[Dl++] = k);
      }
      return ql;
    }
    function Ei(B) {
      var Z = -1, k = Array(B.size);
      return B.forEach(function(vl) {
        k[++Z] = vl;
      }), k;
    }
    function ah(B) {
      var Z = -1, k = Array(B.size);
      return B.forEach(function(vl) {
        k[++Z] = [vl, vl];
      }), k;
    }
    function sh(B, Z, k) {
      for (var vl = k - 1, Dl = B.length; ++vl < Dl; )
        if (B[vl] === Z)
          return vl;
      return -1;
    }
    function dh(B, Z, k) {
      for (var vl = k + 1; vl--; )
        if (B[vl] === Z)
          return vl;
      return vl;
    }
    function Dt(B) {
      return _t(B) ? fh(B) : U9(B);
    }
    function Xu(B) {
      return _t(B) ? ph(B) : J9(B);
    }
    function q0(B) {
      for (var Z = B.length; Z-- && ja.test(B.charAt(Z)); )
        ;
      return Z;
    }
    var ch = ls(W9);
    function fh(B) {
      for (var Z = za.lastIndex = 0; za.test(B); )
        ++Z;
      return Z;
    }
    function ph(B) {
      return B.match(za) || [];
    }
    function gh(B) {
      return B.match(_9) || [];
    }
    var hh = function B(Z) {
      Z = Z == null ? zn : Mt.defaults(zn.Object(), Z, Mt.pick(zn, B9));
      var k = Z.Array, vl = Z.Date, Dl = Z.Error, ql = Z.Function, jn = Z.Math, cn = Z.Object, rs = Z.RegExp, mh = Z.String, Fu = Z.TypeError, Ai = k.prototype, vh = ql.prototype, Bt = cn.prototype, Si = Z["__core-js_shared__"], Pi = vh.toString, an = Bt.hasOwnProperty, bh = 0, l1 = function() {
        var e = /[^.]+$/.exec(Si && Si.keys && Si.keys.IE_PROTO || "");
        return e ? "Symbol(src)_1." + e : "";
      }(), Ni = Bt.toString, yh = Pi.call(cn), $h = zn._, xh = rs(
        "^" + Pi.call(an).replace(br, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
      ), Ti = B0 ? Z.Buffer : u, Le = Z.Symbol, Ri = Z.Uint8Array, n1 = Ti ? Ti.allocUnsafe : u, Oi = Q0(cn.getPrototypeOf, cn), u1 = cn.create, e1 = Bt.propertyIsEnumerable, Fi = Ai.splice, t1 = Le ? Le.isConcatSpreadable : u, xr = Le ? Le.iterator : u, dt = Le ? Le.toStringTag : u, _i = function() {
        try {
          var e = ht(cn, "defineProperty");
          return e({}, "", {}), e;
        } catch {
        }
      }(), Ch = Z.clearTimeout !== zn.clearTimeout && Z.clearTimeout, wh = vl && vl.now !== zn.Date.now && vl.now, Ih = Z.setTimeout !== zn.setTimeout && Z.setTimeout, Di = jn.ceil, Mi = jn.floor, is = cn.getOwnPropertySymbols, Eh = Ti ? Ti.isBuffer : u, r1 = Z.isFinite, Ah = Ai.join, Sh = Q0(cn.keys, cn), Wn = jn.max, qn = jn.min, Ph = vl.now, Nh = Z.parseInt, i1 = jn.random, Th = Ai.reverse, os = ht(Z, "DataView"), Cr = ht(Z, "Map"), as = ht(Z, "Promise"), Lt = ht(Z, "Set"), wr = ht(Z, "WeakMap"), Ir = ht(cn, "create"), Bi = wr && new wr(), Gt = {}, Rh = mt(os), Oh = mt(Cr), Fh = mt(as), _h = mt(Lt), Dh = mt(wr), Li = Le ? Le.prototype : u, Er = Li ? Li.valueOf : u, o1 = Li ? Li.toString : u;
      function N(e) {
        if (Pn(e) && !Ml(e) && !(e instanceof Yl)) {
          if (e instanceof _u)
            return e;
          if (an.call(e, "__wrapped__"))
            return sf(e);
        }
        return new _u(e);
      }
      var jt = /* @__PURE__ */ function() {
        function e() {
        }
        return function(i) {
          if (!In(i))
            return {};
          if (u1)
            return u1(i);
          e.prototype = i;
          var f = new e();
          return e.prototype = u, f;
        };
      }();
      function Gi() {
      }
      function _u(e, i) {
        this.__wrapped__ = e, this.__actions__ = [], this.__chain__ = !!i, this.__index__ = 0, this.__values__ = u;
      }
      N.templateSettings = {
        /**
         * Used to detect `data` property values to be HTML-escaped.
         *
         * @memberOf _.templateSettings
         * @type {RegExp}
         */
        escape: La,
        /**
         * Used to detect code to be evaluated.
         *
         * @memberOf _.templateSettings
         * @type {RegExp}
         */
        evaluate: hi,
        /**
         * Used to detect `data` property values to inject.
         *
         * @memberOf _.templateSettings
         * @type {RegExp}
         */
        interpolate: mi,
        /**
         * Used to reference the data object in the template text.
         *
         * @memberOf _.templateSettings
         * @type {string}
         */
        variable: "",
        /**
         * Used to import variables into the compiled template.
         *
         * @memberOf _.templateSettings
         * @type {Object}
         */
        imports: {
          /**
           * A reference to the `lodash` function.
           *
           * @memberOf _.templateSettings.imports
           * @type {Function}
           */
          _: N
        }
      }, N.prototype = Gi.prototype, N.prototype.constructor = N, _u.prototype = jt(Gi.prototype), _u.prototype.constructor = _u;
      function Yl(e) {
        this.__wrapped__ = e, this.__actions__ = [], this.__dir__ = 1, this.__filtered__ = !1, this.__iteratees__ = [], this.__takeCount__ = X, this.__views__ = [];
      }
      function Mh() {
        var e = new Yl(this.__wrapped__);
        return e.__actions__ = du(this.__actions__), e.__dir__ = this.__dir__, e.__filtered__ = this.__filtered__, e.__iteratees__ = du(this.__iteratees__), e.__takeCount__ = this.__takeCount__, e.__views__ = du(this.__views__), e;
      }
      function Bh() {
        if (this.__filtered__) {
          var e = new Yl(this);
          e.__dir__ = -1, e.__filtered__ = !0;
        } else
          e = this.clone(), e.__dir__ *= -1;
        return e;
      }
      function Lh() {
        var e = this.__wrapped__.value(), i = this.__dir__, f = Ml(e), h = i < 0, w = f ? e.length : 0, T = J6(0, w, this.__views__), F = T.start, M = T.end, L = M - F, J = h ? M : F - 1, K = this.__iteratees__, q = K.length, pl = 0, bl = qn(L, this.__takeCount__);
        if (!f || !h && w == L && bl == L)
          return R1(e, this.__actions__);
        var Nl = [];
        l:
          for (; L-- && pl < bl; ) {
            J += i;
            for (var jl = -1, Tl = e[J]; ++jl < q; ) {
              var Zl = K[jl], Jl = Zl.iteratee, Cu = Zl.type, iu = Jl(Tl);
              if (Cu == rl)
                Tl = iu;
              else if (!iu) {
                if (Cu == il)
                  continue l;
                break l;
              }
            }
            Nl[pl++] = Tl;
          }
        return Nl;
      }
      Yl.prototype = jt(Gi.prototype), Yl.prototype.constructor = Yl;
      function ct(e) {
        var i = -1, f = e == null ? 0 : e.length;
        for (this.clear(); ++i < f; ) {
          var h = e[i];
          this.set(h[0], h[1]);
        }
      }
      function Gh() {
        this.__data__ = Ir ? Ir(null) : {}, this.size = 0;
      }
      function jh(e) {
        var i = this.has(e) && delete this.__data__[e];
        return this.size -= i ? 1 : 0, i;
      }
      function Wh(e) {
        var i = this.__data__;
        if (Ir) {
          var f = i[e];
          return f === a ? u : f;
        }
        return an.call(i, e) ? i[e] : u;
      }
      function Vh(e) {
        var i = this.__data__;
        return Ir ? i[e] !== u : an.call(i, e);
      }
      function kh(e, i) {
        var f = this.__data__;
        return this.size += this.has(e) ? 0 : 1, f[e] = Ir && i === u ? a : i, this;
      }
      ct.prototype.clear = Gh, ct.prototype.delete = jh, ct.prototype.get = Wh, ct.prototype.has = Vh, ct.prototype.set = kh;
      function he(e) {
        var i = -1, f = e == null ? 0 : e.length;
        for (this.clear(); ++i < f; ) {
          var h = e[i];
          this.set(h[0], h[1]);
        }
      }
      function Hh() {
        this.__data__ = [], this.size = 0;
      }
      function Zh(e) {
        var i = this.__data__, f = ji(i, e);
        if (f < 0)
          return !1;
        var h = i.length - 1;
        return f == h ? i.pop() : Fi.call(i, f, 1), --this.size, !0;
      }
      function Xh(e) {
        var i = this.__data__, f = ji(i, e);
        return f < 0 ? u : i[f][1];
      }
      function zh(e) {
        return ji(this.__data__, e) > -1;
      }
      function Yh(e, i) {
        var f = this.__data__, h = ji(f, e);
        return h < 0 ? (++this.size, f.push([e, i])) : f[h][1] = i, this;
      }
      he.prototype.clear = Hh, he.prototype.delete = Zh, he.prototype.get = Xh, he.prototype.has = zh, he.prototype.set = Yh;
      function me(e) {
        var i = -1, f = e == null ? 0 : e.length;
        for (this.clear(); ++i < f; ) {
          var h = e[i];
          this.set(h[0], h[1]);
        }
      }
      function Uh() {
        this.size = 0, this.__data__ = {
          hash: new ct(),
          map: new (Cr || he)(),
          string: new ct()
        };
      }
      function Jh(e) {
        var i = Qi(this, e).delete(e);
        return this.size -= i ? 1 : 0, i;
      }
      function Kh(e) {
        return Qi(this, e).get(e);
      }
      function Qh(e) {
        return Qi(this, e).has(e);
      }
      function qh(e, i) {
        var f = Qi(this, e), h = f.size;
        return f.set(e, i), this.size += f.size == h ? 0 : 1, this;
      }
      me.prototype.clear = Uh, me.prototype.delete = Jh, me.prototype.get = Kh, me.prototype.has = Qh, me.prototype.set = qh;
      function ft(e) {
        var i = -1, f = e == null ? 0 : e.length;
        for (this.__data__ = new me(); ++i < f; )
          this.add(e[i]);
      }
      function l6(e) {
        return this.__data__.set(e, a), this;
      }
      function n6(e) {
        return this.__data__.has(e);
      }
      ft.prototype.add = ft.prototype.push = l6, ft.prototype.has = n6;
      function zu(e) {
        var i = this.__data__ = new he(e);
        this.size = i.size;
      }
      function u6() {
        this.__data__ = new he(), this.size = 0;
      }
      function e6(e) {
        var i = this.__data__, f = i.delete(e);
        return this.size = i.size, f;
      }
      function t6(e) {
        return this.__data__.get(e);
      }
      function r6(e) {
        return this.__data__.has(e);
      }
      function i6(e, i) {
        var f = this.__data__;
        if (f instanceof he) {
          var h = f.__data__;
          if (!Cr || h.length < r - 1)
            return h.push([e, i]), this.size = ++f.size, this;
          f = this.__data__ = new me(h);
        }
        return f.set(e, i), this.size = f.size, this;
      }
      zu.prototype.clear = u6, zu.prototype.delete = e6, zu.prototype.get = t6, zu.prototype.has = r6, zu.prototype.set = i6;
      function a1(e, i) {
        var f = Ml(e), h = !f && vt(e), w = !f && !h && ke(e), T = !f && !h && !w && Ht(e), F = f || h || w || T, M = F ? us(e.length, mh) : [], L = M.length;
        for (var J in e)
          (i || an.call(e, J)) && !(F && // Safari 9 has enumerable `arguments.length` in strict mode.
          (J == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
          w && (J == "offset" || J == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
          T && (J == "buffer" || J == "byteLength" || J == "byteOffset") || // Skip index properties.
          $e(J, L))) && M.push(J);
        return M;
      }
      function s1(e) {
        var i = e.length;
        return i ? e[ys(0, i - 1)] : u;
      }
      function o6(e, i) {
        return qi(du(e), pt(i, 0, e.length));
      }
      function a6(e) {
        return qi(du(e));
      }
      function ss(e, i, f) {
        (f !== u && !Yu(e[i], f) || f === u && !(i in e)) && ve(e, i, f);
      }
      function Ar(e, i, f) {
        var h = e[i];
        (!(an.call(e, i) && Yu(h, f)) || f === u && !(i in e)) && ve(e, i, f);
      }
      function ji(e, i) {
        for (var f = e.length; f--; )
          if (Yu(e[f][0], i))
            return f;
        return -1;
      }
      function s6(e, i, f, h) {
        return Ge(e, function(w, T, F) {
          i(h, w, f(w), F);
        }), h;
      }
      function d1(e, i) {
        return e && re(i, Vn(i), e);
      }
      function d6(e, i) {
        return e && re(i, fu(i), e);
      }
      function ve(e, i, f) {
        i == "__proto__" && _i ? _i(e, i, {
          configurable: !0,
          enumerable: !0,
          value: f,
          writable: !0
        }) : e[i] = f;
      }
      function ds(e, i) {
        for (var f = -1, h = i.length, w = k(h), T = e == null; ++f < h; )
          w[f] = T ? u : Hs(e, i[f]);
        return w;
      }
      function pt(e, i, f) {
        return e === e && (f !== u && (e = e <= f ? e : f), i !== u && (e = e >= i ? e : i)), e;
      }
      function Du(e, i, f, h, w, T) {
        var F, M = i & g, L = i & m, J = i & v;
        if (f && (F = w ? f(e, h, w, T) : f(e)), F !== u)
          return F;
        if (!In(e))
          return e;
        var K = Ml(e);
        if (K) {
          if (F = Q6(e), !M)
            return du(e, F);
        } else {
          var q = lu(e), pl = q == Q || q == Xl;
          if (ke(e))
            return _1(e, M);
          if (q == dn || q == cl || pl && !w) {
            if (F = L || pl ? {} : q1(e), !M)
              return L ? W6(e, d6(F, e)) : j6(e, d1(F, e));
          } else {
            if (!pn[q])
              return w ? e : {};
            F = q6(e, q, M);
          }
        }
        T || (T = new zu());
        var bl = T.get(e);
        if (bl)
          return bl;
        T.set(e, F), Nf(e) ? e.forEach(function(Tl) {
          F.add(Du(Tl, i, f, Tl, e, T));
        }) : Sf(e) && e.forEach(function(Tl, Zl) {
          F.set(Zl, Du(Tl, i, f, Zl, e, T));
        });
        var Nl = J ? L ? Ts : Ns : L ? fu : Vn, jl = K ? u : Nl(e);
        return Ou(jl || e, function(Tl, Zl) {
          jl && (Zl = Tl, Tl = e[Zl]), Ar(F, Zl, Du(Tl, i, f, Zl, e, T));
        }), F;
      }
      function c6(e) {
        var i = Vn(e);
        return function(f) {
          return c1(f, e, i);
        };
      }
      function c1(e, i, f) {
        var h = f.length;
        if (e == null)
          return !h;
        for (e = cn(e); h--; ) {
          var w = f[h], T = i[w], F = e[w];
          if (F === u && !(w in e) || !T(F))
            return !1;
        }
        return !0;
      }
      function f1(e, i, f) {
        if (typeof e != "function")
          throw new Fu(s);
        return Fr(function() {
          e.apply(u, f);
        }, i);
      }
      function Sr(e, i, f, h) {
        var w = -1, T = wi, F = !0, M = e.length, L = [], J = i.length;
        if (!M)
          return L;
        f && (i = $n(i, yu(f))), h ? (T = Ja, F = !1) : i.length >= r && (T = $r, F = !1, i = new ft(i));
        l:
          for (; ++w < M; ) {
            var K = e[w], q = f == null ? K : f(K);
            if (K = h || K !== 0 ? K : 0, F && q === q) {
              for (var pl = J; pl--; )
                if (i[pl] === q)
                  continue l;
              L.push(K);
            } else T(i, q, h) || L.push(K);
          }
        return L;
      }
      var Ge = G1(te), p1 = G1(fs, !0);
      function f6(e, i) {
        var f = !0;
        return Ge(e, function(h, w, T) {
          return f = !!i(h, w, T), f;
        }), f;
      }
      function Wi(e, i, f) {
        for (var h = -1, w = e.length; ++h < w; ) {
          var T = e[h], F = i(T);
          if (F != null && (M === u ? F === F && !xu(F) : f(F, M)))
            var M = F, L = T;
        }
        return L;
      }
      function p6(e, i, f, h) {
        var w = e.length;
        for (f = Ll(f), f < 0 && (f = -f > w ? 0 : w + f), h = h === u || h > w ? w : Ll(h), h < 0 && (h += w), h = f > h ? 0 : Rf(h); f < h; )
          e[f++] = i;
        return e;
      }
      function g1(e, i) {
        var f = [];
        return Ge(e, function(h, w, T) {
          i(h, w, T) && f.push(h);
        }), f;
      }
      function Yn(e, i, f, h, w) {
        var T = -1, F = e.length;
        for (f || (f = nm), w || (w = []); ++T < F; ) {
          var M = e[T];
          i > 0 && f(M) ? i > 1 ? Yn(M, i - 1, f, h, w) : Me(w, M) : h || (w[w.length] = M);
        }
        return w;
      }
      var cs = j1(), h1 = j1(!0);
      function te(e, i) {
        return e && cs(e, i, Vn);
      }
      function fs(e, i) {
        return e && h1(e, i, Vn);
      }
      function Vi(e, i) {
        return De(i, function(f) {
          return xe(e[f]);
        });
      }
      function gt(e, i) {
        i = We(i, e);
        for (var f = 0, h = i.length; e != null && f < h; )
          e = e[ie(i[f++])];
        return f && f == h ? e : u;
      }
      function m1(e, i, f) {
        var h = i(e);
        return Ml(e) ? h : Me(h, f(e));
      }
      function tu(e) {
        return e == null ? e === u ? _e : fn : dt && dt in cn(e) ? U6(e) : am(e);
      }
      function ps(e, i) {
        return e > i;
      }
      function g6(e, i) {
        return e != null && an.call(e, i);
      }
      function h6(e, i) {
        return e != null && i in cn(e);
      }
      function m6(e, i, f) {
        return e >= qn(i, f) && e < Wn(i, f);
      }
      function gs(e, i, f) {
        for (var h = f ? Ja : wi, w = e[0].length, T = e.length, F = T, M = k(T), L = 1 / 0, J = []; F--; ) {
          var K = e[F];
          F && i && (K = $n(K, yu(i))), L = qn(K.length, L), M[F] = !f && (i || w >= 120 && K.length >= 120) ? new ft(F && K) : u;
        }
        K = e[0];
        var q = -1, pl = M[0];
        l:
          for (; ++q < w && J.length < L; ) {
            var bl = K[q], Nl = i ? i(bl) : bl;
            if (bl = f || bl !== 0 ? bl : 0, !(pl ? $r(pl, Nl) : h(J, Nl, f))) {
              for (F = T; --F; ) {
                var jl = M[F];
                if (!(jl ? $r(jl, Nl) : h(e[F], Nl, f)))
                  continue l;
              }
              pl && pl.push(Nl), J.push(bl);
            }
          }
        return J;
      }
      function v6(e, i, f, h) {
        return te(e, function(w, T, F) {
          i(h, f(w), T, F);
        }), h;
      }
      function Pr(e, i, f) {
        i = We(i, e), e = ef(e, i);
        var h = e == null ? e : e[ie(Bu(i))];
        return h == null ? u : bu(h, e, f);
      }
      function v1(e) {
        return Pn(e) && tu(e) == cl;
      }
      function b6(e) {
        return Pn(e) && tu(e) == Qn;
      }
      function y6(e) {
        return Pn(e) && tu(e) == Sl;
      }
      function Nr(e, i, f, h, w) {
        return e === i ? !0 : e == null || i == null || !Pn(e) && !Pn(i) ? e !== e && i !== i : $6(e, i, f, h, Nr, w);
      }
      function $6(e, i, f, h, w, T) {
        var F = Ml(e), M = Ml(i), L = F ? xl : lu(e), J = M ? xl : lu(i);
        L = L == cl ? dn : L, J = J == cl ? dn : J;
        var K = L == dn, q = J == dn, pl = L == J;
        if (pl && ke(e)) {
          if (!ke(i))
            return !1;
          F = !0, K = !1;
        }
        if (pl && !K)
          return T || (T = new zu()), F || Ht(e) ? J1(e, i, f, h, w, T) : z6(e, i, L, f, h, w, T);
        if (!(f & $)) {
          var bl = K && an.call(e, "__wrapped__"), Nl = q && an.call(i, "__wrapped__");
          if (bl || Nl) {
            var jl = bl ? e.value() : e, Tl = Nl ? i.value() : i;
            return T || (T = new zu()), w(jl, Tl, f, h, T);
          }
        }
        return pl ? (T || (T = new zu()), Y6(e, i, f, h, w, T)) : !1;
      }
      function x6(e) {
        return Pn(e) && lu(e) == Bl;
      }
      function hs(e, i, f, h) {
        var w = f.length, T = w, F = !h;
        if (e == null)
          return !T;
        for (e = cn(e); w--; ) {
          var M = f[w];
          if (F && M[2] ? M[1] !== e[M[0]] : !(M[0] in e))
            return !1;
        }
        for (; ++w < T; ) {
          M = f[w];
          var L = M[0], J = e[L], K = M[1];
          if (F && M[2]) {
            if (J === u && !(L in e))
              return !1;
          } else {
            var q = new zu();
            if (h)
              var pl = h(J, K, L, e, i, q);
            if (!(pl === u ? Nr(K, J, $ | b, h, q) : pl))
              return !1;
          }
        }
        return !0;
      }
      function b1(e) {
        if (!In(e) || em(e))
          return !1;
        var i = xe(e) ? xh : Xn;
        return i.test(mt(e));
      }
      function C6(e) {
        return Pn(e) && tu(e) == gn;
      }
      function w6(e) {
        return Pn(e) && lu(e) == _n;
      }
      function I6(e) {
        return Pn(e) && ro(e.length) && !!hn[tu(e)];
      }
      function y1(e) {
        return typeof e == "function" ? e : e == null ? pu : typeof e == "object" ? Ml(e) ? C1(e[0], e[1]) : x1(e) : Vf(e);
      }
      function ms(e) {
        if (!Or(e))
          return Sh(e);
        var i = [];
        for (var f in cn(e))
          an.call(e, f) && f != "constructor" && i.push(f);
        return i;
      }
      function E6(e) {
        if (!In(e))
          return om(e);
        var i = Or(e), f = [];
        for (var h in e)
          h == "constructor" && (i || !an.call(e, h)) || f.push(h);
        return f;
      }
      function vs(e, i) {
        return e < i;
      }
      function $1(e, i) {
        var f = -1, h = cu(e) ? k(e.length) : [];
        return Ge(e, function(w, T, F) {
          h[++f] = i(w, T, F);
        }), h;
      }
      function x1(e) {
        var i = Os(e);
        return i.length == 1 && i[0][2] ? nf(i[0][0], i[0][1]) : function(f) {
          return f === e || hs(f, e, i);
        };
      }
      function C1(e, i) {
        return _s(e) && lf(i) ? nf(ie(e), i) : function(f) {
          var h = Hs(f, e);
          return h === u && h === i ? Zs(f, e) : Nr(i, h, $ | b);
        };
      }
      function ki(e, i, f, h, w) {
        e !== i && cs(i, function(T, F) {
          if (w || (w = new zu()), In(T))
            A6(e, i, F, f, ki, h, w);
          else {
            var M = h ? h(Ms(e, F), T, F + "", e, i, w) : u;
            M === u && (M = T), ss(e, F, M);
          }
        }, fu);
      }
      function A6(e, i, f, h, w, T, F) {
        var M = Ms(e, f), L = Ms(i, f), J = F.get(L);
        if (J) {
          ss(e, f, J);
          return;
        }
        var K = T ? T(M, L, f + "", e, i, F) : u, q = K === u;
        if (q) {
          var pl = Ml(L), bl = !pl && ke(L), Nl = !pl && !bl && Ht(L);
          K = L, pl || bl || Nl ? Ml(M) ? K = M : Tn(M) ? K = du(M) : bl ? (q = !1, K = _1(L, !0)) : Nl ? (q = !1, K = D1(L, !0)) : K = [] : _r(L) || vt(L) ? (K = M, vt(M) ? K = Of(M) : (!In(M) || xe(M)) && (K = q1(L))) : q = !1;
        }
        q && (F.set(L, K), w(K, L, h, T, F), F.delete(L)), ss(e, f, K);
      }
      function w1(e, i) {
        var f = e.length;
        if (f)
          return i += i < 0 ? f : 0, $e(i, f) ? e[i] : u;
      }
      function I1(e, i, f) {
        i.length ? i = $n(i, function(T) {
          return Ml(T) ? function(F) {
            return gt(F, T.length === 1 ? T[0] : T);
          } : T;
        }) : i = [pu];
        var h = -1;
        i = $n(i, yu(Al()));
        var w = $1(e, function(T, F, M) {
          var L = $n(i, function(J) {
            return J(T);
          });
          return { criteria: L, index: ++h, value: T };
        });
        return q9(w, function(T, F) {
          return G6(T, F, f);
        });
      }
      function S6(e, i) {
        return E1(e, i, function(f, h) {
          return Zs(e, h);
        });
      }
      function E1(e, i, f) {
        for (var h = -1, w = i.length, T = {}; ++h < w; ) {
          var F = i[h], M = gt(e, F);
          f(M, F) && Tr(T, We(F, e), M);
        }
        return T;
      }
      function P6(e) {
        return function(i) {
          return gt(i, e);
        };
      }
      function bs(e, i, f, h) {
        var w = h ? Q9 : Ft, T = -1, F = i.length, M = e;
        for (e === i && (i = du(i)), f && (M = $n(e, yu(f))); ++T < F; )
          for (var L = 0, J = i[T], K = f ? f(J) : J; (L = w(M, K, L, h)) > -1; )
            M !== e && Fi.call(M, L, 1), Fi.call(e, L, 1);
        return e;
      }
      function A1(e, i) {
        for (var f = e ? i.length : 0, h = f - 1; f--; ) {
          var w = i[f];
          if (f == h || w !== T) {
            var T = w;
            $e(w) ? Fi.call(e, w, 1) : Cs(e, w);
          }
        }
        return e;
      }
      function ys(e, i) {
        return e + Mi(i1() * (i - e + 1));
      }
      function N6(e, i, f, h) {
        for (var w = -1, T = Wn(Di((i - e) / (f || 1)), 0), F = k(T); T--; )
          F[h ? T : ++w] = e, e += f;
        return F;
      }
      function $s(e, i) {
        var f = "";
        if (!e || i < 1 || i > ll)
          return f;
        do
          i % 2 && (f += e), i = Mi(i / 2), i && (e += e);
        while (i);
        return f;
      }
      function Wl(e, i) {
        return Bs(uf(e, i, pu), e + "");
      }
      function T6(e) {
        return s1(Zt(e));
      }
      function R6(e, i) {
        var f = Zt(e);
        return qi(f, pt(i, 0, f.length));
      }
      function Tr(e, i, f, h) {
        if (!In(e))
          return e;
        i = We(i, e);
        for (var w = -1, T = i.length, F = T - 1, M = e; M != null && ++w < T; ) {
          var L = ie(i[w]), J = f;
          if (L === "__proto__" || L === "constructor" || L === "prototype")
            return e;
          if (w != F) {
            var K = M[L];
            J = h ? h(K, L, M) : u, J === u && (J = In(K) ? K : $e(i[w + 1]) ? [] : {});
          }
          Ar(M, L, J), M = M[L];
        }
        return e;
      }
      var S1 = Bi ? function(e, i) {
        return Bi.set(e, i), e;
      } : pu, O6 = _i ? function(e, i) {
        return _i(e, "toString", {
          configurable: !0,
          enumerable: !1,
          value: zs(i),
          writable: !0
        });
      } : pu;
      function F6(e) {
        return qi(Zt(e));
      }
      function Mu(e, i, f) {
        var h = -1, w = e.length;
        i < 0 && (i = -i > w ? 0 : w + i), f = f > w ? w : f, f < 0 && (f += w), w = i > f ? 0 : f - i >>> 0, i >>>= 0;
        for (var T = k(w); ++h < w; )
          T[h] = e[h + i];
        return T;
      }
      function _6(e, i) {
        var f;
        return Ge(e, function(h, w, T) {
          return f = i(h, w, T), !f;
        }), !!f;
      }
      function Hi(e, i, f) {
        var h = 0, w = e == null ? h : e.length;
        if (typeof i == "number" && i === i && w <= fl) {
          for (; h < w; ) {
            var T = h + w >>> 1, F = e[T];
            F !== null && !xu(F) && (f ? F <= i : F < i) ? h = T + 1 : w = T;
          }
          return w;
        }
        return xs(e, i, pu, f);
      }
      function xs(e, i, f, h) {
        var w = 0, T = e == null ? 0 : e.length;
        if (T === 0)
          return 0;
        i = f(i);
        for (var F = i !== i, M = i === null, L = xu(i), J = i === u; w < T; ) {
          var K = Mi((w + T) / 2), q = f(e[K]), pl = q !== u, bl = q === null, Nl = q === q, jl = xu(q);
          if (F)
            var Tl = h || Nl;
          else J ? Tl = Nl && (h || pl) : M ? Tl = Nl && pl && (h || !bl) : L ? Tl = Nl && pl && !bl && (h || !jl) : bl || jl ? Tl = !1 : Tl = h ? q <= i : q < i;
          Tl ? w = K + 1 : T = K;
        }
        return qn(T, dl);
      }
      function P1(e, i) {
        for (var f = -1, h = e.length, w = 0, T = []; ++f < h; ) {
          var F = e[f], M = i ? i(F) : F;
          if (!f || !Yu(M, L)) {
            var L = M;
            T[w++] = F === 0 ? 0 : F;
          }
        }
        return T;
      }
      function N1(e) {
        return typeof e == "number" ? e : xu(e) ? V : +e;
      }
      function $u(e) {
        if (typeof e == "string")
          return e;
        if (Ml(e))
          return $n(e, $u) + "";
        if (xu(e))
          return o1 ? o1.call(e) : "";
        var i = e + "";
        return i == "0" && 1 / e == -sl ? "-0" : i;
      }
      function je(e, i, f) {
        var h = -1, w = wi, T = e.length, F = !0, M = [], L = M;
        if (f)
          F = !1, w = Ja;
        else if (T >= r) {
          var J = i ? null : Z6(e);
          if (J)
            return Ei(J);
          F = !1, w = $r, L = new ft();
        } else
          L = i ? [] : M;
        l:
          for (; ++h < T; ) {
            var K = e[h], q = i ? i(K) : K;
            if (K = f || K !== 0 ? K : 0, F && q === q) {
              for (var pl = L.length; pl--; )
                if (L[pl] === q)
                  continue l;
              i && L.push(q), M.push(K);
            } else w(L, q, f) || (L !== M && L.push(q), M.push(K));
          }
        return M;
      }
      function Cs(e, i) {
        return i = We(i, e), e = ef(e, i), e == null || delete e[ie(Bu(i))];
      }
      function T1(e, i, f, h) {
        return Tr(e, i, f(gt(e, i)), h);
      }
      function Zi(e, i, f, h) {
        for (var w = e.length, T = h ? w : -1; (h ? T-- : ++T < w) && i(e[T], T, e); )
          ;
        return f ? Mu(e, h ? 0 : T, h ? T + 1 : w) : Mu(e, h ? T + 1 : 0, h ? w : T);
      }
      function R1(e, i) {
        var f = e;
        return f instanceof Yl && (f = f.value()), Ka(i, function(h, w) {
          return w.func.apply(w.thisArg, Me([h], w.args));
        }, f);
      }
      function ws(e, i, f) {
        var h = e.length;
        if (h < 2)
          return h ? je(e[0]) : [];
        for (var w = -1, T = k(h); ++w < h; )
          for (var F = e[w], M = -1; ++M < h; )
            M != w && (T[w] = Sr(T[w] || F, e[M], i, f));
        return je(Yn(T, 1), i, f);
      }
      function O1(e, i, f) {
        for (var h = -1, w = e.length, T = i.length, F = {}; ++h < w; ) {
          var M = h < T ? i[h] : u;
          f(F, e[h], M);
        }
        return F;
      }
      function Is(e) {
        return Tn(e) ? e : [];
      }
      function Es(e) {
        return typeof e == "function" ? e : pu;
      }
      function We(e, i) {
        return Ml(e) ? e : _s(e, i) ? [e] : af(en(e));
      }
      var D6 = Wl;
      function Ve(e, i, f) {
        var h = e.length;
        return f = f === u ? h : f, !i && f >= h ? e : Mu(e, i, f);
      }
      var F1 = Ch || function(e) {
        return zn.clearTimeout(e);
      };
      function _1(e, i) {
        if (i)
          return e.slice();
        var f = e.length, h = n1 ? n1(f) : new e.constructor(f);
        return e.copy(h), h;
      }
      function As(e) {
        var i = new e.constructor(e.byteLength);
        return new Ri(i).set(new Ri(e)), i;
      }
      function M6(e, i) {
        var f = i ? As(e.buffer) : e.buffer;
        return new e.constructor(f, e.byteOffset, e.byteLength);
      }
      function B6(e) {
        var i = new e.constructor(e.source, un.exec(e));
        return i.lastIndex = e.lastIndex, i;
      }
      function L6(e) {
        return Er ? cn(Er.call(e)) : {};
      }
      function D1(e, i) {
        var f = i ? As(e.buffer) : e.buffer;
        return new e.constructor(f, e.byteOffset, e.length);
      }
      function M1(e, i) {
        if (e !== i) {
          var f = e !== u, h = e === null, w = e === e, T = xu(e), F = i !== u, M = i === null, L = i === i, J = xu(i);
          if (!M && !J && !T && e > i || T && F && L && !M && !J || h && F && L || !f && L || !w)
            return 1;
          if (!h && !T && !J && e < i || J && f && w && !h && !T || M && f && w || !F && w || !L)
            return -1;
        }
        return 0;
      }
      function G6(e, i, f) {
        for (var h = -1, w = e.criteria, T = i.criteria, F = w.length, M = f.length; ++h < F; ) {
          var L = M1(w[h], T[h]);
          if (L) {
            if (h >= M)
              return L;
            var J = f[h];
            return L * (J == "desc" ? -1 : 1);
          }
        }
        return e.index - i.index;
      }
      function B1(e, i, f, h) {
        for (var w = -1, T = e.length, F = f.length, M = -1, L = i.length, J = Wn(T - F, 0), K = k(L + J), q = !h; ++M < L; )
          K[M] = i[M];
        for (; ++w < F; )
          (q || w < T) && (K[f[w]] = e[w]);
        for (; J--; )
          K[M++] = e[w++];
        return K;
      }
      function L1(e, i, f, h) {
        for (var w = -1, T = e.length, F = -1, M = f.length, L = -1, J = i.length, K = Wn(T - M, 0), q = k(K + J), pl = !h; ++w < K; )
          q[w] = e[w];
        for (var bl = w; ++L < J; )
          q[bl + L] = i[L];
        for (; ++F < M; )
          (pl || w < T) && (q[bl + f[F]] = e[w++]);
        return q;
      }
      function du(e, i) {
        var f = -1, h = e.length;
        for (i || (i = k(h)); ++f < h; )
          i[f] = e[f];
        return i;
      }
      function re(e, i, f, h) {
        var w = !f;
        f || (f = {});
        for (var T = -1, F = i.length; ++T < F; ) {
          var M = i[T], L = h ? h(f[M], e[M], M, f, e) : u;
          L === u && (L = e[M]), w ? ve(f, M, L) : Ar(f, M, L);
        }
        return f;
      }
      function j6(e, i) {
        return re(e, Fs(e), i);
      }
      function W6(e, i) {
        return re(e, K1(e), i);
      }
      function Xi(e, i) {
        return function(f, h) {
          var w = Ml(f) ? X9 : s6, T = i ? i() : {};
          return w(f, e, Al(h, 2), T);
        };
      }
      function Wt(e) {
        return Wl(function(i, f) {
          var h = -1, w = f.length, T = w > 1 ? f[w - 1] : u, F = w > 2 ? f[2] : u;
          for (T = e.length > 3 && typeof T == "function" ? (w--, T) : u, F && ru(f[0], f[1], F) && (T = w < 3 ? u : T, w = 1), i = cn(i); ++h < w; ) {
            var M = f[h];
            M && e(i, M, h, T);
          }
          return i;
        });
      }
      function G1(e, i) {
        return function(f, h) {
          if (f == null)
            return f;
          if (!cu(f))
            return e(f, h);
          for (var w = f.length, T = i ? w : -1, F = cn(f); (i ? T-- : ++T < w) && h(F[T], T, F) !== !1; )
            ;
          return f;
        };
      }
      function j1(e) {
        return function(i, f, h) {
          for (var w = -1, T = cn(i), F = h(i), M = F.length; M--; ) {
            var L = F[e ? M : ++w];
            if (f(T[L], L, T) === !1)
              break;
          }
          return i;
        };
      }
      function V6(e, i, f) {
        var h = i & E, w = Rr(e);
        function T() {
          var F = this && this !== zn && this instanceof T ? w : e;
          return F.apply(h ? f : this, arguments);
        }
        return T;
      }
      function W1(e) {
        return function(i) {
          i = en(i);
          var f = _t(i) ? Xu(i) : u, h = f ? f[0] : i.charAt(0), w = f ? Ve(f, 1).join("") : i.slice(1);
          return h[e]() + w;
        };
      }
      function Vt(e) {
        return function(i) {
          return Ka(jf(Gf(i).replace(O9, "")), e, "");
        };
      }
      function Rr(e) {
        return function() {
          var i = arguments;
          switch (i.length) {
            case 0:
              return new e();
            case 1:
              return new e(i[0]);
            case 2:
              return new e(i[0], i[1]);
            case 3:
              return new e(i[0], i[1], i[2]);
            case 4:
              return new e(i[0], i[1], i[2], i[3]);
            case 5:
              return new e(i[0], i[1], i[2], i[3], i[4]);
            case 6:
              return new e(i[0], i[1], i[2], i[3], i[4], i[5]);
            case 7:
              return new e(i[0], i[1], i[2], i[3], i[4], i[5], i[6]);
          }
          var f = jt(e.prototype), h = e.apply(f, i);
          return In(h) ? h : f;
        };
      }
      function k6(e, i, f) {
        var h = Rr(e);
        function w() {
          for (var T = arguments.length, F = k(T), M = T, L = kt(w); M--; )
            F[M] = arguments[M];
          var J = T < 3 && F[0] !== L && F[T - 1] !== L ? [] : Be(F, L);
          if (T -= J.length, T < f)
            return X1(
              e,
              i,
              zi,
              w.placeholder,
              u,
              F,
              J,
              u,
              u,
              f - T
            );
          var K = this && this !== zn && this instanceof w ? h : e;
          return bu(K, this, F);
        }
        return w;
      }
      function V1(e) {
        return function(i, f, h) {
          var w = cn(i);
          if (!cu(i)) {
            var T = Al(f, 3);
            i = Vn(i), f = function(M) {
              return T(w[M], M, w);
            };
          }
          var F = e(i, f, h);
          return F > -1 ? w[T ? i[F] : F] : u;
        };
      }
      function k1(e) {
        return ye(function(i) {
          var f = i.length, h = f, w = _u.prototype.thru;
          for (e && i.reverse(); h--; ) {
            var T = i[h];
            if (typeof T != "function")
              throw new Fu(s);
            if (w && !F && Ki(T) == "wrapper")
              var F = new _u([], !0);
          }
          for (h = F ? h : f; ++h < f; ) {
            T = i[h];
            var M = Ki(T), L = M == "wrapper" ? Rs(T) : u;
            L && Ds(L[0]) && L[1] == (_ | x | P | j) && !L[4].length && L[9] == 1 ? F = F[Ki(L[0])].apply(F, L[3]) : F = T.length == 1 && Ds(T) ? F[M]() : F.thru(T);
          }
          return function() {
            var J = arguments, K = J[0];
            if (F && J.length == 1 && Ml(K))
              return F.plant(K).value();
            for (var q = 0, pl = f ? i[q].apply(this, J) : K; ++q < f; )
              pl = i[q].call(this, pl);
            return pl;
          };
        });
      }
      function zi(e, i, f, h, w, T, F, M, L, J) {
        var K = i & _, q = i & E, pl = i & S, bl = i & (x | I), Nl = i & z, jl = pl ? u : Rr(e);
        function Tl() {
          for (var Zl = arguments.length, Jl = k(Zl), Cu = Zl; Cu--; )
            Jl[Cu] = arguments[Cu];
          if (bl)
            var iu = kt(Tl), wu = nh(Jl, iu);
          if (h && (Jl = B1(Jl, h, w, bl)), T && (Jl = L1(Jl, T, F, bl)), Zl -= wu, bl && Zl < J) {
            var Rn = Be(Jl, iu);
            return X1(
              e,
              i,
              zi,
              Tl.placeholder,
              f,
              Jl,
              Rn,
              M,
              L,
              J - Zl
            );
          }
          var Uu = q ? f : this, we = pl ? Uu[e] : e;
          return Zl = Jl.length, M ? Jl = sm(Jl, M) : Nl && Zl > 1 && Jl.reverse(), K && L < Zl && (Jl.length = L), this && this !== zn && this instanceof Tl && (we = jl || Rr(we)), we.apply(Uu, Jl);
        }
        return Tl;
      }
      function H1(e, i) {
        return function(f, h) {
          return v6(f, e, i(h), {});
        };
      }
      function Yi(e, i) {
        return function(f, h) {
          var w;
          if (f === u && h === u)
            return i;
          if (f !== u && (w = f), h !== u) {
            if (w === u)
              return h;
            typeof f == "string" || typeof h == "string" ? (f = $u(f), h = $u(h)) : (f = N1(f), h = N1(h)), w = e(f, h);
          }
          return w;
        };
      }
      function Ss(e) {
        return ye(function(i) {
          return i = $n(i, yu(Al())), Wl(function(f) {
            var h = this;
            return e(i, function(w) {
              return bu(w, h, f);
            });
          });
        });
      }
      function Ui(e, i) {
        i = i === u ? " " : $u(i);
        var f = i.length;
        if (f < 2)
          return f ? $s(i, e) : i;
        var h = $s(i, Di(e / Dt(i)));
        return _t(i) ? Ve(Xu(h), 0, e).join("") : h.slice(0, e);
      }
      function H6(e, i, f, h) {
        var w = i & E, T = Rr(e);
        function F() {
          for (var M = -1, L = arguments.length, J = -1, K = h.length, q = k(K + L), pl = this && this !== zn && this instanceof F ? T : e; ++J < K; )
            q[J] = h[J];
          for (; L--; )
            q[J++] = arguments[++M];
          return bu(pl, w ? f : this, q);
        }
        return F;
      }
      function Z1(e) {
        return function(i, f, h) {
          return h && typeof h != "number" && ru(i, f, h) && (f = h = u), i = Ce(i), f === u ? (f = i, i = 0) : f = Ce(f), h = h === u ? i < f ? 1 : -1 : Ce(h), N6(i, f, h, e);
        };
      }
      function Ji(e) {
        return function(i, f) {
          return typeof i == "string" && typeof f == "string" || (i = Lu(i), f = Lu(f)), e(i, f);
        };
      }
      function X1(e, i, f, h, w, T, F, M, L, J) {
        var K = i & x, q = K ? F : u, pl = K ? u : F, bl = K ? T : u, Nl = K ? u : T;
        i |= K ? P : O, i &= ~(K ? O : P), i & A || (i &= ~(E | S));
        var jl = [
          e,
          i,
          w,
          bl,
          q,
          Nl,
          pl,
          M,
          L,
          J
        ], Tl = f.apply(u, jl);
        return Ds(e) && tf(Tl, jl), Tl.placeholder = h, rf(Tl, e, i);
      }
      function Ps(e) {
        var i = jn[e];
        return function(f, h) {
          if (f = Lu(f), h = h == null ? 0 : qn(Ll(h), 292), h && r1(f)) {
            var w = (en(f) + "e").split("e"), T = i(w[0] + "e" + (+w[1] + h));
            return w = (en(T) + "e").split("e"), +(w[0] + "e" + (+w[1] - h));
          }
          return i(f);
        };
      }
      var Z6 = Lt && 1 / Ei(new Lt([, -0]))[1] == sl ? function(e) {
        return new Lt(e);
      } : Js;
      function z1(e) {
        return function(i) {
          var f = lu(i);
          return f == Bl ? ts(i) : f == _n ? ah(i) : lh(i, e(i));
        };
      }
      function be(e, i, f, h, w, T, F, M) {
        var L = i & S;
        if (!L && typeof e != "function")
          throw new Fu(s);
        var J = h ? h.length : 0;
        if (J || (i &= ~(P | O), h = w = u), F = F === u ? F : Wn(Ll(F), 0), M = M === u ? M : Ll(M), J -= w ? w.length : 0, i & O) {
          var K = h, q = w;
          h = w = u;
        }
        var pl = L ? u : Rs(e), bl = [
          e,
          i,
          f,
          h,
          w,
          K,
          q,
          T,
          F,
          M
        ];
        if (pl && im(bl, pl), e = bl[0], i = bl[1], f = bl[2], h = bl[3], w = bl[4], M = bl[9] = bl[9] === u ? L ? 0 : e.length : Wn(bl[9] - J, 0), !M && i & (x | I) && (i &= ~(x | I)), !i || i == E)
          var Nl = V6(e, i, f);
        else i == x || i == I ? Nl = k6(e, i, M) : (i == P || i == (E | P)) && !w.length ? Nl = H6(e, i, f, h) : Nl = zi.apply(u, bl);
        var jl = pl ? S1 : tf;
        return rf(jl(Nl, bl), e, i);
      }
      function Y1(e, i, f, h) {
        return e === u || Yu(e, Bt[f]) && !an.call(h, f) ? i : e;
      }
      function U1(e, i, f, h, w, T) {
        return In(e) && In(i) && (T.set(i, e), ki(e, i, u, U1, T), T.delete(i)), e;
      }
      function X6(e) {
        return _r(e) ? u : e;
      }
      function J1(e, i, f, h, w, T) {
        var F = f & $, M = e.length, L = i.length;
        if (M != L && !(F && L > M))
          return !1;
        var J = T.get(e), K = T.get(i);
        if (J && K)
          return J == i && K == e;
        var q = -1, pl = !0, bl = f & b ? new ft() : u;
        for (T.set(e, i), T.set(i, e); ++q < M; ) {
          var Nl = e[q], jl = i[q];
          if (h)
            var Tl = F ? h(jl, Nl, q, i, e, T) : h(Nl, jl, q, e, i, T);
          if (Tl !== u) {
            if (Tl)
              continue;
            pl = !1;
            break;
          }
          if (bl) {
            if (!Qa(i, function(Zl, Jl) {
              if (!$r(bl, Jl) && (Nl === Zl || w(Nl, Zl, f, h, T)))
                return bl.push(Jl);
            })) {
              pl = !1;
              break;
            }
          } else if (!(Nl === jl || w(Nl, jl, f, h, T))) {
            pl = !1;
            break;
          }
        }
        return T.delete(e), T.delete(i), pl;
      }
      function z6(e, i, f, h, w, T, F) {
        switch (f) {
          case vu:
            if (e.byteLength != i.byteLength || e.byteOffset != i.byteOffset)
              return !1;
            e = e.buffer, i = i.buffer;
          case Qn:
            return !(e.byteLength != i.byteLength || !T(new Ri(e), new Ri(i)));
          case ml:
          case Sl:
          case Kl:
            return Yu(+e, +i);
          case Cl:
            return e.name == i.name && e.message == i.message;
          case gn:
          case Zn:
            return e == i + "";
          case Bl:
            var M = ts;
          case _n:
            var L = h & $;
            if (M || (M = Ei), e.size != i.size && !L)
              return !1;
            var J = F.get(e);
            if (J)
              return J == i;
            h |= b, F.set(e, i);
            var K = J1(M(e), M(i), h, w, T, F);
            return F.delete(e), K;
          case ue:
            if (Er)
              return Er.call(e) == Er.call(i);
        }
        return !1;
      }
      function Y6(e, i, f, h, w, T) {
        var F = f & $, M = Ns(e), L = M.length, J = Ns(i), K = J.length;
        if (L != K && !F)
          return !1;
        for (var q = L; q--; ) {
          var pl = M[q];
          if (!(F ? pl in i : an.call(i, pl)))
            return !1;
        }
        var bl = T.get(e), Nl = T.get(i);
        if (bl && Nl)
          return bl == i && Nl == e;
        var jl = !0;
        T.set(e, i), T.set(i, e);
        for (var Tl = F; ++q < L; ) {
          pl = M[q];
          var Zl = e[pl], Jl = i[pl];
          if (h)
            var Cu = F ? h(Jl, Zl, pl, i, e, T) : h(Zl, Jl, pl, e, i, T);
          if (!(Cu === u ? Zl === Jl || w(Zl, Jl, f, h, T) : Cu)) {
            jl = !1;
            break;
          }
          Tl || (Tl = pl == "constructor");
        }
        if (jl && !Tl) {
          var iu = e.constructor, wu = i.constructor;
          iu != wu && "constructor" in e && "constructor" in i && !(typeof iu == "function" && iu instanceof iu && typeof wu == "function" && wu instanceof wu) && (jl = !1);
        }
        return T.delete(e), T.delete(i), jl;
      }
      function ye(e) {
        return Bs(uf(e, u, ff), e + "");
      }
      function Ns(e) {
        return m1(e, Vn, Fs);
      }
      function Ts(e) {
        return m1(e, fu, K1);
      }
      var Rs = Bi ? function(e) {
        return Bi.get(e);
      } : Js;
      function Ki(e) {
        for (var i = e.name + "", f = Gt[i], h = an.call(Gt, i) ? f.length : 0; h--; ) {
          var w = f[h], T = w.func;
          if (T == null || T == e)
            return w.name;
        }
        return i;
      }
      function kt(e) {
        var i = an.call(N, "placeholder") ? N : e;
        return i.placeholder;
      }
      function Al() {
        var e = N.iteratee || Ys;
        return e = e === Ys ? y1 : e, arguments.length ? e(arguments[0], arguments[1]) : e;
      }
      function Qi(e, i) {
        var f = e.__data__;
        return um(i) ? f[typeof i == "string" ? "string" : "hash"] : f.map;
      }
      function Os(e) {
        for (var i = Vn(e), f = i.length; f--; ) {
          var h = i[f], w = e[h];
          i[f] = [h, w, lf(w)];
        }
        return i;
      }
      function ht(e, i) {
        var f = rh(e, i);
        return b1(f) ? f : u;
      }
      function U6(e) {
        var i = an.call(e, dt), f = e[dt];
        try {
          e[dt] = u;
          var h = !0;
        } catch {
        }
        var w = Ni.call(e);
        return h && (i ? e[dt] = f : delete e[dt]), w;
      }
      var Fs = is ? function(e) {
        return e == null ? [] : (e = cn(e), De(is(e), function(i) {
          return e1.call(e, i);
        }));
      } : Ks, K1 = is ? function(e) {
        for (var i = []; e; )
          Me(i, Fs(e)), e = Oi(e);
        return i;
      } : Ks, lu = tu;
      (os && lu(new os(new ArrayBuffer(1))) != vu || Cr && lu(new Cr()) != Bl || as && lu(as.resolve()) != Fn || Lt && lu(new Lt()) != _n || wr && lu(new wr()) != Tu) && (lu = function(e) {
        var i = tu(e), f = i == dn ? e.constructor : u, h = f ? mt(f) : "";
        if (h)
          switch (h) {
            case Rh:
              return vu;
            case Oh:
              return Bl;
            case Fh:
              return Fn;
            case _h:
              return _n;
            case Dh:
              return Tu;
          }
        return i;
      });
      function J6(e, i, f) {
        for (var h = -1, w = f.length; ++h < w; ) {
          var T = f[h], F = T.size;
          switch (T.type) {
            case "drop":
              e += F;
              break;
            case "dropRight":
              i -= F;
              break;
            case "take":
              i = qn(i, e + F);
              break;
            case "takeRight":
              e = Wn(e, i - F);
              break;
          }
        }
        return { start: e, end: i };
      }
      function K6(e) {
        var i = e.match(Va);
        return i ? i[1].split(D) : [];
      }
      function Q1(e, i, f) {
        i = We(i, e);
        for (var h = -1, w = i.length, T = !1; ++h < w; ) {
          var F = ie(i[h]);
          if (!(T = e != null && f(e, F)))
            break;
          e = e[F];
        }
        return T || ++h != w ? T : (w = e == null ? 0 : e.length, !!w && ro(w) && $e(F, w) && (Ml(e) || vt(e)));
      }
      function Q6(e) {
        var i = e.length, f = new e.constructor(i);
        return i && typeof e[0] == "string" && an.call(e, "index") && (f.index = e.index, f.input = e.input), f;
      }
      function q1(e) {
        return typeof e.constructor == "function" && !Or(e) ? jt(Oi(e)) : {};
      }
      function q6(e, i, f) {
        var h = e.constructor;
        switch (i) {
          case Qn:
            return As(e);
          case ml:
          case Sl:
            return new h(+e);
          case vu:
            return M6(e, f);
          case R:
          case G:
          case W:
          case al:
          case Pl:
          case Fl:
          case on:
          case Cn:
          case Dn:
            return D1(e, f);
          case Bl:
            return new h();
          case Kl:
          case Zn:
            return new h(e);
          case gn:
            return B6(e);
          case _n:
            return new h();
          case ue:
            return L6(e);
        }
      }
      function lm(e, i) {
        var f = i.length;
        if (!f)
          return e;
        var h = f - 1;
        return i[h] = (f > 1 ? "& " : "") + i[h], i = i.join(f > 2 ? ", " : " "), e.replace(Wa, `{
/* [wrapped with ` + i + `] */
`);
      }
      function nm(e) {
        return Ml(e) || vt(e) || !!(t1 && e && e[t1]);
      }
      function $e(e, i) {
        var f = typeof e;
        return i = i ?? ll, !!i && (f == "number" || f != "symbol" && Sn.test(e)) && e > -1 && e % 1 == 0 && e < i;
      }
      function ru(e, i, f) {
        if (!In(f))
          return !1;
        var h = typeof i;
        return (h == "number" ? cu(f) && $e(i, f.length) : h == "string" && i in f) ? Yu(f[i], e) : !1;
      }
      function _s(e, i) {
        if (Ml(e))
          return !1;
        var f = typeof e;
        return f == "number" || f == "symbol" || f == "boolean" || e == null || xu(e) ? !0 : yi.test(e) || !bi.test(e) || i != null && e in cn(i);
      }
      function um(e) {
        var i = typeof e;
        return i == "string" || i == "number" || i == "symbol" || i == "boolean" ? e !== "__proto__" : e === null;
      }
      function Ds(e) {
        var i = Ki(e), f = N[i];
        if (typeof f != "function" || !(i in Yl.prototype))
          return !1;
        if (e === f)
          return !0;
        var h = Rs(f);
        return !!h && e === h[0];
      }
      function em(e) {
        return !!l1 && l1 in e;
      }
      var tm = Si ? xe : Qs;
      function Or(e) {
        var i = e && e.constructor, f = typeof i == "function" && i.prototype || Bt;
        return e === f;
      }
      function lf(e) {
        return e === e && !In(e);
      }
      function nf(e, i) {
        return function(f) {
          return f == null ? !1 : f[e] === i && (i !== u || e in cn(f));
        };
      }
      function rm(e) {
        var i = eo(e, function(h) {
          return f.size === c && f.clear(), h;
        }), f = i.cache;
        return i;
      }
      function im(e, i) {
        var f = e[1], h = i[1], w = f | h, T = w < (E | S | _), F = h == _ && f == x || h == _ && f == j && e[7].length <= i[8] || h == (_ | j) && i[7].length <= i[8] && f == x;
        if (!(T || F))
          return e;
        h & E && (e[2] = i[2], w |= f & E ? 0 : A);
        var M = i[3];
        if (M) {
          var L = e[3];
          e[3] = L ? B1(L, M, i[4]) : M, e[4] = L ? Be(e[3], p) : i[4];
        }
        return M = i[5], M && (L = e[5], e[5] = L ? L1(L, M, i[6]) : M, e[6] = L ? Be(e[5], p) : i[6]), M = i[7], M && (e[7] = M), h & _ && (e[8] = e[8] == null ? i[8] : qn(e[8], i[8])), e[9] == null && (e[9] = i[9]), e[0] = i[0], e[1] = w, e;
      }
      function om(e) {
        var i = [];
        if (e != null)
          for (var f in cn(e))
            i.push(f);
        return i;
      }
      function am(e) {
        return Ni.call(e);
      }
      function uf(e, i, f) {
        return i = Wn(i === u ? e.length - 1 : i, 0), function() {
          for (var h = arguments, w = -1, T = Wn(h.length - i, 0), F = k(T); ++w < T; )
            F[w] = h[i + w];
          w = -1;
          for (var M = k(i + 1); ++w < i; )
            M[w] = h[w];
          return M[i] = f(F), bu(e, this, M);
        };
      }
      function ef(e, i) {
        return i.length < 2 ? e : gt(e, Mu(i, 0, -1));
      }
      function sm(e, i) {
        for (var f = e.length, h = qn(i.length, f), w = du(e); h--; ) {
          var T = i[h];
          e[h] = $e(T, f) ? w[T] : u;
        }
        return e;
      }
      function Ms(e, i) {
        if (!(i === "constructor" && typeof e[i] == "function") && i != "__proto__")
          return e[i];
      }
      var tf = of(S1), Fr = Ih || function(e, i) {
        return zn.setTimeout(e, i);
      }, Bs = of(O6);
      function rf(e, i, f) {
        var h = i + "";
        return Bs(e, lm(h, dm(K6(h), f)));
      }
      function of(e) {
        var i = 0, f = 0;
        return function() {
          var h = Ph(), w = ul - (h - f);
          if (f = h, w > 0) {
            if (++i >= U)
              return arguments[0];
          } else
            i = 0;
          return e.apply(u, arguments);
        };
      }
      function qi(e, i) {
        var f = -1, h = e.length, w = h - 1;
        for (i = i === u ? h : i; ++f < i; ) {
          var T = ys(f, w), F = e[T];
          e[T] = e[f], e[f] = F;
        }
        return e.length = i, e;
      }
      var af = rm(function(e) {
        var i = [];
        return e.charCodeAt(0) === 46 && i.push(""), e.replace(Ga, function(f, h, w, T) {
          i.push(w ? T.replace(_l, "$1") : h || f);
        }), i;
      });
      function ie(e) {
        if (typeof e == "string" || xu(e))
          return e;
        var i = e + "";
        return i == "0" && 1 / e == -sl ? "-0" : i;
      }
      function mt(e) {
        if (e != null) {
          try {
            return Pi.call(e);
          } catch {
          }
          try {
            return e + "";
          } catch {
          }
        }
        return "";
      }
      function dm(e, i) {
        return Ou($l, function(f) {
          var h = "_." + f[0];
          i & f[1] && !wi(e, h) && e.push(h);
        }), e.sort();
      }
      function sf(e) {
        if (e instanceof Yl)
          return e.clone();
        var i = new _u(e.__wrapped__, e.__chain__);
        return i.__actions__ = du(e.__actions__), i.__index__ = e.__index__, i.__values__ = e.__values__, i;
      }
      function cm(e, i, f) {
        (f ? ru(e, i, f) : i === u) ? i = 1 : i = Wn(Ll(i), 0);
        var h = e == null ? 0 : e.length;
        if (!h || i < 1)
          return [];
        for (var w = 0, T = 0, F = k(Di(h / i)); w < h; )
          F[T++] = Mu(e, w, w += i);
        return F;
      }
      function fm(e) {
        for (var i = -1, f = e == null ? 0 : e.length, h = 0, w = []; ++i < f; ) {
          var T = e[i];
          T && (w[h++] = T);
        }
        return w;
      }
      function pm() {
        var e = arguments.length;
        if (!e)
          return [];
        for (var i = k(e - 1), f = arguments[0], h = e; h--; )
          i[h - 1] = arguments[h];
        return Me(Ml(f) ? du(f) : [f], Yn(i, 1));
      }
      var gm = Wl(function(e, i) {
        return Tn(e) ? Sr(e, Yn(i, 1, Tn, !0)) : [];
      }), hm = Wl(function(e, i) {
        var f = Bu(i);
        return Tn(f) && (f = u), Tn(e) ? Sr(e, Yn(i, 1, Tn, !0), Al(f, 2)) : [];
      }), mm = Wl(function(e, i) {
        var f = Bu(i);
        return Tn(f) && (f = u), Tn(e) ? Sr(e, Yn(i, 1, Tn, !0), u, f) : [];
      });
      function vm(e, i, f) {
        var h = e == null ? 0 : e.length;
        return h ? (i = f || i === u ? 1 : Ll(i), Mu(e, i < 0 ? 0 : i, h)) : [];
      }
      function bm(e, i, f) {
        var h = e == null ? 0 : e.length;
        return h ? (i = f || i === u ? 1 : Ll(i), i = h - i, Mu(e, 0, i < 0 ? 0 : i)) : [];
      }
      function ym(e, i) {
        return e && e.length ? Zi(e, Al(i, 3), !0, !0) : [];
      }
      function $m(e, i) {
        return e && e.length ? Zi(e, Al(i, 3), !0) : [];
      }
      function xm(e, i, f, h) {
        var w = e == null ? 0 : e.length;
        return w ? (f && typeof f != "number" && ru(e, i, f) && (f = 0, h = w), p6(e, i, f, h)) : [];
      }
      function df(e, i, f) {
        var h = e == null ? 0 : e.length;
        if (!h)
          return -1;
        var w = f == null ? 0 : Ll(f);
        return w < 0 && (w = Wn(h + w, 0)), Ii(e, Al(i, 3), w);
      }
      function cf(e, i, f) {
        var h = e == null ? 0 : e.length;
        if (!h)
          return -1;
        var w = h - 1;
        return f !== u && (w = Ll(f), w = f < 0 ? Wn(h + w, 0) : qn(w, h - 1)), Ii(e, Al(i, 3), w, !0);
      }
      function ff(e) {
        var i = e == null ? 0 : e.length;
        return i ? Yn(e, 1) : [];
      }
      function Cm(e) {
        var i = e == null ? 0 : e.length;
        return i ? Yn(e, sl) : [];
      }
      function wm(e, i) {
        var f = e == null ? 0 : e.length;
        return f ? (i = i === u ? 1 : Ll(i), Yn(e, i)) : [];
      }
      function Im(e) {
        for (var i = -1, f = e == null ? 0 : e.length, h = {}; ++i < f; ) {
          var w = e[i];
          h[w[0]] = w[1];
        }
        return h;
      }
      function pf(e) {
        return e && e.length ? e[0] : u;
      }
      function Em(e, i, f) {
        var h = e == null ? 0 : e.length;
        if (!h)
          return -1;
        var w = f == null ? 0 : Ll(f);
        return w < 0 && (w = Wn(h + w, 0)), Ft(e, i, w);
      }
      function Am(e) {
        var i = e == null ? 0 : e.length;
        return i ? Mu(e, 0, -1) : [];
      }
      var Sm = Wl(function(e) {
        var i = $n(e, Is);
        return i.length && i[0] === e[0] ? gs(i) : [];
      }), Pm = Wl(function(e) {
        var i = Bu(e), f = $n(e, Is);
        return i === Bu(f) ? i = u : f.pop(), f.length && f[0] === e[0] ? gs(f, Al(i, 2)) : [];
      }), Nm = Wl(function(e) {
        var i = Bu(e), f = $n(e, Is);
        return i = typeof i == "function" ? i : u, i && f.pop(), f.length && f[0] === e[0] ? gs(f, u, i) : [];
      });
      function Tm(e, i) {
        return e == null ? "" : Ah.call(e, i);
      }
      function Bu(e) {
        var i = e == null ? 0 : e.length;
        return i ? e[i - 1] : u;
      }
      function Rm(e, i, f) {
        var h = e == null ? 0 : e.length;
        if (!h)
          return -1;
        var w = h;
        return f !== u && (w = Ll(f), w = w < 0 ? Wn(h + w, 0) : qn(w, h - 1)), i === i ? dh(e, i, w) : Ii(e, X0, w, !0);
      }
      function Om(e, i) {
        return e && e.length ? w1(e, Ll(i)) : u;
      }
      var Fm = Wl(gf);
      function gf(e, i) {
        return e && e.length && i && i.length ? bs(e, i) : e;
      }
      function _m(e, i, f) {
        return e && e.length && i && i.length ? bs(e, i, Al(f, 2)) : e;
      }
      function Dm(e, i, f) {
        return e && e.length && i && i.length ? bs(e, i, u, f) : e;
      }
      var Mm = ye(function(e, i) {
        var f = e == null ? 0 : e.length, h = ds(e, i);
        return A1(e, $n(i, function(w) {
          return $e(w, f) ? +w : w;
        }).sort(M1)), h;
      });
      function Bm(e, i) {
        var f = [];
        if (!(e && e.length))
          return f;
        var h = -1, w = [], T = e.length;
        for (i = Al(i, 3); ++h < T; ) {
          var F = e[h];
          i(F, h, e) && (f.push(F), w.push(h));
        }
        return A1(e, w), f;
      }
      function Ls(e) {
        return e == null ? e : Th.call(e);
      }
      function Lm(e, i, f) {
        var h = e == null ? 0 : e.length;
        return h ? (f && typeof f != "number" && ru(e, i, f) ? (i = 0, f = h) : (i = i == null ? 0 : Ll(i), f = f === u ? h : Ll(f)), Mu(e, i, f)) : [];
      }
      function Gm(e, i) {
        return Hi(e, i);
      }
      function jm(e, i, f) {
        return xs(e, i, Al(f, 2));
      }
      function Wm(e, i) {
        var f = e == null ? 0 : e.length;
        if (f) {
          var h = Hi(e, i);
          if (h < f && Yu(e[h], i))
            return h;
        }
        return -1;
      }
      function Vm(e, i) {
        return Hi(e, i, !0);
      }
      function km(e, i, f) {
        return xs(e, i, Al(f, 2), !0);
      }
      function Hm(e, i) {
        var f = e == null ? 0 : e.length;
        if (f) {
          var h = Hi(e, i, !0) - 1;
          if (Yu(e[h], i))
            return h;
        }
        return -1;
      }
      function Zm(e) {
        return e && e.length ? P1(e) : [];
      }
      function Xm(e, i) {
        return e && e.length ? P1(e, Al(i, 2)) : [];
      }
      function zm(e) {
        var i = e == null ? 0 : e.length;
        return i ? Mu(e, 1, i) : [];
      }
      function Ym(e, i, f) {
        return e && e.length ? (i = f || i === u ? 1 : Ll(i), Mu(e, 0, i < 0 ? 0 : i)) : [];
      }
      function Um(e, i, f) {
        var h = e == null ? 0 : e.length;
        return h ? (i = f || i === u ? 1 : Ll(i), i = h - i, Mu(e, i < 0 ? 0 : i, h)) : [];
      }
      function Jm(e, i) {
        return e && e.length ? Zi(e, Al(i, 3), !1, !0) : [];
      }
      function Km(e, i) {
        return e && e.length ? Zi(e, Al(i, 3)) : [];
      }
      var Qm = Wl(function(e) {
        return je(Yn(e, 1, Tn, !0));
      }), qm = Wl(function(e) {
        var i = Bu(e);
        return Tn(i) && (i = u), je(Yn(e, 1, Tn, !0), Al(i, 2));
      }), l7 = Wl(function(e) {
        var i = Bu(e);
        return i = typeof i == "function" ? i : u, je(Yn(e, 1, Tn, !0), u, i);
      });
      function n7(e) {
        return e && e.length ? je(e) : [];
      }
      function u7(e, i) {
        return e && e.length ? je(e, Al(i, 2)) : [];
      }
      function e7(e, i) {
        return i = typeof i == "function" ? i : u, e && e.length ? je(e, u, i) : [];
      }
      function Gs(e) {
        if (!(e && e.length))
          return [];
        var i = 0;
        return e = De(e, function(f) {
          if (Tn(f))
            return i = Wn(f.length, i), !0;
        }), us(i, function(f) {
          return $n(e, qa(f));
        });
      }
      function hf(e, i) {
        if (!(e && e.length))
          return [];
        var f = Gs(e);
        return i == null ? f : $n(f, function(h) {
          return bu(i, u, h);
        });
      }
      var t7 = Wl(function(e, i) {
        return Tn(e) ? Sr(e, i) : [];
      }), r7 = Wl(function(e) {
        return ws(De(e, Tn));
      }), i7 = Wl(function(e) {
        var i = Bu(e);
        return Tn(i) && (i = u), ws(De(e, Tn), Al(i, 2));
      }), o7 = Wl(function(e) {
        var i = Bu(e);
        return i = typeof i == "function" ? i : u, ws(De(e, Tn), u, i);
      }), a7 = Wl(Gs);
      function s7(e, i) {
        return O1(e || [], i || [], Ar);
      }
      function d7(e, i) {
        return O1(e || [], i || [], Tr);
      }
      var c7 = Wl(function(e) {
        var i = e.length, f = i > 1 ? e[i - 1] : u;
        return f = typeof f == "function" ? (e.pop(), f) : u, hf(e, f);
      });
      function mf(e) {
        var i = N(e);
        return i.__chain__ = !0, i;
      }
      function f7(e, i) {
        return i(e), e;
      }
      function lo(e, i) {
        return i(e);
      }
      var p7 = ye(function(e) {
        var i = e.length, f = i ? e[0] : 0, h = this.__wrapped__, w = function(T) {
          return ds(T, e);
        };
        return i > 1 || this.__actions__.length || !(h instanceof Yl) || !$e(f) ? this.thru(w) : (h = h.slice(f, +f + (i ? 1 : 0)), h.__actions__.push({
          func: lo,
          args: [w],
          thisArg: u
        }), new _u(h, this.__chain__).thru(function(T) {
          return i && !T.length && T.push(u), T;
        }));
      });
      function g7() {
        return mf(this);
      }
      function h7() {
        return new _u(this.value(), this.__chain__);
      }
      function m7() {
        this.__values__ === u && (this.__values__ = Tf(this.value()));
        var e = this.__index__ >= this.__values__.length, i = e ? u : this.__values__[this.__index__++];
        return { done: e, value: i };
      }
      function v7() {
        return this;
      }
      function b7(e) {
        for (var i, f = this; f instanceof Gi; ) {
          var h = sf(f);
          h.__index__ = 0, h.__values__ = u, i ? w.__wrapped__ = h : i = h;
          var w = h;
          f = f.__wrapped__;
        }
        return w.__wrapped__ = e, i;
      }
      function y7() {
        var e = this.__wrapped__;
        if (e instanceof Yl) {
          var i = e;
          return this.__actions__.length && (i = new Yl(this)), i = i.reverse(), i.__actions__.push({
            func: lo,
            args: [Ls],
            thisArg: u
          }), new _u(i, this.__chain__);
        }
        return this.thru(Ls);
      }
      function $7() {
        return R1(this.__wrapped__, this.__actions__);
      }
      var x7 = Xi(function(e, i, f) {
        an.call(e, f) ? ++e[f] : ve(e, f, 1);
      });
      function C7(e, i, f) {
        var h = Ml(e) ? H0 : f6;
        return f && ru(e, i, f) && (i = u), h(e, Al(i, 3));
      }
      function w7(e, i) {
        var f = Ml(e) ? De : g1;
        return f(e, Al(i, 3));
      }
      var I7 = V1(df), E7 = V1(cf);
      function A7(e, i) {
        return Yn(no(e, i), 1);
      }
      function S7(e, i) {
        return Yn(no(e, i), sl);
      }
      function P7(e, i, f) {
        return f = f === u ? 1 : Ll(f), Yn(no(e, i), f);
      }
      function vf(e, i) {
        var f = Ml(e) ? Ou : Ge;
        return f(e, Al(i, 3));
      }
      function bf(e, i) {
        var f = Ml(e) ? z9 : p1;
        return f(e, Al(i, 3));
      }
      var N7 = Xi(function(e, i, f) {
        an.call(e, f) ? e[f].push(i) : ve(e, f, [i]);
      });
      function T7(e, i, f, h) {
        e = cu(e) ? e : Zt(e), f = f && !h ? Ll(f) : 0;
        var w = e.length;
        return f < 0 && (f = Wn(w + f, 0)), io(e) ? f <= w && e.indexOf(i, f) > -1 : !!w && Ft(e, i, f) > -1;
      }
      var R7 = Wl(function(e, i, f) {
        var h = -1, w = typeof i == "function", T = cu(e) ? k(e.length) : [];
        return Ge(e, function(F) {
          T[++h] = w ? bu(i, F, f) : Pr(F, i, f);
        }), T;
      }), O7 = Xi(function(e, i, f) {
        ve(e, f, i);
      });
      function no(e, i) {
        var f = Ml(e) ? $n : $1;
        return f(e, Al(i, 3));
      }
      function F7(e, i, f, h) {
        return e == null ? [] : (Ml(i) || (i = i == null ? [] : [i]), f = h ? u : f, Ml(f) || (f = f == null ? [] : [f]), I1(e, i, f));
      }
      var _7 = Xi(function(e, i, f) {
        e[f ? 0 : 1].push(i);
      }, function() {
        return [[], []];
      });
      function D7(e, i, f) {
        var h = Ml(e) ? Ka : Y0, w = arguments.length < 3;
        return h(e, Al(i, 4), f, w, Ge);
      }
      function M7(e, i, f) {
        var h = Ml(e) ? Y9 : Y0, w = arguments.length < 3;
        return h(e, Al(i, 4), f, w, p1);
      }
      function B7(e, i) {
        var f = Ml(e) ? De : g1;
        return f(e, to(Al(i, 3)));
      }
      function L7(e) {
        var i = Ml(e) ? s1 : T6;
        return i(e);
      }
      function G7(e, i, f) {
        (f ? ru(e, i, f) : i === u) ? i = 1 : i = Ll(i);
        var h = Ml(e) ? o6 : R6;
        return h(e, i);
      }
      function j7(e) {
        var i = Ml(e) ? a6 : F6;
        return i(e);
      }
      function W7(e) {
        if (e == null)
          return 0;
        if (cu(e))
          return io(e) ? Dt(e) : e.length;
        var i = lu(e);
        return i == Bl || i == _n ? e.size : ms(e).length;
      }
      function V7(e, i, f) {
        var h = Ml(e) ? Qa : _6;
        return f && ru(e, i, f) && (i = u), h(e, Al(i, 3));
      }
      var k7 = Wl(function(e, i) {
        if (e == null)
          return [];
        var f = i.length;
        return f > 1 && ru(e, i[0], i[1]) ? i = [] : f > 2 && ru(i[0], i[1], i[2]) && (i = [i[0]]), I1(e, Yn(i, 1), []);
      }), uo = wh || function() {
        return zn.Date.now();
      };
      function H7(e, i) {
        if (typeof i != "function")
          throw new Fu(s);
        return e = Ll(e), function() {
          if (--e < 1)
            return i.apply(this, arguments);
        };
      }
      function yf(e, i, f) {
        return i = f ? u : i, i = e && i == null ? e.length : i, be(e, _, u, u, u, u, i);
      }
      function $f(e, i) {
        var f;
        if (typeof i != "function")
          throw new Fu(s);
        return e = Ll(e), function() {
          return --e > 0 && (f = i.apply(this, arguments)), e <= 1 && (i = u), f;
        };
      }
      var js = Wl(function(e, i, f) {
        var h = E;
        if (f.length) {
          var w = Be(f, kt(js));
          h |= P;
        }
        return be(e, h, i, f, w);
      }), xf = Wl(function(e, i, f) {
        var h = E | S;
        if (f.length) {
          var w = Be(f, kt(xf));
          h |= P;
        }
        return be(i, h, e, f, w);
      });
      function Cf(e, i, f) {
        i = f ? u : i;
        var h = be(e, x, u, u, u, u, u, i);
        return h.placeholder = Cf.placeholder, h;
      }
      function wf(e, i, f) {
        i = f ? u : i;
        var h = be(e, I, u, u, u, u, u, i);
        return h.placeholder = wf.placeholder, h;
      }
      function If(e, i, f) {
        var h, w, T, F, M, L, J = 0, K = !1, q = !1, pl = !0;
        if (typeof e != "function")
          throw new Fu(s);
        i = Lu(i) || 0, In(f) && (K = !!f.leading, q = "maxWait" in f, T = q ? Wn(Lu(f.maxWait) || 0, i) : T, pl = "trailing" in f ? !!f.trailing : pl);
        function bl(Rn) {
          var Uu = h, we = w;
          return h = w = u, J = Rn, F = e.apply(we, Uu), F;
        }
        function Nl(Rn) {
          return J = Rn, M = Fr(Zl, i), K ? bl(Rn) : F;
        }
        function jl(Rn) {
          var Uu = Rn - L, we = Rn - J, kf = i - Uu;
          return q ? qn(kf, T - we) : kf;
        }
        function Tl(Rn) {
          var Uu = Rn - L, we = Rn - J;
          return L === u || Uu >= i || Uu < 0 || q && we >= T;
        }
        function Zl() {
          var Rn = uo();
          if (Tl(Rn))
            return Jl(Rn);
          M = Fr(Zl, jl(Rn));
        }
        function Jl(Rn) {
          return M = u, pl && h ? bl(Rn) : (h = w = u, F);
        }
        function Cu() {
          M !== u && F1(M), J = 0, h = L = w = M = u;
        }
        function iu() {
          return M === u ? F : Jl(uo());
        }
        function wu() {
          var Rn = uo(), Uu = Tl(Rn);
          if (h = arguments, w = this, L = Rn, Uu) {
            if (M === u)
              return Nl(L);
            if (q)
              return F1(M), M = Fr(Zl, i), bl(L);
          }
          return M === u && (M = Fr(Zl, i)), F;
        }
        return wu.cancel = Cu, wu.flush = iu, wu;
      }
      var Z7 = Wl(function(e, i) {
        return f1(e, 1, i);
      }), X7 = Wl(function(e, i, f) {
        return f1(e, Lu(i) || 0, f);
      });
      function z7(e) {
        return be(e, z);
      }
      function eo(e, i) {
        if (typeof e != "function" || i != null && typeof i != "function")
          throw new Fu(s);
        var f = function() {
          var h = arguments, w = i ? i.apply(this, h) : h[0], T = f.cache;
          if (T.has(w))
            return T.get(w);
          var F = e.apply(this, h);
          return f.cache = T.set(w, F) || T, F;
        };
        return f.cache = new (eo.Cache || me)(), f;
      }
      eo.Cache = me;
      function to(e) {
        if (typeof e != "function")
          throw new Fu(s);
        return function() {
          var i = arguments;
          switch (i.length) {
            case 0:
              return !e.call(this);
            case 1:
              return !e.call(this, i[0]);
            case 2:
              return !e.call(this, i[0], i[1]);
            case 3:
              return !e.call(this, i[0], i[1], i[2]);
          }
          return !e.apply(this, i);
        };
      }
      function Y7(e) {
        return $f(2, e);
      }
      var U7 = D6(function(e, i) {
        i = i.length == 1 && Ml(i[0]) ? $n(i[0], yu(Al())) : $n(Yn(i, 1), yu(Al()));
        var f = i.length;
        return Wl(function(h) {
          for (var w = -1, T = qn(h.length, f); ++w < T; )
            h[w] = i[w].call(this, h[w]);
          return bu(e, this, h);
        });
      }), Ws = Wl(function(e, i) {
        var f = Be(i, kt(Ws));
        return be(e, P, u, i, f);
      }), Ef = Wl(function(e, i) {
        var f = Be(i, kt(Ef));
        return be(e, O, u, i, f);
      }), J7 = ye(function(e, i) {
        return be(e, j, u, u, u, i);
      });
      function K7(e, i) {
        if (typeof e != "function")
          throw new Fu(s);
        return i = i === u ? i : Ll(i), Wl(e, i);
      }
      function Q7(e, i) {
        if (typeof e != "function")
          throw new Fu(s);
        return i = i == null ? 0 : Wn(Ll(i), 0), Wl(function(f) {
          var h = f[i], w = Ve(f, 0, i);
          return h && Me(w, h), bu(e, this, w);
        });
      }
      function q7(e, i, f) {
        var h = !0, w = !0;
        if (typeof e != "function")
          throw new Fu(s);
        return In(f) && (h = "leading" in f ? !!f.leading : h, w = "trailing" in f ? !!f.trailing : w), If(e, i, {
          leading: h,
          maxWait: i,
          trailing: w
        });
      }
      function l8(e) {
        return yf(e, 1);
      }
      function n8(e, i) {
        return Ws(Es(i), e);
      }
      function u8() {
        if (!arguments.length)
          return [];
        var e = arguments[0];
        return Ml(e) ? e : [e];
      }
      function e8(e) {
        return Du(e, v);
      }
      function t8(e, i) {
        return i = typeof i == "function" ? i : u, Du(e, v, i);
      }
      function r8(e) {
        return Du(e, g | v);
      }
      function i8(e, i) {
        return i = typeof i == "function" ? i : u, Du(e, g | v, i);
      }
      function o8(e, i) {
        return i == null || c1(e, i, Vn(i));
      }
      function Yu(e, i) {
        return e === i || e !== e && i !== i;
      }
      var a8 = Ji(ps), s8 = Ji(function(e, i) {
        return e >= i;
      }), vt = v1(/* @__PURE__ */ function() {
        return arguments;
      }()) ? v1 : function(e) {
        return Pn(e) && an.call(e, "callee") && !e1.call(e, "callee");
      }, Ml = k.isArray, d8 = L0 ? yu(L0) : b6;
      function cu(e) {
        return e != null && ro(e.length) && !xe(e);
      }
      function Tn(e) {
        return Pn(e) && cu(e);
      }
      function c8(e) {
        return e === !0 || e === !1 || Pn(e) && tu(e) == ml;
      }
      var ke = Eh || Qs, f8 = G0 ? yu(G0) : y6;
      function p8(e) {
        return Pn(e) && e.nodeType === 1 && !_r(e);
      }
      function g8(e) {
        if (e == null)
          return !0;
        if (cu(e) && (Ml(e) || typeof e == "string" || typeof e.splice == "function" || ke(e) || Ht(e) || vt(e)))
          return !e.length;
        var i = lu(e);
        if (i == Bl || i == _n)
          return !e.size;
        if (Or(e))
          return !ms(e).length;
        for (var f in e)
          if (an.call(e, f))
            return !1;
        return !0;
      }
      function h8(e, i) {
        return Nr(e, i);
      }
      function m8(e, i, f) {
        f = typeof f == "function" ? f : u;
        var h = f ? f(e, i) : u;
        return h === u ? Nr(e, i, u, f) : !!h;
      }
      function Vs(e) {
        if (!Pn(e))
          return !1;
        var i = tu(e);
        return i == Cl || i == Ol || typeof e.message == "string" && typeof e.name == "string" && !_r(e);
      }
      function v8(e) {
        return typeof e == "number" && r1(e);
      }
      function xe(e) {
        if (!In(e))
          return !1;
        var i = tu(e);
        return i == Q || i == Xl || i == ol || i == sn;
      }
      function Af(e) {
        return typeof e == "number" && e == Ll(e);
      }
      function ro(e) {
        return typeof e == "number" && e > -1 && e % 1 == 0 && e <= ll;
      }
      function In(e) {
        var i = typeof e;
        return e != null && (i == "object" || i == "function");
      }
      function Pn(e) {
        return e != null && typeof e == "object";
      }
      var Sf = j0 ? yu(j0) : x6;
      function b8(e, i) {
        return e === i || hs(e, i, Os(i));
      }
      function y8(e, i, f) {
        return f = typeof f == "function" ? f : u, hs(e, i, Os(i), f);
      }
      function $8(e) {
        return Pf(e) && e != +e;
      }
      function x8(e) {
        if (tm(e))
          throw new Dl(o);
        return b1(e);
      }
      function C8(e) {
        return e === null;
      }
      function w8(e) {
        return e == null;
      }
      function Pf(e) {
        return typeof e == "number" || Pn(e) && tu(e) == Kl;
      }
      function _r(e) {
        if (!Pn(e) || tu(e) != dn)
          return !1;
        var i = Oi(e);
        if (i === null)
          return !0;
        var f = an.call(i, "constructor") && i.constructor;
        return typeof f == "function" && f instanceof f && Pi.call(f) == yh;
      }
      var ks = W0 ? yu(W0) : C6;
      function I8(e) {
        return Af(e) && e >= -ll && e <= ll;
      }
      var Nf = V0 ? yu(V0) : w6;
      function io(e) {
        return typeof e == "string" || !Ml(e) && Pn(e) && tu(e) == Zn;
      }
      function xu(e) {
        return typeof e == "symbol" || Pn(e) && tu(e) == ue;
      }
      var Ht = k0 ? yu(k0) : I6;
      function E8(e) {
        return e === u;
      }
      function A8(e) {
        return Pn(e) && lu(e) == Tu;
      }
      function S8(e) {
        return Pn(e) && tu(e) == ee;
      }
      var P8 = Ji(vs), N8 = Ji(function(e, i) {
        return e <= i;
      });
      function Tf(e) {
        if (!e)
          return [];
        if (cu(e))
          return io(e) ? Xu(e) : du(e);
        if (xr && e[xr])
          return oh(e[xr]());
        var i = lu(e), f = i == Bl ? ts : i == _n ? Ei : Zt;
        return f(e);
      }
      function Ce(e) {
        if (!e)
          return e === 0 ? e : 0;
        if (e = Lu(e), e === sl || e === -sl) {
          var i = e < 0 ? -1 : 1;
          return i * H;
        }
        return e === e ? e : 0;
      }
      function Ll(e) {
        var i = Ce(e), f = i % 1;
        return i === i ? f ? i - f : i : 0;
      }
      function Rf(e) {
        return e ? pt(Ll(e), 0, X) : 0;
      }
      function Lu(e) {
        if (typeof e == "number")
          return e;
        if (xu(e))
          return V;
        if (In(e)) {
          var i = typeof e.valueOf == "function" ? e.valueOf() : e;
          e = In(i) ? i + "" : i;
        }
        if (typeof e != "string")
          return e === 0 ? e : +e;
        e = U0(e);
        var f = kl.test(e);
        return f || wn.test(e) ? H9(e.slice(2), f ? 2 : 8) : zl.test(e) ? V : +e;
      }
      function Of(e) {
        return re(e, fu(e));
      }
      function T8(e) {
        return e ? pt(Ll(e), -ll, ll) : e === 0 ? e : 0;
      }
      function en(e) {
        return e == null ? "" : $u(e);
      }
      var R8 = Wt(function(e, i) {
        if (Or(i) || cu(i)) {
          re(i, Vn(i), e);
          return;
        }
        for (var f in i)
          an.call(i, f) && Ar(e, f, i[f]);
      }), Ff = Wt(function(e, i) {
        re(i, fu(i), e);
      }), oo = Wt(function(e, i, f, h) {
        re(i, fu(i), e, h);
      }), O8 = Wt(function(e, i, f, h) {
        re(i, Vn(i), e, h);
      }), F8 = ye(ds);
      function _8(e, i) {
        var f = jt(e);
        return i == null ? f : d1(f, i);
      }
      var D8 = Wl(function(e, i) {
        e = cn(e);
        var f = -1, h = i.length, w = h > 2 ? i[2] : u;
        for (w && ru(i[0], i[1], w) && (h = 1); ++f < h; )
          for (var T = i[f], F = fu(T), M = -1, L = F.length; ++M < L; ) {
            var J = F[M], K = e[J];
            (K === u || Yu(K, Bt[J]) && !an.call(e, J)) && (e[J] = T[J]);
          }
        return e;
      }), M8 = Wl(function(e) {
        return e.push(u, U1), bu(_f, u, e);
      });
      function B8(e, i) {
        return Z0(e, Al(i, 3), te);
      }
      function L8(e, i) {
        return Z0(e, Al(i, 3), fs);
      }
      function G8(e, i) {
        return e == null ? e : cs(e, Al(i, 3), fu);
      }
      function j8(e, i) {
        return e == null ? e : h1(e, Al(i, 3), fu);
      }
      function W8(e, i) {
        return e && te(e, Al(i, 3));
      }
      function V8(e, i) {
        return e && fs(e, Al(i, 3));
      }
      function k8(e) {
        return e == null ? [] : Vi(e, Vn(e));
      }
      function H8(e) {
        return e == null ? [] : Vi(e, fu(e));
      }
      function Hs(e, i, f) {
        var h = e == null ? u : gt(e, i);
        return h === u ? f : h;
      }
      function Z8(e, i) {
        return e != null && Q1(e, i, g6);
      }
      function Zs(e, i) {
        return e != null && Q1(e, i, h6);
      }
      var X8 = H1(function(e, i, f) {
        i != null && typeof i.toString != "function" && (i = Ni.call(i)), e[i] = f;
      }, zs(pu)), z8 = H1(function(e, i, f) {
        i != null && typeof i.toString != "function" && (i = Ni.call(i)), an.call(e, i) ? e[i].push(f) : e[i] = [f];
      }, Al), Y8 = Wl(Pr);
      function Vn(e) {
        return cu(e) ? a1(e) : ms(e);
      }
      function fu(e) {
        return cu(e) ? a1(e, !0) : E6(e);
      }
      function U8(e, i) {
        var f = {};
        return i = Al(i, 3), te(e, function(h, w, T) {
          ve(f, i(h, w, T), h);
        }), f;
      }
      function J8(e, i) {
        var f = {};
        return i = Al(i, 3), te(e, function(h, w, T) {
          ve(f, w, i(h, w, T));
        }), f;
      }
      var K8 = Wt(function(e, i, f) {
        ki(e, i, f);
      }), _f = Wt(function(e, i, f, h) {
        ki(e, i, f, h);
      }), Q8 = ye(function(e, i) {
        var f = {};
        if (e == null)
          return f;
        var h = !1;
        i = $n(i, function(T) {
          return T = We(T, e), h || (h = T.length > 1), T;
        }), re(e, Ts(e), f), h && (f = Du(f, g | m | v, X6));
        for (var w = i.length; w--; )
          Cs(f, i[w]);
        return f;
      });
      function q8(e, i) {
        return Df(e, to(Al(i)));
      }
      var lv = ye(function(e, i) {
        return e == null ? {} : S6(e, i);
      });
      function Df(e, i) {
        if (e == null)
          return {};
        var f = $n(Ts(e), function(h) {
          return [h];
        });
        return i = Al(i), E1(e, f, function(h, w) {
          return i(h, w[0]);
        });
      }
      function nv(e, i, f) {
        i = We(i, e);
        var h = -1, w = i.length;
        for (w || (w = 1, e = u); ++h < w; ) {
          var T = e == null ? u : e[ie(i[h])];
          T === u && (h = w, T = f), e = xe(T) ? T.call(e) : T;
        }
        return e;
      }
      function uv(e, i, f) {
        return e == null ? e : Tr(e, i, f);
      }
      function ev(e, i, f, h) {
        return h = typeof h == "function" ? h : u, e == null ? e : Tr(e, i, f, h);
      }
      var Mf = z1(Vn), Bf = z1(fu);
      function tv(e, i, f) {
        var h = Ml(e), w = h || ke(e) || Ht(e);
        if (i = Al(i, 4), f == null) {
          var T = e && e.constructor;
          w ? f = h ? new T() : [] : In(e) ? f = xe(T) ? jt(Oi(e)) : {} : f = {};
        }
        return (w ? Ou : te)(e, function(F, M, L) {
          return i(f, F, M, L);
        }), f;
      }
      function rv(e, i) {
        return e == null ? !0 : Cs(e, i);
      }
      function iv(e, i, f) {
        return e == null ? e : T1(e, i, Es(f));
      }
      function ov(e, i, f, h) {
        return h = typeof h == "function" ? h : u, e == null ? e : T1(e, i, Es(f), h);
      }
      function Zt(e) {
        return e == null ? [] : es(e, Vn(e));
      }
      function av(e) {
        return e == null ? [] : es(e, fu(e));
      }
      function sv(e, i, f) {
        return f === u && (f = i, i = u), f !== u && (f = Lu(f), f = f === f ? f : 0), i !== u && (i = Lu(i), i = i === i ? i : 0), pt(Lu(e), i, f);
      }
      function dv(e, i, f) {
        return i = Ce(i), f === u ? (f = i, i = 0) : f = Ce(f), e = Lu(e), m6(e, i, f);
      }
      function cv(e, i, f) {
        if (f && typeof f != "boolean" && ru(e, i, f) && (i = f = u), f === u && (typeof i == "boolean" ? (f = i, i = u) : typeof e == "boolean" && (f = e, e = u)), e === u && i === u ? (e = 0, i = 1) : (e = Ce(e), i === u ? (i = e, e = 0) : i = Ce(i)), e > i) {
          var h = e;
          e = i, i = h;
        }
        if (f || e % 1 || i % 1) {
          var w = i1();
          return qn(e + w * (i - e + k9("1e-" + ((w + "").length - 1))), i);
        }
        return ys(e, i);
      }
      var fv = Vt(function(e, i, f) {
        return i = i.toLowerCase(), e + (f ? Lf(i) : i);
      });
      function Lf(e) {
        return Xs(en(e).toLowerCase());
      }
      function Gf(e) {
        return e = en(e), e && e.replace(au, uh).replace(F9, "");
      }
      function pv(e, i, f) {
        e = en(e), i = $u(i);
        var h = e.length;
        f = f === u ? h : pt(Ll(f), 0, h);
        var w = f;
        return f -= i.length, f >= 0 && e.slice(f, w) == i;
      }
      function gv(e) {
        return e = en(e), e && gi.test(e) ? e.replace(Rt, eh) : e;
      }
      function hv(e) {
        return e = en(e), e && $i.test(e) ? e.replace(br, "\\$&") : e;
      }
      var mv = Vt(function(e, i, f) {
        return e + (f ? "-" : "") + i.toLowerCase();
      }), vv = Vt(function(e, i, f) {
        return e + (f ? " " : "") + i.toLowerCase();
      }), bv = W1("toLowerCase");
      function yv(e, i, f) {
        e = en(e), i = Ll(i);
        var h = i ? Dt(e) : 0;
        if (!i || h >= i)
          return e;
        var w = (i - h) / 2;
        return Ui(Mi(w), f) + e + Ui(Di(w), f);
      }
      function $v(e, i, f) {
        e = en(e), i = Ll(i);
        var h = i ? Dt(e) : 0;
        return i && h < i ? e + Ui(i - h, f) : e;
      }
      function xv(e, i, f) {
        e = en(e), i = Ll(i);
        var h = i ? Dt(e) : 0;
        return i && h < i ? Ui(i - h, f) + e : e;
      }
      function Cv(e, i, f) {
        return f || i == null ? i = 0 : i && (i = +i), Nh(en(e).replace(yr, ""), i || 0);
      }
      function wv(e, i, f) {
        return (f ? ru(e, i, f) : i === u) ? i = 1 : i = Ll(i), $s(en(e), i);
      }
      function Iv() {
        var e = arguments, i = en(e[0]);
        return e.length < 3 ? i : i.replace(e[1], e[2]);
      }
      var Ev = Vt(function(e, i, f) {
        return e + (f ? "_" : "") + i.toLowerCase();
      });
      function Av(e, i, f) {
        return f && typeof f != "number" && ru(e, i, f) && (i = f = u), f = f === u ? X : f >>> 0, f ? (e = en(e), e && (typeof i == "string" || i != null && !ks(i)) && (i = $u(i), !i && _t(e)) ? Ve(Xu(e), 0, f) : e.split(i, f)) : [];
      }
      var Sv = Vt(function(e, i, f) {
        return e + (f ? " " : "") + Xs(i);
      });
      function Pv(e, i, f) {
        return e = en(e), f = f == null ? 0 : pt(Ll(f), 0, e.length), i = $u(i), e.slice(f, f + i.length) == i;
      }
      function Nv(e, i, f) {
        var h = N.templateSettings;
        f && ru(e, i, f) && (i = u), e = en(e), i = oo({}, i, h, Y1);
        var w = oo({}, i.imports, h.imports, Y1), T = Vn(w), F = es(w, T), M, L, J = 0, K = i.interpolate || Zu, q = "__p += '", pl = rs(
          (i.escape || Zu).source + "|" + K.source + "|" + (K === mi ? Ql : Zu).source + "|" + (i.evaluate || Zu).source + "|$",
          "g"
        ), bl = "//# sourceURL=" + (an.call(i, "sourceURL") ? (i.sourceURL + "").replace(/\s/g, " ") : "lodash.templateSources[" + ++L9 + "]") + `
`;
        e.replace(pl, function(Tl, Zl, Jl, Cu, iu, wu) {
          return Jl || (Jl = Cu), q += e.slice(J, wu).replace(xi, th), Zl && (M = !0, q += `' +
__e(` + Zl + `) +
'`), iu && (L = !0, q += `';
` + iu + `;
__p += '`), Jl && (q += `' +
((__t = (` + Jl + `)) == null ? '' : __t) +
'`), J = wu + Tl.length, Tl;
        }), q += `';
`;
        var Nl = an.call(i, "variable") && i.variable;
        if (!Nl)
          q = `with (obj) {
` + q + `
}
`;
        else if (gl.test(Nl))
          throw new Dl(d);
        q = (L ? q.replace(Hu, "") : q).replace(at, "$1").replace(pi, "$1;"), q = "function(" + (Nl || "obj") + `) {
` + (Nl ? "" : `obj || (obj = {});
`) + "var __t, __p = ''" + (M ? ", __e = _.escape" : "") + (L ? `, __j = Array.prototype.join;
function print() { __p += __j.call(arguments, '') }
` : `;
`) + q + `return __p
}`;
        var jl = Wf(function() {
          return ql(T, bl + "return " + q).apply(u, F);
        });
        if (jl.source = q, Vs(jl))
          throw jl;
        return jl;
      }
      function Tv(e) {
        return en(e).toLowerCase();
      }
      function Rv(e) {
        return en(e).toUpperCase();
      }
      function Ov(e, i, f) {
        if (e = en(e), e && (f || i === u))
          return U0(e);
        if (!e || !(i = $u(i)))
          return e;
        var h = Xu(e), w = Xu(i), T = J0(h, w), F = K0(h, w) + 1;
        return Ve(h, T, F).join("");
      }
      function Fv(e, i, f) {
        if (e = en(e), e && (f || i === u))
          return e.slice(0, q0(e) + 1);
        if (!e || !(i = $u(i)))
          return e;
        var h = Xu(e), w = K0(h, Xu(i)) + 1;
        return Ve(h, 0, w).join("");
      }
      function _v(e, i, f) {
        if (e = en(e), e && (f || i === u))
          return e.replace(yr, "");
        if (!e || !(i = $u(i)))
          return e;
        var h = Xu(e), w = J0(h, Xu(i));
        return Ve(h, w).join("");
      }
      function Dv(e, i) {
        var f = Y, h = el;
        if (In(i)) {
          var w = "separator" in i ? i.separator : w;
          f = "length" in i ? Ll(i.length) : f, h = "omission" in i ? $u(i.omission) : h;
        }
        e = en(e);
        var T = e.length;
        if (_t(e)) {
          var F = Xu(e);
          T = F.length;
        }
        if (f >= T)
          return e;
        var M = f - Dt(h);
        if (M < 1)
          return h;
        var L = F ? Ve(F, 0, M).join("") : e.slice(0, M);
        if (w === u)
          return L + h;
        if (F && (M += L.length - M), ks(w)) {
          if (e.slice(M).search(w)) {
            var J, K = L;
            for (w.global || (w = rs(w.source, en(un.exec(w)) + "g")), w.lastIndex = 0; J = w.exec(K); )
              var q = J.index;
            L = L.slice(0, q === u ? M : q);
          }
        } else if (e.indexOf($u(w), M) != M) {
          var pl = L.lastIndexOf(w);
          pl > -1 && (L = L.slice(0, pl));
        }
        return L + h;
      }
      function Mv(e) {
        return e = en(e), e && vr.test(e) ? e.replace(ge, ch) : e;
      }
      var Bv = Vt(function(e, i, f) {
        return e + (f ? " " : "") + i.toUpperCase();
      }), Xs = W1("toUpperCase");
      function jf(e, i, f) {
        return e = en(e), i = f ? u : i, i === u ? ih(e) ? gh(e) : K9(e) : e.match(i) || [];
      }
      var Wf = Wl(function(e, i) {
        try {
          return bu(e, u, i);
        } catch (f) {
          return Vs(f) ? f : new Dl(f);
        }
      }), Lv = ye(function(e, i) {
        return Ou(i, function(f) {
          f = ie(f), ve(e, f, js(e[f], e));
        }), e;
      });
      function Gv(e) {
        var i = e == null ? 0 : e.length, f = Al();
        return e = i ? $n(e, function(h) {
          if (typeof h[1] != "function")
            throw new Fu(s);
          return [f(h[0]), h[1]];
        }) : [], Wl(function(h) {
          for (var w = -1; ++w < i; ) {
            var T = e[w];
            if (bu(T[0], this, h))
              return bu(T[1], this, h);
          }
        });
      }
      function jv(e) {
        return c6(Du(e, g));
      }
      function zs(e) {
        return function() {
          return e;
        };
      }
      function Wv(e, i) {
        return e == null || e !== e ? i : e;
      }
      var Vv = k1(), kv = k1(!0);
      function pu(e) {
        return e;
      }
      function Ys(e) {
        return y1(typeof e == "function" ? e : Du(e, g));
      }
      function Hv(e) {
        return x1(Du(e, g));
      }
      function Zv(e, i) {
        return C1(e, Du(i, g));
      }
      var Xv = Wl(function(e, i) {
        return function(f) {
          return Pr(f, e, i);
        };
      }), zv = Wl(function(e, i) {
        return function(f) {
          return Pr(e, f, i);
        };
      });
      function Us(e, i, f) {
        var h = Vn(i), w = Vi(i, h);
        f == null && !(In(i) && (w.length || !h.length)) && (f = i, i = e, e = this, w = Vi(i, Vn(i)));
        var T = !(In(f) && "chain" in f) || !!f.chain, F = xe(e);
        return Ou(w, function(M) {
          var L = i[M];
          e[M] = L, F && (e.prototype[M] = function() {
            var J = this.__chain__;
            if (T || J) {
              var K = e(this.__wrapped__), q = K.__actions__ = du(this.__actions__);
              return q.push({ func: L, args: arguments, thisArg: e }), K.__chain__ = J, K;
            }
            return L.apply(e, Me([this.value()], arguments));
          });
        }), e;
      }
      function Yv() {
        return zn._ === this && (zn._ = $h), this;
      }
      function Js() {
      }
      function Uv(e) {
        return e = Ll(e), Wl(function(i) {
          return w1(i, e);
        });
      }
      var Jv = Ss($n), Kv = Ss(H0), Qv = Ss(Qa);
      function Vf(e) {
        return _s(e) ? qa(ie(e)) : P6(e);
      }
      function qv(e) {
        return function(i) {
          return e == null ? u : gt(e, i);
        };
      }
      var lb = Z1(), nb = Z1(!0);
      function Ks() {
        return [];
      }
      function Qs() {
        return !1;
      }
      function ub() {
        return {};
      }
      function eb() {
        return "";
      }
      function tb() {
        return !0;
      }
      function rb(e, i) {
        if (e = Ll(e), e < 1 || e > ll)
          return [];
        var f = X, h = qn(e, X);
        i = Al(i), e -= X;
        for (var w = us(h, i); ++f < e; )
          i(f);
        return w;
      }
      function ib(e) {
        return Ml(e) ? $n(e, ie) : xu(e) ? [e] : du(af(en(e)));
      }
      function ob(e) {
        var i = ++bh;
        return en(e) + i;
      }
      var ab = Yi(function(e, i) {
        return e + i;
      }, 0), sb = Ps("ceil"), db = Yi(function(e, i) {
        return e / i;
      }, 1), cb = Ps("floor");
      function fb(e) {
        return e && e.length ? Wi(e, pu, ps) : u;
      }
      function pb(e, i) {
        return e && e.length ? Wi(e, Al(i, 2), ps) : u;
      }
      function gb(e) {
        return z0(e, pu);
      }
      function hb(e, i) {
        return z0(e, Al(i, 2));
      }
      function mb(e) {
        return e && e.length ? Wi(e, pu, vs) : u;
      }
      function vb(e, i) {
        return e && e.length ? Wi(e, Al(i, 2), vs) : u;
      }
      var bb = Yi(function(e, i) {
        return e * i;
      }, 1), yb = Ps("round"), $b = Yi(function(e, i) {
        return e - i;
      }, 0);
      function xb(e) {
        return e && e.length ? ns(e, pu) : 0;
      }
      function Cb(e, i) {
        return e && e.length ? ns(e, Al(i, 2)) : 0;
      }
      return N.after = H7, N.ary = yf, N.assign = R8, N.assignIn = Ff, N.assignInWith = oo, N.assignWith = O8, N.at = F8, N.before = $f, N.bind = js, N.bindAll = Lv, N.bindKey = xf, N.castArray = u8, N.chain = mf, N.chunk = cm, N.compact = fm, N.concat = pm, N.cond = Gv, N.conforms = jv, N.constant = zs, N.countBy = x7, N.create = _8, N.curry = Cf, N.curryRight = wf, N.debounce = If, N.defaults = D8, N.defaultsDeep = M8, N.defer = Z7, N.delay = X7, N.difference = gm, N.differenceBy = hm, N.differenceWith = mm, N.drop = vm, N.dropRight = bm, N.dropRightWhile = ym, N.dropWhile = $m, N.fill = xm, N.filter = w7, N.flatMap = A7, N.flatMapDeep = S7, N.flatMapDepth = P7, N.flatten = ff, N.flattenDeep = Cm, N.flattenDepth = wm, N.flip = z7, N.flow = Vv, N.flowRight = kv, N.fromPairs = Im, N.functions = k8, N.functionsIn = H8, N.groupBy = N7, N.initial = Am, N.intersection = Sm, N.intersectionBy = Pm, N.intersectionWith = Nm, N.invert = X8, N.invertBy = z8, N.invokeMap = R7, N.iteratee = Ys, N.keyBy = O7, N.keys = Vn, N.keysIn = fu, N.map = no, N.mapKeys = U8, N.mapValues = J8, N.matches = Hv, N.matchesProperty = Zv, N.memoize = eo, N.merge = K8, N.mergeWith = _f, N.method = Xv, N.methodOf = zv, N.mixin = Us, N.negate = to, N.nthArg = Uv, N.omit = Q8, N.omitBy = q8, N.once = Y7, N.orderBy = F7, N.over = Jv, N.overArgs = U7, N.overEvery = Kv, N.overSome = Qv, N.partial = Ws, N.partialRight = Ef, N.partition = _7, N.pick = lv, N.pickBy = Df, N.property = Vf, N.propertyOf = qv, N.pull = Fm, N.pullAll = gf, N.pullAllBy = _m, N.pullAllWith = Dm, N.pullAt = Mm, N.range = lb, N.rangeRight = nb, N.rearg = J7, N.reject = B7, N.remove = Bm, N.rest = K7, N.reverse = Ls, N.sampleSize = G7, N.set = uv, N.setWith = ev, N.shuffle = j7, N.slice = Lm, N.sortBy = k7, N.sortedUniq = Zm, N.sortedUniqBy = Xm, N.split = Av, N.spread = Q7, N.tail = zm, N.take = Ym, N.takeRight = Um, N.takeRightWhile = Jm, N.takeWhile = Km, N.tap = f7, N.throttle = q7, N.thru = lo, N.toArray = Tf, N.toPairs = Mf, N.toPairsIn = Bf, N.toPath = ib, N.toPlainObject = Of, N.transform = tv, N.unary = l8, N.union = Qm, N.unionBy = qm, N.unionWith = l7, N.uniq = n7, N.uniqBy = u7, N.uniqWith = e7, N.unset = rv, N.unzip = Gs, N.unzipWith = hf, N.update = iv, N.updateWith = ov, N.values = Zt, N.valuesIn = av, N.without = t7, N.words = jf, N.wrap = n8, N.xor = r7, N.xorBy = i7, N.xorWith = o7, N.zip = a7, N.zipObject = s7, N.zipObjectDeep = d7, N.zipWith = c7, N.entries = Mf, N.entriesIn = Bf, N.extend = Ff, N.extendWith = oo, Us(N, N), N.add = ab, N.attempt = Wf, N.camelCase = fv, N.capitalize = Lf, N.ceil = sb, N.clamp = sv, N.clone = e8, N.cloneDeep = r8, N.cloneDeepWith = i8, N.cloneWith = t8, N.conformsTo = o8, N.deburr = Gf, N.defaultTo = Wv, N.divide = db, N.endsWith = pv, N.eq = Yu, N.escape = gv, N.escapeRegExp = hv, N.every = C7, N.find = I7, N.findIndex = df, N.findKey = B8, N.findLast = E7, N.findLastIndex = cf, N.findLastKey = L8, N.floor = cb, N.forEach = vf, N.forEachRight = bf, N.forIn = G8, N.forInRight = j8, N.forOwn = W8, N.forOwnRight = V8, N.get = Hs, N.gt = a8, N.gte = s8, N.has = Z8, N.hasIn = Zs, N.head = pf, N.identity = pu, N.includes = T7, N.indexOf = Em, N.inRange = dv, N.invoke = Y8, N.isArguments = vt, N.isArray = Ml, N.isArrayBuffer = d8, N.isArrayLike = cu, N.isArrayLikeObject = Tn, N.isBoolean = c8, N.isBuffer = ke, N.isDate = f8, N.isElement = p8, N.isEmpty = g8, N.isEqual = h8, N.isEqualWith = m8, N.isError = Vs, N.isFinite = v8, N.isFunction = xe, N.isInteger = Af, N.isLength = ro, N.isMap = Sf, N.isMatch = b8, N.isMatchWith = y8, N.isNaN = $8, N.isNative = x8, N.isNil = w8, N.isNull = C8, N.isNumber = Pf, N.isObject = In, N.isObjectLike = Pn, N.isPlainObject = _r, N.isRegExp = ks, N.isSafeInteger = I8, N.isSet = Nf, N.isString = io, N.isSymbol = xu, N.isTypedArray = Ht, N.isUndefined = E8, N.isWeakMap = A8, N.isWeakSet = S8, N.join = Tm, N.kebabCase = mv, N.last = Bu, N.lastIndexOf = Rm, N.lowerCase = vv, N.lowerFirst = bv, N.lt = P8, N.lte = N8, N.max = fb, N.maxBy = pb, N.mean = gb, N.meanBy = hb, N.min = mb, N.minBy = vb, N.stubArray = Ks, N.stubFalse = Qs, N.stubObject = ub, N.stubString = eb, N.stubTrue = tb, N.multiply = bb, N.nth = Om, N.noConflict = Yv, N.noop = Js, N.now = uo, N.pad = yv, N.padEnd = $v, N.padStart = xv, N.parseInt = Cv, N.random = cv, N.reduce = D7, N.reduceRight = M7, N.repeat = wv, N.replace = Iv, N.result = nv, N.round = yb, N.runInContext = B, N.sample = L7, N.size = W7, N.snakeCase = Ev, N.some = V7, N.sortedIndex = Gm, N.sortedIndexBy = jm, N.sortedIndexOf = Wm, N.sortedLastIndex = Vm, N.sortedLastIndexBy = km, N.sortedLastIndexOf = Hm, N.startCase = Sv, N.startsWith = Pv, N.subtract = $b, N.sum = xb, N.sumBy = Cb, N.template = Nv, N.times = rb, N.toFinite = Ce, N.toInteger = Ll, N.toLength = Rf, N.toLower = Tv, N.toNumber = Lu, N.toSafeInteger = T8, N.toString = en, N.toUpper = Rv, N.trim = Ov, N.trimEnd = Fv, N.trimStart = _v, N.truncate = Dv, N.unescape = Mv, N.uniqueId = ob, N.upperCase = Bv, N.upperFirst = Xs, N.each = vf, N.eachRight = bf, N.first = pf, Us(N, function() {
        var e = {};
        return te(N, function(i, f) {
          an.call(N.prototype, f) || (e[f] = i);
        }), e;
      }(), { chain: !1 }), N.VERSION = t, Ou(["bind", "bindKey", "curry", "curryRight", "partial", "partialRight"], function(e) {
        N[e].placeholder = N;
      }), Ou(["drop", "take"], function(e, i) {
        Yl.prototype[e] = function(f) {
          f = f === u ? 1 : Wn(Ll(f), 0);
          var h = this.__filtered__ && !i ? new Yl(this) : this.clone();
          return h.__filtered__ ? h.__takeCount__ = qn(f, h.__takeCount__) : h.__views__.push({
            size: qn(f, X),
            type: e + (h.__dir__ < 0 ? "Right" : "")
          }), h;
        }, Yl.prototype[e + "Right"] = function(f) {
          return this.reverse()[e](f).reverse();
        };
      }), Ou(["filter", "map", "takeWhile"], function(e, i) {
        var f = i + 1, h = f == il || f == tl;
        Yl.prototype[e] = function(w) {
          var T = this.clone();
          return T.__iteratees__.push({
            iteratee: Al(w, 3),
            type: f
          }), T.__filtered__ = T.__filtered__ || h, T;
        };
      }), Ou(["head", "last"], function(e, i) {
        var f = "take" + (i ? "Right" : "");
        Yl.prototype[e] = function() {
          return this[f](1).value()[0];
        };
      }), Ou(["initial", "tail"], function(e, i) {
        var f = "drop" + (i ? "" : "Right");
        Yl.prototype[e] = function() {
          return this.__filtered__ ? new Yl(this) : this[f](1);
        };
      }), Yl.prototype.compact = function() {
        return this.filter(pu);
      }, Yl.prototype.find = function(e) {
        return this.filter(e).head();
      }, Yl.prototype.findLast = function(e) {
        return this.reverse().find(e);
      }, Yl.prototype.invokeMap = Wl(function(e, i) {
        return typeof e == "function" ? new Yl(this) : this.map(function(f) {
          return Pr(f, e, i);
        });
      }), Yl.prototype.reject = function(e) {
        return this.filter(to(Al(e)));
      }, Yl.prototype.slice = function(e, i) {
        e = Ll(e);
        var f = this;
        return f.__filtered__ && (e > 0 || i < 0) ? new Yl(f) : (e < 0 ? f = f.takeRight(-e) : e && (f = f.drop(e)), i !== u && (i = Ll(i), f = i < 0 ? f.dropRight(-i) : f.take(i - e)), f);
      }, Yl.prototype.takeRightWhile = function(e) {
        return this.reverse().takeWhile(e).reverse();
      }, Yl.prototype.toArray = function() {
        return this.take(X);
      }, te(Yl.prototype, function(e, i) {
        var f = /^(?:filter|find|map|reject)|While$/.test(i), h = /^(?:head|last)$/.test(i), w = N[h ? "take" + (i == "last" ? "Right" : "") : i], T = h || /^find/.test(i);
        w && (N.prototype[i] = function() {
          var F = this.__wrapped__, M = h ? [1] : arguments, L = F instanceof Yl, J = M[0], K = L || Ml(F), q = function(Zl) {
            var Jl = w.apply(N, Me([Zl], M));
            return h && pl ? Jl[0] : Jl;
          };
          K && f && typeof J == "function" && J.length != 1 && (L = K = !1);
          var pl = this.__chain__, bl = !!this.__actions__.length, Nl = T && !pl, jl = L && !bl;
          if (!T && K) {
            F = jl ? F : new Yl(this);
            var Tl = e.apply(F, M);
            return Tl.__actions__.push({ func: lo, args: [q], thisArg: u }), new _u(Tl, pl);
          }
          return Nl && jl ? e.apply(this, M) : (Tl = this.thru(q), Nl ? h ? Tl.value()[0] : Tl.value() : Tl);
        });
      }), Ou(["pop", "push", "shift", "sort", "splice", "unshift"], function(e) {
        var i = Ai[e], f = /^(?:push|sort|unshift)$/.test(e) ? "tap" : "thru", h = /^(?:pop|shift)$/.test(e);
        N.prototype[e] = function() {
          var w = arguments;
          if (h && !this.__chain__) {
            var T = this.value();
            return i.apply(Ml(T) ? T : [], w);
          }
          return this[f](function(F) {
            return i.apply(Ml(F) ? F : [], w);
          });
        };
      }), te(Yl.prototype, function(e, i) {
        var f = N[i];
        if (f) {
          var h = f.name + "";
          an.call(Gt, h) || (Gt[h] = []), Gt[h].push({ name: i, func: f });
        }
      }), Gt[zi(u, S).name] = [{
        name: "wrapper",
        func: u
      }], Yl.prototype.clone = Mh, Yl.prototype.reverse = Bh, Yl.prototype.value = Lh, N.prototype.at = p7, N.prototype.chain = g7, N.prototype.commit = h7, N.prototype.next = m7, N.prototype.plant = b7, N.prototype.reverse = y7, N.prototype.toJSON = N.prototype.valueOf = N.prototype.value = $7, N.prototype.first = N.prototype.head, xr && (N.prototype[xr] = v7), N;
    }, Mt = hh();
    st ? ((st.exports = Mt)._ = Mt, Ya._ = Mt) : zn._ = Mt;
  }).call(Jn);
})(Bo, Bo.exports);
var B3 = Bo.exports;
const oe = /* @__PURE__ */ oa(B3), fc = "-";
function Ob(l) {
  const n = _b(l), {
    conflictingClassGroups: u,
    conflictingClassGroupModifiers: t
  } = l;
  function r(s) {
    const d = s.split(fc);
    return d[0] === "" && d.length !== 1 && d.shift(), L3(d, n) || Fb(s);
  }
  function o(s, d) {
    const a = u[s] || [];
    return d && t[s] ? [...a, ...t[s]] : a;
  }
  return {
    getClassGroupId: r,
    getConflictingClassGroupIds: o
  };
}
function L3(l, n) {
  var s;
  if (l.length === 0)
    return n.classGroupId;
  const u = l[0], t = n.nextPart.get(u), r = t ? L3(l.slice(1), t) : void 0;
  if (r)
    return r;
  if (n.validators.length === 0)
    return;
  const o = l.join(fc);
  return (s = n.validators.find(({
    validator: d
  }) => d(o))) == null ? void 0 : s.classGroupId;
}
const Xf = /^\[(.+)\]$/;
function Fb(l) {
  if (Xf.test(l)) {
    const n = Xf.exec(l)[1], u = n == null ? void 0 : n.substring(0, n.indexOf(":"));
    if (u)
      return "arbitrary.." + u;
  }
}
function _b(l) {
  const {
    theme: n,
    prefix: u
  } = l, t = {
    nextPart: /* @__PURE__ */ new Map(),
    validators: []
  };
  return Mb(Object.entries(l.classGroups), u).forEach(([o, s]) => {
    $d(s, t, o, n);
  }), t;
}
function $d(l, n, u, t) {
  l.forEach((r) => {
    if (typeof r == "string") {
      const o = r === "" ? n : zf(n, r);
      o.classGroupId = u;
      return;
    }
    if (typeof r == "function") {
      if (Db(r)) {
        $d(r(t), n, u, t);
        return;
      }
      n.validators.push({
        validator: r,
        classGroupId: u
      });
      return;
    }
    Object.entries(r).forEach(([o, s]) => {
      $d(s, zf(n, o), u, t);
    });
  });
}
function zf(l, n) {
  let u = l;
  return n.split(fc).forEach((t) => {
    u.nextPart.has(t) || u.nextPart.set(t, {
      nextPart: /* @__PURE__ */ new Map(),
      validators: []
    }), u = u.nextPart.get(t);
  }), u;
}
function Db(l) {
  return l.isThemeGetter;
}
function Mb(l, n) {
  return n ? l.map(([u, t]) => {
    const r = t.map((o) => typeof o == "string" ? n + o : typeof o == "object" ? Object.fromEntries(Object.entries(o).map(([s, d]) => [n + s, d])) : o);
    return [u, r];
  }) : l;
}
function Bb(l) {
  if (l < 1)
    return {
      get: () => {
      },
      set: () => {
      }
    };
  let n = 0, u = /* @__PURE__ */ new Map(), t = /* @__PURE__ */ new Map();
  function r(o, s) {
    u.set(o, s), n++, n > l && (n = 0, t = u, u = /* @__PURE__ */ new Map());
  }
  return {
    get(o) {
      let s = u.get(o);
      if (s !== void 0)
        return s;
      if ((s = t.get(o)) !== void 0)
        return r(o, s), s;
    },
    set(o, s) {
      u.has(o) ? u.set(o, s) : r(o, s);
    }
  };
}
const G3 = "!";
function Lb(l) {
  const n = l.separator, u = n.length === 1, t = n[0], r = n.length;
  return function(s) {
    const d = [];
    let a = 0, c = 0, p;
    for (let b = 0; b < s.length; b++) {
      let E = s[b];
      if (a === 0) {
        if (E === t && (u || s.slice(b, b + r) === n)) {
          d.push(s.slice(c, b)), c = b + r;
          continue;
        }
        if (E === "/") {
          p = b;
          continue;
        }
      }
      E === "[" ? a++ : E === "]" && a--;
    }
    const g = d.length === 0 ? s : s.substring(c), m = g.startsWith(G3), v = m ? g.substring(1) : g, $ = p && p > c ? p - c : void 0;
    return {
      modifiers: d,
      hasImportantModifier: m,
      baseClassName: v,
      maybePostfixModifierPosition: $
    };
  };
}
function Gb(l) {
  if (l.length <= 1)
    return l;
  const n = [];
  let u = [];
  return l.forEach((t) => {
    t[0] === "[" ? (n.push(...u.sort(), t), u = []) : u.push(t);
  }), n.push(...u.sort()), n;
}
function jb(l) {
  return {
    cache: Bb(l.cacheSize),
    splitModifiers: Lb(l),
    ...Ob(l)
  };
}
const Wb = /\s+/;
function Vb(l, n) {
  const {
    splitModifiers: u,
    getClassGroupId: t,
    getConflictingClassGroupIds: r
  } = n, o = /* @__PURE__ */ new Set();
  return l.trim().split(Wb).map((s) => {
    const {
      modifiers: d,
      hasImportantModifier: a,
      baseClassName: c,
      maybePostfixModifierPosition: p
    } = u(s);
    let g = t(p ? c.substring(0, p) : c), m = !!p;
    if (!g) {
      if (!p)
        return {
          isTailwindClass: !1,
          originalClassName: s
        };
      if (g = t(c), !g)
        return {
          isTailwindClass: !1,
          originalClassName: s
        };
      m = !1;
    }
    const v = Gb(d).join(":");
    return {
      isTailwindClass: !0,
      modifierId: a ? v + G3 : v,
      classGroupId: g,
      originalClassName: s,
      hasPostfixModifier: m
    };
  }).reverse().filter((s) => {
    if (!s.isTailwindClass)
      return !0;
    const {
      modifierId: d,
      classGroupId: a,
      hasPostfixModifier: c
    } = s, p = d + a;
    return o.has(p) ? !1 : (o.add(p), r(a, c).forEach((g) => o.add(d + g)), !0);
  }).reverse().map((s) => s.originalClassName).join(" ");
}
function kb() {
  let l = 0, n, u, t = "";
  for (; l < arguments.length; )
    (n = arguments[l++]) && (u = j3(n)) && (t && (t += " "), t += u);
  return t;
}
function j3(l) {
  if (typeof l == "string")
    return l;
  let n, u = "";
  for (let t = 0; t < l.length; t++)
    l[t] && (n = j3(l[t])) && (u && (u += " "), u += n);
  return u;
}
function Hb(l, ...n) {
  let u, t, r, o = s;
  function s(a) {
    const c = n.reduce((p, g) => g(p), l());
    return u = jb(c), t = u.cache.get, r = u.cache.set, o = d, d(a);
  }
  function d(a) {
    const c = t(a);
    if (c)
      return c;
    const p = Vb(a, u);
    return r(a, p), p;
  }
  return function() {
    return o(kb.apply(null, arguments));
  };
}
function mn(l) {
  const n = (u) => u[l] || [];
  return n.isThemeGetter = !0, n;
}
const W3 = /^\[(?:([a-z-]+):)?(.+)\]$/i, Zb = /^\d+\/\d+$/, Xb = /* @__PURE__ */ new Set(["px", "full", "screen"]), zb = /^(\d+(\.\d+)?)?(xs|sm|md|lg|xl)$/, Yb = /\d+(%|px|r?em|[sdl]?v([hwib]|min|max)|pt|pc|in|cm|mm|cap|ch|ex|r?lh|cq(w|h|i|b|min|max))|\b(calc|min|max|clamp)\(.+\)|^0$/, Ub = /^(rgba?|hsla?|hwb|(ok)?(lab|lch))\(.+\)$/, Jb = /^(inset_)?-?((\d+)?\.?(\d+)[a-z]+|0)_-?((\d+)?\.?(\d+)[a-z]+|0)/, Kb = /^(url|image|image-set|cross-fade|element|(repeating-)?(linear|radial|conic)-gradient)\(.+\)$/;
function Ie(l) {
  return xt(l) || Xb.has(l) || Zb.test(l);
}
function He(l) {
  return ar(l, "length", ry);
}
function xt(l) {
  return !!l && !Number.isNaN(Number(l));
}
function ao(l) {
  return ar(l, "number", xt);
}
function Br(l) {
  return !!l && Number.isInteger(Number(l));
}
function Qb(l) {
  return l.endsWith("%") && xt(l.slice(0, -1));
}
function Gl(l) {
  return W3.test(l);
}
function Ze(l) {
  return zb.test(l);
}
const qb = /* @__PURE__ */ new Set(["length", "size", "percentage"]);
function ly(l) {
  return ar(l, qb, V3);
}
function ny(l) {
  return ar(l, "position", V3);
}
const uy = /* @__PURE__ */ new Set(["image", "url"]);
function ey(l) {
  return ar(l, uy, oy);
}
function ty(l) {
  return ar(l, "", iy);
}
function Lr() {
  return !0;
}
function ar(l, n, u) {
  const t = W3.exec(l);
  return t ? t[1] ? typeof n == "string" ? t[1] === n : n.has(t[1]) : u(t[2]) : !1;
}
function ry(l) {
  return Yb.test(l) && !Ub.test(l);
}
function V3() {
  return !1;
}
function iy(l) {
  return Jb.test(l);
}
function oy(l) {
  return Kb.test(l);
}
function ay() {
  const l = mn("colors"), n = mn("spacing"), u = mn("blur"), t = mn("brightness"), r = mn("borderColor"), o = mn("borderRadius"), s = mn("borderSpacing"), d = mn("borderWidth"), a = mn("contrast"), c = mn("grayscale"), p = mn("hueRotate"), g = mn("invert"), m = mn("gap"), v = mn("gradientColorStops"), $ = mn("gradientColorStopPositions"), b = mn("inset"), E = mn("margin"), S = mn("opacity"), A = mn("padding"), x = mn("saturate"), I = mn("scale"), P = mn("sepia"), O = mn("skew"), _ = mn("space"), j = mn("translate"), z = () => ["auto", "contain", "none"], Y = () => ["auto", "hidden", "clip", "visible", "scroll"], el = () => ["auto", Gl, n], U = () => [Gl, n], ul = () => ["", Ie, He], il = () => ["auto", xt, Gl], rl = () => ["bottom", "center", "left", "left-bottom", "left-top", "right", "right-bottom", "right-top", "top"], tl = () => ["solid", "dashed", "dotted", "double", "none"], sl = () => ["normal", "multiply", "screen", "overlay", "darken", "lighten", "color-dodge", "color-burn", "hard-light", "soft-light", "difference", "exclusion", "hue", "saturation", "color", "luminosity", "plus-lighter"], ll = () => ["start", "end", "center", "between", "around", "evenly", "stretch"], H = () => ["", "0", Gl], V = () => ["auto", "avoid", "all", "avoid-page", "page", "left", "right", "column"], X = () => [xt, ao], dl = () => [xt, Gl];
  return {
    cacheSize: 500,
    separator: ":",
    theme: {
      colors: [Lr],
      spacing: [Ie, He],
      blur: ["none", "", Ze, Gl],
      brightness: X(),
      borderColor: [l],
      borderRadius: ["none", "", "full", Ze, Gl],
      borderSpacing: U(),
      borderWidth: ul(),
      contrast: X(),
      grayscale: H(),
      hueRotate: dl(),
      invert: H(),
      gap: U(),
      gradientColorStops: [l],
      gradientColorStopPositions: [Qb, He],
      inset: el(),
      margin: el(),
      opacity: X(),
      padding: U(),
      saturate: X(),
      scale: X(),
      sepia: H(),
      skew: dl(),
      space: U(),
      translate: U()
    },
    classGroups: {
      // Layout
      /**
       * Aspect Ratio
       * @see https://tailwindcss.com/docs/aspect-ratio
       */
      aspect: [{
        aspect: ["auto", "square", "video", Gl]
      }],
      /**
       * Container
       * @see https://tailwindcss.com/docs/container
       */
      container: ["container"],
      /**
       * Columns
       * @see https://tailwindcss.com/docs/columns
       */
      columns: [{
        columns: [Ze]
      }],
      /**
       * Break After
       * @see https://tailwindcss.com/docs/break-after
       */
      "break-after": [{
        "break-after": V()
      }],
      /**
       * Break Before
       * @see https://tailwindcss.com/docs/break-before
       */
      "break-before": [{
        "break-before": V()
      }],
      /**
       * Break Inside
       * @see https://tailwindcss.com/docs/break-inside
       */
      "break-inside": [{
        "break-inside": ["auto", "avoid", "avoid-page", "avoid-column"]
      }],
      /**
       * Box Decoration Break
       * @see https://tailwindcss.com/docs/box-decoration-break
       */
      "box-decoration": [{
        "box-decoration": ["slice", "clone"]
      }],
      /**
       * Box Sizing
       * @see https://tailwindcss.com/docs/box-sizing
       */
      box: [{
        box: ["border", "content"]
      }],
      /**
       * Display
       * @see https://tailwindcss.com/docs/display
       */
      display: ["block", "inline-block", "inline", "flex", "inline-flex", "table", "inline-table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group", "table-row-group", "table-row", "flow-root", "grid", "inline-grid", "contents", "list-item", "hidden"],
      /**
       * Floats
       * @see https://tailwindcss.com/docs/float
       */
      float: [{
        float: ["right", "left", "none", "start", "end"]
      }],
      /**
       * Clear
       * @see https://tailwindcss.com/docs/clear
       */
      clear: [{
        clear: ["left", "right", "both", "none", "start", "end"]
      }],
      /**
       * Isolation
       * @see https://tailwindcss.com/docs/isolation
       */
      isolation: ["isolate", "isolation-auto"],
      /**
       * Object Fit
       * @see https://tailwindcss.com/docs/object-fit
       */
      "object-fit": [{
        object: ["contain", "cover", "fill", "none", "scale-down"]
      }],
      /**
       * Object Position
       * @see https://tailwindcss.com/docs/object-position
       */
      "object-position": [{
        object: [...rl(), Gl]
      }],
      /**
       * Overflow
       * @see https://tailwindcss.com/docs/overflow
       */
      overflow: [{
        overflow: Y()
      }],
      /**
       * Overflow X
       * @see https://tailwindcss.com/docs/overflow
       */
      "overflow-x": [{
        "overflow-x": Y()
      }],
      /**
       * Overflow Y
       * @see https://tailwindcss.com/docs/overflow
       */
      "overflow-y": [{
        "overflow-y": Y()
      }],
      /**
       * Overscroll Behavior
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      overscroll: [{
        overscroll: z()
      }],
      /**
       * Overscroll Behavior X
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      "overscroll-x": [{
        "overscroll-x": z()
      }],
      /**
       * Overscroll Behavior Y
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      "overscroll-y": [{
        "overscroll-y": z()
      }],
      /**
       * Position
       * @see https://tailwindcss.com/docs/position
       */
      position: ["static", "fixed", "absolute", "relative", "sticky"],
      /**
       * Top / Right / Bottom / Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      inset: [{
        inset: [b]
      }],
      /**
       * Right / Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      "inset-x": [{
        "inset-x": [b]
      }],
      /**
       * Top / Bottom
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      "inset-y": [{
        "inset-y": [b]
      }],
      /**
       * Start
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      start: [{
        start: [b]
      }],
      /**
       * End
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      end: [{
        end: [b]
      }],
      /**
       * Top
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      top: [{
        top: [b]
      }],
      /**
       * Right
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      right: [{
        right: [b]
      }],
      /**
       * Bottom
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      bottom: [{
        bottom: [b]
      }],
      /**
       * Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      left: [{
        left: [b]
      }],
      /**
       * Visibility
       * @see https://tailwindcss.com/docs/visibility
       */
      visibility: ["visible", "invisible", "collapse"],
      /**
       * Z-Index
       * @see https://tailwindcss.com/docs/z-index
       */
      z: [{
        z: ["auto", Br, Gl]
      }],
      // Flexbox and Grid
      /**
       * Flex Basis
       * @see https://tailwindcss.com/docs/flex-basis
       */
      basis: [{
        basis: el()
      }],
      /**
       * Flex Direction
       * @see https://tailwindcss.com/docs/flex-direction
       */
      "flex-direction": [{
        flex: ["row", "row-reverse", "col", "col-reverse"]
      }],
      /**
       * Flex Wrap
       * @see https://tailwindcss.com/docs/flex-wrap
       */
      "flex-wrap": [{
        flex: ["wrap", "wrap-reverse", "nowrap"]
      }],
      /**
       * Flex
       * @see https://tailwindcss.com/docs/flex
       */
      flex: [{
        flex: ["1", "auto", "initial", "none", Gl]
      }],
      /**
       * Flex Grow
       * @see https://tailwindcss.com/docs/flex-grow
       */
      grow: [{
        grow: H()
      }],
      /**
       * Flex Shrink
       * @see https://tailwindcss.com/docs/flex-shrink
       */
      shrink: [{
        shrink: H()
      }],
      /**
       * Order
       * @see https://tailwindcss.com/docs/order
       */
      order: [{
        order: ["first", "last", "none", Br, Gl]
      }],
      /**
       * Grid Template Columns
       * @see https://tailwindcss.com/docs/grid-template-columns
       */
      "grid-cols": [{
        "grid-cols": [Lr]
      }],
      /**
       * Grid Column Start / End
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-start-end": [{
        col: ["auto", {
          span: ["full", Br, Gl]
        }, Gl]
      }],
      /**
       * Grid Column Start
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-start": [{
        "col-start": il()
      }],
      /**
       * Grid Column End
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-end": [{
        "col-end": il()
      }],
      /**
       * Grid Template Rows
       * @see https://tailwindcss.com/docs/grid-template-rows
       */
      "grid-rows": [{
        "grid-rows": [Lr]
      }],
      /**
       * Grid Row Start / End
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-start-end": [{
        row: ["auto", {
          span: [Br, Gl]
        }, Gl]
      }],
      /**
       * Grid Row Start
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-start": [{
        "row-start": il()
      }],
      /**
       * Grid Row End
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-end": [{
        "row-end": il()
      }],
      /**
       * Grid Auto Flow
       * @see https://tailwindcss.com/docs/grid-auto-flow
       */
      "grid-flow": [{
        "grid-flow": ["row", "col", "dense", "row-dense", "col-dense"]
      }],
      /**
       * Grid Auto Columns
       * @see https://tailwindcss.com/docs/grid-auto-columns
       */
      "auto-cols": [{
        "auto-cols": ["auto", "min", "max", "fr", Gl]
      }],
      /**
       * Grid Auto Rows
       * @see https://tailwindcss.com/docs/grid-auto-rows
       */
      "auto-rows": [{
        "auto-rows": ["auto", "min", "max", "fr", Gl]
      }],
      /**
       * Gap
       * @see https://tailwindcss.com/docs/gap
       */
      gap: [{
        gap: [m]
      }],
      /**
       * Gap X
       * @see https://tailwindcss.com/docs/gap
       */
      "gap-x": [{
        "gap-x": [m]
      }],
      /**
       * Gap Y
       * @see https://tailwindcss.com/docs/gap
       */
      "gap-y": [{
        "gap-y": [m]
      }],
      /**
       * Justify Content
       * @see https://tailwindcss.com/docs/justify-content
       */
      "justify-content": [{
        justify: ["normal", ...ll()]
      }],
      /**
       * Justify Items
       * @see https://tailwindcss.com/docs/justify-items
       */
      "justify-items": [{
        "justify-items": ["start", "end", "center", "stretch"]
      }],
      /**
       * Justify Self
       * @see https://tailwindcss.com/docs/justify-self
       */
      "justify-self": [{
        "justify-self": ["auto", "start", "end", "center", "stretch"]
      }],
      /**
       * Align Content
       * @see https://tailwindcss.com/docs/align-content
       */
      "align-content": [{
        content: ["normal", ...ll(), "baseline"]
      }],
      /**
       * Align Items
       * @see https://tailwindcss.com/docs/align-items
       */
      "align-items": [{
        items: ["start", "end", "center", "baseline", "stretch"]
      }],
      /**
       * Align Self
       * @see https://tailwindcss.com/docs/align-self
       */
      "align-self": [{
        self: ["auto", "start", "end", "center", "stretch", "baseline"]
      }],
      /**
       * Place Content
       * @see https://tailwindcss.com/docs/place-content
       */
      "place-content": [{
        "place-content": [...ll(), "baseline"]
      }],
      /**
       * Place Items
       * @see https://tailwindcss.com/docs/place-items
       */
      "place-items": [{
        "place-items": ["start", "end", "center", "baseline", "stretch"]
      }],
      /**
       * Place Self
       * @see https://tailwindcss.com/docs/place-self
       */
      "place-self": [{
        "place-self": ["auto", "start", "end", "center", "stretch"]
      }],
      // Spacing
      /**
       * Padding
       * @see https://tailwindcss.com/docs/padding
       */
      p: [{
        p: [A]
      }],
      /**
       * Padding X
       * @see https://tailwindcss.com/docs/padding
       */
      px: [{
        px: [A]
      }],
      /**
       * Padding Y
       * @see https://tailwindcss.com/docs/padding
       */
      py: [{
        py: [A]
      }],
      /**
       * Padding Start
       * @see https://tailwindcss.com/docs/padding
       */
      ps: [{
        ps: [A]
      }],
      /**
       * Padding End
       * @see https://tailwindcss.com/docs/padding
       */
      pe: [{
        pe: [A]
      }],
      /**
       * Padding Top
       * @see https://tailwindcss.com/docs/padding
       */
      pt: [{
        pt: [A]
      }],
      /**
       * Padding Right
       * @see https://tailwindcss.com/docs/padding
       */
      pr: [{
        pr: [A]
      }],
      /**
       * Padding Bottom
       * @see https://tailwindcss.com/docs/padding
       */
      pb: [{
        pb: [A]
      }],
      /**
       * Padding Left
       * @see https://tailwindcss.com/docs/padding
       */
      pl: [{
        pl: [A]
      }],
      /**
       * Margin
       * @see https://tailwindcss.com/docs/margin
       */
      m: [{
        m: [E]
      }],
      /**
       * Margin X
       * @see https://tailwindcss.com/docs/margin
       */
      mx: [{
        mx: [E]
      }],
      /**
       * Margin Y
       * @see https://tailwindcss.com/docs/margin
       */
      my: [{
        my: [E]
      }],
      /**
       * Margin Start
       * @see https://tailwindcss.com/docs/margin
       */
      ms: [{
        ms: [E]
      }],
      /**
       * Margin End
       * @see https://tailwindcss.com/docs/margin
       */
      me: [{
        me: [E]
      }],
      /**
       * Margin Top
       * @see https://tailwindcss.com/docs/margin
       */
      mt: [{
        mt: [E]
      }],
      /**
       * Margin Right
       * @see https://tailwindcss.com/docs/margin
       */
      mr: [{
        mr: [E]
      }],
      /**
       * Margin Bottom
       * @see https://tailwindcss.com/docs/margin
       */
      mb: [{
        mb: [E]
      }],
      /**
       * Margin Left
       * @see https://tailwindcss.com/docs/margin
       */
      ml: [{
        ml: [E]
      }],
      /**
       * Space Between X
       * @see https://tailwindcss.com/docs/space
       */
      "space-x": [{
        "space-x": [_]
      }],
      /**
       * Space Between X Reverse
       * @see https://tailwindcss.com/docs/space
       */
      "space-x-reverse": ["space-x-reverse"],
      /**
       * Space Between Y
       * @see https://tailwindcss.com/docs/space
       */
      "space-y": [{
        "space-y": [_]
      }],
      /**
       * Space Between Y Reverse
       * @see https://tailwindcss.com/docs/space
       */
      "space-y-reverse": ["space-y-reverse"],
      // Sizing
      /**
       * Width
       * @see https://tailwindcss.com/docs/width
       */
      w: [{
        w: ["auto", "min", "max", "fit", "svw", "lvw", "dvw", Gl, n]
      }],
      /**
       * Min-Width
       * @see https://tailwindcss.com/docs/min-width
       */
      "min-w": [{
        "min-w": [Gl, n, "min", "max", "fit"]
      }],
      /**
       * Max-Width
       * @see https://tailwindcss.com/docs/max-width
       */
      "max-w": [{
        "max-w": [Gl, n, "none", "full", "min", "max", "fit", "prose", {
          screen: [Ze]
        }, Ze]
      }],
      /**
       * Height
       * @see https://tailwindcss.com/docs/height
       */
      h: [{
        h: [Gl, n, "auto", "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Min-Height
       * @see https://tailwindcss.com/docs/min-height
       */
      "min-h": [{
        "min-h": [Gl, n, "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Max-Height
       * @see https://tailwindcss.com/docs/max-height
       */
      "max-h": [{
        "max-h": [Gl, n, "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Size
       * @see https://tailwindcss.com/docs/size
       */
      size: [{
        size: [Gl, n, "auto", "min", "max", "fit"]
      }],
      // Typography
      /**
       * Font Size
       * @see https://tailwindcss.com/docs/font-size
       */
      "font-size": [{
        text: ["base", Ze, He]
      }],
      /**
       * Font Smoothing
       * @see https://tailwindcss.com/docs/font-smoothing
       */
      "font-smoothing": ["antialiased", "subpixel-antialiased"],
      /**
       * Font Style
       * @see https://tailwindcss.com/docs/font-style
       */
      "font-style": ["italic", "not-italic"],
      /**
       * Font Weight
       * @see https://tailwindcss.com/docs/font-weight
       */
      "font-weight": [{
        font: ["thin", "extralight", "light", "normal", "medium", "semibold", "bold", "extrabold", "black", ao]
      }],
      /**
       * Font Family
       * @see https://tailwindcss.com/docs/font-family
       */
      "font-family": [{
        font: [Lr]
      }],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-normal": ["normal-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-ordinal": ["ordinal"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-slashed-zero": ["slashed-zero"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-figure": ["lining-nums", "oldstyle-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-spacing": ["proportional-nums", "tabular-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-fraction": ["diagonal-fractions", "stacked-fractons"],
      /**
       * Letter Spacing
       * @see https://tailwindcss.com/docs/letter-spacing
       */
      tracking: [{
        tracking: ["tighter", "tight", "normal", "wide", "wider", "widest", Gl]
      }],
      /**
       * Line Clamp
       * @see https://tailwindcss.com/docs/line-clamp
       */
      "line-clamp": [{
        "line-clamp": ["none", xt, ao]
      }],
      /**
       * Line Height
       * @see https://tailwindcss.com/docs/line-height
       */
      leading: [{
        leading: ["none", "tight", "snug", "normal", "relaxed", "loose", Ie, Gl]
      }],
      /**
       * List Style Image
       * @see https://tailwindcss.com/docs/list-style-image
       */
      "list-image": [{
        "list-image": ["none", Gl]
      }],
      /**
       * List Style Type
       * @see https://tailwindcss.com/docs/list-style-type
       */
      "list-style-type": [{
        list: ["none", "disc", "decimal", Gl]
      }],
      /**
       * List Style Position
       * @see https://tailwindcss.com/docs/list-style-position
       */
      "list-style-position": [{
        list: ["inside", "outside"]
      }],
      /**
       * Placeholder Color
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/placeholder-color
       */
      "placeholder-color": [{
        placeholder: [l]
      }],
      /**
       * Placeholder Opacity
       * @see https://tailwindcss.com/docs/placeholder-opacity
       */
      "placeholder-opacity": [{
        "placeholder-opacity": [S]
      }],
      /**
       * Text Alignment
       * @see https://tailwindcss.com/docs/text-align
       */
      "text-alignment": [{
        text: ["left", "center", "right", "justify", "start", "end"]
      }],
      /**
       * Text Color
       * @see https://tailwindcss.com/docs/text-color
       */
      "text-color": [{
        text: [l]
      }],
      /**
       * Text Opacity
       * @see https://tailwindcss.com/docs/text-opacity
       */
      "text-opacity": [{
        "text-opacity": [S]
      }],
      /**
       * Text Decoration
       * @see https://tailwindcss.com/docs/text-decoration
       */
      "text-decoration": ["underline", "overline", "line-through", "no-underline"],
      /**
       * Text Decoration Style
       * @see https://tailwindcss.com/docs/text-decoration-style
       */
      "text-decoration-style": [{
        decoration: [...tl(), "wavy"]
      }],
      /**
       * Text Decoration Thickness
       * @see https://tailwindcss.com/docs/text-decoration-thickness
       */
      "text-decoration-thickness": [{
        decoration: ["auto", "from-font", Ie, He]
      }],
      /**
       * Text Underline Offset
       * @see https://tailwindcss.com/docs/text-underline-offset
       */
      "underline-offset": [{
        "underline-offset": ["auto", Ie, Gl]
      }],
      /**
       * Text Decoration Color
       * @see https://tailwindcss.com/docs/text-decoration-color
       */
      "text-decoration-color": [{
        decoration: [l]
      }],
      /**
       * Text Transform
       * @see https://tailwindcss.com/docs/text-transform
       */
      "text-transform": ["uppercase", "lowercase", "capitalize", "normal-case"],
      /**
       * Text Overflow
       * @see https://tailwindcss.com/docs/text-overflow
       */
      "text-overflow": ["truncate", "text-ellipsis", "text-clip"],
      /**
       * Text Wrap
       * @see https://tailwindcss.com/docs/text-wrap
       */
      "text-wrap": [{
        text: ["wrap", "nowrap", "balance", "pretty"]
      }],
      /**
       * Text Indent
       * @see https://tailwindcss.com/docs/text-indent
       */
      indent: [{
        indent: U()
      }],
      /**
       * Vertical Alignment
       * @see https://tailwindcss.com/docs/vertical-align
       */
      "vertical-align": [{
        align: ["baseline", "top", "middle", "bottom", "text-top", "text-bottom", "sub", "super", Gl]
      }],
      /**
       * Whitespace
       * @see https://tailwindcss.com/docs/whitespace
       */
      whitespace: [{
        whitespace: ["normal", "nowrap", "pre", "pre-line", "pre-wrap", "break-spaces"]
      }],
      /**
       * Word Break
       * @see https://tailwindcss.com/docs/word-break
       */
      break: [{
        break: ["normal", "words", "all", "keep"]
      }],
      /**
       * Hyphens
       * @see https://tailwindcss.com/docs/hyphens
       */
      hyphens: [{
        hyphens: ["none", "manual", "auto"]
      }],
      /**
       * Content
       * @see https://tailwindcss.com/docs/content
       */
      content: [{
        content: ["none", Gl]
      }],
      // Backgrounds
      /**
       * Background Attachment
       * @see https://tailwindcss.com/docs/background-attachment
       */
      "bg-attachment": [{
        bg: ["fixed", "local", "scroll"]
      }],
      /**
       * Background Clip
       * @see https://tailwindcss.com/docs/background-clip
       */
      "bg-clip": [{
        "bg-clip": ["border", "padding", "content", "text"]
      }],
      /**
       * Background Opacity
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/background-opacity
       */
      "bg-opacity": [{
        "bg-opacity": [S]
      }],
      /**
       * Background Origin
       * @see https://tailwindcss.com/docs/background-origin
       */
      "bg-origin": [{
        "bg-origin": ["border", "padding", "content"]
      }],
      /**
       * Background Position
       * @see https://tailwindcss.com/docs/background-position
       */
      "bg-position": [{
        bg: [...rl(), ny]
      }],
      /**
       * Background Repeat
       * @see https://tailwindcss.com/docs/background-repeat
       */
      "bg-repeat": [{
        bg: ["no-repeat", {
          repeat: ["", "x", "y", "round", "space"]
        }]
      }],
      /**
       * Background Size
       * @see https://tailwindcss.com/docs/background-size
       */
      "bg-size": [{
        bg: ["auto", "cover", "contain", ly]
      }],
      /**
       * Background Image
       * @see https://tailwindcss.com/docs/background-image
       */
      "bg-image": [{
        bg: ["none", {
          "gradient-to": ["t", "tr", "r", "br", "b", "bl", "l", "tl"]
        }, ey]
      }],
      /**
       * Background Color
       * @see https://tailwindcss.com/docs/background-color
       */
      "bg-color": [{
        bg: [l]
      }],
      /**
       * Gradient Color Stops From Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-from-pos": [{
        from: [$]
      }],
      /**
       * Gradient Color Stops Via Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-via-pos": [{
        via: [$]
      }],
      /**
       * Gradient Color Stops To Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-to-pos": [{
        to: [$]
      }],
      /**
       * Gradient Color Stops From
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-from": [{
        from: [v]
      }],
      /**
       * Gradient Color Stops Via
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-via": [{
        via: [v]
      }],
      /**
       * Gradient Color Stops To
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-to": [{
        to: [v]
      }],
      // Borders
      /**
       * Border Radius
       * @see https://tailwindcss.com/docs/border-radius
       */
      rounded: [{
        rounded: [o]
      }],
      /**
       * Border Radius Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-s": [{
        "rounded-s": [o]
      }],
      /**
       * Border Radius End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-e": [{
        "rounded-e": [o]
      }],
      /**
       * Border Radius Top
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-t": [{
        "rounded-t": [o]
      }],
      /**
       * Border Radius Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-r": [{
        "rounded-r": [o]
      }],
      /**
       * Border Radius Bottom
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-b": [{
        "rounded-b": [o]
      }],
      /**
       * Border Radius Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-l": [{
        "rounded-l": [o]
      }],
      /**
       * Border Radius Start Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-ss": [{
        "rounded-ss": [o]
      }],
      /**
       * Border Radius Start End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-se": [{
        "rounded-se": [o]
      }],
      /**
       * Border Radius End End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-ee": [{
        "rounded-ee": [o]
      }],
      /**
       * Border Radius End Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-es": [{
        "rounded-es": [o]
      }],
      /**
       * Border Radius Top Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-tl": [{
        "rounded-tl": [o]
      }],
      /**
       * Border Radius Top Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-tr": [{
        "rounded-tr": [o]
      }],
      /**
       * Border Radius Bottom Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-br": [{
        "rounded-br": [o]
      }],
      /**
       * Border Radius Bottom Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-bl": [{
        "rounded-bl": [o]
      }],
      /**
       * Border Width
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w": [{
        border: [d]
      }],
      /**
       * Border Width X
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-x": [{
        "border-x": [d]
      }],
      /**
       * Border Width Y
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-y": [{
        "border-y": [d]
      }],
      /**
       * Border Width Start
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-s": [{
        "border-s": [d]
      }],
      /**
       * Border Width End
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-e": [{
        "border-e": [d]
      }],
      /**
       * Border Width Top
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-t": [{
        "border-t": [d]
      }],
      /**
       * Border Width Right
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-r": [{
        "border-r": [d]
      }],
      /**
       * Border Width Bottom
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-b": [{
        "border-b": [d]
      }],
      /**
       * Border Width Left
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-l": [{
        "border-l": [d]
      }],
      /**
       * Border Opacity
       * @see https://tailwindcss.com/docs/border-opacity
       */
      "border-opacity": [{
        "border-opacity": [S]
      }],
      /**
       * Border Style
       * @see https://tailwindcss.com/docs/border-style
       */
      "border-style": [{
        border: [...tl(), "hidden"]
      }],
      /**
       * Divide Width X
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-x": [{
        "divide-x": [d]
      }],
      /**
       * Divide Width X Reverse
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-x-reverse": ["divide-x-reverse"],
      /**
       * Divide Width Y
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-y": [{
        "divide-y": [d]
      }],
      /**
       * Divide Width Y Reverse
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-y-reverse": ["divide-y-reverse"],
      /**
       * Divide Opacity
       * @see https://tailwindcss.com/docs/divide-opacity
       */
      "divide-opacity": [{
        "divide-opacity": [S]
      }],
      /**
       * Divide Style
       * @see https://tailwindcss.com/docs/divide-style
       */
      "divide-style": [{
        divide: tl()
      }],
      /**
       * Border Color
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color": [{
        border: [r]
      }],
      /**
       * Border Color X
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-x": [{
        "border-x": [r]
      }],
      /**
       * Border Color Y
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-y": [{
        "border-y": [r]
      }],
      /**
       * Border Color Top
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-t": [{
        "border-t": [r]
      }],
      /**
       * Border Color Right
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-r": [{
        "border-r": [r]
      }],
      /**
       * Border Color Bottom
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-b": [{
        "border-b": [r]
      }],
      /**
       * Border Color Left
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-l": [{
        "border-l": [r]
      }],
      /**
       * Divide Color
       * @see https://tailwindcss.com/docs/divide-color
       */
      "divide-color": [{
        divide: [r]
      }],
      /**
       * Outline Style
       * @see https://tailwindcss.com/docs/outline-style
       */
      "outline-style": [{
        outline: ["", ...tl()]
      }],
      /**
       * Outline Offset
       * @see https://tailwindcss.com/docs/outline-offset
       */
      "outline-offset": [{
        "outline-offset": [Ie, Gl]
      }],
      /**
       * Outline Width
       * @see https://tailwindcss.com/docs/outline-width
       */
      "outline-w": [{
        outline: [Ie, He]
      }],
      /**
       * Outline Color
       * @see https://tailwindcss.com/docs/outline-color
       */
      "outline-color": [{
        outline: [l]
      }],
      /**
       * Ring Width
       * @see https://tailwindcss.com/docs/ring-width
       */
      "ring-w": [{
        ring: ul()
      }],
      /**
       * Ring Width Inset
       * @see https://tailwindcss.com/docs/ring-width
       */
      "ring-w-inset": ["ring-inset"],
      /**
       * Ring Color
       * @see https://tailwindcss.com/docs/ring-color
       */
      "ring-color": [{
        ring: [l]
      }],
      /**
       * Ring Opacity
       * @see https://tailwindcss.com/docs/ring-opacity
       */
      "ring-opacity": [{
        "ring-opacity": [S]
      }],
      /**
       * Ring Offset Width
       * @see https://tailwindcss.com/docs/ring-offset-width
       */
      "ring-offset-w": [{
        "ring-offset": [Ie, He]
      }],
      /**
       * Ring Offset Color
       * @see https://tailwindcss.com/docs/ring-offset-color
       */
      "ring-offset-color": [{
        "ring-offset": [l]
      }],
      // Effects
      /**
       * Box Shadow
       * @see https://tailwindcss.com/docs/box-shadow
       */
      shadow: [{
        shadow: ["", "inner", "none", Ze, ty]
      }],
      /**
       * Box Shadow Color
       * @see https://tailwindcss.com/docs/box-shadow-color
       */
      "shadow-color": [{
        shadow: [Lr]
      }],
      /**
       * Opacity
       * @see https://tailwindcss.com/docs/opacity
       */
      opacity: [{
        opacity: [S]
      }],
      /**
       * Mix Blend Mode
       * @see https://tailwindcss.com/docs/mix-blend-mode
       */
      "mix-blend": [{
        "mix-blend": sl()
      }],
      /**
       * Background Blend Mode
       * @see https://tailwindcss.com/docs/background-blend-mode
       */
      "bg-blend": [{
        "bg-blend": sl()
      }],
      // Filters
      /**
       * Filter
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/filter
       */
      filter: [{
        filter: ["", "none"]
      }],
      /**
       * Blur
       * @see https://tailwindcss.com/docs/blur
       */
      blur: [{
        blur: [u]
      }],
      /**
       * Brightness
       * @see https://tailwindcss.com/docs/brightness
       */
      brightness: [{
        brightness: [t]
      }],
      /**
       * Contrast
       * @see https://tailwindcss.com/docs/contrast
       */
      contrast: [{
        contrast: [a]
      }],
      /**
       * Drop Shadow
       * @see https://tailwindcss.com/docs/drop-shadow
       */
      "drop-shadow": [{
        "drop-shadow": ["", "none", Ze, Gl]
      }],
      /**
       * Grayscale
       * @see https://tailwindcss.com/docs/grayscale
       */
      grayscale: [{
        grayscale: [c]
      }],
      /**
       * Hue Rotate
       * @see https://tailwindcss.com/docs/hue-rotate
       */
      "hue-rotate": [{
        "hue-rotate": [p]
      }],
      /**
       * Invert
       * @see https://tailwindcss.com/docs/invert
       */
      invert: [{
        invert: [g]
      }],
      /**
       * Saturate
       * @see https://tailwindcss.com/docs/saturate
       */
      saturate: [{
        saturate: [x]
      }],
      /**
       * Sepia
       * @see https://tailwindcss.com/docs/sepia
       */
      sepia: [{
        sepia: [P]
      }],
      /**
       * Backdrop Filter
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/backdrop-filter
       */
      "backdrop-filter": [{
        "backdrop-filter": ["", "none"]
      }],
      /**
       * Backdrop Blur
       * @see https://tailwindcss.com/docs/backdrop-blur
       */
      "backdrop-blur": [{
        "backdrop-blur": [u]
      }],
      /**
       * Backdrop Brightness
       * @see https://tailwindcss.com/docs/backdrop-brightness
       */
      "backdrop-brightness": [{
        "backdrop-brightness": [t]
      }],
      /**
       * Backdrop Contrast
       * @see https://tailwindcss.com/docs/backdrop-contrast
       */
      "backdrop-contrast": [{
        "backdrop-contrast": [a]
      }],
      /**
       * Backdrop Grayscale
       * @see https://tailwindcss.com/docs/backdrop-grayscale
       */
      "backdrop-grayscale": [{
        "backdrop-grayscale": [c]
      }],
      /**
       * Backdrop Hue Rotate
       * @see https://tailwindcss.com/docs/backdrop-hue-rotate
       */
      "backdrop-hue-rotate": [{
        "backdrop-hue-rotate": [p]
      }],
      /**
       * Backdrop Invert
       * @see https://tailwindcss.com/docs/backdrop-invert
       */
      "backdrop-invert": [{
        "backdrop-invert": [g]
      }],
      /**
       * Backdrop Opacity
       * @see https://tailwindcss.com/docs/backdrop-opacity
       */
      "backdrop-opacity": [{
        "backdrop-opacity": [S]
      }],
      /**
       * Backdrop Saturate
       * @see https://tailwindcss.com/docs/backdrop-saturate
       */
      "backdrop-saturate": [{
        "backdrop-saturate": [x]
      }],
      /**
       * Backdrop Sepia
       * @see https://tailwindcss.com/docs/backdrop-sepia
       */
      "backdrop-sepia": [{
        "backdrop-sepia": [P]
      }],
      // Tables
      /**
       * Border Collapse
       * @see https://tailwindcss.com/docs/border-collapse
       */
      "border-collapse": [{
        border: ["collapse", "separate"]
      }],
      /**
       * Border Spacing
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing": [{
        "border-spacing": [s]
      }],
      /**
       * Border Spacing X
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing-x": [{
        "border-spacing-x": [s]
      }],
      /**
       * Border Spacing Y
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing-y": [{
        "border-spacing-y": [s]
      }],
      /**
       * Table Layout
       * @see https://tailwindcss.com/docs/table-layout
       */
      "table-layout": [{
        table: ["auto", "fixed"]
      }],
      /**
       * Caption Side
       * @see https://tailwindcss.com/docs/caption-side
       */
      caption: [{
        caption: ["top", "bottom"]
      }],
      // Transitions and Animation
      /**
       * Tranisition Property
       * @see https://tailwindcss.com/docs/transition-property
       */
      transition: [{
        transition: ["none", "all", "", "colors", "opacity", "shadow", "transform", Gl]
      }],
      /**
       * Transition Duration
       * @see https://tailwindcss.com/docs/transition-duration
       */
      duration: [{
        duration: dl()
      }],
      /**
       * Transition Timing Function
       * @see https://tailwindcss.com/docs/transition-timing-function
       */
      ease: [{
        ease: ["linear", "in", "out", "in-out", Gl]
      }],
      /**
       * Transition Delay
       * @see https://tailwindcss.com/docs/transition-delay
       */
      delay: [{
        delay: dl()
      }],
      /**
       * Animation
       * @see https://tailwindcss.com/docs/animation
       */
      animate: [{
        animate: ["none", "spin", "ping", "pulse", "bounce", Gl]
      }],
      // Transforms
      /**
       * Transform
       * @see https://tailwindcss.com/docs/transform
       */
      transform: [{
        transform: ["", "gpu", "none"]
      }],
      /**
       * Scale
       * @see https://tailwindcss.com/docs/scale
       */
      scale: [{
        scale: [I]
      }],
      /**
       * Scale X
       * @see https://tailwindcss.com/docs/scale
       */
      "scale-x": [{
        "scale-x": [I]
      }],
      /**
       * Scale Y
       * @see https://tailwindcss.com/docs/scale
       */
      "scale-y": [{
        "scale-y": [I]
      }],
      /**
       * Rotate
       * @see https://tailwindcss.com/docs/rotate
       */
      rotate: [{
        rotate: [Br, Gl]
      }],
      /**
       * Translate X
       * @see https://tailwindcss.com/docs/translate
       */
      "translate-x": [{
        "translate-x": [j]
      }],
      /**
       * Translate Y
       * @see https://tailwindcss.com/docs/translate
       */
      "translate-y": [{
        "translate-y": [j]
      }],
      /**
       * Skew X
       * @see https://tailwindcss.com/docs/skew
       */
      "skew-x": [{
        "skew-x": [O]
      }],
      /**
       * Skew Y
       * @see https://tailwindcss.com/docs/skew
       */
      "skew-y": [{
        "skew-y": [O]
      }],
      /**
       * Transform Origin
       * @see https://tailwindcss.com/docs/transform-origin
       */
      "transform-origin": [{
        origin: ["center", "top", "top-right", "right", "bottom-right", "bottom", "bottom-left", "left", "top-left", Gl]
      }],
      // Interactivity
      /**
       * Accent Color
       * @see https://tailwindcss.com/docs/accent-color
       */
      accent: [{
        accent: ["auto", l]
      }],
      /**
       * Appearance
       * @see https://tailwindcss.com/docs/appearance
       */
      appearance: [{
        appearance: ["none", "auto"]
      }],
      /**
       * Cursor
       * @see https://tailwindcss.com/docs/cursor
       */
      cursor: [{
        cursor: ["auto", "default", "pointer", "wait", "text", "move", "help", "not-allowed", "none", "context-menu", "progress", "cell", "crosshair", "vertical-text", "alias", "copy", "no-drop", "grab", "grabbing", "all-scroll", "col-resize", "row-resize", "n-resize", "e-resize", "s-resize", "w-resize", "ne-resize", "nw-resize", "se-resize", "sw-resize", "ew-resize", "ns-resize", "nesw-resize", "nwse-resize", "zoom-in", "zoom-out", Gl]
      }],
      /**
       * Caret Color
       * @see https://tailwindcss.com/docs/just-in-time-mode#caret-color-utilities
       */
      "caret-color": [{
        caret: [l]
      }],
      /**
       * Pointer Events
       * @see https://tailwindcss.com/docs/pointer-events
       */
      "pointer-events": [{
        "pointer-events": ["none", "auto"]
      }],
      /**
       * Resize
       * @see https://tailwindcss.com/docs/resize
       */
      resize: [{
        resize: ["none", "y", "x", ""]
      }],
      /**
       * Scroll Behavior
       * @see https://tailwindcss.com/docs/scroll-behavior
       */
      "scroll-behavior": [{
        scroll: ["auto", "smooth"]
      }],
      /**
       * Scroll Margin
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-m": [{
        "scroll-m": U()
      }],
      /**
       * Scroll Margin X
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mx": [{
        "scroll-mx": U()
      }],
      /**
       * Scroll Margin Y
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-my": [{
        "scroll-my": U()
      }],
      /**
       * Scroll Margin Start
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-ms": [{
        "scroll-ms": U()
      }],
      /**
       * Scroll Margin End
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-me": [{
        "scroll-me": U()
      }],
      /**
       * Scroll Margin Top
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mt": [{
        "scroll-mt": U()
      }],
      /**
       * Scroll Margin Right
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mr": [{
        "scroll-mr": U()
      }],
      /**
       * Scroll Margin Bottom
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mb": [{
        "scroll-mb": U()
      }],
      /**
       * Scroll Margin Left
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-ml": [{
        "scroll-ml": U()
      }],
      /**
       * Scroll Padding
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-p": [{
        "scroll-p": U()
      }],
      /**
       * Scroll Padding X
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-px": [{
        "scroll-px": U()
      }],
      /**
       * Scroll Padding Y
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-py": [{
        "scroll-py": U()
      }],
      /**
       * Scroll Padding Start
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-ps": [{
        "scroll-ps": U()
      }],
      /**
       * Scroll Padding End
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pe": [{
        "scroll-pe": U()
      }],
      /**
       * Scroll Padding Top
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pt": [{
        "scroll-pt": U()
      }],
      /**
       * Scroll Padding Right
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pr": [{
        "scroll-pr": U()
      }],
      /**
       * Scroll Padding Bottom
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pb": [{
        "scroll-pb": U()
      }],
      /**
       * Scroll Padding Left
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pl": [{
        "scroll-pl": U()
      }],
      /**
       * Scroll Snap Align
       * @see https://tailwindcss.com/docs/scroll-snap-align
       */
      "snap-align": [{
        snap: ["start", "end", "center", "align-none"]
      }],
      /**
       * Scroll Snap Stop
       * @see https://tailwindcss.com/docs/scroll-snap-stop
       */
      "snap-stop": [{
        snap: ["normal", "always"]
      }],
      /**
       * Scroll Snap Type
       * @see https://tailwindcss.com/docs/scroll-snap-type
       */
      "snap-type": [{
        snap: ["none", "x", "y", "both"]
      }],
      /**
       * Scroll Snap Type Strictness
       * @see https://tailwindcss.com/docs/scroll-snap-type
       */
      "snap-strictness": [{
        snap: ["mandatory", "proximity"]
      }],
      /**
       * Touch Action
       * @see https://tailwindcss.com/docs/touch-action
       */
      touch: [{
        touch: ["auto", "none", "manipulation"]
      }],
      /**
       * Touch Action X
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-x": [{
        "touch-pan": ["x", "left", "right"]
      }],
      /**
       * Touch Action Y
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-y": [{
        "touch-pan": ["y", "up", "down"]
      }],
      /**
       * Touch Action Pinch Zoom
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-pz": ["touch-pinch-zoom"],
      /**
       * User Select
       * @see https://tailwindcss.com/docs/user-select
       */
      select: [{
        select: ["none", "text", "all", "auto"]
      }],
      /**
       * Will Change
       * @see https://tailwindcss.com/docs/will-change
       */
      "will-change": [{
        "will-change": ["auto", "scroll", "contents", "transform", Gl]
      }],
      // SVG
      /**
       * Fill
       * @see https://tailwindcss.com/docs/fill
       */
      fill: [{
        fill: [l, "none"]
      }],
      /**
       * Stroke Width
       * @see https://tailwindcss.com/docs/stroke-width
       */
      "stroke-w": [{
        stroke: [Ie, He, ao]
      }],
      /**
       * Stroke
       * @see https://tailwindcss.com/docs/stroke
       */
      stroke: [{
        stroke: [l, "none"]
      }],
      // Accessibility
      /**
       * Screen Readers
       * @see https://tailwindcss.com/docs/screen-readers
       */
      sr: ["sr-only", "not-sr-only"],
      /**
       * Forced Color Adjust
       * @see https://tailwindcss.com/docs/forced-color-adjust
       */
      "forced-color-adjust": [{
        "forced-color-adjust": ["auto", "none"]
      }]
    },
    conflictingClassGroups: {
      overflow: ["overflow-x", "overflow-y"],
      overscroll: ["overscroll-x", "overscroll-y"],
      inset: ["inset-x", "inset-y", "start", "end", "top", "right", "bottom", "left"],
      "inset-x": ["right", "left"],
      "inset-y": ["top", "bottom"],
      flex: ["basis", "grow", "shrink"],
      gap: ["gap-x", "gap-y"],
      p: ["px", "py", "ps", "pe", "pt", "pr", "pb", "pl"],
      px: ["pr", "pl"],
      py: ["pt", "pb"],
      m: ["mx", "my", "ms", "me", "mt", "mr", "mb", "ml"],
      mx: ["mr", "ml"],
      my: ["mt", "mb"],
      size: ["w", "h"],
      "font-size": ["leading"],
      "fvn-normal": ["fvn-ordinal", "fvn-slashed-zero", "fvn-figure", "fvn-spacing", "fvn-fraction"],
      "fvn-ordinal": ["fvn-normal"],
      "fvn-slashed-zero": ["fvn-normal"],
      "fvn-figure": ["fvn-normal"],
      "fvn-spacing": ["fvn-normal"],
      "fvn-fraction": ["fvn-normal"],
      "line-clamp": ["display", "overflow"],
      rounded: ["rounded-s", "rounded-e", "rounded-t", "rounded-r", "rounded-b", "rounded-l", "rounded-ss", "rounded-se", "rounded-ee", "rounded-es", "rounded-tl", "rounded-tr", "rounded-br", "rounded-bl"],
      "rounded-s": ["rounded-ss", "rounded-es"],
      "rounded-e": ["rounded-se", "rounded-ee"],
      "rounded-t": ["rounded-tl", "rounded-tr"],
      "rounded-r": ["rounded-tr", "rounded-br"],
      "rounded-b": ["rounded-br", "rounded-bl"],
      "rounded-l": ["rounded-tl", "rounded-bl"],
      "border-spacing": ["border-spacing-x", "border-spacing-y"],
      "border-w": ["border-w-s", "border-w-e", "border-w-t", "border-w-r", "border-w-b", "border-w-l"],
      "border-w-x": ["border-w-r", "border-w-l"],
      "border-w-y": ["border-w-t", "border-w-b"],
      "border-color": ["border-color-t", "border-color-r", "border-color-b", "border-color-l"],
      "border-color-x": ["border-color-r", "border-color-l"],
      "border-color-y": ["border-color-t", "border-color-b"],
      "scroll-m": ["scroll-mx", "scroll-my", "scroll-ms", "scroll-me", "scroll-mt", "scroll-mr", "scroll-mb", "scroll-ml"],
      "scroll-mx": ["scroll-mr", "scroll-ml"],
      "scroll-my": ["scroll-mt", "scroll-mb"],
      "scroll-p": ["scroll-px", "scroll-py", "scroll-ps", "scroll-pe", "scroll-pt", "scroll-pr", "scroll-pb", "scroll-pl"],
      "scroll-px": ["scroll-pr", "scroll-pl"],
      "scroll-py": ["scroll-pt", "scroll-pb"],
      touch: ["touch-x", "touch-y", "touch-pz"],
      "touch-x": ["touch"],
      "touch-y": ["touch"],
      "touch-pz": ["touch"]
    },
    conflictingClassGroupModifiers: {
      "font-size": ["leading"]
    }
  };
}
const Kn = /* @__PURE__ */ Hb(ay);
var k3 = {}, H3 = {}, pc = { exports: {} }, vn = String, Z3 = function() {
  return { isColorSupported: !1, reset: vn, bold: vn, dim: vn, italic: vn, underline: vn, inverse: vn, hidden: vn, strikethrough: vn, black: vn, red: vn, green: vn, yellow: vn, blue: vn, magenta: vn, cyan: vn, white: vn, gray: vn, bgBlack: vn, bgRed: vn, bgGreen: vn, bgYellow: vn, bgBlue: vn, bgMagenta: vn, bgCyan: vn, bgWhite: vn };
};
pc.exports = Z3();
pc.exports.createColors = Z3;
var sy = pc.exports;
(function(l) {
  Object.defineProperty(l, "__esModule", {
    value: !0
  });
  function n(a, c) {
    for (var p in c) Object.defineProperty(a, p, {
      enumerable: !0,
      get: c[p]
    });
  }
  n(l, {
    dim: function() {
      return s;
    },
    default: function() {
      return d;
    }
  });
  const u = /* @__PURE__ */ t(sy);
  function t(a) {
    return a && a.__esModule ? a : {
      default: a
    };
  }
  let r = /* @__PURE__ */ new Set();
  function o(a, c, p) {
    typeof process < "u" && process.env.JEST_WORKER_ID || p && r.has(p) || (p && r.add(p), console.warn(""), c.forEach((g) => console.warn(a, "-", g)));
  }
  function s(a) {
    return u.default.dim(a);
  }
  const d = {
    info(a, c) {
      o(u.default.bold(u.default.cyan("info")), ...Array.isArray(a) ? [
        a
      ] : [
        c,
        a
      ]);
    },
    warn(a, c) {
      o(u.default.bold(u.default.yellow("warn")), ...Array.isArray(a) ? [
        a
      ] : [
        c,
        a
      ]);
    },
    risk(a, c) {
      o(u.default.bold(u.default.magenta("risk")), ...Array.isArray(a) ? [
        a
      ] : [
        c,
        a
      ]);
    }
  };
})(H3);
(function(l) {
  Object.defineProperty(l, "__esModule", {
    value: !0
  }), Object.defineProperty(l, "default", {
    enumerable: !0,
    get: function() {
      return r;
    }
  });
  const n = /* @__PURE__ */ u(H3);
  function u(o) {
    return o && o.__esModule ? o : {
      default: o
    };
  }
  function t({ version: o, from: s, to: d }) {
    n.default.warn(`${s}-color-renamed`, [
      `As of Tailwind CSS ${o}, \`${s}\` has been renamed to \`${d}\`.`,
      "Update your configuration file to silence this warning."
    ]);
  }
  const r = {
    inherit: "inherit",
    current: "currentColor",
    transparent: "transparent",
    black: "#000",
    white: "#fff",
    slate: {
      50: "#f8fafc",
      100: "#f1f5f9",
      200: "#e2e8f0",
      300: "#cbd5e1",
      400: "#94a3b8",
      500: "#64748b",
      600: "#475569",
      700: "#334155",
      800: "#1e293b",
      900: "#0f172a",
      950: "#020617"
    },
    gray: {
      50: "#f9fafb",
      100: "#f3f4f6",
      200: "#e5e7eb",
      300: "#d1d5db",
      400: "#9ca3af",
      500: "#6b7280",
      600: "#4b5563",
      700: "#374151",
      800: "#1f2937",
      900: "#111827",
      950: "#030712"
    },
    zinc: {
      50: "#fafafa",
      100: "#f4f4f5",
      200: "#e4e4e7",
      300: "#d4d4d8",
      400: "#a1a1aa",
      500: "#71717a",
      600: "#52525b",
      700: "#3f3f46",
      800: "#27272a",
      900: "#18181b",
      950: "#09090b"
    },
    neutral: {
      50: "#fafafa",
      100: "#f5f5f5",
      200: "#e5e5e5",
      300: "#d4d4d4",
      400: "#a3a3a3",
      500: "#737373",
      600: "#525252",
      700: "#404040",
      800: "#262626",
      900: "#171717",
      950: "#0a0a0a"
    },
    stone: {
      50: "#fafaf9",
      100: "#f5f5f4",
      200: "#e7e5e4",
      300: "#d6d3d1",
      400: "#a8a29e",
      500: "#78716c",
      600: "#57534e",
      700: "#44403c",
      800: "#292524",
      900: "#1c1917",
      950: "#0c0a09"
    },
    red: {
      50: "#fef2f2",
      100: "#fee2e2",
      200: "#fecaca",
      300: "#fca5a5",
      400: "#f87171",
      500: "#ef4444",
      600: "#dc2626",
      700: "#b91c1c",
      800: "#991b1b",
      900: "#7f1d1d",
      950: "#450a0a"
    },
    orange: {
      50: "#fff7ed",
      100: "#ffedd5",
      200: "#fed7aa",
      300: "#fdba74",
      400: "#fb923c",
      500: "#f97316",
      600: "#ea580c",
      700: "#c2410c",
      800: "#9a3412",
      900: "#7c2d12",
      950: "#431407"
    },
    amber: {
      50: "#fffbeb",
      100: "#fef3c7",
      200: "#fde68a",
      300: "#fcd34d",
      400: "#fbbf24",
      500: "#f59e0b",
      600: "#d97706",
      700: "#b45309",
      800: "#92400e",
      900: "#78350f",
      950: "#451a03"
    },
    yellow: {
      50: "#fefce8",
      100: "#fef9c3",
      200: "#fef08a",
      300: "#fde047",
      400: "#facc15",
      500: "#eab308",
      600: "#ca8a04",
      700: "#a16207",
      800: "#854d0e",
      900: "#713f12",
      950: "#422006"
    },
    lime: {
      50: "#f7fee7",
      100: "#ecfccb",
      200: "#d9f99d",
      300: "#bef264",
      400: "#a3e635",
      500: "#84cc16",
      600: "#65a30d",
      700: "#4d7c0f",
      800: "#3f6212",
      900: "#365314",
      950: "#1a2e05"
    },
    green: {
      50: "#f0fdf4",
      100: "#dcfce7",
      200: "#bbf7d0",
      300: "#86efac",
      400: "#4ade80",
      500: "#22c55e",
      600: "#16a34a",
      700: "#15803d",
      800: "#166534",
      900: "#14532d",
      950: "#052e16"
    },
    emerald: {
      50: "#ecfdf5",
      100: "#d1fae5",
      200: "#a7f3d0",
      300: "#6ee7b7",
      400: "#34d399",
      500: "#10b981",
      600: "#059669",
      700: "#047857",
      800: "#065f46",
      900: "#064e3b",
      950: "#022c22"
    },
    teal: {
      50: "#f0fdfa",
      100: "#ccfbf1",
      200: "#99f6e4",
      300: "#5eead4",
      400: "#2dd4bf",
      500: "#14b8a6",
      600: "#0d9488",
      700: "#0f766e",
      800: "#115e59",
      900: "#134e4a",
      950: "#042f2e"
    },
    cyan: {
      50: "#ecfeff",
      100: "#cffafe",
      200: "#a5f3fc",
      300: "#67e8f9",
      400: "#22d3ee",
      500: "#06b6d4",
      600: "#0891b2",
      700: "#0e7490",
      800: "#155e75",
      900: "#164e63",
      950: "#083344"
    },
    sky: {
      50: "#f0f9ff",
      100: "#e0f2fe",
      200: "#bae6fd",
      300: "#7dd3fc",
      400: "#38bdf8",
      500: "#0ea5e9",
      600: "#0284c7",
      700: "#0369a1",
      800: "#075985",
      900: "#0c4a6e",
      950: "#082f49"
    },
    blue: {
      50: "#eff6ff",
      100: "#dbeafe",
      200: "#bfdbfe",
      300: "#93c5fd",
      400: "#60a5fa",
      500: "#3b82f6",
      600: "#2563eb",
      700: "#1d4ed8",
      800: "#1e40af",
      900: "#1e3a8a",
      950: "#172554"
    },
    indigo: {
      50: "#eef2ff",
      100: "#e0e7ff",
      200: "#c7d2fe",
      300: "#a5b4fc",
      400: "#818cf8",
      500: "#6366f1",
      600: "#4f46e5",
      700: "#4338ca",
      800: "#3730a3",
      900: "#312e81",
      950: "#1e1b4b"
    },
    violet: {
      50: "#f5f3ff",
      100: "#ede9fe",
      200: "#ddd6fe",
      300: "#c4b5fd",
      400: "#a78bfa",
      500: "#8b5cf6",
      600: "#7c3aed",
      700: "#6d28d9",
      800: "#5b21b6",
      900: "#4c1d95",
      950: "#2e1065"
    },
    purple: {
      50: "#faf5ff",
      100: "#f3e8ff",
      200: "#e9d5ff",
      300: "#d8b4fe",
      400: "#c084fc",
      500: "#a855f7",
      600: "#9333ea",
      700: "#7e22ce",
      800: "#6b21a8",
      900: "#581c87",
      950: "#3b0764"
    },
    fuchsia: {
      50: "#fdf4ff",
      100: "#fae8ff",
      200: "#f5d0fe",
      300: "#f0abfc",
      400: "#e879f9",
      500: "#d946ef",
      600: "#c026d3",
      700: "#a21caf",
      800: "#86198f",
      900: "#701a75",
      950: "#4a044e"
    },
    pink: {
      50: "#fdf2f8",
      100: "#fce7f3",
      200: "#fbcfe8",
      300: "#f9a8d4",
      400: "#f472b6",
      500: "#ec4899",
      600: "#db2777",
      700: "#be185d",
      800: "#9d174d",
      900: "#831843",
      950: "#500724"
    },
    rose: {
      50: "#fff1f2",
      100: "#ffe4e6",
      200: "#fecdd3",
      300: "#fda4af",
      400: "#fb7185",
      500: "#f43f5e",
      600: "#e11d48",
      700: "#be123c",
      800: "#9f1239",
      900: "#881337",
      950: "#4c0519"
    },
    get lightBlue() {
      return t({
        version: "v2.2",
        from: "lightBlue",
        to: "sky"
      }), this.sky;
    },
    get warmGray() {
      return t({
        version: "v3.0",
        from: "warmGray",
        to: "stone"
      }), this.stone;
    },
    get trueGray() {
      return t({
        version: "v3.0",
        from: "trueGray",
        to: "neutral"
      }), this.neutral;
    },
    get coolGray() {
      return t({
        version: "v3.0",
        from: "coolGray",
        to: "gray"
      }), this.gray;
    },
    get blueGray() {
      return t({
        version: "v3.0",
        from: "blueGray",
        to: "slate"
      }), this.slate;
    }
  };
})(k3);
let qs = k3;
var dy = (qs.__esModule ? qs : { default: qs }).default;
const Gu = /* @__PURE__ */ oa(dy);
function wl(...l) {
  return Kn(Rb(l));
}
B3.debounce(async (l, n) => {
  try {
    const t = await (await fetch(`https://jsonplaceholder.typicode.com/todos?search=${l}&_limit=10`)).json();
    n(t.map((r) => ({ label: r.title, value: r.title })));
  } catch (u) {
    console.error("Error fetching data:", u);
  }
}, 300);
Gu.amber, Gu.cyan, Gu.emerald, Gu.fuchsia, Gu.indigo, Gu.lime, Gu.orange, Gu.purple, Gu.rose, Gu.sky, Gu.teal, Gu.violet;
const cy = {
  amber: "bg-amber-200 text-amber-900",
  blue: "bg-blue-200 text-blue-900",
  cyan: "bg-cyan-200 text-cyan-900",
  emerald: "bg-emerald-200 text-emerald-900",
  fuchsia: "bg-fuchsia-200 text-fuchsia-900",
  green: "bg-green-200 text-green-900",
  gray: "bg-gray-200 text-gray-900",
  indigo: "bg-indigo-200 text-indigo-900",
  lime: "bg-lime-200 text-lime-900",
  orange: "bg-orange-200 text-orange-900",
  pink: "bg-pink-200 text-pink-900",
  purple: "bg-purple-200 text-purple-900",
  red: "bg-red-200 text-red-900",
  rose: "bg-rose-200 text-rose-900",
  sky: "bg-sky-200 text-sky-900",
  teal: "bg-teal-200 text-teal-900",
  violet: "bg-violet-200 text-violet-900",
  yellow: "bg-yellow-200 text-yellow-900",
  primary: "bg-primary-200 text-primary-900",
  secondary: "bg-secondary-200 text-secondary-900",
  danger: "bg-danger-200 text-danger-900"
}, p_ = ({ color: l, label: n, className: u }) => /* @__PURE__ */ y.jsx("span", { className: wl("text-xs px-2 py-1 rounded-full whitespace-nowrap", cy[l], u), children: n }), g_ = (l) => /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsx(
  "div",
  {
    className: wl(
      "bg-white overflow-hidden border border-gray-300 rounded p-4",
      l.shadow && "shadow",
      l.className
    ),
    children: l.children
  }
) });
var X3 = {
  color: void 0,
  size: void 0,
  className: void 0,
  style: void 0,
  attr: void 0
}, Yf = react__WEBPACK_IMPORTED_MODULE_0__.createContext && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createContext(X3), fy = ["attr", "size", "title"];
function py(l, n) {
  if (l == null) return {};
  var u = gy(l, n), t, r;
  if (Object.getOwnPropertySymbols) {
    var o = Object.getOwnPropertySymbols(l);
    for (r = 0; r < o.length; r++)
      t = o[r], !(n.indexOf(t) >= 0) && Object.prototype.propertyIsEnumerable.call(l, t) && (u[t] = l[t]);
  }
  return u;
}
function gy(l, n) {
  if (l == null) return {};
  var u = {}, t = Object.keys(l), r, o;
  for (o = 0; o < t.length; o++)
    r = t[o], !(n.indexOf(r) >= 0) && (u[r] = l[r]);
  return u;
}
function Lo() {
  return Lo = Object.assign ? Object.assign.bind() : function(l) {
    for (var n = 1; n < arguments.length; n++) {
      var u = arguments[n];
      for (var t in u)
        Object.prototype.hasOwnProperty.call(u, t) && (l[t] = u[t]);
    }
    return l;
  }, Lo.apply(this, arguments);
}
function Uf(l, n) {
  var u = Object.keys(l);
  if (Object.getOwnPropertySymbols) {
    var t = Object.getOwnPropertySymbols(l);
    n && (t = t.filter(function(r) {
      return Object.getOwnPropertyDescriptor(l, r).enumerable;
    })), u.push.apply(u, t);
  }
  return u;
}
function Go(l) {
  for (var n = 1; n < arguments.length; n++) {
    var u = arguments[n] != null ? arguments[n] : {};
    n % 2 ? Uf(Object(u), !0).forEach(function(t) {
      hy(l, t, u[t]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(l, Object.getOwnPropertyDescriptors(u)) : Uf(Object(u)).forEach(function(t) {
      Object.defineProperty(l, t, Object.getOwnPropertyDescriptor(u, t));
    });
  }
  return l;
}
function hy(l, n, u) {
  return n = my(n), n in l ? Object.defineProperty(l, n, { value: u, enumerable: !0, configurable: !0, writable: !0 }) : l[n] = u, l;
}
function my(l) {
  var n = vy(l, "string");
  return typeof n == "symbol" ? n : String(n);
}
function vy(l, n) {
  if (typeof l != "object" || l === null) return l;
  var u = l[Symbol.toPrimitive];
  if (u !== void 0) {
    var t = u.call(l, n || "default");
    if (typeof t != "object") return t;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (n === "string" ? String : Number)(l);
}
function z3(l) {
  return l && l.map((n, u) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(n.tag, Go({
    key: u
  }, n.attr), z3(n.child)));
}
function Vu(l) {
  return (n) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(by, Lo({
    attr: Go({}, l.attr)
  }, n), z3(l.child));
}
function by(l) {
  var n = (u) => {
    var {
      attr: t,
      size: r,
      title: o
    } = l, s = py(l, fy), d = r || u.size || "1em", a;
    return u.className && (a = u.className), l.className && (a = (a ? a + " " : "") + l.className), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", Lo({
      stroke: "currentColor",
      fill: "currentColor",
      strokeWidth: "0"
    }, u.attr, t, s, {
      className: a,
      style: Go(Go({
        color: l.color || u.color
      }, u.style), l.style),
      height: d,
      width: d,
      xmlns: "http://www.w3.org/2000/svg"
    }), o && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("title", null, o), l.children);
  };
  return Yf !== void 0 ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Yf.Consumer, null, (u) => n(u)) : n(X3);
}
function Y3(l) {
  return Vu({ tag: "svg", attr: { viewBox: "0 0 24 24", fill: "none" }, child: [{ tag: "path", attr: { opacity: "0.2", fillRule: "evenodd", clipRule: "evenodd", d: "M12 19C15.866 19 19 15.866 19 12C19 8.13401 15.866 5 12 5C8.13401 5 5 8.13401 5 12C5 15.866 8.13401 19 12 19ZM12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z", fill: "currentColor" }, child: [] }, { tag: "path", attr: { d: "M2 12C2 6.47715 6.47715 2 12 2V5C8.13401 5 5 8.13401 5 12H2Z", fill: "currentColor" }, child: [] }] })(l);
}
const xd = (l) => {
  const n = l.icon, u = {
    amber: "text-amber-600",
    blue: "text-blue-600",
    cyan: "text-cyan-600",
    emerald: "text-emerald-600",
    fuchsia: "text-fuchsia-600",
    green: "text-green-600",
    gray: "text-gray-600",
    indigo: "text-indigo-600",
    lime: "text-lime-600",
    orange: "text-orange-600",
    pink: "text-pink-600",
    purple: "text-purple-600",
    red: "text-red-600",
    rose: "text-rose-600",
    sky: "text-sky-600",
    teal: "text-teal-600",
    violet: "text-violet-600",
    yellow: "text-yellow-600",
    primary: "text-primary-600",
    secondary: "text-secondary-600",
    danger: "text-danger-600",
    white: "text-white-600"
  }, t = {
    amber: `${l.outlined ? "border border-amber-600 text-amber-600 hover:bg-amber-100" : "text-white bg-amber-600 hover:bg-amber-700"} focus:ring-amber-600`,
    blue: `${l.outlined ? "border border-blue-600 text-blue-600 hover:bg-blue-100" : "text-white bg-blue-600  hover:bg-blue-700"} focus:ring-blue-600`,
    cyan: `${l.outlined ? "border border-cyan-600 text-cyan-600 hover:bg-cyan-100" : "text-white bg-cyan-600 hover:bg-cyan-700"} focus:ring-cyan-600`,
    emerald: `${l.outlined ? "border border-emerald-600 text-emerald-600 hover:bg-emerald-100" : "text-white bg-emerald-600 hover:bg-emerald-700"} focus:ring-emerald-600`,
    fuchsia: `${l.outlined ? "border border-fuchsia-600 text-fuchsia-600 hover:bg-fuchsia-100" : "text-white bg-fuchsia-600 hover:bg-fuchsia-700"} focus:ring-fuchsia-600`,
    green: `${l.outlined ? "border border-green-600 text-green-600 hover:bg-green-100" : "text-white bg-green-600 hover:bg-green-700"} focus:ring-green-600`,
    gray: `${l.outlined ? "border border-gray-600 text-gray-600 hover:bg-gray-100" : "text-white bg-gray-600 hover:bg-gray-700"} focus:ring-gray-600`,
    indigo: `${l.outlined ? "border border-indigo-600 text-indigo-600 hover:bg-indigo-100" : "text-white bg-indigo-600 hover:bg-indigo-700"} focus:ring-indigo-600`,
    lime: `${l.outlined ? "border border-lime-600 text-lime-600 hover:bg-lime-100" : "text-white bg-lime-600 hover:bg-lime-700"} focus:ring-lime-600`,
    orange: `${l.outlined ? "border border-orange-600 text-orange-600 hover:bg-orange-100" : "text-white bg-orange-600 hover:bg-orange-700"} focus:ring-orange-600`,
    pink: `${l.outlined ? "border border-pink-600 text-pink-600 hover:bg-pink-100" : "text-white bg-pink-600 hover:bg-pink-700"} focus:ring-pink-600`,
    purple: `${l.outlined ? "border border-purple-600 text-purple-600 hover:bg-purple-100" : "text-white bg-purple-600 hover:bg-purple-700"} focus:ring-purple-600`,
    red: `${l.outlined ? "border border-red-600 text-red-600 hover:bg-red-100" : "text-white bg-red-600 hover:bg-red-700"} focus:ring-red-600`,
    rose: `${l.outlined ? "border border-rose-600 text-rose-600 hover:bg-rose-100" : "text-white bg-rose-600 hover:bg-rose-700"} focus:ring-rose-600`,
    sky: `${l.outlined ? "border border-sky-600 text-sky-600 hover:bg-sky-100" : "text-white bg-sky-600 hover:bg-sky-700"} focus:ring-sky-600`,
    teal: `${l.outlined ? "border border-teal-600 text-teal-600 hover:bg-teal-100" : "text-white bg-teal-600 hover:bg-teal-700"} focus:ring-teal-600`,
    violet: `${l.outlined ? "border border-violet-600 text-violet-600 hover:bg-violet-100" : "text-white bg-violet-600 hover:bg-violet-700"} focus:ring-violet-600`,
    yellow: `${l.outlined ? "border border-yellow-600 text-yellow-600 hover:bg-yellow-100" : "text-white bg-yellow-600 hover:bg-yellow-700"} focus:ring-yellow-600`,
    primary: `${l.outlined ? "border border-primary-600 text-primary-600 hover:bg-primary-100" : "text-white bg-primary-600 hover:bg-primary-700"} focus:ring-primary-600`,
    secondary: `${l.outlined ? "border border-secondary-600 text-secondary-600 hover:bg-secondary-100" : "text-gray-600 bg-secondary-600 hover:bg-secondary-700"} focus:ring-secondary-600`,
    danger: `${l.outlined ? "border border-danger-600 text-danger-600 hover:bg-danger-100" : "text-white bg-danger-600 hover:bg-danger-700"} focus:ring-danger-600`,
    white: "bg-transparent text-gray-600 hover:bg-gray-100"
  }, r = {
    lg: "px-6 py-2.5 text-sm",
    md: "px-5 py-2 text-sm",
    sm: "px-4 py-1.5 text-xs"
  }, o = {
    lg: "h-5 w-5",
    md: "h-4 w-4",
    sm: "h-3 w-3"
  };
  return l.link ? /* @__PURE__ */ y.jsxs(
    "a",
    {
      target: l.target,
      href: l.href,
      type: l.type || "submit",
      onClick: l.onClick,
      className: `${l.block ? "w-full" : ""} ${l.disabled ? "opacity-50 cursor-not-allowed" : ""} ${l.underline ? "underline decoration-2" : ""} ${l.underlineOnHover ? "hover:underline decoration-2" : ""} hover:cursor-pointer rounded my-2 mx-4 text-sm font-medium ${u[l.color]} ${l.className || ""}`,
      children: [
        l.label && /* @__PURE__ */ y.jsx("span", { children: l.label }),
        l.children
      ]
    }
  ) : /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsx(
    "button",
    {
      type: l.type || "button",
      disabled: l.disabled || !1,
      onClick: l.onClick,
      className: Kn(
        "inline-flex items-center gap-2 justify-center border rounded shadow-sm font-medium focus:outline-none focus:ring-2 focus:ring-offset-2 transition-colors duration-300",
        l.block ? "w-full" : "",
        l.disabled ? "opacity-50 cursor-not-allowed" : "",
        t[l.color],
        l.size ? r[l.size] : r.md,
        l.className || ""
      ),
      children: l.children || /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
        l.loading && /* @__PURE__ */ y.jsx(Y3, { className: `animate-spin ${o[l.size || "md"]}` }),
        l.icon && /* @__PURE__ */ y.jsx(n, { className: "w-5 h-5" }),
        l.label && /* @__PURE__ */ y.jsx("span", { className: `${l.iconOnMobile ? "hidden sm:inline-block" : ""}`, children: l.label })
      ] })
    }
  ) });
};
xd.propTypes = {};
const sr = ({ className: l, children: n, clickable: u, onClick: t, ...r }) => /* @__PURE__ */ y.jsx(
  "div",
  {
    className: wl(
      "w-full rounded transition-all duration-300 border",
      u && "cursor-pointer hover:shadow-lg",
      l
    ),
    onClick: () => u && (t == null ? void 0 : t()),
    ...r,
    children: n
  }
), yy = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("border-b px-6 py-4 first:rounded-t bg-gray-50", l), ...u, children: n }), $y = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("h4", { className: wl("text-base font-medium", l), ...u, children: n }), xy = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("p", { className: wl("text-sm text-gray-500", l), ...u, children: n }), Cy = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("text-sm", l), ...u, children: n }), wy = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("p-6 first:rounded-t", l), ...u, children: n }), Iy = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("border-t px-6 py-4 last:rounded-b", l), ...u, children: n });
sr.Header = yy;
sr.Title = $y;
sr.Subtitle = xy;
sr.Text = Cy;
sr.Body = wy;
sr.Footer = Iy;
const h_ = ({ className: l, children: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("container mx-auto px-4", l), ...u, children: n }), m_ = (l) => /* @__PURE__ */ y.jsxs("div", { className: "mt-6 relative", children: [
  /* @__PURE__ */ y.jsx("div", { className: "absolute inset-0 flex items-center", "aria-hidden": "true", children: /* @__PURE__ */ y.jsx("div", { className: "w-full border-t border-gray-300" }) }),
  /* @__PURE__ */ y.jsx("div", { className: "relative flex justify-center text-sm", children: /* @__PURE__ */ y.jsx("span", { className: "px-2 bg-white text-gray-500", children: l.label }) })
] });
var Ey = Object.defineProperty, Ay = (l, n, u) => n in l ? Ey(l, n, { enumerable: !0, configurable: !0, writable: !0, value: u }) : l[n] = u, ld = (l, n, u) => (Ay(l, typeof n != "symbol" ? n + "" : n, u), u);
let Sy = class {
  constructor() {
    ld(this, "current", this.detect()), ld(this, "handoffState", "pending"), ld(this, "currentId", 0);
  }
  set(n) {
    this.current !== n && (this.handoffState = "pending", this.currentId = 0, this.current = n);
  }
  reset() {
    this.set(this.detect());
  }
  nextId() {
    return ++this.currentId;
  }
  get isServer() {
    return this.current === "server";
  }
  get isClient() {
    return this.current === "client";
  }
  detect() {
    return typeof window > "u" || typeof document > "u" ? "server" : "client";
  }
  handoff() {
    this.handoffState === "pending" && (this.handoffState = "complete");
  }
  get isHandoffComplete() {
    return this.handoffState === "complete";
  }
}, It = new Sy();
function aa(l) {
  var n, u;
  return It.isServer ? null : l ? "ownerDocument" in l ? l.ownerDocument : "current" in l ? (u = (n = l.current) == null ? void 0 : n.ownerDocument) != null ? u : document : null : document;
}
function sa(l) {
  typeof queueMicrotask == "function" ? queueMicrotask(l) : Promise.resolve().then(l).catch((n) => setTimeout(() => {
    throw n;
  }));
}
function nt() {
  let l = [], n = { addEventListener(u, t, r, o) {
    return u.addEventListener(t, r, o), n.add(() => u.removeEventListener(t, r, o));
  }, requestAnimationFrame(...u) {
    let t = requestAnimationFrame(...u);
    return n.add(() => cancelAnimationFrame(t));
  }, nextFrame(...u) {
    return n.requestAnimationFrame(() => n.requestAnimationFrame(...u));
  }, setTimeout(...u) {
    let t = setTimeout(...u);
    return n.add(() => clearTimeout(t));
  }, microTask(...u) {
    let t = { current: !0 };
    return sa(() => {
      t.current && u[0]();
    }), n.add(() => {
      t.current = !1;
    });
  }, style(u, t, r) {
    let o = u.style.getPropertyValue(t);
    return Object.assign(u.style, { [t]: r }), this.add(() => {
      Object.assign(u.style, { [t]: o });
    });
  }, group(u) {
    let t = nt();
    return u(t), this.add(() => t.dispose());
  }, add(u) {
    return l.includes(u) || l.push(u), () => {
      let t = l.indexOf(u);
      if (t >= 0) for (let r of l.splice(t, 1)) r();
    };
  }, dispose() {
    for (let u of l.splice(0)) u();
  } };
  return n;
}
function gc() {
  let [l] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(nt);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => () => l.dispose(), [l]), l;
}
let ou = (l, n) => {
  It.isServer ? (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(l, n) : (0,react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect)(l, n);
};
function Pt(l) {
  let n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(l);
  return ou(() => {
    n.current = l;
  }, [l]), n;
}
let En = function(l) {
  let n = Pt(l);
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback((...u) => n.current(...u), [n]);
}, Py = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(void 0);
function Ny() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(Py);
}
function Cd(...l) {
  return Array.from(new Set(l.flatMap((n) => typeof n == "string" ? n.split(" ") : []))).filter(Boolean).join(" ");
}
function Ke(l, n, ...u) {
  if (l in n) {
    let r = n[l];
    return typeof r == "function" ? r(...u) : r;
  }
  let t = new Error(`Tried to handle "${l}" but there is no handler defined. Only defined handlers are: ${Object.keys(n).map((r) => `"${r}"`).join(", ")}.`);
  throw Error.captureStackTrace && Error.captureStackTrace(t, Ke), t;
}
var jo = ((l) => (l[l.None = 0] = "None", l[l.RenderStrategy = 1] = "RenderStrategy", l[l.Static = 2] = "Static", l))(jo || {}), Ue = ((l) => (l[l.Unmount = 0] = "Unmount", l[l.Hidden = 1] = "Hidden", l))(Ue || {});
function ku() {
  let l = Ry();
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((n) => Ty({ mergeRefs: l, ...n }), [l]);
}
function Ty({ ourProps: l, theirProps: n, slot: u, defaultTag: t, features: r, visible: o = !0, name: s, mergeRefs: d }) {
  d = d ?? Oy;
  let a = U3(n, l);
  if (o) return so(a, u, t, s, d);
  let c = r ?? 0;
  if (c & 2) {
    let { static: p = !1, ...g } = a;
    if (p) return so(g, u, t, s, d);
  }
  if (c & 1) {
    let { unmount: p = !0, ...g } = a;
    return Ke(p ? 0 : 1, { 0() {
      return null;
    }, 1() {
      return so({ ...g, hidden: !0, style: { display: "none" } }, u, t, s, d);
    } });
  }
  return so(a, u, t, s, d);
}
function so(l, n = {}, u, t, r) {
  let { as: o = u, children: s, refName: d = "ref", ...a } = nd(l, ["unmount", "static"]), c = l.ref !== void 0 ? { [d]: l.ref } : {}, p = typeof s == "function" ? s(n) : s;
  "className" in a && a.className && typeof a.className == "function" && (a.className = a.className(n)), a["aria-labelledby"] && a["aria-labelledby"] === a.id && (a["aria-labelledby"] = void 0);
  let g = {};
  if (n) {
    let m = !1, v = [];
    for (let [$, b] of Object.entries(n)) typeof b == "boolean" && (m = !0), b === !0 && v.push($.replace(/([A-Z])/g, (E) => `-${E.toLowerCase()}`));
    if (m) {
      g["data-headlessui-state"] = v.join(" ");
      for (let $ of v) g[`data-${$}`] = "";
    }
  }
  if (o === react__WEBPACK_IMPORTED_MODULE_0__.Fragment && (Object.keys(bt(a)).length > 0 || Object.keys(bt(g)).length > 0)) if (!(0,react__WEBPACK_IMPORTED_MODULE_0__.isValidElement)(p) || Array.isArray(p) && p.length > 1) {
    if (Object.keys(bt(a)).length > 0) throw new Error(['Passing props on "Fragment"!', "", `The current component <${t} /> is rendering a "Fragment".`, "However we need to passthrough the following props:", Object.keys(bt(a)).concat(Object.keys(bt(g))).map((m) => `  - ${m}`).join(`
`), "", "You can apply a few solutions:", ['Add an `as="..."` prop, to ensure that we render an actual element instead of a "Fragment".', "Render a single element as the child so that we can forward the props onto that element."].map((m) => `  - ${m}`).join(`
`)].join(`
`));
  } else {
    let m = p.props, v = m == null ? void 0 : m.className, $ = typeof v == "function" ? (...S) => Cd(v(...S), a.className) : Cd(v, a.className), b = $ ? { className: $ } : {}, E = U3(p.props, bt(nd(a, ["ref"])));
    for (let S in g) S in E && delete g[S];
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(p, Object.assign({}, E, g, c, { ref: r(Fy(p), c.ref) }, b));
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(o, Object.assign({}, nd(a, ["ref"]), o !== react__WEBPACK_IMPORTED_MODULE_0__.Fragment && c, o !== react__WEBPACK_IMPORTED_MODULE_0__.Fragment && g), p);
}
function Ry() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]), n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((u) => {
    for (let t of l.current) t != null && (typeof t == "function" ? t(u) : t.current = u);
  }, []);
  return (...u) => {
    if (!u.every((t) => t == null)) return l.current = u, n;
  };
}
function Oy(...l) {
  return l.every((n) => n == null) ? void 0 : (n) => {
    for (let u of l) u != null && (typeof u == "function" ? u(n) : u.current = n);
  };
}
function U3(...l) {
  if (l.length === 0) return {};
  if (l.length === 1) return l[0];
  let n = {}, u = {};
  for (let t of l) for (let r in t) r.startsWith("on") && typeof t[r] == "function" ? (u[r] != null || (u[r] = []), u[r].push(t[r])) : n[r] = t[r];
  if (n.disabled || n["aria-disabled"]) for (let t in u) /^(on(?:Click|Pointer|Mouse|Key)(?:Down|Up|Press)?)$/.test(t) && (u[t] = [(r) => {
    var o;
    return (o = r == null ? void 0 : r.preventDefault) == null ? void 0 : o.call(r);
  }]);
  for (let t in u) Object.assign(n, { [t](r, ...o) {
    let s = u[t];
    for (let d of s) {
      if ((r instanceof Event || (r == null ? void 0 : r.nativeEvent) instanceof Event) && r.defaultPrevented) return;
      d(r, ...o);
    }
  } });
  return n;
}
function mu(l) {
  var n;
  return Object.assign((0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(l), { displayName: (n = l.displayName) != null ? n : l.name });
}
function bt(l) {
  let n = Object.assign({}, l);
  for (let u in n) n[u] === void 0 && delete n[u];
  return n;
}
function nd(l, n = []) {
  let u = Object.assign({}, l);
  for (let t of n) t in u && delete u[t];
  return u;
}
function Fy(l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.version.split(".")[0] >= "19" ? l.props.ref : l.ref;
}
let _y = "span";
var Wo = ((l) => (l[l.None = 1] = "None", l[l.Focusable = 2] = "Focusable", l[l.Hidden = 4] = "Hidden", l))(Wo || {});
function Dy(l, n) {
  var u;
  let { features: t = 1, ...r } = l, o = { ref: n, "aria-hidden": (t & 2) === 2 ? !0 : (u = r["aria-hidden"]) != null ? u : void 0, hidden: (t & 4) === 4 ? !0 : void 0, style: { position: "fixed", top: 1, left: 1, width: 1, height: 0, padding: 0, margin: -1, overflow: "hidden", clip: "rect(0, 0, 0, 0)", whiteSpace: "nowrap", borderWidth: "0", ...(t & 4) === 4 && (t & 2) !== 2 && { display: "none" } } };
  return ku()({ ourProps: o, theirProps: r, slot: {}, defaultTag: _y, name: "Hidden" });
}
let wd = mu(Dy), J3 = Symbol();
function My(l, n = !0) {
  return Object.assign(l, { [J3]: n });
}
function pe(...l) {
  let n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(l);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    n.current = l;
  }, [l]);
  let u = En((t) => {
    for (let r of n.current) r != null && (typeof r == "function" ? r(t) : r.current = t);
  });
  return l.every((t) => t == null || (t == null ? void 0 : t[J3])) ? void 0 : u;
}
let hc = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
hc.displayName = "DescriptionContext";
function K3() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(hc);
  if (l === null) {
    let n = new Error("You used a <Description /> component, but it is not inside a relevant parent.");
    throw Error.captureStackTrace && Error.captureStackTrace(n, K3), n;
  }
  return l;
}
function By() {
  let [l, n] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
  return [l.length > 0 ? l.join(" ") : void 0, (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => function(u) {
    let t = En((o) => (n((s) => [...s, o]), () => n((s) => {
      let d = s.slice(), a = d.indexOf(o);
      return a !== -1 && d.splice(a, 1), d;
    }))), r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ register: t, slot: u.slot, name: u.name, props: u.props, value: u.value }), [t, u.slot, u.name, u.props, u.value]);
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(hc.Provider, { value: r }, u.children);
  }, [n])];
}
let Ly = "p";
function Gy(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), t = Ny(), { id: r = `headlessui-description-${u}`, ...o } = l, s = K3(), d = pe(n);
  ou(() => s.register(r), [r, s.register]);
  let a = t || !1, c = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ ...s.slot, disabled: a }), [s.slot, a]), p = { ref: d, ...s.props, id: r };
  return ku()({ ourProps: p, theirProps: o, slot: c, defaultTag: Ly, name: s.name || "Description" });
}
let jy = mu(Gy), Wy = Object.assign(jy, {});
var Q3 = ((l) => (l.Space = " ", l.Enter = "Enter", l.Escape = "Escape", l.Backspace = "Backspace", l.Delete = "Delete", l.ArrowLeft = "ArrowLeft", l.ArrowUp = "ArrowUp", l.ArrowRight = "ArrowRight", l.ArrowDown = "ArrowDown", l.Home = "Home", l.End = "End", l.PageUp = "PageUp", l.PageDown = "PageDown", l.Tab = "Tab", l))(Q3 || {});
let Vy = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(() => {
});
function ky({ value: l, children: n }) {
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(Vy.Provider, { value: l }, n);
}
let Hy = class extends Map {
  constructor(n) {
    super(), this.factory = n;
  }
  get(n) {
    let u = super.get(n);
    return u === void 0 && (u = this.factory(n), this.set(n, u)), u;
  }
};
function q3(l, n) {
  let u = l(), t = /* @__PURE__ */ new Set();
  return { getSnapshot() {
    return u;
  }, subscribe(r) {
    return t.add(r), () => t.delete(r);
  }, dispatch(r, ...o) {
    let s = n[r].call(u, ...o);
    s && (u = s, t.forEach((d) => d()));
  } };
}
function l4(l) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useSyncExternalStore)(l.subscribe, l.getSnapshot, l.getSnapshot);
}
let Zy = new Hy(() => q3(() => [], { ADD(l) {
  return this.includes(l) ? this : [...this, l];
}, REMOVE(l) {
  let n = this.indexOf(l);
  if (n === -1) return this;
  let u = this.slice();
  return u.splice(n, 1), u;
} }));
function dr(l, n) {
  let u = Zy.get(n), t = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), r = l4(u);
  if (ou(() => {
    if (l) return u.dispatch("ADD", t), () => u.dispatch("REMOVE", t);
  }, [u, l]), !l) return !1;
  let o = r.indexOf(t), s = r.length;
  return o === -1 && (o = s, s += 1), o === s - 1;
}
let Id = /* @__PURE__ */ new Map(), Xr = /* @__PURE__ */ new Map();
function Jf(l) {
  var n;
  let u = (n = Xr.get(l)) != null ? n : 0;
  return Xr.set(l, u + 1), u !== 0 ? () => Kf(l) : (Id.set(l, { "aria-hidden": l.getAttribute("aria-hidden"), inert: l.inert }), l.setAttribute("aria-hidden", "true"), l.inert = !0, () => Kf(l));
}
function Kf(l) {
  var n;
  let u = (n = Xr.get(l)) != null ? n : 1;
  if (u === 1 ? Xr.delete(l) : Xr.set(l, u - 1), u !== 1) return;
  let t = Id.get(l);
  t && (t["aria-hidden"] === null ? l.removeAttribute("aria-hidden") : l.setAttribute("aria-hidden", t["aria-hidden"]), l.inert = t.inert, Id.delete(l));
}
function Xy(l, { allowed: n, disallowed: u } = {}) {
  let t = dr(l, "inert-others");
  ou(() => {
    var r, o;
    if (!t) return;
    let s = nt();
    for (let a of (r = u == null ? void 0 : u()) != null ? r : []) a && s.add(Jf(a));
    let d = (o = n == null ? void 0 : n()) != null ? o : [];
    for (let a of d) {
      if (!a) continue;
      let c = aa(a);
      if (!c) continue;
      let p = a.parentElement;
      for (; p && p !== c.body; ) {
        for (let g of p.children) d.some((m) => g.contains(m)) || s.add(Jf(g));
        p = p.parentElement;
      }
    }
    return s.dispose;
  }, [t, n, u]);
}
function zy(l, n, u) {
  let t = Pt((r) => {
    let o = r.getBoundingClientRect();
    o.x === 0 && o.y === 0 && o.width === 0 && o.height === 0 && u();
  });
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!l) return;
    let r = n === null ? null : n instanceof HTMLElement ? n : n.current;
    if (!r) return;
    let o = nt();
    if (typeof ResizeObserver < "u") {
      let s = new ResizeObserver(() => t.current(r));
      s.observe(r), o.add(() => s.disconnect());
    }
    if (typeof IntersectionObserver < "u") {
      let s = new IntersectionObserver(() => t.current(r));
      s.observe(r), o.add(() => s.disconnect());
    }
    return () => o.dispose();
  }, [n, t, l]);
}
let Vo = ["[contentEditable=true]", "[tabindex]", "a[href]", "area[href]", "button:not([disabled])", "iframe", "input:not([disabled])", "select:not([disabled])", "textarea:not([disabled])"].map((l) => `${l}:not([tabindex='-1'])`).join(","), Yy = ["[data-autofocus]"].map((l) => `${l}:not([tabindex='-1'])`).join(",");
var Se = ((l) => (l[l.First = 1] = "First", l[l.Previous = 2] = "Previous", l[l.Next = 4] = "Next", l[l.Last = 8] = "Last", l[l.WrapAround = 16] = "WrapAround", l[l.NoScroll = 32] = "NoScroll", l[l.AutoFocus = 64] = "AutoFocus", l))(Se || {}), Ed = ((l) => (l[l.Error = 0] = "Error", l[l.Overflow = 1] = "Overflow", l[l.Success = 2] = "Success", l[l.Underflow = 3] = "Underflow", l))(Ed || {}), Uy = ((l) => (l[l.Previous = -1] = "Previous", l[l.Next = 1] = "Next", l))(Uy || {});
function Jy(l = document.body) {
  return l == null ? [] : Array.from(l.querySelectorAll(Vo)).sort((n, u) => Math.sign((n.tabIndex || Number.MAX_SAFE_INTEGER) - (u.tabIndex || Number.MAX_SAFE_INTEGER)));
}
function Ky(l = document.body) {
  return l == null ? [] : Array.from(l.querySelectorAll(Yy)).sort((n, u) => Math.sign((n.tabIndex || Number.MAX_SAFE_INTEGER) - (u.tabIndex || Number.MAX_SAFE_INTEGER)));
}
var n4 = ((l) => (l[l.Strict = 0] = "Strict", l[l.Loose = 1] = "Loose", l))(n4 || {});
function Qy(l, n = 0) {
  var u;
  return l === ((u = aa(l)) == null ? void 0 : u.body) ? !1 : Ke(n, { 0() {
    return l.matches(Vo);
  }, 1() {
    let t = l;
    for (; t !== null; ) {
      if (t.matches(Vo)) return !0;
      t = t.parentElement;
    }
    return !1;
  } });
}
var qy = ((l) => (l[l.Keyboard = 0] = "Keyboard", l[l.Mouse = 1] = "Mouse", l))(qy || {});
typeof window < "u" && typeof document < "u" && (document.addEventListener("keydown", (l) => {
  l.metaKey || l.altKey || l.ctrlKey || (document.documentElement.dataset.headlessuiFocusVisible = "");
}, !0), document.addEventListener("click", (l) => {
  l.detail === 1 ? delete document.documentElement.dataset.headlessuiFocusVisible : l.detail === 0 && (document.documentElement.dataset.headlessuiFocusVisible = "");
}, !0));
function Pe(l) {
  l == null || l.focus({ preventScroll: !0 });
}
let l$ = ["textarea", "input"].join(",");
function n$(l) {
  var n, u;
  return (u = (n = l == null ? void 0 : l.matches) == null ? void 0 : n.call(l, l$)) != null ? u : !1;
}
function u$(l, n = (u) => u) {
  return l.slice().sort((u, t) => {
    let r = n(u), o = n(t);
    if (r === null || o === null) return 0;
    let s = r.compareDocumentPosition(o);
    return s & Node.DOCUMENT_POSITION_FOLLOWING ? -1 : s & Node.DOCUMENT_POSITION_PRECEDING ? 1 : 0;
  });
}
function zr(l, n, { sorted: u = !0, relativeTo: t = null, skipElements: r = [] } = {}) {
  let o = Array.isArray(l) ? l.length > 0 ? l[0].ownerDocument : document : l.ownerDocument, s = Array.isArray(l) ? u ? u$(l) : l : n & 64 ? Ky(l) : Jy(l);
  r.length > 0 && s.length > 1 && (s = s.filter((v) => !r.some(($) => $ != null && "current" in $ ? ($ == null ? void 0 : $.current) === v : $ === v))), t = t ?? o.activeElement;
  let d = (() => {
    if (n & 5) return 1;
    if (n & 10) return -1;
    throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
  })(), a = (() => {
    if (n & 1) return 0;
    if (n & 2) return Math.max(0, s.indexOf(t)) - 1;
    if (n & 4) return Math.max(0, s.indexOf(t)) + 1;
    if (n & 8) return s.length - 1;
    throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
  })(), c = n & 32 ? { preventScroll: !0 } : {}, p = 0, g = s.length, m;
  do {
    if (p >= g || p + g <= 0) return 0;
    let v = a + p;
    if (n & 16) v = (v + g) % g;
    else {
      if (v < 0) return 3;
      if (v >= g) return 1;
    }
    m = s[v], m == null || m.focus(c), p += d;
  } while (m !== o.activeElement);
  return n & 6 && n$(m) && m.select(), 2;
}
function u4() {
  return /iPhone/gi.test(window.navigator.platform) || /Mac/gi.test(window.navigator.platform) && window.navigator.maxTouchPoints > 0;
}
function e$() {
  return /Android/gi.test(window.navigator.userAgent);
}
function t$() {
  return u4() || e$();
}
function Gr(l, n, u, t) {
  let r = Pt(u);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!l) return;
    function o(s) {
      r.current(s);
    }
    return document.addEventListener(n, o, t), () => document.removeEventListener(n, o, t);
  }, [l, n, t]);
}
function e4(l, n, u, t) {
  let r = Pt(u);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!l) return;
    function o(s) {
      r.current(s);
    }
    return window.addEventListener(n, o, t), () => window.removeEventListener(n, o, t);
  }, [l, n, t]);
}
const Qf = 30;
function r$(l, n, u) {
  let t = dr(l, "outside-click"), r = Pt(u), o = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(a, c) {
    if (a.defaultPrevented) return;
    let p = c(a);
    if (p === null || !p.getRootNode().contains(p) || !p.isConnected) return;
    let g = function m(v) {
      return typeof v == "function" ? m(v()) : Array.isArray(v) || v instanceof Set ? v : [v];
    }(n);
    for (let m of g) if (m !== null && (m.contains(p) || a.composed && a.composedPath().includes(m))) return;
    return !Qy(p, n4.Loose) && p.tabIndex !== -1 && a.preventDefault(), r.current(a, p);
  }, [r, n]), s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  Gr(t, "pointerdown", (a) => {
    var c, p;
    s.current = ((p = (c = a.composedPath) == null ? void 0 : c.call(a)) == null ? void 0 : p[0]) || a.target;
  }, !0), Gr(t, "mousedown", (a) => {
    var c, p;
    s.current = ((p = (c = a.composedPath) == null ? void 0 : c.call(a)) == null ? void 0 : p[0]) || a.target;
  }, !0), Gr(t, "click", (a) => {
    t$() || s.current && (o(a, () => s.current), s.current = null);
  }, !0);
  let d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({ x: 0, y: 0 });
  Gr(t, "touchstart", (a) => {
    d.current.x = a.touches[0].clientX, d.current.y = a.touches[0].clientY;
  }, !0), Gr(t, "touchend", (a) => {
    let c = { x: a.changedTouches[0].clientX, y: a.changedTouches[0].clientY };
    if (!(Math.abs(c.x - d.current.x) >= Qf || Math.abs(c.y - d.current.y) >= Qf)) return o(a, () => a.target instanceof HTMLElement ? a.target : null);
  }, !0), e4(t, "blur", (a) => o(a, () => window.document.activeElement instanceof HTMLIFrameElement ? window.document.activeElement : null), !0);
}
function da(...l) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => aa(...l), [...l]);
}
function t4(l, n, u, t) {
  let r = Pt(u);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    l = l ?? window;
    function o(s) {
      r.current(s);
    }
    return l.addEventListener(n, o, t), () => l.removeEventListener(n, o, t);
  }, [l, n, t]);
}
function i$() {
  let l;
  return { before({ doc: n }) {
    var u;
    let t = n.documentElement, r = (u = n.defaultView) != null ? u : window;
    l = Math.max(0, r.innerWidth - t.clientWidth);
  }, after({ doc: n, d: u }) {
    let t = n.documentElement, r = Math.max(0, t.clientWidth - t.offsetWidth), o = Math.max(0, l - r);
    u.style(t, "paddingRight", `${o}px`);
  } };
}
function o$() {
  return u4() ? { before({ doc: l, d: n, meta: u }) {
    function t(r) {
      return u.containers.flatMap((o) => o()).some((o) => o.contains(r));
    }
    n.microTask(() => {
      var r;
      if (window.getComputedStyle(l.documentElement).scrollBehavior !== "auto") {
        let d = nt();
        d.style(l.documentElement, "scrollBehavior", "auto"), n.add(() => n.microTask(() => d.dispose()));
      }
      let o = (r = window.scrollY) != null ? r : window.pageYOffset, s = null;
      n.addEventListener(l, "click", (d) => {
        if (d.target instanceof HTMLElement) try {
          let a = d.target.closest("a");
          if (!a) return;
          let { hash: c } = new URL(a.href), p = l.querySelector(c);
          p && !t(p) && (s = p);
        } catch {
        }
      }, !0), n.addEventListener(l, "touchstart", (d) => {
        if (d.target instanceof HTMLElement) if (t(d.target)) {
          let a = d.target;
          for (; a.parentElement && t(a.parentElement); ) a = a.parentElement;
          n.style(a, "overscrollBehavior", "contain");
        } else n.style(d.target, "touchAction", "none");
      }), n.addEventListener(l, "touchmove", (d) => {
        if (d.target instanceof HTMLElement) {
          if (d.target.tagName === "INPUT") return;
          if (t(d.target)) {
            let a = d.target;
            for (; a.parentElement && a.dataset.headlessuiPortal !== "" && !(a.scrollHeight > a.clientHeight || a.scrollWidth > a.clientWidth); ) a = a.parentElement;
            a.dataset.headlessuiPortal === "" && d.preventDefault();
          } else d.preventDefault();
        }
      }, { passive: !1 }), n.add(() => {
        var d;
        let a = (d = window.scrollY) != null ? d : window.pageYOffset;
        o !== a && window.scrollTo(0, o), s && s.isConnected && (s.scrollIntoView({ block: "nearest" }), s = null);
      });
    });
  } } : {};
}
function a$() {
  return { before({ doc: l, d: n }) {
    n.style(l.documentElement, "overflow", "hidden");
  } };
}
function s$(l) {
  let n = {};
  for (let u of l) Object.assign(n, u(n));
  return n;
}
let Ct = q3(() => /* @__PURE__ */ new Map(), { PUSH(l, n) {
  var u;
  let t = (u = this.get(l)) != null ? u : { doc: l, count: 0, d: nt(), meta: /* @__PURE__ */ new Set() };
  return t.count++, t.meta.add(n), this.set(l, t), this;
}, POP(l, n) {
  let u = this.get(l);
  return u && (u.count--, u.meta.delete(n)), this;
}, SCROLL_PREVENT({ doc: l, d: n, meta: u }) {
  let t = { doc: l, d: n, meta: s$(u) }, r = [o$(), i$(), a$()];
  r.forEach(({ before: o }) => o == null ? void 0 : o(t)), r.forEach(({ after: o }) => o == null ? void 0 : o(t));
}, SCROLL_ALLOW({ d: l }) {
  l.dispose();
}, TEARDOWN({ doc: l }) {
  this.delete(l);
} });
Ct.subscribe(() => {
  let l = Ct.getSnapshot(), n = /* @__PURE__ */ new Map();
  for (let [u] of l) n.set(u, u.documentElement.style.overflow);
  for (let u of l.values()) {
    let t = n.get(u.doc) === "hidden", r = u.count !== 0;
    (r && !t || !r && t) && Ct.dispatch(u.count > 0 ? "SCROLL_PREVENT" : "SCROLL_ALLOW", u), u.count === 0 && Ct.dispatch("TEARDOWN", u);
  }
});
function d$(l, n, u = () => ({ containers: [] })) {
  let t = l4(Ct), r = n ? t.get(n) : void 0, o = r ? r.count > 0 : !1;
  return ou(() => {
    if (!(!n || !l)) return Ct.dispatch("PUSH", n, u), () => Ct.dispatch("POP", n, u);
  }, [l, n]), o;
}
function c$(l, n, u = () => [document.body]) {
  let t = dr(l, "scroll-lock");
  d$(t, n, (r) => {
    var o;
    return { containers: [...(o = r.containers) != null ? o : [], u] };
  });
}
function f$(l = 0) {
  let [n, u] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(l), t = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((a) => u(a), [n]), r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((a) => u((c) => c | a), [n]), o = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((a) => (n & a) === a, [n]), s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((a) => u((c) => c & ~a), [u]), d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((a) => u((c) => c ^ a), [u]);
  return { flags: n, setFlag: t, addFlag: r, hasFlag: o, removeFlag: s, toggleFlag: d };
}
var qf, l2;
typeof process < "u" && typeof globalThis < "u" && typeof Element < "u" && ((qf = process == null ? void 0 : process.env) == null ? void 0 : qf.NODE_ENV) === "test" && typeof ((l2 = Element == null ? void 0 : Element.prototype) == null ? void 0 : l2.getAnimations) > "u" && (Element.prototype.getAnimations = function() {
  return console.warn(["Headless UI has polyfilled `Element.prototype.getAnimations` for your tests.", "Please install a proper polyfill e.g. `jsdom-testing-mocks`, to silence these warnings.", "", "Example usage:", "```js", "import { mockAnimationsApi } from 'jsdom-testing-mocks'", "mockAnimationsApi()", "```"].join(`
`)), [];
});
var p$ = ((l) => (l[l.None = 0] = "None", l[l.Closed = 1] = "Closed", l[l.Enter = 2] = "Enter", l[l.Leave = 4] = "Leave", l))(p$ || {});
function g$(l) {
  let n = {};
  for (let u in l) l[u] === !0 && (n[`data-${u}`] = "");
  return n;
}
function h$(l, n, u, t) {
  let [r, o] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(u), { hasFlag: s, addFlag: d, removeFlag: a } = f$(l && r ? 3 : 0), c = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), g = gc();
  return ou(() => {
    var m;
    if (l) {
      if (u && o(!0), !n) {
        u && d(3);
        return;
      }
      return (m = t == null ? void 0 : t.start) == null || m.call(t, u), m$(n, { inFlight: c, prepare() {
        p.current ? p.current = !1 : p.current = c.current, c.current = !0, !p.current && (u ? (d(3), a(4)) : (d(4), a(2)));
      }, run() {
        p.current ? u ? (a(3), d(4)) : (a(4), d(3)) : u ? a(1) : d(1);
      }, done() {
        var v;
        p.current && typeof n.getAnimations == "function" && n.getAnimations().length > 0 || (c.current = !1, a(7), u || o(!1), (v = t == null ? void 0 : t.end) == null || v.call(t, u));
      } });
    }
  }, [l, u, n, g]), l ? [r, { closed: s(1), enter: s(2), leave: s(4), transition: s(2) || s(4) }] : [u, { closed: void 0, enter: void 0, leave: void 0, transition: void 0 }];
}
function m$(l, { prepare: n, run: u, done: t, inFlight: r }) {
  let o = nt();
  return b$(l, { prepare: n, inFlight: r }), o.nextFrame(() => {
    u(), o.requestAnimationFrame(() => {
      o.add(v$(l, t));
    });
  }), o.dispose;
}
function v$(l, n) {
  var u, t;
  let r = nt();
  if (!l) return r.dispose;
  let o = !1;
  r.add(() => {
    o = !0;
  });
  let s = (t = (u = l.getAnimations) == null ? void 0 : u.call(l).filter((d) => d instanceof CSSTransition)) != null ? t : [];
  return s.length === 0 ? (n(), r.dispose) : (Promise.allSettled(s.map((d) => d.finished)).then(() => {
    o || n();
  }), r.dispose);
}
function b$(l, { inFlight: n, prepare: u }) {
  if (n != null && n.current) {
    u();
    return;
  }
  let t = l.style.transition;
  l.style.transition = "none", u(), l.offsetHeight, l.style.transition = t;
}
function mc(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]), t = En(l);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    let r = [...u.current];
    for (let [o, s] of n.entries()) if (u.current[o] !== s) {
      let d = t(n, r);
      return u.current = n, d;
    }
  }, [t, ...n]);
}
const y$ = ["top", "right", "bottom", "left"], Qe = Math.min, Iu = Math.max, ko = Math.round, co = Math.floor, qe = (l) => ({
  x: l,
  y: l
}), $$ = {
  left: "right",
  right: "left",
  bottom: "top",
  top: "bottom"
}, x$ = {
  start: "end",
  end: "start"
};
function Ad(l, n, u) {
  return Iu(l, Qe(n, u));
}
function Ne(l, n) {
  return typeof l == "function" ? l(n) : l;
}
function Te(l) {
  return l.split("-")[0];
}
function cr(l) {
  return l.split("-")[1];
}
function vc(l) {
  return l === "x" ? "y" : "x";
}
function bc(l) {
  return l === "y" ? "height" : "width";
}
function fr(l) {
  return ["top", "bottom"].includes(Te(l)) ? "y" : "x";
}
function yc(l) {
  return vc(fr(l));
}
function C$(l, n, u) {
  u === void 0 && (u = !1);
  const t = cr(l), r = yc(l), o = bc(r);
  let s = r === "x" ? t === (u ? "end" : "start") ? "right" : "left" : t === "start" ? "bottom" : "top";
  return n.reference[o] > n.floating[o] && (s = Ho(s)), [s, Ho(s)];
}
function w$(l) {
  const n = Ho(l);
  return [Sd(l), n, Sd(n)];
}
function Sd(l) {
  return l.replace(/start|end/g, (n) => x$[n]);
}
function I$(l, n, u) {
  const t = ["left", "right"], r = ["right", "left"], o = ["top", "bottom"], s = ["bottom", "top"];
  switch (l) {
    case "top":
    case "bottom":
      return u ? n ? r : t : n ? t : r;
    case "left":
    case "right":
      return n ? o : s;
    default:
      return [];
  }
}
function E$(l, n, u, t) {
  const r = cr(l);
  let o = I$(Te(l), u === "start", t);
  return r && (o = o.map((s) => s + "-" + r), n && (o = o.concat(o.map(Sd)))), o;
}
function Ho(l) {
  return l.replace(/left|right|bottom|top/g, (n) => $$[n]);
}
function A$(l) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...l
  };
}
function r4(l) {
  return typeof l != "number" ? A$(l) : {
    top: l,
    right: l,
    bottom: l,
    left: l
  };
}
function Zo(l) {
  return {
    ...l,
    top: l.y,
    left: l.x,
    right: l.x + l.width,
    bottom: l.y + l.height
  };
}
function n2(l, n, u) {
  let {
    reference: t,
    floating: r
  } = l;
  const o = fr(n), s = yc(n), d = bc(s), a = Te(n), c = o === "y", p = t.x + t.width / 2 - r.width / 2, g = t.y + t.height / 2 - r.height / 2, m = t[d] / 2 - r[d] / 2;
  let v;
  switch (a) {
    case "top":
      v = {
        x: p,
        y: t.y - r.height
      };
      break;
    case "bottom":
      v = {
        x: p,
        y: t.y + t.height
      };
      break;
    case "right":
      v = {
        x: t.x + t.width,
        y: g
      };
      break;
    case "left":
      v = {
        x: t.x - r.width,
        y: g
      };
      break;
    default:
      v = {
        x: t.x,
        y: t.y
      };
  }
  switch (cr(n)) {
    case "start":
      v[s] -= m * (u && c ? -1 : 1);
      break;
    case "end":
      v[s] += m * (u && c ? -1 : 1);
      break;
  }
  return v;
}
const S$ = async (l, n, u) => {
  const {
    placement: t = "bottom",
    strategy: r = "absolute",
    middleware: o = [],
    platform: s
  } = u, d = o.filter(Boolean), a = await (s.isRTL == null ? void 0 : s.isRTL(n));
  let c = await s.getElementRects({
    reference: l,
    floating: n,
    strategy: r
  }), {
    x: p,
    y: g
  } = n2(c, t, a), m = t, v = {}, $ = 0;
  for (let b = 0; b < d.length; b++) {
    const {
      name: E,
      fn: S
    } = d[b], {
      x: A,
      y: x,
      data: I,
      reset: P
    } = await S({
      x: p,
      y: g,
      initialPlacement: t,
      placement: m,
      strategy: r,
      middlewareData: v,
      rects: c,
      platform: s,
      elements: {
        reference: l,
        floating: n
      }
    });
    p = A ?? p, g = x ?? g, v = {
      ...v,
      [E]: {
        ...v[E],
        ...I
      }
    }, P && $ <= 50 && ($++, typeof P == "object" && (P.placement && (m = P.placement), P.rects && (c = P.rects === !0 ? await s.getElementRects({
      reference: l,
      floating: n,
      strategy: r
    }) : P.rects), {
      x: p,
      y: g
    } = n2(c, m, a)), b = -1);
  }
  return {
    x: p,
    y: g,
    placement: m,
    strategy: r,
    middlewareData: v
  };
};
async function Yr(l, n) {
  var u;
  n === void 0 && (n = {});
  const {
    x: t,
    y: r,
    platform: o,
    rects: s,
    elements: d,
    strategy: a
  } = l, {
    boundary: c = "clippingAncestors",
    rootBoundary: p = "viewport",
    elementContext: g = "floating",
    altBoundary: m = !1,
    padding: v = 0
  } = Ne(n, l), $ = r4(v), E = d[m ? g === "floating" ? "reference" : "floating" : g], S = Zo(await o.getClippingRect({
    element: (u = await (o.isElement == null ? void 0 : o.isElement(E))) == null || u ? E : E.contextElement || await (o.getDocumentElement == null ? void 0 : o.getDocumentElement(d.floating)),
    boundary: c,
    rootBoundary: p,
    strategy: a
  })), A = g === "floating" ? {
    ...s.floating,
    x: t,
    y: r
  } : s.reference, x = await (o.getOffsetParent == null ? void 0 : o.getOffsetParent(d.floating)), I = await (o.isElement == null ? void 0 : o.isElement(x)) ? await (o.getScale == null ? void 0 : o.getScale(x)) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  }, P = Zo(o.convertOffsetParentRelativeRectToViewportRelativeRect ? await o.convertOffsetParentRelativeRectToViewportRelativeRect({
    elements: d,
    rect: A,
    offsetParent: x,
    strategy: a
  }) : A);
  return {
    top: (S.top - P.top + $.top) / I.y,
    bottom: (P.bottom - S.bottom + $.bottom) / I.y,
    left: (S.left - P.left + $.left) / I.x,
    right: (P.right - S.right + $.right) / I.x
  };
}
const P$ = (l) => ({
  name: "arrow",
  options: l,
  async fn(n) {
    const {
      x: u,
      y: t,
      placement: r,
      rects: o,
      platform: s,
      elements: d,
      middlewareData: a
    } = n, {
      element: c,
      padding: p = 0
    } = Ne(l, n) || {};
    if (c == null)
      return {};
    const g = r4(p), m = {
      x: u,
      y: t
    }, v = yc(r), $ = bc(v), b = await s.getDimensions(c), E = v === "y", S = E ? "top" : "left", A = E ? "bottom" : "right", x = E ? "clientHeight" : "clientWidth", I = o.reference[$] + o.reference[v] - m[v] - o.floating[$], P = m[v] - o.reference[v], O = await (s.getOffsetParent == null ? void 0 : s.getOffsetParent(c));
    let _ = O ? O[x] : 0;
    (!_ || !await (s.isElement == null ? void 0 : s.isElement(O))) && (_ = d.floating[x] || o.floating[$]);
    const j = I / 2 - P / 2, z = _ / 2 - b[$] / 2 - 1, Y = Qe(g[S], z), el = Qe(g[A], z), U = Y, ul = _ - b[$] - el, il = _ / 2 - b[$] / 2 + j, rl = Ad(U, il, ul), tl = !a.arrow && cr(r) != null && il !== rl && o.reference[$] / 2 - (il < U ? Y : el) - b[$] / 2 < 0, sl = tl ? il < U ? il - U : il - ul : 0;
    return {
      [v]: m[v] + sl,
      data: {
        [v]: rl,
        centerOffset: il - rl - sl,
        ...tl && {
          alignmentOffset: sl
        }
      },
      reset: tl
    };
  }
}), N$ = function(l) {
  return l === void 0 && (l = {}), {
    name: "flip",
    options: l,
    async fn(n) {
      var u, t;
      const {
        placement: r,
        middlewareData: o,
        rects: s,
        initialPlacement: d,
        platform: a,
        elements: c
      } = n, {
        mainAxis: p = !0,
        crossAxis: g = !0,
        fallbackPlacements: m,
        fallbackStrategy: v = "bestFit",
        fallbackAxisSideDirection: $ = "none",
        flipAlignment: b = !0,
        ...E
      } = Ne(l, n);
      if ((u = o.arrow) != null && u.alignmentOffset)
        return {};
      const S = Te(r), A = Te(d) === d, x = await (a.isRTL == null ? void 0 : a.isRTL(c.floating)), I = m || (A || !b ? [Ho(d)] : w$(d));
      !m && $ !== "none" && I.push(...E$(d, b, $, x));
      const P = [d, ...I], O = await Yr(n, E), _ = [];
      let j = ((t = o.flip) == null ? void 0 : t.overflows) || [];
      if (p && _.push(O[S]), g) {
        const U = C$(r, s, x);
        _.push(O[U[0]], O[U[1]]);
      }
      if (j = [...j, {
        placement: r,
        overflows: _
      }], !_.every((U) => U <= 0)) {
        var z, Y;
        const U = (((z = o.flip) == null ? void 0 : z.index) || 0) + 1, ul = P[U];
        if (ul)
          return {
            data: {
              index: U,
              overflows: j
            },
            reset: {
              placement: ul
            }
          };
        let il = (Y = j.filter((rl) => rl.overflows[0] <= 0).sort((rl, tl) => rl.overflows[1] - tl.overflows[1])[0]) == null ? void 0 : Y.placement;
        if (!il)
          switch (v) {
            case "bestFit": {
              var el;
              const rl = (el = j.map((tl) => [tl.placement, tl.overflows.filter((sl) => sl > 0).reduce((sl, ll) => sl + ll, 0)]).sort((tl, sl) => tl[1] - sl[1])[0]) == null ? void 0 : el[0];
              rl && (il = rl);
              break;
            }
            case "initialPlacement":
              il = d;
              break;
          }
        if (r !== il)
          return {
            reset: {
              placement: il
            }
          };
      }
      return {};
    }
  };
};
function u2(l, n) {
  return {
    top: l.top - n.height,
    right: l.right - n.width,
    bottom: l.bottom - n.height,
    left: l.left - n.width
  };
}
function e2(l) {
  return y$.some((n) => l[n] >= 0);
}
const T$ = function(l) {
  return l === void 0 && (l = {}), {
    name: "hide",
    options: l,
    async fn(n) {
      const {
        rects: u
      } = n, {
        strategy: t = "referenceHidden",
        ...r
      } = Ne(l, n);
      switch (t) {
        case "referenceHidden": {
          const o = await Yr(n, {
            ...r,
            elementContext: "reference"
          }), s = u2(o, u.reference);
          return {
            data: {
              referenceHiddenOffsets: s,
              referenceHidden: e2(s)
            }
          };
        }
        case "escaped": {
          const o = await Yr(n, {
            ...r,
            altBoundary: !0
          }), s = u2(o, u.floating);
          return {
            data: {
              escapedOffsets: s,
              escaped: e2(s)
            }
          };
        }
        default:
          return {};
      }
    }
  };
};
async function R$(l, n) {
  const {
    placement: u,
    platform: t,
    elements: r
  } = l, o = await (t.isRTL == null ? void 0 : t.isRTL(r.floating)), s = Te(u), d = cr(u), a = fr(u) === "y", c = ["left", "top"].includes(s) ? -1 : 1, p = o && a ? -1 : 1, g = Ne(n, l);
  let {
    mainAxis: m,
    crossAxis: v,
    alignmentAxis: $
  } = typeof g == "number" ? {
    mainAxis: g,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: 0,
    crossAxis: 0,
    alignmentAxis: null,
    ...g
  };
  return d && typeof $ == "number" && (v = d === "end" ? $ * -1 : $), a ? {
    x: v * p,
    y: m * c
  } : {
    x: m * c,
    y: v * p
  };
}
const O$ = function(l) {
  return l === void 0 && (l = 0), {
    name: "offset",
    options: l,
    async fn(n) {
      var u, t;
      const {
        x: r,
        y: o,
        placement: s,
        middlewareData: d
      } = n, a = await R$(n, l);
      return s === ((u = d.offset) == null ? void 0 : u.placement) && (t = d.arrow) != null && t.alignmentOffset ? {} : {
        x: r + a.x,
        y: o + a.y,
        data: {
          ...a,
          placement: s
        }
      };
    }
  };
}, F$ = function(l) {
  return l === void 0 && (l = {}), {
    name: "shift",
    options: l,
    async fn(n) {
      const {
        x: u,
        y: t,
        placement: r
      } = n, {
        mainAxis: o = !0,
        crossAxis: s = !1,
        limiter: d = {
          fn: (E) => {
            let {
              x: S,
              y: A
            } = E;
            return {
              x: S,
              y: A
            };
          }
        },
        ...a
      } = Ne(l, n), c = {
        x: u,
        y: t
      }, p = await Yr(n, a), g = fr(Te(r)), m = vc(g);
      let v = c[m], $ = c[g];
      if (o) {
        const E = m === "y" ? "top" : "left", S = m === "y" ? "bottom" : "right", A = v + p[E], x = v - p[S];
        v = Ad(A, v, x);
      }
      if (s) {
        const E = g === "y" ? "top" : "left", S = g === "y" ? "bottom" : "right", A = $ + p[E], x = $ - p[S];
        $ = Ad(A, $, x);
      }
      const b = d.fn({
        ...n,
        [m]: v,
        [g]: $
      });
      return {
        ...b,
        data: {
          x: b.x - u,
          y: b.y - t
        }
      };
    }
  };
}, _$ = function(l) {
  return l === void 0 && (l = {}), {
    options: l,
    fn(n) {
      const {
        x: u,
        y: t,
        placement: r,
        rects: o,
        middlewareData: s
      } = n, {
        offset: d = 0,
        mainAxis: a = !0,
        crossAxis: c = !0
      } = Ne(l, n), p = {
        x: u,
        y: t
      }, g = fr(r), m = vc(g);
      let v = p[m], $ = p[g];
      const b = Ne(d, n), E = typeof b == "number" ? {
        mainAxis: b,
        crossAxis: 0
      } : {
        mainAxis: 0,
        crossAxis: 0,
        ...b
      };
      if (a) {
        const x = m === "y" ? "height" : "width", I = o.reference[m] - o.floating[x] + E.mainAxis, P = o.reference[m] + o.reference[x] - E.mainAxis;
        v < I ? v = I : v > P && (v = P);
      }
      if (c) {
        var S, A;
        const x = m === "y" ? "width" : "height", I = ["top", "left"].includes(Te(r)), P = o.reference[g] - o.floating[x] + (I && ((S = s.offset) == null ? void 0 : S[g]) || 0) + (I ? 0 : E.crossAxis), O = o.reference[g] + o.reference[x] + (I ? 0 : ((A = s.offset) == null ? void 0 : A[g]) || 0) - (I ? E.crossAxis : 0);
        $ < P ? $ = P : $ > O && ($ = O);
      }
      return {
        [m]: v,
        [g]: $
      };
    }
  };
}, D$ = function(l) {
  return l === void 0 && (l = {}), {
    name: "size",
    options: l,
    async fn(n) {
      const {
        placement: u,
        rects: t,
        platform: r,
        elements: o
      } = n, {
        apply: s = () => {
        },
        ...d
      } = Ne(l, n), a = await Yr(n, d), c = Te(u), p = cr(u), g = fr(u) === "y", {
        width: m,
        height: v
      } = t.floating;
      let $, b;
      c === "top" || c === "bottom" ? ($ = c, b = p === (await (r.isRTL == null ? void 0 : r.isRTL(o.floating)) ? "start" : "end") ? "left" : "right") : (b = c, $ = p === "end" ? "top" : "bottom");
      const E = v - a[$], S = m - a[b], A = !n.middlewareData.shift;
      let x = E, I = S;
      if (g) {
        const O = m - a.left - a.right;
        I = p || A ? Qe(S, O) : O;
      } else {
        const O = v - a.top - a.bottom;
        x = p || A ? Qe(E, O) : O;
      }
      if (A && !p) {
        const O = Iu(a.left, 0), _ = Iu(a.right, 0), j = Iu(a.top, 0), z = Iu(a.bottom, 0);
        g ? I = m - 2 * (O !== 0 || _ !== 0 ? O + _ : Iu(a.left, a.right)) : x = v - 2 * (j !== 0 || z !== 0 ? j + z : Iu(a.top, a.bottom));
      }
      await s({
        ...n,
        availableWidth: I,
        availableHeight: x
      });
      const P = await r.getDimensions(o.floating);
      return m !== P.width || v !== P.height ? {
        reset: {
          rects: !0
        }
      } : {};
    }
  };
};
function lt(l) {
  return i4(l) ? (l.nodeName || "").toLowerCase() : "#document";
}
function Au(l) {
  var n;
  return (l == null || (n = l.ownerDocument) == null ? void 0 : n.defaultView) || window;
}
function Fe(l) {
  var n;
  return (n = (i4(l) ? l.ownerDocument : l.document) || window.document) == null ? void 0 : n.documentElement;
}
function i4(l) {
  return l instanceof Node || l instanceof Au(l).Node;
}
function Re(l) {
  return l instanceof Element || l instanceof Au(l).Element;
}
function ce(l) {
  return l instanceof HTMLElement || l instanceof Au(l).HTMLElement;
}
function t2(l) {
  return typeof ShadowRoot > "u" ? !1 : l instanceof ShadowRoot || l instanceof Au(l).ShadowRoot;
}
function ei(l) {
  const {
    overflow: n,
    overflowX: u,
    overflowY: t,
    display: r
  } = ju(l);
  return /auto|scroll|overlay|hidden|clip/.test(n + t + u) && !["inline", "contents"].includes(r);
}
function M$(l) {
  return ["table", "td", "th"].includes(lt(l));
}
function $c(l) {
  const n = xc(), u = ju(l);
  return u.transform !== "none" || u.perspective !== "none" || (u.containerType ? u.containerType !== "normal" : !1) || !n && (u.backdropFilter ? u.backdropFilter !== "none" : !1) || !n && (u.filter ? u.filter !== "none" : !1) || ["transform", "perspective", "filter"].some((t) => (u.willChange || "").includes(t)) || ["paint", "layout", "strict", "content"].some((t) => (u.contain || "").includes(t));
}
function B$(l) {
  let n = ur(l);
  for (; ce(n) && !ca(n); ) {
    if ($c(n))
      return n;
    n = ur(n);
  }
  return null;
}
function xc() {
  return typeof CSS > "u" || !CSS.supports ? !1 : CSS.supports("-webkit-backdrop-filter", "none");
}
function ca(l) {
  return ["html", "body", "#document"].includes(lt(l));
}
function ju(l) {
  return Au(l).getComputedStyle(l);
}
function fa(l) {
  return Re(l) ? {
    scrollLeft: l.scrollLeft,
    scrollTop: l.scrollTop
  } : {
    scrollLeft: l.pageXOffset,
    scrollTop: l.pageYOffset
  };
}
function ur(l) {
  if (lt(l) === "html")
    return l;
  const n = (
    // Step into the shadow DOM of the parent of a slotted node.
    l.assignedSlot || // DOM Element detected.
    l.parentNode || // ShadowRoot detected.
    t2(l) && l.host || // Fallback.
    Fe(l)
  );
  return t2(n) ? n.host : n;
}
function o4(l) {
  const n = ur(l);
  return ca(n) ? l.ownerDocument ? l.ownerDocument.body : l.body : ce(n) && ei(n) ? n : o4(n);
}
function Ur(l, n, u) {
  var t;
  n === void 0 && (n = []), u === void 0 && (u = !0);
  const r = o4(l), o = r === ((t = l.ownerDocument) == null ? void 0 : t.body), s = Au(r);
  return o ? n.concat(s, s.visualViewport || [], ei(r) ? r : [], s.frameElement && u ? Ur(s.frameElement) : []) : n.concat(r, Ur(r, [], u));
}
function a4(l) {
  const n = ju(l);
  let u = parseFloat(n.width) || 0, t = parseFloat(n.height) || 0;
  const r = ce(l), o = r ? l.offsetWidth : u, s = r ? l.offsetHeight : t, d = ko(u) !== o || ko(t) !== s;
  return d && (u = o, t = s), {
    width: u,
    height: t,
    $: d
  };
}
function Cc(l) {
  return Re(l) ? l : l.contextElement;
}
function Qt(l) {
  const n = Cc(l);
  if (!ce(n))
    return qe(1);
  const u = n.getBoundingClientRect(), {
    width: t,
    height: r,
    $: o
  } = a4(n);
  let s = (o ? ko(u.width) : u.width) / t, d = (o ? ko(u.height) : u.height) / r;
  return (!s || !Number.isFinite(s)) && (s = 1), (!d || !Number.isFinite(d)) && (d = 1), {
    x: s,
    y: d
  };
}
const L$ = /* @__PURE__ */ qe(0);
function s4(l) {
  const n = Au(l);
  return !xc() || !n.visualViewport ? L$ : {
    x: n.visualViewport.offsetLeft,
    y: n.visualViewport.offsetTop
  };
}
function G$(l, n, u) {
  return n === void 0 && (n = !1), !u || n && u !== Au(l) ? !1 : n;
}
function Et(l, n, u, t) {
  n === void 0 && (n = !1), u === void 0 && (u = !1);
  const r = l.getBoundingClientRect(), o = Cc(l);
  let s = qe(1);
  n && (t ? Re(t) && (s = Qt(t)) : s = Qt(l));
  const d = G$(o, u, t) ? s4(o) : qe(0);
  let a = (r.left + d.x) / s.x, c = (r.top + d.y) / s.y, p = r.width / s.x, g = r.height / s.y;
  if (o) {
    const m = Au(o), v = t && Re(t) ? Au(t) : t;
    let $ = m, b = $.frameElement;
    for (; b && t && v !== $; ) {
      const E = Qt(b), S = b.getBoundingClientRect(), A = ju(b), x = S.left + (b.clientLeft + parseFloat(A.paddingLeft)) * E.x, I = S.top + (b.clientTop + parseFloat(A.paddingTop)) * E.y;
      a *= E.x, c *= E.y, p *= E.x, g *= E.y, a += x, c += I, $ = Au(b), b = $.frameElement;
    }
  }
  return Zo({
    width: p,
    height: g,
    x: a,
    y: c
  });
}
const j$ = [":popover-open", ":modal"];
function d4(l) {
  return j$.some((n) => {
    try {
      return l.matches(n);
    } catch {
      return !1;
    }
  });
}
function W$(l) {
  let {
    elements: n,
    rect: u,
    offsetParent: t,
    strategy: r
  } = l;
  const o = r === "fixed", s = Fe(t), d = n ? d4(n.floating) : !1;
  if (t === s || d && o)
    return u;
  let a = {
    scrollLeft: 0,
    scrollTop: 0
  }, c = qe(1);
  const p = qe(0), g = ce(t);
  if ((g || !g && !o) && ((lt(t) !== "body" || ei(s)) && (a = fa(t)), ce(t))) {
    const m = Et(t);
    c = Qt(t), p.x = m.x + t.clientLeft, p.y = m.y + t.clientTop;
  }
  return {
    width: u.width * c.x,
    height: u.height * c.y,
    x: u.x * c.x - a.scrollLeft * c.x + p.x,
    y: u.y * c.y - a.scrollTop * c.y + p.y
  };
}
function V$(l) {
  return Array.from(l.getClientRects());
}
function c4(l) {
  return Et(Fe(l)).left + fa(l).scrollLeft;
}
function k$(l) {
  const n = Fe(l), u = fa(l), t = l.ownerDocument.body, r = Iu(n.scrollWidth, n.clientWidth, t.scrollWidth, t.clientWidth), o = Iu(n.scrollHeight, n.clientHeight, t.scrollHeight, t.clientHeight);
  let s = -u.scrollLeft + c4(l);
  const d = -u.scrollTop;
  return ju(t).direction === "rtl" && (s += Iu(n.clientWidth, t.clientWidth) - r), {
    width: r,
    height: o,
    x: s,
    y: d
  };
}
function H$(l, n) {
  const u = Au(l), t = Fe(l), r = u.visualViewport;
  let o = t.clientWidth, s = t.clientHeight, d = 0, a = 0;
  if (r) {
    o = r.width, s = r.height;
    const c = xc();
    (!c || c && n === "fixed") && (d = r.offsetLeft, a = r.offsetTop);
  }
  return {
    width: o,
    height: s,
    x: d,
    y: a
  };
}
function Z$(l, n) {
  const u = Et(l, !0, n === "fixed"), t = u.top + l.clientTop, r = u.left + l.clientLeft, o = ce(l) ? Qt(l) : qe(1), s = l.clientWidth * o.x, d = l.clientHeight * o.y, a = r * o.x, c = t * o.y;
  return {
    width: s,
    height: d,
    x: a,
    y: c
  };
}
function r2(l, n, u) {
  let t;
  if (n === "viewport")
    t = H$(l, u);
  else if (n === "document")
    t = k$(Fe(l));
  else if (Re(n))
    t = Z$(n, u);
  else {
    const r = s4(l);
    t = {
      ...n,
      x: n.x - r.x,
      y: n.y - r.y
    };
  }
  return Zo(t);
}
function f4(l, n) {
  const u = ur(l);
  return u === n || !Re(u) || ca(u) ? !1 : ju(u).position === "fixed" || f4(u, n);
}
function X$(l, n) {
  const u = n.get(l);
  if (u)
    return u;
  let t = Ur(l, [], !1).filter((d) => Re(d) && lt(d) !== "body"), r = null;
  const o = ju(l).position === "fixed";
  let s = o ? ur(l) : l;
  for (; Re(s) && !ca(s); ) {
    const d = ju(s), a = $c(s);
    !a && d.position === "fixed" && (r = null), (o ? !a && !r : !a && d.position === "static" && !!r && ["absolute", "fixed"].includes(r.position) || ei(s) && !a && f4(l, s)) ? t = t.filter((p) => p !== s) : r = d, s = ur(s);
  }
  return n.set(l, t), t;
}
function z$(l) {
  let {
    element: n,
    boundary: u,
    rootBoundary: t,
    strategy: r
  } = l;
  const s = [...u === "clippingAncestors" ? X$(n, this._c) : [].concat(u), t], d = s[0], a = s.reduce((c, p) => {
    const g = r2(n, p, r);
    return c.top = Iu(g.top, c.top), c.right = Qe(g.right, c.right), c.bottom = Qe(g.bottom, c.bottom), c.left = Iu(g.left, c.left), c;
  }, r2(n, d, r));
  return {
    width: a.right - a.left,
    height: a.bottom - a.top,
    x: a.left,
    y: a.top
  };
}
function Y$(l) {
  const {
    width: n,
    height: u
  } = a4(l);
  return {
    width: n,
    height: u
  };
}
function U$(l, n, u) {
  const t = ce(n), r = Fe(n), o = u === "fixed", s = Et(l, !0, o, n);
  let d = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const a = qe(0);
  if (t || !t && !o)
    if ((lt(n) !== "body" || ei(r)) && (d = fa(n)), t) {
      const g = Et(n, !0, o, n);
      a.x = g.x + n.clientLeft, a.y = g.y + n.clientTop;
    } else r && (a.x = c4(r));
  const c = s.left + d.scrollLeft - a.x, p = s.top + d.scrollTop - a.y;
  return {
    x: c,
    y: p,
    width: s.width,
    height: s.height
  };
}
function i2(l, n) {
  return !ce(l) || ju(l).position === "fixed" ? null : n ? n(l) : l.offsetParent;
}
function p4(l, n) {
  const u = Au(l);
  if (!ce(l) || d4(l))
    return u;
  let t = i2(l, n);
  for (; t && M$(t) && ju(t).position === "static"; )
    t = i2(t, n);
  return t && (lt(t) === "html" || lt(t) === "body" && ju(t).position === "static" && !$c(t)) ? u : t || B$(l) || u;
}
const J$ = async function(l) {
  const n = this.getOffsetParent || p4, u = this.getDimensions;
  return {
    reference: U$(l.reference, await n(l.floating), l.strategy),
    floating: {
      x: 0,
      y: 0,
      ...await u(l.floating)
    }
  };
};
function K$(l) {
  return ju(l).direction === "rtl";
}
const Q$ = {
  convertOffsetParentRelativeRectToViewportRelativeRect: W$,
  getDocumentElement: Fe,
  getClippingRect: z$,
  getOffsetParent: p4,
  getElementRects: J$,
  getClientRects: V$,
  getDimensions: Y$,
  getScale: Qt,
  isElement: Re,
  isRTL: K$
};
function q$(l, n) {
  let u = null, t;
  const r = Fe(l);
  function o() {
    var d;
    clearTimeout(t), (d = u) == null || d.disconnect(), u = null;
  }
  function s(d, a) {
    d === void 0 && (d = !1), a === void 0 && (a = 1), o();
    const {
      left: c,
      top: p,
      width: g,
      height: m
    } = l.getBoundingClientRect();
    if (d || n(), !g || !m)
      return;
    const v = co(p), $ = co(r.clientWidth - (c + g)), b = co(r.clientHeight - (p + m)), E = co(c), A = {
      rootMargin: -v + "px " + -$ + "px " + -b + "px " + -E + "px",
      threshold: Iu(0, Qe(1, a)) || 1
    };
    let x = !0;
    function I(P) {
      const O = P[0].intersectionRatio;
      if (O !== a) {
        if (!x)
          return s();
        O ? s(!1, O) : t = setTimeout(() => {
          s(!1, 1e-7);
        }, 100);
      }
      x = !1;
    }
    try {
      u = new IntersectionObserver(I, {
        ...A,
        // Handle <iframe>s
        root: r.ownerDocument
      });
    } catch {
      u = new IntersectionObserver(I, A);
    }
    u.observe(l);
  }
  return s(!0), o;
}
function wc(l, n, u, t) {
  t === void 0 && (t = {});
  const {
    ancestorScroll: r = !0,
    ancestorResize: o = !0,
    elementResize: s = typeof ResizeObserver == "function",
    layoutShift: d = typeof IntersectionObserver == "function",
    animationFrame: a = !1
  } = t, c = Cc(l), p = r || o ? [...c ? Ur(c) : [], ...Ur(n)] : [];
  p.forEach((S) => {
    r && S.addEventListener("scroll", u, {
      passive: !0
    }), o && S.addEventListener("resize", u);
  });
  const g = c && d ? q$(c, u) : null;
  let m = -1, v = null;
  s && (v = new ResizeObserver((S) => {
    let [A] = S;
    A && A.target === c && v && (v.unobserve(n), cancelAnimationFrame(m), m = requestAnimationFrame(() => {
      var x;
      (x = v) == null || x.observe(n);
    })), u();
  }), c && !a && v.observe(c), v.observe(n));
  let $, b = a ? Et(l) : null;
  a && E();
  function E() {
    const S = Et(l);
    b && (S.x !== b.x || S.y !== b.y || S.width !== b.width || S.height !== b.height) && u(), b = S, $ = requestAnimationFrame(E);
  }
  return u(), () => {
    var S;
    p.forEach((A) => {
      r && A.removeEventListener("scroll", u), o && A.removeEventListener("resize", u);
    }), g == null || g(), (S = v) == null || S.disconnect(), v = null, a && cancelAnimationFrame($);
  };
}
const lx = F$, nx = N$, ux = D$, ex = T$, o2 = P$, tx = _$, rx = (l, n, u) => {
  const t = /* @__PURE__ */ new Map(), r = {
    platform: Q$,
    ...u
  }, o = {
    ...r.platform,
    _c: t
  };
  return S$(l, n, {
    ...r,
    platform: o
  });
};
var Ao = typeof document < "u" ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_0__.useEffect;
function Xo(l, n) {
  if (l === n)
    return !0;
  if (typeof l != typeof n)
    return !1;
  if (typeof l == "function" && l.toString() === n.toString())
    return !0;
  let u, t, r;
  if (l && n && typeof l == "object") {
    if (Array.isArray(l)) {
      if (u = l.length, u !== n.length) return !1;
      for (t = u; t-- !== 0; )
        if (!Xo(l[t], n[t]))
          return !1;
      return !0;
    }
    if (r = Object.keys(l), u = r.length, u !== Object.keys(n).length)
      return !1;
    for (t = u; t-- !== 0; )
      if (!{}.hasOwnProperty.call(n, r[t]))
        return !1;
    for (t = u; t-- !== 0; ) {
      const o = r[t];
      if (!(o === "_owner" && l.$$typeof) && !Xo(l[o], n[o]))
        return !1;
    }
    return !0;
  }
  return l !== l && n !== n;
}
function g4(l) {
  return typeof window > "u" ? 1 : (l.ownerDocument.defaultView || window).devicePixelRatio || 1;
}
function a2(l, n) {
  const u = g4(l);
  return Math.round(n * u) / u;
}
function ud(l) {
  const n = react__WEBPACK_IMPORTED_MODULE_0__.useRef(l);
  return Ao(() => {
    n.current = l;
  }), n;
}
function h4(l) {
  l === void 0 && (l = {});
  const {
    placement: n = "bottom",
    strategy: u = "absolute",
    middleware: t = [],
    platform: r,
    elements: {
      reference: o,
      floating: s
    } = {},
    transform: d = !0,
    whileElementsMounted: a,
    open: c
  } = l, [p, g] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    x: 0,
    y: 0,
    strategy: u,
    placement: n,
    middlewareData: {},
    isPositioned: !1
  }), [m, v] = react__WEBPACK_IMPORTED_MODULE_0__.useState(t);
  Xo(m, t) || v(t);
  const [$, b] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), [E, S] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), A = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((ll) => {
    ll !== O.current && (O.current = ll, b(ll));
  }, []), x = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((ll) => {
    ll !== _.current && (_.current = ll, S(ll));
  }, []), I = o || $, P = s || E, O = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), _ = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), j = react__WEBPACK_IMPORTED_MODULE_0__.useRef(p), z = a != null, Y = ud(a), el = ud(r), U = ud(c), ul = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    if (!O.current || !_.current)
      return;
    const ll = {
      placement: n,
      strategy: u,
      middleware: m
    };
    el.current && (ll.platform = el.current), rx(O.current, _.current, ll).then((H) => {
      const V = {
        ...H,
        // The floating element's position may be recomputed while it's closed
        // but still mounted (such as when transitioning out). To ensure
        // `isPositioned` will be `false` initially on the next open, avoid
        // setting it to `true` when `open === false` (must be specified).
        isPositioned: U.current !== !1
      };
      il.current && !Xo(j.current, V) && (j.current = V, react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync(() => {
        g(V);
      }));
    });
  }, [m, n, u, el, U]);
  Ao(() => {
    c === !1 && j.current.isPositioned && (j.current.isPositioned = !1, g((ll) => ({
      ...ll,
      isPositioned: !1
    })));
  }, [c]);
  const il = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1);
  Ao(() => (il.current = !0, () => {
    il.current = !1;
  }), []), Ao(() => {
    if (I && (O.current = I), P && (_.current = P), I && P) {
      if (Y.current)
        return Y.current(I, P, ul);
      ul();
    }
  }, [I, P, ul, Y, z]);
  const rl = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    reference: O,
    floating: _,
    setReference: A,
    setFloating: x
  }), [A, x]), tl = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    reference: I,
    floating: P
  }), [I, P]), sl = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    const ll = {
      position: u,
      left: 0,
      top: 0
    };
    if (!tl.floating)
      return ll;
    const H = a2(tl.floating, p.x), V = a2(tl.floating, p.y);
    return d ? {
      ...ll,
      transform: "translate(" + H + "px, " + V + "px)",
      ...g4(tl.floating) >= 1.5 && {
        willChange: "transform"
      }
    } : {
      position: u,
      left: H,
      top: V
    };
  }, [u, d, tl.floating, p.x, p.y]);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    ...p,
    update: ul,
    refs: rl,
    elements: tl,
    floatingStyles: sl
  }), [p, ul, rl, tl, sl]);
}
const ix = (l) => {
  function n(u) {
    return {}.hasOwnProperty.call(u, "current");
  }
  return {
    name: "arrow",
    options: l,
    fn(u) {
      const {
        element: t,
        padding: r
      } = typeof l == "function" ? l(u) : l;
      return t && n(t) ? t.current != null ? o2({
        element: t.current,
        padding: r
      }).fn(u) : {} : t ? o2({
        element: t,
        padding: r
      }).fn(u) : {};
    }
  };
}, m4 = (l, n) => ({
  ...O$(l),
  options: [l, n]
}), v4 = (l, n) => ({
  ...lx(l),
  options: [l, n]
}), b4 = (l, n) => ({
  ...tx(l),
  options: [l, n]
}), y4 = (l, n) => ({
  ...nx(l),
  options: [l, n]
}), $4 = (l, n) => ({
  ...ux(l),
  options: [l, n]
}), x4 = (l, n) => ({
  ...ex(l),
  options: [l, n]
}), C4 = (l, n) => ({
  ...ix(l),
  options: [l, n]
});
let pa = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
pa.displayName = "OpenClosedContext";
var le = ((l) => (l[l.Open = 1] = "Open", l[l.Closed = 2] = "Closed", l[l.Closing = 4] = "Closing", l[l.Opening = 8] = "Opening", l))(le || {});
function ga() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(pa);
}
function ox({ value: l, children: n }) {
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(pa.Provider, { value: l }, n);
}
function ax({ children: l }) {
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(pa.Provider, { value: null }, l);
}
function sx(l) {
  function n() {
    document.readyState !== "loading" && (l(), document.removeEventListener("DOMContentLoaded", n));
  }
  typeof window < "u" && typeof document < "u" && (document.addEventListener("DOMContentLoaded", n), n());
}
let ze = [];
sx(() => {
  function l(n) {
    if (!(n.target instanceof HTMLElement) || n.target === document.body || ze[0] === n.target) return;
    let u = n.target;
    u = u.closest(Vo), ze.unshift(u ?? n.target), ze = ze.filter((t) => t != null && t.isConnected), ze.splice(10);
  }
  window.addEventListener("click", l, { capture: !0 }), window.addEventListener("mousedown", l, { capture: !0 }), window.addEventListener("focus", l, { capture: !0 }), document.body.addEventListener("click", l, { capture: !0 }), document.body.addEventListener("mousedown", l, { capture: !0 }), document.body.addEventListener("focus", l, { capture: !0 });
});
function w4(l) {
  let n = En(l), u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => (u.current = !1, () => {
    u.current = !0, sa(() => {
      u.current && n();
    });
  }), [n]);
}
function dx() {
  let l = typeof document > "u";
  return "useSyncExternalStore" in /*#__PURE__*/ (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache || (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache = __webpack_require__.t(react__WEBPACK_IMPORTED_MODULE_0__, 2))) ? ((n) => n.useSyncExternalStore)(/*#__PURE__*/ (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache || (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache = __webpack_require__.t(react__WEBPACK_IMPORTED_MODULE_0__, 2))))(() => () => {
  }, () => !1, () => !l) : !1;
}
function ti() {
  let l = dx(), [n, u] = react__WEBPACK_IMPORTED_MODULE_0__.useState(It.isHandoffComplete);
  return n && It.isHandoffComplete === !1 && u(!1), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    n !== !0 && u(!0);
  }, [n]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => It.handoff(), []), l ? !1 : n;
}
let I4 = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(!1);
function cx() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(I4);
}
function s2(l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(I4.Provider, { value: l.force }, l.children);
}
function fx(l) {
  let n = cx(), u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(A4), [t, r] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(() => {
    var o;
    if (!n && u !== null) return (o = u.current) != null ? o : null;
    if (It.isServer) return null;
    let s = l == null ? void 0 : l.getElementById("headlessui-portal-root");
    if (s) return s;
    if (l === null) return null;
    let d = l.createElement("div");
    return d.setAttribute("id", "headlessui-portal-root"), l.body.appendChild(d);
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    t !== null && (l != null && l.body.contains(t) || l == null || l.body.appendChild(t));
  }, [t, l]), (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    n || u !== null && r(u.current);
  }, [u, r, n]), t;
}
let E4 = react__WEBPACK_IMPORTED_MODULE_0__.Fragment, px = mu(function(l, n) {
  let { ownerDocument: u = null, ...t } = l, r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), o = pe(My((v) => {
    r.current = v;
  }), n), s = da(r), d = u ?? s, a = fx(d), [c] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(() => {
    var v;
    return It.isServer ? null : (v = d == null ? void 0 : d.createElement("div")) != null ? v : null;
  }), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(Pd), g = ti();
  ou(() => {
    !a || !c || a.contains(c) || (c.setAttribute("data-headlessui-portal", ""), a.appendChild(c));
  }, [a, c]), ou(() => {
    if (c && p) return p.register(c);
  }, [p, c]), w4(() => {
    var v;
    !a || !c || (c instanceof Node && a.contains(c) && a.removeChild(c), a.childNodes.length <= 0 && ((v = a.parentElement) == null || v.removeChild(a)));
  });
  let m = ku();
  return g ? !a || !c ? null : (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)(m({ ourProps: { ref: o }, theirProps: t, slot: {}, defaultTag: E4, name: "Portal" }), c) : null;
});
function gx(l, n) {
  let u = pe(n), { enabled: t = !0, ownerDocument: r, ...o } = l, s = ku();
  return t ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(px, { ...o, ownerDocument: r, ref: u }) : s({ ourProps: { ref: u }, theirProps: o, slot: {}, defaultTag: E4, name: "Portal" });
}
let hx = react__WEBPACK_IMPORTED_MODULE_0__.Fragment, A4 = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
function mx(l, n) {
  let { target: u, ...t } = l, r = { ref: pe(n) }, o = ku();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(A4.Provider, { value: u }, o({ ourProps: r, theirProps: t, defaultTag: hx, name: "Popover.Group" }));
}
let Pd = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
function vx() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(Pd), n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]), u = En((o) => (n.current.push(o), l && l.register(o), () => t(o))), t = En((o) => {
    let s = n.current.indexOf(o);
    s !== -1 && n.current.splice(s, 1), l && l.unregister(o);
  }), r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ register: u, unregister: t, portals: n }), [u, t, n]);
  return [n, (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => function({ children: o }) {
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(Pd.Provider, { value: r }, o);
  }, [r])];
}
let bx = mu(gx), S4 = mu(mx), yx = Object.assign(bx, { Group: S4 });
function $x(l, n = typeof document < "u" ? document.defaultView : null, u) {
  let t = dr(l, "escape");
  t4(n, "keydown", (r) => {
    t && (r.defaultPrevented || r.key === Q3.Escape && u(r));
  });
}
function xx() {
  var l;
  let [n] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(() => typeof window < "u" && typeof window.matchMedia == "function" ? window.matchMedia("(pointer: coarse)") : null), [u, t] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)((l = n == null ? void 0 : n.matches) != null ? l : !1);
  return ou(() => {
    if (!n) return;
    function r(o) {
      t(o.matches);
    }
    return n.addEventListener("change", r), () => n.removeEventListener("change", r);
  }, [n]), u;
}
function Cx({ defaultContainers: l = [], portals: n, mainTreeNode: u } = {}) {
  let t = da(u), r = En(() => {
    var o, s;
    let d = [];
    for (let a of l) a !== null && (a instanceof HTMLElement ? d.push(a) : "current" in a && a.current instanceof HTMLElement && d.push(a.current));
    if (n != null && n.current) for (let a of n.current) d.push(a);
    for (let a of (o = t == null ? void 0 : t.querySelectorAll("html > *, body > *")) != null ? o : []) a !== document.body && a !== document.head && a instanceof HTMLElement && a.id !== "headlessui-portal-root" && (u && (a.contains(u) || a.contains((s = u == null ? void 0 : u.getRootNode()) == null ? void 0 : s.host)) || d.some((c) => a.contains(c)) || d.push(a));
    return d;
  });
  return { resolveContainers: r, contains: En((o) => r().some((s) => s.contains(o))) };
}
let P4 = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
function d2({ children: l, node: n }) {
  let [u, t] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null), r = N4(n ?? u);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(P4.Provider, { value: r }, l, r === null && react__WEBPACK_IMPORTED_MODULE_0__.createElement(wd, { features: Wo.Hidden, ref: (o) => {
    var s, d;
    if (o) {
      for (let a of (d = (s = aa(o)) == null ? void 0 : s.querySelectorAll("html > *, body > *")) != null ? d : []) if (a !== document.body && a !== document.head && a instanceof HTMLElement && a != null && a.contains(o)) {
        t(a);
        break;
      }
    }
  } }));
}
function N4(l = null) {
  var n;
  return (n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(P4)) != null ? n : l;
}
function Ic() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1);
  return ou(() => (l.current = !0, () => {
    l.current = !1;
  }), []), l;
}
var kr = ((l) => (l[l.Forwards = 0] = "Forwards", l[l.Backwards = 1] = "Backwards", l))(kr || {});
function wx() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(0);
  return e4(!0, "keydown", (n) => {
    n.key === "Tab" && (l.current = n.shiftKey ? 1 : 0);
  }, !0), l;
}
function T4(l) {
  if (!l) return /* @__PURE__ */ new Set();
  if (typeof l == "function") return new Set(l());
  let n = /* @__PURE__ */ new Set();
  for (let u of l.current) u.current instanceof HTMLElement && n.add(u.current);
  return n;
}
let Ix = "div";
var $t = ((l) => (l[l.None = 0] = "None", l[l.InitialFocus = 1] = "InitialFocus", l[l.TabLock = 2] = "TabLock", l[l.FocusLock = 4] = "FocusLock", l[l.RestoreFocus = 8] = "RestoreFocus", l[l.AutoFocus = 16] = "AutoFocus", l))($t || {});
function Ex(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), t = pe(u, n), { initialFocus: r, initialFocusFallback: o, containers: s, features: d = 15, ...a } = l;
  ti() || (d = 0);
  let c = da(u);
  Nx(d, { ownerDocument: c });
  let p = Tx(d, { ownerDocument: c, container: u, initialFocus: r, initialFocusFallback: o });
  Rx(d, { ownerDocument: c, container: u, containers: s, previousActiveElement: p });
  let g = wx(), m = En((A) => {
    let x = u.current;
    x && ((I) => I())(() => {
      Ke(g.current, { [kr.Forwards]: () => {
        zr(x, Se.First, { skipElements: [A.relatedTarget, o] });
      }, [kr.Backwards]: () => {
        zr(x, Se.Last, { skipElements: [A.relatedTarget, o] });
      } });
    });
  }), v = dr(!!(d & 2), "focus-trap#tab-lock"), $ = gc(), b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), E = { ref: t, onKeyDown(A) {
    A.key == "Tab" && (b.current = !0, $.requestAnimationFrame(() => {
      b.current = !1;
    }));
  }, onBlur(A) {
    if (!(d & 4)) return;
    let x = T4(s);
    u.current instanceof HTMLElement && x.add(u.current);
    let I = A.relatedTarget;
    I instanceof HTMLElement && I.dataset.headlessuiFocusGuard !== "true" && (R4(x, I) || (b.current ? zr(u.current, Ke(g.current, { [kr.Forwards]: () => Se.Next, [kr.Backwards]: () => Se.Previous }) | Se.WrapAround, { relativeTo: A.target }) : A.target instanceof HTMLElement && Pe(A.target)));
  } }, S = ku();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, v && react__WEBPACK_IMPORTED_MODULE_0__.createElement(wd, { as: "button", type: "button", "data-headlessui-focus-guard": !0, onFocus: m, features: Wo.Focusable }), S({ ourProps: E, theirProps: a, defaultTag: Ix, name: "FocusTrap" }), v && react__WEBPACK_IMPORTED_MODULE_0__.createElement(wd, { as: "button", type: "button", "data-headlessui-focus-guard": !0, onFocus: m, features: Wo.Focusable }));
}
let Ax = mu(Ex), Sx = Object.assign(Ax, { features: $t });
function Px(l = !0) {
  let n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(ze.slice());
  return mc(([u], [t]) => {
    t === !0 && u === !1 && sa(() => {
      n.current.splice(0);
    }), t === !1 && u === !0 && (n.current = ze.slice());
  }, [l, ze, n]), En(() => {
    var u;
    return (u = n.current.find((t) => t != null && t.isConnected)) != null ? u : null;
  });
}
function Nx(l, { ownerDocument: n }) {
  let u = !!(l & 8), t = Px(u);
  mc(() => {
    u || (n == null ? void 0 : n.activeElement) === (n == null ? void 0 : n.body) && Pe(t());
  }, [u]), w4(() => {
    u && Pe(t());
  });
}
function Tx(l, { ownerDocument: n, container: u, initialFocus: t, initialFocusFallback: r }) {
  let o = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), s = dr(!!(l & 1), "focus-trap#initial-focus"), d = Ic();
  return mc(() => {
    if (l === 0) return;
    if (!s) {
      r != null && r.current && Pe(r.current);
      return;
    }
    let a = u.current;
    a && sa(() => {
      if (!d.current) return;
      let c = n == null ? void 0 : n.activeElement;
      if (t != null && t.current) {
        if ((t == null ? void 0 : t.current) === c) {
          o.current = c;
          return;
        }
      } else if (a.contains(c)) {
        o.current = c;
        return;
      }
      if (t != null && t.current) Pe(t.current);
      else {
        if (l & 16) {
          if (zr(a, Se.First | Se.AutoFocus) !== Ed.Error) return;
        } else if (zr(a, Se.First) !== Ed.Error) return;
        if (r != null && r.current && (Pe(r.current), (n == null ? void 0 : n.activeElement) === r.current)) return;
        console.warn("There are no focusable elements inside the <FocusTrap />");
      }
      o.current = n == null ? void 0 : n.activeElement;
    });
  }, [r, s, l]), o;
}
function Rx(l, { ownerDocument: n, container: u, containers: t, previousActiveElement: r }) {
  let o = Ic(), s = !!(l & 4);
  t4(n == null ? void 0 : n.defaultView, "focus", (d) => {
    if (!s || !o.current) return;
    let a = T4(t);
    u.current instanceof HTMLElement && a.add(u.current);
    let c = r.current;
    if (!c) return;
    let p = d.target;
    p && p instanceof HTMLElement ? R4(a, p) ? (r.current = p, Pe(p)) : (d.preventDefault(), d.stopPropagation(), Pe(c)) : Pe(r.current);
  }, !0);
}
function R4(l, n) {
  for (let u of l) if (u.contains(n)) return !0;
  return !1;
}
function O4(l) {
  var n;
  return !!(l.enter || l.enterFrom || l.enterTo || l.leave || l.leaveFrom || l.leaveTo) || ((n = l.as) != null ? n : _4) !== react__WEBPACK_IMPORTED_MODULE_0__.Fragment || react__WEBPACK_IMPORTED_MODULE_0__.Children.count(l.children) === 1;
}
let ha = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
ha.displayName = "TransitionContext";
var Ox = ((l) => (l.Visible = "visible", l.Hidden = "hidden", l))(Ox || {});
function Fx() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ha);
  if (l === null) throw new Error("A <Transition.Child /> is used but it is missing a parent <Transition /> or <Transition.Root />.");
  return l;
}
function _x() {
  let l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ma);
  if (l === null) throw new Error("A <Transition.Child /> is used but it is missing a parent <Transition /> or <Transition.Root />.");
  return l;
}
let ma = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
ma.displayName = "NestingContext";
function va(l) {
  return "children" in l ? va(l.children) : l.current.filter(({ el: n }) => n.current !== null).filter(({ state: n }) => n === "visible").length > 0;
}
function F4(l, n) {
  let u = Pt(l), t = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]), r = Ic(), o = gc(), s = En((v, $ = Ue.Hidden) => {
    let b = t.current.findIndex(({ el: E }) => E === v);
    b !== -1 && (Ke($, { [Ue.Unmount]() {
      t.current.splice(b, 1);
    }, [Ue.Hidden]() {
      t.current[b].state = "hidden";
    } }), o.microTask(() => {
      var E;
      !va(t) && r.current && ((E = u.current) == null || E.call(u));
    }));
  }), d = En((v) => {
    let $ = t.current.find(({ el: b }) => b === v);
    return $ ? $.state !== "visible" && ($.state = "visible") : t.current.push({ el: v, state: "visible" }), () => s(v, Ue.Unmount);
  }), a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]), c = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(Promise.resolve()), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({ enter: [], leave: [] }), g = En((v, $, b) => {
    a.current.splice(0), n && (n.chains.current[$] = n.chains.current[$].filter(([E]) => E !== v)), n == null || n.chains.current[$].push([v, new Promise((E) => {
      a.current.push(E);
    })]), n == null || n.chains.current[$].push([v, new Promise((E) => {
      Promise.all(p.current[$].map(([S, A]) => A)).then(() => E());
    })]), $ === "enter" ? c.current = c.current.then(() => n == null ? void 0 : n.wait.current).then(() => b($)) : b($);
  }), m = En((v, $, b) => {
    Promise.all(p.current[$].splice(0).map(([E, S]) => S)).then(() => {
      var E;
      (E = a.current.shift()) == null || E();
    }).then(() => b($));
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ children: t, register: d, unregister: s, onStart: g, onStop: m, wait: c, chains: p }), [d, s, t, g, m, p, c]);
}
let _4 = react__WEBPACK_IMPORTED_MODULE_0__.Fragment, D4 = jo.RenderStrategy;
function Dx(l, n) {
  var u, t;
  let { transition: r = !0, beforeEnter: o, afterEnter: s, beforeLeave: d, afterLeave: a, enter: c, enterFrom: p, enterTo: g, entered: m, leave: v, leaveFrom: $, leaveTo: b, ...E } = l, [S, A] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null), x = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), I = O4(l), P = pe(...I ? [x, n, A] : n === null ? [] : [n]), O = (u = E.unmount) == null || u ? Ue.Unmount : Ue.Hidden, { show: _, appear: j, initial: z } = Fx(), [Y, el] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(_ ? "visible" : "hidden"), U = _x(), { register: ul, unregister: il } = U;
  ou(() => ul(x), [ul, x]), ou(() => {
    if (O === Ue.Hidden && x.current) {
      if (_ && Y !== "visible") {
        el("visible");
        return;
      }
      return Ke(Y, { hidden: () => il(x), visible: () => ul(x) });
    }
  }, [Y, x, ul, il, _, O]);
  let rl = ti();
  ou(() => {
    if (I && rl && Y === "visible" && x.current === null) throw new Error("Did you forget to passthrough the `ref` to the actual DOM node?");
  }, [x, Y, rl, I]);
  let tl = z && !j, sl = j && _ && z, ll = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), H = F4(() => {
    ll.current || (el("hidden"), il(x));
  }, U), V = En((ol) => {
    ll.current = !0;
    let ml = ol ? "enter" : "leave";
    H.onStart(x, ml, (Sl) => {
      Sl === "enter" ? o == null || o() : Sl === "leave" && (d == null || d());
    });
  }), X = En((ol) => {
    let ml = ol ? "enter" : "leave";
    ll.current = !1, H.onStop(x, ml, (Sl) => {
      Sl === "enter" ? s == null || s() : Sl === "leave" && (a == null || a());
    }), ml === "leave" && !va(H) && (el("hidden"), il(x));
  });
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    I && r || (V(_), X(_));
  }, [_, I, r]);
  let dl = !(!r || !I || !rl || tl), [, fl] = h$(dl, S, _, { start: V, end: X }), $l = bt({ ref: P, className: ((t = Cd(E.className, sl && c, sl && p, fl.enter && c, fl.enter && fl.closed && p, fl.enter && !fl.closed && g, fl.leave && v, fl.leave && !fl.closed && $, fl.leave && fl.closed && b, !fl.transition && _ && m)) == null ? void 0 : t.trim()) || void 0, ...g$(fl) }), cl = 0;
  Y === "visible" && (cl |= le.Open), Y === "hidden" && (cl |= le.Closed), _ && Y === "hidden" && (cl |= le.Opening), !_ && Y === "visible" && (cl |= le.Closing);
  let xl = ku();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(ma.Provider, { value: H }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(ox, { value: cl }, xl({ ourProps: $l, theirProps: E, defaultTag: _4, features: D4, visible: Y === "visible", name: "Transition.Child" })));
}
function Mx(l, n) {
  let { show: u, appear: t = !1, unmount: r = !0, ...o } = l, s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), d = O4(l), a = pe(...d ? [s, n] : n === null ? [] : [n]);
  ti();
  let c = ga();
  if (u === void 0 && c !== null && (u = (c & le.Open) === le.Open), u === void 0) throw new Error("A <Transition /> is used but it is missing a `show={true | false}` prop.");
  let [p, g] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(u ? "visible" : "hidden"), m = F4(() => {
    u || g("hidden");
  }), [v, $] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(!0), b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([u]);
  ou(() => {
    v !== !1 && b.current[b.current.length - 1] !== u && (b.current.push(u), $(!1));
  }, [b, u]);
  let E = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ show: u, appear: t, initial: v }), [u, t, v]);
  ou(() => {
    u ? g("visible") : !va(m) && s.current !== null && g("hidden");
  }, [u, m]);
  let S = { unmount: r }, A = En(() => {
    var P;
    v && $(!1), (P = l.beforeEnter) == null || P.call(l);
  }), x = En(() => {
    var P;
    v && $(!1), (P = l.beforeLeave) == null || P.call(l);
  }), I = ku();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(ma.Provider, { value: m }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(ha.Provider, { value: E }, I({ ourProps: { ...S, as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment, children: react__WEBPACK_IMPORTED_MODULE_0__.createElement(M4, { ref: a, ...S, ...o, beforeEnter: A, beforeLeave: x }) }, theirProps: {}, defaultTag: react__WEBPACK_IMPORTED_MODULE_0__.Fragment, features: D4, visible: p === "visible", name: "Transition" })));
}
function Bx(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ha) !== null, t = ga() !== null;
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !u && t ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(Nd, { ref: n, ...l }) : react__WEBPACK_IMPORTED_MODULE_0__.createElement(M4, { ref: n, ...l }));
}
let Nd = mu(Mx), M4 = mu(Dx), Ec = mu(Bx), Je = Object.assign(Nd, { Child: Ec, Root: Nd });
var Lx = ((l) => (l[l.Open = 0] = "Open", l[l.Closed = 1] = "Closed", l))(Lx || {}), Gx = ((l) => (l[l.SetTitleId = 0] = "SetTitleId", l))(Gx || {});
let jx = { 0(l, n) {
  return l.titleId === n.id ? l : { ...l, titleId: n.id };
} }, Ac = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
Ac.displayName = "DialogContext";
function ba(l) {
  let n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(Ac);
  if (n === null) {
    let u = new Error(`<${l} /> is missing a parent <Dialog /> component.`);
    throw Error.captureStackTrace && Error.captureStackTrace(u, ba), u;
  }
  return n;
}
function Wx(l, n) {
  return Ke(n.type, jx, l, n);
}
let c2 = mu(function(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), { id: t = `headlessui-dialog-${u}`, open: r, onClose: o, initialFocus: s, role: d = "dialog", autoFocus: a = !0, __demoMode: c = !1, unmount: p = !1, ...g } = l, m = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1);
  d = function() {
    return d === "dialog" || d === "alertdialog" ? d : (m.current || (m.current = !0, console.warn(`Invalid role [${d}] passed to <Dialog />. Only \`dialog\` and and \`alertdialog\` are supported. Using \`dialog\` instead.`)), "dialog");
  }();
  let v = ga();
  r === void 0 && v !== null && (r = (v & le.Open) === le.Open);
  let $ = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), b = pe($, n), E = da($), S = r ? 0 : 1, [A, x] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useReducer)(Wx, { titleId: null, descriptionId: null, panelRef: (0,react__WEBPACK_IMPORTED_MODULE_0__.createRef)() }), I = En(() => o(!1)), P = En((X) => x({ type: 0, id: X })), O = ti() ? S === 0 : !1, [_, j] = vx(), z = { get current() {
    var X;
    return (X = A.panelRef.current) != null ? X : $.current;
  } }, Y = N4(), { resolveContainers: el } = Cx({ mainTreeNode: Y, portals: _, defaultContainers: [z] }), U = v !== null ? (v & le.Closing) === le.Closing : !1;
  Xy(c || U ? !1 : O, { allowed: En(() => {
    var X, dl;
    return [(dl = (X = $.current) == null ? void 0 : X.closest("[data-headlessui-portal]")) != null ? dl : null];
  }), disallowed: En(() => {
    var X;
    return [(X = Y == null ? void 0 : Y.closest("body > *:not(#headlessui-portal-root)")) != null ? X : null];
  }) }), r$(O, el, (X) => {
    X.preventDefault(), I();
  }), $x(O, E == null ? void 0 : E.defaultView, (X) => {
    X.preventDefault(), X.stopPropagation(), document.activeElement && "blur" in document.activeElement && typeof document.activeElement.blur == "function" && document.activeElement.blur(), I();
  }), c$(c || U ? !1 : O, E, el), zy(O, $, I);
  let [ul, il] = By(), rl = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => [{ dialogState: S, close: I, setTitleId: P, unmount: p }, A], [S, A, I, P, p]), tl = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ open: S === 0 }), [S]), sl = { ref: b, id: t, role: d, tabIndex: -1, "aria-modal": c ? void 0 : S === 0 ? !0 : void 0, "aria-labelledby": A.titleId, "aria-describedby": ul, unmount: p }, ll = !xx(), H = $t.None;
  O && !c && (H |= $t.RestoreFocus, H |= $t.TabLock, a && (H |= $t.AutoFocus), ll && (H |= $t.InitialFocus));
  let V = ku();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(ax, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(s2, { force: !0 }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(yx, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(Ac.Provider, { value: rl }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(S4, { target: $ }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(s2, { force: !1 }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(il, { slot: tl }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(j, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(Sx, { initialFocus: s, initialFocusFallback: $, containers: el, features: H }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(ky, { value: I }, V({ ourProps: sl, theirProps: g, slot: tl, defaultTag: Vx, features: kx, visible: S === 0, name: "Dialog" })))))))))));
}), Vx = "div", kx = jo.RenderStrategy | jo.Static;
function Hx(l, n) {
  let { transition: u = !1, open: t, ...r } = l, o = ga(), s = l.hasOwnProperty("open") || o !== null, d = l.hasOwnProperty("onClose");
  if (!s && !d) throw new Error("You have to provide an `open` and an `onClose` prop to the `Dialog` component.");
  if (!s) throw new Error("You provided an `onClose` prop to the `Dialog`, but forgot an `open` prop.");
  if (!d) throw new Error("You provided an `open` prop to the `Dialog`, but forgot an `onClose` prop.");
  if (!o && typeof l.open != "boolean") throw new Error(`You provided an \`open\` prop to the \`Dialog\`, but the value is not a boolean. Received: ${l.open}`);
  if (typeof l.onClose != "function") throw new Error(`You provided an \`onClose\` prop to the \`Dialog\`, but the value is not a function. Received: ${l.onClose}`);
  return (t !== void 0 || u) && !r.static ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(d2, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(Je, { show: t, transition: u, unmount: r.unmount }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(c2, { ref: n, ...r }))) : react__WEBPACK_IMPORTED_MODULE_0__.createElement(d2, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(c2, { ref: n, open: t, ...r }));
}
let Zx = "div";
function Xx(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), { id: t = `headlessui-dialog-panel-${u}`, transition: r = !1, ...o } = l, [{ dialogState: s, unmount: d }, a] = ba("Dialog.Panel"), c = pe(n, a.panelRef), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ open: s === 0 }), [s]), g = En((E) => {
    E.stopPropagation();
  }), m = { ref: c, id: t, onClick: g }, v = r ? Ec : react__WEBPACK_IMPORTED_MODULE_0__.Fragment, $ = r ? { unmount: d } : {}, b = ku();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(v, { ...$ }, b({ ourProps: m, theirProps: o, slot: p, defaultTag: Zx, name: "Dialog.Panel" }));
}
let zx = "div";
function Yx(l, n) {
  let { transition: u = !1, ...t } = l, [{ dialogState: r, unmount: o }] = ba("Dialog.Backdrop"), s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ open: r === 0 }), [r]), d = { ref: n, "aria-hidden": !0 }, a = u ? Ec : react__WEBPACK_IMPORTED_MODULE_0__.Fragment, c = u ? { unmount: o } : {}, p = ku();
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(a, { ...c }, p({ ourProps: d, theirProps: t, slot: s, defaultTag: zx, name: "Dialog.Backdrop" }));
}
let Ux = "h2";
function Jx(l, n) {
  let u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), { id: t = `headlessui-dialog-title-${u}`, ...r } = l, [{ dialogState: o, setTitleId: s }] = ba("Dialog.Title"), d = pe(n);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => (s(t), () => s(null)), [t, s]);
  let a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ open: o === 0 }), [o]), c = { ref: d, id: t };
  return ku()({ ourProps: c, theirProps: r, slot: a, defaultTag: Ux, name: "Dialog.Title" });
}
let Kx = mu(Hx), Qx = mu(Xx), qx = mu(Yx), lC = mu(Jx), Td = Object.assign(Kx, { Panel: Qx, Title: lC, Description: Wy });
function Sc(l) {
  return Vu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z", clipRule: "evenodd" }, child: [] }] })(l);
}
function B4(l) {
  return Vu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z", clipRule: "evenodd" }, child: [] }] })(l);
}
function Pc(l) {
  return Vu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z", clipRule: "evenodd" }, child: [] }] })(l);
}
function nC(l) {
  return Vu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z", clipRule: "evenodd" }, child: [] }] })(l);
}
function L4(l) {
  return Vu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z", clipRule: "evenodd" }, child: [] }] })(l);
}
function G4(l) {
  return Vu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z", clipRule: "evenodd" }, child: [] }] })(l);
}
function j4(l) {
  return Vu({ tag: "svg", attr: { viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, child: [{ tag: "path", attr: { fillRule: "evenodd", d: "M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z", clipRule: "evenodd" }, child: [] }] })(l);
}
const y_ = ({ direction: l = "ltr", isOpen: n, onClose: u, children: t }) => /* @__PURE__ */ y.jsx(Je.Root, { show: n, as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment, children: /* @__PURE__ */ y.jsxs(Td, { as: "div", className: "relative z-40", onClose: u, children: [
  /* @__PURE__ */ y.jsx(
    Je.Child,
    {
      as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
      enter: "transition-opacity ease-linear duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "transition-opacity ease-linear duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      children: /* @__PURE__ */ y.jsx("div", { className: "fixed inset-0 bg-gray-600 bg-opacity-75" })
    }
  ),
  /* @__PURE__ */ y.jsx("div", { className: wl("fixed inset-0 flex z-40", l === "ltr" ? "justify-end" : "justify-start"), children: /* @__PURE__ */ y.jsx(
    Je.Child,
    {
      as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
      enter: "transition ease-in-out duration-300 transform",
      enterFrom: l === "ltr" ? "translate-x-full" : "-translate-x-full",
      enterTo: "translate-x-0",
      leave: "transition ease-in-out duration-300 transform",
      leaveFrom: "translate-x-0",
      leaveTo: l === "ltr" ? "translate-x-full" : "-translate-x-full",
      children: /* @__PURE__ */ y.jsxs(Td.Panel, { className: "relative flex-1 flex flex-col max-w-xs w-full pt-5 pb-4 bg-white", children: [
        /* @__PURE__ */ y.jsx(
          Je.Child,
          {
            as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
            enter: "ease-in-out duration-300",
            enterFrom: "opacity-0",
            enterTo: "opacity-100",
            leave: "ease-in-out duration-300",
            leaveFrom: "opacity-100",
            leaveTo: "opacity-0",
            children: /* @__PURE__ */ y.jsx("div", { className: `absolute pt-2 top-0 ${l === "ltr" ? "-left-12" : "-right-12"}`, children: /* @__PURE__ */ y.jsxs(
              "button",
              {
                type: "button",
                className: "ms-1 flex items-center justify-center h-10 w-10 rounded-full focus:outline-none focus:ring-2 focus:ring-inset focus:ring-white",
                onClick: u,
                children: [
                  /* @__PURE__ */ y.jsx("span", { className: "sr-only", children: "Close sidebar" }),
                  /* @__PURE__ */ y.jsx(j4, { className: "h-6 w-6 text-white", "aria-hidden": "true" })
                ]
              }
            ) })
          }
        ),
        /* @__PURE__ */ y.jsx("div", { className: "mt-5 flex-1 h-full overflow-y-auto", dir: l, children: t })
      ] })
    }
  ) })
] }) });
var uC = "development" === "production";
function Rd(l, n) {
  if (!uC) {
    if (l)
      return;
    var u = "Warning: " + n;
    typeof console < "u" && console.warn(u);
    try {
      throw Error(u);
    } catch {
    }
  }
}
function eC(l, n) {
  for (var u = 0; u < n.length; u++) {
    var t = n[u];
    t.enumerable = t.enumerable || !1, t.configurable = !0, "value" in t && (t.writable = !0), Object.defineProperty(l, t.key, t);
  }
}
function ya(l, n, u) {
  return n && eC(l.prototype, n), l;
}
function Su() {
  return Su = Object.assign || function(l) {
    for (var n = 1; n < arguments.length; n++) {
      var u = arguments[n];
      for (var t in u)
        Object.prototype.hasOwnProperty.call(u, t) && (l[t] = u[t]);
    }
    return l;
  }, Su.apply(this, arguments);
}
function tC(l, n) {
  l.prototype = Object.create(n.prototype), l.prototype.constructor = l, Od(l, n);
}
function Od(l, n) {
  return Od = Object.setPrototypeOf || function(t, r) {
    return t.__proto__ = r, t;
  }, Od(l, n);
}
function rC(l, n) {
  if (l) {
    if (typeof l == "string") return f2(l, n);
    var u = Object.prototype.toString.call(l).slice(8, -1);
    if (u === "Object" && l.constructor && (u = l.constructor.name), u === "Map" || u === "Set") return Array.from(l);
    if (u === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(u)) return f2(l, n);
  }
}
function f2(l, n) {
  (n == null || n > l.length) && (n = l.length);
  for (var u = 0, t = new Array(n); u < n; u++) t[u] = l[u];
  return t;
}
function er(l, n) {
  var u = typeof Symbol < "u" && l[Symbol.iterator] || l["@@iterator"];
  if (u) return (u = u.call(l)).next.bind(u);
  if (Array.isArray(l) || (u = rC(l)) || n) {
    u && (l = u);
    var t = 0;
    return function() {
      return t >= l.length ? {
        done: !0
      } : {
        done: !1,
        value: l[t++]
      };
    };
  }
  throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function p2(l) {
  var n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  function u(t) {
    !t || t === n.current || (n.current = t, l(t));
  }
  return u;
}
function iC(l) {
  var n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(l);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    function u(r) {
      typeof r == "function" ? n.current = r(n.current) : n.current = r;
    }
    function t() {
      return n.current;
    }
    return [t, u];
  }, []);
}
function oC() {
  var l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)([]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    function n() {
      return l.current.length > 0;
    }
    function u() {
      for (var r = er(l.current), o; !(o = r()).done; ) {
        var s = o.value;
        s();
      }
      l.current = [];
    }
    function t(r) {
      l.current.push(r);
    }
    return {
      hasEventSubscriptions: n,
      removeAllEventSubscriptions: u,
      addEventSubscription: t
    };
  }, []);
}
var ed = typeof window < "u" ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_0__.useEffect;
function aC(l, n) {
  var u = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(l);
  return n ? (u.current = l, u) : (u.current = null, u);
}
function Jr(l) {
  return parseFloat(l.replace("px", ""));
}
function Fd(l, n, u) {
  return l < n ? n : l > u ? u : l;
}
function g2(l) {
  return l != null;
}
function h2() {
  for (var l = arguments.length, n = new Array(l), u = 0; u < l; u++)
    n[u] = arguments[u];
  return function(t) {
    for (var r = er(n), o; !(o = r()).done; ) {
      var s = o.value;
      s && (typeof s == "function" ? s(t) : s.current = t);
    }
  };
}
function sC(l, n) {
  if (!(typeof l > "u"))
    return n || l.ResizeObserver;
}
function W4(l, n) {
  var u = [];
  if (!l || !n || l === document.body)
    return u;
  var t = n.getComputedStyle(l), r = t.overflow, o = t.overflowX, s = t.overflowY;
  return [r, o, s].some(function(d) {
    return ["auto", "scroll"].includes(d);
  }) && u.push(l), [].concat(u, W4(l.parentElement, n));
}
function fo(l) {
  return "react-laag: Could not find a valid reference for the " + l + ` element. There might be 2 causes:
   - Make sure that the 'ref' is set correctly on the ` + l + ` element when isOpen: true. Also make sure your component forwards the ref with "forwardRef()".
   - Make sure that you are actually rendering the ` + l + " when the isOpen prop is set to true";
}
function dC(l) {
  var n = l.enabled, u = l.onChange, t = l.environment, r = l.ResizeObserverPolyfill, o = l.overflowContainer, s = l.triggerOption, d = sC(t, r);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
     true && Rd(d, "This browser does not support ResizeObserver out of the box. We recommend to add a polyfill in order to utilize the full capabilities of react-laag. See: https://github.com/everweij/react-laag#resize-observer");
  }, [d]);
  var a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), c = !!s, p = iC({
    scrollContainers: [],
    trigger: null,
    layer: null
  }), g = p[0], m = p[1], v = oC(), $ = v.hasEventSubscriptions, b = v.addEventSubscription, E = v.removeAllEventSubscriptions, S = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    var z = g(), Y = z.layer, el = z.trigger, U = z.scrollContainers, ul = U[0];
    if (!Y)
      throw new Error(fo("layer"));
    if (!el && !c)
      throw new Error(fo("trigger"));
    var il = {
      top: 0,
      left: 0
    };
    if (ul) {
      var rl = ul.scrollLeft, tl = ul.scrollTop;
      il = {
        top: tl,
        left: rl
      };
    } else {
      var sl = t.scrollX, ll = t.scrollY;
      il = {
        top: ll,
        left: sl
      };
    }
    var H = {
      left: 0,
      top: 0
    };
    if (ul) {
      var V = t.getComputedStyle(ul), X = V.borderLeftWidth, dl = V.borderTopWidth;
      H = {
        left: Jr(X) || 0,
        top: Jr(dl) || 0
      };
    }
    u({
      layer: Y,
      trigger: el,
      scrollContainers: U,
      arrow: a.current
    }, il, H);
  }, [g, u, t, a, c]), A = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    var z = g(), Y = z.trigger, el = z.layer, U = z.scrollContainers;
    if (!el)
      throw new Error(fo("layer"));
    if (!Y && !c)
      throw new Error(fo("trigger"));
    if (d) {
      for (var ul = !1, il = function() {
        if (!ul) {
          ul = !0;
          return;
        }
        S();
      }, rl = new d(il), tl = 0, sl = [Y, el, document.body]; tl < sl.length; tl++) {
        var ll = sl[tl];
        ll && rl.observe(ll);
      }
      b(function() {
        for (var fl = 0, $l = [Y, el, document.body]; fl < $l.length; fl++) {
          var cl = $l[fl];
          cl && rl.unobserve(cl);
        }
        rl.disconnect();
      });
    }
    for (var H = [t].concat(U), V = function() {
      var $l = dl.value;
      $l.addEventListener("scroll", S), b(function() {
        return $l.removeEventListener("scroll", S);
      });
    }, X = er(H), dl; !(dl = X()).done; )
      V();
  }, [g, b, S, t, d, c]), x = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(j, z) {
    n && j && j !== z && (E(), A(), S());
  }, [E, A, S, n]), I = p2((0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(j) {
    var z = g(), Y = z.layer;
    m(function(el) {
      return Su({}, el, {
        layer: j
      });
    }), x(Y, j);
  }, [g, m, x])), P = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(z) {
    var Y = W4(z, t), el = Y[0];
    if (el) {
      var U = t.getComputedStyle(el).position, ul = ["relative", "absolute", "fixed"].includes(U) || o;
      ul || (el.style.position = "relative"),  true && Rd(ul, `react-laag: Set the 'position' style of the nearest scroll-container to 'relative', 'absolute' or 'fixed', or set the 'overflowContainer' prop to true. This is needed in order to position the layer properly. Currently the scroll-container is positioned: "` + U + '". For now, "position: relative;" is added for you, but this behavior might be removed in the future. Visit https://react-laag.com/docs/#position-relative for more info.');
    }
    return Y;
  }, [t, o]), O = p2((0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(j) {
    var z = P(j), Y = g(), el = Y.trigger;
    m(function(U) {
      return Su({}, U, {
        trigger: j,
        scrollContainers: z
      });
    }), x(el, j);
  }, [g, m, x, P])), _ = s == null || s.getParent == null ? void 0 : s.getParent();
  return ed(function() {
    _ && m(function(j) {
      return Su({}, j, {
        scrollContainers: P(_)
      });
    });
  }, [_, m, P]), ed(function() {
    return n && ($() || A()), function() {
      $() && E();
    };
  }, [n, $, A, E]), ed(function() {
    n && S();
  }), {
    triggerRef: O,
    layerRef: I,
    arrowRef: a,
    closestScrollContainer: g().scrollContainers[0] || null
  };
}
var V4 = /* @__PURE__ */ (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({});
function cC(l) {
  var n = l.children, u = l.registrations, t = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(o) {
    return u.current.add(o), function() {
      return u.current.delete(o);
    };
  }, [u]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(V4.Provider, {
    value: t
  }, n);
}
function fC(l, n) {
  for (var u = er(l), t; !(t = u()).done; ) {
    var r = t.value.shouldCloseWhenClickedOutside;
    if (!r(n))
      return !1;
  }
  return !0;
}
function pC(l) {
  var n = l.isOpen, u = l.onOutsideClick, t = l.onParentClose, r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), o = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(/* @__PURE__ */ new Set()), d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(V4), a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(p) {
    var g = p.target, m = r.current && r.current.contains(g), v = o.current && o.current.contains(g), $ = fC(s.current, p);
    return v && $ && s.current.forEach(function(b) {
      var E = b.closeChild;
      return E();
    }), !m && !v && $;
  }, [r, o, s]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    if (typeof d == "function")
      return d({
        shouldCloseWhenClickedOutside: a,
        closeChild: function() {
           true && Rd(t, "react-laag: You are using useLayer() in a nested setting but forgot to set the 'onParentClose()' callback in the options. This could lead to unexpected behavior."), t && t();
        }
      });
  }, [d, a, t, s]), (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    var c = typeof d == "function", p = !n || !u || c;
    if (p)
      return;
    function g(m) {
      a(m) && u();
    }
    return document.addEventListener("click", g, !0), function() {
      return document.removeEventListener("click", g, !0);
    };
  }, [n, u, a, d]), (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    n || s.current.forEach(function(c) {
      var p = c.closeChild;
      return p();
    });
  }, [n]), {
    closeOnOutsideClickRefs: {
      trigger: r,
      layer: o
    },
    registrations: s
  };
}
var gC = ["bottom-start", "bottom-end", "bottom-center", "top-start", "top-center", "top-end", "left-end", "left-center", "left-start", "right-end", "right-center", "right-start", "center"], hC = {
  top: "bottom",
  left: "right",
  bottom: "top",
  right: "left",
  center: "center"
}, mC = /* @__PURE__ */ function() {
  function l(u, t, r, o, s, d, a, c, p) {
    this.prop = void 0, this.opposite = void 0, this.isHorizontal = void 0, this.sizeProp = void 0, this.oppositeSizeProp = void 0, this.cssProp = void 0, this.oppositeCssProp = void 0, this.isCenter = void 0, this.isPush = void 0, this.prop = u, this.opposite = t, this.isHorizontal = r, this.sizeProp = o, this.oppositeSizeProp = s, this.cssProp = d, this.oppositeCssProp = a, this.isCenter = c, this.isPush = p;
  }
  var n = l.prototype;
  return n.factor = function(t) {
    return t * (this.isPush ? 1 : -1);
  }, n.isOppositeDirection = function(t) {
    return this.isHorizontal !== t.isHorizontal;
  }, l;
}();
function Jt(l, n) {
  n === void 0 && (n = !0);
  var u = ["left", "right"].includes(l);
  return new mC(l, n ? Jt(hC[l], !1) : null, u, u ? "width" : "height", u ? "height" : "width", u ? "left" : "top", u ? "top" : "left", l === "center", !["right", "bottom"].includes(l));
}
var kn = {
  top: /* @__PURE__ */ Jt("top"),
  bottom: /* @__PURE__ */ Jt("bottom"),
  left: /* @__PURE__ */ Jt("left"),
  right: /* @__PURE__ */ Jt("right")
}, Mn = /* @__PURE__ */ Su({}, kn, {
  center: /* @__PURE__ */ Jt("center")
}), po = ["top", "left", "bottom", "right"], Nc = /* @__PURE__ */ function() {
  function l(n) {
    return this.top = void 0, this.left = void 0, this.right = void 0, this.bottom = void 0, Object.assign(this, n);
  }
  return l.mergeSmallestSides = function(u) {
    var t = u[0], r = u.slice(1);
    if (!t)
      throw new Error("Please provide at least 1 bounds objects in order to merge");
    for (var o = Object.fromEntries(po.map(function(m) {
      return [m, t[m]];
    })), s = er(r), d; !(d = s()).done; )
      for (var a = d.value, c = er(po), p; !(p = c()).done; ) {
        var g = p.value;
        o[g] = Math.min(o[g], a[g]);
      }
    return new l(o);
  }, ya(l, [{
    key: "allSidesArePositive",
    get: function() {
      var u = this;
      return po.every(function(t) {
        return u[t] >= 0;
      });
    }
    /**
     * Returns a partial IBoundsOffsets with sides that are negative, meaning sides aren't entirely
     * visible in respect to a parent Bounds instance
     */
  }, {
    key: "negativeSides",
    get: function() {
      var u = this;
      return Object.fromEntries(po.filter(function(t) {
        return u[t] < 0;
      }).map(function(t) {
        return [t, u[t]];
      }));
    }
  }]), l;
}();
function m2() {
  for (var l = arguments.length, n = new Array(l), u = 0; u < l; u++)
    n[u] = arguments[u];
  return n.reduce(function(t, r) {
    return t + (r ? Jr(r) : 0);
  }, 0);
}
function _d(l) {
  var n = l.top, u = l.left, t = l.right, r = l.bottom, o = l.width, s = l.height;
  return {
    top: n,
    left: u,
    right: t,
    bottom: r,
    width: o,
    height: s
  };
}
var vC = {
  top: 0,
  left: 0,
  right: 0,
  bottom: 0,
  width: 0,
  height: 0
}, Qu = /* @__PURE__ */ function() {
  l.create = function(t) {
    return new l(t);
  }, l.fromElement = function(t, r) {
    r === void 0 && (r = {});
    var o = r, s = o.withTransform, d = s === void 0 ? !0 : s, a = o.environment, c = a === void 0 ? window : a, p = o.withScrollbars, g = p === void 0 ? !0 : p, m = _d(t.getBoundingClientRect()), v = new l(m);
    if (!d) {
      var $ = c.getComputedStyle(t), b = $.width, E = $.height, S = $.boxSizing, A = $.borderLeft, x = $.borderRight, I = $.borderTop, P = $.borderBottom, O = $.paddingLeft, _ = $.paddingRight, j = $.paddingTop, z = $.paddingBottom, Y = S === "border-box" ? Jr(b) : m2(b, A, x, O, _), el = S === "border-box" ? Jr(E) : m2(E, I, P, j, z);
      v = new l(Su({}, v, {
        width: Y,
        height: el
      }));
    }
    if (!g) {
      var U = v.width - t.clientWidth, ul = v.height - t.clientHeight;
      return v.substract({
        right: U,
        bottom: ul
      });
    }
    return v;
  }, l.empty = function() {
    return new l();
  }, l.fromWindow = function(t) {
    var r, o = (r = t == null ? void 0 : t.document.scrollingElement) != null ? r : t == null ? void 0 : t.document.documentElement, s = o ?? {}, d = s.clientWidth, a = d === void 0 ? 0 : d, c = s.clientHeight, p = c === void 0 ? 0 : c;
    return new l({
      width: a,
      height: p,
      right: a,
      bottom: p
    });
  };
  function l(u) {
    return u === void 0 && (u = {}), this.top = void 0, this.left = void 0, this.right = void 0, this.bottom = void 0, this.width = void 0, this.height = void 0, Object.assign(this, vC, u);
  }
  var n = l.prototype;
  return n.toObject = function() {
    return _d(this);
  }, n.merge = function(t) {
    var r = this.toObject();
    return new l(Su({}, r, typeof t == "function" ? t(r) : t));
  }, n.substract = function(t) {
    for (var r = this.toObject(), o = Object.entries(t), s = 0, d = o; s < d.length; s++) {
      var a = d[s], c = a[0], p = a[1];
      if (c in kn) {
        var g = kn[c];
        r[c] += g.factor(p), r[g.isHorizontal ? "width" : "height"] -= p;
      } else
        r[c] -= p || 0;
    }
    return new l(r);
  }, n.offsetsTo = function(t) {
    return new Nc({
      top: t.top - this.top,
      bottom: this.bottom - t.bottom,
      left: t.left - this.left,
      right: this.right - t.right
    });
  }, n.mapSides = function(t) {
    for (var r = this.toObject(), o = Object.values(kn), s = 0, d = o; s < d.length; s++) {
      var a = d[s];
      r[a.prop] = t(a, r[a.prop]);
    }
    return new l(r);
  }, ya(l, [{
    key: "surface",
    get: function() {
      return this.width * this.height;
    }
  }]), l;
}(), k4 = /* @__PURE__ */ function() {
  function l(u, t, r, o, s) {
    this.primary = void 0, this.secondary = void 0, this.offsets = void 0, this.subjectsBounds = void 0, this._cachedLayerBounds = null, this._cachedContainerOffsets = null, this.primary = u, this.secondary = t, this.offsets = s, this.setSubjectsBounds(r, o);
  }
  var n = l.prototype;
  return n.setSubjectsBounds = function(t, r) {
    if (!r) {
      this.subjectsBounds = t;
      return;
    }
    var o = (
      // if the user passed a callback, call it with the layerSide corresponding to
      // the placement
      typeof r == "function" ? r(this.primary.prop) : r
    );
    this.subjectsBounds = t.merge({
      layer: Su({}, t.layer, o)
    });
  }, n.getLayerBounds = function(t) {
    if (t === void 0 && (t = 0), this._cachedLayerBounds && t === 0)
      return this._cachedLayerBounds;
    var r = this.primary, o = this.secondary, s = this.subjectsBounds, d = s.trigger, a = s.layer, c = s.arrow, p = r.isHorizontal, g = r.oppositeCssProp, m = r.oppositeSizeProp, v = r.prop, $ = r.opposite, b = Qu.empty();
    b[$.prop] = d[v] - r.factor(this.offsets.trigger), b[v] = b[$.prop] - r.factor(a[r.sizeProp]);
    var E = this.offsets.arrow * 2, S = d[g] - (a[m] - c[m]) + E, A = d[g] + (d[m] - c[m]) - E;
    if (o.isPush || (S += a[m], A += a[m]), o.isCenter) {
      var x = (p ? kn.top : kn.left).prop, I = (p ? kn.bottom : kn.right).prop;
      b[x] = Fd(d[x] + d[m] / 2 - a[m] / 2 + t, S, A), b[I] = b[x] + a[m];
    } else {
      var P = o, O = d[P.prop], _ = O < S ? S - O : O > A ? A - O : 0;
      b[P.prop] = Fd(O + t + _, S, A), b[P.opposite.prop] = b[P.prop] + o.factor(a[m]);
    }
    b.width = b.right - b.left, b.height = b.bottom - b.top;
    var j = Qu.create(b);
    return t === 0 && (this._cachedLayerBounds = j), j;
  }, n.getLayerCollisionBounds = function() {
    var t = this.offsets.container;
    return this.getLayerBounds().mapSides(function(r, o) {
      return o -= r.factor(t);
    }).merge(function(r) {
      var o = r.width, s = r.height;
      return {
        width: o + t * 2,
        height: s + t * 2
      };
    });
  }, n.getContainerOffsets = function(t) {
    if (this._cachedContainerOffsets && !t)
      return this._cachedContainerOffsets;
    var r = this.subjectsBounds.merge({
      layer: t || this.getLayerCollisionBounds()
    }), o = Nc.mergeSmallestSides(r.layerOffsetsToScrollContainers);
    return t || (this._cachedContainerOffsets = o), o;
  }, ya(l, [{
    key: "type",
    get: function() {
      return this.primary.prop + "-" + (this.secondary.prop === "center" ? "center" : ["bottom", "right"].includes(this.secondary.prop) ? "end" : "start");
    }
  }, {
    key: "triggerIsBigger",
    get: function() {
      var t = this.secondary.isHorizontal, r = this.subjectsBounds, o = r.triggerHasBiggerWidth, s = r.triggerHasBiggerHeight;
      return t && o || !t && s;
    }
    /**
     * Checks whether the placement fits within all it's container (including container-offset)
     */
  }, {
    key: "fitsContainer",
    get: function() {
      return this.getContainerOffsets().allSidesArePositive;
    }
    /**
     * Returns the surface in square pixels of the visible part of the layer
     */
  }, {
    key: "visibleSurface",
    get: function() {
      var t = this.getLayerBounds(), r = this.getContainerOffsets(t), o = r.negativeSides;
      for (var s in o)
        o[s] = -o[s];
      return t.substract(o).surface;
    }
    /**
     * Returns a BoundSide by looking at the most negative offset that is the opposite direction
     */
  }, {
    key: "secondaryOffsetSide",
    get: function() {
      var t, r, o = this, s = this.getContainerOffsets(), d = (t = (r = Object.entries(s.negativeSides).map(function(c) {
        var p = c[0], g = c[1];
        return [kn[p], g];
      }).filter(function(c) {
        var p = c[0];
        return o.primary.isOppositeDirection(p);
      }).sort(function(c, p) {
        var g = c[1], m = p[1];
        return m - g;
      })) == null ? void 0 : r[0]) != null ? t : [], a = d[0];
      return a || null;
    }
  }]), l;
}(), v2 = /* @__PURE__ */ function(l) {
  tC(n, l);
  function n() {
    return l.apply(this, arguments) || this;
  }
  var u = n.prototype;
  return u.getLayerBounds = function() {
    var r = this.subjectsBounds, o = r.trigger, s = r.layer, d = Qu.empty();
    return d.top = o.top + o.height / 2 - s.height / 2, d.bottom = d.top + s.height, d.left = o.left + o.width / 2 - s.width / 2, d.right = d.left + s.width, d.width = d.right - d.left, d.height = d.bottom - d.top, d;
  }, n;
}(k4);
function bC(l, n, u) {
  var t = l.layer, r = l.trigger, o = l.arrow, s = n.primary.oppositeSizeProp, d = n.primary.isHorizontal ? ["top", "bottom"] : ["left", "right"], a = d[0], c = d[1], p = t[a] + t[s] / 2 - r[a] - o[s] / 2 - u, g = t[c] - t[s] / 2 - r[c] + o[s] / 2 + u;
  return (p < 0 ? -p : 0) + (g > 0 ? -g : 0);
}
var b2 = {
  position: "absolute",
  willChange: "top, left",
  left: null,
  right: null,
  top: null,
  bottom: null
};
function yC(l, n, u) {
  var t;
  if (n.primary.isCenter)
    return b2;
  var r = l.layer, o = l.trigger, s = l.arrow, d = n.primary.oppositeSizeProp, a = o[d] > r[d], c = u + s[d] / 2, p = r[d] - s[d] / 2 - u, g = bC(l, n, u), m = n.primary.prop, v = n.primary.oppositeCssProp, $ = a ? r[d] / 2 + g : o[v] + o[d] / 2 - r[v];
  return Su({}, b2, (t = {}, t[m] = "100%", t[v] = Fd($, c, p), t));
}
var y2 = /* @__PURE__ */ function() {
  function l(u, t, r) {
    this.placements = void 0, this.config = void 0, this.subjectsBounds = void 0, this.placements = u, this.config = t, this.subjectsBounds = r;
  }
  l.getSidesFromPlacementType = function(t) {
    var r = t.split("-"), o = r[0], s = r[1], d = kn[o], a;
    return s === "center" ? a = Mn.center : d.isHorizontal ? a = s === "start" ? Mn.top : Mn.bottom : a = s === "start" ? Mn.left : Mn.right, [d, a];
  }, l.create = function(t, r) {
    var o = {
      arrow: r.arrowOffset,
      container: r.containerOffset,
      trigger: r.triggerOffset
    };
    function s(d) {
      d === void 0 && (d = r.placement);
      var a = l.getSidesFromPlacementType(d), c = a[0], p = a[1], g = kn[c.isHorizontal ? r.preferY : r.preferX], m = !c.isHorizontal && t.triggerHasBiggerWidth || c.isHorizontal && t.triggerHasBiggerHeight;
      function v(b, E) {
        return new k4(b, E, t, r.layerDimensions, o);
      }
      var $ = [];
      return $[0] = v(c, p), $[1] = v(c, p.isCenter ? g : Mn.center), $[2] = v(c, Mn[(p.opposite.isCenter ? g.opposite : p.opposite).prop]), $[3] = v(g, m ? c : Mn[c.opposite.prop]), $[4] = v(g, Mn.center), $[5] = v(g, m ? Mn[c.opposite.prop] : c), $[6] = v(kn[g.opposite.prop], m ? c : Mn[c.opposite.prop]), $[7] = v(kn[g.opposite.prop], Mn.center), $[8] = v(kn[g.opposite.prop], m ? Mn[c.opposite.prop] : c), $[9] = v(kn[c.opposite.prop], p), $[10] = v(kn[c.opposite.prop], p.isCenter ? g : Mn.center), $[11] = v(kn[c.opposite.prop], Mn[(p.opposite.isCenter ? g.opposite : p.opposite).prop]), $ = $.filter(function(b) {
        return b.type === r.placement || r.possiblePlacements.includes(b.type);
      }), $;
    }
    return r.placement === "center" ? new l([new v2(Mn.center, Mn.center, t, r.layerDimensions, o)].concat(s(r.preferY + "-" + r.preferX)), r, t) : new l(s(), r, t);
  };
  var n = l.prototype;
  return n.filterPlacementsBySide = function(t) {
    return this.placements.filter(function(r) {
      return r.primary === t;
    });
  }, n.findFirstPlacementThatFits = function() {
    return this.placements.find(function(t) {
      return t.fitsContainer;
    });
  }, n.placementWithBiggestVisibleSurface = function() {
    var t = this.placements.map(function(o) {
      return {
        placement: o,
        surface: o.visibleSurface
      };
    }).sort(function(o, s) {
      return s.surface - o.surface;
    }), r = t[0].placement;
    return r;
  }, n.findSuitablePlacement = function() {
    return this.config.auto ? this.findFirstPlacementThatFits() || this.placementWithBiggestVisibleSurface() : this.placements[0];
  }, n.getSecondaryOffset = function(t) {
    var r = this.config, o = r.auto, s = r.snap;
    if (!o || s || t instanceof v2)
      return 0;
    var d = this.filterPlacementsBySide(t.primary), a = d.indexOf(t) === 0;
    if (a && t.fitsContainer)
      return 0;
    var c = d.find(function(b) {
      return !b.fitsContainer;
    });
    if (!c)
      return 0;
    var p = c.secondaryOffsetSide;
    if (!p)
      return 0;
    var g = t.getContainerOffsets(), m = t.secondary, v;
    t.triggerIsBigger || c === t ? v = p.isPush ? -1 : 1 : v = m === Mn.left || [Mn.top, Mn.center].includes(m) && p.isPush ? -1 : 1;
    var $ = g[p.prop];
    return $ * v;
  }, n.getStyles = function(t, r, o, s) {
    var d = {
      willChange: "top, left, width, height"
    }, a = yC(this.subjectsBounds.merge({
      layer: t
    }), r, this.config.arrowOffset), c = this.config.overflowContainer ? Su({}, d, {
      position: "fixed",
      top: t.top,
      left: t.left
    }) : Su({}, d, {
      position: "absolute",
      top: t.top - this.subjectsBounds.parent.top + o.top - s.top,
      left: t.left - this.subjectsBounds.parent.left + o.left - s.left
    });
    return {
      arrow: a,
      layer: c
    };
  }, n.getHasDisappeared = function(t) {
    var r = this.config.overflowContainer ? this.subjectsBounds.trigger : t, o = Nc.mergeSmallestSides(this.subjectsBounds.offsetsToScrollContainers(r, !0)), s = Object.entries(o.negativeSides), d = s.some(function(a) {
      var c = a[0], p = a[1], g = kn[c];
      return p <= -r[g.sizeProp];
    });
    return d ? "full" : o.allSidesArePositive ? null : "partial";
  }, n.result = function(t, r) {
    var o = this.findSuitablePlacement(), s = this.getSecondaryOffset(o), d = o.getLayerBounds(s), a = this.getStyles(d, o, t, r), c = o.primary.prop;
    return {
      styles: a,
      layerSide: c,
      placement: o,
      layerBounds: d,
      hasDisappeared: this.getHasDisappeared(d)
    };
  }, l;
}(), $C = /* @__PURE__ */ function() {
  function l(u, t) {
    this.overflowContainer = void 0, this.trigger = void 0, this.layer = void 0, this.arrow = void 0, this.parent = void 0, this.window = void 0, this.scrollContainers = void 0, this.overflowContainer = t, Object.assign(this, u);
  }
  l.create = function(t, r, o, s, d, a, c, p) {
    var g = Qu.fromWindow(t);
    return new l({
      layer: Qu.fromElement(r, {
        environment: t,
        withTransform: !1
      }),
      trigger: p ? Qu.create(_d(p())) : Qu.fromElement(o),
      arrow: d ? Qu.fromElement(d) : Qu.empty(),
      parent: s ? Qu.fromElement(s) : g,
      window: g,
      scrollContainers: [g].concat(a.map(function(m) {
        return Qu.fromElement(m, {
          withScrollbars: !1
        });
      }))
    }, c);
  };
  var n = l.prototype;
  return n.merge = function(t) {
    return new l(Su({}, this, t), this.overflowContainer);
  }, n.offsetsToScrollContainers = function(t, r) {
    r === void 0 && (r = !1);
    var o = this.overflowContainer && !r ? [this.window] : this.scrollContainers;
    return o.map(function(s) {
      return s.offsetsTo(t);
    });
  }, ya(l, [{
    key: "layerOffsetsToScrollContainers",
    get: function() {
      return this.offsetsToScrollContainers(this.layer);
    }
  }, {
    key: "triggerHasBiggerWidth",
    get: function() {
      return this.trigger.width > this.layer.width;
    }
  }, {
    key: "triggerHasBiggerHeight",
    get: function() {
      return this.trigger.height > this.layer.height;
    }
  }]), l;
}(), $2 = null, Ju = {
  auto: !1,
  arrowOffset: 0,
  containerOffset: 10,
  triggerOffset: 0,
  overflowContainer: !0,
  placement: "top-center",
  possiblePlacements: gC,
  preferX: "right",
  preferY: "bottom",
  snap: !1,
  container: void 0,
  trigger: void 0
};
function xC(l) {
  var n, u = l.isOpen, t = u === void 0 ? !1 : u, r = l.overflowContainer, o = r === void 0 ? Ju.overflowContainer : r, s = l.environment, d = s === void 0 ? typeof window < "u" ? window : void 0 : s, a = l.ResizeObserver, c = l.placement, p = c === void 0 ? Ju.placement : c, g = l.possiblePlacements, m = g === void 0 ? Ju.possiblePlacements : g, v = l.preferX, $ = v === void 0 ? Ju.preferX : v, b = l.preferY, E = b === void 0 ? Ju.preferY : b, S = l.auto, A = S === void 0 ? Ju.auto : S, x = l.snap, I = x === void 0 ? Ju.snap : x, P = l.triggerOffset, O = P === void 0 ? Ju.triggerOffset : P, _ = l.containerOffset, j = _ === void 0 ? Ju.containerOffset : _, z = l.arrowOffset, Y = z === void 0 ? Ju.arrowOffset : z, el = l.container, U = el === void 0 ? Ju.container : el, ul = l.layerDimensions, il = ul === void 0 ? null : ul, rl = l.onDisappear, tl = l.onOutsideClick, sl = l.onParentClose, ll = l.trigger, H = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(function() {
    return {
      layerSide: p === "center" ? "center" : y2.getSidesFromPlacementType(p)[0].prop,
      styles: {
        layer: {
          position: o ? "fixed" : "absolute",
          top: 0,
          left: 0
        },
        arrow: {
          position: "absolute",
          top: 0,
          left: 0
        }
      }
    };
  }), V = H[0], X = H[1], dl = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), fl = aC(V, t), $l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({
    cancelled: !1
  });
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    return function() {
      $l.current.cancelled = !0;
    };
  }, []);
  var cl = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(fn, dn, Fn) {
    var sn = fn.arrow, gn = fn.layer, _n = fn.scrollContainers, Zn = fn.trigger, ue = _n[0], _e = $C.create(d, gn, Zn, ue, sn, _n, o, ll == null ? void 0 : ll.getBounds), Tu = {
      placement: p,
      possiblePlacements: m,
      auto: A,
      layerDimensions: il,
      arrowOffset: Y,
      containerOffset: j,
      triggerOffset: O,
      preferX: $,
      preferY: E,
      snap: I,
      overflowContainer: o
    }, ee = y2.create(_e, Tu).result(dn, Fn), Qn = ee.hasDisappeared, vu = ee.layerSide, R = ee.styles, G = {
      layerSide: vu,
      styles: R
    };
    if (!fl.current || CC(fl.current, G)) {
      fl.current = G, $l.current.cancelled = !0;
      var W = {
        cancelled: !1
      };
      $l.current = W, Promise.resolve().then(function() {
        W.cancelled || X(G);
      });
    }
    g2(Qn) && g2(rl) && rl(Qn);
  }, [Y, A, j, d, il, rl, o, p, m, $, E, I, O, fl, ll]), xl = dC({
    ResizeObserverPolyfill: a,
    environment: d,
    enabled: t,
    overflowContainer: o,
    onChange: cl,
    triggerOption: ll
  }), ol = xl.triggerRef, ml = xl.layerRef, Sl = xl.arrowRef, Ol = xl.closestScrollContainer, Cl = pC({
    isOpen: t,
    onOutsideClick: tl,
    onParentClose: sl
  }), Q = Cl.closeOnOutsideClickRefs, Xl = Cl.registrations, Bl = {
    triggerProps: ll ? {} : {
      ref: h2(ol, Q.trigger, dl)
    },
    layerProps: {
      ref: h2(ml, Q.layer),
      style: V.styles.layer
    },
    arrowProps: {
      ref: Sl,
      style: V.styles.arrow,
      layerSide: V.layerSide
    },
    layerSide: V.layerSide,
    triggerBounds: t ? ll ? ll.getBounds() : (n = dl.current) == null ? void 0 : n.getBoundingClientRect() : null,
    renderLayer: function(fn) {
      return typeof document < "u" ? (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(cC, {
        registrations: Xl,
        children: fn
      }), o || !Ol ? wC(U) : Ol) : null;
    }
  };
  return Bl;
}
function CC(l, n) {
  if (l.layerSide !== n.layerSide)
    return !0;
  for (var u = ["position", "top", "left", "right", "bottom"], t = 0, r = u; t < r.length; t++) {
    var o = r[t];
    if (l.styles.layer[o] !== n.styles.layer[o] || l.styles.arrow[o] !== n.styles.arrow[o])
      return !0;
  }
  return !1;
}
var x2 = "layers";
function wC(l) {
  var n;
  if (typeof l == "function") {
    if (n = l(), !n || !(n instanceof HTMLElement))
      throw new Error("react-laag: You've passed a function to the 'container' prop, but it returned no valid HTMLElement");
  } else if (l instanceof HTMLElement)
    n = l;
  else if (typeof l == "string") {
    if (n = document.getElementById(l), !n)
      throw new Error("react-laag: You've passed element with id '" + l + "' to the 'container' prop, but it returned no valid HTMLElement");
  } else {
    if ($2 instanceof HTMLElement)
      return $2;
    n = document.getElementById(x2), n || (n = document.createElement("div"), n.id = x2, n.style.cssText = `
        position: absolute;
        top: 0px;
        left: 0px;
        right: 0px;
      `, document.body.appendChild(n));
  }
  return n;
}
var C2;
(function(l) {
  l[l.ENTERING = 0] = "ENTERING", l[l.LEAVING = 1] = "LEAVING", l[l.IDLE = 2] = "IDLE";
})(C2 || (C2 = {}));
const H4 = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(void 0), Tc = ({
  initialOpen: l = !1,
  isOpen: n,
  setIsOpen: u,
  className: t,
  placement: r = "bottom-end",
  children: o
}) => {
  const [s, d] = react__WEBPACK_IMPORTED_MODULE_0__.useState(l), a = n ?? s, c = u ?? d, p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => c(!1), [c]), { renderLayer: g, triggerProps: m, layerProps: v } = xC({
    isOpen: a,
    onOutsideClick: p,
    // close the menu when the user clicks outside
    onDisappear: p,
    // close the menu when the menu gets scrolled out of sight
    overflowContainer: !0,
    // keep the menu positioned inside the container
    auto: !0,
    // automatically find the best placement
    placement: r,
    // we prefer to place the menu "top-end"
    triggerOffset: 8,
    // keep some distance to the trigger
    containerOffset: 16,
    // give the menu some room to breath relative to the container
    arrowOffset: 16
    // let the arrow have some room to breath also
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (n && !u)
      throw new Error("Must provide setIsOpen prop when using isOpen prop");
  }, []), /* @__PURE__ */ y.jsx(
    H4.Provider,
    {
      value: {
        isOpen: a,
        setIsOpen: c,
        renderLayer: g,
        triggerProps: m,
        layerProps: v
      },
      children: /* @__PURE__ */ y.jsx("div", { className: Kn("relative inline-block", t), children: o })
    }
  );
}, Rc = () => {
  const l = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(H4);
  if (l === void 0)
    throw new Error("Must be used in a Dropdown component");
  return l;
}, IC = ({ children: l, className: n }) => {
  const { isOpen: u, setIsOpen: t, triggerProps: r } = Rc();
  return /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsx(
    "div",
    {
      role: "button",
      ...r,
      className: n,
      onClick: () => {
        t(!u);
      },
      children: l
    }
  ) });
}, EC = ({ className: l, children: n }) => {
  const { isOpen: u, renderLayer: t, layerProps: r } = Rc();
  return /* @__PURE__ */ y.jsx(y.Fragment, { children: t(
    u && /* @__PURE__ */ y.jsx("div", { ...r, className: Kn("relative z-20 rounded border bg-white shadow-lg", l), children: n })
  ) });
}, AC = ({ children: l, className: n }) => {
  const { setIsOpen: u } = Rc();
  return /* @__PURE__ */ y.jsx(
    "div",
    {
      className: Kn(
        "flex w-full items-center px-4 py-2 text-left text-sm leading-5 text-gray-800 transition duration-150 ease-in-out first:rounded-t last:rounded-b hover:bg-gray-100 focus:outline-none",
        n
      ),
      onClick: () => u(!1),
      children: l
    }
  );
};
Tc.Trigger = IC;
Tc.Content = EC;
Tc.Item = AC;
const $_ = (l) => /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsxs("fieldset", { className: "space-y-5", children: [
  /* @__PURE__ */ y.jsx("legend", { className: "sr-only", children: "List" }),
  l.inputs.map((n) => /* @__PURE__ */ y.jsxs("div", { className: "relative flex items-start", children: [
    /* @__PURE__ */ y.jsx("div", { className: "flex items-center h-5", children: /* @__PURE__ */ y.jsx(
      "input",
      {
        ...(({ label: u, description: t, ...r }) => r)(n),
        onChange: l.onChange,
        id: n.id,
        type: "checkbox",
        className: "focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded"
      }
    ) }),
    /* @__PURE__ */ y.jsxs("div", { className: "ml-3 text-sm", children: [
      /* @__PURE__ */ y.jsx("label", { htmlFor: n.id, className: "font-medium text-gray-700", children: n.label }),
      /* @__PURE__ */ y.jsx("p", { id: `${n.id}-description`, className: "text-gray-500", children: n.description })
    ] })
  ] }, n.id))
] }) }), x_ = (l) => /* @__PURE__ */ y.jsxs(
  "svg",
  {
    className: l.className,
    xmlns: "http://www.w3.org/2000/svg",
    width: l.width || "48",
    height: l.height || "48",
    viewBox: "0 0 48 48",
    children: [
      /* @__PURE__ */ y.jsx(
        "path",
        {
          fill: "#FFC107",
          d: "M43.611,20.083H42V20H24v8h11.303c-1.649,4.657-6.08,8-11.303,8c-6.627,0-12-5.373-12-12c0-6.627,5.373-12,12-12c3.059,0,5.842,1.154,7.961,3.039l5.657-5.657C34.046,6.053,29.268,4,24,4C12.955,4,4,12.955,4,24c0,11.045,8.955,20,20,20c11.045,0,20-8.955,20-20C44,22.659,43.862,21.35,43.611,20.083z"
        }
      ),
      /* @__PURE__ */ y.jsx(
        "path",
        {
          fill: "#FF3D00",
          d: "M6.306,14.691l6.571,4.819C14.655,15.108,18.961,12,24,12c3.059,0,5.842,1.154,7.961,3.039l5.657-5.657C34.046,6.053,29.268,4,24,4C16.318,4,9.656,8.337,6.306,14.691z"
        }
      ),
      /* @__PURE__ */ y.jsx(
        "path",
        {
          fill: "#4CAF50",
          d: "M24,44c5.166,0,9.86-1.977,13.409-5.192l-6.19-5.238C29.211,35.091,26.715,36,24,36c-5.202,0-9.619-3.317-11.283-7.946l-6.522,5.025C9.505,39.556,16.227,44,24,44z"
        }
      ),
      /* @__PURE__ */ y.jsx(
        "path",
        {
          fill: "#1976D2",
          d: "M43.611,20.083H42V20H24v8h11.303c-0.792,2.237-2.231,4.166-4.087,5.571c0.001-0.001,0.002-0.001,0.003-0.002l6.19,5.238C36.971,39.205,44,34,44,24C44,22.659,43.862,21.35,43.611,20.083z"
        }
      )
    ]
  }
), wt = ({ children: l, showXButton: n = !0, className: u, isOpen: t, onClose: r, backdropClassName: o }) => /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsx(Je, { appear: !0, show: t, as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment, children: /* @__PURE__ */ y.jsx(Td, { as: "div", className: "fixed inset-0 z-10 overflow-auto", onClose: r, children: /* @__PURE__ */ y.jsxs("div", { className: "min-h-screen p-4 text-center flex justify-center", children: [
  /* @__PURE__ */ y.jsx(
    Je.Child,
    {
      as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
      enter: "ease-out duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "ease-in duration-200",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      children: /* @__PURE__ */ y.jsx(
        qx,
        {
          onClick: r,
          className: wl(
            "fixed inset-0 bg-black bg-opacity-75 transition-opacity backdrop-blur-sm",
            o
          )
        }
      )
    }
  ),
  /* @__PURE__ */ y.jsx(
    Je.Child,
    {
      as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
      enter: "ease-out duration-300",
      enterFrom: "opacity-0 scale-95",
      enterTo: "opacity-100 scale-100",
      leave: "ease-in duration-200",
      leaveFrom: "opacity-100 scale-100",
      leaveTo: "opacity-0 scale-95",
      children: /* @__PURE__ */ y.jsxs(
        "div",
        {
          className: wl(
            "relative inline-block text-left w-full rounded transition-all transform bg-white shadow-xl self-center",
            u
          ),
          children: [
            l,
            n && /* @__PURE__ */ y.jsx(
              "button",
              {
                type: "button",
                onClick: r,
                className: "absolute right-2 top-2 rounded-primary p-1.5 transition-colors duration-150 text-sm text-gray-500 hover:text-gray-700 outline-none focus:outline-none",
                children: "✕"
              }
            )
          ]
        }
      )
    }
  )
] }) }) }) }), SC = ({ children: l, className: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("p-4 font-semibold", n), ...u, children: l }), PC = ({ children: l, className: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("p-4", n), ...u, children: l }), NC = ({ children: l, className: n, ...u }) => /* @__PURE__ */ y.jsx("div", { className: wl("p-4", n), ...u, children: l });
wt.Title = SC;
wt.Content = PC;
wt.Footer = NC;
const TC = (l) => /* @__PURE__ */ y.jsxs(
  "svg",
  {
    width: l.width || "15",
    height: l.height || "15",
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: [
      /* @__PURE__ */ y.jsx(
        "path",
        {
          d: "M6.40024 2.40909L1.13653 11.1964C1.02801 11.3844 0.970583 11.5975 0.969976 11.8145C0.969368 12.0315 1.0256 12.2449 1.13307 12.4334C1.24054 12.622 1.39551 12.7791 1.58255 12.8892C1.7696 12.9992 1.9822 13.0584 2.19922 13.0608H12.7266C12.9436 13.0584 13.1562 12.9992 13.3433 12.8892C13.5303 12.7791 13.6853 12.622 13.7928 12.4334C13.9002 12.2449 13.9565 12.0315 13.9559 11.8145C13.9553 11.5975 13.8978 11.3844 13.7893 11.1964L8.52561 2.40909C8.41482 2.22645 8.25883 2.07544 8.07269 1.97065C7.88655 1.86585 7.67654 1.81079 7.46292 1.81079C7.24931 1.81079 7.0393 1.86585 6.85315 1.97065C6.66701 2.07544 6.51102 2.22645 6.40024 2.40909V2.40909Z",
          stroke: "#E64B5F",
          strokeWidth: "1.7",
          strokeLinecap: "round",
          strokeLinejoin: "round"
        }
      ),
      /* @__PURE__ */ y.jsx("path", { d: "M7.5 5.625V8.125", stroke: "#E64B5F", strokeWidth: "1.7", strokeLinecap: "round", strokeLinejoin: "round" }),
      /* @__PURE__ */ y.jsx("path", { d: "M7.5 10.625H7.50625", stroke: "#E64B5F", strokeWidth: "1.7", strokeLinecap: "round", strokeLinejoin: "round" })
    ]
  }
);
var RC = Object.prototype;
function OC(l) {
  var n = l && l.constructor, u = typeof n == "function" && n.prototype || RC;
  return l === u;
}
var Z4 = OC;
function FC(l, n) {
  return function(u) {
    return l(n(u));
  };
}
var _C = FC, DC = _C, MC = DC(Object.keys, Object), BC = MC, LC = Z4, GC = BC, jC = Object.prototype, WC = jC.hasOwnProperty;
function VC(l) {
  if (!LC(l))
    return GC(l);
  var n = [];
  for (var u in Object(l))
    WC.call(l, u) && u != "constructor" && n.push(u);
  return n;
}
var kC = VC, HC = typeof Jn == "object" && Jn && Jn.Object === Object && Jn, X4 = HC, ZC = X4, XC = typeof self == "object" && self && self.Object === Object && self, zC = ZC || XC || Function("return this")(), ut = zC, YC = ut, UC = YC.Symbol, z4 = UC, w2 = z4, Y4 = Object.prototype, JC = Y4.hasOwnProperty, KC = Y4.toString, jr = w2 ? w2.toStringTag : void 0;
function QC(l) {
  var n = JC.call(l, jr), u = l[jr];
  try {
    l[jr] = void 0;
    var t = !0;
  } catch {
  }
  var r = KC.call(l);
  return t && (n ? l[jr] = u : delete l[jr]), r;
}
var qC = QC, lw = Object.prototype, nw = lw.toString;
function uw(l) {
  return nw.call(l);
}
var ew = uw, I2 = z4, tw = qC, rw = ew, iw = "[object Null]", ow = "[object Undefined]", E2 = I2 ? I2.toStringTag : void 0;
function aw(l) {
  return l == null ? l === void 0 ? ow : iw : E2 && E2 in Object(l) ? tw(l) : rw(l);
}
var $a = aw;
function sw(l) {
  var n = typeof l;
  return l != null && (n == "object" || n == "function");
}
var U4 = sw, dw = $a, cw = U4, fw = "[object AsyncFunction]", pw = "[object Function]", gw = "[object GeneratorFunction]", hw = "[object Proxy]";
function mw(l) {
  if (!cw(l))
    return !1;
  var n = dw(l);
  return n == pw || n == gw || n == fw || n == hw;
}
var J4 = mw, vw = ut, bw = vw["__core-js_shared__"], yw = bw, td = yw, A2 = function() {
  var l = /[^.]+$/.exec(td && td.keys && td.keys.IE_PROTO || "");
  return l ? "Symbol(src)_1." + l : "";
}();
function $w(l) {
  return !!A2 && A2 in l;
}
var xw = $w, Cw = Function.prototype, ww = Cw.toString;
function Iw(l) {
  if (l != null) {
    try {
      return ww.call(l);
    } catch {
    }
    try {
      return l + "";
    } catch {
    }
  }
  return "";
}
var K4 = Iw, Ew = J4, Aw = xw, Sw = U4, Pw = K4, Nw = /[\\^$.*+?()[\]{}|]/g, Tw = /^\[object .+?Constructor\]$/, Rw = Function.prototype, Ow = Object.prototype, Fw = Rw.toString, _w = Ow.hasOwnProperty, Dw = RegExp(
  "^" + Fw.call(_w).replace(Nw, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
);
function Mw(l) {
  if (!Sw(l) || Aw(l))
    return !1;
  var n = Ew(l) ? Dw : Tw;
  return n.test(Pw(l));
}
var Bw = Mw;
function Lw(l, n) {
  return l == null ? void 0 : l[n];
}
var Gw = Lw, jw = Bw, Ww = Gw;
function Vw(l, n) {
  var u = Ww(l, n);
  return jw(u) ? u : void 0;
}
var ri = Vw, kw = ri, Hw = ut, Zw = kw(Hw, "DataView"), Xw = Zw, zw = ri, Yw = ut, Uw = zw(Yw, "Map"), Jw = Uw, Kw = ri, Qw = ut, qw = Kw(Qw, "Promise"), lI = qw, nI = ri, uI = ut, eI = nI(uI, "Set"), tI = eI, rI = ri, iI = ut, oI = rI(iI, "WeakMap"), aI = oI, Dd = Xw, Md = Jw, Bd = lI, Ld = tI, Gd = aI, Q4 = $a, pr = K4, S2 = "[object Map]", sI = "[object Object]", P2 = "[object Promise]", N2 = "[object Set]", T2 = "[object WeakMap]", R2 = "[object DataView]", dI = pr(Dd), cI = pr(Md), fI = pr(Bd), pI = pr(Ld), gI = pr(Gd), yt = Q4;
(Dd && yt(new Dd(new ArrayBuffer(1))) != R2 || Md && yt(new Md()) != S2 || Bd && yt(Bd.resolve()) != P2 || Ld && yt(new Ld()) != N2 || Gd && yt(new Gd()) != T2) && (yt = function(l) {
  var n = Q4(l), u = n == sI ? l.constructor : void 0, t = u ? pr(u) : "";
  if (t)
    switch (t) {
      case dI:
        return R2;
      case cI:
        return S2;
      case fI:
        return P2;
      case pI:
        return N2;
      case gI:
        return T2;
    }
  return n;
});
var hI = yt;
function mI(l) {
  return l != null && typeof l == "object";
}
var Oc = mI, vI = $a, bI = Oc, yI = "[object Arguments]";
function $I(l) {
  return bI(l) && vI(l) == yI;
}
var xI = $I, O2 = xI, CI = Oc, q4 = Object.prototype, wI = q4.hasOwnProperty, II = q4.propertyIsEnumerable, EI = O2(/* @__PURE__ */ function() {
  return arguments;
}()) ? O2 : function(l) {
  return CI(l) && wI.call(l, "callee") && !II.call(l, "callee");
}, AI = EI, SI = Array.isArray, PI = SI, NI = 9007199254740991;
function TI(l) {
  return typeof l == "number" && l > -1 && l % 1 == 0 && l <= NI;
}
var lp = TI, RI = J4, OI = lp;
function FI(l) {
  return l != null && OI(l.length) && !RI(l);
}
var _I = FI, zo = { exports: {} };
function DI() {
  return !1;
}
var MI = DI;
zo.exports;
(function(l, n) {
  var u = ut, t = MI, r = n && !n.nodeType && n, o = r && !0 && l && !l.nodeType && l, s = o && o.exports === r, d = s ? u.Buffer : void 0, a = d ? d.isBuffer : void 0, c = a || t;
  l.exports = c;
})(zo, zo.exports);
var BI = zo.exports, LI = $a, GI = lp, jI = Oc, WI = "[object Arguments]", VI = "[object Array]", kI = "[object Boolean]", HI = "[object Date]", ZI = "[object Error]", XI = "[object Function]", zI = "[object Map]", YI = "[object Number]", UI = "[object Object]", JI = "[object RegExp]", KI = "[object Set]", QI = "[object String]", qI = "[object WeakMap]", lE = "[object ArrayBuffer]", nE = "[object DataView]", uE = "[object Float32Array]", eE = "[object Float64Array]", tE = "[object Int8Array]", rE = "[object Int16Array]", iE = "[object Int32Array]", oE = "[object Uint8Array]", aE = "[object Uint8ClampedArray]", sE = "[object Uint16Array]", dE = "[object Uint32Array]", bn = {};
bn[uE] = bn[eE] = bn[tE] = bn[rE] = bn[iE] = bn[oE] = bn[aE] = bn[sE] = bn[dE] = !0;
bn[WI] = bn[VI] = bn[lE] = bn[kI] = bn[nE] = bn[HI] = bn[ZI] = bn[XI] = bn[zI] = bn[YI] = bn[UI] = bn[JI] = bn[KI] = bn[QI] = bn[qI] = !1;
function cE(l) {
  return jI(l) && GI(l.length) && !!bn[LI(l)];
}
var fE = cE;
function pE(l) {
  return function(n) {
    return l(n);
  };
}
var gE = pE, Yo = { exports: {} };
Yo.exports;
(function(l, n) {
  var u = X4, t = n && !n.nodeType && n, r = t && !0 && l && !l.nodeType && l, o = r && r.exports === t, s = o && u.process, d = function() {
    try {
      var a = r && r.require && r.require("util").types;
      return a || s && s.binding && s.binding("util");
    } catch {
    }
  }();
  l.exports = d;
})(Yo, Yo.exports);
var hE = Yo.exports, mE = fE, vE = gE, F2 = hE, _2 = F2 && F2.isTypedArray, bE = _2 ? vE(_2) : mE, yE = bE, $E = kC, xE = hI, CE = AI, wE = PI, IE = _I, EE = BI, AE = Z4, SE = yE, PE = "[object Map]", NE = "[object Set]", TE = Object.prototype, RE = TE.hasOwnProperty;
function OE(l) {
  if (l == null)
    return !0;
  if (IE(l) && (wE(l) || typeof l == "string" || typeof l.splice == "function" || EE(l) || SE(l) || CE(l)))
    return !l.length;
  var n = xE(l);
  if (n == PE || n == NE)
    return !l.size;
  if (AE(l))
    return !$E(l).length;
  for (var u in l)
    if (RE.call(l, u))
      return !1;
  return !0;
}
var FE = OE;
const _E = /* @__PURE__ */ oa(FE), Nu = ({ value: l, className: n, ...u }) => _E(l) ? null : /* @__PURE__ */ y.jsxs("p", { className: wl("mt-1.5 flex items-center space-x-1.5", n), ...u, children: [
  /* @__PURE__ */ y.jsx(TC, {}),
  " ",
  /* @__PURE__ */ y.jsx("span", { className: "text-xs text-danger-500", children: Array.isArray(l) ? l.join(", ") : l })
] }), C_ = ({
  id: l,
  className: n,
  label: u,
  errors: t,
  placeholder: r,
  value: o,
  setValue: s,
  helpText: d
}) => {
  const [a, c] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(""), p = (A) => {
    const x = [...o, A].filter(function(I, P, O) {
      return P === O.indexOf(I);
    });
    s(x);
  }, g = (A) => {
    c(A.target.value);
  }, m = (A) => {
    if (A.key == "Backspace" && a == "") {
      const x = [...o];
      s(
        x.filter((I, P) => {
        })
      ), A.preventDefault();
      return;
    }
    if (a && (A.key == "Enter" || A.key == "Tab")) {
      p(a), c(""), A.preventDefault();
      return;
    }
  }, v = (A) => {
    const I = [...o].filter((P, O) => O !== A);
    s(I);
  }, $ = !!(t && t.length > 0), b = l || Math.random().toString();
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    u && /* @__PURE__ */ y.jsx("label", { htmlFor: b, className: "block text-sm font-medium text-gray-700", children: u }),
    /* @__PURE__ */ y.jsxs(
      "div",
      {
        className: wl(
          "flex items-center flex-wrap gap-1 w-full px-3 py-2 rounded shadow-sm relative",
          $ ? "border border-red-300 text-red-900 placeholder-red-300 focus-within:ring-1 focus-within:ring-danger-500 focus-within:border-danger-500 hasErrors" : "border border-gray-300 placeholder-gray-400 focus-within:ring-1 focus-within:ring-primary-500 focus-within:border-primary-500",
          n
        ),
        children: [
          o.map((A, x) => /* @__PURE__ */ y.jsxs(
            "div",
            {
              className: "flex items-center bg-primary-50 text-xs rounded overflow-hidden text-primary-500",
              children: [
                /* @__PURE__ */ y.jsx("span", { className: "inline-block px-1.5", children: A }),
                /* @__PURE__ */ y.jsx(
                  "button",
                  {
                    type: "button",
                    className: "hover:bg-primary-100 font-semibold inline-block h-full p-1 transition-colors duration-200 focus:outline-none",
                    onClick: () => v(x),
                    children: "✕"
                  }
                )
              ]
            },
            x
          )),
          /* @__PURE__ */ y.jsx(
            "input",
            {
              id: b,
              value: a,
              onKeyDown: m,
              onChange: g,
              className: "flex-grow outline-none border-none text-sm shadow-none ring-0",
              placeholder: r
            }
          ),
          $ && /* @__PURE__ */ y.jsx("div", { className: "absolute right-0 pe-3 flex items-center pointer-events-none", children: /* @__PURE__ */ y.jsx(Pc, { className: "h-5 w-5 sm:h-4 sm:w-4 text-danger-400", "aria-hidden": "true" }) })
        ]
      }
    ),
    /* @__PURE__ */ y.jsx(Nu, { value: t ?? [] }),
    d && /* @__PURE__ */ y.jsx("span", { className: "text-xs text-gray-600", children: d })
  ] });
};
function At(l) {
  "@babel/helpers - typeof";
  return At = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(n) {
    return typeof n;
  } : function(n) {
    return n && typeof Symbol == "function" && n.constructor === Symbol && n !== Symbol.prototype ? "symbol" : typeof n;
  }, At(l);
}
function DE(l, n) {
  if (At(l) != "object" || !l) return l;
  var u = l[Symbol.toPrimitive];
  if (u !== void 0) {
    var t = u.call(l, n || "default");
    if (At(t) != "object") return t;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (n === "string" ? String : Number)(l);
}
function np(l) {
  var n = DE(l, "string");
  return At(n) == "symbol" ? n : n + "";
}
function Kt(l, n, u) {
  return n = np(n), n in l ? Object.defineProperty(l, n, {
    value: u,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : l[n] = u, l;
}
function D2(l, n) {
  var u = Object.keys(l);
  if (Object.getOwnPropertySymbols) {
    var t = Object.getOwnPropertySymbols(l);
    n && (t = t.filter(function(r) {
      return Object.getOwnPropertyDescriptor(l, r).enumerable;
    })), u.push.apply(u, t);
  }
  return u;
}
function yl(l) {
  for (var n = 1; n < arguments.length; n++) {
    var u = arguments[n] != null ? arguments[n] : {};
    n % 2 ? D2(Object(u), !0).forEach(function(t) {
      Kt(l, t, u[t]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(l, Object.getOwnPropertyDescriptors(u)) : D2(Object(u)).forEach(function(t) {
      Object.defineProperty(l, t, Object.getOwnPropertyDescriptor(u, t));
    });
  }
  return l;
}
function ME(l) {
  if (Array.isArray(l)) return l;
}
function BE(l, n) {
  var u = l == null ? null : typeof Symbol < "u" && l[Symbol.iterator] || l["@@iterator"];
  if (u != null) {
    var t, r, o, s, d = [], a = !0, c = !1;
    try {
      if (o = (u = u.call(l)).next, n === 0) {
        if (Object(u) !== u) return;
        a = !1;
      } else for (; !(a = (t = o.call(u)).done) && (d.push(t.value), d.length !== n); a = !0) ;
    } catch (p) {
      c = !0, r = p;
    } finally {
      try {
        if (!a && u.return != null && (s = u.return(), Object(s) !== s)) return;
      } finally {
        if (c) throw r;
      }
    }
    return d;
  }
}
function jd(l, n) {
  (n == null || n > l.length) && (n = l.length);
  for (var u = 0, t = new Array(n); u < n; u++) t[u] = l[u];
  return t;
}
function up(l, n) {
  if (l) {
    if (typeof l == "string") return jd(l, n);
    var u = Object.prototype.toString.call(l).slice(8, -1);
    if (u === "Object" && l.constructor && (u = l.constructor.name), u === "Map" || u === "Set") return Array.from(l);
    if (u === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(u)) return jd(l, n);
  }
}
function LE() {
  throw new TypeError(`Invalid attempt to destructure non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function Hn(l, n) {
  return ME(l) || BE(l, n) || up(l, n) || LE();
}
function GE(l, n) {
  if (l == null) return {};
  var u = {}, t = Object.keys(l), r, o;
  for (o = 0; o < t.length; o++)
    r = t[o], !(n.indexOf(r) >= 0) && (u[r] = l[r]);
  return u;
}
function ne(l, n) {
  if (l == null) return {};
  var u = GE(l, n), t, r;
  if (Object.getOwnPropertySymbols) {
    var o = Object.getOwnPropertySymbols(l);
    for (r = 0; r < o.length; r++)
      t = o[r], !(n.indexOf(t) >= 0) && Object.prototype.propertyIsEnumerable.call(l, t) && (u[t] = l[t]);
  }
  return u;
}
var jE = ["defaultInputValue", "defaultMenuIsOpen", "defaultValue", "inputValue", "menuIsOpen", "onChange", "onInputChange", "onMenuClose", "onMenuOpen", "value"];
function xa(l) {
  var n = l.defaultInputValue, u = n === void 0 ? "" : n, t = l.defaultMenuIsOpen, r = t === void 0 ? !1 : t, o = l.defaultValue, s = o === void 0 ? null : o, d = l.inputValue, a = l.menuIsOpen, c = l.onChange, p = l.onInputChange, g = l.onMenuClose, m = l.onMenuOpen, v = l.value, $ = ne(l, jE), b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(d !== void 0 ? d : u), E = Hn(b, 2), S = E[0], A = E[1], x = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(a !== void 0 ? a : r), I = Hn(x, 2), P = I[0], O = I[1], _ = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(v !== void 0 ? v : s), j = Hn(_, 2), z = j[0], Y = j[1], el = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(ll, H) {
    typeof c == "function" && c(ll, H), Y(ll);
  }, [c]), U = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(ll, H) {
    var V;
    typeof p == "function" && (V = p(ll, H)), A(V !== void 0 ? V : ll);
  }, [p]), ul = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    typeof m == "function" && m(), O(!0);
  }, [m]), il = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    typeof g == "function" && g(), O(!1);
  }, [g]), rl = d !== void 0 ? d : S, tl = a !== void 0 ? a : P, sl = v !== void 0 ? v : z;
  return yl(yl({}, $), {}, {
    inputValue: rl,
    menuIsOpen: tl,
    onChange: el,
    onInputChange: U,
    onMenuClose: il,
    onMenuOpen: ul,
    value: sl
  });
}
function El() {
  return El = Object.assign ? Object.assign.bind() : function(l) {
    for (var n = 1; n < arguments.length; n++) {
      var u = arguments[n];
      for (var t in u)
        Object.prototype.hasOwnProperty.call(u, t) && (l[t] = u[t]);
    }
    return l;
  }, El.apply(this, arguments);
}
function WE(l, n) {
  if (!(l instanceof n))
    throw new TypeError("Cannot call a class as a function");
}
function M2(l, n) {
  for (var u = 0; u < n.length; u++) {
    var t = n[u];
    t.enumerable = t.enumerable || !1, t.configurable = !0, "value" in t && (t.writable = !0), Object.defineProperty(l, np(t.key), t);
  }
}
function VE(l, n, u) {
  return n && M2(l.prototype, n), u && M2(l, u), Object.defineProperty(l, "prototype", {
    writable: !1
  }), l;
}
function Wd(l, n) {
  return Wd = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(t, r) {
    return t.__proto__ = r, t;
  }, Wd(l, n);
}
function kE(l, n) {
  if (typeof n != "function" && n !== null)
    throw new TypeError("Super expression must either be null or a function");
  l.prototype = Object.create(n && n.prototype, {
    constructor: {
      value: l,
      writable: !0,
      configurable: !0
    }
  }), Object.defineProperty(l, "prototype", {
    writable: !1
  }), n && Wd(l, n);
}
function Uo(l) {
  return Uo = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function(u) {
    return u.__proto__ || Object.getPrototypeOf(u);
  }, Uo(l);
}
function ep() {
  try {
    var l = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
  } catch {
  }
  return (ep = function() {
    return !!l;
  })();
}
function HE(l) {
  if (l === void 0)
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  return l;
}
function ZE(l, n) {
  if (n && (At(n) === "object" || typeof n == "function"))
    return n;
  if (n !== void 0)
    throw new TypeError("Derived constructors may only return object or undefined");
  return HE(l);
}
function XE(l) {
  var n = ep();
  return function() {
    var t = Uo(l), r;
    if (n) {
      var o = Uo(this).constructor;
      r = Reflect.construct(t, arguments, o);
    } else
      r = t.apply(this, arguments);
    return ZE(this, r);
  };
}
function zE(l) {
  if (Array.isArray(l)) return jd(l);
}
function YE(l) {
  if (typeof Symbol < "u" && l[Symbol.iterator] != null || l["@@iterator"] != null) return Array.from(l);
}
function UE() {
  throw new TypeError(`Invalid attempt to spread non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function qt(l) {
  return zE(l) || YE(l) || up(l) || UE();
}
function JE(l) {
  if (l.sheet)
    return l.sheet;
  for (var n = 0; n < document.styleSheets.length; n++)
    if (document.styleSheets[n].ownerNode === l)
      return document.styleSheets[n];
}
function KE(l) {
  var n = document.createElement("style");
  return n.setAttribute("data-emotion", l.key), l.nonce !== void 0 && n.setAttribute("nonce", l.nonce), n.appendChild(document.createTextNode("")), n.setAttribute("data-s", ""), n;
}
var QE = /* @__PURE__ */ function() {
  function l(u) {
    var t = this;
    this._insertTag = function(r) {
      var o;
      t.tags.length === 0 ? t.insertionPoint ? o = t.insertionPoint.nextSibling : t.prepend ? o = t.container.firstChild : o = t.before : o = t.tags[t.tags.length - 1].nextSibling, t.container.insertBefore(r, o), t.tags.push(r);
    }, this.isSpeedy = u.speedy === void 0 ? "development" === "production" : u.speedy, this.tags = [], this.ctr = 0, this.nonce = u.nonce, this.key = u.key, this.container = u.container, this.prepend = u.prepend, this.insertionPoint = u.insertionPoint, this.before = null;
  }
  var n = l.prototype;
  return n.hydrate = function(t) {
    t.forEach(this._insertTag);
  }, n.insert = function(t) {
    this.ctr % (this.isSpeedy ? 65e3 : 1) === 0 && this._insertTag(KE(this));
    var r = this.tags[this.tags.length - 1];
    if (true) {
      var o = t.charCodeAt(0) === 64 && t.charCodeAt(1) === 105;
      o && this._alreadyInsertedOrderInsensitiveRule && console.error(`You're attempting to insert the following rule:
` + t + "\n\n`@import` rules must be before all other types of rules in a stylesheet but other rules have already been inserted. Please ensure that `@import` rules are before all other rules."), this._alreadyInsertedOrderInsensitiveRule = this._alreadyInsertedOrderInsensitiveRule || !o;
    }
    if (this.isSpeedy) {
      var s = JE(r);
      try {
        s.insertRule(t, s.cssRules.length);
      } catch (d) {
         true && !/:(-moz-placeholder|-moz-focus-inner|-moz-focusring|-ms-input-placeholder|-moz-read-write|-moz-read-only|-ms-clear|-ms-expand|-ms-reveal){/.test(t) && console.error('There was a problem inserting the following rule: "' + t + '"', d);
      }
    } else
      r.appendChild(document.createTextNode(t));
    this.ctr++;
  }, n.flush = function() {
    this.tags.forEach(function(t) {
      return t.parentNode && t.parentNode.removeChild(t);
    }), this.tags = [], this.ctr = 0,  true && (this._alreadyInsertedOrderInsensitiveRule = !1);
  }, l;
}(), nu = "-ms-", Jo = "-moz-", ln = "-webkit-", Fc = "comm", _c = "rule", Dc = "decl", qE = "@import", tp = "@keyframes", lA = "@layer", nA = Math.abs, Ca = String.fromCharCode, uA = Object.assign;
function eA(l, n) {
  return Un(l, 0) ^ 45 ? (((n << 2 ^ Un(l, 0)) << 2 ^ Un(l, 1)) << 2 ^ Un(l, 2)) << 2 ^ Un(l, 3) : 0;
}
function rp(l) {
  return l.trim();
}
function tA(l, n) {
  return (l = n.exec(l)) ? l[0] : l;
}
function nn(l, n, u) {
  return l.replace(n, u);
}
function Vd(l, n) {
  return l.indexOf(n);
}
function Un(l, n) {
  return l.charCodeAt(n) | 0;
}
function Kr(l, n, u) {
  return l.slice(n, u);
}
function ae(l) {
  return l.length;
}
function Mc(l) {
  return l.length;
}
function go(l, n) {
  return n.push(l), l;
}
function rA(l, n) {
  return l.map(n).join("");
}
var wa = 1, tr = 1, ip = 0, gu = 0, Bn = 0, gr = "";
function Ia(l, n, u, t, r, o, s) {
  return { value: l, root: n, parent: u, type: t, props: r, children: o, line: wa, column: tr, length: s, return: "" };
}
function Wr(l, n) {
  return uA(Ia("", null, null, "", null, null, 0), l, { length: -l.length }, n);
}
function iA() {
  return Bn;
}
function oA() {
  return Bn = gu > 0 ? Un(gr, --gu) : 0, tr--, Bn === 10 && (tr = 1, wa--), Bn;
}
function Pu() {
  return Bn = gu < ip ? Un(gr, gu++) : 0, tr++, Bn === 10 && (tr = 1, wa++), Bn;
}
function de() {
  return Un(gr, gu);
}
function So() {
  return gu;
}
function ii(l, n) {
  return Kr(gr, l, n);
}
function Qr(l) {
  switch (l) {
    case 0:
    case 9:
    case 10:
    case 13:
    case 32:
      return 5;
    case 33:
    case 43:
    case 44:
    case 47:
    case 62:
    case 64:
    case 126:
    case 59:
    case 123:
    case 125:
      return 4;
    case 58:
      return 3;
    case 34:
    case 39:
    case 40:
    case 91:
      return 2;
    case 41:
    case 93:
      return 1;
  }
  return 0;
}
function op(l) {
  return wa = tr = 1, ip = ae(gr = l), gu = 0, [];
}
function ap(l) {
  return gr = "", l;
}
function Po(l) {
  return rp(ii(gu - 1, kd(l === 91 ? l + 2 : l === 40 ? l + 1 : l)));
}
function aA(l) {
  for (; (Bn = de()) && Bn < 33; )
    Pu();
  return Qr(l) > 2 || Qr(Bn) > 3 ? "" : " ";
}
function sA(l, n) {
  for (; --n && Pu() && !(Bn < 48 || Bn > 102 || Bn > 57 && Bn < 65 || Bn > 70 && Bn < 97); )
    ;
  return ii(l, So() + (n < 6 && de() == 32 && Pu() == 32));
}
function kd(l) {
  for (; Pu(); )
    switch (Bn) {
      case l:
        return gu;
      case 34:
      case 39:
        l !== 34 && l !== 39 && kd(Bn);
        break;
      case 40:
        l === 41 && kd(l);
        break;
      case 92:
        Pu();
        break;
    }
  return gu;
}
function dA(l, n) {
  for (; Pu() && l + Bn !== 57; )
    if (l + Bn === 84 && de() === 47)
      break;
  return "/*" + ii(n, gu - 1) + "*" + Ca(l === 47 ? l : Pu());
}
function cA(l) {
  for (; !Qr(de()); )
    Pu();
  return ii(l, gu);
}
function fA(l) {
  return ap(No("", null, null, null, [""], l = op(l), 0, [0], l));
}
function No(l, n, u, t, r, o, s, d, a) {
  for (var c = 0, p = 0, g = s, m = 0, v = 0, $ = 0, b = 1, E = 1, S = 1, A = 0, x = "", I = r, P = o, O = t, _ = x; E; )
    switch ($ = A, A = Pu()) {
      case 40:
        if ($ != 108 && Un(_, g - 1) == 58) {
          Vd(_ += nn(Po(A), "&", "&\f"), "&\f") != -1 && (S = -1);
          break;
        }
      case 34:
      case 39:
      case 91:
        _ += Po(A);
        break;
      case 9:
      case 10:
      case 13:
      case 32:
        _ += aA($);
        break;
      case 92:
        _ += sA(So() - 1, 7);
        continue;
      case 47:
        switch (de()) {
          case 42:
          case 47:
            go(pA(dA(Pu(), So()), n, u), a);
            break;
          default:
            _ += "/";
        }
        break;
      case 123 * b:
        d[c++] = ae(_) * S;
      case 125 * b:
      case 59:
      case 0:
        switch (A) {
          case 0:
          case 125:
            E = 0;
          case 59 + p:
            S == -1 && (_ = nn(_, /\f/g, "")), v > 0 && ae(_) - g && go(v > 32 ? L2(_ + ";", t, u, g - 1) : L2(nn(_, " ", "") + ";", t, u, g - 2), a);
            break;
          case 59:
            _ += ";";
          default:
            if (go(O = B2(_, n, u, c, p, r, d, x, I = [], P = [], g), o), A === 123)
              if (p === 0)
                No(_, n, O, O, I, o, g, d, P);
              else
                switch (m === 99 && Un(_, 3) === 110 ? 100 : m) {
                  case 100:
                  case 108:
                  case 109:
                  case 115:
                    No(l, O, O, t && go(B2(l, O, O, 0, 0, r, d, x, r, I = [], g), P), r, P, g, d, t ? I : P);
                    break;
                  default:
                    No(_, O, O, O, [""], P, 0, d, P);
                }
        }
        c = p = v = 0, b = S = 1, x = _ = "", g = s;
        break;
      case 58:
        g = 1 + ae(_), v = $;
      default:
        if (b < 1) {
          if (A == 123)
            --b;
          else if (A == 125 && b++ == 0 && oA() == 125)
            continue;
        }
        switch (_ += Ca(A), A * b) {
          case 38:
            S = p > 0 ? 1 : (_ += "\f", -1);
            break;
          case 44:
            d[c++] = (ae(_) - 1) * S, S = 1;
            break;
          case 64:
            de() === 45 && (_ += Po(Pu())), m = de(), p = g = ae(x = _ += cA(So())), A++;
            break;
          case 45:
            $ === 45 && ae(_) == 2 && (b = 0);
        }
    }
  return o;
}
function B2(l, n, u, t, r, o, s, d, a, c, p) {
  for (var g = r - 1, m = r === 0 ? o : [""], v = Mc(m), $ = 0, b = 0, E = 0; $ < t; ++$)
    for (var S = 0, A = Kr(l, g + 1, g = nA(b = s[$])), x = l; S < v; ++S)
      (x = rp(b > 0 ? m[S] + " " + A : nn(A, /&\f/g, m[S]))) && (a[E++] = x);
  return Ia(l, n, u, r === 0 ? _c : d, a, c, p);
}
function pA(l, n, u) {
  return Ia(l, n, u, Fc, Ca(iA()), Kr(l, 2, -2), 0);
}
function L2(l, n, u, t) {
  return Ia(l, n, u, Dc, Kr(l, 0, t), Kr(l, t + 1, -1), t);
}
function lr(l, n) {
  for (var u = "", t = Mc(l), r = 0; r < t; r++)
    u += n(l[r], r, l, n) || "";
  return u;
}
function gA(l, n, u, t) {
  switch (l.type) {
    case lA:
      if (l.children.length) break;
    case qE:
    case Dc:
      return l.return = l.return || l.value;
    case Fc:
      return "";
    case tp:
      return l.return = l.value + "{" + lr(l.children, t) + "}";
    case _c:
      l.value = l.props.join(",");
  }
  return ae(u = lr(l.children, t)) ? l.return = l.value + "{" + u + "}" : "";
}
function hA(l) {
  var n = Mc(l);
  return function(u, t, r, o) {
    for (var s = "", d = 0; d < n; d++)
      s += l[d](u, t, r, o) || "";
    return s;
  };
}
function mA(l) {
  return function(n) {
    n.root || (n = n.return) && l(n);
  };
}
function vA(l) {
  var n = /* @__PURE__ */ Object.create(null);
  return function(u) {
    return n[u] === void 0 && (n[u] = l(u)), n[u];
  };
}
var bA = function(n, u, t) {
  for (var r = 0, o = 0; r = o, o = de(), r === 38 && o === 12 && (u[t] = 1), !Qr(o); )
    Pu();
  return ii(n, gu);
}, yA = function(n, u) {
  var t = -1, r = 44;
  do
    switch (Qr(r)) {
      case 0:
        r === 38 && de() === 12 && (u[t] = 1), n[t] += bA(gu - 1, u, t);
        break;
      case 2:
        n[t] += Po(r);
        break;
      case 4:
        if (r === 44) {
          n[++t] = de() === 58 ? "&\f" : "", u[t] = n[t].length;
          break;
        }
      default:
        n[t] += Ca(r);
    }
  while (r = Pu());
  return n;
}, $A = function(n, u) {
  return ap(yA(op(n), u));
}, G2 = /* @__PURE__ */ new WeakMap(), xA = function(n) {
  if (!(n.type !== "rule" || !n.parent || // positive .length indicates that this rule contains pseudo
  // negative .length indicates that this rule has been already prefixed
  n.length < 1)) {
    for (var u = n.value, t = n.parent, r = n.column === t.column && n.line === t.line; t.type !== "rule"; )
      if (t = t.parent, !t) return;
    if (!(n.props.length === 1 && u.charCodeAt(0) !== 58 && !G2.get(t)) && !r) {
      G2.set(n, !0);
      for (var o = [], s = $A(u, o), d = t.props, a = 0, c = 0; a < s.length; a++)
        for (var p = 0; p < d.length; p++, c++)
          n.props[c] = o[a] ? s[a].replace(/&\f/g, d[p]) : d[p] + " " + s[a];
    }
  }
}, CA = function(n) {
  if (n.type === "decl") {
    var u = n.value;
    // charcode for l
    u.charCodeAt(0) === 108 && // charcode for b
    u.charCodeAt(2) === 98 && (n.return = "", n.value = "");
  }
}, wA = "emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason", IA = function(n) {
  return n.type === "comm" && n.children.indexOf(wA) > -1;
}, EA = function(n) {
  return function(u, t, r) {
    if (!(u.type !== "rule" || n.compat)) {
      var o = u.value.match(/(:first|:nth|:nth-last)-child/g);
      if (o) {
        for (var s = !!u.parent, d = s ? u.parent.children : (
          // global rule at the root level
          r
        ), a = d.length - 1; a >= 0; a--) {
          var c = d[a];
          if (c.line < u.line)
            break;
          if (c.column < u.column) {
            if (IA(c))
              return;
            break;
          }
        }
        o.forEach(function(p) {
          console.error('The pseudo class "' + p + '" is potentially unsafe when doing server-side rendering. Try changing it to "' + p.split("-child")[0] + '-of-type".');
        });
      }
    }
  };
}, sp = function(n) {
  return n.type.charCodeAt(1) === 105 && n.type.charCodeAt(0) === 64;
}, AA = function(n, u) {
  for (var t = n - 1; t >= 0; t--)
    if (!sp(u[t]))
      return !0;
  return !1;
}, j2 = function(n) {
  n.type = "", n.value = "", n.return = "", n.children = "", n.props = "";
}, SA = function(n, u, t) {
  sp(n) && (n.parent ? (console.error("`@import` rules can't be nested inside other rules. Please move it to the top level and put it before regular rules. Keep in mind that they can only be used within global styles."), j2(n)) : AA(u, t) && (console.error("`@import` rules can't be after other rules. Please put your `@import` rules before your other rules."), j2(n)));
};
function dp(l, n) {
  switch (eA(l, n)) {
    case 5103:
      return ln + "print-" + l + l;
    case 5737:
    case 4201:
    case 3177:
    case 3433:
    case 1641:
    case 4457:
    case 2921:
    case 5572:
    case 6356:
    case 5844:
    case 3191:
    case 6645:
    case 3005:
    case 6391:
    case 5879:
    case 5623:
    case 6135:
    case 4599:
    case 4855:
    case 4215:
    case 6389:
    case 5109:
    case 5365:
    case 5621:
    case 3829:
      return ln + l + l;
    case 5349:
    case 4246:
    case 4810:
    case 6968:
    case 2756:
      return ln + l + Jo + l + nu + l + l;
    case 6828:
    case 4268:
      return ln + l + nu + l + l;
    case 6165:
      return ln + l + nu + "flex-" + l + l;
    case 5187:
      return ln + l + nn(l, /(\w+).+(:[^]+)/, ln + "box-$1$2" + nu + "flex-$1$2") + l;
    case 5443:
      return ln + l + nu + "flex-item-" + nn(l, /flex-|-self/, "") + l;
    case 4675:
      return ln + l + nu + "flex-line-pack" + nn(l, /align-content|flex-|-self/, "") + l;
    case 5548:
      return ln + l + nu + nn(l, "shrink", "negative") + l;
    case 5292:
      return ln + l + nu + nn(l, "basis", "preferred-size") + l;
    case 6060:
      return ln + "box-" + nn(l, "-grow", "") + ln + l + nu + nn(l, "grow", "positive") + l;
    case 4554:
      return ln + nn(l, /([^-])(transform)/g, "$1" + ln + "$2") + l;
    case 6187:
      return nn(nn(nn(l, /(zoom-|grab)/, ln + "$1"), /(image-set)/, ln + "$1"), l, "") + l;
    case 5495:
    case 3959:
      return nn(l, /(image-set\([^]*)/, ln + "$1$`$1");
    case 4968:
      return nn(nn(l, /(.+:)(flex-)?(.*)/, ln + "box-pack:$3" + nu + "flex-pack:$3"), /s.+-b[^;]+/, "justify") + ln + l + l;
    case 4095:
    case 3583:
    case 4068:
    case 2532:
      return nn(l, /(.+)-inline(.+)/, ln + "$1$2") + l;
    case 8116:
    case 7059:
    case 5753:
    case 5535:
    case 5445:
    case 5701:
    case 4933:
    case 4677:
    case 5533:
    case 5789:
    case 5021:
    case 4765:
      if (ae(l) - 1 - n > 6) switch (Un(l, n + 1)) {
        case 109:
          if (Un(l, n + 4) !== 45) break;
        case 102:
          return nn(l, /(.+:)(.+)-([^]+)/, "$1" + ln + "$2-$3$1" + Jo + (Un(l, n + 3) == 108 ? "$3" : "$2-$3")) + l;
        case 115:
          return ~Vd(l, "stretch") ? dp(nn(l, "stretch", "fill-available"), n) + l : l;
      }
      break;
    case 4949:
      if (Un(l, n + 1) !== 115) break;
    case 6444:
      switch (Un(l, ae(l) - 3 - (~Vd(l, "!important") && 10))) {
        case 107:
          return nn(l, ":", ":" + ln) + l;
        case 101:
          return nn(l, /(.+:)([^;!]+)(;|!.+)?/, "$1" + ln + (Un(l, 14) === 45 ? "inline-" : "") + "box$3$1" + ln + "$2$3$1" + nu + "$2box$3") + l;
      }
      break;
    case 5936:
      switch (Un(l, n + 11)) {
        case 114:
          return ln + l + nu + nn(l, /[svh]\w+-[tblr]{2}/, "tb") + l;
        case 108:
          return ln + l + nu + nn(l, /[svh]\w+-[tblr]{2}/, "tb-rl") + l;
        case 45:
          return ln + l + nu + nn(l, /[svh]\w+-[tblr]{2}/, "lr") + l;
      }
      return ln + l + nu + l + l;
  }
  return l;
}
var PA = function(n, u, t, r) {
  if (n.length > -1 && !n.return) switch (n.type) {
    case Dc:
      n.return = dp(n.value, n.length);
      break;
    case tp:
      return lr([Wr(n, {
        value: nn(n.value, "@", "@" + ln)
      })], r);
    case _c:
      if (n.length) return rA(n.props, function(o) {
        switch (tA(o, /(::plac\w+|:read-\w+)/)) {
          case ":read-only":
          case ":read-write":
            return lr([Wr(n, {
              props: [nn(o, /:(read-\w+)/, ":" + Jo + "$1")]
            })], r);
          case "::placeholder":
            return lr([Wr(n, {
              props: [nn(o, /:(plac\w+)/, ":" + ln + "input-$1")]
            }), Wr(n, {
              props: [nn(o, /:(plac\w+)/, ":" + Jo + "$1")]
            }), Wr(n, {
              props: [nn(o, /:(plac\w+)/, nu + "input-$1")]
            })], r);
        }
        return "";
      });
  }
}, NA = [PA], cp = function(n) {
  var u = n.key;
  if ( true && !u)
    throw new Error(`You have to configure \`key\` for your cache. Please make sure it's unique (and not equal to 'css') as it's used for linking styles to your cache.
If multiple caches share the same key they might "fight" for each other's style elements.`);
  if (u === "css") {
    var t = document.querySelectorAll("style[data-emotion]:not([data-s])");
    Array.prototype.forEach.call(t, function(b) {
      var E = b.getAttribute("data-emotion");
      E.indexOf(" ") !== -1 && (document.head.appendChild(b), b.setAttribute("data-s", ""));
    });
  }
  var r = n.stylisPlugins || NA;
  if ( true && /[^a-z-]/.test(u))
    throw new Error('Emotion key must only contain lower case alphabetical characters and - but "' + u + '" was passed');
  var o = {}, s, d = [];
  s = n.container || document.head, Array.prototype.forEach.call(
    // this means we will ignore elements which don't have a space in them which
    // means that the style elements we're looking at are only Emotion 11 server-rendered style elements
    document.querySelectorAll('style[data-emotion^="' + u + ' "]'),
    function(b) {
      for (var E = b.getAttribute("data-emotion").split(" "), S = 1; S < E.length; S++)
        o[E[S]] = !0;
      d.push(b);
    }
  );
  var a, c = [xA, CA];
   true && c.push(EA({
    get compat() {
      return $.compat;
    }
  }), SA);
  {
    var p, g = [gA,  true ? function(b) {
      b.root || (b.return ? p.insert(b.return) : b.value && b.type !== Fc && p.insert(b.value + "{}"));
    } : 0], m = hA(c.concat(r, g)), v = function(E) {
      return lr(fA(E), m);
    };
    a = function(E, S, A, x) {
      p = A,  true && S.map !== void 0 && (p = {
        insert: function(P) {
          A.insert(P + S.map);
        }
      }), v(E ? E + "{" + S.styles + "}" : S.styles), x && ($.inserted[S.name] = !0);
    };
  }
  var $ = {
    key: u,
    sheet: new QE({
      key: u,
      container: s,
      nonce: n.nonce,
      speedy: n.speedy,
      prepend: n.prepend,
      insertionPoint: n.insertionPoint
    }),
    nonce: n.nonce,
    inserted: o,
    registered: {},
    insert: a
  };
  return $.sheet.hydrate(d), $;
}, Hd = { exports: {} }, tn = {};
/** @license React v16.13.1
 * react-is.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var W2;
function TA() {
  if (W2) return tn;
  W2 = 1;
  var l = typeof Symbol == "function" && Symbol.for, n = l ? Symbol.for("react.element") : 60103, u = l ? Symbol.for("react.portal") : 60106, t = l ? Symbol.for("react.fragment") : 60107, r = l ? Symbol.for("react.strict_mode") : 60108, o = l ? Symbol.for("react.profiler") : 60114, s = l ? Symbol.for("react.provider") : 60109, d = l ? Symbol.for("react.context") : 60110, a = l ? Symbol.for("react.async_mode") : 60111, c = l ? Symbol.for("react.concurrent_mode") : 60111, p = l ? Symbol.for("react.forward_ref") : 60112, g = l ? Symbol.for("react.suspense") : 60113, m = l ? Symbol.for("react.suspense_list") : 60120, v = l ? Symbol.for("react.memo") : 60115, $ = l ? Symbol.for("react.lazy") : 60116, b = l ? Symbol.for("react.block") : 60121, E = l ? Symbol.for("react.fundamental") : 60117, S = l ? Symbol.for("react.responder") : 60118, A = l ? Symbol.for("react.scope") : 60119;
  function x(P) {
    if (typeof P == "object" && P !== null) {
      var O = P.$$typeof;
      switch (O) {
        case n:
          switch (P = P.type, P) {
            case a:
            case c:
            case t:
            case o:
            case r:
            case g:
              return P;
            default:
              switch (P = P && P.$$typeof, P) {
                case d:
                case p:
                case $:
                case v:
                case s:
                  return P;
                default:
                  return O;
              }
          }
        case u:
          return O;
      }
    }
  }
  function I(P) {
    return x(P) === c;
  }
  return tn.AsyncMode = a, tn.ConcurrentMode = c, tn.ContextConsumer = d, tn.ContextProvider = s, tn.Element = n, tn.ForwardRef = p, tn.Fragment = t, tn.Lazy = $, tn.Memo = v, tn.Portal = u, tn.Profiler = o, tn.StrictMode = r, tn.Suspense = g, tn.isAsyncMode = function(P) {
    return I(P) || x(P) === a;
  }, tn.isConcurrentMode = I, tn.isContextConsumer = function(P) {
    return x(P) === d;
  }, tn.isContextProvider = function(P) {
    return x(P) === s;
  }, tn.isElement = function(P) {
    return typeof P == "object" && P !== null && P.$$typeof === n;
  }, tn.isForwardRef = function(P) {
    return x(P) === p;
  }, tn.isFragment = function(P) {
    return x(P) === t;
  }, tn.isLazy = function(P) {
    return x(P) === $;
  }, tn.isMemo = function(P) {
    return x(P) === v;
  }, tn.isPortal = function(P) {
    return x(P) === u;
  }, tn.isProfiler = function(P) {
    return x(P) === o;
  }, tn.isStrictMode = function(P) {
    return x(P) === r;
  }, tn.isSuspense = function(P) {
    return x(P) === g;
  }, tn.isValidElementType = function(P) {
    return typeof P == "string" || typeof P == "function" || P === t || P === c || P === o || P === r || P === g || P === m || typeof P == "object" && P !== null && (P.$$typeof === $ || P.$$typeof === v || P.$$typeof === s || P.$$typeof === d || P.$$typeof === p || P.$$typeof === E || P.$$typeof === S || P.$$typeof === A || P.$$typeof === b);
  }, tn.typeOf = x, tn;
}
var rn = {};
/** @license React v16.13.1
 * react-is.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var V2;
function RA() {
  return V2 || (V2 = 1,  true && function() {
    var l = typeof Symbol == "function" && Symbol.for, n = l ? Symbol.for("react.element") : 60103, u = l ? Symbol.for("react.portal") : 60106, t = l ? Symbol.for("react.fragment") : 60107, r = l ? Symbol.for("react.strict_mode") : 60108, o = l ? Symbol.for("react.profiler") : 60114, s = l ? Symbol.for("react.provider") : 60109, d = l ? Symbol.for("react.context") : 60110, a = l ? Symbol.for("react.async_mode") : 60111, c = l ? Symbol.for("react.concurrent_mode") : 60111, p = l ? Symbol.for("react.forward_ref") : 60112, g = l ? Symbol.for("react.suspense") : 60113, m = l ? Symbol.for("react.suspense_list") : 60120, v = l ? Symbol.for("react.memo") : 60115, $ = l ? Symbol.for("react.lazy") : 60116, b = l ? Symbol.for("react.block") : 60121, E = l ? Symbol.for("react.fundamental") : 60117, S = l ? Symbol.for("react.responder") : 60118, A = l ? Symbol.for("react.scope") : 60119;
    function x(Q) {
      return typeof Q == "string" || typeof Q == "function" || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
      Q === t || Q === c || Q === o || Q === r || Q === g || Q === m || typeof Q == "object" && Q !== null && (Q.$$typeof === $ || Q.$$typeof === v || Q.$$typeof === s || Q.$$typeof === d || Q.$$typeof === p || Q.$$typeof === E || Q.$$typeof === S || Q.$$typeof === A || Q.$$typeof === b);
    }
    function I(Q) {
      if (typeof Q == "object" && Q !== null) {
        var Xl = Q.$$typeof;
        switch (Xl) {
          case n:
            var Bl = Q.type;
            switch (Bl) {
              case a:
              case c:
              case t:
              case o:
              case r:
              case g:
                return Bl;
              default:
                var Kl = Bl && Bl.$$typeof;
                switch (Kl) {
                  case d:
                  case p:
                  case $:
                  case v:
                  case s:
                    return Kl;
                  default:
                    return Xl;
                }
            }
          case u:
            return Xl;
        }
      }
    }
    var P = a, O = c, _ = d, j = s, z = n, Y = p, el = t, U = $, ul = v, il = u, rl = o, tl = r, sl = g, ll = !1;
    function H(Q) {
      return ll || (ll = !0, console.warn("The ReactIs.isAsyncMode() alias has been deprecated, and will be removed in React 17+. Update your code to use ReactIs.isConcurrentMode() instead. It has the exact same API.")), V(Q) || I(Q) === a;
    }
    function V(Q) {
      return I(Q) === c;
    }
    function X(Q) {
      return I(Q) === d;
    }
    function dl(Q) {
      return I(Q) === s;
    }
    function fl(Q) {
      return typeof Q == "object" && Q !== null && Q.$$typeof === n;
    }
    function $l(Q) {
      return I(Q) === p;
    }
    function cl(Q) {
      return I(Q) === t;
    }
    function xl(Q) {
      return I(Q) === $;
    }
    function ol(Q) {
      return I(Q) === v;
    }
    function ml(Q) {
      return I(Q) === u;
    }
    function Sl(Q) {
      return I(Q) === o;
    }
    function Ol(Q) {
      return I(Q) === r;
    }
    function Cl(Q) {
      return I(Q) === g;
    }
    rn.AsyncMode = P, rn.ConcurrentMode = O, rn.ContextConsumer = _, rn.ContextProvider = j, rn.Element = z, rn.ForwardRef = Y, rn.Fragment = el, rn.Lazy = U, rn.Memo = ul, rn.Portal = il, rn.Profiler = rl, rn.StrictMode = tl, rn.Suspense = sl, rn.isAsyncMode = H, rn.isConcurrentMode = V, rn.isContextConsumer = X, rn.isContextProvider = dl, rn.isElement = fl, rn.isForwardRef = $l, rn.isFragment = cl, rn.isLazy = xl, rn.isMemo = ol, rn.isPortal = ml, rn.isProfiler = Sl, rn.isStrictMode = Ol, rn.isSuspense = Cl, rn.isValidElementType = x, rn.typeOf = I;
  }()), rn;
}
 false ? 0 : Hd.exports = RA();
var OA = Hd.exports, fp = OA, FA = {
  $$typeof: !0,
  render: !0,
  defaultProps: !0,
  displayName: !0,
  propTypes: !0
}, _A = {
  $$typeof: !0,
  compare: !0,
  defaultProps: !0,
  displayName: !0,
  propTypes: !0,
  type: !0
}, pp = {};
pp[fp.ForwardRef] = FA;
pp[fp.Memo] = _A;
var DA = !0;
function gp(l, n, u) {
  var t = "";
  return u.split(" ").forEach(function(r) {
    l[r] !== void 0 ? n.push(l[r] + ";") : t += r + " ";
  }), t;
}
var Bc = function(n, u, t) {
  var r = n.key + "-" + u.name;
  // we only need to add the styles to the registered cache if the
  // class name could be used further down
  // the tree but if it's a string tag, we know it won't
  // so we don't have to add it to registered cache.
  // this improves memory usage since we can avoid storing the whole style string
  (t === !1 || // we need to always store it if we're in compat mode and
  // in node since emotion-server relies on whether a style is in
  // the registered cache to know whether a style is global or not
  // also, note that this check will be dead code eliminated in the browser
  DA === !1) && n.registered[r] === void 0 && (n.registered[r] = u.styles);
}, Lc = function(n, u, t) {
  Bc(n, u, t);
  var r = n.key + "-" + u.name;
  if (n.inserted[u.name] === void 0) {
    var o = u;
    do
      n.insert(u === o ? "." + r : "", o, n.sheet, !0), o = o.next;
    while (o !== void 0);
  }
};
function MA(l) {
  for (var n = 0, u, t = 0, r = l.length; r >= 4; ++t, r -= 4)
    u = l.charCodeAt(t) & 255 | (l.charCodeAt(++t) & 255) << 8 | (l.charCodeAt(++t) & 255) << 16 | (l.charCodeAt(++t) & 255) << 24, u = /* Math.imul(k, m): */
    (u & 65535) * 1540483477 + ((u >>> 16) * 59797 << 16), u ^= /* k >>> r: */
    u >>> 24, n = /* Math.imul(k, m): */
    (u & 65535) * 1540483477 + ((u >>> 16) * 59797 << 16) ^ /* Math.imul(h, m): */
    (n & 65535) * 1540483477 + ((n >>> 16) * 59797 << 16);
  switch (r) {
    case 3:
      n ^= (l.charCodeAt(t + 2) & 255) << 16;
    case 2:
      n ^= (l.charCodeAt(t + 1) & 255) << 8;
    case 1:
      n ^= l.charCodeAt(t) & 255, n = /* Math.imul(h, m): */
      (n & 65535) * 1540483477 + ((n >>> 16) * 59797 << 16);
  }
  return n ^= n >>> 13, n = /* Math.imul(h, m): */
  (n & 65535) * 1540483477 + ((n >>> 16) * 59797 << 16), ((n ^ n >>> 15) >>> 0).toString(36);
}
var BA = {
  animationIterationCount: 1,
  aspectRatio: 1,
  borderImageOutset: 1,
  borderImageSlice: 1,
  borderImageWidth: 1,
  boxFlex: 1,
  boxFlexGroup: 1,
  boxOrdinalGroup: 1,
  columnCount: 1,
  columns: 1,
  flex: 1,
  flexGrow: 1,
  flexPositive: 1,
  flexShrink: 1,
  flexNegative: 1,
  flexOrder: 1,
  gridRow: 1,
  gridRowEnd: 1,
  gridRowSpan: 1,
  gridRowStart: 1,
  gridColumn: 1,
  gridColumnEnd: 1,
  gridColumnSpan: 1,
  gridColumnStart: 1,
  msGridRow: 1,
  msGridRowSpan: 1,
  msGridColumn: 1,
  msGridColumnSpan: 1,
  fontWeight: 1,
  lineHeight: 1,
  opacity: 1,
  order: 1,
  orphans: 1,
  tabSize: 1,
  widows: 1,
  zIndex: 1,
  zoom: 1,
  WebkitLineClamp: 1,
  // SVG-related properties
  fillOpacity: 1,
  floodOpacity: 1,
  stopOpacity: 1,
  strokeDasharray: 1,
  strokeDashoffset: 1,
  strokeMiterlimit: 1,
  strokeOpacity: 1,
  strokeWidth: 1
}, k2 = `You have illegal escape sequence in your template literal, most likely inside content's property value.
Because you write your CSS inside a JavaScript string you actually have to do double escaping, so for example "content: '\\00d7';" should become "content: '\\\\00d7';".
You can read more about this here:
https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences`, LA = "You have passed in falsy value as style object's key (can happen when in example you pass unexported component as computed key).", GA = /[A-Z]|^ms/g, hp = /_EMO_([^_]+?)_([^]*?)_EMO_/g, Gc = function(n) {
  return n.charCodeAt(1) === 45;
}, H2 = function(n) {
  return n != null && typeof n != "boolean";
}, rd = /* @__PURE__ */ vA(function(l) {
  return Gc(l) ? l : l.replace(GA, "-$&").toLowerCase();
}), Ko = function(n, u) {
  switch (n) {
    case "animation":
    case "animationName":
      if (typeof u == "string")
        return u.replace(hp, function(t, r, o) {
          return qu = {
            name: r,
            styles: o,
            next: qu
          }, r;
        });
  }
  return BA[n] !== 1 && !Gc(n) && typeof u == "number" && u !== 0 ? u + "px" : u;
};
if (true) {
  var jA = /(var|attr|counters?|url|element|(((repeating-)?(linear|radial))|conic)-gradient)\(|(no-)?(open|close)-quote/, WA = ["normal", "none", "initial", "inherit", "unset"], VA = Ko, kA = /^-ms-/, HA = /-(.)/g, Z2 = {};
  Ko = function(n, u) {
    if (n === "content" && (typeof u != "string" || WA.indexOf(u) === -1 && !jA.test(u) && (u.charAt(0) !== u.charAt(u.length - 1) || u.charAt(0) !== '"' && u.charAt(0) !== "'")))
      throw new Error("You seem to be using a value for 'content' without quotes, try replacing it with `content: '\"" + u + "\"'`");
    var t = VA(n, u);
    return t !== "" && !Gc(n) && n.indexOf("-") !== -1 && Z2[n] === void 0 && (Z2[n] = !0, console.error("Using kebab-case for css properties in objects is not supported. Did you mean " + n.replace(kA, "ms-").replace(HA, function(r, o) {
      return o.toUpperCase();
    }) + "?")), t;
  };
}
var mp = "Component selectors can only be used in conjunction with @emotion/babel-plugin, the swc Emotion plugin, or another Emotion-aware compiler transform.";
function qr(l, n, u) {
  if (u == null)
    return "";
  if (u.__emotion_styles !== void 0) {
    if ( true && u.toString() === "NO_COMPONENT_SELECTOR")
      throw new Error(mp);
    return u;
  }
  switch (typeof u) {
    case "boolean":
      return "";
    case "object": {
      if (u.anim === 1)
        return qu = {
          name: u.name,
          styles: u.styles,
          next: qu
        }, u.name;
      if (u.styles !== void 0) {
        var t = u.next;
        if (t !== void 0)
          for (; t !== void 0; )
            qu = {
              name: t.name,
              styles: t.styles,
              next: qu
            }, t = t.next;
        var r = u.styles + ";";
        return  true && u.map !== void 0 && (r += u.map), r;
      }
      return ZA(l, n, u);
    }
    case "function": {
      if (l !== void 0) {
        var o = qu, s = u(l);
        return qu = o, qr(l, n, s);
      } else  true && console.error("Functions that are interpolated in css calls will be stringified.\nIf you want to have a css call based on props, create a function that returns a css call like this\nlet dynamicStyle = (props) => css`color: ${props.color}`\nIt can be called directly with props or interpolated in a styled call like this\nlet SomeComponent = styled('div')`${dynamicStyle}`");
      break;
    }
    case "string":
      if (true) {
        var d = [], a = u.replace(hp, function(p, g, m) {
          var v = "animation" + d.length;
          return d.push("const " + v + " = keyframes`" + m.replace(/^@keyframes animation-\w+/, "") + "`"), "${" + v + "}";
        });
        d.length && console.error("`keyframes` output got interpolated into plain string, please wrap it with `css`.\n\nInstead of doing this:\n\n" + [].concat(d, ["`" + a + "`"]).join(`
`) + `

You should wrap it with \`css\` like this:

` + ("css`" + a + "`"));
      }
      break;
  }
  if (n == null)
    return u;
  var c = n[u];
  return c !== void 0 ? c : u;
}
function ZA(l, n, u) {
  var t = "";
  if (Array.isArray(u))
    for (var r = 0; r < u.length; r++)
      t += qr(l, n, u[r]) + ";";
  else
    for (var o in u) {
      var s = u[o];
      if (typeof s != "object")
        n != null && n[s] !== void 0 ? t += o + "{" + n[s] + "}" : H2(s) && (t += rd(o) + ":" + Ko(o, s) + ";");
      else {
        if (o === "NO_COMPONENT_SELECTOR" && "development" !== "production")
          throw new Error(mp);
        if (Array.isArray(s) && typeof s[0] == "string" && (n == null || n[s[0]] === void 0))
          for (var d = 0; d < s.length; d++)
            H2(s[d]) && (t += rd(o) + ":" + Ko(o, s[d]) + ";");
        else {
          var a = qr(l, n, s);
          switch (o) {
            case "animation":
            case "animationName": {
              t += rd(o) + ":" + a + ";";
              break;
            }
            default:
               true && o === "undefined" && console.error(LA), t += o + "{" + a + "}";
          }
        }
      }
    }
  return t;
}
var X2 = /label:\s*([^\s;\n{]+)\s*(;|$)/g, vp;
 true && (vp = /\/\*#\ssourceMappingURL=data:application\/json;\S+\s+\*\//g);
var qu, li = function(n, u, t) {
  if (n.length === 1 && typeof n[0] == "object" && n[0] !== null && n[0].styles !== void 0)
    return n[0];
  var r = !0, o = "";
  qu = void 0;
  var s = n[0];
  s == null || s.raw === void 0 ? (r = !1, o += qr(t, u, s)) : ( true && s[0] === void 0 && console.error(k2), o += s[0]);
  for (var d = 1; d < n.length; d++)
    o += qr(t, u, n[d]), r && ( true && s[d] === void 0 && console.error(k2), o += s[d]);
  var a;
   true && (o = o.replace(vp, function(m) {
    return a = m, "";
  })), X2.lastIndex = 0;
  for (var c = "", p; (p = X2.exec(o)) !== null; )
    c += "-" + // $FlowFixMe we know it's not null
    p[1];
  var g = MA(o) + c;
  return  true ? {
    name: g,
    styles: o,
    map: a,
    next: qu,
    toString: function() {
      return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
    }
  } : 0;
}, XA = function(n) {
  return n();
}, bp = react__WEBPACK_IMPORTED_MODULE_0__.useInsertionEffect ? react__WEBPACK_IMPORTED_MODULE_0__.useInsertionEffect : !1, yp = bp || XA, z2 = bp || react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect, jc = {}.hasOwnProperty, Wc = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createContext(
  // we're doing this to avoid preconstruct's dead code elimination in this one case
  // because this module is primarily intended for the browser and node
  // but it's also required in react native and similar environments sometimes
  // and we could have a special build just for that
  // but this is much easier and the native packages
  // might use a different theme context in the future anyway
  typeof HTMLElement < "u" ? /* @__PURE__ */ cp({
    key: "css"
  }) : null
);
 true && (Wc.displayName = "EmotionCacheContext");
var zA = Wc.Provider, Vc = function(n) {
  return /* @__PURE__ */ (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function(u, t) {
    var r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(Wc);
    return n(u, r, t);
  });
}, Ea = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createContext({});
 true && (Ea.displayName = "EmotionThemeContext");
var Y2 = function(n) {
  var u = n.split(".");
  return u[u.length - 1];
}, YA = function(n) {
  var u = /^\s+at\s+([A-Za-z0-9$.]+)\s/.exec(n);
  if (u || (u = /^([A-Za-z0-9$.]+)@/.exec(n), u)) return Y2(u[1]);
}, UA = /* @__PURE__ */ new Set(["renderWithHooks", "processChild", "finishClassComponent", "renderToString"]), JA = function(n) {
  return n.replace(/\$/g, "-");
}, KA = function(n) {
  if (n)
    for (var u = n.split(`
`), t = 0; t < u.length; t++) {
      var r = YA(u[t]);
      if (r) {
        if (UA.has(r)) break;
        if (/^[A-Z]/.test(r)) return JA(r);
      }
    }
}, Zd = "__EMOTION_TYPE_PLEASE_DO_NOT_USE__", Xd = "__EMOTION_LABEL_PLEASE_DO_NOT_USE__", QA = function(n, u) {
  if ( true && typeof u.css == "string" && // check if there is a css declaration
  u.css.indexOf(":") !== -1)
    throw new Error("Strings are not allowed as css prop values, please wrap it in a css template literal from '@emotion/react' like this: css`" + u.css + "`");
  var t = {};
  for (var r in u)
    jc.call(u, r) && (t[r] = u[r]);
  if (t[Zd] = n,  true && u.css && (typeof u.css != "object" || typeof u.css.name != "string" || u.css.name.indexOf("-") === -1)) {
    var o = KA(new Error().stack);
    o && (t[Xd] = o);
  }
  return t;
}, qA = function(n) {
  var u = n.cache, t = n.serialized, r = n.isStringTag;
  return Bc(u, t, r), yp(function() {
    return Lc(u, t, r);
  }), null;
}, $p = /* @__PURE__ */ Vc(function(l, n, u) {
  var t = l.css;
  typeof t == "string" && n.registered[t] !== void 0 && (t = n.registered[t]);
  var r = l[Zd], o = [t], s = "";
  typeof l.className == "string" ? s = gp(n.registered, o, l.className) : l.className != null && (s = l.className + " ");
  var d = li(o, void 0, react__WEBPACK_IMPORTED_MODULE_0__.useContext(Ea));
  if ( true && d.name.indexOf("-") === -1) {
    var a = l[Xd];
    a && (d = li([d, "label:" + a + ";"]));
  }
  s += n.key + "-" + d.name;
  var c = {};
  for (var p in l)
    jc.call(l, p) && p !== "css" && p !== Zd && ( false || p !== Xd) && (c[p] = l[p]);
  return c.ref = u, c.className = s, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(qA, {
    cache: n,
    serialized: d,
    isStringTag: typeof r == "string"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(r, c));
});
 true && ($p.displayName = "EmotionCssPropInternal");
var lS = $p, nS = {
  name: "@emotion/react",
  version: "11.11.4",
  main: "dist/emotion-react.cjs.js",
  module: "dist/emotion-react.esm.js",
  browser: {
    "./dist/emotion-react.esm.js": "./dist/emotion-react.browser.esm.js"
  },
  exports: {
    ".": {
      module: {
        worker: "./dist/emotion-react.worker.esm.js",
        browser: "./dist/emotion-react.browser.esm.js",
        default: "./dist/emotion-react.esm.js"
      },
      import: "./dist/emotion-react.cjs.mjs",
      default: "./dist/emotion-react.cjs.js"
    },
    "./jsx-runtime": {
      module: {
        worker: "./jsx-runtime/dist/emotion-react-jsx-runtime.worker.esm.js",
        browser: "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.esm.js",
        default: "./jsx-runtime/dist/emotion-react-jsx-runtime.esm.js"
      },
      import: "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.mjs",
      default: "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.js"
    },
    "./_isolated-hnrs": {
      module: {
        worker: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.worker.esm.js",
        browser: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.esm.js",
        default: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.esm.js"
      },
      import: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.mjs",
      default: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.js"
    },
    "./jsx-dev-runtime": {
      module: {
        worker: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.worker.esm.js",
        browser: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.esm.js",
        default: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.esm.js"
      },
      import: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.mjs",
      default: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.js"
    },
    "./package.json": "./package.json",
    "./types/css-prop": "./types/css-prop.d.ts",
    "./macro": {
      types: {
        import: "./macro.d.mts",
        default: "./macro.d.ts"
      },
      default: "./macro.js"
    }
  },
  types: "types/index.d.ts",
  files: [
    "src",
    "dist",
    "jsx-runtime",
    "jsx-dev-runtime",
    "_isolated-hnrs",
    "types/*.d.ts",
    "macro.*"
  ],
  sideEffects: !1,
  author: "Emotion Contributors",
  license: "MIT",
  scripts: {
    "test:typescript": "dtslint types"
  },
  dependencies: {
    "@babel/runtime": "^7.18.3",
    "@emotion/babel-plugin": "^11.11.0",
    "@emotion/cache": "^11.11.0",
    "@emotion/serialize": "^1.1.3",
    "@emotion/use-insertion-effect-with-fallbacks": "^1.0.1",
    "@emotion/utils": "^1.2.1",
    "@emotion/weak-memoize": "^0.3.1",
    "hoist-non-react-statics": "^3.3.1"
  },
  peerDependencies: {
    react: ">=16.8.0"
  },
  peerDependenciesMeta: {
    "@types/react": {
      optional: !0
    }
  },
  devDependencies: {
    "@definitelytyped/dtslint": "0.0.112",
    "@emotion/css": "11.11.2",
    "@emotion/css-prettifier": "1.1.3",
    "@emotion/server": "11.11.0",
    "@emotion/styled": "11.11.0",
    "html-tag-names": "^1.1.2",
    react: "16.14.0",
    "svg-tag-names": "^1.1.1",
    typescript: "^4.5.5"
  },
  repository: "https://github.com/emotion-js/emotion/tree/main/packages/react",
  publishConfig: {
    access: "public"
  },
  "umd:main": "dist/emotion-react.umd.min.js",
  preconstruct: {
    entrypoints: [
      "./index.js",
      "./jsx-runtime.js",
      "./jsx-dev-runtime.js",
      "./_isolated-hnrs.js"
    ],
    umdName: "emotionReact",
    exports: {
      envConditions: [
        "browser",
        "worker"
      ],
      extra: {
        "./types/css-prop": "./types/css-prop.d.ts",
        "./macro": {
          types: {
            import: "./macro.d.mts",
            default: "./macro.d.ts"
          },
          default: "./macro.js"
        }
      }
    }
  }
}, Il = function(n, u) {
  var t = arguments;
  if (u == null || !jc.call(u, "css"))
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement.apply(void 0, t);
  var r = t.length, o = new Array(r);
  o[0] = lS, o[1] = QA(n, u);
  for (var s = 2; s < r; s++)
    o[s] = t[s];
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement.apply(null, o);
}, U2 = !1, uS = /* @__PURE__ */ Vc(function(l, n) {
   true && !U2 && // check for className as well since the user is
  // probably using the custom createElement which
  // means it will be turned into a className prop
  // $FlowFixMe I don't really want to add it to the type since it shouldn't be used
  (l.className || l.css) && (console.error("It looks like you're using the css prop on Global, did you mean to use the styles prop instead?"), U2 = !0);
  var u = l.styles, t = li([u], void 0, react__WEBPACK_IMPORTED_MODULE_0__.useContext(Ea)), r = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  return z2(function() {
    var o = n.key + "-global", s = new n.sheet.constructor({
      key: o,
      nonce: n.sheet.nonce,
      container: n.sheet.container,
      speedy: n.sheet.isSpeedy
    }), d = !1, a = document.querySelector('style[data-emotion="' + o + " " + t.name + '"]');
    return n.sheet.tags.length && (s.before = n.sheet.tags[0]), a !== null && (d = !0, a.setAttribute("data-emotion", o), s.hydrate([a])), r.current = [s, d], function() {
      s.flush();
    };
  }, [n]), z2(function() {
    var o = r.current, s = o[0], d = o[1];
    if (d) {
      o[1] = !1;
      return;
    }
    if (t.next !== void 0 && Lc(n, t.next, !0), s.tags.length) {
      var a = s.tags[s.tags.length - 1].nextElementSibling;
      s.before = a, s.flush();
    }
    n.insert("", t, s, !1);
  }, [n, t.name]), null;
});
 true && (uS.displayName = "EmotionGlobal");
function kc() {
  for (var l = arguments.length, n = new Array(l), u = 0; u < l; u++)
    n[u] = arguments[u];
  return li(n);
}
var eS = function() {
  var n = kc.apply(void 0, arguments), u = "animation-" + n.name;
  return {
    name: u,
    styles: "@keyframes " + u + "{" + n.styles + "}",
    anim: 1,
    toString: function() {
      return "_EMO_" + this.name + "_" + this.styles + "_EMO_";
    }
  };
}, tS = function l(n) {
  for (var u = n.length, t = 0, r = ""; t < u; t++) {
    var o = n[t];
    if (o != null) {
      var s = void 0;
      switch (typeof o) {
        case "boolean":
          break;
        case "object": {
          if (Array.isArray(o))
            s = l(o);
          else {
             true && o.styles !== void 0 && o.name !== void 0 && console.error("You have passed styles created with `css` from `@emotion/react` package to the `cx`.\n`cx` is meant to compose class names (strings) so you should convert those styles to a class name by passing them to the `css` received from <ClassNames/> component."), s = "";
            for (var d in o)
              o[d] && d && (s && (s += " "), s += d);
          }
          break;
        }
        default:
          s = o;
      }
      s && (r && (r += " "), r += s);
    }
  }
  return r;
};
function rS(l, n, u) {
  var t = [], r = gp(l, t, u);
  return t.length < 2 ? u : r + n(t);
}
var iS = function(n) {
  var u = n.cache, t = n.serializedArr;
  return yp(function() {
    for (var r = 0; r < t.length; r++)
      Lc(u, t[r], !1);
  }), null;
}, oS = /* @__PURE__ */ Vc(function(l, n) {
  var u = !1, t = [], r = function() {
    if (u && "development" !== "production")
      throw new Error("css can only be used during render");
    for (var c = arguments.length, p = new Array(c), g = 0; g < c; g++)
      p[g] = arguments[g];
    var m = li(p, n.registered);
    return t.push(m), Bc(n, m, !1), n.key + "-" + m.name;
  }, o = function() {
    if (u && "development" !== "production")
      throw new Error("cx can only be used during render");
    for (var c = arguments.length, p = new Array(c), g = 0; g < c; g++)
      p[g] = arguments[g];
    return rS(n.registered, r, tS(p));
  }, s = {
    css: r,
    cx: o,
    theme: react__WEBPACK_IMPORTED_MODULE_0__.useContext(Ea)
  }, d = l.children(s);
  return u = !0, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(iS, {
    cache: n,
    serializedArr: t
  }), d);
});
 true && (oS.displayName = "EmotionClassNames");
if (true) {
  var J2 = !0, aS = typeof jest < "u" || typeof vi < "u";
  if (J2 && !aS) {
    var K2 = (
      // $FlowIgnore
      typeof globalThis < "u" ? globalThis : J2 ? window : global
    ), Q2 = "__EMOTION_REACT_" + nS.version.split(".")[0] + "__";
    K2[Q2] && console.warn("You are loading @emotion/react when it is already loaded. Running multiple instances may cause problems. This can happen if multiple versions are used, or if multiple builds of the same version are used."), K2[Q2] = !0;
  }
}
function sS(l, n) {
  return n || (n = l.slice(0)), Object.freeze(Object.defineProperties(l, {
    raw: {
      value: Object.freeze(n)
    }
  }));
}
var zd = react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect, dS = ["className", "clearValue", "cx", "getStyles", "getClassNames", "getValue", "hasValue", "isMulti", "isRtl", "options", "selectOption", "selectProps", "setValue", "theme"], Qo = function() {
};
function cS(l, n) {
  return n ? n[0] === "-" ? l + n : l + "__" + n : l;
}
function fS(l, n) {
  for (var u = arguments.length, t = new Array(u > 2 ? u - 2 : 0), r = 2; r < u; r++)
    t[r - 2] = arguments[r];
  var o = [].concat(t);
  if (n && l)
    for (var s in n)
      n.hasOwnProperty(s) && n[s] && o.push("".concat(cS(l, s)));
  return o.filter(function(d) {
    return d;
  }).map(function(d) {
    return String(d).trim();
  }).join(" ");
}
var qo = function(n) {
  return CS(n) ? n.filter(Boolean) : At(n) === "object" && n !== null ? [n] : [];
}, xp = function(n) {
  n.className, n.clearValue, n.cx, n.getStyles, n.getClassNames, n.getValue, n.hasValue, n.isMulti, n.isRtl, n.options, n.selectOption, n.selectProps, n.setValue, n.theme;
  var u = ne(n, dS);
  return yl({}, u);
}, Nn = function(n, u, t) {
  var r = n.cx, o = n.getStyles, s = n.getClassNames, d = n.className;
  return {
    css: o(u, n),
    className: r(t ?? {}, s(u, n), d)
  };
};
function pS(l, n, u) {
  if (u) {
    var t = u(l, n);
    if (typeof t == "string") return t;
  }
  return l;
}
function Aa(l) {
  return [document.documentElement, document.body, window].indexOf(l) > -1;
}
function gS(l) {
  return Aa(l) ? window.innerHeight : l.clientHeight;
}
function Cp(l) {
  return Aa(l) ? window.pageYOffset : l.scrollTop;
}
function la(l, n) {
  if (Aa(l)) {
    window.scrollTo(0, n);
    return;
  }
  l.scrollTop = n;
}
function hS(l) {
  var n = getComputedStyle(l), u = n.position === "absolute", t = /(auto|scroll)/;
  if (n.position === "fixed") return document.documentElement;
  for (var r = l; r = r.parentElement; )
    if (n = getComputedStyle(r), !(u && n.position === "static") && t.test(n.overflow + n.overflowY + n.overflowX))
      return r;
  return document.documentElement;
}
function mS(l, n, u, t) {
  return u * ((l = l / t - 1) * l * l + 1) + n;
}
function ho(l, n) {
  var u = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : 200, t = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : Qo, r = Cp(l), o = n - r, s = 10, d = 0;
  function a() {
    d += s;
    var c = mS(d, r, o, u);
    la(l, c), d < u ? window.requestAnimationFrame(a) : t(l);
  }
  a();
}
function q2(l, n) {
  var u = l.getBoundingClientRect(), t = n.getBoundingClientRect(), r = n.offsetHeight / 3;
  t.bottom + r > u.bottom ? la(l, Math.min(n.offsetTop + n.clientHeight - l.offsetHeight + r, l.scrollHeight)) : t.top - r < u.top && la(l, Math.max(n.offsetTop - r, 0));
}
function vS(l) {
  var n = l.getBoundingClientRect();
  return {
    bottom: n.bottom,
    height: n.height,
    left: n.left,
    right: n.right,
    top: n.top,
    width: n.width
  };
}
function l3() {
  try {
    return document.createEvent("TouchEvent"), !0;
  } catch {
    return !1;
  }
}
function bS() {
  try {
    return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
  } catch {
    return !1;
  }
}
var wp = !1, yS = {
  get passive() {
    return wp = !0;
  }
}, mo = typeof window < "u" ? window : {};
mo.addEventListener && mo.removeEventListener && (mo.addEventListener("p", Qo, yS), mo.removeEventListener("p", Qo, !1));
var $S = wp;
function xS(l) {
  return l != null;
}
function CS(l) {
  return Array.isArray(l);
}
function Hr(l, n, u) {
  return l ? n : u;
}
var wS = function(n) {
  for (var u = arguments.length, t = new Array(u > 1 ? u - 1 : 0), r = 1; r < u; r++)
    t[r - 1] = arguments[r];
  var o = Object.entries(n).filter(function(s) {
    var d = Hn(s, 1), a = d[0];
    return !t.includes(a);
  });
  return o.reduce(function(s, d) {
    var a = Hn(d, 2), c = a[0], p = a[1];
    return s[c] = p, s;
  }, {});
}, IS = ["children", "innerProps"], ES = ["children", "innerProps"];
function AS(l) {
  var n = l.maxHeight, u = l.menuEl, t = l.minHeight, r = l.placement, o = l.shouldScroll, s = l.isFixedPosition, d = l.controlHeight, a = hS(u), c = {
    placement: "bottom",
    maxHeight: n
  };
  if (!u || !u.offsetParent) return c;
  var p = a.getBoundingClientRect(), g = p.height, m = u.getBoundingClientRect(), v = m.bottom, $ = m.height, b = m.top, E = u.offsetParent.getBoundingClientRect(), S = E.top, A = s ? window.innerHeight : gS(a), x = Cp(a), I = parseInt(getComputedStyle(u).marginBottom, 10), P = parseInt(getComputedStyle(u).marginTop, 10), O = S - P, _ = A - b, j = O + x, z = g - x - b, Y = v - A + x + I, el = x + b - P, U = 160;
  switch (r) {
    case "auto":
    case "bottom":
      if (_ >= $)
        return {
          placement: "bottom",
          maxHeight: n
        };
      if (z >= $ && !s)
        return o && ho(a, Y, U), {
          placement: "bottom",
          maxHeight: n
        };
      if (!s && z >= t || s && _ >= t) {
        o && ho(a, Y, U);
        var ul = s ? _ - I : z - I;
        return {
          placement: "bottom",
          maxHeight: ul
        };
      }
      if (r === "auto" || s) {
        var il = n, rl = s ? O : j;
        return rl >= t && (il = Math.min(rl - I - d, n)), {
          placement: "top",
          maxHeight: il
        };
      }
      if (r === "bottom")
        return o && la(a, Y), {
          placement: "bottom",
          maxHeight: n
        };
      break;
    case "top":
      if (O >= $)
        return {
          placement: "top",
          maxHeight: n
        };
      if (j >= $ && !s)
        return o && ho(a, el, U), {
          placement: "top",
          maxHeight: n
        };
      if (!s && j >= t || s && O >= t) {
        var tl = n;
        return (!s && j >= t || s && O >= t) && (tl = s ? O - P : j - P), o && ho(a, el, U), {
          placement: "top",
          maxHeight: tl
        };
      }
      return {
        placement: "bottom",
        maxHeight: n
      };
    default:
      throw new Error('Invalid placement provided "'.concat(r, '".'));
  }
  return c;
}
function SS(l) {
  var n = {
    bottom: "top",
    top: "bottom"
  };
  return l ? n[l] : "bottom";
}
var Ip = function(n) {
  return n === "auto" ? "bottom" : n;
}, PS = function(n, u) {
  var t, r = n.placement, o = n.theme, s = o.borderRadius, d = o.spacing, a = o.colors;
  return yl((t = {
    label: "menu"
  }, Kt(t, SS(r), "100%"), Kt(t, "position", "absolute"), Kt(t, "width", "100%"), Kt(t, "zIndex", 1), t), u ? {} : {
    backgroundColor: a.neutral0,
    borderRadius: s,
    boxShadow: "0 0 0 1px hsla(0, 0%, 0%, 0.1), 0 4px 11px hsla(0, 0%, 0%, 0.1)",
    marginBottom: d.menuGutter,
    marginTop: d.menuGutter
  });
}, Ep = /* @__PURE__ */ (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null), NS = function(n) {
  var u = n.children, t = n.minMenuHeight, r = n.maxMenuHeight, o = n.menuPlacement, s = n.menuPosition, d = n.menuShouldScrollIntoView, a = n.theme, c = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(Ep) || {}, p = c.setPortalPlacement, g = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), m = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(r), v = Hn(m, 2), $ = v[0], b = v[1], E = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null), S = Hn(E, 2), A = S[0], x = S[1], I = a.spacing.controlHeight;
  return zd(function() {
    var P = g.current;
    if (P) {
      var O = s === "fixed", _ = d && !O, j = AS({
        maxHeight: r,
        menuEl: P,
        minHeight: t,
        placement: o,
        shouldScroll: _,
        isFixedPosition: O,
        controlHeight: I
      });
      b(j.maxHeight), x(j.placement), p == null || p(j.placement);
    }
  }, [r, o, s, d, t, p, I]), u({
    ref: g,
    placerProps: yl(yl({}, n), {}, {
      placement: A || Ip(o),
      maxHeight: $
    })
  });
}, TS = function(n) {
  var u = n.children, t = n.innerRef, r = n.innerProps;
  return Il("div", El({}, Nn(n, "menu", {
    menu: !0
  }), {
    ref: t
  }, r), u);
}, RS = TS, OS = function(n, u) {
  var t = n.maxHeight, r = n.theme.spacing.baseUnit;
  return yl({
    maxHeight: t,
    overflowY: "auto",
    position: "relative",
    // required for offset[Height, Top] > keyboard scroll
    WebkitOverflowScrolling: "touch"
  }, u ? {} : {
    paddingBottom: r,
    paddingTop: r
  });
}, FS = function(n) {
  var u = n.children, t = n.innerProps, r = n.innerRef, o = n.isMulti;
  return Il("div", El({}, Nn(n, "menuList", {
    "menu-list": !0,
    "menu-list--is-multi": o
  }), {
    ref: r
  }, t), u);
}, Ap = function(n, u) {
  var t = n.theme, r = t.spacing.baseUnit, o = t.colors;
  return yl({
    textAlign: "center"
  }, u ? {} : {
    color: o.neutral40,
    padding: "".concat(r * 2, "px ").concat(r * 3, "px")
  });
}, _S = Ap, DS = Ap, MS = function(n) {
  var u = n.children, t = u === void 0 ? "No options" : u, r = n.innerProps, o = ne(n, IS);
  return Il("div", El({}, Nn(yl(yl({}, o), {}, {
    children: t,
    innerProps: r
  }), "noOptionsMessage", {
    "menu-notice": !0,
    "menu-notice--no-options": !0
  }), r), t);
}, BS = function(n) {
  var u = n.children, t = u === void 0 ? "Loading..." : u, r = n.innerProps, o = ne(n, ES);
  return Il("div", El({}, Nn(yl(yl({}, o), {}, {
    children: t,
    innerProps: r
  }), "loadingMessage", {
    "menu-notice": !0,
    "menu-notice--loading": !0
  }), r), t);
}, LS = function(n) {
  var u = n.rect, t = n.offset, r = n.position;
  return {
    left: u.left,
    position: r,
    top: t,
    width: u.width,
    zIndex: 1
  };
}, GS = function(n) {
  var u = n.appendTo, t = n.children, r = n.controlElement, o = n.innerProps, s = n.menuPlacement, d = n.menuPosition, a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), c = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(Ip(s)), g = Hn(p, 2), m = g[0], v = g[1], $ = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    return {
      setPortalPlacement: v
    };
  }, []), b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null), E = Hn(b, 2), S = E[0], A = E[1], x = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    if (r) {
      var _ = vS(r), j = d === "fixed" ? 0 : window.pageYOffset, z = _[m] + j;
      (z !== (S == null ? void 0 : S.offset) || _.left !== (S == null ? void 0 : S.rect.left) || _.width !== (S == null ? void 0 : S.rect.width)) && A({
        offset: z,
        rect: _
      });
    }
  }, [r, d, m, S == null ? void 0 : S.offset, S == null ? void 0 : S.rect.left, S == null ? void 0 : S.rect.width]);
  zd(function() {
    x();
  }, [x]);
  var I = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function() {
    typeof c.current == "function" && (c.current(), c.current = null), r && a.current && (c.current = wc(r, a.current, x, {
      elementResize: "ResizeObserver" in window
    }));
  }, [r, x]);
  zd(function() {
    I();
  }, [I]);
  var P = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(_) {
    a.current = _, I();
  }, [I]);
  if (!u && d !== "fixed" || !S) return null;
  var O = Il("div", El({
    ref: P
  }, Nn(yl(yl({}, n), {}, {
    offset: S.offset,
    position: d,
    rect: S.rect
  }), "menuPortal", {
    "menu-portal": !0
  }), o), t);
  return Il(Ep.Provider, {
    value: $
  }, u ? /* @__PURE__ */ (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)(O, u) : O);
}, jS = function(n) {
  var u = n.isDisabled, t = n.isRtl;
  return {
    label: "container",
    direction: t ? "rtl" : void 0,
    pointerEvents: u ? "none" : void 0,
    // cancel mouse events when disabled
    position: "relative"
  };
}, WS = function(n) {
  var u = n.children, t = n.innerProps, r = n.isDisabled, o = n.isRtl;
  return Il("div", El({}, Nn(n, "container", {
    "--is-disabled": r,
    "--is-rtl": o
  }), t), u);
}, VS = function(n, u) {
  var t = n.theme.spacing, r = n.isMulti, o = n.hasValue, s = n.selectProps.controlShouldRenderValue;
  return yl({
    alignItems: "center",
    display: r && o && s ? "flex" : "grid",
    flex: 1,
    flexWrap: "wrap",
    WebkitOverflowScrolling: "touch",
    position: "relative",
    overflow: "hidden"
  }, u ? {} : {
    padding: "".concat(t.baseUnit / 2, "px ").concat(t.baseUnit * 2, "px")
  });
}, kS = function(n) {
  var u = n.children, t = n.innerProps, r = n.isMulti, o = n.hasValue;
  return Il("div", El({}, Nn(n, "valueContainer", {
    "value-container": !0,
    "value-container--is-multi": r,
    "value-container--has-value": o
  }), t), u);
}, HS = function() {
  return {
    alignItems: "center",
    alignSelf: "stretch",
    display: "flex",
    flexShrink: 0
  };
}, ZS = function(n) {
  var u = n.children, t = n.innerProps;
  return Il("div", El({}, Nn(n, "indicatorsContainer", {
    indicators: !0
  }), t), u);
}, n3, XS = ["size"], zS = ["innerProps", "isRtl", "size"];
function YS() {
  return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
}
var US =  false ? 0 : {
  name: "tj5bde-Svg",
  styles: "display:inline-block;fill:currentColor;line-height:1;stroke:currentColor;stroke-width:0;label:Svg;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImluZGljYXRvcnMudHN4Il0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQXlCSSIsImZpbGUiOiJpbmRpY2F0b3JzLnRzeCIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAanN4IGpzeCAqL1xuaW1wb3J0IHsgUmVhY3ROb2RlIH0gZnJvbSAncmVhY3QnO1xuaW1wb3J0IHsganN4LCBrZXlmcmFtZXMgfSBmcm9tICdAZW1vdGlvbi9yZWFjdCc7XG5cbmltcG9ydCB7XG4gIENvbW1vblByb3BzQW5kQ2xhc3NOYW1lLFxuICBDU1NPYmplY3RXaXRoTGFiZWwsXG4gIEdyb3VwQmFzZSxcbn0gZnJvbSAnLi4vdHlwZXMnO1xuaW1wb3J0IHsgZ2V0U3R5bGVQcm9wcyB9IGZyb20gJy4uL3V0aWxzJztcblxuLy8gPT09PT09PT09PT09PT09PT09PT09PT09PT09PT09XG4vLyBEcm9wZG93biAmIENsZWFyIEljb25zXG4vLyA9PT09PT09PT09PT09PT09PT09PT09PT09PT09PT1cblxuY29uc3QgU3ZnID0gKHtcbiAgc2l6ZSxcbiAgLi4ucHJvcHNcbn06IEpTWC5JbnRyaW5zaWNFbGVtZW50c1snc3ZnJ10gJiB7IHNpemU6IG51bWJlciB9KSA9PiAoXG4gIDxzdmdcbiAgICBoZWlnaHQ9e3NpemV9XG4gICAgd2lkdGg9e3NpemV9XG4gICAgdmlld0JveD1cIjAgMCAyMCAyMFwiXG4gICAgYXJpYS1oaWRkZW49XCJ0cnVlXCJcbiAgICBmb2N1c2FibGU9XCJmYWxzZVwiXG4gICAgY3NzPXt7XG4gICAgICBkaXNwbGF5OiAnaW5saW5lLWJsb2NrJyxcbiAgICAgIGZpbGw6ICdjdXJyZW50Q29sb3InLFxuICAgICAgbGluZUhlaWdodDogMSxcbiAgICAgIHN0cm9rZTogJ2N1cnJlbnRDb2xvcicsXG4gICAgICBzdHJva2VXaWR0aDogMCxcbiAgICB9fVxuICAgIHsuLi5wcm9wc31cbiAgLz5cbik7XG5cbmV4cG9ydCB0eXBlIENyb3NzSWNvblByb3BzID0gSlNYLkludHJpbnNpY0VsZW1lbnRzWydzdmcnXSAmIHsgc2l6ZT86IG51bWJlciB9O1xuZXhwb3J0IGNvbnN0IENyb3NzSWNvbiA9IChwcm9wczogQ3Jvc3NJY29uUHJvcHMpID0+IChcbiAgPFN2ZyBzaXplPXsyMH0gey4uLnByb3BzfT5cbiAgICA8cGF0aCBkPVwiTTE0LjM0OCAxNC44NDljLTAuNDY5IDAuNDY5LTEuMjI5IDAuNDY5LTEuNjk3IDBsLTIuNjUxLTMuMDMwLTIuNjUxIDMuMDI5Yy0wLjQ2OSAwLjQ2OS0xLjIyOSAwLjQ2OS0xLjY5NyAwLTAuNDY5LTAuNDY5LTAuNDY5LTEuMjI5IDAtMS42OTdsMi43NTgtMy4xNS0yLjc1OS0zLjE1MmMtMC40NjktMC40NjktMC40NjktMS4yMjggMC0xLjY5N3MxLjIyOC0wLjQ2OSAxLjY5NyAwbDIuNjUyIDMuMDMxIDIuNjUxLTMuMDMxYzAuNDY5LTAuNDY5IDEuMjI4LTAuNDY5IDEuNjk3IDBzMC40NjkgMS4yMjkgMCAxLjY5N2wtMi43NTggMy4xNTIgMi43NTggMy4xNWMwLjQ2OSAwLjQ2OSAwLjQ2OSAxLjIyOSAwIDEuNjk4elwiIC8+XG4gIDwvU3ZnPlxuKTtcbmV4cG9ydCB0eXBlIERvd25DaGV2cm9uUHJvcHMgPSBKU1guSW50cmluc2ljRWxlbWVudHNbJ3N2ZyddICYgeyBzaXplPzogbnVtYmVyIH07XG5leHBvcnQgY29uc3QgRG93bkNoZXZyb24gPSAocHJvcHM6IERvd25DaGV2cm9uUHJvcHMpID0+IChcbiAgPFN2ZyBzaXplPXsyMH0gey4uLnByb3BzfT5cbiAgICA8cGF0aCBkPVwiTTQuNTE2IDcuNTQ4YzAuNDM2LTAuNDQ2IDEuMDQzLTAuNDgxIDEuNTc2IDBsMy45MDggMy43NDcgMy45MDgtMy43NDdjMC41MzMtMC40ODEgMS4xNDEtMC40NDYgMS41NzQgMCAwLjQzNiAwLjQ0NSAwLjQwOCAxLjE5NyAwIDEuNjE1LTAuNDA2IDAuNDE4LTQuNjk1IDQuNTAyLTQuNjk1IDQuNTAyLTAuMjE3IDAuMjIzLTAuNTAyIDAuMzM1LTAuNzg3IDAuMzM1cy0wLjU3LTAuMTEyLTAuNzg5LTAuMzM1YzAgMC00LjI4Ny00LjA4NC00LjY5NS00LjUwMnMtMC40MzYtMS4xNyAwLTEuNjE1elwiIC8+XG4gIDwvU3ZnPlxuKTtcblxuLy8gPT09PT09PT09PT09PT09PT09PT09PT09PT09PT09XG4vLyBEcm9wZG93biAmIENsZWFyIEJ1dHRvbnNcbi8vID09PT09PT09PT09PT09PT09PT09PT09PT09PT09PVxuXG5leHBvcnQgaW50ZXJmYWNlIERyb3Bkb3duSW5kaWNhdG9yUHJvcHM8XG4gIE9wdGlvbiA9IHVua25vd24sXG4gIElzTXVsdGkgZXh0ZW5kcyBib29sZWFuID0gYm9vbGVhbixcbiAgR3JvdXAgZXh0ZW5kcyBHcm91cEJhc2U8T3B0aW9uPiA9IEdyb3VwQmFzZTxPcHRpb24+XG4+IGV4dGVuZHMgQ29tbW9uUHJvcHNBbmRDbGFzc05hbWU8T3B0aW9uLCBJc011bHRpLCBHcm91cD4ge1xuICAvKiogVGhlIGNoaWxkcmVuIHRvIGJlIHJlbmRlcmVkIGluc2lkZSB0aGUgaW5kaWNhdG9yLiAqL1xuICBjaGlsZHJlbj86IFJlYWN0Tm9kZTtcbiAgLyoqIFByb3BzIHRoYXQgd2lsbCBiZSBwYXNzZWQgb24gdG8gdGhlIGNoaWxkcmVuLiAqL1xuICBpbm5lclByb3BzOiBKU1guSW50cmluc2ljRWxlbWVudHNbJ2RpdiddO1xuICAvKiogVGhlIGZvY3VzZWQgc3RhdGUgb2YgdGhlIHNlbGVjdC4gKi9cbiAgaXNGb2N1c2VkOiBib29sZWFuO1xuICBpc0Rpc2FibGVkOiBib29sZWFuO1xufVxuXG5jb25zdCBiYXNlQ1NTID0gPFxuICBPcHRpb24sXG4gIElzTXVsdGkgZXh0ZW5kcyBib29sZWFuLFxuICBHcm91cCBleHRlbmRzIEdyb3VwQmFzZTxPcHRpb24+XG4+KFxuICB7XG4gICAgaXNGb2N1c2VkLFxuICAgIHRoZW1lOiB7XG4gICAgICBzcGFjaW5nOiB7IGJhc2VVbml0IH0sXG4gICAgICBjb2xvcnMsXG4gICAgfSxcbiAgfTpcbiAgICB8IERyb3Bkb3duSW5kaWNhdG9yUHJvcHM8T3B0aW9uLCBJc011bHRpLCBHcm91cD5cbiAgICB8IENsZWFySW5kaWNhdG9yUHJvcHM8T3B0aW9uLCBJc011bHRpLCBHcm91cD4sXG4gIHVuc3R5bGVkOiBib29sZWFuXG4pOiBDU1NPYmplY3RXaXRoTGFiZWwgPT4gKHtcbiAgbGFiZWw6ICdpbmRpY2F0b3JDb250YWluZXInLFxuICBkaXNwbGF5OiAnZmxleCcsXG4gIHRyYW5zaXRpb246ICdjb2xvciAxNTBtcycsXG4gIC4uLih1bnN0eWxlZFxuICAgID8ge31cbiAgICA6IHtcbiAgICAgICAgY29sb3I6IGlzRm9jdXNlZCA/IGNvbG9ycy5uZXV0cmFsNjAgOiBjb2xvcnMubmV1dHJhbDIwLFxuICAgICAgICBwYWRkaW5nOiBiYXNlVW5pdCAqIDIsXG4gICAgICAgICc6aG92ZXInOiB7XG4gICAgICAgICAgY29sb3I6IGlzRm9jdXNlZCA/IGNvbG9ycy5uZXV0cmFsODAgOiBjb2xvcnMubmV1dHJhbDQwLFxuICAgICAgICB9LFxuICAgICAgfSksXG59KTtcblxuZXhwb3J0IGNvbnN0IGRyb3Bkb3duSW5kaWNhdG9yQ1NTID0gYmFzZUNTUztcbmV4cG9ydCBjb25zdCBEcm9wZG93bkluZGljYXRvciA9IDxcbiAgT3B0aW9uLFxuICBJc011bHRpIGV4dGVuZHMgYm9vbGVhbixcbiAgR3JvdXAgZXh0ZW5kcyBHcm91cEJhc2U8T3B0aW9uPlxuPihcbiAgcHJvcHM6IERyb3Bkb3duSW5kaWNhdG9yUHJvcHM8T3B0aW9uLCBJc011bHRpLCBHcm91cD5cbikgPT4ge1xuICBjb25zdCB7IGNoaWxkcmVuLCBpbm5lclByb3BzIH0gPSBwcm9wcztcbiAgcmV0dXJuIChcbiAgICA8ZGl2XG4gICAgICB7Li4uZ2V0U3R5bGVQcm9wcyhwcm9wcywgJ2Ryb3Bkb3duSW5kaWNhdG9yJywge1xuICAgICAgICBpbmRpY2F0b3I6IHRydWUsXG4gICAgICAgICdkcm9wZG93bi1pbmRpY2F0b3InOiB0cnVlLFxuICAgICAgfSl9XG4gICAgICB7Li4uaW5uZXJQcm9wc31cbiAgICA+XG4gICAgICB7Y2hpbGRyZW4gfHwgPERvd25DaGV2cm9uIC8+fVxuICAgIDwvZGl2PlxuICApO1xufTtcblxuZXhwb3J0IGludGVyZmFjZSBDbGVhckluZGljYXRvclByb3BzPFxuICBPcHRpb24gPSB1bmtub3duLFxuICBJc011bHRpIGV4dGVuZHMgYm9vbGVhbiA9IGJvb2xlYW4sXG4gIEdyb3VwIGV4dGVuZHMgR3JvdXBCYXNlPE9wdGlvbj4gPSBHcm91cEJhc2U8T3B0aW9uPlxuPiBleHRlbmRzIENvbW1vblByb3BzQW5kQ2xhc3NOYW1lPE9wdGlvbiwgSXNNdWx0aSwgR3JvdXA+IHtcbiAgLyoqIFRoZSBjaGlsZHJlbiB0byBiZSByZW5kZXJlZCBpbnNpZGUgdGhlIGluZGljYXRvci4gKi9cbiAgY2hpbGRyZW4/OiBSZWFjdE5vZGU7XG4gIC8qKiBQcm9wcyB0aGF0IHdpbGwgYmUgcGFzc2VkIG9uIHRvIHRoZSBjaGlsZHJlbi4gKi9cbiAgaW5uZXJQcm9wczogSlNYLkludHJpbnNpY0VsZW1lbnRzWydkaXYnXTtcbiAgLyoqIFRoZSBmb2N1c2VkIHN0YXRlIG9mIHRoZSBzZWxlY3QuICovXG4gIGlzRm9jdXNlZDogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNvbnN0IGNsZWFySW5kaWNhdG9yQ1NTID0gYmFzZUNTUztcbmV4cG9ydCBjb25zdCBDbGVhckluZGljYXRvciA9IDxcbiAgT3B0aW9uLFxuICBJc011bHRpIGV4dGVuZHMgYm9vbGVhbixcbiAgR3JvdXAgZXh0ZW5kcyBHcm91cEJhc2U8T3B0aW9uPlxuPihcbiAgcHJvcHM6IENsZWFySW5kaWNhdG9yUHJvcHM8T3B0aW9uLCBJc011bHRpLCBHcm91cD5cbikgPT4ge1xuICBjb25zdCB7IGNoaWxkcmVuLCBpbm5lclByb3BzIH0gPSBwcm9wcztcbiAgcmV0dXJuIChcbiAgICA8ZGl2XG4gICAgICB7Li4uZ2V0U3R5bGVQcm9wcyhwcm9wcywgJ2NsZWFySW5kaWNhdG9yJywge1xuICAgICAgICBpbmRpY2F0b3I6IHRydWUsXG4gICAgICAgICdjbGVhci1pbmRpY2F0b3InOiB0cnVlLFxuICAgICAgfSl9XG4gICAgICB7Li4uaW5uZXJQcm9wc31cbiAgICA+XG4gICAgICB7Y2hpbGRyZW4gfHwgPENyb3NzSWNvbiAvPn1cbiAgICA8L2Rpdj5cbiAgKTtcbn07XG5cbi8vID09PT09PT09PT09PT09PT09PT09PT09PT09PT09PVxuLy8gU2VwYXJhdG9yXG4vLyA9PT09PT09PT09PT09PT09PT09PT09PT09PT09PT1cblxuZXhwb3J0IGludGVyZmFjZSBJbmRpY2F0b3JTZXBhcmF0b3JQcm9wczxcbiAgT3B0aW9uID0gdW5rbm93bixcbiAgSXNNdWx0aSBleHRlbmRzIGJvb2xlYW4gPSBib29sZWFuLFxuICBHcm91cCBleHRlbmRzIEdyb3VwQmFzZTxPcHRpb24+ID0gR3JvdXBCYXNlPE9wdGlvbj5cbj4gZXh0ZW5kcyBDb21tb25Qcm9wc0FuZENsYXNzTmFtZTxPcHRpb24sIElzTXVsdGksIEdyb3VwPiB7XG4gIGlzRGlzYWJsZWQ6IGJvb2xlYW47XG4gIGlzRm9jdXNlZDogYm9vbGVhbjtcbiAgaW5uZXJQcm9wcz86IEpTWC5JbnRyaW5zaWNFbGVtZW50c1snc3BhbiddO1xufVxuXG5leHBvcnQgY29uc3QgaW5kaWNhdG9yU2VwYXJhdG9yQ1NTID0gPFxuICBPcHRpb24sXG4gIElzTXVsdGkgZXh0ZW5kcyBib29sZWFuLFxuICBHcm91cCBleHRlbmRzIEdyb3VwQmFzZTxPcHRpb24+XG4+KFxuICB7XG4gICAgaXNEaXNhYmxlZCxcbiAgICB0aGVtZToge1xuICAgICAgc3BhY2luZzogeyBiYXNlVW5pdCB9LFxuICAgICAgY29sb3JzLFxuICAgIH0sXG4gIH06IEluZGljYXRvclNlcGFyYXRvclByb3BzPE9wdGlvbiwgSXNNdWx0aSwgR3JvdXA+LFxuICB1bnN0eWxlZDogYm9vbGVhblxuKTogQ1NTT2JqZWN0V2l0aExhYmVsID0+ICh7XG4gIGxhYmVsOiAnaW5kaWNhdG9yU2VwYXJhdG9yJyxcbiAgYWxpZ25TZWxmOiAnc3RyZXRjaCcsXG4gIHdpZHRoOiAxLFxuICAuLi4odW5zdHlsZWRcbiAgICA/IHt9XG4gICAgOiB7XG4gICAgICAgIGJhY2tncm91bmRDb2xvcjogaXNEaXNhYmxlZCA/IGNvbG9ycy5uZXV0cmFsMTAgOiBjb2xvcnMubmV1dHJhbDIwLFxuICAgICAgICBtYXJnaW5Cb3R0b206IGJhc2VVbml0ICogMixcbiAgICAgICAgbWFyZ2luVG9wOiBiYXNlVW5pdCAqIDIsXG4gICAgICB9KSxcbn0pO1xuXG5leHBvcnQgY29uc3QgSW5kaWNhdG9yU2VwYXJhdG9yID0gPFxuICBPcHRpb24sXG4gIElzTXVsdGkgZXh0ZW5kcyBib29sZWFuLFxuICBHcm91cCBleHRlbmRzIEdyb3VwQmFzZTxPcHRpb24+XG4+KFxuICBwcm9wczogSW5kaWNhdG9yU2VwYXJhdG9yUHJvcHM8T3B0aW9uLCBJc011bHRpLCBHcm91cD5cbikgPT4ge1xuICBjb25zdCB7IGlubmVyUHJvcHMgfSA9IHByb3BzO1xuICByZXR1cm4gKFxuICAgIDxzcGFuXG4gICAgICB7Li4uaW5uZXJQcm9wc31cbiAgICAgIHsuLi5nZXRTdHlsZVByb3BzKHByb3BzLCAnaW5kaWNhdG9yU2VwYXJhdG9yJywge1xuICAgICAgICAnaW5kaWNhdG9yLXNlcGFyYXRvcic6IHRydWUsXG4gICAgICB9KX1cbiAgICAvPlxuICApO1xufTtcblxuLy8gPT09PT09PT09PT09PT09PT09PT09PT09PT09PT09XG4vLyBMb2FkaW5nXG4vLyA9PT09PT09PT09PT09PT09PT09PT09PT09PT09PT1cblxuY29uc3QgbG9hZGluZ0RvdEFuaW1hdGlvbnMgPSBrZXlmcmFtZXNgXG4gIDAlLCA4MCUsIDEwMCUgeyBvcGFjaXR5OiAwOyB9XG4gIDQwJSB7IG9wYWNpdHk6IDE7IH1cbmA7XG5cbmV4cG9ydCBjb25zdCBsb2FkaW5nSW5kaWNhdG9yQ1NTID0gPFxuICBPcHRpb24sXG4gIElzTXVsdGkgZXh0ZW5kcyBib29sZWFuLFxuICBHcm91cCBleHRlbmRzIEdyb3VwQmFzZTxPcHRpb24+XG4+KFxuICB7XG4gICAgaXNGb2N1c2VkLFxuICAgIHNpemUsXG4gICAgdGhlbWU6IHtcbiAgICAgIGNvbG9ycyxcbiAgICAgIHNwYWNpbmc6IHsgYmFzZVVuaXQgfSxcbiAgICB9LFxuICB9OiBMb2FkaW5nSW5kaWNhdG9yUHJvcHM8T3B0aW9uLCBJc011bHRpLCBHcm91cD4sXG4gIHVuc3R5bGVkOiBib29sZWFuXG4pOiBDU1NPYmplY3RXaXRoTGFiZWwgPT4gKHtcbiAgbGFiZWw6ICdsb2FkaW5nSW5kaWNhdG9yJyxcbiAgZGlzcGxheTogJ2ZsZXgnLFxuICB0cmFuc2l0aW9uOiAnY29sb3IgMTUwbXMnLFxuICBhbGlnblNlbGY6ICdjZW50ZXInLFxuICBmb250U2l6ZTogc2l6ZSxcbiAgbGluZUhlaWdodDogMSxcbiAgbWFyZ2luUmlnaHQ6IHNpemUsXG4gIHRleHRBbGlnbjogJ2NlbnRlcicsXG4gIHZlcnRpY2FsQWxpZ246ICdtaWRkbGUnLFxuICAuLi4odW5zdHlsZWRcbiAgICA/IHt9XG4gICAgOiB7XG4gICAgICAgIGNvbG9yOiBpc0ZvY3VzZWQgPyBjb2xvcnMubmV1dHJhbDYwIDogY29sb3JzLm5ldXRyYWwyMCxcbiAgICAgICAgcGFkZGluZzogYmFzZVVuaXQgKiAyLFxuICAgICAgfSksXG59KTtcblxuaW50ZXJmYWNlIExvYWRpbmdEb3RQcm9wcyB7XG4gIGRlbGF5OiBudW1iZXI7XG4gIG9mZnNldDogYm9vbGVhbjtcbn1cbmNvbnN0IExvYWRpbmdEb3QgPSAoeyBkZWxheSwgb2Zmc2V0IH06IExvYWRpbmdEb3RQcm9wcykgPT4gKFxuICA8c3BhblxuICAgIGNzcz17e1xuICAgICAgYW5pbWF0aW9uOiBgJHtsb2FkaW5nRG90QW5pbWF0aW9uc30gMXMgZWFzZS1pbi1vdXQgJHtkZWxheX1tcyBpbmZpbml0ZTtgLFxuICAgICAgYmFja2dyb3VuZENvbG9yOiAnY3VycmVudENvbG9yJyxcbiAgICAgIGJvcmRlclJhZGl1czogJzFlbScsXG4gICAgICBkaXNwbGF5OiAnaW5saW5lLWJsb2NrJyxcbiAgICAgIG1hcmdpbkxlZnQ6IG9mZnNldCA/ICcxZW0nIDogdW5kZWZpbmVkLFxuICAgICAgaGVpZ2h0OiAnMWVtJyxcbiAgICAgIHZlcnRpY2FsQWxpZ246ICd0b3AnLFxuICAgICAgd2lkdGg6ICcxZW0nLFxuICAgIH19XG4gIC8+XG4pO1xuXG5leHBvcnQgaW50ZXJmYWNlIExvYWRpbmdJbmRpY2F0b3JQcm9wczxcbiAgT3B0aW9uID0gdW5rbm93bixcbiAgSXNNdWx0aSBleHRlbmRzIGJvb2xlYW4gPSBib29sZWFuLFxuICBHcm91cCBleHRlbmRzIEdyb3VwQmFzZTxPcHRpb24+ID0gR3JvdXBCYXNlPE9wdGlvbj5cbj4gZXh0ZW5kcyBDb21tb25Qcm9wc0FuZENsYXNzTmFtZTxPcHRpb24sIElzTXVsdGksIEdyb3VwPiB7XG4gIC8qKiBQcm9wcyB0aGF0IHdpbGwgYmUgcGFzc2VkIG9uIHRvIHRoZSBjaGlsZHJlbi4gKi9cbiAgaW5uZXJQcm9wczogSlNYLkludHJpbnNpY0VsZW1lbnRzWydkaXYnXTtcbiAgLyoqIFRoZSBmb2N1c2VkIHN0YXRlIG9mIHRoZSBzZWxlY3QuICovXG4gIGlzRm9jdXNlZDogYm9vbGVhbjtcbiAgaXNEaXNhYmxlZDogYm9vbGVhbjtcbiAgLyoqIFNldCBzaXplIG9mIHRoZSBjb250YWluZXIuICovXG4gIHNpemU6IG51bWJlcjtcbn1cbmV4cG9ydCBjb25zdCBMb2FkaW5nSW5kaWNhdG9yID0gPFxuICBPcHRpb24sXG4gIElzTXVsdGkgZXh0ZW5kcyBib29sZWFuLFxuICBHcm91cCBleHRlbmRzIEdyb3VwQmFzZTxPcHRpb24+XG4+KHtcbiAgaW5uZXJQcm9wcyxcbiAgaXNSdGwsXG4gIHNpemUgPSA0LFxuICAuLi5yZXN0UHJvcHNcbn06IExvYWRpbmdJbmRpY2F0b3JQcm9wczxPcHRpb24sIElzTXVsdGksIEdyb3VwPikgPT4ge1xuICByZXR1cm4gKFxuICAgIDxkaXZcbiAgICAgIHsuLi5nZXRTdHlsZVByb3BzKFxuICAgICAgICB7IC4uLnJlc3RQcm9wcywgaW5uZXJQcm9wcywgaXNSdGwsIHNpemUgfSxcbiAgICAgICAgJ2xvYWRpbmdJbmRpY2F0b3InLFxuICAgICAgICB7XG4gICAgICAgICAgaW5kaWNhdG9yOiB0cnVlLFxuICAgICAgICAgICdsb2FkaW5nLWluZGljYXRvcic6IHRydWUsXG4gICAgICAgIH1cbiAgICAgICl9XG4gICAgICB7Li4uaW5uZXJQcm9wc31cbiAgICA+XG4gICAgICA8TG9hZGluZ0RvdCBkZWxheT17MH0gb2Zmc2V0PXtpc1J0bH0gLz5cbiAgICAgIDxMb2FkaW5nRG90IGRlbGF5PXsxNjB9IG9mZnNldCAvPlxuICAgICAgPExvYWRpbmdEb3QgZGVsYXk9ezMyMH0gb2Zmc2V0PXshaXNSdGx9IC8+XG4gICAgPC9kaXY+XG4gICk7XG59O1xuIl19 */",
  toString: YS
}, Sp = function(n) {
  var u = n.size, t = ne(n, XS);
  return Il("svg", El({
    height: u,
    width: u,
    viewBox: "0 0 20 20",
    "aria-hidden": "true",
    focusable: "false",
    css: US
  }, t));
}, Hc = function(n) {
  return Il(Sp, El({
    size: 20
  }, n), Il("path", {
    d: "M14.348 14.849c-0.469 0.469-1.229 0.469-1.697 0l-2.651-3.030-2.651 3.029c-0.469 0.469-1.229 0.469-1.697 0-0.469-0.469-0.469-1.229 0-1.697l2.758-3.15-2.759-3.152c-0.469-0.469-0.469-1.228 0-1.697s1.228-0.469 1.697 0l2.652 3.031 2.651-3.031c0.469-0.469 1.228-0.469 1.697 0s0.469 1.229 0 1.697l-2.758 3.152 2.758 3.15c0.469 0.469 0.469 1.229 0 1.698z"
  }));
}, Pp = function(n) {
  return Il(Sp, El({
    size: 20
  }, n), Il("path", {
    d: "M4.516 7.548c0.436-0.446 1.043-0.481 1.576 0l3.908 3.747 3.908-3.747c0.533-0.481 1.141-0.446 1.574 0 0.436 0.445 0.408 1.197 0 1.615-0.406 0.418-4.695 4.502-4.695 4.502-0.217 0.223-0.502 0.335-0.787 0.335s-0.57-0.112-0.789-0.335c0 0-4.287-4.084-4.695-4.502s-0.436-1.17 0-1.615z"
  }));
}, Np = function(n, u) {
  var t = n.isFocused, r = n.theme, o = r.spacing.baseUnit, s = r.colors;
  return yl({
    label: "indicatorContainer",
    display: "flex",
    transition: "color 150ms"
  }, u ? {} : {
    color: t ? s.neutral60 : s.neutral20,
    padding: o * 2,
    ":hover": {
      color: t ? s.neutral80 : s.neutral40
    }
  });
}, JS = Np, KS = function(n) {
  var u = n.children, t = n.innerProps;
  return Il("div", El({}, Nn(n, "dropdownIndicator", {
    indicator: !0,
    "dropdown-indicator": !0
  }), t), u || Il(Pp, null));
}, QS = Np, qS = function(n) {
  var u = n.children, t = n.innerProps;
  return Il("div", El({}, Nn(n, "clearIndicator", {
    indicator: !0,
    "clear-indicator": !0
  }), t), u || Il(Hc, null));
}, lP = function(n, u) {
  var t = n.isDisabled, r = n.theme, o = r.spacing.baseUnit, s = r.colors;
  return yl({
    label: "indicatorSeparator",
    alignSelf: "stretch",
    width: 1
  }, u ? {} : {
    backgroundColor: t ? s.neutral10 : s.neutral20,
    marginBottom: o * 2,
    marginTop: o * 2
  });
}, nP = function(n) {
  var u = n.innerProps;
  return Il("span", El({}, u, Nn(n, "indicatorSeparator", {
    "indicator-separator": !0
  })));
}, uP = eS(n3 || (n3 = sS([`
  0%, 80%, 100% { opacity: 0; }
  40% { opacity: 1; }
`]))), eP = function(n, u) {
  var t = n.isFocused, r = n.size, o = n.theme, s = o.colors, d = o.spacing.baseUnit;
  return yl({
    label: "loadingIndicator",
    display: "flex",
    transition: "color 150ms",
    alignSelf: "center",
    fontSize: r,
    lineHeight: 1,
    marginRight: r,
    textAlign: "center",
    verticalAlign: "middle"
  }, u ? {} : {
    color: t ? s.neutral60 : s.neutral20,
    padding: d * 2
  });
}, id = function(n) {
  var u = n.delay, t = n.offset;
  return Il("span", {
    css: /* @__PURE__ */ kc({
      animation: "".concat(uP, " 1s ease-in-out ").concat(u, "ms infinite;"),
      backgroundColor: "currentColor",
      borderRadius: "1em",
      display: "inline-block",
      marginLeft: t ? "1em" : void 0,
      height: "1em",
      verticalAlign: "top",
      width: "1em"
    },  false ? 0 : ";label:LoadingDot;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
  });
}, tP = function(n) {
  var u = n.innerProps, t = n.isRtl, r = n.size, o = r === void 0 ? 4 : r, s = ne(n, zS);
  return Il("div", El({}, Nn(yl(yl({}, s), {}, {
    innerProps: u,
    isRtl: t,
    size: o
  }), "loadingIndicator", {
    indicator: !0,
    "loading-indicator": !0
  }), u), Il(id, {
    delay: 0,
    offset: t
  }), Il(id, {
    delay: 160,
    offset: !0
  }), Il(id, {
    delay: 320,
    offset: !t
  }));
}, rP = function(n, u) {
  var t = n.isDisabled, r = n.isFocused, o = n.theme, s = o.colors, d = o.borderRadius, a = o.spacing;
  return yl({
    label: "control",
    alignItems: "center",
    cursor: "default",
    display: "flex",
    flexWrap: "wrap",
    justifyContent: "space-between",
    minHeight: a.controlHeight,
    outline: "0 !important",
    position: "relative",
    transition: "all 100ms"
  }, u ? {} : {
    backgroundColor: t ? s.neutral5 : s.neutral0,
    borderColor: t ? s.neutral10 : r ? s.primary : s.neutral20,
    borderRadius: d,
    borderStyle: "solid",
    borderWidth: 1,
    boxShadow: r ? "0 0 0 1px ".concat(s.primary) : void 0,
    "&:hover": {
      borderColor: r ? s.primary : s.neutral30
    }
  });
}, iP = function(n) {
  var u = n.children, t = n.isDisabled, r = n.isFocused, o = n.innerRef, s = n.innerProps, d = n.menuIsOpen;
  return Il("div", El({
    ref: o
  }, Nn(n, "control", {
    control: !0,
    "control--is-disabled": t,
    "control--is-focused": r,
    "control--menu-is-open": d
  }), s, {
    "aria-disabled": t || void 0
  }), u);
}, oP = iP, aP = ["data"], sP = function(n, u) {
  var t = n.theme.spacing;
  return u ? {} : {
    paddingBottom: t.baseUnit * 2,
    paddingTop: t.baseUnit * 2
  };
}, dP = function(n) {
  var u = n.children, t = n.cx, r = n.getStyles, o = n.getClassNames, s = n.Heading, d = n.headingProps, a = n.innerProps, c = n.label, p = n.theme, g = n.selectProps;
  return Il("div", El({}, Nn(n, "group", {
    group: !0
  }), a), Il(s, El({}, d, {
    selectProps: g,
    theme: p,
    getStyles: r,
    getClassNames: o,
    cx: t
  }), c), Il("div", null, u));
}, cP = function(n, u) {
  var t = n.theme, r = t.colors, o = t.spacing;
  return yl({
    label: "group",
    cursor: "default",
    display: "block"
  }, u ? {} : {
    color: r.neutral40,
    fontSize: "75%",
    fontWeight: 500,
    marginBottom: "0.25em",
    paddingLeft: o.baseUnit * 3,
    paddingRight: o.baseUnit * 3,
    textTransform: "uppercase"
  });
}, fP = function(n) {
  var u = xp(n);
  u.data;
  var t = ne(u, aP);
  return Il("div", El({}, Nn(n, "groupHeading", {
    "group-heading": !0
  }), t));
}, pP = dP, gP = ["innerRef", "isDisabled", "isHidden", "inputClassName"], hP = function(n, u) {
  var t = n.isDisabled, r = n.value, o = n.theme, s = o.spacing, d = o.colors;
  return yl(yl({
    visibility: t ? "hidden" : "visible",
    // force css to recompute when value change due to @emotion bug.
    // We can remove it whenever the bug is fixed.
    transform: r ? "translateZ(0)" : ""
  }, mP), u ? {} : {
    margin: s.baseUnit / 2,
    paddingBottom: s.baseUnit / 2,
    paddingTop: s.baseUnit / 2,
    color: d.neutral80
  });
}, Tp = {
  gridArea: "1 / 2",
  font: "inherit",
  minWidth: "2px",
  border: 0,
  margin: 0,
  outline: 0,
  padding: 0
}, mP = {
  flex: "1 1 auto",
  display: "inline-grid",
  gridArea: "1 / 1 / 2 / 3",
  gridTemplateColumns: "0 min-content",
  "&:after": yl({
    content: 'attr(data-value) " "',
    visibility: "hidden",
    whiteSpace: "pre"
  }, Tp)
}, vP = function(n) {
  return yl({
    label: "input",
    color: "inherit",
    background: 0,
    opacity: n ? 0 : 1,
    width: "100%"
  }, Tp);
}, bP = function(n) {
  var u = n.cx, t = n.value, r = xp(n), o = r.innerRef, s = r.isDisabled, d = r.isHidden, a = r.inputClassName, c = ne(r, gP);
  return Il("div", El({}, Nn(n, "input", {
    "input-container": !0
  }), {
    "data-value": t || ""
  }), Il("input", El({
    className: u({
      input: !0
    }, a),
    ref: o,
    style: vP(d),
    disabled: s
  }, c)));
}, yP = bP, $P = function(n, u) {
  var t = n.theme, r = t.spacing, o = t.borderRadius, s = t.colors;
  return yl({
    label: "multiValue",
    display: "flex",
    minWidth: 0
  }, u ? {} : {
    backgroundColor: s.neutral10,
    borderRadius: o / 2,
    margin: r.baseUnit / 2
  });
}, xP = function(n, u) {
  var t = n.theme, r = t.borderRadius, o = t.colors, s = n.cropWithEllipsis;
  return yl({
    overflow: "hidden",
    textOverflow: s || s === void 0 ? "ellipsis" : void 0,
    whiteSpace: "nowrap"
  }, u ? {} : {
    borderRadius: r / 2,
    color: o.neutral80,
    fontSize: "85%",
    padding: 3,
    paddingLeft: 6
  });
}, CP = function(n, u) {
  var t = n.theme, r = t.spacing, o = t.borderRadius, s = t.colors, d = n.isFocused;
  return yl({
    alignItems: "center",
    display: "flex"
  }, u ? {} : {
    borderRadius: o / 2,
    backgroundColor: d ? s.dangerLight : void 0,
    paddingLeft: r.baseUnit,
    paddingRight: r.baseUnit,
    ":hover": {
      backgroundColor: s.dangerLight,
      color: s.danger
    }
  });
}, Rp = function(n) {
  var u = n.children, t = n.innerProps;
  return Il("div", t, u);
}, wP = Rp, IP = Rp;
function EP(l) {
  var n = l.children, u = l.innerProps;
  return Il("div", El({
    role: "button"
  }, u), n || Il(Hc, {
    size: 14
  }));
}
var AP = function(n) {
  var u = n.children, t = n.components, r = n.data, o = n.innerProps, s = n.isDisabled, d = n.removeProps, a = n.selectProps, c = t.Container, p = t.Label, g = t.Remove;
  return Il(c, {
    data: r,
    innerProps: yl(yl({}, Nn(n, "multiValue", {
      "multi-value": !0,
      "multi-value--is-disabled": s
    })), o),
    selectProps: a
  }, Il(p, {
    data: r,
    innerProps: yl({}, Nn(n, "multiValueLabel", {
      "multi-value__label": !0
    })),
    selectProps: a
  }, u), Il(g, {
    data: r,
    innerProps: yl(yl({}, Nn(n, "multiValueRemove", {
      "multi-value__remove": !0
    })), {}, {
      "aria-label": "Remove ".concat(u || "option")
    }, d),
    selectProps: a
  }));
}, SP = AP, PP = function(n, u) {
  var t = n.isDisabled, r = n.isFocused, o = n.isSelected, s = n.theme, d = s.spacing, a = s.colors;
  return yl({
    label: "option",
    cursor: "default",
    display: "block",
    fontSize: "inherit",
    width: "100%",
    userSelect: "none",
    WebkitTapHighlightColor: "rgba(0, 0, 0, 0)"
  }, u ? {} : {
    backgroundColor: o ? a.primary : r ? a.primary25 : "transparent",
    color: t ? a.neutral20 : o ? a.neutral0 : "inherit",
    padding: "".concat(d.baseUnit * 2, "px ").concat(d.baseUnit * 3, "px"),
    // provide some affordance on touch devices
    ":active": {
      backgroundColor: t ? void 0 : o ? a.primary : a.primary50
    }
  });
}, NP = function(n) {
  var u = n.children, t = n.isDisabled, r = n.isFocused, o = n.isSelected, s = n.innerRef, d = n.innerProps;
  return Il("div", El({}, Nn(n, "option", {
    option: !0,
    "option--is-disabled": t,
    "option--is-focused": r,
    "option--is-selected": o
  }), {
    ref: s,
    "aria-disabled": t
  }, d), u);
}, TP = NP, RP = function(n, u) {
  var t = n.theme, r = t.spacing, o = t.colors;
  return yl({
    label: "placeholder",
    gridArea: "1 / 1 / 2 / 3"
  }, u ? {} : {
    color: o.neutral50,
    marginLeft: r.baseUnit / 2,
    marginRight: r.baseUnit / 2
  });
}, OP = function(n) {
  var u = n.children, t = n.innerProps;
  return Il("div", El({}, Nn(n, "placeholder", {
    placeholder: !0
  }), t), u);
}, FP = OP, _P = function(n, u) {
  var t = n.isDisabled, r = n.theme, o = r.spacing, s = r.colors;
  return yl({
    label: "singleValue",
    gridArea: "1 / 1 / 2 / 3",
    maxWidth: "100%",
    overflow: "hidden",
    textOverflow: "ellipsis",
    whiteSpace: "nowrap"
  }, u ? {} : {
    color: t ? s.neutral40 : s.neutral80,
    marginLeft: o.baseUnit / 2,
    marginRight: o.baseUnit / 2
  });
}, DP = function(n) {
  var u = n.children, t = n.isDisabled, r = n.innerProps;
  return Il("div", El({}, Nn(n, "singleValue", {
    "single-value": !0,
    "single-value--is-disabled": t
  }), r), u);
}, MP = DP, Zc = {
  ClearIndicator: qS,
  Control: oP,
  DropdownIndicator: KS,
  DownChevron: Pp,
  CrossIcon: Hc,
  Group: pP,
  GroupHeading: fP,
  IndicatorsContainer: ZS,
  IndicatorSeparator: nP,
  Input: yP,
  LoadingIndicator: tP,
  Menu: RS,
  MenuList: FS,
  MenuPortal: GS,
  LoadingMessage: BS,
  NoOptionsMessage: MS,
  MultiValue: SP,
  MultiValueContainer: wP,
  MultiValueLabel: IP,
  MultiValueRemove: EP,
  Option: TP,
  Placeholder: FP,
  SelectContainer: WS,
  SingleValue: MP,
  ValueContainer: kS
}, BP = function(n) {
  return yl(yl({}, Zc), n.components);
}, u3 = Number.isNaN || function(n) {
  return typeof n == "number" && n !== n;
};
function LP(l, n) {
  return !!(l === n || u3(l) && u3(n));
}
function GP(l, n) {
  if (l.length !== n.length)
    return !1;
  for (var u = 0; u < l.length; u++)
    if (!LP(l[u], n[u]))
      return !1;
  return !0;
}
function jP(l, n) {
  n === void 0 && (n = GP);
  var u = null;
  function t() {
    for (var r = [], o = 0; o < arguments.length; o++)
      r[o] = arguments[o];
    if (u && u.lastThis === this && n(r, u.lastArgs))
      return u.lastResult;
    var s = l.apply(this, r);
    return u = {
      lastResult: s,
      lastArgs: r,
      lastThis: this
    }, s;
  }
  return t.clear = function() {
    u = null;
  }, t;
}
function WP() {
  return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
}
var VP =  false ? 0 : {
  name: "1f43avz-a11yText-A11yText",
  styles: "label:a11yText;z-index:9999;border:0;clip:rect(1px, 1px, 1px, 1px);height:1px;width:1px;position:absolute;overflow:hidden;padding:0;white-space:nowrap;label:A11yText;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkExMXlUZXh0LnRzeCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFNSSIsImZpbGUiOiJBMTF5VGV4dC50c3giLCJzb3VyY2VzQ29udGVudCI6WyIvKiogQGpzeCBqc3ggKi9cbmltcG9ydCB7IGpzeCB9IGZyb20gJ0BlbW90aW9uL3JlYWN0JztcblxuLy8gQXNzaXN0aXZlIHRleHQgdG8gZGVzY3JpYmUgdmlzdWFsIGVsZW1lbnRzLiBIaWRkZW4gZm9yIHNpZ2h0ZWQgdXNlcnMuXG5jb25zdCBBMTF5VGV4dCA9IChwcm9wczogSlNYLkludHJpbnNpY0VsZW1lbnRzWydzcGFuJ10pID0+IChcbiAgPHNwYW5cbiAgICBjc3M9e3tcbiAgICAgIGxhYmVsOiAnYTExeVRleHQnLFxuICAgICAgekluZGV4OiA5OTk5LFxuICAgICAgYm9yZGVyOiAwLFxuICAgICAgY2xpcDogJ3JlY3QoMXB4LCAxcHgsIDFweCwgMXB4KScsXG4gICAgICBoZWlnaHQ6IDEsXG4gICAgICB3aWR0aDogMSxcbiAgICAgIHBvc2l0aW9uOiAnYWJzb2x1dGUnLFxuICAgICAgb3ZlcmZsb3c6ICdoaWRkZW4nLFxuICAgICAgcGFkZGluZzogMCxcbiAgICAgIHdoaXRlU3BhY2U6ICdub3dyYXAnLFxuICAgIH19XG4gICAgey4uLnByb3BzfVxuICAvPlxuKTtcblxuZXhwb3J0IGRlZmF1bHQgQTExeVRleHQ7XG4iXX0= */",
  toString: WP
}, kP = function(n) {
  return Il("span", El({
    css: VP
  }, n));
}, e3 = kP, HP = {
  guidance: function(n) {
    var u = n.isSearchable, t = n.isMulti, r = n.tabSelectsValue, o = n.context, s = n.isInitialFocus;
    switch (o) {
      case "menu":
        return "Use Up and Down to choose options, press Enter to select the currently focused option, press Escape to exit the menu".concat(r ? ", press Tab to select the option and exit the menu" : "", ".");
      case "input":
        return s ? "".concat(n["aria-label"] || "Select", " is focused ").concat(u ? ",type to refine list" : "", ", press Down to open the menu, ").concat(t ? " press left to focus selected values" : "") : "";
      case "value":
        return "Use left and right to toggle between focused values, press Backspace to remove the currently focused value";
      default:
        return "";
    }
  },
  onChange: function(n) {
    var u = n.action, t = n.label, r = t === void 0 ? "" : t, o = n.labels, s = n.isDisabled;
    switch (u) {
      case "deselect-option":
      case "pop-value":
      case "remove-value":
        return "option ".concat(r, ", deselected.");
      case "clear":
        return "All selected options have been cleared.";
      case "initial-input-focus":
        return "option".concat(o.length > 1 ? "s" : "", " ").concat(o.join(","), ", selected.");
      case "select-option":
        return s ? "option ".concat(r, " is disabled. Select another option.") : "option ".concat(r, ", selected.");
      default:
        return "";
    }
  },
  onFocus: function(n) {
    var u = n.context, t = n.focused, r = n.options, o = n.label, s = o === void 0 ? "" : o, d = n.selectValue, a = n.isDisabled, c = n.isSelected, p = n.isAppleDevice, g = function(b, E) {
      return b && b.length ? "".concat(b.indexOf(E) + 1, " of ").concat(b.length) : "";
    };
    if (u === "value" && d)
      return "value ".concat(s, " focused, ").concat(g(d, t), ".");
    if (u === "menu" && p) {
      var m = a ? " disabled" : "", v = "".concat(c ? " selected" : "").concat(m);
      return "".concat(s).concat(v, ", ").concat(g(r, t), ".");
    }
    return "";
  },
  onFilter: function(n) {
    var u = n.inputValue, t = n.resultsMessage;
    return "".concat(t).concat(u ? " for search term " + u : "", ".");
  }
}, ZP = function(n) {
  var u = n.ariaSelection, t = n.focusedOption, r = n.focusedValue, o = n.focusableOptions, s = n.isFocused, d = n.selectValue, a = n.selectProps, c = n.id, p = n.isAppleDevice, g = a.ariaLiveMessages, m = a.getOptionLabel, v = a.inputValue, $ = a.isMulti, b = a.isOptionDisabled, E = a.isSearchable, S = a.menuIsOpen, A = a.options, x = a.screenReaderStatus, I = a.tabSelectsValue, P = a.isLoading, O = a["aria-label"], _ = a["aria-live"], j = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    return yl(yl({}, HP), g || {});
  }, [g]), z = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    var rl = "";
    if (u && j.onChange) {
      var tl = u.option, sl = u.options, ll = u.removedValue, H = u.removedValues, V = u.value, X = function(ml) {
        return Array.isArray(ml) ? null : ml;
      }, dl = ll || tl || X(V), fl = dl ? m(dl) : "", $l = sl || H || void 0, cl = $l ? $l.map(m) : [], xl = yl({
        // multiSelected items are usually items that have already been selected
        // or set by the user as a default value so we assume they are not disabled
        isDisabled: dl && b(dl, d),
        label: fl,
        labels: cl
      }, u);
      rl = j.onChange(xl);
    }
    return rl;
  }, [u, j, b, d, m]), Y = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    var rl = "", tl = t || r, sl = !!(t && d && d.includes(t));
    if (tl && j.onFocus) {
      var ll = {
        focused: tl,
        label: m(tl),
        isDisabled: b(tl, d),
        isSelected: sl,
        options: o,
        context: tl === t ? "menu" : "value",
        selectValue: d,
        isAppleDevice: p
      };
      rl = j.onFocus(ll);
    }
    return rl;
  }, [t, r, m, b, j, o, d, p]), el = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    var rl = "";
    if (S && A.length && !P && j.onFilter) {
      var tl = x({
        count: o.length
      });
      rl = j.onFilter({
        inputValue: v,
        resultsMessage: tl
      });
    }
    return rl;
  }, [o, v, S, j, A, x, P]), U = (u == null ? void 0 : u.action) === "initial-input-focus", ul = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    var rl = "";
    if (j.guidance) {
      var tl = r ? "value" : S ? "menu" : "input";
      rl = j.guidance({
        "aria-label": O,
        context: tl,
        isDisabled: t && b(t, d),
        isMulti: $,
        isSearchable: E,
        tabSelectsValue: I,
        isInitialFocus: U
      });
    }
    return rl;
  }, [O, t, r, $, b, E, S, j, d, I, U]), il = Il(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, Il("span", {
    id: "aria-selection"
  }, z), Il("span", {
    id: "aria-focused"
  }, Y), Il("span", {
    id: "aria-results"
  }, el), Il("span", {
    id: "aria-guidance"
  }, ul));
  return Il(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, Il(e3, {
    id: c
  }, U && il), Il(e3, {
    "aria-live": _,
    "aria-atomic": "false",
    "aria-relevant": "additions text",
    role: "log"
  }, s && !U && il));
}, XP = ZP, Yd = [{
  base: "A",
  letters: "AⒶＡÀÁÂẦẤẪẨÃĀĂẰẮẴẲȦǠÄǞẢÅǺǍȀȂẠẬẶḀĄȺⱯ"
}, {
  base: "AA",
  letters: "Ꜳ"
}, {
  base: "AE",
  letters: "ÆǼǢ"
}, {
  base: "AO",
  letters: "Ꜵ"
}, {
  base: "AU",
  letters: "Ꜷ"
}, {
  base: "AV",
  letters: "ꜸꜺ"
}, {
  base: "AY",
  letters: "Ꜽ"
}, {
  base: "B",
  letters: "BⒷＢḂḄḆɃƂƁ"
}, {
  base: "C",
  letters: "CⒸＣĆĈĊČÇḈƇȻꜾ"
}, {
  base: "D",
  letters: "DⒹＤḊĎḌḐḒḎĐƋƊƉꝹ"
}, {
  base: "DZ",
  letters: "ǱǄ"
}, {
  base: "Dz",
  letters: "ǲǅ"
}, {
  base: "E",
  letters: "EⒺＥÈÉÊỀẾỄỂẼĒḔḖĔĖËẺĚȄȆẸỆȨḜĘḘḚƐƎ"
}, {
  base: "F",
  letters: "FⒻＦḞƑꝻ"
}, {
  base: "G",
  letters: "GⒼＧǴĜḠĞĠǦĢǤƓꞠꝽꝾ"
}, {
  base: "H",
  letters: "HⒽＨĤḢḦȞḤḨḪĦⱧⱵꞍ"
}, {
  base: "I",
  letters: "IⒾＩÌÍÎĨĪĬİÏḮỈǏȈȊỊĮḬƗ"
}, {
  base: "J",
  letters: "JⒿＪĴɈ"
}, {
  base: "K",
  letters: "KⓀＫḰǨḲĶḴƘⱩꝀꝂꝄꞢ"
}, {
  base: "L",
  letters: "LⓁＬĿĹĽḶḸĻḼḺŁȽⱢⱠꝈꝆꞀ"
}, {
  base: "LJ",
  letters: "Ǉ"
}, {
  base: "Lj",
  letters: "ǈ"
}, {
  base: "M",
  letters: "MⓂＭḾṀṂⱮƜ"
}, {
  base: "N",
  letters: "NⓃＮǸŃÑṄŇṆŅṊṈȠƝꞐꞤ"
}, {
  base: "NJ",
  letters: "Ǌ"
}, {
  base: "Nj",
  letters: "ǋ"
}, {
  base: "O",
  letters: "OⓄＯÒÓÔỒỐỖỔÕṌȬṎŌṐṒŎȮȰÖȪỎŐǑȌȎƠỜỚỠỞỢỌỘǪǬØǾƆƟꝊꝌ"
}, {
  base: "OI",
  letters: "Ƣ"
}, {
  base: "OO",
  letters: "Ꝏ"
}, {
  base: "OU",
  letters: "Ȣ"
}, {
  base: "P",
  letters: "PⓅＰṔṖƤⱣꝐꝒꝔ"
}, {
  base: "Q",
  letters: "QⓆＱꝖꝘɊ"
}, {
  base: "R",
  letters: "RⓇＲŔṘŘȐȒṚṜŖṞɌⱤꝚꞦꞂ"
}, {
  base: "S",
  letters: "SⓈＳẞŚṤŜṠŠṦṢṨȘŞⱾꞨꞄ"
}, {
  base: "T",
  letters: "TⓉＴṪŤṬȚŢṰṮŦƬƮȾꞆ"
}, {
  base: "TZ",
  letters: "Ꜩ"
}, {
  base: "U",
  letters: "UⓊＵÙÚÛŨṸŪṺŬÜǛǗǕǙỦŮŰǓȔȖƯỪỨỮỬỰỤṲŲṶṴɄ"
}, {
  base: "V",
  letters: "VⓋＶṼṾƲꝞɅ"
}, {
  base: "VY",
  letters: "Ꝡ"
}, {
  base: "W",
  letters: "WⓌＷẀẂŴẆẄẈⱲ"
}, {
  base: "X",
  letters: "XⓍＸẊẌ"
}, {
  base: "Y",
  letters: "YⓎＹỲÝŶỸȲẎŸỶỴƳɎỾ"
}, {
  base: "Z",
  letters: "ZⓏＺŹẐŻŽẒẔƵȤⱿⱫꝢ"
}, {
  base: "a",
  letters: "aⓐａẚàáâầấẫẩãāăằắẵẳȧǡäǟảåǻǎȁȃạậặḁąⱥɐ"
}, {
  base: "aa",
  letters: "ꜳ"
}, {
  base: "ae",
  letters: "æǽǣ"
}, {
  base: "ao",
  letters: "ꜵ"
}, {
  base: "au",
  letters: "ꜷ"
}, {
  base: "av",
  letters: "ꜹꜻ"
}, {
  base: "ay",
  letters: "ꜽ"
}, {
  base: "b",
  letters: "bⓑｂḃḅḇƀƃɓ"
}, {
  base: "c",
  letters: "cⓒｃćĉċčçḉƈȼꜿↄ"
}, {
  base: "d",
  letters: "dⓓｄḋďḍḑḓḏđƌɖɗꝺ"
}, {
  base: "dz",
  letters: "ǳǆ"
}, {
  base: "e",
  letters: "eⓔｅèéêềếễểẽēḕḗĕėëẻěȅȇẹệȩḝęḙḛɇɛǝ"
}, {
  base: "f",
  letters: "fⓕｆḟƒꝼ"
}, {
  base: "g",
  letters: "gⓖｇǵĝḡğġǧģǥɠꞡᵹꝿ"
}, {
  base: "h",
  letters: "hⓗｈĥḣḧȟḥḩḫẖħⱨⱶɥ"
}, {
  base: "hv",
  letters: "ƕ"
}, {
  base: "i",
  letters: "iⓘｉìíîĩīĭïḯỉǐȉȋịįḭɨı"
}, {
  base: "j",
  letters: "jⓙｊĵǰɉ"
}, {
  base: "k",
  letters: "kⓚｋḱǩḳķḵƙⱪꝁꝃꝅꞣ"
}, {
  base: "l",
  letters: "lⓛｌŀĺľḷḹļḽḻſłƚɫⱡꝉꞁꝇ"
}, {
  base: "lj",
  letters: "ǉ"
}, {
  base: "m",
  letters: "mⓜｍḿṁṃɱɯ"
}, {
  base: "n",
  letters: "nⓝｎǹńñṅňṇņṋṉƞɲŉꞑꞥ"
}, {
  base: "nj",
  letters: "ǌ"
}, {
  base: "o",
  letters: "oⓞｏòóôồốỗổõṍȭṏōṑṓŏȯȱöȫỏőǒȍȏơờớỡởợọộǫǭøǿɔꝋꝍɵ"
}, {
  base: "oi",
  letters: "ƣ"
}, {
  base: "ou",
  letters: "ȣ"
}, {
  base: "oo",
  letters: "ꝏ"
}, {
  base: "p",
  letters: "pⓟｐṕṗƥᵽꝑꝓꝕ"
}, {
  base: "q",
  letters: "qⓠｑɋꝗꝙ"
}, {
  base: "r",
  letters: "rⓡｒŕṙřȑȓṛṝŗṟɍɽꝛꞧꞃ"
}, {
  base: "s",
  letters: "sⓢｓßśṥŝṡšṧṣṩșşȿꞩꞅẛ"
}, {
  base: "t",
  letters: "tⓣｔṫẗťṭțţṱṯŧƭʈⱦꞇ"
}, {
  base: "tz",
  letters: "ꜩ"
}, {
  base: "u",
  letters: "uⓤｕùúûũṹūṻŭüǜǘǖǚủůűǔȕȗưừứữửựụṳųṷṵʉ"
}, {
  base: "v",
  letters: "vⓥｖṽṿʋꝟʌ"
}, {
  base: "vy",
  letters: "ꝡ"
}, {
  base: "w",
  letters: "wⓦｗẁẃŵẇẅẘẉⱳ"
}, {
  base: "x",
  letters: "xⓧｘẋẍ"
}, {
  base: "y",
  letters: "yⓨｙỳýŷỹȳẏÿỷẙỵƴɏỿ"
}, {
  base: "z",
  letters: "zⓩｚźẑżžẓẕƶȥɀⱬꝣ"
}], zP = new RegExp("[" + Yd.map(function(l) {
  return l.letters;
}).join("") + "]", "g"), Op = {};
for (var od = 0; od < Yd.length; od++)
  for (var ad = Yd[od], sd = 0; sd < ad.letters.length; sd++)
    Op[ad.letters[sd]] = ad.base;
var Fp = function(n) {
  return n.replace(zP, function(u) {
    return Op[u];
  });
}, YP = jP(Fp), t3 = function(n) {
  return n.replace(/^\s+|\s+$/g, "");
}, UP = function(n) {
  return "".concat(n.label, " ").concat(n.value);
}, _p = function(n) {
  return function(u, t) {
    if (u.data.__isNew__) return !0;
    var r = yl({
      ignoreCase: !0,
      ignoreAccents: !0,
      stringify: UP,
      trim: !0,
      matchFrom: "any"
    }, n), o = r.ignoreCase, s = r.ignoreAccents, d = r.stringify, a = r.trim, c = r.matchFrom, p = a ? t3(t) : t, g = a ? t3(d(u)) : d(u);
    return o && (p = p.toLowerCase(), g = g.toLowerCase()), s && (p = YP(p), g = Fp(g)), c === "start" ? g.substr(0, p.length) === p : g.indexOf(p) > -1;
  };
}, JP = ["innerRef"];
function KP(l) {
  var n = l.innerRef, u = ne(l, JP), t = wS(u, "onExited", "in", "enter", "exit", "appear");
  return Il("input", El({
    ref: n
  }, t, {
    css: /* @__PURE__ */ kc({
      label: "dummyInput",
      // get rid of any default styles
      background: 0,
      border: 0,
      // important! this hides the flashing cursor
      caretColor: "transparent",
      fontSize: "inherit",
      gridArea: "1 / 1 / 2 / 3",
      outline: 0,
      padding: 0,
      // important! without `width` browsers won't allow focus
      width: 1,
      // remove cursor on desktop
      color: "transparent",
      // remove cursor on mobile whilst maintaining "scroll into view" behaviour
      left: -100,
      opacity: 0,
      position: "relative",
      transform: "scale(.01)"
    },  false ? 0 : ";label:DummyInput;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkR1bW15SW5wdXQudHN4Il0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQXlCTSIsImZpbGUiOiJEdW1teUlucHV0LnRzeCIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAanN4IGpzeCAqL1xuaW1wb3J0IHsgUmVmIH0gZnJvbSAncmVhY3QnO1xuaW1wb3J0IHsganN4IH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuaW1wb3J0IHsgcmVtb3ZlUHJvcHMgfSBmcm9tICcuLi91dGlscyc7XG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIER1bW15SW5wdXQoe1xuICBpbm5lclJlZixcbiAgLi4ucHJvcHNcbn06IEpTWC5JbnRyaW5zaWNFbGVtZW50c1snaW5wdXQnXSAmIHtcbiAgcmVhZG9ubHkgaW5uZXJSZWY6IFJlZjxIVE1MSW5wdXRFbGVtZW50Pjtcbn0pIHtcbiAgLy8gUmVtb3ZlIGFuaW1hdGlvbiBwcm9wcyBub3QgbWVhbnQgZm9yIEhUTUwgZWxlbWVudHNcbiAgY29uc3QgZmlsdGVyZWRQcm9wcyA9IHJlbW92ZVByb3BzKFxuICAgIHByb3BzLFxuICAgICdvbkV4aXRlZCcsXG4gICAgJ2luJyxcbiAgICAnZW50ZXInLFxuICAgICdleGl0JyxcbiAgICAnYXBwZWFyJ1xuICApO1xuXG4gIHJldHVybiAoXG4gICAgPGlucHV0XG4gICAgICByZWY9e2lubmVyUmVmfVxuICAgICAgey4uLmZpbHRlcmVkUHJvcHN9XG4gICAgICBjc3M9e3tcbiAgICAgICAgbGFiZWw6ICdkdW1teUlucHV0JyxcbiAgICAgICAgLy8gZ2V0IHJpZCBvZiBhbnkgZGVmYXVsdCBzdHlsZXNcbiAgICAgICAgYmFja2dyb3VuZDogMCxcbiAgICAgICAgYm9yZGVyOiAwLFxuICAgICAgICAvLyBpbXBvcnRhbnQhIHRoaXMgaGlkZXMgdGhlIGZsYXNoaW5nIGN1cnNvclxuICAgICAgICBjYXJldENvbG9yOiAndHJhbnNwYXJlbnQnLFxuICAgICAgICBmb250U2l6ZTogJ2luaGVyaXQnLFxuICAgICAgICBncmlkQXJlYTogJzEgLyAxIC8gMiAvIDMnLFxuICAgICAgICBvdXRsaW5lOiAwLFxuICAgICAgICBwYWRkaW5nOiAwLFxuICAgICAgICAvLyBpbXBvcnRhbnQhIHdpdGhvdXQgYHdpZHRoYCBicm93c2VycyB3b24ndCBhbGxvdyBmb2N1c1xuICAgICAgICB3aWR0aDogMSxcblxuICAgICAgICAvLyByZW1vdmUgY3Vyc29yIG9uIGRlc2t0b3BcbiAgICAgICAgY29sb3I6ICd0cmFuc3BhcmVudCcsXG5cbiAgICAgICAgLy8gcmVtb3ZlIGN1cnNvciBvbiBtb2JpbGUgd2hpbHN0IG1haW50YWluaW5nIFwic2Nyb2xsIGludG8gdmlld1wiIGJlaGF2aW91clxuICAgICAgICBsZWZ0OiAtMTAwLFxuICAgICAgICBvcGFjaXR5OiAwLFxuICAgICAgICBwb3NpdGlvbjogJ3JlbGF0aXZlJyxcbiAgICAgICAgdHJhbnNmb3JtOiAnc2NhbGUoLjAxKScsXG4gICAgICB9fVxuICAgIC8+XG4gICk7XG59XG4iXX0= */")
  }));
}
var QP = function(n) {
  n.cancelable && n.preventDefault(), n.stopPropagation();
};
function qP(l) {
  var n = l.isEnabled, u = l.onBottomArrive, t = l.onBottomLeave, r = l.onTopArrive, o = l.onTopLeave, s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(!1), a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(0), c = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), p = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E, S) {
    if (c.current !== null) {
      var A = c.current, x = A.scrollTop, I = A.scrollHeight, P = A.clientHeight, O = c.current, _ = S > 0, j = I - P - x, z = !1;
      j > S && s.current && (t && t(E), s.current = !1), _ && d.current && (o && o(E), d.current = !1), _ && S > j ? (u && !s.current && u(E), O.scrollTop = I, z = !0, s.current = !0) : !_ && -S > x && (r && !d.current && r(E), O.scrollTop = 0, z = !0, d.current = !0), z && QP(E);
    }
  }, [u, t, r, o]), g = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E) {
    p(E, E.deltaY);
  }, [p]), m = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E) {
    a.current = E.changedTouches[0].clientY;
  }, []), v = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E) {
    var S = a.current - E.changedTouches[0].clientY;
    p(E, S);
  }, [p]), $ = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E) {
    if (E) {
      var S = $S ? {
        passive: !1
      } : !1;
      E.addEventListener("wheel", g, S), E.addEventListener("touchstart", m, S), E.addEventListener("touchmove", v, S);
    }
  }, [v, m, g]), b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(E) {
    E && (E.removeEventListener("wheel", g, !1), E.removeEventListener("touchstart", m, !1), E.removeEventListener("touchmove", v, !1));
  }, [v, m, g]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    if (n) {
      var E = c.current;
      return $(E), function() {
        b(E);
      };
    }
  }, [n, $, b]), function(E) {
    c.current = E;
  };
}
var r3 = ["boxSizing", "height", "overflow", "paddingRight", "position"], i3 = {
  boxSizing: "border-box",
  // account for possible declaration `width: 100%;` on body
  overflow: "hidden",
  position: "relative",
  height: "100%"
};
function o3(l) {
  l.preventDefault();
}
function a3(l) {
  l.stopPropagation();
}
function s3() {
  var l = this.scrollTop, n = this.scrollHeight, u = l + this.offsetHeight;
  l === 0 ? this.scrollTop = 1 : u === n && (this.scrollTop = l - 1);
}
function d3() {
  return "ontouchstart" in window || navigator.maxTouchPoints;
}
var c3 = !!(typeof window < "u" && window.document && window.document.createElement), Vr = 0, Xt = {
  capture: !1,
  passive: !1
};
function lN(l) {
  var n = l.isEnabled, u = l.accountForScrollbars, t = u === void 0 ? !0 : u, r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({}), o = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), s = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(a) {
    if (c3) {
      var c = document.body, p = c && c.style;
      if (t && r3.forEach(function($) {
        var b = p && p[$];
        r.current[$] = b;
      }), t && Vr < 1) {
        var g = parseInt(r.current.paddingRight, 10) || 0, m = document.body ? document.body.clientWidth : 0, v = window.innerWidth - m + g || 0;
        Object.keys(i3).forEach(function($) {
          var b = i3[$];
          p && (p[$] = b);
        }), p && (p.paddingRight = "".concat(v, "px"));
      }
      c && d3() && (c.addEventListener("touchmove", o3, Xt), a && (a.addEventListener("touchstart", s3, Xt), a.addEventListener("touchmove", a3, Xt))), Vr += 1;
    }
  }, [t]), d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(a) {
    if (c3) {
      var c = document.body, p = c && c.style;
      Vr = Math.max(Vr - 1, 0), t && Vr < 1 && r3.forEach(function(g) {
        var m = r.current[g];
        p && (p[g] = m);
      }), c && d3() && (c.removeEventListener("touchmove", o3, Xt), a && (a.removeEventListener("touchstart", s3, Xt), a.removeEventListener("touchmove", a3, Xt)));
    }
  }, [t]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function() {
    if (n) {
      var a = o.current;
      return s(a), function() {
        d(a);
      };
    }
  }, [n, s, d]), function(a) {
    o.current = a;
  };
}
function nN() {
  return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
}
var uN = function(n) {
  var u = n.target;
  return u.ownerDocument.activeElement && u.ownerDocument.activeElement.blur();
}, eN =  false ? 0 : {
  name: "bp8cua-ScrollManager",
  styles: "position:fixed;left:0;bottom:0;right:0;top:0;label:ScrollManager;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: nN
};
function tN(l) {
  var n = l.children, u = l.lockEnabled, t = l.captureEnabled, r = t === void 0 ? !0 : t, o = l.onBottomArrive, s = l.onBottomLeave, d = l.onTopArrive, a = l.onTopLeave, c = qP({
    isEnabled: r,
    onBottomArrive: o,
    onBottomLeave: s,
    onTopArrive: d,
    onTopLeave: a
  }), p = lN({
    isEnabled: u
  }), g = function(v) {
    c(v), p(v);
  };
  return Il(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, u && Il("div", {
    onClick: uN,
    css: eN
  }), n(g));
}
function rN() {
  return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
}
var iN =  false ? 0 : {
  name: "5kkxb2-requiredInput-RequiredInput",
  styles: "label:requiredInput;opacity:0;pointer-events:none;position:absolute;bottom:0;left:0;right:0;width:100%;label:RequiredInput;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIlJlcXVpcmVkSW5wdXQudHN4Il0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQWNJIiwiZmlsZSI6IlJlcXVpcmVkSW5wdXQudHN4Iiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBqc3gganN4ICovXG5pbXBvcnQgeyBGb2N1c0V2ZW50SGFuZGxlciwgRnVuY3Rpb25Db21wb25lbnQgfSBmcm9tICdyZWFjdCc7XG5pbXBvcnQgeyBqc3ggfSBmcm9tICdAZW1vdGlvbi9yZWFjdCc7XG5cbmNvbnN0IFJlcXVpcmVkSW5wdXQ6IEZ1bmN0aW9uQ29tcG9uZW50PHtcbiAgcmVhZG9ubHkgbmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkgb25Gb2N1czogRm9jdXNFdmVudEhhbmRsZXI8SFRNTElucHV0RWxlbWVudD47XG59PiA9ICh7IG5hbWUsIG9uRm9jdXMgfSkgPT4gKFxuICA8aW5wdXRcbiAgICByZXF1aXJlZFxuICAgIG5hbWU9e25hbWV9XG4gICAgdGFiSW5kZXg9ey0xfVxuICAgIGFyaWEtaGlkZGVuPVwidHJ1ZVwiXG4gICAgb25Gb2N1cz17b25Gb2N1c31cbiAgICBjc3M9e3tcbiAgICAgIGxhYmVsOiAncmVxdWlyZWRJbnB1dCcsXG4gICAgICBvcGFjaXR5OiAwLFxuICAgICAgcG9pbnRlckV2ZW50czogJ25vbmUnLFxuICAgICAgcG9zaXRpb246ICdhYnNvbHV0ZScsXG4gICAgICBib3R0b206IDAsXG4gICAgICBsZWZ0OiAwLFxuICAgICAgcmlnaHQ6IDAsXG4gICAgICB3aWR0aDogJzEwMCUnLFxuICAgIH19XG4gICAgLy8gUHJldmVudCBgU3dpdGNoaW5nIGZyb20gdW5jb250cm9sbGVkIHRvIGNvbnRyb2xsZWRgIGVycm9yXG4gICAgdmFsdWU9XCJcIlxuICAgIG9uQ2hhbmdlPXsoKSA9PiB7fX1cbiAgLz5cbik7XG5cbmV4cG9ydCBkZWZhdWx0IFJlcXVpcmVkSW5wdXQ7XG4iXX0= */",
  toString: rN
}, oN = function(n) {
  var u = n.name, t = n.onFocus;
  return Il("input", {
    required: !0,
    name: u,
    tabIndex: -1,
    "aria-hidden": "true",
    onFocus: t,
    css: iN,
    value: "",
    onChange: function() {
    }
  });
}, aN = oN;
function Xc(l) {
  var n;
  return typeof window < "u" && window.navigator != null ? l.test(((n = window.navigator.userAgentData) === null || n === void 0 ? void 0 : n.platform) || window.navigator.platform) : !1;
}
function sN() {
  return Xc(/^iPhone/i);
}
function Dp() {
  return Xc(/^Mac/i);
}
function dN() {
  return Xc(/^iPad/i) || // iPadOS 13 lies and says it's a Mac, but we can distinguish by detecting touch support.
  Dp() && navigator.maxTouchPoints > 1;
}
function cN() {
  return sN() || dN();
}
function fN() {
  return Dp() || cN();
}
var pN = function(n) {
  return n.label;
}, Mp = function(n) {
  return n.label;
}, Bp = function(n) {
  return n.value;
}, gN = function(n) {
  return !!n.isDisabled;
}, hN = {
  clearIndicator: QS,
  container: jS,
  control: rP,
  dropdownIndicator: JS,
  group: sP,
  groupHeading: cP,
  indicatorsContainer: HS,
  indicatorSeparator: lP,
  input: hP,
  loadingIndicator: eP,
  loadingMessage: DS,
  menu: PS,
  menuList: OS,
  menuPortal: LS,
  multiValue: $P,
  multiValueLabel: xP,
  multiValueRemove: CP,
  noOptionsMessage: _S,
  option: PP,
  placeholder: RP,
  singleValue: _P,
  valueContainer: VS
};
function mN(l) {
  var n = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {}, u = yl({}, l);
  return Object.keys(n).forEach(function(t) {
    var r = t;
    l[r] ? u[r] = function(o, s) {
      return n[r](l[r](o, s), s);
    } : u[r] = n[r];
  }), u;
}
var vN = {
  primary: "#2684FF",
  primary75: "#4C9AFF",
  primary50: "#B2D4FF",
  primary25: "#DEEBFF",
  danger: "#DE350B",
  dangerLight: "#FFBDAD",
  neutral0: "hsl(0, 0%, 100%)",
  neutral5: "hsl(0, 0%, 95%)",
  neutral10: "hsl(0, 0%, 90%)",
  neutral20: "hsl(0, 0%, 80%)",
  neutral30: "hsl(0, 0%, 70%)",
  neutral40: "hsl(0, 0%, 60%)",
  neutral50: "hsl(0, 0%, 50%)",
  neutral60: "hsl(0, 0%, 40%)",
  neutral70: "hsl(0, 0%, 30%)",
  neutral80: "hsl(0, 0%, 20%)",
  neutral90: "hsl(0, 0%, 10%)"
}, bN = 4, Lp = 4, yN = 38, $N = Lp * 2, xN = {
  baseUnit: Lp,
  controlHeight: yN,
  menuGutter: $N
}, To = {
  borderRadius: bN,
  colors: vN,
  spacing: xN
}, CN = {
  "aria-live": "polite",
  backspaceRemovesValue: !0,
  blurInputOnSelect: l3(),
  captureMenuScroll: !l3(),
  classNames: {},
  closeMenuOnSelect: !0,
  closeMenuOnScroll: !1,
  components: {},
  controlShouldRenderValue: !0,
  escapeClearsValue: !1,
  filterOption: _p(),
  formatGroupLabel: pN,
  getOptionLabel: Mp,
  getOptionValue: Bp,
  isDisabled: !1,
  isLoading: !1,
  isMulti: !1,
  isRtl: !1,
  isSearchable: !0,
  isOptionDisabled: gN,
  loadingMessage: function() {
    return "Loading...";
  },
  maxMenuHeight: 300,
  minMenuHeight: 140,
  menuIsOpen: !1,
  menuPlacement: "bottom",
  menuPosition: "absolute",
  menuShouldBlockScroll: !1,
  menuShouldScrollIntoView: !bS(),
  noOptionsMessage: function() {
    return "No options";
  },
  openMenuOnFocus: !1,
  openMenuOnClick: !0,
  options: [],
  pageSize: 5,
  placeholder: "Select...",
  screenReaderStatus: function(n) {
    var u = n.count;
    return "".concat(u, " result").concat(u !== 1 ? "s" : "", " available");
  },
  styles: {},
  tabIndex: 0,
  tabSelectsValue: !0,
  unstyled: !1
};
function f3(l, n, u, t) {
  var r = Wp(l, n, u), o = Vp(l, n, u), s = jp(l, n), d = na(l, n);
  return {
    type: "option",
    data: n,
    isDisabled: r,
    isSelected: o,
    label: s,
    value: d,
    index: t
  };
}
function Ro(l, n) {
  return l.options.map(function(u, t) {
    if ("options" in u) {
      var r = u.options.map(function(s, d) {
        return f3(l, s, n, d);
      }).filter(function(s) {
        return g3(l, s);
      });
      return r.length > 0 ? {
        type: "group",
        data: u,
        options: r,
        index: t
      } : void 0;
    }
    var o = f3(l, u, n, t);
    return g3(l, o) ? o : void 0;
  }).filter(xS);
}
function Gp(l) {
  return l.reduce(function(n, u) {
    return u.type === "group" ? n.push.apply(n, qt(u.options.map(function(t) {
      return t.data;
    }))) : n.push(u.data), n;
  }, []);
}
function p3(l, n) {
  return l.reduce(function(u, t) {
    return t.type === "group" ? u.push.apply(u, qt(t.options.map(function(r) {
      return {
        data: r.data,
        id: "".concat(n, "-").concat(t.index, "-").concat(r.index)
      };
    }))) : u.push({
      data: t.data,
      id: "".concat(n, "-").concat(t.index)
    }), u;
  }, []);
}
function wN(l, n) {
  return Gp(Ro(l, n));
}
function g3(l, n) {
  var u = l.inputValue, t = u === void 0 ? "" : u, r = n.data, o = n.isSelected, s = n.label, d = n.value;
  return (!Hp(l) || !o) && kp(l, {
    label: s,
    value: d,
    data: r
  }, t);
}
function IN(l, n) {
  var u = l.focusedValue, t = l.selectValue, r = t.indexOf(u);
  if (r > -1) {
    var o = n.indexOf(u);
    if (o > -1)
      return u;
    if (r < n.length)
      return n[r];
  }
  return null;
}
function EN(l, n) {
  var u = l.focusedOption;
  return u && n.indexOf(u) > -1 ? u : n[0];
}
var dd = function(n, u) {
  var t, r = (t = n.find(function(o) {
    return o.data === u;
  })) === null || t === void 0 ? void 0 : t.id;
  return r || null;
}, jp = function(n, u) {
  return n.getOptionLabel(u);
}, na = function(n, u) {
  return n.getOptionValue(u);
};
function Wp(l, n, u) {
  return typeof l.isOptionDisabled == "function" ? l.isOptionDisabled(n, u) : !1;
}
function Vp(l, n, u) {
  if (u.indexOf(n) > -1) return !0;
  if (typeof l.isOptionSelected == "function")
    return l.isOptionSelected(n, u);
  var t = na(l, n);
  return u.some(function(r) {
    return na(l, r) === t;
  });
}
function kp(l, n, u) {
  return l.filterOption ? l.filterOption(n, u) : !0;
}
var Hp = function(n) {
  var u = n.hideSelectedOptions, t = n.isMulti;
  return u === void 0 ? t : u;
}, AN = 1, Sa = /* @__PURE__ */ function(l) {
  kE(u, l);
  var n = XE(u);
  function u(t) {
    var r;
    if (WE(this, u), r = n.call(this, t), r.state = {
      ariaSelection: null,
      focusedOption: null,
      focusedOptionId: null,
      focusableOptionsWithIds: [],
      focusedValue: null,
      inputIsHidden: !1,
      isFocused: !1,
      selectValue: [],
      clearFocusValueOnUpdate: !1,
      prevWasFocused: !1,
      inputIsHiddenAfterUpdate: void 0,
      prevProps: void 0,
      instancePrefix: ""
    }, r.blockOptionHover = !1, r.isComposing = !1, r.commonProps = void 0, r.initialTouchX = 0, r.initialTouchY = 0, r.openAfterFocus = !1, r.scrollToFocusedOptionOnUpdate = !1, r.userIsDragging = void 0, r.isAppleDevice = fN(), r.controlRef = null, r.getControlRef = function(a) {
      r.controlRef = a;
    }, r.focusedOptionRef = null, r.getFocusedOptionRef = function(a) {
      r.focusedOptionRef = a;
    }, r.menuListRef = null, r.getMenuListRef = function(a) {
      r.menuListRef = a;
    }, r.inputRef = null, r.getInputRef = function(a) {
      r.inputRef = a;
    }, r.focus = r.focusInput, r.blur = r.blurInput, r.onChange = function(a, c) {
      var p = r.props, g = p.onChange, m = p.name;
      c.name = m, r.ariaOnChange(a, c), g(a, c);
    }, r.setValue = function(a, c, p) {
      var g = r.props, m = g.closeMenuOnSelect, v = g.isMulti, $ = g.inputValue;
      r.onInputChange("", {
        action: "set-value",
        prevInputValue: $
      }), m && (r.setState({
        inputIsHiddenAfterUpdate: !v
      }), r.onMenuClose()), r.setState({
        clearFocusValueOnUpdate: !0
      }), r.onChange(a, {
        action: c,
        option: p
      });
    }, r.selectOption = function(a) {
      var c = r.props, p = c.blurInputOnSelect, g = c.isMulti, m = c.name, v = r.state.selectValue, $ = g && r.isOptionSelected(a, v), b = r.isOptionDisabled(a, v);
      if ($) {
        var E = r.getOptionValue(a);
        r.setValue(v.filter(function(S) {
          return r.getOptionValue(S) !== E;
        }), "deselect-option", a);
      } else if (!b)
        g ? r.setValue([].concat(qt(v), [a]), "select-option", a) : r.setValue(a, "select-option");
      else {
        r.ariaOnChange(a, {
          action: "select-option",
          option: a,
          name: m
        });
        return;
      }
      p && r.blurInput();
    }, r.removeValue = function(a) {
      var c = r.props.isMulti, p = r.state.selectValue, g = r.getOptionValue(a), m = p.filter(function($) {
        return r.getOptionValue($) !== g;
      }), v = Hr(c, m, m[0] || null);
      r.onChange(v, {
        action: "remove-value",
        removedValue: a
      }), r.focusInput();
    }, r.clearValue = function() {
      var a = r.state.selectValue;
      r.onChange(Hr(r.props.isMulti, [], null), {
        action: "clear",
        removedValues: a
      });
    }, r.popValue = function() {
      var a = r.props.isMulti, c = r.state.selectValue, p = c[c.length - 1], g = c.slice(0, c.length - 1), m = Hr(a, g, g[0] || null);
      r.onChange(m, {
        action: "pop-value",
        removedValue: p
      });
    }, r.getFocusedOptionId = function(a) {
      return dd(r.state.focusableOptionsWithIds, a);
    }, r.getFocusableOptionsWithIds = function() {
      return p3(Ro(r.props, r.state.selectValue), r.getElementId("option"));
    }, r.getValue = function() {
      return r.state.selectValue;
    }, r.cx = function() {
      for (var a = arguments.length, c = new Array(a), p = 0; p < a; p++)
        c[p] = arguments[p];
      return fS.apply(void 0, [r.props.classNamePrefix].concat(c));
    }, r.getOptionLabel = function(a) {
      return jp(r.props, a);
    }, r.getOptionValue = function(a) {
      return na(r.props, a);
    }, r.getStyles = function(a, c) {
      var p = r.props.unstyled, g = hN[a](c, p);
      g.boxSizing = "border-box";
      var m = r.props.styles[a];
      return m ? m(g, c) : g;
    }, r.getClassNames = function(a, c) {
      var p, g;
      return (p = (g = r.props.classNames)[a]) === null || p === void 0 ? void 0 : p.call(g, c);
    }, r.getElementId = function(a) {
      return "".concat(r.state.instancePrefix, "-").concat(a);
    }, r.getComponents = function() {
      return BP(r.props);
    }, r.buildCategorizedOptions = function() {
      return Ro(r.props, r.state.selectValue);
    }, r.getCategorizedOptions = function() {
      return r.props.menuIsOpen ? r.buildCategorizedOptions() : [];
    }, r.buildFocusableOptions = function() {
      return Gp(r.buildCategorizedOptions());
    }, r.getFocusableOptions = function() {
      return r.props.menuIsOpen ? r.buildFocusableOptions() : [];
    }, r.ariaOnChange = function(a, c) {
      r.setState({
        ariaSelection: yl({
          value: a
        }, c)
      });
    }, r.onMenuMouseDown = function(a) {
      a.button === 0 && (a.stopPropagation(), a.preventDefault(), r.focusInput());
    }, r.onMenuMouseMove = function(a) {
      r.blockOptionHover = !1;
    }, r.onControlMouseDown = function(a) {
      if (!a.defaultPrevented) {
        var c = r.props.openMenuOnClick;
        r.state.isFocused ? r.props.menuIsOpen ? a.target.tagName !== "INPUT" && a.target.tagName !== "TEXTAREA" && r.onMenuClose() : c && r.openMenu("first") : (c && (r.openAfterFocus = !0), r.focusInput()), a.target.tagName !== "INPUT" && a.target.tagName !== "TEXTAREA" && a.preventDefault();
      }
    }, r.onDropdownIndicatorMouseDown = function(a) {
      if (!(a && a.type === "mousedown" && a.button !== 0) && !r.props.isDisabled) {
        var c = r.props, p = c.isMulti, g = c.menuIsOpen;
        r.focusInput(), g ? (r.setState({
          inputIsHiddenAfterUpdate: !p
        }), r.onMenuClose()) : r.openMenu("first"), a.preventDefault();
      }
    }, r.onClearIndicatorMouseDown = function(a) {
      a && a.type === "mousedown" && a.button !== 0 || (r.clearValue(), a.preventDefault(), r.openAfterFocus = !1, a.type === "touchend" ? r.focusInput() : setTimeout(function() {
        return r.focusInput();
      }));
    }, r.onScroll = function(a) {
      typeof r.props.closeMenuOnScroll == "boolean" ? a.target instanceof HTMLElement && Aa(a.target) && r.props.onMenuClose() : typeof r.props.closeMenuOnScroll == "function" && r.props.closeMenuOnScroll(a) && r.props.onMenuClose();
    }, r.onCompositionStart = function() {
      r.isComposing = !0;
    }, r.onCompositionEnd = function() {
      r.isComposing = !1;
    }, r.onTouchStart = function(a) {
      var c = a.touches, p = c && c.item(0);
      p && (r.initialTouchX = p.clientX, r.initialTouchY = p.clientY, r.userIsDragging = !1);
    }, r.onTouchMove = function(a) {
      var c = a.touches, p = c && c.item(0);
      if (p) {
        var g = Math.abs(p.clientX - r.initialTouchX), m = Math.abs(p.clientY - r.initialTouchY), v = 5;
        r.userIsDragging = g > v || m > v;
      }
    }, r.onTouchEnd = function(a) {
      r.userIsDragging || (r.controlRef && !r.controlRef.contains(a.target) && r.menuListRef && !r.menuListRef.contains(a.target) && r.blurInput(), r.initialTouchX = 0, r.initialTouchY = 0);
    }, r.onControlTouchEnd = function(a) {
      r.userIsDragging || r.onControlMouseDown(a);
    }, r.onClearIndicatorTouchEnd = function(a) {
      r.userIsDragging || r.onClearIndicatorMouseDown(a);
    }, r.onDropdownIndicatorTouchEnd = function(a) {
      r.userIsDragging || r.onDropdownIndicatorMouseDown(a);
    }, r.handleInputChange = function(a) {
      var c = r.props.inputValue, p = a.currentTarget.value;
      r.setState({
        inputIsHiddenAfterUpdate: !1
      }), r.onInputChange(p, {
        action: "input-change",
        prevInputValue: c
      }), r.props.menuIsOpen || r.onMenuOpen();
    }, r.onInputFocus = function(a) {
      r.props.onFocus && r.props.onFocus(a), r.setState({
        inputIsHiddenAfterUpdate: !1,
        isFocused: !0
      }), (r.openAfterFocus || r.props.openMenuOnFocus) && r.openMenu("first"), r.openAfterFocus = !1;
    }, r.onInputBlur = function(a) {
      var c = r.props.inputValue;
      if (r.menuListRef && r.menuListRef.contains(document.activeElement)) {
        r.inputRef.focus();
        return;
      }
      r.props.onBlur && r.props.onBlur(a), r.onInputChange("", {
        action: "input-blur",
        prevInputValue: c
      }), r.onMenuClose(), r.setState({
        focusedValue: null,
        isFocused: !1
      });
    }, r.onOptionHover = function(a) {
      if (!(r.blockOptionHover || r.state.focusedOption === a)) {
        var c = r.getFocusableOptions(), p = c.indexOf(a);
        r.setState({
          focusedOption: a,
          focusedOptionId: p > -1 ? r.getFocusedOptionId(a) : null
        });
      }
    }, r.shouldHideSelectedOptions = function() {
      return Hp(r.props);
    }, r.onValueInputFocus = function(a) {
      a.preventDefault(), a.stopPropagation(), r.focus();
    }, r.onKeyDown = function(a) {
      var c = r.props, p = c.isMulti, g = c.backspaceRemovesValue, m = c.escapeClearsValue, v = c.inputValue, $ = c.isClearable, b = c.isDisabled, E = c.menuIsOpen, S = c.onKeyDown, A = c.tabSelectsValue, x = c.openMenuOnFocus, I = r.state, P = I.focusedOption, O = I.focusedValue, _ = I.selectValue;
      if (!b && !(typeof S == "function" && (S(a), a.defaultPrevented))) {
        switch (r.blockOptionHover = !0, a.key) {
          case "ArrowLeft":
            if (!p || v) return;
            r.focusValue("previous");
            break;
          case "ArrowRight":
            if (!p || v) return;
            r.focusValue("next");
            break;
          case "Delete":
          case "Backspace":
            if (v) return;
            if (O)
              r.removeValue(O);
            else {
              if (!g) return;
              p ? r.popValue() : $ && r.clearValue();
            }
            break;
          case "Tab":
            if (r.isComposing || a.shiftKey || !E || !A || !P || // don't capture the event if the menu opens on focus and the focused
            // option is already selected; it breaks the flow of navigation
            x && r.isOptionSelected(P, _))
              return;
            r.selectOption(P);
            break;
          case "Enter":
            if (a.keyCode === 229)
              break;
            if (E) {
              if (!P || r.isComposing) return;
              r.selectOption(P);
              break;
            }
            return;
          case "Escape":
            E ? (r.setState({
              inputIsHiddenAfterUpdate: !1
            }), r.onInputChange("", {
              action: "menu-close",
              prevInputValue: v
            }), r.onMenuClose()) : $ && m && r.clearValue();
            break;
          case " ":
            if (v)
              return;
            if (!E) {
              r.openMenu("first");
              break;
            }
            if (!P) return;
            r.selectOption(P);
            break;
          case "ArrowUp":
            E ? r.focusOption("up") : r.openMenu("last");
            break;
          case "ArrowDown":
            E ? r.focusOption("down") : r.openMenu("first");
            break;
          case "PageUp":
            if (!E) return;
            r.focusOption("pageup");
            break;
          case "PageDown":
            if (!E) return;
            r.focusOption("pagedown");
            break;
          case "Home":
            if (!E) return;
            r.focusOption("first");
            break;
          case "End":
            if (!E) return;
            r.focusOption("last");
            break;
          default:
            return;
        }
        a.preventDefault();
      }
    }, r.state.instancePrefix = "react-select-" + (r.props.instanceId || ++AN), r.state.selectValue = qo(t.value), t.menuIsOpen && r.state.selectValue.length) {
      var o = r.getFocusableOptionsWithIds(), s = r.buildFocusableOptions(), d = s.indexOf(r.state.selectValue[0]);
      r.state.focusableOptionsWithIds = o, r.state.focusedOption = s[d], r.state.focusedOptionId = dd(o, s[d]);
    }
    return r;
  }
  return VE(u, [{
    key: "componentDidMount",
    value: function() {
      this.startListeningComposition(), this.startListeningToTouch(), this.props.closeMenuOnScroll && document && document.addEventListener && document.addEventListener("scroll", this.onScroll, !0), this.props.autoFocus && this.focusInput(), this.props.menuIsOpen && this.state.focusedOption && this.menuListRef && this.focusedOptionRef && q2(this.menuListRef, this.focusedOptionRef);
    }
  }, {
    key: "componentDidUpdate",
    value: function(r) {
      var o = this.props, s = o.isDisabled, d = o.menuIsOpen, a = this.state.isFocused;
      // ensure focus is restored correctly when the control becomes enabled
      (a && !s && r.isDisabled || // ensure focus is on the Input when the menu opens
      a && d && !r.menuIsOpen) && this.focusInput(), a && s && !r.isDisabled ? this.setState({
        isFocused: !1
      }, this.onMenuClose) : !a && !s && r.isDisabled && this.inputRef === document.activeElement && this.setState({
        isFocused: !0
      }), this.menuListRef && this.focusedOptionRef && this.scrollToFocusedOptionOnUpdate && (q2(this.menuListRef, this.focusedOptionRef), this.scrollToFocusedOptionOnUpdate = !1);
    }
  }, {
    key: "componentWillUnmount",
    value: function() {
      this.stopListeningComposition(), this.stopListeningToTouch(), document.removeEventListener("scroll", this.onScroll, !0);
    }
    // ==============================
    // Consumer Handlers
    // ==============================
  }, {
    key: "onMenuOpen",
    value: function() {
      this.props.onMenuOpen();
    }
  }, {
    key: "onMenuClose",
    value: function() {
      this.onInputChange("", {
        action: "menu-close",
        prevInputValue: this.props.inputValue
      }), this.props.onMenuClose();
    }
  }, {
    key: "onInputChange",
    value: function(r, o) {
      this.props.onInputChange(r, o);
    }
    // ==============================
    // Methods
    // ==============================
  }, {
    key: "focusInput",
    value: function() {
      this.inputRef && this.inputRef.focus();
    }
  }, {
    key: "blurInput",
    value: function() {
      this.inputRef && this.inputRef.blur();
    }
    // aliased for consumers
  }, {
    key: "openMenu",
    value: function(r) {
      var o = this, s = this.state, d = s.selectValue, a = s.isFocused, c = this.buildFocusableOptions(), p = r === "first" ? 0 : c.length - 1;
      if (!this.props.isMulti) {
        var g = c.indexOf(d[0]);
        g > -1 && (p = g);
      }
      this.scrollToFocusedOptionOnUpdate = !(a && this.menuListRef), this.setState({
        inputIsHiddenAfterUpdate: !1,
        focusedValue: null,
        focusedOption: c[p],
        focusedOptionId: this.getFocusedOptionId(c[p])
      }, function() {
        return o.onMenuOpen();
      });
    }
  }, {
    key: "focusValue",
    value: function(r) {
      var o = this.state, s = o.selectValue, d = o.focusedValue;
      if (this.props.isMulti) {
        this.setState({
          focusedOption: null
        });
        var a = s.indexOf(d);
        d || (a = -1);
        var c = s.length - 1, p = -1;
        if (s.length) {
          switch (r) {
            case "previous":
              a === 0 ? p = 0 : a === -1 ? p = c : p = a - 1;
              break;
            case "next":
              a > -1 && a < c && (p = a + 1);
              break;
          }
          this.setState({
            inputIsHidden: p !== -1,
            focusedValue: s[p]
          });
        }
      }
    }
  }, {
    key: "focusOption",
    value: function() {
      var r = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "first", o = this.props.pageSize, s = this.state.focusedOption, d = this.getFocusableOptions();
      if (d.length) {
        var a = 0, c = d.indexOf(s);
        s || (c = -1), r === "up" ? a = c > 0 ? c - 1 : d.length - 1 : r === "down" ? a = (c + 1) % d.length : r === "pageup" ? (a = c - o, a < 0 && (a = 0)) : r === "pagedown" ? (a = c + o, a > d.length - 1 && (a = d.length - 1)) : r === "last" && (a = d.length - 1), this.scrollToFocusedOptionOnUpdate = !0, this.setState({
          focusedOption: d[a],
          focusedValue: null,
          focusedOptionId: this.getFocusedOptionId(d[a])
        });
      }
    }
  }, {
    key: "getTheme",
    value: (
      // ==============================
      // Getters
      // ==============================
      function() {
        return this.props.theme ? typeof this.props.theme == "function" ? this.props.theme(To) : yl(yl({}, To), this.props.theme) : To;
      }
    )
  }, {
    key: "getCommonProps",
    value: function() {
      var r = this.clearValue, o = this.cx, s = this.getStyles, d = this.getClassNames, a = this.getValue, c = this.selectOption, p = this.setValue, g = this.props, m = g.isMulti, v = g.isRtl, $ = g.options, b = this.hasValue();
      return {
        clearValue: r,
        cx: o,
        getStyles: s,
        getClassNames: d,
        getValue: a,
        hasValue: b,
        isMulti: m,
        isRtl: v,
        options: $,
        selectOption: c,
        selectProps: g,
        setValue: p,
        theme: this.getTheme()
      };
    }
  }, {
    key: "hasValue",
    value: function() {
      var r = this.state.selectValue;
      return r.length > 0;
    }
  }, {
    key: "hasOptions",
    value: function() {
      return !!this.getFocusableOptions().length;
    }
  }, {
    key: "isClearable",
    value: function() {
      var r = this.props, o = r.isClearable, s = r.isMulti;
      return o === void 0 ? s : o;
    }
  }, {
    key: "isOptionDisabled",
    value: function(r, o) {
      return Wp(this.props, r, o);
    }
  }, {
    key: "isOptionSelected",
    value: function(r, o) {
      return Vp(this.props, r, o);
    }
  }, {
    key: "filterOption",
    value: function(r, o) {
      return kp(this.props, r, o);
    }
  }, {
    key: "formatOptionLabel",
    value: function(r, o) {
      if (typeof this.props.formatOptionLabel == "function") {
        var s = this.props.inputValue, d = this.state.selectValue;
        return this.props.formatOptionLabel(r, {
          context: o,
          inputValue: s,
          selectValue: d
        });
      } else
        return this.getOptionLabel(r);
    }
  }, {
    key: "formatGroupLabel",
    value: function(r) {
      return this.props.formatGroupLabel(r);
    }
    // ==============================
    // Mouse Handlers
    // ==============================
  }, {
    key: "startListeningComposition",
    value: (
      // ==============================
      // Composition Handlers
      // ==============================
      function() {
        document && document.addEventListener && (document.addEventListener("compositionstart", this.onCompositionStart, !1), document.addEventListener("compositionend", this.onCompositionEnd, !1));
      }
    )
  }, {
    key: "stopListeningComposition",
    value: function() {
      document && document.removeEventListener && (document.removeEventListener("compositionstart", this.onCompositionStart), document.removeEventListener("compositionend", this.onCompositionEnd));
    }
  }, {
    key: "startListeningToTouch",
    value: (
      // ==============================
      // Touch Handlers
      // ==============================
      function() {
        document && document.addEventListener && (document.addEventListener("touchstart", this.onTouchStart, !1), document.addEventListener("touchmove", this.onTouchMove, !1), document.addEventListener("touchend", this.onTouchEnd, !1));
      }
    )
  }, {
    key: "stopListeningToTouch",
    value: function() {
      document && document.removeEventListener && (document.removeEventListener("touchstart", this.onTouchStart), document.removeEventListener("touchmove", this.onTouchMove), document.removeEventListener("touchend", this.onTouchEnd));
    }
  }, {
    key: "renderInput",
    value: (
      // ==============================
      // Renderers
      // ==============================
      function() {
        var r = this.props, o = r.isDisabled, s = r.isSearchable, d = r.inputId, a = r.inputValue, c = r.tabIndex, p = r.form, g = r.menuIsOpen, m = r.required, v = this.getComponents(), $ = v.Input, b = this.state, E = b.inputIsHidden, S = b.ariaSelection, A = this.commonProps, x = d || this.getElementId("input"), I = yl(yl(yl({
          "aria-autocomplete": "list",
          "aria-expanded": g,
          "aria-haspopup": !0,
          "aria-errormessage": this.props["aria-errormessage"],
          "aria-invalid": this.props["aria-invalid"],
          "aria-label": this.props["aria-label"],
          "aria-labelledby": this.props["aria-labelledby"],
          "aria-required": m,
          role: "combobox",
          "aria-activedescendant": this.isAppleDevice ? void 0 : this.state.focusedOptionId || ""
        }, g && {
          "aria-controls": this.getElementId("listbox")
        }), !s && {
          "aria-readonly": !0
        }), this.hasValue() ? (S == null ? void 0 : S.action) === "initial-input-focus" && {
          "aria-describedby": this.getElementId("live-region")
        } : {
          "aria-describedby": this.getElementId("placeholder")
        });
        return s ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement($, El({}, A, {
          autoCapitalize: "none",
          autoComplete: "off",
          autoCorrect: "off",
          id: x,
          innerRef: this.getInputRef,
          isDisabled: o,
          isHidden: E,
          onBlur: this.onInputBlur,
          onChange: this.handleInputChange,
          onFocus: this.onInputFocus,
          spellCheck: "false",
          tabIndex: c,
          form: p,
          type: "text",
          value: a
        }, I)) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(KP, El({
          id: x,
          innerRef: this.getInputRef,
          onBlur: this.onInputBlur,
          onChange: Qo,
          onFocus: this.onInputFocus,
          disabled: o,
          tabIndex: c,
          inputMode: "none",
          form: p,
          value: ""
        }, I));
      }
    )
  }, {
    key: "renderPlaceholderOrValue",
    value: function() {
      var r = this, o = this.getComponents(), s = o.MultiValue, d = o.MultiValueContainer, a = o.MultiValueLabel, c = o.MultiValueRemove, p = o.SingleValue, g = o.Placeholder, m = this.commonProps, v = this.props, $ = v.controlShouldRenderValue, b = v.isDisabled, E = v.isMulti, S = v.inputValue, A = v.placeholder, x = this.state, I = x.selectValue, P = x.focusedValue, O = x.isFocused;
      if (!this.hasValue() || !$)
        return S ? null : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(g, El({}, m, {
          key: "placeholder",
          isDisabled: b,
          isFocused: O,
          innerProps: {
            id: this.getElementId("placeholder")
          }
        }), A);
      if (E)
        return I.map(function(j, z) {
          var Y = j === P, el = "".concat(r.getOptionLabel(j), "-").concat(r.getOptionValue(j));
          return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(s, El({}, m, {
            components: {
              Container: d,
              Label: a,
              Remove: c
            },
            isFocused: Y,
            isDisabled: b,
            key: el,
            index: z,
            removeProps: {
              onClick: function() {
                return r.removeValue(j);
              },
              onTouchEnd: function() {
                return r.removeValue(j);
              },
              onMouseDown: function(ul) {
                ul.preventDefault();
              }
            },
            data: j
          }), r.formatOptionLabel(j, "value"));
        });
      if (S)
        return null;
      var _ = I[0];
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(p, El({}, m, {
        data: _,
        isDisabled: b
      }), this.formatOptionLabel(_, "value"));
    }
  }, {
    key: "renderClearIndicator",
    value: function() {
      var r = this.getComponents(), o = r.ClearIndicator, s = this.commonProps, d = this.props, a = d.isDisabled, c = d.isLoading, p = this.state.isFocused;
      if (!this.isClearable() || !o || a || !this.hasValue() || c)
        return null;
      var g = {
        onMouseDown: this.onClearIndicatorMouseDown,
        onTouchEnd: this.onClearIndicatorTouchEnd,
        "aria-hidden": "true"
      };
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(o, El({}, s, {
        innerProps: g,
        isFocused: p
      }));
    }
  }, {
    key: "renderLoadingIndicator",
    value: function() {
      var r = this.getComponents(), o = r.LoadingIndicator, s = this.commonProps, d = this.props, a = d.isDisabled, c = d.isLoading, p = this.state.isFocused;
      if (!o || !c) return null;
      var g = {
        "aria-hidden": "true"
      };
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(o, El({}, s, {
        innerProps: g,
        isDisabled: a,
        isFocused: p
      }));
    }
  }, {
    key: "renderIndicatorSeparator",
    value: function() {
      var r = this.getComponents(), o = r.DropdownIndicator, s = r.IndicatorSeparator;
      if (!o || !s) return null;
      var d = this.commonProps, a = this.props.isDisabled, c = this.state.isFocused;
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(s, El({}, d, {
        isDisabled: a,
        isFocused: c
      }));
    }
  }, {
    key: "renderDropdownIndicator",
    value: function() {
      var r = this.getComponents(), o = r.DropdownIndicator;
      if (!o) return null;
      var s = this.commonProps, d = this.props.isDisabled, a = this.state.isFocused, c = {
        onMouseDown: this.onDropdownIndicatorMouseDown,
        onTouchEnd: this.onDropdownIndicatorTouchEnd,
        "aria-hidden": "true"
      };
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(o, El({}, s, {
        innerProps: c,
        isDisabled: d,
        isFocused: a
      }));
    }
  }, {
    key: "renderMenu",
    value: function() {
      var r = this, o = this.getComponents(), s = o.Group, d = o.GroupHeading, a = o.Menu, c = o.MenuList, p = o.MenuPortal, g = o.LoadingMessage, m = o.NoOptionsMessage, v = o.Option, $ = this.commonProps, b = this.state.focusedOption, E = this.props, S = E.captureMenuScroll, A = E.inputValue, x = E.isLoading, I = E.loadingMessage, P = E.minMenuHeight, O = E.maxMenuHeight, _ = E.menuIsOpen, j = E.menuPlacement, z = E.menuPosition, Y = E.menuPortalTarget, el = E.menuShouldBlockScroll, U = E.menuShouldScrollIntoView, ul = E.noOptionsMessage, il = E.onMenuScrollToTop, rl = E.onMenuScrollToBottom;
      if (!_) return null;
      var tl = function(fl, $l) {
        var cl = fl.type, xl = fl.data, ol = fl.isDisabled, ml = fl.isSelected, Sl = fl.label, Ol = fl.value, Cl = b === xl, Q = ol ? void 0 : function() {
          return r.onOptionHover(xl);
        }, Xl = ol ? void 0 : function() {
          return r.selectOption(xl);
        }, Bl = "".concat(r.getElementId("option"), "-").concat($l), Kl = {
          id: Bl,
          onClick: Xl,
          onMouseMove: Q,
          onMouseOver: Q,
          tabIndex: -1,
          role: "option",
          "aria-selected": r.isAppleDevice ? void 0 : ml
          // is not supported on Apple devices
        };
        return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(v, El({}, $, {
          innerProps: Kl,
          data: xl,
          isDisabled: ol,
          isSelected: ml,
          key: Bl,
          label: Sl,
          type: cl,
          value: Ol,
          isFocused: Cl,
          innerRef: Cl ? r.getFocusedOptionRef : void 0
        }), r.formatOptionLabel(fl.data, "menu"));
      }, sl;
      if (this.hasOptions())
        sl = this.getCategorizedOptions().map(function(dl) {
          if (dl.type === "group") {
            var fl = dl.data, $l = dl.options, cl = dl.index, xl = "".concat(r.getElementId("group"), "-").concat(cl), ol = "".concat(xl, "-heading");
            return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(s, El({}, $, {
              key: xl,
              data: fl,
              options: $l,
              Heading: d,
              headingProps: {
                id: ol,
                data: dl.data
              },
              label: r.formatGroupLabel(dl.data)
            }), dl.options.map(function(ml) {
              return tl(ml, "".concat(cl, "-").concat(ml.index));
            }));
          } else if (dl.type === "option")
            return tl(dl, "".concat(dl.index));
        });
      else if (x) {
        var ll = I({
          inputValue: A
        });
        if (ll === null) return null;
        sl = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(g, $, ll);
      } else {
        var H = ul({
          inputValue: A
        });
        if (H === null) return null;
        sl = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(m, $, H);
      }
      var V = {
        minMenuHeight: P,
        maxMenuHeight: O,
        menuPlacement: j,
        menuPosition: z,
        menuShouldScrollIntoView: U
      }, X = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(NS, El({}, $, V), function(dl) {
        var fl = dl.ref, $l = dl.placerProps, cl = $l.placement, xl = $l.maxHeight;
        return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(a, El({}, $, V, {
          innerRef: fl,
          innerProps: {
            onMouseDown: r.onMenuMouseDown,
            onMouseMove: r.onMenuMouseMove
          },
          isLoading: x,
          placement: cl
        }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(tN, {
          captureEnabled: S,
          onTopArrive: il,
          onBottomArrive: rl,
          lockEnabled: el
        }, function(ol) {
          return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(c, El({}, $, {
            innerRef: function(Sl) {
              r.getMenuListRef(Sl), ol(Sl);
            },
            innerProps: {
              role: "listbox",
              "aria-multiselectable": $.isMulti,
              id: r.getElementId("listbox")
            },
            isLoading: x,
            maxHeight: xl,
            focusedOption: b
          }), sl);
        }));
      });
      return Y || z === "fixed" ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(p, El({}, $, {
        appendTo: Y,
        controlElement: this.controlRef,
        menuPlacement: j,
        menuPosition: z
      }), X) : X;
    }
  }, {
    key: "renderFormField",
    value: function() {
      var r = this, o = this.props, s = o.delimiter, d = o.isDisabled, a = o.isMulti, c = o.name, p = o.required, g = this.state.selectValue;
      if (p && !this.hasValue() && !d)
        return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(aN, {
          name: c,
          onFocus: this.onValueInputFocus
        });
      if (!(!c || d))
        if (a)
          if (s) {
            var m = g.map(function(b) {
              return r.getOptionValue(b);
            }).join(s);
            return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
              name: c,
              type: "hidden",
              value: m
            });
          } else {
            var v = g.length > 0 ? g.map(function(b, E) {
              return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
                key: "i-".concat(E),
                name: c,
                type: "hidden",
                value: r.getOptionValue(b)
              });
            }) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
              name: c,
              type: "hidden",
              value: ""
            });
            return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, v);
          }
        else {
          var $ = g[0] ? this.getOptionValue(g[0]) : "";
          return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
            name: c,
            type: "hidden",
            value: $
          });
        }
    }
  }, {
    key: "renderLiveRegion",
    value: function() {
      var r = this.commonProps, o = this.state, s = o.ariaSelection, d = o.focusedOption, a = o.focusedValue, c = o.isFocused, p = o.selectValue, g = this.getFocusableOptions();
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(XP, El({}, r, {
        id: this.getElementId("live-region"),
        ariaSelection: s,
        focusedOption: d,
        focusedValue: a,
        isFocused: c,
        selectValue: p,
        focusableOptions: g,
        isAppleDevice: this.isAppleDevice
      }));
    }
  }, {
    key: "render",
    value: function() {
      var r = this.getComponents(), o = r.Control, s = r.IndicatorsContainer, d = r.SelectContainer, a = r.ValueContainer, c = this.props, p = c.className, g = c.id, m = c.isDisabled, v = c.menuIsOpen, $ = this.state.isFocused, b = this.commonProps = this.getCommonProps();
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(d, El({}, b, {
        className: p,
        innerProps: {
          id: g,
          onKeyDown: this.onKeyDown
        },
        isDisabled: m,
        isFocused: $
      }), this.renderLiveRegion(), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(o, El({}, b, {
        innerRef: this.getControlRef,
        innerProps: {
          onMouseDown: this.onControlMouseDown,
          onTouchEnd: this.onControlTouchEnd
        },
        isDisabled: m,
        isFocused: $,
        menuIsOpen: v
      }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(a, El({}, b, {
        isDisabled: m
      }), this.renderPlaceholderOrValue(), this.renderInput()), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(s, El({}, b, {
        isDisabled: m
      }), this.renderClearIndicator(), this.renderLoadingIndicator(), this.renderIndicatorSeparator(), this.renderDropdownIndicator())), this.renderMenu(), this.renderFormField());
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function(r, o) {
      var s = o.prevProps, d = o.clearFocusValueOnUpdate, a = o.inputIsHiddenAfterUpdate, c = o.ariaSelection, p = o.isFocused, g = o.prevWasFocused, m = o.instancePrefix, v = r.options, $ = r.value, b = r.menuIsOpen, E = r.inputValue, S = r.isMulti, A = qo($), x = {};
      if (s && ($ !== s.value || v !== s.options || b !== s.menuIsOpen || E !== s.inputValue)) {
        var I = b ? wN(r, A) : [], P = b ? p3(Ro(r, A), "".concat(m, "-option")) : [], O = d ? IN(o, A) : null, _ = EN(o, I), j = dd(P, _);
        x = {
          selectValue: A,
          focusedOption: _,
          focusedOptionId: j,
          focusableOptionsWithIds: P,
          focusedValue: O,
          clearFocusValueOnUpdate: !1
        };
      }
      var z = a != null && r !== s ? {
        inputIsHidden: a,
        inputIsHiddenAfterUpdate: void 0
      } : {}, Y = c, el = p && g;
      return p && !el && (Y = {
        value: Hr(S, A, A[0] || null),
        options: A,
        action: "initial-input-focus"
      }, el = !g), (c == null ? void 0 : c.action) === "initial-input-focus" && (Y = null), yl(yl(yl({}, x), z), {}, {
        prevProps: r,
        ariaSelection: Y,
        prevWasFocused: el
      });
    }
  }]), u;
}(react__WEBPACK_IMPORTED_MODULE_0__.Component);
Sa.defaultProps = CN;
var SN = /* @__PURE__ */ (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function(l, n) {
  var u = xa(l);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Sa, El({
    ref: n
  }, u));
}), Zp = SN, PN = function(l) {
  var n = l.nonce, u = l.children, t = l.cacheKey, r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    return cp({
      key: t,
      nonce: n
    });
  }, [t, n]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(zA, {
    value: r
  }, u);
};
const w_ = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  NonceProvider: PN,
  components: Zc,
  createFilter: _p,
  default: Zp,
  defaultTheme: To,
  mergeStyles: mN,
  useStateManager: xa
}, Symbol.toStringTag, { value: "Module" }));
function ua(l) {
  return Vu({ tag: "svg", attr: { viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", strokeLinecap: "round", strokeLinejoin: "round" }, child: [{ tag: "polyline", attr: { points: "6 9 12 15 18 9" }, child: [] }] })(l);
}
function NN(l) {
  return Vu({ tag: "svg", attr: { viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", strokeLinecap: "round", strokeLinejoin: "round" }, child: [{ tag: "polyline", attr: { points: "18 15 12 9 6 15" }, child: [] }] })(l);
}
function TN(l) {
  return Vu({ tag: "svg", attr: { viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", strokeLinecap: "round", strokeLinejoin: "round" }, child: [{ tag: "circle", attr: { cx: "12", cy: "12", r: "10" }, child: [] }] })(l);
}
const I_ = (l) => {
  const n = l.id || Math.random().toString(), u = l.errors && l.errors.length > 0, t = () => null, r = () => /* @__PURE__ */ y.jsx("div", { className: "px-2", children: /* @__PURE__ */ y.jsx(ua, { className: "h-5 text-gray-400" }) }), o = !!(l.errors && l.errors.length > 0);
  return /* @__PURE__ */ y.jsxs("div", { className: "react-select", children: [
    typeof l.label == "string" ? /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: n,
        className: wl(
          "mb-2 inline-block cursor-pointer text-sm font-medium leading-[21px] text-gray-900",
          l.disabled && "cursor-not-allowed opacity-50"
        ),
        children: [
          l.label,
          l.required && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ) : l.label,
    /* @__PURE__ */ y.jsx(
      Zp,
      {
        ...l,
        id: void 0,
        inputId: n,
        menuPortalTarget: l.menuPortalTarget,
        menuPosition: l.menuPosition,
        isDisabled: l.disabled,
        className: wl(
          {
            hasErrors: o,
            "rounded border": l.disabled
          },
          l.className
        ),
        placeholder: /* @__PURE__ */ y.jsx("div", { className: "text-sm text-gray-400", children: l.placeholder || "Search" }),
        theme: (s) => ({
          ...s,
          colors: {
            ...s.colors,
            primary: "var(--colors-primary-500)",
            primary75: "var(--colors-primary-200)",
            primary50: "var(--colors-primary-100)",
            primary25: "var(--colors-primary-50)",
            neutral5: "var(--colors-gray-100)",
            neutral10: "var(--colors-gray-100)",
            neutral20: "var(--colors-gray-200)",
            neutral30: "var(--colors-gray-200)",
            neutral40: "var(--colors-gray-400)",
            neutral50: "var(--colors-gray-500)",
            neutral60: "var(--colors-gray-600)",
            neutral70: "var(--colors-gray-700)",
            neutral80: "var(--colors-gray-800)",
            neutral90: "var(--colors-gray-900)"
          }
        }),
        components: {
          IndicatorSeparator: t,
          DropdownIndicator: r,
          ...l != null && l.components ? l.components : {}
        },
        classNames: {
          ...l != null && l.classNames ? l.classNames : {},
          control: (s) => {
            var c;
            const d = (c = l.classNames) == null ? void 0 : c.control, a = typeof d == "function" ? d({ ...s, hasError: u }) : "";
            return u && s.isFocused ? Kn("!border !ring-danger-500 !ring-1", a) : s.isFocused ? Kn("!border !ring-primary-500 !ring-1", a) : Kn(u ? "!border !ring-danger-500 !ring-1" : "!border-gray-200", a);
          }
        },
        styles: {
          // Pass through any container-level custom styles if provided
          ...l != null && l.styles ? l.styles : {},
          control: (s, d) => {
            var p;
            const a = (p = l.styles) == null ? void 0 : p.control, c = typeof a == "function" ? a(s, d) : {};
            return {
              ...s,
              minHeight: "40px",
              boxShadow: "none",
              borderRadius: "5px",
              fontSize: "14px",
              ...c
            };
          },
          option: (s, d) => {
            var p;
            const a = (p = l.styles) == null ? void 0 : p.option, c = typeof a == "function" ? a(s, d) : {};
            return {
              ...s,
              fontSize: "0.875rem",
              ...c
            };
          },
          multiValue: (s, d) => {
            var p;
            const a = (p = l.styles) == null ? void 0 : p.multiValue, c = typeof a == "function" ? a(s, d) : {};
            return {
              ...s,
              background: "var(--colors-primary-50)",
              borderRadius: "0.25rem",
              ...c
            };
          },
          multiValueLabel: (s, d) => {
            var p;
            const a = (p = l.styles) == null ? void 0 : p.multiValueLabel, c = typeof a == "function" ? a(s, d) : {};
            return {
              ...s,
              color: "var(--colors-primary-600)",
              ...c
            };
          },
          multiValueRemove: (s, d) => {
            var p;
            const a = (p = l.styles) == null ? void 0 : p.multiValueRemove, c = typeof a == "function" ? a(s, d) : {};
            return {
              ...s,
              color: "var(--colors-primary-600)",
              ":hover": {
                background: "var(--colors-primary-100)"
              },
              ...c
            };
          },
          menuPortal: (s, d) => {
            var p;
            const a = (p = l.styles) == null ? void 0 : p.menuPortal, c = typeof a == "function" ? a(s, d) : {};
            return {
              ...s,
              zIndex: 9999,
              ...c
            };
          }
        }
      }
    ),
    /* @__PURE__ */ y.jsx(Nu, { value: l.errors ?? [] }),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "mt-1.5 text-xs text-gray-500", children: l.helpText })
  ] });
}, vo = {
  primary: "text-primary-400",
  amber: "text-amber-400",
  blue: "text-blue-400",
  cyan: "text-cyan-400",
  emerald: "text-emerald-400",
  fuchsia: "text-fuchsia-400",
  green: "text-green-400",
  gray: "text-gray-400",
  indigo: "text-indigo-400",
  lime: "text-lime-400",
  orange: "text-orange-400",
  pink: "text-pink-400",
  purple: "text-purple-400",
  red: "text-red-400",
  rose: "text-rose-400",
  sky: "text-sky-400",
  teal: "text-teal-400",
  violet: "text-violet-400",
  yellow: "text-yellow-400"
}, RN = {
  primary: "text-primary-800",
  amber: "text-amber-800",
  blue: "text-blue-800",
  cyan: "text-cyan-800",
  emerald: "text-emerald-800",
  fuchsia: "text-fuchsia-800",
  green: "text-green-800",
  gray: "text-gray-800",
  indigo: "text-indigo-800",
  lime: "text-lime-800",
  orange: "text-orange-800",
  pink: "text-pink-800",
  purple: "text-purple-800",
  red: "text-red-800",
  rose: "text-rose-800",
  sky: "text-sky-800",
  teal: "text-teal-800",
  violet: "text-violet-800",
  yellow: "text-yellow-800"
}, ON = {
  primary: "bg-primary-50",
  amber: "bg-amber-50",
  blue: "bg-blue-50",
  cyan: "bg-cyan-50",
  emerald: "bg-emerald-50",
  fuchsia: "bg-fuchsia-50",
  green: "bg-green-50",
  gray: "bg-gray-50",
  indigo: "bg-indigo-50",
  lime: "bg-lime-50",
  orange: "bg-orange-50",
  pink: "bg-pink-50",
  purple: "bg-purple-50",
  red: "bg-red-50",
  rose: "bg-rose-50",
  sky: "bg-sky-50",
  teal: "bg-teal-50",
  violet: "bg-violet-50",
  yellow: "bg-yellow-50"
}, FN = {
  primary: "bg-primary-50 text-primary-500 hover:bg-primary-100 focus:ring-offset-primary-50 focus-ring-primary-600",
  amber: "bg-amber-50 text-amber-500 hover:bg-amber-100 focus:ring-offset-amber-50 focus-ring-amber-600",
  blue: "bg-blue-50 text-blue-500 hover:bg-blue-100 focus:ring-offset-blue-50 focus-ring-blue-600",
  cyan: "bg-cyan-50 text-cyan-500 hover:bg-cyan-100 focus:ring-offset-cyan-50 focus-ring-cyan-600",
  emerald: "bg-emerald-50 text-emerald-500 hover:bg-emerald-100 focus:ring-offset-emerald-50 focus-ring-emerald-600",
  fuchsia: "bg-fuchsia-50 text-fuchsia-500 hover:bg-fuchsia-100 focus:ring-offset-fuchsia-50 focus-ring-fuchsia-600",
  green: "bg-green-50 text-green-500 hover:bg-green-100 focus:ring-offset-green-50 focus-ring-green-600",
  gray: "bg-gray-50 text-gray-500 hover:bg-gray-100 focus:ring-offset-gray-50 focus-ring-gray-600",
  indigo: "bg-indigo-50 text-indigo-500 hover:bg-indigo-100 focus:ring-offset-indigo-50 focus-ring-indigo-600",
  lime: "bg-lime-50 text-lime-500 hover:bg-lime-100 focus:ring-offset-lime-50 focus-ring-lime-600",
  orange: "bg-orange-50 text-orange-500 hover:bg-orange-100 focus:ring-offset-orange-50 focus-ring-orange-600",
  pink: "bg-pink-50 text-pink-500 hover:bg-pink-100 focus:ring-offset-pink-50 focus-ring-pink-600",
  purple: "bg-purple-50 text-purple-500 hover:bg-purple-100 focus:ring-offset-purple-50 focus-ring-purple-600",
  red: "bg-red-50 text-red-500 hover:bg-red-100 focus:ring-offset-red-50 focus-ring-red-600",
  rose: "bg-rose-50 text-rose-500 hover:bg-rose-100 focus:ring-offset-rose-50 focus-ring-rose-600",
  sky: "bg-sky-50 text-sky-500 hover:bg-sky-100 focus:ring-offset-sky-50 focus-ring-sky-600",
  teal: "bg-teal-50 text-teal-500 hover:bg-teal-100 focus:ring-offset-teal-50 focus-ring-teal-600",
  violet: "bg-violet-50 text-violet-500 hover:bg-violet-100 focus:ring-offset-violet-50 focus-ring-violet-600",
  yellow: "bg-yellow-50 text-yellow-500 hover:bg-yellow-100 focus:ring-offset-yellow-50 focus-ring-yellow-600"
}, E_ = (l) => /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsx("div", { className: wl(`rounded-md ${ON[l.color]} p-4`, l.className), children: /* @__PURE__ */ y.jsxs("div", { className: `flex ${l.centered ? "justify-center" : ""}`, children: [
  /* @__PURE__ */ y.jsxs("div", { className: "flex-shrink-0", children: [
    l.type == "success" && /* @__PURE__ */ y.jsx(Sc, { className: `h-5 w-5 ${vo[l.color]}`, "aria-hidden": "true" }),
    l.type == "warning" && /* @__PURE__ */ y.jsx(nC, { className: `h-5 w-5 ${vo[l.color]}`, "aria-hidden": "true" }),
    l.type == "danger" && /* @__PURE__ */ y.jsx(G4, { className: `h-5 w-5 ${vo[l.color]}`, "aria-hidden": "true" }),
    l.type == "info" && /* @__PURE__ */ y.jsx(L4, { className: `h-5 w-5 ${vo[l.color]}`, "aria-hidden": "true" })
  ] }),
  /* @__PURE__ */ y.jsxs("div", { className: "ml-3", children: [
    /* @__PURE__ */ y.jsx("p", { className: `text-sm font-medium ${RN[l.color]}`, children: l.label }),
    l.children
  ] }),
  l.dismissable && /* @__PURE__ */ y.jsx("div", { className: "ml-auto pl-3", children: /* @__PURE__ */ y.jsx("div", { className: "-mx-1.5 -my-1.5", children: /* @__PURE__ */ y.jsxs(
    "button",
    {
      onClick: l.onDismiss,
      type: "button",
      className: `
                                inline-flex
                                rounded-md p-1.5
                                focus:outline-none focus:ring-2 focus:ring-offset-2
                                ${FN[l.color]}
                            `,
      children: [
        /* @__PURE__ */ y.jsx("span", { className: "sr-only", children: "Dismiss" }),
        /* @__PURE__ */ y.jsx(j4, { className: "h-5 w-5", "aria-hidden": "true" })
      ]
    }
  ) }) })
] }) }) }), _N = (l) => {
  const n = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    l.indeterminate ? n.current && (n.current.indeterminate = !0) : n.current && (n.current.indeterminate = !1);
  }, [l.indeterminate]), /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsxs("div", { className: "flex items-center", children: [
    /* @__PURE__ */ y.jsx(
      "input",
      {
        ref: n,
        type: "checkbox",
        checked: l.checked,
        ...l.input,
        id: l.input.id,
        className: wl(
          "h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded",
          l.className && l.className,
          l.disabled ? "opacity-50 cursor-not-allowed" : "cursor-pointer"
        ),
        onChange: l.onChange,
        disabled: l.disabled
      }
    ),
    /* @__PURE__ */ y.jsx(
      "label",
      {
        htmlFor: l.input.id,
        className: wl(
          "ml-2 block text-sm font-medium text-gray-700",
          l.disabled ? "opacity-50 cursor-not-allowed" : "cursor-pointer"
        ),
        children: l.label
      }
    )
  ] }) });
}, A_ = (l) => {
  const [n, u] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(l.defaultValue ?? []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => l.onChange && l.onChange(n), [n]);
  const t = !!(l.errors && l.errors.length > 0);
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    l.label && /* @__PURE__ */ y.jsx("label", { className: `block w-full text-sm font-medium text-gray-700 ${l.helpText ? "" : "mb-2"}`, children: l.label }),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "text-xs mb-2 leading-5 text-gray-600", children: l.helpText }),
    /* @__PURE__ */ y.jsx("div", { className: "space-y-0", children: l.options.map((r, o) => /* @__PURE__ */ y.jsx("div", { className: `py-1 ${l.className}`, children: /* @__PURE__ */ y.jsx(
      _N,
      {
        label: r.label,
        input: {
          id: `simple-checkbox-group-${r.value}`,
          type: "checkbox",
          name: l.name,
          value: r.value
        },
        checked: !!n.find((s) => s === r.value),
        indeterminate: r.indeterminate,
        onChange: (s) => {
          s.target.checked ? u((d) => [...d, r.value]) : u((d) => d.filter((a) => a !== r.value));
        }
      }
    ) }, o)) }),
    /* @__PURE__ */ y.jsx(
      Nu,
      {
        value: l.errors ?? [],
        className: wl({
          hasErrors: t
        })
      }
    )
  ] });
}, DN = (l) => /* @__PURE__ */ y.jsxs(
  "svg",
  {
    width: l.width || "35",
    height: l.height || "45",
    viewBox: "0 0 22 27",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: [
      /* @__PURE__ */ y.jsx(
        "path",
        {
          d: "M15.29 13.2969C15.2719 17.7984 13.3516 22.4457 9.38415 24.5598C6.59427 26.0542 0 27.2024 0 22.3364C0 22.3364 0 4.23917 0 4.22094C0 1.52368 2.26452 0.630662 4.52903 0.758235C7.89863 0.940483 11.1233 2.52604 13.0799 5.442C14.3299 7.30093 15.0183 9.54257 15.2357 11.8024C15.2538 12.3127 15.29 12.8048 15.29 13.2969Z",
          fill: "#7047EB"
        }
      ),
      /* @__PURE__ */ y.jsx(
        "path",
        {
          d: "M21.5402 11.7116C21.1598 7.99377 18.8952 4.87733 15.7612 3.00018C13.6778 1.74267 11.0691 1.43285 9.71037 3.94787C9.71037 3.9661 0.561722 20.8787 0.561722 20.8787C-0.235387 22.3549 -0.0542249 23.5759 0.67042 24.5783C1.75739 26.0727 3.9132 26.7471 5.67047 26.9293C7.30092 27.1115 8.94949 26.9293 10.5256 26.5648C15.2901 25.4713 19.5112 22.2091 20.9424 17.4706C21.504 15.6117 21.7395 13.6617 21.5402 11.7116Z",
          fill: "#FF7D92"
        }
      ),
      /* @__PURE__ */ y.jsx(
        "path",
        {
          d: "M9.38396 24.5781C13.3514 22.4458 15.2717 17.7985 15.2898 13.3152C15.2898 12.8232 15.2717 12.3311 15.2174 11.839C15.0181 9.57915 14.3116 7.3375 13.0615 5.47858C12.3731 4.43976 11.5217 3.5832 10.5615 2.87244C10.2535 3.14581 9.96368 3.5103 9.72817 3.96592C9.72817 3.98415 0.579526 20.8967 0.579526 20.8967C-0.0183065 21.9902 -0.0545421 22.9561 0.253432 23.7945C0.253432 23.8127 0.271549 23.8309 0.271549 23.8491C0.289665 23.8856 0.307779 23.9403 0.325896 23.9767C0.344012 24.0132 0.344014 24.0314 0.36213 24.0678C0.36213 24.0861 0.380247 24.1043 0.380247 24.1043C1.81142 26.8744 6.99263 25.8539 9.38396 24.5781Z",
          fill: "#E23B7B"
        }
      )
    ]
  }
), S_ = (l) => /* @__PURE__ */ y.jsx(y.Fragment, { children: /* @__PURE__ */ y.jsxs("section", { className: "flex flex-col items-center mt-6", children: [
  /* @__PURE__ */ y.jsx(DN, {}),
  /* @__PURE__ */ y.jsx("p", { className: "text-xl mt-4", children: l.title }),
  l.subtitle && /* @__PURE__ */ y.jsx("p", { className: "text-sm text-gray-500 mt-4", children: l.subtitle })
] }) }), P_ = (l) => {
  var s, d, a, c;
  const [n, u] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0), t = l.icon, r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    var p;
    l.counter && u(((p = l.value ?? l.defaultValue) == null ? void 0 : p.toString().length) ?? 0);
  }, [l.defaultValue, l.value]);
  const o = !!(l.errors && l.errors.length > 0);
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    typeof l.label == "string" ? /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: ((s = l.input) == null ? void 0 : s.id) ?? r,
        className: wl(
          "cursor-pointer text-sm font-medium leading-[21px] text-gray-900  mb-2 inline-block",
          l.disabled && "cursor-not-allowed opacity-50"
        ),
        children: [
          l.label,
          l.required && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ) : l.label,
    /* @__PURE__ */ y.jsxs(
      "div",
      {
        className: wl(
          "flex h-10 items-center rounded ring-1 ring-[#E9E9E9] focus-within:ring-2 focus-within:ring-primary-500",
          o && "hasErrors ring-2 ring-red-500 focus:ring-red-500"
        ),
        children: [
          l.addOnLeft && /* @__PURE__ */ y.jsx("span", { className: "inline-flex h-full items-center rounded-bl rounded-tl bg-[#EAEAEA] px-3 text-sm text-[#4F4F4F]", children: l.addOnLeft }),
          l.icon && /* @__PURE__ */ y.jsx("div", { className: "inline-flex h-full items-center rounded-bl rounded-tl px-3 text-sm", children: /* @__PURE__ */ y.jsx(t, { className: wl("h-5 w-5 text-gray-400", o && "text-red-400"), "aria-hidden": "true" }) }),
          /* @__PURE__ */ y.jsx(
            "input",
            {
              type: "text",
              required: l.required,
              disabled: l.disabled,
              value: l.value,
              id: ((d = l.input) == null ? void 0 : d.id) ?? r,
              defaultValue: l.defaultValue,
              className: wl(
                "h-full w-full rounded border-transparent p-2 text-sm text-[#575757] placeholder:text-[#828282] focus:border-transparent focus:outline-none focus:ring-0 disabled:cursor-not-allowed disabled:opacity-50",
                l.disabled && "disabled",
                l.icon && "pl-0",
                l.className
              ),
              onChange: (p) => {
                l.counter && u(p.target.value.length), l.onChange && l.onChange(p);
              },
              onKeyDown: l.onKeyDown,
              onKeyPress: l.onKeyPress,
              onKeyUp: l.onKeyUp,
              onBlur: l.onBlur,
              onFocus: l.onFocus,
              "aria-invalid": o ? "true" : "false",
              "aria-describedby": `${((a = l.input) == null ? void 0 : a.id) ?? r}-error`,
              ...l.input
            }
          ),
          l.counter && /* @__PURE__ */ y.jsx("div", { className: "inline-flex h-full items-center rounded-br rounded-tr text-sm text-[#4F4F4F]", children: /* @__PURE__ */ y.jsxs("span", { className: "border-l-2 px-3", children: [
            n,
            "/",
            ((c = l.input) == null ? void 0 : c.maxLength) ?? "∞"
          ] }) }),
          l.addOnRight && /* @__PURE__ */ y.jsx("span", { className: "inline-flex h-full items-center rounded-br rounded-tr bg-[#EAEAEA] px-3 text-sm text-[#4F4F4F]", children: l.addOnRight }),
          l.children
        ]
      }
    ),
    /* @__PURE__ */ y.jsx(Nu, { value: l.errors ?? [] }),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "mt-1.5 text-xs text-gray-500", children: l.helpText })
  ] });
}, N_ = (l) => {
  const [n, u] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(void 0), t = !!(l.errors && l.errors.length > 0);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    u(l.value ?? l.defaultValue);
  }, [l.value, l.defaultValue]), /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    l.label && /* @__PURE__ */ y.jsx(
      "label",
      {
        htmlFor: l.name,
        className: `block w-full text-sm font-medium text-gray-700 ${l.helpText ? "" : "mb-2"}`,
        children: l.label
      }
    ),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "text-xs mb-2 leading-5 text-gray-600", children: l.helpText }),
    /* @__PURE__ */ y.jsx("div", { className: "space-y-0", children: l.options.map((r, o) => /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: `${l.name}-${r.value}-${o}`,
        className: Kn(
          "flex items-center py-2 px-4 rounded-md w-full text-sm font-medium text-gray-700",
          l.optionClass,
          r.value === n && l.selectedOptionClass
        ),
        children: [
          /* @__PURE__ */ y.jsx(
            "input",
            {
              id: `${l.name}-${r.value}-${o}`,
              type: "radio",
              name: l.name,
              value: r.value,
              checked: r.value === n,
              className: wl(
                "h-4 w-4 border-gray-300 text-primary-600 focus:ring-primary-500",
                t && "hasErrors"
              ),
              onChange: (s) => {
                u(s.target.value), l.onChange && l.onChange(s);
              }
            }
          ),
          r.label && /* @__PURE__ */ y.jsx("span", { className: "ml-3", children: r.label })
        ]
      },
      o
    )) }),
    /* @__PURE__ */ y.jsx(Nu, { value: l.errors ?? [] })
  ] });
}, T_ = (l) => {
  function n(t) {
    t = t.replace(/^\s+|\s+$/g, ""), t = t.toLowerCase();
    const r = "àáäâèéëêìíïîòóöôùúüûñç·/_,:;", o = "aaaaeeeeiiiioooouuuunc------";
    for (let s = 0, d = r.length; s < d; s++)
      t = t.replace(new RegExp(r.charAt(s), "g"), o.charAt(s));
    return t = t.replace(/[^a-z0-9 -]/g, "").replace(/\s+/g, "-").replace(/-+/g, "-"), t;
  }
  const u = !!(l.errors && l.errors.length > 0);
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: `${n(l.label)}-simple-select`,
        className: wl(
          "cursor-pointer text-sm font-medium leading-[21px] text-gray-900  mb-2 inline-block",
          l.disabled && "cursor-not-allowed opacity-50"
        ),
        children: [
          l.label,
          l.required && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ),
    /* @__PURE__ */ y.jsxs(
      "select",
      {
        value: l.value || "",
        required: l.required,
        onChange: l.onChange,
        id: `${n(l.label)}-simple-select`,
        name: `${n(l.label)}-simple-select`,
        className: wl(
          "h-10 w-full rounded border-0 text-sm ring-1 focus:ring-2 ring-gray-200 ps-3 focus:outline-none focus:ring-primary-500",
          u && "ring-red-500 focus:ring-red-500 hasErrors"
        ),
        style: { fontSize: "14px" },
        disabled: l.disabled,
        children: [
          l.placeholder && /* @__PURE__ */ y.jsx("option", { disabled: !0, value: "", children: l.placeholder }),
          l.options.map((t, r) => Array.isArray(t.value) ? /* @__PURE__ */ y.jsx("optgroup", { label: t.label, children: t.value.map((o, s) => {
            var d;
            return /* @__PURE__ */ y.jsx(
              "option",
              {
                value: typeof l.value == "object" ? (d = l == null ? void 0 : l.value) == null ? void 0 : d.toString() : o.value,
                children: o.label
              },
              s
            );
          }) }, r) : typeof t.value == "string" ? /* @__PURE__ */ y.jsx("option", { value: t.value, children: t.label }, r) : typeof t.value == "number" ? /* @__PURE__ */ y.jsx("option", { value: t.value, children: t.label }, r) : null)
        ]
      }
    ),
    /* @__PURE__ */ y.jsx(Nu, { value: l.errors ?? [] }),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "mt-1.5 text-xs text-gray-500", children: l.helpText })
  ] });
};
var MN = ["allowCreateWhileLoading", "createOptionPosition", "formatCreateLabel", "isValidNewOption", "getNewOptionData", "onCreateOption", "options", "onChange"], h3 = function() {
  var n = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "", u = arguments.length > 1 ? arguments[1] : void 0, t = arguments.length > 2 ? arguments[2] : void 0, r = String(n).toLowerCase(), o = String(t.getOptionValue(u)).toLowerCase(), s = String(t.getOptionLabel(u)).toLowerCase();
  return o === r || s === r;
}, cd = {
  formatCreateLabel: function(n) {
    return 'Create "'.concat(n, '"');
  },
  isValidNewOption: function(n, u, t, r) {
    return !(!n || u.some(function(o) {
      return h3(n, o, r);
    }) || t.some(function(o) {
      return h3(n, o, r);
    }));
  },
  getNewOptionData: function(n, u) {
    return {
      label: u,
      value: n,
      __isNew__: !0
    };
  }
};
function BN(l) {
  var n = l.allowCreateWhileLoading, u = n === void 0 ? !1 : n, t = l.createOptionPosition, r = t === void 0 ? "last" : t, o = l.formatCreateLabel, s = o === void 0 ? cd.formatCreateLabel : o, d = l.isValidNewOption, a = d === void 0 ? cd.isValidNewOption : d, c = l.getNewOptionData, p = c === void 0 ? cd.getNewOptionData : c, g = l.onCreateOption, m = l.options, v = m === void 0 ? [] : m, $ = l.onChange, b = ne(l, MN), E = b.getOptionValue, S = E === void 0 ? Bp : E, A = b.getOptionLabel, x = A === void 0 ? Mp : A, I = b.inputValue, P = b.isLoading, O = b.isMulti, _ = b.value, j = b.name, z = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    return a(I, qo(_), v, {
      getOptionValue: S,
      getOptionLabel: x
    }) ? p(I, s(I)) : void 0;
  }, [s, p, x, S, I, a, v, _]), Y = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function() {
    return (u || !P) && z ? r === "first" ? [z].concat(qt(v)) : [].concat(qt(v), [z]) : v;
  }, [u, r, P, z, v]), el = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function(U, ul) {
    if (ul.action !== "select-option")
      return $(U, ul);
    var il = Array.isArray(U) ? U : [U];
    if (il[il.length - 1] === z) {
      if (g) g(I);
      else {
        var rl = p(I, I), tl = {
          action: "create-option",
          name: j,
          option: rl
        };
        $(Hr(O, [].concat(qt(qo(_)), [rl]), rl), tl);
      }
      return;
    }
    $(U, ul);
  }, [p, I, O, j, z, g, $, _]);
  return yl(yl({}, b), {}, {
    options: Y,
    onChange: el
  });
}
var LN = /* @__PURE__ */ (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function(l, n) {
  var u = xa(l), t = BN(u);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Sa, El({
    ref: n
  }, t));
}), GN = LN;
const R_ = (l) => {
  const n = l.id || Math.random().toString(), u = (s) => /* @__PURE__ */ y.jsx(Zc.MultiValueRemove, { ...s, children: /* @__PURE__ */ y.jsx("span", { className: "text-primary-600", children: "×" }) }), t = () => /* @__PURE__ */ y.jsx("div", { className: "px-2", children: /* @__PURE__ */ y.jsx(B4, { className: "h-5 text-gray-400" }) }), r = () => null, o = !!(l.errors && l.errors.length > 0);
  return /* @__PURE__ */ y.jsxs("div", { className: "react-select", children: [
    l.label && /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: n,
        className: Kn(
          "inline-block cursor-pointer text-sm font-medium leading-[21px] text-gray-900",
          l.disabled && "cursor-not-allowed opacity-70"
        ),
        children: [
          l.label,
          l.required && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ),
    /* @__PURE__ */ y.jsx(
      GN,
      {
        ...l,
        inputId: n,
        menuPortalTarget: document.body,
        menuPosition: "absolute",
        isDisabled: l.disabled,
        className: wl(
          {
            hasErrors: o,
            "border rounded": l.disabled
          },
          l.className
        ),
        placeholder: /* @__PURE__ */ y.jsx("div", { className: "text-sm text-gray-400", children: l.placeholder || "Search" }),
        components: {
          MultiValueRemove: u,
          DropdownIndicator: t,
          IndicatorSeparator: r
        },
        classNames: {
          control: ({ isFocused: s }) => o && s ? "!border-2 !border-danger-500" : s ? "!border-2 !border-primary-500" : o ? "!border !border-danger-500" : "!border-gray-200"
        },
        styles: {
          control: (s) => ({
            ...s,
            minHeight: "40px",
            boxShadow: "none",
            borderRadius: "5px",
            fontSize: "14px"
          }),
          option: (s) => ({
            ...s,
            fontSize: "0.875rem"
          }),
          multiValue: (s) => ({
            ...s,
            background: "var(--colors-primary-50)",
            borderRadius: "0.25rem"
          }),
          multiValueLabel: (s) => ({
            ...s,
            color: "var(--colors-primary-600)"
          }),
          multiValueRemove: (s) => ({
            ...s,
            color: "var(--colors-primary-600)",
            ":hover": {
              background: "var(--colors-primary-100)"
            }
          }),
          menuPortal: (s) => ({
            ...s,
            zIndex: 9999
          }),
          noOptionsMessage: (s) => ({
            ...s,
            fontSize: "0.875rem",
            color: "var(--colors-gray-800)"
          })
        },
        theme: (s) => ({
          ...s,
          colors: {
            ...s.colors,
            primary: "var(--colors-primary-500)",
            primary75: "var(--colors-primary-200)",
            primary50: "var(--colors-primary-100)",
            primary25: "var(--colors-primary-50)",
            neutral5: "var(--colors-gray-100)",
            neutral10: "var(--colors-gray-100)",
            neutral20: "var(--colors-gray-200)",
            neutral30: "var(--colors-gray-200)",
            neutral40: "var(--colors-gray-400)",
            neutral50: "var(--colors-gray-500)",
            neutral60: "var(--colors-gray-600)",
            neutral70: "var(--colors-gray-700)",
            neutral80: "var(--colors-gray-800)",
            neutral90: "var(--colors-gray-900)"
          }
        })
      }
    ),
    /* @__PURE__ */ y.jsx(Nu, { value: l.errors ?? [] }),
    l.helpText && /* @__PURE__ */ y.jsx("span", { className: "text-xs text-gray-600", children: l.helpText })
  ] });
}, O_ = ({
  input: l,
  label: n,
  className: u,
  errors: t,
  defaultValue: r,
  value: o,
  onChange: s,
  helpText: d,
  disabled: a,
  required: c
}) => {
  const p = !!(t && t.length > 0);
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    typeof n == "string" ? /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: l.id,
        className: wl(
          "cursor-pointer text-sm font-medium leading-[21px] text-gray-900  mb-2 inline-block",
          a && "cursor-not-allowed opacity-50"
        ),
        children: [
          n,
          c && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ) : n,
    /* @__PURE__ */ y.jsx(
      "textarea",
      {
        required: c,
        className: wl(
          "w-full rounded border-0 px-4 py-2.5 text-sm leading-5 text-gray-800 ring-1 ring-gray-200 placeholder:text-gray-400 focus:ring-2 focus:ring-primary-600 disabled:cursor-not-allowed disabled:opacity-50",
          p && "ring-red-500 focus:ring-red-500 hasErrors",
          u,
          a && "disabled"
        ),
        onChange: s,
        "aria-invalid": t ? "true" : "false",
        "aria-describedby": `${l.id}-error`,
        value: o,
        defaultValue: r,
        disabled: a,
        ...l
      }
    ),
    /* @__PURE__ */ y.jsx(Nu, { value: t ?? [] }),
    d && /* @__PURE__ */ y.jsx("p", { className: "mt-1.5 text-xs text-gray-500", children: d })
  ] });
};
function jN(l, n, { checkForDefaultPrevented: u = !0 } = {}) {
  return function(r) {
    if (l == null || l(r), u === !1 || !r.defaultPrevented)
      return n == null ? void 0 : n(r);
  };
}
function m3(l, n) {
  if (typeof l == "function")
    return l(n);
  l != null && (l.current = n);
}
function Xp(...l) {
  return (n) => {
    let u = !1;
    const t = l.map((r) => {
      const o = m3(r, n);
      return !u && typeof o == "function" && (u = !0), o;
    });
    if (u)
      return () => {
        for (let r = 0; r < t.length; r++) {
          const o = t[r];
          typeof o == "function" ? o() : m3(l[r], null);
        }
      };
  };
}
function zp(...l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(Xp(...l), l);
}
function WN(l, n = []) {
  let u = [];
  function t(o, s) {
    const d = react__WEBPACK_IMPORTED_MODULE_0__.createContext(s), a = u.length;
    u = [...u, s];
    const c = (g) => {
      var S;
      const { scope: m, children: v, ...$ } = g, b = ((S = m == null ? void 0 : m[l]) == null ? void 0 : S[a]) || d, E = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => $, Object.values($));
      return /* @__PURE__ */ y.jsx(b.Provider, { value: E, children: v });
    };
    c.displayName = o + "Provider";
    function p(g, m) {
      var b;
      const v = ((b = m == null ? void 0 : m[l]) == null ? void 0 : b[a]) || d, $ = react__WEBPACK_IMPORTED_MODULE_0__.useContext(v);
      if ($) return $;
      if (s !== void 0) return s;
      throw new Error(`\`${g}\` must be used within \`${o}\``);
    }
    return [c, p];
  }
  const r = () => {
    const o = u.map((s) => react__WEBPACK_IMPORTED_MODULE_0__.createContext(s));
    return function(d) {
      const a = (d == null ? void 0 : d[l]) || o;
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(
        () => ({ [`__scope${l}`]: { ...d, [l]: a } }),
        [d, a]
      );
    };
  };
  return r.scopeName = l, [t, VN(r, ...n)];
}
function VN(...l) {
  const n = l[0];
  if (l.length === 1) return n;
  const u = () => {
    const t = l.map((r) => ({
      useScope: r(),
      scopeName: r.scopeName
    }));
    return function(o) {
      const s = t.reduce((d, { useScope: a, scopeName: c }) => {
        const g = a(o)[`__scope${c}`];
        return { ...d, ...g };
      }, {});
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({ [`__scope${n.scopeName}`]: s }), [s]);
    };
  };
  return u.scopeName = n.scopeName, u;
}
var Yp = globalThis != null && globalThis.document ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : () => {
}, kN = /*#__PURE__*/ (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache || (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache = __webpack_require__.t(react__WEBPACK_IMPORTED_MODULE_0__, 2)))[" useInsertionEffect ".trim().toString()] || Yp;
function HN({
  prop: l,
  defaultProp: n,
  onChange: u = () => {
  },
  caller: t
}) {
  const [r, o, s] = ZN({
    defaultProp: n,
    onChange: u
  }), d = l !== void 0, a = d ? l : r;
  {
    const p = react__WEBPACK_IMPORTED_MODULE_0__.useRef(l !== void 0);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      const g = p.current;
      g !== d && console.warn(
        `${t} is changing from ${g ? "controlled" : "uncontrolled"} to ${d ? "controlled" : "uncontrolled"}. Components should not switch from controlled to uncontrolled (or vice versa). Decide between using a controlled or uncontrolled value for the lifetime of the component.`
      ), p.current = d;
    }, [d, t]);
  }
  const c = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(
    (p) => {
      var g;
      if (d) {
        const m = XN(p) ? p(l) : p;
        m !== l && ((g = s.current) == null || g.call(s, m));
      } else
        o(p);
    },
    [d, l, o, s]
  );
  return [a, c];
}
function ZN({
  defaultProp: l,
  onChange: n
}) {
  const [u, t] = react__WEBPACK_IMPORTED_MODULE_0__.useState(l), r = react__WEBPACK_IMPORTED_MODULE_0__.useRef(u), o = react__WEBPACK_IMPORTED_MODULE_0__.useRef(n);
  return kN(() => {
    o.current = n;
  }, [n]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    var s;
    r.current !== u && ((s = o.current) == null || s.call(o, u), r.current = u);
  }, [u, r]), [u, t, o];
}
function XN(l) {
  return typeof l == "function";
}
function zN(l) {
  const n = react__WEBPACK_IMPORTED_MODULE_0__.useRef({ value: l, previous: l });
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (n.current.value !== l && (n.current.previous = n.current.value, n.current.value = l), n.current.previous), [l]);
}
function YN(l) {
  const [n, u] = react__WEBPACK_IMPORTED_MODULE_0__.useState(void 0);
  return Yp(() => {
    if (l) {
      u({ width: l.offsetWidth, height: l.offsetHeight });
      const t = new ResizeObserver((r) => {
        if (!Array.isArray(r) || !r.length)
          return;
        const o = r[0];
        let s, d;
        if ("borderBoxSize" in o) {
          const a = o.borderBoxSize, c = Array.isArray(a) ? a[0] : a;
          s = c.inlineSize, d = c.blockSize;
        } else
          s = l.offsetWidth, d = l.offsetHeight;
        u({ width: s, height: d });
      });
      return t.observe(l, { box: "border-box" }), () => t.unobserve(l);
    } else
      u(void 0);
  }, [l]), n;
}
// @__NO_SIDE_EFFECTS__
function UN(l) {
  const n = /* @__PURE__ */ JN(l), u = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((t, r) => {
    const { children: o, ...s } = t, d = react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(o), a = d.find(QN);
    if (a) {
      const c = a.props.children, p = d.map((g) => g === a ? react__WEBPACK_IMPORTED_MODULE_0__.Children.count(c) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(c) ? c.props.children : null : g);
      return /* @__PURE__ */ y.jsx(n, { ...s, ref: r, children: react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(c) ? react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(c, void 0, p) : null });
    }
    return /* @__PURE__ */ y.jsx(n, { ...s, ref: r, children: o });
  });
  return u.displayName = `${l}.Slot`, u;
}
// @__NO_SIDE_EFFECTS__
function JN(l) {
  const n = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((u, t) => {
    const { children: r, ...o } = u;
    if (react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(r)) {
      const s = lT(r), d = qN(o, r.props);
      return r.type !== react__WEBPACK_IMPORTED_MODULE_0__.Fragment && (d.ref = t ? Xp(t, s) : s), react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(r, d);
    }
    return react__WEBPACK_IMPORTED_MODULE_0__.Children.count(r) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : null;
  });
  return n.displayName = `${l}.SlotClone`, n;
}
var KN = Symbol("radix.slottable");
function QN(l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(l) && typeof l.type == "function" && "__radixId" in l.type && l.type.__radixId === KN;
}
function qN(l, n) {
  const u = { ...n };
  for (const t in n) {
    const r = l[t], o = n[t];
    /^on[A-Z]/.test(t) ? r && o ? u[t] = (...d) => {
      o(...d), r(...d);
    } : r && (u[t] = r) : t === "style" ? u[t] = { ...r, ...o } : t === "className" && (u[t] = [r, o].filter(Boolean).join(" "));
  }
  return { ...l, ...u };
}
function lT(l) {
  var t, r;
  let n = (t = Object.getOwnPropertyDescriptor(l.props, "ref")) == null ? void 0 : t.get, u = n && "isReactWarning" in n && n.isReactWarning;
  return u ? l.ref : (n = (r = Object.getOwnPropertyDescriptor(l, "ref")) == null ? void 0 : r.get, u = n && "isReactWarning" in n && n.isReactWarning, u ? l.props.ref : l.props.ref || l.ref);
}
var nT = [
  "a",
  "button",
  "div",
  "form",
  "h2",
  "h3",
  "img",
  "input",
  "label",
  "li",
  "nav",
  "ol",
  "p",
  "select",
  "span",
  "svg",
  "ul"
], Up = nT.reduce((l, n) => {
  const u = /* @__PURE__ */ UN(`Primitive.${n}`), t = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((r, o) => {
    const { asChild: s, ...d } = r, a = s ? u : n;
    return typeof window < "u" && (window[Symbol.for("radix-ui")] = !0), /* @__PURE__ */ y.jsx(a, { ...d, ref: o });
  });
  return t.displayName = `Primitive.${n}`, { ...l, [n]: t };
}, {}), Pa = "Switch", [uT, F_] = WN(Pa), [eT, tT] = uT(Pa), Jp = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const {
      __scopeSwitch: u,
      name: t,
      checked: r,
      defaultChecked: o,
      required: s,
      disabled: d,
      value: a = "on",
      onCheckedChange: c,
      form: p,
      ...g
    } = l, [m, v] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), $ = zp(n, (x) => v(x)), b = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), E = m ? p || !!m.closest("form") : !0, [S, A] = HN({
      prop: r,
      defaultProp: o ?? !1,
      onChange: c,
      caller: Pa
    });
    return /* @__PURE__ */ y.jsxs(eT, { scope: u, checked: S, disabled: d, children: [
      /* @__PURE__ */ y.jsx(
        Up.button,
        {
          type: "button",
          role: "switch",
          "aria-checked": S,
          "aria-required": s,
          "data-state": l5(S),
          "data-disabled": d ? "" : void 0,
          disabled: d,
          value: a,
          ...g,
          ref: $,
          onClick: jN(l.onClick, (x) => {
            A((I) => !I), E && (b.current = x.isPropagationStopped(), b.current || x.stopPropagation());
          })
        }
      ),
      E && /* @__PURE__ */ y.jsx(
        qp,
        {
          control: m,
          bubbles: !b.current,
          name: t,
          value: a,
          checked: S,
          required: s,
          disabled: d,
          form: p,
          style: { transform: "translateX(-100%)" }
        }
      )
    ] });
  }
);
Jp.displayName = Pa;
var Kp = "SwitchThumb", Qp = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const { __scopeSwitch: u, ...t } = l, r = tT(Kp, u);
    return /* @__PURE__ */ y.jsx(
      Up.span,
      {
        "data-state": l5(r.checked),
        "data-disabled": r.disabled ? "" : void 0,
        ...t,
        ref: n
      }
    );
  }
);
Qp.displayName = Kp;
var rT = "SwitchBubbleInput", qp = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  ({
    __scopeSwitch: l,
    control: n,
    checked: u,
    bubbles: t = !0,
    ...r
  }, o) => {
    const s = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), d = zp(s, o), a = zN(u), c = YN(n);
    return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      const p = s.current;
      if (!p) return;
      const g = window.HTMLInputElement.prototype, v = Object.getOwnPropertyDescriptor(
        g,
        "checked"
      ).set;
      if (a !== u && v) {
        const $ = new Event("click", { bubbles: t });
        v.call(p, u), p.dispatchEvent($);
      }
    }, [a, u, t]), /* @__PURE__ */ y.jsx(
      "input",
      {
        type: "checkbox",
        "aria-hidden": !0,
        defaultChecked: u,
        ...r,
        tabIndex: -1,
        ref: d,
        style: {
          ...r.style,
          ...c,
          position: "absolute",
          pointerEvents: "none",
          opacity: 0,
          margin: 0
        }
      }
    );
  }
);
qp.displayName = rT;
function l5(l) {
  return l ? "checked" : "unchecked";
}
var iT = Jp, oT = Qp;
const aT = {
  amber: "bg-amber-500",
  blue: "bg-blue-500",
  cyan: "bg-cyan-500",
  emerald: "bg-emerald-500",
  fuchsia: "bg-fuchsia-500",
  green: "bg-green-500",
  gray: "bg-gray-500",
  indigo: "bg-indigo-500",
  lime: "bg-lime-500",
  orange: "bg-orange-500",
  pink: "bg-pink-500",
  purple: "bg-purple-500",
  red: "bg-red-500",
  rose: "bg-rose-500",
  sky: "bg-sky-500",
  teal: "bg-teal-500",
  violet: "bg-violet-500",
  yellow: "bg-yellow-500",
  primary: "bg-primary-500",
  secondary: "bg-secondary-500",
  danger: "bg-danger-500",
  white: "bg-white"
}, __ = ({
  checked: l,
  onChange: n,
  color: u = "primary",
  children: t,
  label: r,
  name: o,
  value: s,
  defaultChecked: d,
  helpText: a,
  disabled: c = !1,
  id: p,
  required: g
}) => {
  const m = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), v = p || `toggle-${m}`;
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    /* @__PURE__ */ y.jsxs("div", { className: "flex items-center relative", children: [
      /* @__PURE__ */ y.jsx(
        iT,
        {
          id: v,
          defaultChecked: d,
          name: o,
          value: s,
          checked: l,
          onCheckedChange: n,
          disabled: c,
          className: `${l ? aT[u] : "bg-gray-200"} ${c ? "opacity-50 cursor-not-allowed" : ""} relative inline-flex items-center h-5 w-10 rounded-full outline-none`,
          required: g,
          children: /* @__PURE__ */ y.jsx(
            oT,
            {
              className: `${l ? "translate-x-6" : "translate-x-1"} block h-3.5 w-3.5 rounded-full bg-white transition-transform duration-200 ease-in-out`
            }
          )
        }
      ),
      t || r && /* @__PURE__ */ y.jsxs(
        "label",
        {
          htmlFor: v,
          className: `ms-2.5 text-sm font-medium text-gray-900 ${c ? "opacity-50 cursor-not-allowed" : "cursor-pointer"}`,
          children: [
            r,
            g && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
          ]
        }
      )
    ] }),
    a && /* @__PURE__ */ y.jsx("p", { className: `mt-2.5 text-xs text-gray-400 ${c ? "opacity-50" : ""}`, children: a })
  ] });
}, D_ = (l) => {
  var o, s, d;
  const n = l.icon, u = l.btnIcon, t = !!(l.errors && l.errors.length > 0), r = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)();
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    typeof l.label == "string" ? /* @__PURE__ */ y.jsxs(
      "label",
      {
        htmlFor: ((o = l.input) == null ? void 0 : o.id) ?? r,
        className: wl(
          "cursor-pointer text-sm font-medium leading-[21px] text-gray-900  mb-2 inline-block",
          l.disabled && "cursor-not-allowed opacity-50"
        ),
        children: [
          l.label,
          l.required && /* @__PURE__ */ y.jsx("span", { className: "ms-0.5 text-danger-500", children: "*" })
        ]
      }
    ) : l.label,
    /* @__PURE__ */ y.jsxs("div", { className: "relative flex items-stretch flex-grow focus-within:z-10", children: [
      l.icon && /* @__PURE__ */ y.jsx("div", { className: "absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none", children: /* @__PURE__ */ y.jsx(n, { className: "h-5 w-5 text-gray-400", "aria-hidden": "true" }) }),
      /* @__PURE__ */ y.jsx(
        "input",
        {
          required: l.required,
          disabled: l.disabled,
          id: ((s = l.input) == null ? void 0 : s.id) ?? r,
          className: wl(
            "w-full h-10 rounded border-0 px-4 py-2.5 text-sm leading-5 text-gray-800 ring-1 focus:ring-2 ring-gray-200 placeholder:text-gray-400 focus:ring-primary-600 disabled:cursor-not-allowed disabled:opacity-50",
            t && "ring-red-500 focus:ring-red-500 hasErrors",
            l.icon && "pl-10",
            l.className
          ),
          value: l.value,
          defaultValue: l.defaultValue,
          onChange: l.onChange,
          onKeyDown: l.onKeyDown,
          onKeyPress: l.onKeyPress,
          onKeyUp: l.onKeyUp,
          onBlur: l.onBlur,
          onFocus: l.onFocus,
          "aria-invalid": t ? "true" : "false",
          "aria-describedby": `${((d = l.input) == null ? void 0 : d.id) ?? r}-error`,
          ...l.input
        }
      ),
      /* @__PURE__ */ y.jsxs(
        "button",
        {
          onClick: l.onBtnClick && l.onBtnClick,
          type: "button",
          className: "absolute right-2.5 top-1/2 -translate-y-1/2 inline-flex items-center gap-1",
          children: [
            /* @__PURE__ */ y.jsx(u, { className: "h-5 w-5 text-gray-400", "aria-hidden": "true" }),
            l.btnLabel && /* @__PURE__ */ y.jsx("span", { children: l.btnLabel })
          ]
        }
      )
    ] }),
    /* @__PURE__ */ y.jsx(Nu, { value: l.errors ?? [] }),
    l.helpText && /* @__PURE__ */ y.jsx("p", { className: "mt-1.5 text-xs text-gray-500", children: l.helpText })
  ] });
}, M_ = (l) => {
  const [n, u] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(l.value), t = (r) => r === n;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    u(l.value);
  }, [l.value]), (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    l.onChange && l.onChange(n ?? "");
  }, [n]), /* @__PURE__ */ y.jsxs("div", { className: "flex flex-col", children: [
    /* @__PURE__ */ y.jsx("section", { className: "flex", children: l.options.map((r, o) => /* @__PURE__ */ y.jsxs(
      "section",
      {
        role: "radio",
        "aria-checked": t(r.value),
        "aria-labelledby": r.label,
        className: `${t(r.value) ? "border border-primary-400" : "border"} mr-1 inline-flex cursor-pointer space-y-1 rounded-md px-3 py-2 ${l.className}`,
        onClick: () => {
          t(r.value) ? l.allowDeselect && u(void 0) : u(r.value);
        },
        children: [
          /* @__PURE__ */ y.jsxs("div", { className: "flex w-full", children: [
            /* @__PURE__ */ y.jsx("section", { className: `pr-2 ${t(r.value) ? "text-primary-500" : "text-gray-500"}`, children: r.icon && /* @__PURE__ */ y.jsx("div", { className: `p-2 ${t(r.value) ? "bg-primary-100" : "bg-gray-100"} rounded-md`, children: r.icon }) }),
            /* @__PURE__ */ y.jsxs("section", { className: "flex flex-col justify-center", children: [
              /* @__PURE__ */ y.jsx("div", { className: "flex", children: /* @__PURE__ */ y.jsx("section", { className: "flex-1", children: /* @__PURE__ */ y.jsx("label", { className: "text-md my-2 cursor-pointer", children: r.label }) }) }),
              r.description && /* @__PURE__ */ y.jsx("div", { className: "mt-1 mb-1", children: /* @__PURE__ */ y.jsx("p", { className: "text-xs leading-4 text-gray-500", children: r.description }) })
            ] })
          ] }),
          /* @__PURE__ */ y.jsxs("section", { className: "flex-none", children: [
            !t(r.value) && /* @__PURE__ */ y.jsx(TN, { className: "h-5 w-5 text-gray-400" }),
            t(r.value) && /* @__PURE__ */ y.jsx(Sc, { className: "h-5 w-5 text-primary-500" })
          ] })
        ]
      },
      o
    )) }),
    /* @__PURE__ */ y.jsx(Nu, { value: l.errors ?? [] })
  ] });
};
function Ae(l, n, { checkForDefaultPrevented: u = !0 } = {}) {
  return function(r) {
    if (l == null || l(r), u === !1 || !r.defaultPrevented)
      return n == null ? void 0 : n(r);
  };
}
function sT(l, n) {
  typeof l == "function" ? l(n) : l != null && (l.current = n);
}
function n5(...l) {
  return (n) => l.forEach((u) => sT(u, n));
}
function Nt(...l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(n5(...l), l);
}
function oi(l, n = []) {
  let u = [];
  function t(o, s) {
    const d = react__WEBPACK_IMPORTED_MODULE_0__.createContext(s), a = u.length;
    u = [...u, s];
    const c = (g) => {
      var S;
      const { scope: m, children: v, ...$ } = g, b = ((S = m == null ? void 0 : m[l]) == null ? void 0 : S[a]) || d, E = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => $, Object.values($));
      return /* @__PURE__ */ y.jsx(b.Provider, { value: E, children: v });
    };
    c.displayName = o + "Provider";
    function p(g, m) {
      var b;
      const v = ((b = m == null ? void 0 : m[l]) == null ? void 0 : b[a]) || d, $ = react__WEBPACK_IMPORTED_MODULE_0__.useContext(v);
      if ($) return $;
      if (s !== void 0) return s;
      throw new Error(`\`${g}\` must be used within \`${o}\``);
    }
    return [c, p];
  }
  const r = () => {
    const o = u.map((s) => react__WEBPACK_IMPORTED_MODULE_0__.createContext(s));
    return function(d) {
      const a = (d == null ? void 0 : d[l]) || o;
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(
        () => ({ [`__scope${l}`]: { ...d, [l]: a } }),
        [d, a]
      );
    };
  };
  return r.scopeName = l, [t, dT(r, ...n)];
}
function dT(...l) {
  const n = l[0];
  if (l.length === 1) return n;
  const u = () => {
    const t = l.map((r) => ({
      useScope: r(),
      scopeName: r.scopeName
    }));
    return function(o) {
      const s = t.reduce((d, { useScope: a, scopeName: c }) => {
        const g = a(o)[`__scope${c}`];
        return { ...d, ...g };
      }, {});
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({ [`__scope${n.scopeName}`]: s }), [s]);
    };
  };
  return u.scopeName = n.scopeName, u;
}
var u5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const { children: u, ...t } = l, r = react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(u), o = r.find(cT);
  if (o) {
    const s = o.props.children, d = r.map((a) => a === o ? react__WEBPACK_IMPORTED_MODULE_0__.Children.count(s) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(s) ? s.props.children : null : a);
    return /* @__PURE__ */ y.jsx(Ud, { ...t, ref: n, children: react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(s) ? react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(s, void 0, d) : null });
  }
  return /* @__PURE__ */ y.jsx(Ud, { ...t, ref: n, children: u });
});
u5.displayName = "Slot";
var Ud = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const { children: u, ...t } = l;
  if (react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(u)) {
    const r = pT(u);
    return react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(u, {
      ...fT(t, u.props),
      // @ts-ignore
      ref: n ? n5(n, r) : r
    });
  }
  return react__WEBPACK_IMPORTED_MODULE_0__.Children.count(u) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : null;
});
Ud.displayName = "SlotClone";
var e5 = ({ children: l }) => /* @__PURE__ */ y.jsx(y.Fragment, { children: l });
function cT(l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(l) && l.type === e5;
}
function fT(l, n) {
  const u = { ...n };
  for (const t in n) {
    const r = l[t], o = n[t];
    /^on[A-Z]/.test(t) ? r && o ? u[t] = (...d) => {
      o(...d), r(...d);
    } : r && (u[t] = r) : t === "style" ? u[t] = { ...r, ...o } : t === "className" && (u[t] = [r, o].filter(Boolean).join(" "));
  }
  return { ...l, ...u };
}
function pT(l) {
  var t, r;
  let n = (t = Object.getOwnPropertyDescriptor(l.props, "ref")) == null ? void 0 : t.get, u = n && "isReactWarning" in n && n.isReactWarning;
  return u ? l.ref : (n = (r = Object.getOwnPropertyDescriptor(l, "ref")) == null ? void 0 : r.get, u = n && "isReactWarning" in n && n.isReactWarning, u ? l.props.ref : l.props.ref || l.ref);
}
var gT = [
  "a",
  "button",
  "div",
  "form",
  "h2",
  "h3",
  "img",
  "input",
  "label",
  "li",
  "nav",
  "ol",
  "p",
  "span",
  "svg",
  "ul"
], et = gT.reduce((l, n) => {
  const u = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((t, r) => {
    const { asChild: o, ...s } = t, d = o ? u5 : n;
    return typeof window < "u" && (window[Symbol.for("radix-ui")] = !0), /* @__PURE__ */ y.jsx(d, { ...s, ref: r });
  });
  return u.displayName = `Primitive.${n}`, { ...l, [n]: u };
}, {});
function hT(l, n) {
  l && react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync(() => l.dispatchEvent(n));
}
function Wu(l) {
  const n = react__WEBPACK_IMPORTED_MODULE_0__.useRef(l);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    n.current = l;
  }), react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (...u) => {
    var t;
    return (t = n.current) == null ? void 0 : t.call(n, ...u);
  }, []);
}
function t5(l, n = globalThis == null ? void 0 : globalThis.document) {
  const u = Wu(l);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const t = (r) => {
      r.key === "Escape" && u(r);
    };
    return n.addEventListener("keydown", t, { capture: !0 }), () => n.removeEventListener("keydown", t, { capture: !0 });
  }, [u, n]);
}
var mT = "DismissableLayer", Jd = "dismissableLayer.update", vT = "dismissableLayer.pointerDownOutside", bT = "dismissableLayer.focusOutside", v3, r5 = react__WEBPACK_IMPORTED_MODULE_0__.createContext({
  layers: /* @__PURE__ */ new Set(),
  layersWithOutsidePointerEventsDisabled: /* @__PURE__ */ new Set(),
  branches: /* @__PURE__ */ new Set()
}), i5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const {
      disableOutsidePointerEvents: u = !1,
      onEscapeKeyDown: t,
      onPointerDownOutside: r,
      onFocusOutside: o,
      onInteractOutside: s,
      onDismiss: d,
      ...a
    } = l, c = react__WEBPACK_IMPORTED_MODULE_0__.useContext(r5), [p, g] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), m = (p == null ? void 0 : p.ownerDocument) ?? (globalThis == null ? void 0 : globalThis.document), [, v] = react__WEBPACK_IMPORTED_MODULE_0__.useState({}), $ = Nt(n, (_) => g(_)), b = Array.from(c.layers), [E] = [...c.layersWithOutsidePointerEventsDisabled].slice(-1), S = b.indexOf(E), A = p ? b.indexOf(p) : -1, x = c.layersWithOutsidePointerEventsDisabled.size > 0, I = A >= S, P = xT((_) => {
      const j = _.target, z = [...c.branches].some((Y) => Y.contains(j));
      !I || z || (r == null || r(_), s == null || s(_), _.defaultPrevented || d == null || d());
    }, m), O = CT((_) => {
      const j = _.target;
      [...c.branches].some((Y) => Y.contains(j)) || (o == null || o(_), s == null || s(_), _.defaultPrevented || d == null || d());
    }, m);
    return t5((_) => {
      A === c.layers.size - 1 && (t == null || t(_), !_.defaultPrevented && d && (_.preventDefault(), d()));
    }, m), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      if (p)
        return u && (c.layersWithOutsidePointerEventsDisabled.size === 0 && (v3 = m.body.style.pointerEvents, m.body.style.pointerEvents = "none"), c.layersWithOutsidePointerEventsDisabled.add(p)), c.layers.add(p), b3(), () => {
          u && c.layersWithOutsidePointerEventsDisabled.size === 1 && (m.body.style.pointerEvents = v3);
        };
    }, [p, m, u, c]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => () => {
      p && (c.layers.delete(p), c.layersWithOutsidePointerEventsDisabled.delete(p), b3());
    }, [p, c]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      const _ = () => v({});
      return document.addEventListener(Jd, _), () => document.removeEventListener(Jd, _);
    }, []), /* @__PURE__ */ y.jsx(
      et.div,
      {
        ...a,
        ref: $,
        style: {
          pointerEvents: x ? I ? "auto" : "none" : void 0,
          ...l.style
        },
        onFocusCapture: Ae(l.onFocusCapture, O.onFocusCapture),
        onBlurCapture: Ae(l.onBlurCapture, O.onBlurCapture),
        onPointerDownCapture: Ae(
          l.onPointerDownCapture,
          P.onPointerDownCapture
        )
      }
    );
  }
);
i5.displayName = mT;
var yT = "DismissableLayerBranch", $T = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const u = react__WEBPACK_IMPORTED_MODULE_0__.useContext(r5), t = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), r = Nt(n, t);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const o = t.current;
    if (o)
      return u.branches.add(o), () => {
        u.branches.delete(o);
      };
  }, [u.branches]), /* @__PURE__ */ y.jsx(et.div, { ...l, ref: r });
});
$T.displayName = yT;
function xT(l, n = globalThis == null ? void 0 : globalThis.document) {
  const u = Wu(l), t = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), r = react__WEBPACK_IMPORTED_MODULE_0__.useRef(() => {
  });
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const o = (d) => {
      if (d.target && !t.current) {
        let a = function() {
          o5(
            vT,
            u,
            c,
            { discrete: !0 }
          );
        };
        const c = { originalEvent: d };
        d.pointerType === "touch" ? (n.removeEventListener("click", r.current), r.current = a, n.addEventListener("click", r.current, { once: !0 })) : a();
      } else
        n.removeEventListener("click", r.current);
      t.current = !1;
    }, s = window.setTimeout(() => {
      n.addEventListener("pointerdown", o);
    }, 0);
    return () => {
      window.clearTimeout(s), n.removeEventListener("pointerdown", o), n.removeEventListener("click", r.current);
    };
  }, [n, u]), {
    // ensures we check React component tree (not just DOM tree)
    onPointerDownCapture: () => t.current = !0
  };
}
function CT(l, n = globalThis == null ? void 0 : globalThis.document) {
  const u = Wu(l), t = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const r = (o) => {
      o.target && !t.current && o5(bT, u, { originalEvent: o }, {
        discrete: !1
      });
    };
    return n.addEventListener("focusin", r), () => n.removeEventListener("focusin", r);
  }, [n, u]), {
    onFocusCapture: () => t.current = !0,
    onBlurCapture: () => t.current = !1
  };
}
function b3() {
  const l = new CustomEvent(Jd);
  document.dispatchEvent(l);
}
function o5(l, n, u, { discrete: t }) {
  const r = u.originalEvent.target, o = new CustomEvent(l, { bubbles: !1, cancelable: !0, detail: u });
  n && r.addEventListener(l, n, { once: !0 }), t ? hT(r, o) : r.dispatchEvent(o);
}
var Ln = globalThis != null && globalThis.document ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : () => {
}, wT = react__WEBPACK_IMPORTED_MODULE_0__.useId || (() => {
}), IT = 0;
function ai(l) {
  const [n, u] = react__WEBPACK_IMPORTED_MODULE_0__.useState(wT());
  return Ln(() => {
    u((t) => t ?? String(IT++));
  }, [l]), n ? `radix-${n}` : "";
}
var ET = "Arrow", a5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const { children: u, width: t = 10, height: r = 5, ...o } = l;
  return /* @__PURE__ */ y.jsx(
    et.svg,
    {
      ...o,
      ref: n,
      width: t,
      height: r,
      viewBox: "0 0 30 10",
      preserveAspectRatio: "none",
      children: l.asChild ? u : /* @__PURE__ */ y.jsx("polygon", { points: "0,0 30,0 15,10" })
    }
  );
});
a5.displayName = ET;
var AT = a5;
function ST(l, n = []) {
  let u = [];
  function t(o, s) {
    const d = react__WEBPACK_IMPORTED_MODULE_0__.createContext(s), a = u.length;
    u = [...u, s];
    function c(g) {
      const { scope: m, children: v, ...$ } = g, b = (m == null ? void 0 : m[l][a]) || d, E = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => $, Object.values($));
      return /* @__PURE__ */ y.jsx(b.Provider, { value: E, children: v });
    }
    function p(g, m) {
      const v = (m == null ? void 0 : m[l][a]) || d, $ = react__WEBPACK_IMPORTED_MODULE_0__.useContext(v);
      if ($) return $;
      if (s !== void 0) return s;
      throw new Error(`\`${g}\` must be used within \`${o}\``);
    }
    return c.displayName = o + "Provider", [c, p];
  }
  const r = () => {
    const o = u.map((s) => react__WEBPACK_IMPORTED_MODULE_0__.createContext(s));
    return function(d) {
      const a = (d == null ? void 0 : d[l]) || o;
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(
        () => ({ [`__scope${l}`]: { ...d, [l]: a } }),
        [d, a]
      );
    };
  };
  return r.scopeName = l, [t, PT(r, ...n)];
}
function PT(...l) {
  const n = l[0];
  if (l.length === 1) return n;
  const u = () => {
    const t = l.map((r) => ({
      useScope: r(),
      scopeName: r.scopeName
    }));
    return function(o) {
      const s = t.reduce((d, { useScope: a, scopeName: c }) => {
        const g = a(o)[`__scope${c}`];
        return { ...d, ...g };
      }, {});
      return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({ [`__scope${n.scopeName}`]: s }), [s]);
    };
  };
  return u.scopeName = n.scopeName, u;
}
function s5(l) {
  const [n, u] = react__WEBPACK_IMPORTED_MODULE_0__.useState(void 0);
  return Ln(() => {
    if (l) {
      u({ width: l.offsetWidth, height: l.offsetHeight });
      const t = new ResizeObserver((r) => {
        if (!Array.isArray(r) || !r.length)
          return;
        const o = r[0];
        let s, d;
        if ("borderBoxSize" in o) {
          const a = o.borderBoxSize, c = Array.isArray(a) ? a[0] : a;
          s = c.inlineSize, d = c.blockSize;
        } else
          s = l.offsetWidth, d = l.offsetHeight;
        u({ width: s, height: d });
      });
      return t.observe(l, { box: "border-box" }), () => t.unobserve(l);
    } else
      u(void 0);
  }, [l]), n;
}
var zc = "Popper", [d5, c5] = ST(zc), [NT, f5] = d5(zc), p5 = (l) => {
  const { __scopePopper: n, children: u } = l, [t, r] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
  return /* @__PURE__ */ y.jsx(NT, { scope: n, anchor: t, onAnchorChange: r, children: u });
};
p5.displayName = zc;
var g5 = "PopperAnchor", h5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const { __scopePopper: u, virtualRef: t, ...r } = l, o = f5(g5, u), s = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), d = Nt(n, s);
    return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      o.onAnchorChange((t == null ? void 0 : t.current) || s.current);
    }), t ? null : /* @__PURE__ */ y.jsx(et.div, { ...r, ref: d });
  }
);
h5.displayName = g5;
var Yc = "PopperContent", [TT, RT] = d5(Yc), m5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    var ol, ml, Sl, Ol, Cl, Q;
    const {
      __scopePopper: u,
      side: t = "bottom",
      sideOffset: r = 0,
      align: o = "center",
      alignOffset: s = 0,
      arrowPadding: d = 0,
      avoidCollisions: a = !0,
      collisionBoundary: c = [],
      collisionPadding: p = 0,
      sticky: g = "partial",
      hideWhenDetached: m = !1,
      updatePositionStrategy: v = "optimized",
      onPlaced: $,
      ...b
    } = l, E = f5(Yc, u), [S, A] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), x = Nt(n, (Xl) => A(Xl)), [I, P] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), O = s5(I), _ = (O == null ? void 0 : O.width) ?? 0, j = (O == null ? void 0 : O.height) ?? 0, z = t + (o !== "center" ? "-" + o : ""), Y = typeof p == "number" ? p : { top: 0, right: 0, bottom: 0, left: 0, ...p }, el = Array.isArray(c) ? c : [c], U = el.length > 0, ul = {
      padding: Y,
      boundary: el.filter(FT),
      // with `strategy: 'fixed'`, this is the only way to get it to respect boundaries
      altBoundary: U
    }, { refs: il, floatingStyles: rl, placement: tl, isPositioned: sl, middlewareData: ll } = h4({
      // default to `fixed` strategy so users don't have to pick and we also avoid focus scroll issues
      strategy: "fixed",
      placement: z,
      whileElementsMounted: (...Xl) => wc(...Xl, {
        animationFrame: v === "always"
      }),
      elements: {
        reference: E.anchor
      },
      middleware: [
        m4({ mainAxis: r + j, alignmentAxis: s }),
        a && v4({
          mainAxis: !0,
          crossAxis: !1,
          limiter: g === "partial" ? b4() : void 0,
          ...ul
        }),
        a && y4({ ...ul }),
        $4({
          ...ul,
          apply: ({ elements: Xl, rects: Bl, availableWidth: Kl, availableHeight: fn }) => {
            const { width: dn, height: Fn } = Bl.reference, sn = Xl.floating.style;
            sn.setProperty("--radix-popper-available-width", `${Kl}px`), sn.setProperty("--radix-popper-available-height", `${fn}px`), sn.setProperty("--radix-popper-anchor-width", `${dn}px`), sn.setProperty("--radix-popper-anchor-height", `${Fn}px`);
          }
        }),
        I && C4({ element: I, padding: d }),
        _T({ arrowWidth: _, arrowHeight: j }),
        m && x4({ strategy: "referenceHidden", ...ul })
      ]
    }), [H, V] = y5(tl), X = Wu($);
    Ln(() => {
      sl && (X == null || X());
    }, [sl, X]);
    const dl = (ol = ll.arrow) == null ? void 0 : ol.x, fl = (ml = ll.arrow) == null ? void 0 : ml.y, $l = ((Sl = ll.arrow) == null ? void 0 : Sl.centerOffset) !== 0, [cl, xl] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
    return Ln(() => {
      S && xl(window.getComputedStyle(S).zIndex);
    }, [S]), /* @__PURE__ */ y.jsx(
      "div",
      {
        ref: il.setFloating,
        "data-radix-popper-content-wrapper": "",
        style: {
          ...rl,
          transform: sl ? rl.transform : "translate(0, -200%)",
          // keep off the page when measuring
          minWidth: "max-content",
          zIndex: cl,
          "--radix-popper-transform-origin": [
            (Ol = ll.transformOrigin) == null ? void 0 : Ol.x,
            (Cl = ll.transformOrigin) == null ? void 0 : Cl.y
          ].join(" "),
          // hide the content if using the hide middleware and should be hidden
          // set visibility to hidden and disable pointer events so the UI behaves
          // as if the PopperContent isn't there at all
          ...((Q = ll.hide) == null ? void 0 : Q.referenceHidden) && {
            visibility: "hidden",
            pointerEvents: "none"
          }
        },
        dir: l.dir,
        children: /* @__PURE__ */ y.jsx(
          TT,
          {
            scope: u,
            placedSide: H,
            onArrowChange: P,
            arrowX: dl,
            arrowY: fl,
            shouldHideArrow: $l,
            children: /* @__PURE__ */ y.jsx(
              et.div,
              {
                "data-side": H,
                "data-align": V,
                ...b,
                ref: x,
                style: {
                  ...b.style,
                  // if the PopperContent hasn't been placed yet (not all measurements done)
                  // we prevent animations so that users's animation don't kick in too early referring wrong sides
                  animation: sl ? void 0 : "none"
                }
              }
            )
          }
        )
      }
    );
  }
);
m5.displayName = Yc;
var v5 = "PopperArrow", OT = {
  top: "bottom",
  right: "left",
  bottom: "top",
  left: "right"
}, b5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function(n, u) {
  const { __scopePopper: t, ...r } = n, o = RT(v5, t), s = OT[o.placedSide];
  return (
    // we have to use an extra wrapper because `ResizeObserver` (used by `useSize`)
    // doesn't report size as we'd expect on SVG elements.
    // it reports their bounding box which is effectively the largest path inside the SVG.
    /* @__PURE__ */ y.jsx(
      "span",
      {
        ref: o.onArrowChange,
        style: {
          position: "absolute",
          left: o.arrowX,
          top: o.arrowY,
          [s]: 0,
          transformOrigin: {
            top: "",
            right: "0 0",
            bottom: "center 0",
            left: "100% 0"
          }[o.placedSide],
          transform: {
            top: "translateY(100%)",
            right: "translateY(50%) rotate(90deg) translateX(-50%)",
            bottom: "rotate(180deg)",
            left: "translateY(50%) rotate(-90deg) translateX(50%)"
          }[o.placedSide],
          visibility: o.shouldHideArrow ? "hidden" : void 0
        },
        children: /* @__PURE__ */ y.jsx(
          AT,
          {
            ...r,
            ref: u,
            style: {
              ...r.style,
              // ensures the element can be measured correctly (mostly for if SVG)
              display: "block"
            }
          }
        )
      }
    )
  );
});
b5.displayName = v5;
function FT(l) {
  return l !== null;
}
var _T = (l) => ({
  name: "transformOrigin",
  options: l,
  fn(n) {
    var E, S, A;
    const { placement: u, rects: t, middlewareData: r } = n, s = ((E = r.arrow) == null ? void 0 : E.centerOffset) !== 0, d = s ? 0 : l.arrowWidth, a = s ? 0 : l.arrowHeight, [c, p] = y5(u), g = { start: "0%", center: "50%", end: "100%" }[p], m = (((S = r.arrow) == null ? void 0 : S.x) ?? 0) + d / 2, v = (((A = r.arrow) == null ? void 0 : A.y) ?? 0) + a / 2;
    let $ = "", b = "";
    return c === "bottom" ? ($ = s ? g : `${m}px`, b = `${-a}px`) : c === "top" ? ($ = s ? g : `${m}px`, b = `${t.floating.height + a}px`) : c === "right" ? ($ = `${-a}px`, b = s ? g : `${v}px`) : c === "left" && ($ = `${t.floating.width + a}px`, b = s ? g : `${v}px`), { data: { x: $, y: b } };
  }
});
function y5(l) {
  const [n, u = "center"] = l.split("-");
  return [n, u];
}
var DT = p5, MT = h5, BT = m5, LT = b5, GT = "Portal", $5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  var d;
  const { container: u, ...t } = l, [r, o] = react__WEBPACK_IMPORTED_MODULE_0__.useState(!1);
  Ln(() => o(!0), []);
  const s = u || r && ((d = globalThis == null ? void 0 : globalThis.document) == null ? void 0 : d.body);
  return s ? react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal(/* @__PURE__ */ y.jsx(et.div, { ...t, ref: n }), s) : null;
});
$5.displayName = GT;
function jT(l, n) {
  return react__WEBPACK_IMPORTED_MODULE_0__.useReducer((u, t) => n[u][t] ?? u, l);
}
var Uc = (l) => {
  const { present: n, children: u } = l, t = WT(n), r = typeof u == "function" ? u({ present: t.isPresent }) : react__WEBPACK_IMPORTED_MODULE_0__.Children.only(u), o = Nt(t.ref, VT(r));
  return typeof u == "function" || t.isPresent ? react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(r, { ref: o }) : null;
};
Uc.displayName = "Presence";
function WT(l) {
  const [n, u] = react__WEBPACK_IMPORTED_MODULE_0__.useState(), t = react__WEBPACK_IMPORTED_MODULE_0__.useRef({}), r = react__WEBPACK_IMPORTED_MODULE_0__.useRef(l), o = react__WEBPACK_IMPORTED_MODULE_0__.useRef("none"), s = l ? "mounted" : "unmounted", [d, a] = jT(s, {
    mounted: {
      UNMOUNT: "unmounted",
      ANIMATION_OUT: "unmountSuspended"
    },
    unmountSuspended: {
      MOUNT: "mounted",
      ANIMATION_END: "unmounted"
    },
    unmounted: {
      MOUNT: "mounted"
    }
  });
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const c = bo(t.current);
    o.current = d === "mounted" ? c : "none";
  }, [d]), Ln(() => {
    const c = t.current, p = r.current;
    if (p !== l) {
      const m = o.current, v = bo(c);
      l ? a("MOUNT") : v === "none" || (c == null ? void 0 : c.display) === "none" ? a("UNMOUNT") : a(p && m !== v ? "ANIMATION_OUT" : "UNMOUNT"), r.current = l;
    }
  }, [l, a]), Ln(() => {
    if (n) {
      let c;
      const p = n.ownerDocument.defaultView ?? window, g = (v) => {
        const b = bo(t.current).includes(v.animationName);
        if (v.target === n && b && (a("ANIMATION_END"), !r.current)) {
          const E = n.style.animationFillMode;
          n.style.animationFillMode = "forwards", c = p.setTimeout(() => {
            n.style.animationFillMode === "forwards" && (n.style.animationFillMode = E);
          });
        }
      }, m = (v) => {
        v.target === n && (o.current = bo(t.current));
      };
      return n.addEventListener("animationstart", m), n.addEventListener("animationcancel", g), n.addEventListener("animationend", g), () => {
        p.clearTimeout(c), n.removeEventListener("animationstart", m), n.removeEventListener("animationcancel", g), n.removeEventListener("animationend", g);
      };
    } else
      a("ANIMATION_END");
  }, [n, a]), {
    isPresent: ["mounted", "unmountSuspended"].includes(d),
    ref: react__WEBPACK_IMPORTED_MODULE_0__.useCallback((c) => {
      c && (t.current = getComputedStyle(c)), u(c);
    }, [])
  };
}
function bo(l) {
  return (l == null ? void 0 : l.animationName) || "none";
}
function VT(l) {
  var t, r;
  let n = (t = Object.getOwnPropertyDescriptor(l.props, "ref")) == null ? void 0 : t.get, u = n && "isReactWarning" in n && n.isReactWarning;
  return u ? l.ref : (n = (r = Object.getOwnPropertyDescriptor(l, "ref")) == null ? void 0 : r.get, u = n && "isReactWarning" in n && n.isReactWarning, u ? l.props.ref : l.props.ref || l.ref);
}
function ea({
  prop: l,
  defaultProp: n,
  onChange: u = () => {
  }
}) {
  const [t, r] = kT({ defaultProp: n, onChange: u }), o = l !== void 0, s = o ? l : t, d = Wu(u), a = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(
    (c) => {
      if (o) {
        const g = typeof c == "function" ? c(l) : c;
        g !== l && d(g);
      } else
        r(c);
    },
    [o, l, r, d]
  );
  return [s, a];
}
function kT({
  defaultProp: l,
  onChange: n
}) {
  const u = react__WEBPACK_IMPORTED_MODULE_0__.useState(l), [t] = u, r = react__WEBPACK_IMPORTED_MODULE_0__.useRef(t), o = Wu(n);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    r.current !== t && (o(t), r.current = t);
  }, [t, r, o]), u;
}
var HT = "VisuallyHidden", x5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => /* @__PURE__ */ y.jsx(
    et.span,
    {
      ...l,
      ref: n,
      style: {
        // See: https://github.com/twbs/bootstrap/blob/master/scss/mixins/_screen-reader.scss
        position: "absolute",
        border: 0,
        width: 1,
        height: 1,
        padding: 0,
        margin: -1,
        overflow: "hidden",
        clip: "rect(0, 0, 0, 0)",
        whiteSpace: "nowrap",
        wordWrap: "normal",
        ...l.style
      }
    }
  )
);
x5.displayName = HT;
var ZT = x5, [Na, B_] = oi("Tooltip", [
  c5
]), Ta = c5(), C5 = "TooltipProvider", XT = 700, Kd = "tooltip.open", [zT, Jc] = Na(C5), w5 = (l) => {
  const {
    __scopeTooltip: n,
    delayDuration: u = XT,
    skipDelayDuration: t = 300,
    disableHoverableContent: r = !1,
    children: o
  } = l, [s, d] = react__WEBPACK_IMPORTED_MODULE_0__.useState(!0), a = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), c = react__WEBPACK_IMPORTED_MODULE_0__.useRef(0);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    const p = c.current;
    return () => window.clearTimeout(p);
  }, []), /* @__PURE__ */ y.jsx(
    zT,
    {
      scope: n,
      isOpenDelayed: s,
      delayDuration: u,
      onOpen: react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
        window.clearTimeout(c.current), d(!1);
      }, []),
      onClose: react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
        window.clearTimeout(c.current), c.current = window.setTimeout(
          () => d(!0),
          t
        );
      }, [t]),
      isPointerInTransitRef: a,
      onPointerInTransitChange: react__WEBPACK_IMPORTED_MODULE_0__.useCallback((p) => {
        a.current = p;
      }, []),
      disableHoverableContent: r,
      children: o
    }
  );
};
w5.displayName = C5;
var Ra = "Tooltip", [YT, si] = Na(Ra), I5 = (l) => {
  const {
    __scopeTooltip: n,
    children: u,
    open: t,
    defaultOpen: r = !1,
    onOpenChange: o,
    disableHoverableContent: s,
    delayDuration: d
  } = l, a = Jc(Ra, l.__scopeTooltip), c = Ta(n), [p, g] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), m = ai(), v = react__WEBPACK_IMPORTED_MODULE_0__.useRef(0), $ = s ?? a.disableHoverableContent, b = d ?? a.delayDuration, E = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), [S = !1, A] = ea({
    prop: t,
    defaultProp: r,
    onChange: (_) => {
      _ ? (a.onOpen(), document.dispatchEvent(new CustomEvent(Kd))) : a.onClose(), o == null || o(_);
    }
  }), x = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => S ? E.current ? "delayed-open" : "instant-open" : "closed", [S]), I = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    window.clearTimeout(v.current), v.current = 0, E.current = !1, A(!0);
  }, [A]), P = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    window.clearTimeout(v.current), v.current = 0, A(!1);
  }, [A]), O = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    window.clearTimeout(v.current), v.current = window.setTimeout(() => {
      E.current = !0, A(!0), v.current = 0;
    }, b);
  }, [b, A]);
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => () => {
    v.current && (window.clearTimeout(v.current), v.current = 0);
  }, []), /* @__PURE__ */ y.jsx(DT, { ...c, children: /* @__PURE__ */ y.jsx(
    YT,
    {
      scope: n,
      contentId: m,
      open: S,
      stateAttribute: x,
      trigger: p,
      onTriggerChange: g,
      onTriggerEnter: react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
        a.isOpenDelayed ? O() : I();
      }, [a.isOpenDelayed, O, I]),
      onTriggerLeave: react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
        $ ? P() : (window.clearTimeout(v.current), v.current = 0);
      }, [P, $]),
      onOpen: I,
      onClose: P,
      disableHoverableContent: $,
      children: u
    }
  ) });
};
I5.displayName = Ra;
var Qd = "TooltipTrigger", E5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const { __scopeTooltip: u, ...t } = l, r = si(Qd, u), o = Jc(Qd, u), s = Ta(u), d = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), a = Nt(n, d, r.onTriggerChange), c = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), p = react__WEBPACK_IMPORTED_MODULE_0__.useRef(!1), g = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => c.current = !1, []);
    return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => () => document.removeEventListener("pointerup", g), [g]), /* @__PURE__ */ y.jsx(MT, { asChild: !0, ...s, children: /* @__PURE__ */ y.jsx(
      et.button,
      {
        "aria-describedby": r.open ? r.contentId : void 0,
        "data-state": r.stateAttribute,
        ...t,
        ref: a,
        onPointerMove: Ae(l.onPointerMove, (m) => {
          m.pointerType !== "touch" && !p.current && !o.isPointerInTransitRef.current && (r.onTriggerEnter(), p.current = !0);
        }),
        onPointerLeave: Ae(l.onPointerLeave, () => {
          r.onTriggerLeave(), p.current = !1;
        }),
        onPointerDown: Ae(l.onPointerDown, () => {
          c.current = !0, document.addEventListener("pointerup", g, { once: !0 });
        }),
        onFocus: Ae(l.onFocus, () => {
          c.current || r.onOpen();
        }),
        onBlur: Ae(l.onBlur, r.onClose),
        onClick: Ae(l.onClick, r.onClose)
      }
    ) });
  }
);
E5.displayName = Qd;
var Kc = "TooltipPortal", [UT, JT] = Na(Kc, {
  forceMount: void 0
}), A5 = (l) => {
  const { __scopeTooltip: n, forceMount: u, children: t, container: r } = l, o = si(Kc, n);
  return /* @__PURE__ */ y.jsx(UT, { scope: n, forceMount: u, children: /* @__PURE__ */ y.jsx(Uc, { present: u || o.open, children: /* @__PURE__ */ y.jsx($5, { asChild: !0, container: r, children: t }) }) });
};
A5.displayName = Kc;
var rr = "TooltipContent", S5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const u = JT(rr, l.__scopeTooltip), { forceMount: t = u.forceMount, side: r = "top", ...o } = l, s = si(rr, l.__scopeTooltip);
    return /* @__PURE__ */ y.jsx(Uc, { present: t || s.open, children: s.disableHoverableContent ? /* @__PURE__ */ y.jsx(P5, { side: r, ...o, ref: n }) : /* @__PURE__ */ y.jsx(KT, { side: r, ...o, ref: n }) });
  }
), KT = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const u = si(rr, l.__scopeTooltip), t = Jc(rr, l.__scopeTooltip), r = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null), o = Nt(n, r), [s, d] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null), { trigger: a, onClose: c } = u, p = r.current, { onPointerInTransitChange: g } = t, m = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    d(null), g(!1);
  }, [g]), v = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(
    ($, b) => {
      const E = $.currentTarget, S = { x: $.clientX, y: $.clientY }, A = lR(S, E.getBoundingClientRect()), x = nR(S, A), I = uR(b.getBoundingClientRect()), P = tR([...x, ...I]);
      d(P), g(!0);
    },
    [g]
  );
  return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => () => m(), [m]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (a && p) {
      const $ = (E) => v(E, p), b = (E) => v(E, a);
      return a.addEventListener("pointerleave", $), p.addEventListener("pointerleave", b), () => {
        a.removeEventListener("pointerleave", $), p.removeEventListener("pointerleave", b);
      };
    }
  }, [a, p, v, m]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (s) {
      const $ = (b) => {
        const E = b.target, S = { x: b.clientX, y: b.clientY }, A = (a == null ? void 0 : a.contains(E)) || (p == null ? void 0 : p.contains(E)), x = !eR(S, s);
        A ? m() : x && (m(), c());
      };
      return document.addEventListener("pointermove", $), () => document.removeEventListener("pointermove", $);
    }
  }, [a, p, s, c, m]), /* @__PURE__ */ y.jsx(P5, { ...l, ref: o });
}), [QT, qT] = Na(Ra, { isInside: !1 }), P5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const {
      __scopeTooltip: u,
      children: t,
      "aria-label": r,
      onEscapeKeyDown: o,
      onPointerDownOutside: s,
      ...d
    } = l, a = si(rr, u), c = Ta(u), { onClose: p } = a;
    return react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => (document.addEventListener(Kd, p), () => document.removeEventListener(Kd, p)), [p]), react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
      if (a.trigger) {
        const g = (m) => {
          const v = m.target;
          v != null && v.contains(a.trigger) && p();
        };
        return window.addEventListener("scroll", g, { capture: !0 }), () => window.removeEventListener("scroll", g, { capture: !0 });
      }
    }, [a.trigger, p]), /* @__PURE__ */ y.jsx(
      i5,
      {
        asChild: !0,
        disableOutsidePointerEvents: !1,
        onEscapeKeyDown: o,
        onPointerDownOutside: s,
        onFocusOutside: (g) => g.preventDefault(),
        onDismiss: p,
        children: /* @__PURE__ */ y.jsxs(
          BT,
          {
            "data-state": a.stateAttribute,
            ...c,
            ...d,
            ref: n,
            style: {
              ...d.style,
              "--radix-tooltip-content-transform-origin": "var(--radix-popper-transform-origin)",
              "--radix-tooltip-content-available-width": "var(--radix-popper-available-width)",
              "--radix-tooltip-content-available-height": "var(--radix-popper-available-height)",
              "--radix-tooltip-trigger-width": "var(--radix-popper-anchor-width)",
              "--radix-tooltip-trigger-height": "var(--radix-popper-anchor-height)"
            },
            children: [
              /* @__PURE__ */ y.jsx(e5, { children: t }),
              /* @__PURE__ */ y.jsx(QT, { scope: u, isInside: !0, children: /* @__PURE__ */ y.jsx(ZT, { id: a.contentId, role: "tooltip", children: r || t }) })
            ]
          }
        )
      }
    );
  }
);
S5.displayName = rr;
var N5 = "TooltipArrow", T5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  (l, n) => {
    const { __scopeTooltip: u, ...t } = l, r = Ta(u);
    return qT(
      N5,
      u
    ).isInside ? null : /* @__PURE__ */ y.jsx(LT, { ...r, ...t, ref: n });
  }
);
T5.displayName = N5;
function lR(l, n) {
  const u = Math.abs(n.top - l.y), t = Math.abs(n.bottom - l.y), r = Math.abs(n.right - l.x), o = Math.abs(n.left - l.x);
  switch (Math.min(u, t, r, o)) {
    case o:
      return "left";
    case r:
      return "right";
    case u:
      return "top";
    case t:
      return "bottom";
    default:
      throw new Error("unreachable");
  }
}
function nR(l, n, u = 5) {
  const t = [];
  switch (n) {
    case "top":
      t.push(
        { x: l.x - u, y: l.y + u },
        { x: l.x + u, y: l.y + u }
      );
      break;
    case "bottom":
      t.push(
        { x: l.x - u, y: l.y - u },
        { x: l.x + u, y: l.y - u }
      );
      break;
    case "left":
      t.push(
        { x: l.x + u, y: l.y - u },
        { x: l.x + u, y: l.y + u }
      );
      break;
    case "right":
      t.push(
        { x: l.x - u, y: l.y - u },
        { x: l.x - u, y: l.y + u }
      );
      break;
  }
  return t;
}
function uR(l) {
  const { top: n, right: u, bottom: t, left: r } = l;
  return [
    { x: r, y: n },
    { x: u, y: n },
    { x: u, y: t },
    { x: r, y: t }
  ];
}
function eR(l, n) {
  const { x: u, y: t } = l;
  let r = !1;
  for (let o = 0, s = n.length - 1; o < n.length; s = o++) {
    const d = n[o].x, a = n[o].y, c = n[s].x, p = n[s].y;
    a > t != p > t && u < (c - d) * (t - a) / (p - a) + d && (r = !r);
  }
  return r;
}
function tR(l) {
  const n = l.slice();
  return n.sort((u, t) => u.x < t.x ? -1 : u.x > t.x ? 1 : u.y < t.y ? -1 : u.y > t.y ? 1 : 0), rR(n);
}
function rR(l) {
  if (l.length <= 1) return l.slice();
  const n = [];
  for (let t = 0; t < l.length; t++) {
    const r = l[t];
    for (; n.length >= 2; ) {
      const o = n[n.length - 1], s = n[n.length - 2];
      if ((o.x - s.x) * (r.y - s.y) >= (o.y - s.y) * (r.x - s.x)) n.pop();
      else break;
    }
    n.push(r);
  }
  n.pop();
  const u = [];
  for (let t = l.length - 1; t >= 0; t--) {
    const r = l[t];
    for (; u.length >= 2; ) {
      const o = u[u.length - 1], s = u[u.length - 2];
      if ((o.x - s.x) * (r.y - s.y) >= (o.y - s.y) * (r.x - s.x)) u.pop();
      else break;
    }
    u.push(r);
  }
  return u.pop(), n.length === 1 && u.length === 1 && n[0].x === u[0].x && n[0].y === u[0].y ? n : n.concat(u);
}
var iR = w5, oR = I5, aR = E5, sR = A5, dR = S5, cR = T5;
function L_({ direction: l = "top", children: n, content: u, contentClass: t }) {
  return /* @__PURE__ */ y.jsx(iR, { delayDuration: 0, children: /* @__PURE__ */ y.jsxs(oR, { children: [
    /* @__PURE__ */ y.jsx(aR, { asChild: !0, children: n }),
    /* @__PURE__ */ y.jsx(sR, { children: /* @__PURE__ */ y.jsxs(
      dR,
      {
        sideOffset: 5,
        className: Kn(
          "text-gray-50 z-50 select-none rounded-[4px] bg-black px-2 py-1.5 text-xs leading-none text-white will-change-[transform,opacity] data-[state=delayed-open]:data-[side=bottom]:animate-slide-up-fade data-[state=delayed-open]:data-[side=left]:animate-slide-right-fade data-[state=delayed-open]:data-[side=right]:animate-slide-left-fade data-[state=delayed-open]:data-[side=top]:animate-slide-down-fade",
          t
        ),
        side: l,
        align: "center",
        children: [
          u,
          /* @__PURE__ */ y.jsx(cR, { className: "fill-black" })
        ]
      }
    ) })
  ] }) });
}
function y3(l, n) {
  if (typeof l == "function")
    return l(n);
  l != null && (l.current = n);
}
function R5(...l) {
  return (n) => {
    let u = !1;
    const t = l.map((r) => {
      const o = y3(r, n);
      return !u && typeof o == "function" && (u = !0), o;
    });
    if (u)
      return () => {
        for (let r = 0; r < t.length; r++) {
          const o = t[r];
          typeof o == "function" ? o() : y3(l[r], null);
        }
      };
  };
}
function Gn(...l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(R5(...l), l);
}
var ir = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const { children: u, ...t } = l, r = react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(u), o = r.find(pR);
  if (o) {
    const s = o.props.children, d = r.map((a) => a === o ? react__WEBPACK_IMPORTED_MODULE_0__.Children.count(s) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(s) ? s.props.children : null : a);
    return /* @__PURE__ */ y.jsx(qd, { ...t, ref: n, children: react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(s) ? react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(s, void 0, d) : null });
  }
  return /* @__PURE__ */ y.jsx(qd, { ...t, ref: n, children: u });
});
ir.displayName = "Slot";
var qd = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => {
  const { children: u, ...t } = l;
  if (react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(u)) {
    const r = hR(u), o = gR(t, u.props);
    return u.type !== react__WEBPACK_IMPORTED_MODULE_0__.Fragment && (o.ref = n ? R5(n, r) : r), react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(u, o);
  }
  return react__WEBPACK_IMPORTED_MODULE_0__.Children.count(u) > 1 ? react__WEBPACK_IMPORTED_MODULE_0__.Children.only(null) : null;
});
qd.displayName = "SlotClone";
var fR = ({ children: l }) => /* @__PURE__ */ y.jsx(y.Fragment, { children: l });
function pR(l) {
  return react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(l) && l.type === fR;
}
function gR(l, n) {
  const u = { ...n };
  for (const t in n) {
    const r = l[t], o = n[t];
    /^on[A-Z]/.test(t) ? r && o ? u[t] = (...d) => {
      o(...d), r(...d);
    } : r && (u[t] = r) : t === "style" ? u[t] = { ...r, ...o } : t === "className" && (u[t] = [r, o].filter(Boolean).join(" "));
  }
  return { ...l, ...u };
}
function hR(l) {
  var t, r;
  let n = (t = Object.getOwnPropertyDescriptor(l.props, "ref")) == null ? void 0 : t.get, u = n && "isReactWarning" in n && n.isReactWarning;
  return u ? l.ref : (n = (r = Object.getOwnPropertyDescriptor(l, "ref")) == null ? void 0 : r.get, u = n && "isReactWarning" in n && n.isReactWarning, u ? l.props.ref : l.props.ref || l.ref);
}
var mR = [
  "a",
  "button",
  "div",
  "form",
  "h2",
  "h3",
  "img",
  "input",
  "label",
  "li",
  "nav",
  "ol",
  "p",
  "span",
  "svg",
  "ul"
], An = mR.reduce((l, n) => {
  const u = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((t, r) => {
    const { asChild: o, ...s } = t, d = o ? ir : n;
    return typeof window < "u" && (window[Symbol.for("radix-ui")] = !0), /* @__PURE__ */ y.jsx(d, { ...s, ref: r });
  });
  return u.displayName = `Primitive.${n}`, { ...l, [n]: u };
}, {});
function vR(l, n) {
  l && react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync(() => l.dispatchEvent(n));
}
var bR = "Label", O5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((l, n) => /* @__PURE__ */ y.jsx(
  An.label,
  {
    ...l,
    ref: n,
    onMouseDown: (u) => {
      var r;
      u.target.closest("button, input, select, textarea") || ((r = l.onMouseDown) == null || r.call(l, u), !u.defaultPrevented && u.detail > 1 && u.preventDefault());
    }
  }
));
O5.displayName = bR;
var yR = O5;
const F5 = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(
  ({ className: l, ...n }, u) => /* @__PURE__ */ y.jsx(
    yR,
    {
      ref: u,
      className: wl(
        "cursor-pointer text-sm font-medium leading-[21px] text-gray-900 peer-disabled:cursor-not-allowed peer-disabled:opacity-50",
        l
      ),
      ...n
    }
  )
);
F5.displayName = "FormLabel";
let yo;
const $R = (l, n) => {
  var r, o;
  if ((o = (r = window.google) == null ? void 0 : r.maps) != null && o.places) {
    n();
    return;
  }
  const u = document.createElement("script"), t = document.createElement("script");
  t.type = "text/javascript", t.textContent = "function initMapPlaceholderFunc() {}", u.type = "text/javascript", u.src = l, document.body.appendChild(t), document.body.appendChild(u), u.onload = () => n();
}, G_ = ({
  label: l,
  apiKey: n,
  input: u,
  className: t,
  errors: r,
  onPlaceSelected: o,
  countryRestriction: s,
  value: d,
  onClear: a,
  onFocus: c,
  onBlur: p,
  showClear: g = !0,
  disabled: m
}) => {
  const v = (0,react__WEBPACK_IMPORTED_MODULE_0__.useId)(), $ = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null), b = () => {
    var z;
    const A = yo.getPlace(), x = $.current.value;
    A && A.name ? $.current.value = A.name : $.current.value = x;
    const I = oe.get(A, "address_components");
    let P = "", O = "", _ = "", j = { long_name: "", short_name: "" };
    oe.forEach(I, function(Y) {
      const el = oe.get(Y, "types");
      oe.includes(el, "country") && (j = Y), oe.includes(el, "locality") && (P = oe.get(Y, "long_name")), oe.includes(el, "administrative_area_level_1") && (O = oe.get(Y, "long_name")), oe.includes(el, "postal_code") && (_ = oe.get(Y, "long_name"));
    }), o({
      city: P ?? "",
      state: O ?? "",
      zip: _ ?? "",
      country: j ?? { long_name: "", short_name: "" },
      address: ((z = $.current) == null ? void 0 : z.value) ?? "",
      place: A,
      inputValue: x
    });
  }, E = (A, x) => {
    const { maps: I } = window.google;
    yo = new I.places.Autocomplete(A.current), x && yo.setComponentRestrictions({
      country: x
    }), yo.addListener("place_changed", () => b());
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    $.current && d && ($.current.value = d);
  }, [d]), (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const A = `https://maps.googleapis.com/maps/api/js?key=${n}&libraries=places&language=en&callback=initMapPlaceholderFunc`;
    $R(A, () => E($, s));
  }, [s]);
  const S = !!(r && r.length > 0);
  return /* @__PURE__ */ y.jsxs(y.Fragment, { children: [
    typeof l == "string" ? /* @__PURE__ */ y.jsx(
      F5,
      {
        htmlFor: (u == null ? void 0 : u.id) ?? v,
        className: wl("mb-2 inline-block", m && "cursor-not-allowed opacity-50"),
        children: l
      }
    ) : l,
    /* @__PURE__ */ y.jsxs("div", { className: "relative flex", children: [
      /* @__PURE__ */ y.jsx(
        "input",
        {
          id: (u == null ? void 0 : u.id) ?? v,
          className: wl(
            "w-full h-10 rounded border-0 px-4 py-2.5 text-sm leading-5 text-gray-800 ring-1 focus:ring-2 ring-gray-200 placeholder:text-gray-400 focus:ring-primary-600 disabled:cursor-not-allowed disabled:opacity-50",
            S && "ring-red-500 focus:ring-red-500 hasErrors",
            t
          ),
          ...u,
          disabled: m,
          ref: $,
          onFocus: c,
          onBlur: p
        }
      ),
      d && d.toString().length && g && /* @__PURE__ */ y.jsx("div", { className: "absolute right-2 top-1/2 -translate-y-1/2", children: /* @__PURE__ */ y.jsx(
        "button",
        {
          type: "button",
          onClick: () => {
            $.current.value = "", a && a();
          },
          className: "inset-y-0 right-0 text-sm flex items-center me-3 text-gray-400",
          children: "Clear"
        }
      ) })
    ] }),
    /* @__PURE__ */ y.jsx(Nu, { value: r ?? [] })
  ] });
}, j_ = ({ loading: l = !0, children: n, height: u }) => /* @__PURE__ */ y.jsx(y.Fragment, { children: l ? /* @__PURE__ */ y.jsx("div", { className: "loader flex items-center justify-center", style: { height: u || "100px" }, children: /* @__PURE__ */ y.jsxs("div", { className: "lds-ellipsis", children: [
  /* @__PURE__ */ y.jsx("div", {}),
  /* @__PURE__ */ y.jsx("div", {}),
  /* @__PURE__ */ y.jsx("div", {}),
  /* @__PURE__ */ y.jsx("div", {})
] }) }) : n });
(function() {
  function l(R, G) {
    var W = R.split("."), al = xl;
    W[0] in al || !al.execScript || al.execScript("var " + W[0]);
    for (var Pl; W.length && (Pl = W.shift()); ) W.length || G === void 0 ? al = al[Pl] ? al[Pl] : al[Pl] = {} : al[Pl] = G;
  }
  function n(R, G) {
    function W() {
    }
    W.prototype = G.prototype, R.M = G.prototype, R.prototype = new W(), R.prototype.constructor = R, R.N = function(al, Pl, Fl) {
      for (var on = Array(arguments.length - 2), Cn = 2; Cn < arguments.length; Cn++) on[Cn - 2] = arguments[Cn];
      return G.prototype[Pl].apply(al, on);
    };
  }
  function u(R, G) {
    R != null && this.a.apply(this, arguments);
  }
  function t(R) {
    R.b = "";
  }
  function r(R, G) {
    R.sort(G || o);
  }
  function o(R, G) {
    return R > G ? 1 : R < G ? -1 : 0;
  }
  function s(R) {
    var G, W = [], al = 0;
    for (G in R) W[al++] = R[G];
    return W;
  }
  function d(R, G) {
    this.b = R, this.a = {};
    for (var W = 0; W < G.length; W++) {
      var al = G[W];
      this.a[al.b] = al;
    }
  }
  function a(R) {
    return R = s(R.a), r(R, function(G, W) {
      return G.b - W.b;
    }), R;
  }
  function c(R, G) {
    switch (this.b = R, this.g = !!G.v, this.a = G.c, this.i = G.type, this.h = !1, this.a) {
      case Sl:
      case Ol:
      case Cl:
      case Q:
      case Xl:
      case ml:
      case ol:
        this.h = !0;
    }
    this.f = G.defaultValue;
  }
  function p() {
    this.a = {}, this.f = this.j().a, this.b = this.g = null;
  }
  function g(R, G) {
    for (var W = a(R.j()), al = 0; al < W.length; al++) {
      var Pl = W[al], Fl = Pl.b;
      if (G.a[Fl] != null) {
        R.b && delete R.b[Pl.b];
        var on = Pl.a == 11 || Pl.a == 10;
        if (Pl.g) for (var Pl = m(G, Fl) || [], Cn = 0; Cn < Pl.length; Cn++) {
          var Dn = R, Hu = Fl, at = on ? Pl[Cn].clone() : Pl[Cn];
          Dn.a[Hu] || (Dn.a[Hu] = []), Dn.a[Hu].push(at), Dn.b && delete Dn.b[Hu];
        }
        else Pl = m(G, Fl), on ? (on = m(R, Fl)) ? g(on, Pl) : E(R, Fl, Pl.clone()) : E(R, Fl, Pl);
      }
    }
  }
  function m(R, G) {
    var W = R.a[G];
    if (W == null) return null;
    if (R.g) {
      if (!(G in R.b)) {
        var al = R.g, Pl = R.f[G];
        if (W != null) if (Pl.g) {
          for (var Fl = [], on = 0; on < W.length; on++) Fl[on] = al.b(Pl, W[on]);
          W = Fl;
        } else W = al.b(Pl, W);
        return R.b[G] = W;
      }
      return R.b[G];
    }
    return W;
  }
  function v(R, G, W) {
    var al = m(R, G);
    return R.f[G].g ? al[W || 0] : al;
  }
  function $(R, G) {
    var W;
    if (R.a[G] != null) W = v(R, G, void 0);
    else l: {
      if (W = R.f[G], W.f === void 0) {
        var al = W.i;
        if (al === Boolean) W.f = !1;
        else if (al === Number) W.f = 0;
        else {
          if (al !== String) {
            W = new al();
            break l;
          }
          W.f = W.h ? "0" : "";
        }
      }
      W = W.f;
    }
    return W;
  }
  function b(R, G) {
    return R.f[G].g ? R.a[G] != null ? R.a[G].length : 0 : R.a[G] != null ? 1 : 0;
  }
  function E(R, G, W) {
    R.a[G] = W, R.b && (R.b[G] = W);
  }
  function S(R, G) {
    var W, al = [];
    for (W in G) W != 0 && al.push(new c(W, G[W]));
    return new d(R, al);
  }
  function A() {
    p.call(this);
  }
  function x() {
    p.call(this);
  }
  function I() {
    p.call(this);
  }
  function P() {
  }
  function O() {
  }
  function _() {
  }
  function j() {
    this.a = {};
  }
  function z(R) {
    return R.length == 0 || ue.test(R);
  }
  function Y(R, G) {
    if (G == null) return null;
    G = G.toUpperCase();
    var W = R.a[G];
    if (W == null) {
      if (W = sn[G], W == null) return null;
      W = new _().a(I.j(), W), R.a[G] = W;
    }
    return W;
  }
  function el(R) {
    return R = Fn[R], R == null ? "ZZ" : R[0];
  }
  function U(R) {
    this.H = RegExp(" "), this.C = "", this.m = new u(), this.w = "", this.i = new u(), this.u = new u(), this.l = !0, this.A = this.o = this.F = !1, this.G = j.b(), this.s = 0, this.b = new u(), this.B = !1, this.h = "", this.a = new u(), this.f = [], this.D = R, this.J = this.g = ul(this, this.D);
  }
  function ul(R, G) {
    var W;
    if (G != null && isNaN(G) && G.toUpperCase() in sn) {
      if (W = Y(R.G, G), W == null) throw Error("Invalid region code: " + G);
      W = $(W, 10);
    } else W = 0;
    return W = Y(R.G, el(W)), W ?? _e;
  }
  function il(R) {
    for (var G = R.f.length, W = 0; W < G; ++W) {
      var al = R.f[W], Pl = $(al, 1);
      if (R.w == Pl) return !1;
      var Fl;
      Fl = R;
      var on = al, Cn = $(on, 1);
      if (Cn.indexOf("|") != -1) Fl = !1;
      else {
        Cn = Cn.replace(Tu, "\\d"), Cn = Cn.replace(ee, "\\d"), t(Fl.m);
        var Dn;
        Dn = Fl;
        var on = $(on, 2), Hu = "999999999999999".match(Cn)[0];
        Hu.length < Dn.a.b.length ? Dn = "" : (Dn = Hu.replace(new RegExp(Cn, "g"), on), Dn = Dn.replace(RegExp("9", "g"), " ")), 0 < Dn.length ? (Fl.m.a(Dn), Fl = !0) : Fl = !1;
      }
      if (Fl) return R.w = Pl, R.B = vu.test(v(al, 4)), R.s = 0, !0;
    }
    return R.l = !1;
  }
  function rl(R, G) {
    for (var W = [], al = G.length - 3, Pl = R.f.length, Fl = 0; Fl < Pl; ++Fl) {
      var on = R.f[Fl];
      b(on, 3) == 0 ? W.push(R.f[Fl]) : (on = v(on, 3, Math.min(al, b(on, 3) - 1)), G.search(on) == 0 && W.push(R.f[Fl]));
    }
    R.f = W;
  }
  function tl(R, G) {
    R.i.a(G);
    var W = G;
    if (Zn.test(W) || R.i.b.length == 1 && _n.test(W)) {
      var al, W = G;
      W == "+" ? (al = W, R.u.a(W)) : (al = gn[W], R.u.a(al), R.a.a(al)), G = al;
    } else R.l = !1, R.F = !0;
    if (!R.l) {
      if (!R.F) {
        if (fl(R)) {
          if ($l(R)) return sl(R);
        } else if (0 < R.h.length && (W = R.a.toString(), t(R.a), R.a.a(R.h), R.a.a(W), W = R.b.toString(), al = W.lastIndexOf(R.h), t(R.b), R.b.a(W.substring(0, al))), R.h != dl(R)) return R.b.a(" "), sl(R);
      }
      return R.i.toString();
    }
    switch (R.u.b.length) {
      case 0:
      case 1:
      case 2:
        return R.i.toString();
      case 3:
        if (!fl(R)) return R.h = dl(R), V(R);
        R.A = !0;
      default:
        return R.A ? ($l(R) && (R.A = !1), R.b.toString() + R.a.toString()) : 0 < R.f.length ? (W = cl(R, G), al = ll(R), 0 < al.length ? al : (rl(R, R.a.toString()), il(R) ? X(R) : R.l ? H(R, W) : R.i.toString())) : V(R);
    }
  }
  function sl(R) {
    return R.l = !0, R.A = !1, R.f = [], R.s = 0, t(R.m), R.w = "", V(R);
  }
  function ll(R) {
    for (var G = R.a.toString(), W = R.f.length, al = 0; al < W; ++al) {
      var Pl = R.f[al], Fl = $(Pl, 1);
      if (new RegExp("^(?:" + Fl + ")$").test(G)) return R.B = vu.test(v(Pl, 4)), G = G.replace(new RegExp(Fl, "g"), v(Pl, 2)), H(R, G);
    }
    return "";
  }
  function H(R, G) {
    var W = R.b.b.length;
    return R.B && 0 < W && R.b.toString().charAt(W - 1) != " " ? R.b + " " + G : R.b + G;
  }
  function V(R) {
    var G = R.a.toString();
    if (3 <= G.length) {
      for (var W = R.o && R.h.length == 0 && 0 < b(R.g, 20) ? m(R.g, 20) || [] : m(R.g, 19) || [], al = W.length, Pl = 0; Pl < al; ++Pl) {
        var Fl = W[Pl];
        0 < R.h.length && z($(Fl, 4)) && !v(Fl, 6) && Fl.a[5] == null || (R.h.length != 0 || R.o || z($(Fl, 4)) || v(Fl, 6)) && Qn.test($(Fl, 2)) && R.f.push(Fl);
      }
      return rl(R, G), G = ll(R), 0 < G.length ? G : il(R) ? X(R) : R.i.toString();
    }
    return H(R, G);
  }
  function X(R) {
    var G = R.a.toString(), W = G.length;
    if (0 < W) {
      for (var al = "", Pl = 0; Pl < W; Pl++) al = cl(R, G.charAt(Pl));
      return R.l ? H(R, al) : R.i.toString();
    }
    return R.b.toString();
  }
  function dl(R) {
    var G, W = R.a.toString(), al = 0;
    return v(R.g, 10) != 1 ? G = !1 : (G = R.a.toString(), G = G.charAt(0) == "1" && G.charAt(1) != "0" && G.charAt(1) != "1"), G ? (al = 1, R.b.a("1").a(" "), R.o = !0) : R.g.a[15] != null && (G = new RegExp("^(?:" + v(R.g, 15) + ")"), G = W.match(G), G != null && G[0] != null && 0 < G[0].length && (R.o = !0, al = G[0].length, R.b.a(W.substring(0, al)))), t(R.a), R.a.a(W.substring(al)), W.substring(0, al);
  }
  function fl(R) {
    var G = R.u.toString(), W = new RegExp("^(?:\\+|" + v(R.g, 11) + ")"), W = G.match(W);
    return W != null && W[0] != null && 0 < W[0].length && (R.o = !0, W = W[0].length, t(R.a), R.a.a(G.substring(W)), t(R.b), R.b.a(G.substring(0, W)), G.charAt(0) != "+" && R.b.a(" "), !0);
  }
  function $l(R) {
    if (R.a.b.length == 0) return !1;
    var G, W = new u();
    l: {
      if (G = R.a.toString(), G.length != 0 && G.charAt(0) != "0") {
        for (var al, Pl = G.length, Fl = 1; 3 >= Fl && Fl <= Pl; ++Fl) if (al = parseInt(G.substring(0, Fl), 10), al in Fn) {
          W.a(G.substring(Fl)), G = al;
          break l;
        }
      }
      G = 0;
    }
    return G != 0 && (t(R.a), R.a.a(W.toString()), W = el(G), W == "001" ? R.g = Y(R.G, "" + G) : W != R.D && (R.g = ul(R, W)), R.b.a("" + G).a(" "), R.h = "", !0);
  }
  function cl(R, G) {
    var W = R.m.toString();
    if (0 <= W.substring(R.s).search(R.H)) {
      var al = W.search(R.H), W = W.replace(R.H, G);
      return t(R.m), R.m.a(W), R.s = al, W.substring(0, R.s + 1);
    }
    return R.f.length == 1 && (R.l = !1), R.w = "", R.i.toString();
  }
  var xl = this;
  u.prototype.b = "", u.prototype.set = function(R) {
    this.b = "" + R;
  }, u.prototype.a = function(R, G, W) {
    if (this.b += String(R), G != null) for (var al = 1; al < arguments.length; al++) this.b += arguments[al];
    return this;
  }, u.prototype.toString = function() {
    return this.b;
  };
  var ol = 1, ml = 2, Sl = 3, Ol = 4, Cl = 6, Q = 16, Xl = 18;
  p.prototype.set = function(R, G) {
    E(this, R.b, G);
  }, p.prototype.clone = function() {
    var R = new this.constructor();
    return R != this && (R.a = {}, R.b && (R.b = {}), g(R, this)), R;
  }, n(A, p);
  var Bl = null;
  n(x, p);
  var Kl = null;
  n(I, p);
  var fn = null;
  A.prototype.j = function() {
    var R = Bl;
    return R || (Bl = R = S(A, { 0: { name: "NumberFormat", I: "i18n.phonenumbers.NumberFormat" }, 1: { name: "pattern", required: !0, c: 9, type: String }, 2: { name: "format", required: !0, c: 9, type: String }, 3: { name: "leading_digits_pattern", v: !0, c: 9, type: String }, 4: { name: "national_prefix_formatting_rule", c: 9, type: String }, 6: { name: "national_prefix_optional_when_formatting", c: 8, defaultValue: !1, type: Boolean }, 5: { name: "domestic_carrier_code_formatting_rule", c: 9, type: String } })), R;
  }, A.j = A.prototype.j, x.prototype.j = function() {
    var R = Kl;
    return R || (Kl = R = S(x, { 0: { name: "PhoneNumberDesc", I: "i18n.phonenumbers.PhoneNumberDesc" }, 2: { name: "national_number_pattern", c: 9, type: String }, 9: { name: "possible_length", v: !0, c: 5, type: Number }, 10: { name: "possible_length_local_only", v: !0, c: 5, type: Number }, 6: { name: "example_number", c: 9, type: String } })), R;
  }, x.j = x.prototype.j, I.prototype.j = function() {
    var R = fn;
    return R || (fn = R = S(I, { 0: { name: "PhoneMetadata", I: "i18n.phonenumbers.PhoneMetadata" }, 1: { name: "general_desc", c: 11, type: x }, 2: { name: "fixed_line", c: 11, type: x }, 3: { name: "mobile", c: 11, type: x }, 4: { name: "toll_free", c: 11, type: x }, 5: { name: "premium_rate", c: 11, type: x }, 6: { name: "shared_cost", c: 11, type: x }, 7: { name: "personal_number", c: 11, type: x }, 8: { name: "voip", c: 11, type: x }, 21: { name: "pager", c: 11, type: x }, 25: { name: "uan", c: 11, type: x }, 27: { name: "emergency", c: 11, type: x }, 28: { name: "voicemail", c: 11, type: x }, 29: { name: "short_code", c: 11, type: x }, 30: { name: "standard_rate", c: 11, type: x }, 31: { name: "carrier_specific", c: 11, type: x }, 33: { name: "sms_services", c: 11, type: x }, 24: { name: "no_international_dialling", c: 11, type: x }, 9: { name: "id", required: !0, c: 9, type: String }, 10: { name: "country_code", c: 5, type: Number }, 11: { name: "international_prefix", c: 9, type: String }, 17: { name: "preferred_international_prefix", c: 9, type: String }, 12: { name: "national_prefix", c: 9, type: String }, 13: { name: "preferred_extn_prefix", c: 9, type: String }, 15: { name: "national_prefix_for_parsing", c: 9, type: String }, 16: { name: "national_prefix_transform_rule", c: 9, type: String }, 18: { name: "same_mobile_and_fixed_line_pattern", c: 8, defaultValue: !1, type: Boolean }, 19: { name: "number_format", v: !0, c: 11, type: A }, 20: { name: "intl_number_format", v: !0, c: 11, type: A }, 22: { name: "main_country_for_code", c: 8, defaultValue: !1, type: Boolean }, 23: { name: "leading_digits", c: 9, type: String }, 26: { name: "leading_zero_possible", c: 8, defaultValue: !1, type: Boolean } })), R;
  }, I.j = I.prototype.j, P.prototype.a = function(R) {
    throw new R.b(), Error("Unimplemented");
  }, P.prototype.b = function(R, G) {
    if (R.a == 11 || R.a == 10) return G instanceof p ? G : this.a(R.i.prototype.j(), G);
    if (R.a == 14) {
      if (typeof G == "string" && dn.test(G)) {
        var W = Number(G);
        if (0 < W) return W;
      }
      return G;
    }
    if (!R.h) return G;
    if (W = R.i, W === String) {
      if (typeof G == "number") return String(G);
    } else if (W === Number && typeof G == "string" && (G === "Infinity" || G === "-Infinity" || G === "NaN" || dn.test(G))) return Number(G);
    return G;
  };
  var dn = /^-?[0-9]+$/;
  n(O, P), O.prototype.a = function(R, G) {
    var W = new R.b();
    return W.g = this, W.a = G, W.b = {}, W;
  }, n(_, O), _.prototype.b = function(R, G) {
    return R.a == 8 ? !!G : P.prototype.b.apply(this, arguments);
  }, _.prototype.a = function(R, G) {
    return _.M.a.call(this, R, G);
  };
  var Fn = { 1: "US AG AI AS BB BM BS CA DM DO GD GU JM KN KY LC MP MS PR SX TC TT VC VG VI".split(" "), 7: ["RU", "KZ"], 20: ["EG"], 27: ["ZA"], 30: ["GR"], 31: ["NL"], 32: ["BE"], 33: ["FR"], 34: ["ES"], 36: ["HU"], 39: ["IT", "VA"], 40: ["RO"], 41: ["CH"], 43: ["AT"], 44: ["GB", "GG", "IM", "JE"], 45: ["DK"], 46: ["SE"], 47: ["NO", "SJ"], 48: ["PL"], 49: ["DE"], 51: ["PE"], 52: ["MX"], 53: ["CU"], 54: ["AR"], 55: ["BR"], 56: ["CL"], 57: ["CO"], 58: ["VE"], 60: ["MY"], 61: ["AU", "CC", "CX"], 62: ["ID"], 63: ["PH"], 64: ["NZ"], 65: ["SG"], 66: ["TH"], 81: ["JP"], 82: ["KR"], 84: ["VN"], 86: ["CN"], 90: ["TR"], 91: ["IN"], 92: ["PK"], 93: ["AF"], 94: ["LK"], 95: ["MM"], 98: ["IR"], 211: ["SS"], 212: ["MA", "EH"], 213: ["DZ"], 216: ["TN"], 218: ["LY"], 220: ["GM"], 221: ["SN"], 222: ["MR"], 223: ["ML"], 224: ["GN"], 225: ["CI"], 226: ["BF"], 227: ["NE"], 228: ["TG"], 229: ["BJ"], 230: ["MU"], 231: ["LR"], 232: ["SL"], 233: ["GH"], 234: ["NG"], 235: ["TD"], 236: ["CF"], 237: ["CM"], 238: ["CV"], 239: ["ST"], 240: ["GQ"], 241: ["GA"], 242: ["CG"], 243: ["CD"], 244: ["AO"], 245: ["GW"], 246: ["IO"], 247: ["AC"], 248: ["SC"], 249: ["SD"], 250: ["RW"], 251: ["ET"], 252: ["SO"], 253: ["DJ"], 254: ["KE"], 255: ["TZ"], 256: ["UG"], 257: ["BI"], 258: ["MZ"], 260: ["ZM"], 261: ["MG"], 262: ["RE", "YT"], 263: ["ZW"], 264: ["NA"], 265: ["MW"], 266: ["LS"], 267: ["BW"], 268: ["SZ"], 269: ["KM"], 290: ["SH", "TA"], 291: ["ER"], 297: ["AW"], 298: ["FO"], 299: ["GL"], 350: ["GI"], 351: ["PT"], 352: ["LU"], 353: ["IE"], 354: ["IS"], 355: ["AL"], 356: ["MT"], 357: ["CY"], 358: ["FI", "AX"], 359: ["BG"], 370: ["LT"], 371: ["LV"], 372: ["EE"], 373: ["MD"], 374: ["AM"], 375: ["BY"], 376: ["AD"], 377: ["MC"], 378: ["SM"], 380: ["UA"], 381: ["RS"], 382: ["ME"], 383: ["XK"], 385: ["HR"], 386: ["SI"], 387: ["BA"], 389: ["MK"], 420: ["CZ"], 421: ["SK"], 423: ["LI"], 500: ["FK"], 501: ["BZ"], 502: ["GT"], 503: ["SV"], 504: ["HN"], 505: ["NI"], 506: ["CR"], 507: ["PA"], 508: ["PM"], 509: ["HT"], 590: ["GP", "BL", "MF"], 591: ["BO"], 592: ["GY"], 593: ["EC"], 594: ["GF"], 595: ["PY"], 596: ["MQ"], 597: ["SR"], 598: ["UY"], 599: ["CW", "BQ"], 670: ["TL"], 672: ["NF"], 673: ["BN"], 674: ["NR"], 675: ["PG"], 676: ["TO"], 677: ["SB"], 678: ["VU"], 679: ["FJ"], 680: ["PW"], 681: ["WF"], 682: ["CK"], 683: ["NU"], 685: ["WS"], 686: ["KI"], 687: ["NC"], 688: ["TV"], 689: ["PF"], 690: ["TK"], 691: ["FM"], 692: ["MH"], 800: ["001"], 808: ["001"], 850: ["KP"], 852: ["HK"], 853: ["MO"], 855: ["KH"], 856: ["LA"], 870: ["001"], 878: ["001"], 880: ["BD"], 881: ["001"], 882: ["001"], 883: ["001"], 886: ["TW"], 888: ["001"], 960: ["MV"], 961: ["LB"], 962: ["JO"], 963: ["SY"], 964: ["IQ"], 965: ["KW"], 966: ["SA"], 967: ["YE"], 968: ["OM"], 970: ["PS"], 971: ["AE"], 972: ["IL"], 973: ["BH"], 974: ["QA"], 975: ["BT"], 976: ["MN"], 977: ["NP"], 979: ["001"], 992: ["TJ"], 993: ["TM"], 994: ["AZ"], 995: ["GE"], 996: ["KG"], 998: ["UZ"] }, sn = {
    800: [null, [null, null, "\\d{8}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "\\d{8}", null, null, null, "12345678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 800, null, null, null, null, null, null, null, 1, [[null, "(\\d{4})(\\d{4})", "$1 $2"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    808: [null, [null, null, "\\d{8}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "\\d{8}", null, null, null, "12345678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 808, null, null, null, null, null, null, null, 1, [[null, "(\\d{4})(\\d{4})", "$1 $2"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    870: [null, [null, null, "[35-7]\\d{8}", null, null, null, null, null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:[356]\\d|7[6-8])\\d{7}", null, null, null, "301234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 870, null, null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[35-7]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    878: [null, [null, null, "10\\d{10}", null, null, null, null, null, null, [12]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "10\\d{10}", null, null, null, "101234567890"], "001", 878, null, null, null, null, null, null, null, 1, [[null, "(\\d{2})(\\d{5})(\\d{5})", "$1 $2 $3", ["1"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    881: [null, [null, null, "[67]\\d{8}", null, null, null, null, null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "[67]\\d{8}", null, null, null, "612345678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 881, null, null, null, null, null, null, null, null, [[null, "(\\d)(\\d{3})(\\d{5})", "$1 $2 $3", ["[67]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    882: [null, [null, null, "[13]\\d{6}(?:\\d{2,5})?|1\\d{7}", null, null, null, null, null, null, [7, 8, 9, 10, 11, 12]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "3(?:(?:(?:2|7\\d{3})\\d|37)\\d\\d|4(?:2|7\\d{3}))\\d{4}", null, null, null, "3421234", null, null, [7, 9, 10, 12]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:1(?:3(?:0[0347]|[13][0139]|2[035]|4[013568]|6[0459]|7[06]|8[15-8]|9[0689])|6\\d{1,6})|3(?:45|9\\d{3})\\d{3})\\d{4}", null, null, null, "390123456789"], "001", 882, null, null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{5})", "$1 $2", ["16|342"]], [null, "(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3", ["1"]], [null, "(\\d{2})(\\d{4})(\\d{3})", "$1 $2 $3", ["3[23]"]], [null, "(\\d{2})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["1"]], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["34[57]"]], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["34"]], [null, "(\\d{2})(\\d{4,5})(\\d{5})", "$1 $2 $3", ["[13]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "348[57]\\d{7}", null, null, null, "34851234567", null, null, [11]]],
    883: [null, [null, null, "51\\d{7}(?:\\d{3})?", null, null, null, null, null, null, [9, 12]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "51[013]0\\d{8}|5100\\d{5}", null, null, null, "510012345"], "001", 883, null, null, null, null, null, null, null, 1, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["510"]], [null, "(\\d{3})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["510"]], [null, "(\\d{4})(\\d{4})(\\d{4})", "$1 $2 $3", ["5"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    888: [null, [null, null, "\\d{11}", null, null, null, null, null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 888, null, null, null, null, null, null, null, 1, [[null, "(\\d{3})(\\d{3})(\\d{5})", "$1 $2 $3"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "\\d{11}", null, null, null, "12345678901"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    979: [null, [null, null, "\\d{9}", null, null, null, null, null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "\\d{9}", null, null, null, "123456789"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "001", 979, null, null, null, null, null, null, null, 1, [[null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AC: [null, [null, null, "(?:[01589]\\d|[46])\\d{4}", null, null, null, null, null, null, [5, 6]], [null, null, "6[2-467]\\d{3}", null, null, null, "62889", null, null, [5]], [null, null, "4\\d{4}", null, null, null, "40123", null, null, [5]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AC", 247, "00", null, null, null, null, null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "[01589]\\d{5}", null, null, null, "542011", null, null, [6]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AD: [null, [null, null, "(?:1|6\\d)\\d{7}|[136-9]\\d{5}", null, null, null, null, null, null, [6, 8, 9]], [null, null, "[78]\\d{5}", null, null, null, "712345", null, null, [6]], [null, null, "690\\d{6}|[36]\\d{5}", null, null, null, "312345", null, null, [6, 9]], [null, null, "180[02]\\d{4}", null, null, null, "18001234", null, null, [8]], [null, null, "[19]\\d{5}", null, null, null, "912345", null, null, [6]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AD", 376, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})", "$1 $2", ["[136-9]"]], [null, "(\\d{4})(\\d{4})", "$1 $2", ["1"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["6"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "1800\\d{4}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AE: [null, [null, null, "(?:[4-7]\\d|9[0-689])\\d{7}|800\\d{2,9}|[2-4679]\\d{7}", null, null, null, null, null, null, [5, 6, 7, 8, 9, 10, 11, 12]], [null, null, "[2-4679][2-8]\\d{6}", null, null, null, "22345678", null, null, [8], [7]], [null, null, "5[024-68]\\d{7}", null, null, null, "501234567", null, null, [9]], [null, null, "400\\d{6}|800\\d{2,9}", null, null, null, "800123456"], [null, null, "900[02]\\d{5}", null, null, null, "900234567", null, null, [9]], [null, null, "700[05]\\d{5}", null, null, null, "700012345", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AE", 971, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2,9})", "$1 $2", ["60|8"]], [null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["[236]|[479][2-8]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["5"], "0$1"], [null, "(\\d{3})(\\d)(\\d{5})", "$1 $2 $3", ["[479]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "600[25]\\d{5}", null, null, null, "600212345", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AF: [null, [null, null, "[2-7]\\d{8}", null, null, null, null, null, null, [9], [7]], [null, null, "(?:[25][0-8]|[34][0-4]|6[0-5])[2-9]\\d{6}", null, null, null, "234567890", null, null, null, [7]], [null, null, "7(?:[014-9]\\d|2[89]|3[01])\\d{6}", null, null, null, "701234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AF", 93, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-9]"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[2-7]"], "0$1"]], [[null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[2-7]"], "0$1"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AG: [null, [null, null, "(?:268|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "268(?:4(?:6[0-38]|84)|56[0-2])\\d{4}", null, null, null, "2684601234", null, null, null, [7]], [null, null, "268(?:464|7(?:1[3-9]|2\\d|3[246]|64|[78][0-689]))\\d{4}", null, null, null, "2684641234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, "26848[01]\\d{4}", null, null, null, "2684801234", null, null, null, [7]], "AG", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, "26840[69]\\d{4}", null, null, null, "2684061234", null, null, null, [7]], null, "268", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AI: [null, [null, null, "(?:264|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "2644(?:6[12]|9[78])\\d{4}", null, null, null, "2644612345", null, null, null, [7]], [null, null, "264(?:235|476|5(?:3[6-9]|8[1-4])|7(?:29|72))\\d{4}", null, null, null, "2642351234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "AI", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "264", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AL: [null, [null, null, "(?:(?:[2-58]|6\\d)\\d\\d|700)\\d{5}|(?:8\\d{2,3}|900)\\d{3}", null, null, null, null, null, null, [6, 7, 8, 9], [5]], [null, null, "(?:[2358](?:[16-9]\\d[2-9]|[2-5][2-9]\\d)|4(?:[2-57-9][2-9]|6\\d)\\d)\\d{4}", null, null, null, "22345678", null, null, [8], [5, 6, 7]], [null, null, "6(?:[689][2-9]|7[2-6])\\d{6}", null, null, null, "662123456", null, null, [9]], [null, null, "800\\d{4}", null, null, null, "8001234", null, null, [7]], [null, null, "900[1-9]\\d\\d", null, null, null, "900123", null, null, [6]], [null, null, "808[1-9]\\d\\d", null, null, null, "808123", null, null, [6]], [null, null, "700[2-9]\\d{4}", null, null, null, "70021234", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], "AL", 355, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3,4})", "$1 $2", ["80|9"], "0$1"], [null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["4[2-6]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[2358][2-5]|4"], "0$1"], [null, "(\\d{3})(\\d{5})", "$1 $2", ["[23578]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["6"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AM: [null, [null, null, "(?:[1-489]\\d|55|60|77)\\d{6}", null, null, null, null, null, null, [8], [5, 6]], [null, null, "(?:(?:1[0-2]|47)\\d|2(?:2[2-46]|3[1-8]|4[2-69]|5[2-7]|6[1-9]|8[1-7])|3[12]2)\\d{5}", null, null, null, "10123456", null, null, null, [5, 6]], [null, null, "(?:4[1349]|55|77|88|9[13-9])\\d{6}", null, null, null, "77123456"], [null, null, "800\\d{5}", null, null, null, "80012345"], [null, null, "90[016]\\d{5}", null, null, null, "90012345"], [null, null, "80[1-4]\\d{5}", null, null, null, "80112345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "60(?:2[78]|3[5-9]|4[02-9]|5[0-46-9]|[6-8]\\d|90)\\d{4}", null, null, null, "60271234"], "AM", 374, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{6})", "$1 $2", ["1|47"], "(0$1)"], [null, "(\\d{3})(\\d{5})", "$1 $2", ["[23]"], "(0$1)"], [null, "(\\d{2})(\\d{6})", "$1 $2", ["[4-7]|88|9[13-9]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["[89]"], "0 $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AO: [null, [null, null, "[29]\\d{8}", null, null, null, null, null, null, [9]], [null, null, "2\\d(?:[0134][25-9]|[25-9]\\d)\\d{5}", null, null, null, "222123456"], [null, null, "9[1-49]\\d{7}", null, null, null, "923123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AO", 244, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[29]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AR: [null, [null, null, "(?:11|(?:[2368]|9\\d)\\d)\\d{8}", null, null, null, null, null, null, [10, 11], [6, 7, 8]], [null, null, "11\\d{8}|(?:2(?:2(?:[013]\\d|2[13-79]|4[1-6]|5[2457]|6[124-8]|7[1-4]|8[13-6]|9[1267])|3(?:[07]\\d|1[467]|2[03-6]|3[13-8]|[49][2-6]|5[2-8]|6[013-9])|4(?:7[3-8]|9\\d)|6(?:[01346]\\d|2[24-6]|5[15-8])|80\\d|9(?:[012789]\\d|3[1-6]|4[02-9]|5[234]|6[2-46]))|3(?:3(?:2[79]|6\\d|8[2578])|4(?:0[0124-9]|[1-357]\\d|4[24-7]|6[02-9]|8[0-79]|9[1236-8])|5(?:[138]\\d|2[1245]|4[1-9]|6[2-4]|7[1-6])|6[24]\\d|7(?:[069]\\d|1[1568]|2[013-9]|3[145]|4[0-35-9]|5[14-8]|7[2-57]|8[0-24-9])|8(?:[01578]\\d|2[15-7]|3[0-24-9]|4[13-6]|6[1-357-9]|9[124]))|670\\d)\\d{6}", null, null, null, "1123456789", null, null, [10], [6, 7, 8]], [null, null, "675\\d{7}|9(?:11[2-9]\\d{7}|(?:2(?:2[013]|3[067]|49|6[01346]|80|9[147-9])|3(?:36|4[1-358]|5[138]|6[24]|7[069]|8[013578]))[2-9]\\d{6}|(?:2(?:2(?:02|2[13-79]|4[1-6]|5[2457]|6[124-8]|7[1-4]|8[13-6]|9[1267])|3(?:02|1[467]|2[03-6]|3[13-8]|[49][2-6]|5[2-8])|47[3-578]|6(?:2[24-6]|4[6-8]|5[15-8])|9(?:0[1-3]|2\\d|3[1-6]|4[02568]|5[2-4]|6[2-46]|72|8[23]))|3(?:3(?:2[79]|8[2578])|4(?:0[0-24-9]|4[24-7]|6[02-9]|7[126]|9[1-36-8])|5(?:2[1245]|3[237]|4[1-46-9]|6[2-4]|7[1-6]|8[2-5])|7(?:1[1568]|2[15]|3[145]|4[13]|5[14-8]|7[2-57]|8[126])|8(?:2[15-7]|3[2578]|4[13-6]|5[4-8]|6[1-357-9]|9[124])))[2-9]\\d{5})", null, null, null, "91123456789", null, null, null, [6, 7, 8]], [null, null, "800\\d{7}", null, null, null, "8001234567", null, null, [10]], [null, null, "60[04579]\\d{7}", null, null, null, "6001234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AR", 54, "00", "0", null, null, "0?(?:(11|2(?:2(?:02?|[13]|2[13-79]|4[1-6]|5[2457]|6[124-8]|7[1-4]|8[13-6]|9[1267])|3(?:02?|1[467]|2[03-6]|3[13-8]|[49][2-6]|5[2-8]|[67])|4(?:7[3-578]|9)|6(?:[0136]|2[24-6]|4[6-8]?|5[15-8])|80|9(?:0[1-3]|[19]|2\\d|3[1-6]|4[02568]?|5[2-4]|6[2-46]|72?|8[23]?))|3(?:3(?:2[79]|6|8[2578])|4(?:0[0-24-9]|[12]|3[5-8]?|4[24-7]|5[4-68]?|6[02-9]|7[126]|8[2379]?|9[1-36-8])|5(?:1|2[1245]|3[237]?|4[1-46-9]|6[2-4]|7[1-6]|8[2-5]?)|6[24]|7(?:[069]|1[1568]|2[15]|3[145]|4[13]|5[14-8]|7[2-57]|8[126])|8(?:[01]|2[15-7]|3[2578]?|4[13-6]|5[4-8]?|6[1-357-9]|7[36-8]?|8[5-8]?|9[124])))?15)?", "9$1", null, null, [[null, "(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["[68]"], "0$1"], [null, "(\\d{2})(\\d{4})", "$1-$2", ["[2-9]"], "$1"], [null, "(\\d{3})(\\d{4})", "$1-$2", ["[2-9]"], "$1"], [null, "(\\d{4})(\\d{4})", "$1-$2", ["[2-9]"], "$1"], [null, "(\\d)(\\d{2})(\\d{4})(\\d{4})", "$2 15-$3-$4", ["911"], "0$1"], [null, "(\\d)(\\d{3})(\\d{3})(\\d{4})", "$2 15-$3-$4", ["9(?:2[2-4689]|3[3-8])", "9(?:2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578]))", "9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))", "9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))"], "0$1"], [null, "(\\d)(\\d{4})(\\d{2})(\\d{4})", "$2 15-$3-$4", ["9[23]"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2-$3", ["11"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2-$3", ["2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578])", "2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))", "2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))"], "0$1", null, 1], [null, "(\\d{4})(\\d{2})(\\d{4})", "$1 $2-$3", ["[23]"], "0$1", null, 1], [null, "(\\d{3})", "$1", ["1[0-2]|911"], "$1"]], [[null, "(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["[68]"], "0$1"], [null, "(\\d)(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3-$4", ["911"]], [null, "(\\d)(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3-$4", ["9(?:2[2-4689]|3[3-8])", "9(?:2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578]))", "9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))", "9(?:2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45])))"]], [null, "(\\d)(\\d{4})(\\d{2})(\\d{4})", "$1 $2 $3-$4", ["9[23]"]], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2-$3", ["11"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2-$3", ["2(?:2[013]|3[067]|49|6[01346]|8|9[147-9])|3(?:36|4[1-358]|5[138]|6|7[069]|8[013578])", "2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3[4-6]|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))", "2(?:2(?:0[013-9]|[13])|3(?:0[013-9]|[67])|49|6(?:[0136]|4[0-59])|8|9(?:[19]|44|7[013-9]|8[14]))|3(?:36|4(?:[12]|3(?:4|5[014]|6[1-39])|[58]4)|5(?:1|3[0-24-689]|8[46])|6|7[069]|8(?:[01]|34|[578][45]))"], "0$1", null, 1], [null, "(\\d{4})(\\d{2})(\\d{4})", "$1 $2-$3", ["[23]"], "0$1", null, 1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "810\\d{7}", null, null, null, null, null, null, [10]], [null, null, "810\\d{7}", null, null, null, "8101234567", null, null, [10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AS: [null, [null, null, "(?:[58]\\d\\d|684|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "6846(?:22|33|44|55|77|88|9[19])\\d{4}", null, null, null, "6846221234", null, null, null, [7]], [null, null, "684(?:2(?:5[2468]|72)|7(?:3[13]|70))\\d{4}", null, null, null, "6847331234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "AS", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "684", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AT: [null, [null, null, "[1-35-9]\\d{8,12}|4(?:[0-24-9]\\d{4,11}|3(?:(?:0\\d|5[02-9])\\d{3,9}|2\\d{4,5}|[3467]\\d{4}|8\\d{4,6}|9\\d{4,7}))|[1-35-8]\\d{7}|[1-35-7]\\d{6}|[135-7]\\d{5}|[15]\\d{4}|1\\d{3}", null, null, null, null, null, null, [4, 5, 6, 7, 8, 9, 10, 11, 12, 13], [3]], [null, null, "(?:1(?:11|[2-9]\\d{2,10})|(?:2(?:1[467]|2[13-8]|5[2357]|6[1-46-8]|7[1-8]|8[124-7]|9[1458])|3(?:1[1-8]|3[23568]|4[5-7]|5[1378]|6[1-38]|8[3-68])|7(?:2[1-8]|3[25]|4[13478]|5[68]|6[16-8]|7[1-6]|9[45]))\\d{3,9}|4(?:(?:2[1-8]|35|7[1368]|8[2457])\\d{3,9}|63\\d{2,9})|5(?:12\\d{2,9}|(?:2[1-8]|3[357]|4[147]|5[12578]|6[37])\\d{3,9})|6(?:(?:13|2[1-47]|4[135-8]|5[468])\\d{3,9}|62\\d{2,9}))\\d|(?:316|732)\\d{3}", null, null, null, "1234567890", null, null, null, [3]], [null, null, "6(?:5[0-3579]|6[013-9]|[7-9]\\d)\\d{4,10}", null, null, null, "664123456", null, null, [7, 8, 9, 10, 11, 12, 13]], [null, null, "800\\d{6,10}", null, null, null, "800123456", null, null, [9, 10, 11, 12, 13]], [null, null, "9(?:0[01]|3[019])\\d{6,10}", null, null, null, "900123456", null, null, [9, 10, 11, 12, 13]], [null, null, "8(?:10|2[018])\\d{6,10}|828\\d{5}", null, null, null, "810123456", null, null, [8, 9, 10, 11, 12, 13]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:0[1-9]|17|[79]\\d)\\d{2,10}|7[28]0\\d{6,10}", null, null, null, "780123456", null, null, [5, 6, 7, 8, 9, 10, 11, 12, 13]], "AT", 43, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3,12})", "$1 $2", ["1(?:11|[2-9])"], "0$1"], [null, "(\\d{3})(\\d{2})", "$1 $2", ["517"], "0$1"], [null, "(\\d{2})(\\d{3,5})", "$1 $2", ["5[079]"], "0$1"], [null, "(\\d{3})(\\d{3,10})", "$1 $2", ["(?:31|4)6|51|6(?:5[0-3579]|[6-9])|7(?:20|32|8)|[89]"], "0$1"], [null, "(\\d{4})(\\d{3,9})", "$1 $2", ["[2-467]|5[2-6]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["5"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4,7})", "$1 $2 $3", ["5"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AU: [null, [null, null, "1\\d{4,9}|(?:[2-478]\\d\\d|550)\\d{6}", null, null, null, null, null, null, [5, 6, 7, 8, 9, 10]], [null, null, "(?:[237]\\d{5}|8(?:51(?:0(?:0[03-9]|[1247]\\d|3[2-9]|5[0-8]|6[1-9]|8[0-6])|1(?:1[69]|[23]\\d|4[0-4]))|(?:[6-8]\\d{3}|9(?:[02-9]\\d\\d|1(?:[0-57-9]\\d|6[0135-9])))\\d))\\d{3}", null, null, null, "212345678", null, null, [9], [8]], [null, null, "4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[6-9]|7[02-9]|8[0-2457-9]|9[017-9])\\d{6}", null, null, null, "412345678", null, null, [9]], [null, null, "180(?:0\\d{3}|2)\\d{3}", null, null, null, "1800123456", null, null, [7, 10]], [null, null, "190[0-26]\\d{6}", null, null, null, "1900123456", null, null, [10]], [null, null, "13(?:00\\d{3}|45[0-4])\\d{3}|13\\d{4}", null, null, null, "1300123456", null, null, [6, 8, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:14(?:5\\d|71)|550\\d)\\d{5}", null, null, null, "550123456", null, null, [9]], "AU", 61, "001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011", "0", null, null, "0", null, "0011", null, [[null, "(\\d{3})(\\d{3})", "$1 $2", ["19"]], [null, "(\\d{4})(\\d{3,4})", "$1 $2", ["19"]], [null, "(\\d{2})(\\d{3,4})", "$1 $2", ["16"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["13"]], [null, "(\\d{3})(\\d{4})", "$1 $2", ["180", "1802"]], [null, "(\\d{2})(\\d{3})(\\d{2,4})", "$1 $2 $3", ["16"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["[2378]"], "(0$1)"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["14|[45]"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1(?:30|[89])"]]], [[null, "(\\d{2})(\\d{3,4})", "$1 $2", ["16"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2,4})", "$1 $2 $3", ["16"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["[2378]"], "(0$1)"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["14|[45]"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1(?:30|[89])"]]], [null, null, "16\\d{3,7}", null, null, null, "1612345", null, null, [5, 6, 7, 8, 9]], 1, null, [null, null, "1[38]00\\d{6}|1(?:345[0-4]|802)\\d{3}|13\\d{4}", null, null, null, null, null, null, [6, 7, 8, 10]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AW: [null, [null, null, "(?:[25-79]\\d\\d|800)\\d{4}", null, null, null, null, null, null, [7]], [null, null, "5(?:2\\d|8[1-9])\\d{4}", null, null, null, "5212345"], [null, null, "(?:290|5[69]\\d|6(?:[03]0|22|4[0-2]|[69]\\d)|7(?:[34]\\d|7[07])|9(?:6[45]|9[4-8]))\\d{4}", null, null, null, "5601234"], [null, null, "800\\d{4}", null, null, null, "8001234"], [null, null, "900\\d{4}", null, null, null, "9001234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:28\\d|501)\\d{4}", null, null, null, "5011234"], "AW", 297, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[25-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AX: [null, [null, null, "(?:(?:[1247]\\d|3[0-46-9]|[56]0)\\d\\d|800)\\d{4,6}|(?:[1-47]\\d|50)\\d{4,5}|2\\d{4}", null, null, null, null, null, null, [5, 6, 7, 8, 9, 10]], [null, null, "18[1-8]\\d{3,6}", null, null, null, "181234567", null, null, [6, 7, 8, 9]], [null, null, "(?:4[0-8]|50)\\d{4,8}", null, null, null, "412345678", null, null, [6, 7, 8, 9, 10]], [null, null, "800\\d{4,6}", null, null, null, "800123456", null, null, [7, 8, 9]], [null, null, "[67]00\\d{5,6}", null, null, null, "600123456", null, null, [8, 9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AX", 358, "00|99(?:[01469]|5(?:[14]1|3[23]|5[59]|77|88|9[09]))", "0", null, null, "0", null, "00", null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "18", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:10|[23][09])\\d{4,8}|60(?:[12]\\d{5,6}|6\\d{7})|7(?:(?:1|3\\d)\\d{7}|5[03-9]\\d{3,7})|20[2-59]\\d\\d", null, null, null, "10112345"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    AZ: [null, [null, null, "(?:(?:(?:[12457]\\d|60|88)\\d|365)\\d{3}|900200)\\d{3}", null, null, null, null, null, null, [9], [7]], [null, null, "(?:(?:1[28]\\d|2(?:[045]2|1[24]|2[2-4]|33|6[23]))\\d\\d|365(?:[0-46-9]\\d|5[0-35-9]))\\d{4}", null, null, null, "123123456", null, null, null, [7]], [null, null, "(?:36554|(?:4[04]|5[015]|60|7[07])\\d{3})\\d{4}", null, null, null, "401234567"], [null, null, "88\\d{7}", null, null, null, "881234567"], [null, null, "900200\\d{3}", null, null, null, "900200123"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "AZ", 994, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[12]|365", "[12]|365", "[12]|365(?:[0-46-9]|5[0-35-9])"], "(0$1)"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["9"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[3-8]"], "0$1"]], [[null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[12]|365", "[12]|365", "[12]|365(?:[0-46-9]|5[0-35-9])"], "(0$1)"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["9"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[3-8]"], "0$1"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BA: [null, [null, null, "(?:[3589]\\d|49|6\\d\\d?|70)\\d{6}", null, null, null, null, null, null, [8, 9], [6]], [null, null, "(?:3(?:[05-79][2-9]|1[4579]|[23][24-9]|4[2-4689]|8[2457-9])|49[2-579]|5(?:0[2-49]|[13][2-9]|[268][2-4679]|4[4689]|5[2-79]|7[2-69]|9[2-4689]))\\d{5}", null, null, null, "30212345", null, null, [8], [6]], [null, null, "6(?:0(?:3\\d|40)|[1-356]\\d|44[0-6]|71[137])\\d{5}", null, null, null, "61123456"], [null, null, "8[08]\\d{6}", null, null, null, "80123456", null, null, [8]], [null, null, "9[0246]\\d{6}", null, null, null, "90123456", null, null, [8]], [null, null, "8[12]\\d{6}", null, null, null, "82123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BA", 387, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3})", "$1-$2", ["[2-9]"]], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2-$3", ["[3-5]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["6[1-356]|[7-9]"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["6"], "0$1"]], [[null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2-$3", ["[3-5]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["6[1-356]|[7-9]"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["6"], "0$1"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70(?:3[0146]|[56]0)\\d{4}", null, null, null, "70341234", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BB: [null, [null, null, "(?:246|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "246(?:2(?:2[78]|7[0-4])|4(?:1[024-6]|2\\d|3[2-9])|5(?:20|[34]\\d|54|7[1-3])|6(?:2\\d|38)|7[35]7|9(?:1[89]|63))\\d{4}", null, null, null, "2464123456", null, null, null, [7]], [null, null, "246(?:2(?:[356]\\d|4[0-57-9]|8[0-79])|45\\d|69[5-7]|8(?:[2-5]\\d|83))\\d{4}", null, null, null, "2462501234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "(?:246976|900[2-9]\\d\\d)\\d{4}", null, null, null, "9002123456", null, null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, "24631\\d{5}", null, null, null, "2463101234", null, null, null, [7]], "BB", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "246", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "246(?:292|367|4(?:1[7-9]|3[01]|44|67)|7(?:36|53))\\d{4}", null, null, null, "2464301234", null, null, null, [7]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BD: [null, [null, null, "[13469]\\d{9}|8[0-79]\\d{7,8}|[2-7]\\d{8}|[2-9]\\d{7}|[3-689]\\d{6}|[57-9]\\d{5}", null, null, null, null, null, null, [6, 7, 8, 9, 10]], [null, null, "(?:(?:2(?:[45]\\d{3}|7(?:1[0-267]|2[0-289]|3[0-29]|4[01]|5[1-3]|6[013]|7[0178]|91)|8(?:0[125]|[13][1-6]|2[0157-9]|41|6[1-35]|7[1-5]|8[1-8]|9[0-6])|9(?:0[0-2]|1[0-4]|2[568]|3[3-6]|5[5-7]|6[01367]|7[15]|8[0146-9]))|7(?:02|21\\d|[3-589]1|6[12]|72[24])\\d|8(?:(?:[01]|217|3[12])\\d|4[12]|[5-7](?:1\\d|2)))\\d|3(?:(?:0(?:2[348]\\d|3[2-6])|(?:1(?:2[5-7]|[5-7])|3(?:1|24)|[5-7]1)\\d)\\d|2(?:1\\d\\d|2(?:[35]\\d\\d|4))|4(?:1\\d\\d|2(?:[25]\\d\\d|[47]))|8(?:1\\d\\d|2(?:(?:2\\d|4)\\d|3)))|4(?:0(?:2(?:[09]\\d|7)|33\\d\\d)|(?:1\\d|4(?:2[2-46]|5[25])|8(?:23|54))\\d\\d|2(?:1\\d\\d|2(?:[25]|[67]\\d\\d))|3(?:1\\d\\d(?:\\d{2})?|(?:2[236-9]|32)\\d\\d)|525|6(?:(?:[18]|2[3-6]|62)\\d\\d|5(?:[38]|[5-7]\\d\\d))|9(?:(?:[18]|2[2-5])\\d\\d|53\\d\\d?))|5(?:(?:02[03489]|1|22[2457]|32[35-79]|42[46]|[58]26|724)\\d\\d|6(?:(?:[18]|53)\\d\\d|2))|6(?:(?:(?:[04]2[34]|32[3478]|52[47]|[78]2[2-5]|92[2-6])\\d|6(?:[18]\\d|6(?:2(?:2|[34]\\d)|5[245]\\d)))\\d|2(?:(?:2[2-5]|8)\\d\\d|5(?:[3-5]\\d\\d|7)))|9(?:[24]1\\d\\d|[35]1))\\d{3}|(?:3(?:0(?:2[02-9]\\d|3[56])|(?:22[1-5]|32[2-6]|422)\\d|529)|(?:4(?:22[2-8]|32[02-9]|(?:[48][18]|71)\\d|5(?:1\\d|23)|6(?:2[467]|5[3-57]))|5(?:[2-47-9]1\\d|5(?:1\\d|26))|6(?:0(?:1\\d|24)|[3-589]1\\d|665[35])|81|9(?:[024]2|1\\d|81))\\d|732)\\d{3}|(?:4[46]23|5(?:222|32[37]))\\d{3}", null, null, null, "27111234"], [null, null, "(?:1[13-9]\\d|(?:3[78]|44)[02-9]|6(?:44|6[02-9]))\\d{7}", null, null, null, "1812345678", null, null, [10]], [null, null, "80[03]\\d{7}", null, null, null, "8001234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "96(?:0[469]|1[0-47]|3[389]|6[69]|7[78])\\d{6}", null, null, null, "9604123456", null, null, [10]], "BD", 880, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{4,6})", "$1-$2", ["31[5-7]|[459]1"], "0$1"], [null, "(\\d{3})(\\d{3,7})", "$1-$2", ["3(?:[2-5]1|[67]|8[013-9])|4(?:[235]1|4[01346-9]|6[168]|7|[89][18])|5(?:[2-578]1|6[128]|9)|6(?:[0389]1|28|4[14]|5|6[01346-9])|7(?:[2-589]|61)|8(?:0[014-9]|[12]|[3-7]1)|9(?:[24]1|[358])"], "0$1"], [null, "(\\d{4})(\\d{3,6})", "$1-$2", ["[13-9]"], "0$1"], [null, "(\\d)(\\d{7,8})", "$1-$2", ["2"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BE: [null, [null, null, "4\\d{8}|[1-9]\\d{7}", null, null, null, null, null, null, [8, 9]], [null, null, "(?:(?:1[0-69]|[23][2-8]|4[23]|5\\d|6[013-57-9]|71|9[2-4])\\d|8(?:0[2-8]|[1-79]\\d))\\d{5}", null, null, null, "12345678", null, null, [8]], [null, null, "4(?:5[56]|6[0135-8]|[79]\\d|8[3-9])\\d{6}", null, null, null, "470123456", null, null, [9]], [null, null, "800[1-9]\\d{4}", null, null, null, "80012345", null, null, [8]], [null, null, "(?:70(?:2[0-57]|3[0457]|44|69|7[0579])|90(?:0[0-35-8]|1[36]|2[0-3568]|3[0135689]|4[2-68]|5[1-68]|6[0-378]|7[23568]|9[34679]))\\d{4}", null, null, null, "90012345", null, null, [8]], [null, null, "7879\\d{4}", null, null, null, "78791234", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BE", 32, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[23]|4[23]|9[2-4]"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[15-7]|8(?:0[2-8]|[1-79])"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["[89]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["4"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "78(?:0[57]|1[0458]|2[25]|3[5-8]|48|[56]0|7[078])\\d{4}", null, null, null, "78102345", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BF: [null, [null, null, "[25-7]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "2(?:0(?:49|5[23]|6[56]|9[016-9])|4(?:4[569]|5[4-6]|6[56]|7[0179])|5(?:[34]\\d|50|6[5-7]))\\d{4}", null, null, null, "20491234"], [null, null, "(?:5[124-8]|[67]\\d)\\d{6}", null, null, null, "70123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BF", 226, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[25-7]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BG: [null, [null, null, "[2-7]\\d{6,7}|[89]\\d{6,8}|2\\d{5}", null, null, null, null, null, null, [6, 7, 8, 9], [4, 5]], [null, null, "(?:(?:[236]\\d|5[1-9]|8[1-6]|9[1-7])\\d|4(?:[124-7]\\d|3[1-6])|7(?:0[1-9]|[1-9]\\d))\\d{4,5}|2\\d{5}", null, null, null, "2123456", null, null, [6, 7, 8], [4, 5]], [null, null, "(?:4(?:3[07-9]|8\\d)|(?:8[7-9]\\d|9(?:8\\d|9[69]))\\d)\\d{5}", null, null, null, "48123456", null, null, [8, 9]], [null, null, "800\\d{5}", null, null, null, "80012345", null, null, [8]], [null, null, "90\\d{6}", null, null, null, "90123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "700\\d{5}", null, null, null, "70012345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], "BG", 359, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d)(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["2"], "0$1"], [null, "(\\d{3})(\\d{4})", "$1 $2", ["43[1-6]|70[1-9]"], "0$1"], [null, "(\\d)(\\d{3})(\\d{3,4})", "$1 $2 $3", ["2"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2,3})", "$1 $2 $3", ["[356]|4[124-7]|7[1-9]|8[1-6]|9[1-7]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{2})", "$1 $2 $3", ["43[1-7]|70[1-9]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["7|80"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[48]|9[08]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["9"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BH: [null, [null, null, "[136-9]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "(?:1(?:3[1356]|6[0156]|7\\d)\\d|6(?:1[16]\\d|500|6(?:0\\d|3[12]|44|7[7-9])|9[69][69])|7(?:1(?:11|78)|7\\d\\d))\\d{4}", null, null, null, "17001234"], [null, null, "(?:3(?:[1-4679]\\d|5[013-69]|8[0-47-9])\\d|6(?:3(?:00|33|6[16])|6(?:3[03-9]|[69]\\d|7[0-6])))\\d{4}", null, null, null, "36001234"], [null, null, "80\\d{6}", null, null, null, "80123456"], [null, null, "(?:87|9[014578])\\d{6}", null, null, null, "90123456"], [null, null, "84\\d{6}", null, null, null, "84123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BH", 973, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{4})", "$1 $2", ["[1367]|8[047]|9[014578]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BI: [null, [null, null, "(?:[267]\\d|31)\\d{6}", null, null, null, null, null, null, [8]], [null, null, "22\\d{6}", null, null, null, "22201234"], [null, null, "(?:29|31|6[189]|7[125-9])\\d{6}", null, null, null, "79561234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BI", 257, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[23]|6[189]|7[125-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BJ: [null, [null, null, "[2689]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "2(?:02|1[037]|2[45]|3[68])\\d{5}", null, null, null, "20211234"], [null, null, "(?:6\\d|9[03-9])\\d{6}", null, null, null, "90011234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "857[58]\\d{4}", null, null, null, "85751234"], "BJ", 229, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2689]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "81\\d{6}", null, null, null, "81123456"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BL: [null, [null, null, "(?:590|69\\d)\\d{6}", null, null, null, null, null, null, [9]], [null, null, "590(?:2[7-9]|5[12]|87)\\d{4}", null, null, null, "590271234"], [null, null, "69(?:0\\d\\d|1(?:2[29]|3[0-5]))\\d{4}", null, null, null, "690001234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BL", 590, "00", "0", null, null, "0", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BM: [null, [null, null, "(?:441|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "441(?:2(?:02|23|[3479]\\d|61)|[46]\\d\\d|5(?:4\\d|60|89)|824)\\d{4}", null, null, null, "4412345678", null, null, null, [7]], [null, null, "441(?:[37]\\d|5[0-39])\\d{5}", null, null, null, "4413701234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "BM", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "441", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BN: [null, [null, null, "[2-578]\\d{6}", null, null, null, null, null, null, [7]], [null, null, "(?:2(?:[013-9]\\d|2[0-7])|[3-5]\\d\\d)\\d{4}", null, null, null, "2345678"], [null, null, "(?:22[89]|[78]\\d\\d)\\d{4}", null, null, null, "7123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BN", 673, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-578]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BO: [null, [null, null, "(?:[2-467]\\d{3}|80017)\\d{4}", null, null, null, null, null, null, [8, 9], [7]], [null, null, "(?:2(?:2\\d\\d|5(?:11|[258]\\d|9[67])|6(?:12|2\\d|9[34])|8(?:2[34]|39|62))|3(?:3\\d\\d|4(?:6\\d|8[24])|8(?:25|42|5[257]|86|9[25])|9(?:[27]\\d|3[2-4]|4[248]|5[24]|6[2-6]))|4(?:4\\d\\d|6(?:11|[24689]\\d|72)))\\d{4}", null, null, null, "22123456", null, null, [8], [7]], [null, null, "[67]\\d{7}", null, null, null, "71234567", null, null, [8]], [null, null, "80017\\d{4}", null, null, null, "800171234", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BO", 591, "00(?:1\\d)?", "0", null, null, "0(1\\d)?", null, null, null, [[null, "(\\d)(\\d{7})", "$1 $2", ["[2-4]"], null, "0$CC $1"], [null, "(\\d{8})", "$1", ["[67]"], null, "0$CC $1"], [null, "(\\d{3})(\\d{2})(\\d{4})", "$1 $2 $3", ["8"], null, "0$CC $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BQ: [null, [null, null, "(?:[34]1|7\\d)\\d{5}", null, null, null, null, null, null, [7]], [null, null, "(?:318[023]|41(?:6[023]|70)|7(?:1[578]|50)\\d)\\d{3}", null, null, null, "7151234"], [null, null, "(?:31(?:8[14-8]|9[14578])|416[14-9]|7(?:0[01]|7[07]|8\\d|9[056])\\d)\\d{3}", null, null, null, "3181234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BQ", 599, "00", null, null, null, null, null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "[347]", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BR: [null, [null, null, "(?:[1-46-9]\\d\\d|5(?:[0-46-9]\\d|5[0-24679]))\\d{8}|[1-9]\\d{9}|[3589]\\d{8}|[34]\\d{7}", null, null, null, null, null, null, [8, 9, 10, 11]], [null, null, "(?:[14689][1-9]|2[12478]|3[1-578]|5[13-5]|7[13-579])[2-5]\\d{7}", null, null, null, "1123456789", null, null, [10], [8]], [null, null, "(?:[189][1-9]|2[12478])(?:7|9\\d)\\d{7}|(?:3[1-578]|[46][1-9]|5[13-5]|7[13-579])(?:[6-9]|9\\d)\\d{7}", null, null, null, "11961234567", null, null, [10, 11], [8]], [null, null, "800\\d{6,7}", null, null, null, "800123456", null, null, [9, 10]], [null, null, "(?:300|[59]00\\d?)\\d{6}", null, null, null, "300123456", null, null, [9, 10]], [null, null, "(?:300\\d(?:\\d{2})?|4(?:0(?:0\\d|20)|370))\\d{4}", null, null, null, "40041234", null, null, [8, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BR", 55, "00(?:1[245]|2[1-35]|31|4[13]|[56]5|99)", "0", null, null, "0(?:(1[245]|2[1-35]|31|4[13]|[56]5|99)(\\d{10,11}))?", "$2", null, null, [[null, "(\\d{4})(\\d{4})", "$1-$2", ["300|4(?:0[02]|37)", "300|4(?:0(?:0|20)|370)"]], [null, "(\\d{3})(\\d{2,3})(\\d{4})", "$1 $2 $3", ["[3589]00"], "0$1"], [null, "(\\d{3,5})", "$1", ["1[125689]"]], [null, "(\\d{4})(\\d{4})", "$1-$2", ["[2-9](?:0[1-9]|[1-9])"]], [null, "(\\d{5})(\\d{4})", "$1-$2", ["9(?:0[1-9]|[1-9])"]], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2-$3", ["[1-9][1-9]"], "($1)", "0 $CC ($1)"], [null, "(\\d{2})(\\d{5})(\\d{4})", "$1 $2-$3", ["[1-9][1-9]9"], "($1)", "0 $CC ($1)"]], [[null, "(\\d{4})(\\d{4})", "$1-$2", ["300|4(?:0[02]|37)", "300|4(?:0(?:0|20)|370)"]], [null, "(\\d{3})(\\d{2,3})(\\d{4})", "$1 $2 $3", ["[3589]00"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2-$3", ["[1-9][1-9]"], "($1)", "0 $CC ($1)"], [null, "(\\d{2})(\\d{5})(\\d{4})", "$1 $2-$3", ["[1-9][1-9]9"], "($1)", "0 $CC ($1)"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "(?:300\\d|40(?:0\\d|20))\\d{4}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BS: [null, [null, null, "(?:242|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "242(?:3(?:02|[236][1-9]|4[0-24-9]|5[0-68]|7[347]|8[0-4]|9[2-467])|461|502|6(?:0[1-4]|12|2[013]|[45]0|7[67]|8[78]|9[89])|7(?:02|88))\\d{4}", null, null, null, "2423456789", null, null, null, [7]], [null, null, "242(?:3(?:5[79]|7[56]|95)|4(?:[23][1-9]|4[1-35-9]|5[1-8]|6[2-8]|7\\d|81)|5(?:2[45]|3[35]|44|5[1-46-9]|65|77)|6[34]6|7(?:27|38)|8(?:0[1-9]|1[02-9]|2\\d|[89]9))\\d{4}", null, null, null, "2423591234", null, null, null, [7]], [null, null, "(?:242300|8(?:00|33|44|55|66|77|88)[2-9]\\d\\d)\\d{4}", null, null, null, "8002123456", null, null, null, [7]], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "BS", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "242", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "242225[0-46-9]\\d{3}", null, null, null, "2422250123"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BT: [null, [null, null, "[17]\\d{7}|[2-8]\\d{6}", null, null, null, null, null, null, [7, 8], [6]], [null, null, "(?:2[3-6]|[34][5-7]|5[236]|6[2-46]|7[246]|8[2-4])\\d{5}", null, null, null, "2345678", null, null, [7], [6]], [null, null, "(?:1[67]|77)\\d{6}", null, null, null, "17123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BT", 975, "00", null, null, null, null, null, null, null, [[null, "(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[23568]|4[5-7]|7[246]"]], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["1[67]|7"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BW: [null, [null, null, "(?:(?:[2-6]|7\\d)\\d|90)\\d{5}", null, null, null, null, null, null, [7, 8]], [null, null, "(?:2(?:4[0-48]|6[0-24]|9[0578])|3(?:1[0-35-9]|55|[69]\\d|7[01])|4(?:6[03]|7[1267]|9[0-5])|5(?:3[0389]|4[0489]|7[1-47]|88|9[0-49])|6(?:2[1-35]|5[149]|8[067]))\\d{4}", null, null, null, "2401234", null, null, [7]], [null, null, "7(?:[1-6]\\d{3}|7(?:[014-8]\\d\\d|200))\\d{3}", null, null, null, "71123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "90\\d{5}", null, null, null, "9012345", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "79(?:1(?:[01]\\d|20)|2[0-2]\\d)\\d{3}", null, null, null, "79101234", null, null, [8]], "BW", 267, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-6]"]], [null, "(\\d{2})(\\d{5})", "$1 $2", ["90"]], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["7"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BY: [null, [null, null, "(?:(?:[12]|8[0-7]\\d)\\d|33|44|902)\\d{7}|8(?:[05-79]\\d|1[0-489])\\d{7}|8[0-79]\\d{5,7}|8\\d{5}", null, null, null, null, null, null, [6, 7, 8, 9, 10, 11], [5]], [null, null, "(?:1(?:5(?:1[1-5]|[24]\\d|6[2-4]|9[1-7])|6(?:[235]\\d|4[1-7])|7\\d\\d)|2(?:1(?:[246]\\d|3[0-35-9]|5[1-9])|2(?:[235]\\d|4[0-8])|3(?:[26]\\d|3[02-79]|4[024-7]|5[03-7])))\\d{5}", null, null, null, "152450911", null, null, [9], [5, 6, 7]], [null, null, "(?:2(?:5[5-79]|9[1-9])|(?:33|44)\\d)\\d{6}", null, null, null, "294911911", null, null, [9]], [null, null, "8(?:0[013]|20\\d)\\d{7}|800\\d{3,6}", null, null, null, "8011234567"], [null, null, "(?:810|902)\\d{7}", null, null, null, "9021234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "249\\d{6}", null, null, null, "249123456", null, null, [9]], "BY", 375, "810", "8", null, null, "0|80?", null, "8~10", null, [[null, "(\\d{3})(\\d{3})", "$1 $2", ["800"], "8 $1"], [null, "(\\d{3})(\\d{2})(\\d{2,4})", "$1 $2 $3", ["800"], "8 $1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2-$3-$4", ["1(?:5[24]|6[235]|7[467])|2(?:1[246]|2[25]|3[26])", "1(?:5[24]|6(?:2|3[04-9]|5[0346-9])|7(?:[46]|7[37-9]))|2(?:1[246]|2[25]|3[26])"], "8 0$1"], [null, "(\\d{4})(\\d{2})(\\d{3})", "$1 $2-$3", ["1(?:[56]|7[179])|2[1-3]", "1(?:[56]|7(?:1[3-9]|7|9[2-7]))|2[1-3]"], "8 0$1"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2-$3-$4", ["[1-4]"], "8 0$1"], [null, "(\\d{3})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["[89]"], "8 $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "(?:8(?:0[013]|10|20\\d)|902)\\d{7}|800\\d{3,6}"], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    BZ: [null, [null, null, "(?:0800\\d|[2-8])\\d{6}", null, null, null, null, null, null, [7, 11]], [null, null, "(?:2(?:[02]\\d|36)|[3-58][02]\\d|7(?:[02]\\d|32))\\d{4}", null, null, null, "2221234", null, null, [7]], [null, null, "6[0-35-7]\\d{5}", null, null, null, "6221234", null, null, [7]], [null, null, "0800\\d{7}", null, null, null, "08001234123", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "BZ", 501, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1-$2", ["[2-8]"]], [null, "(\\d)(\\d{3})(\\d{4})(\\d{3})", "$1-$2-$3-$4", ["0"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CA: [null, [null, null, "(?:[2-8]\\d|90)\\d{8}", null, null, null, null, null, null, [10], [7]], [null, null, "(?:2(?:04|[23]6|[48]9|50)|3(?:06|43|65)|4(?:03|1[68]|3[178]|50)|5(?:06|1[49]|48|79|8[17])|6(?:04|13|39|47)|7(?:0[59]|78|8[02])|8(?:[06]7|19|25|73)|90[25])[2-9]\\d{6}", null, null, null, "5062345678", null, null, null, [7]], [null, null, "(?:2(?:04|[23]6|[48]9|50)|3(?:06|43|65)|4(?:03|1[68]|3[178]|50)|5(?:06|1[49]|48|79|8[17])|6(?:04|13|39|47)|7(?:0[59]|78|8[02])|8(?:[06]7|19|25|73)|90[25])[2-9]\\d{6}", null, null, null, "5062345678", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:5(?:00|2[12]|33|44|66|77|88)|622)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, "600[2-9]\\d{6}", null, null, null, "6002012345"], "CA", 1, "011", "1", null, null, "1", null, null, 1, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CC: [null, [null, null, "1\\d{5,9}|(?:[48]\\d\\d|550)\\d{6}", null, null, null, null, null, null, [6, 7, 8, 9, 10]], [null, null, "8(?:51(?:0(?:02|31|60)|118)|91(?:0(?:1[0-2]|29)|1(?:[28]2|50|79)|2(?:10|64)|3(?:[06]8|22)|4[29]8|62\\d|70[23]|959))\\d{3}", null, null, null, "891621234", null, null, [9], [8]], [null, null, "4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[6-9]|7[02-9]|8[0-2457-9]|9[017-9])\\d{6}", null, null, null, "412345678", null, null, [9]], [null, null, "180(?:0\\d{3}|2)\\d{3}", null, null, null, "1800123456", null, null, [7, 10]], [null, null, "190[0-26]\\d{6}", null, null, null, "1900123456", null, null, [10]], [null, null, "13(?:00\\d{3}|45[0-4])\\d{3}|13\\d{4}", null, null, null, "1300123456", null, null, [6, 8, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:14(?:5\\d|71)|550\\d)\\d{5}", null, null, null, "550123456", null, null, [9]], "CC", 61, "001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011", "0", null, null, "0|([59]\\d{7})$", "8$1", "0011", null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CD: [null, [null, null, "[189]\\d{8}|[1-68]\\d{6}", null, null, null, null, null, null, [7, 9]], [null, null, "12\\d{7}|[1-6]\\d{6}", null, null, null, "1234567"], [null, null, "(?:8(?:[0-2459]\\d\\d|8)|9[017-9]\\d\\d)\\d{5}", null, null, null, "991234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CD", 243, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3", ["88"], "0$1"], [null, "(\\d{2})(\\d{5})", "$1 $2", ["[1-6]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[89]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CF: [null, [null, null, "(?:[27]\\d{3}|8776)\\d{4}", null, null, null, null, null, null, [8]], [null, null, "2[12]\\d{6}", null, null, null, "21612345"], [null, null, "7[0257]\\d{6}", null, null, null, "70012345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "8776\\d{4}", null, null, null, "87761234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CF", 236, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[278]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CG: [null, [null, null, "(?:(?:0\\d|80)\\d|222)\\d{6}", null, null, null, null, null, null, [9]], [null, null, "222[1-589]\\d{5}", null, null, null, "222123456"], [null, null, "0[14-6]\\d{7}", null, null, null, "061234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "80(?:0\\d\\d|11[0-4])\\d{4}", null, null, null, "800123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CG", 242, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["801"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[02]"]], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["8"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CH: [null, [null, null, "8\\d{11}|[2-9]\\d{8}", null, null, null, null, null, null, [9, 12]], [null, null, "(?:2[12467]|3[1-4]|4[134]|5[256]|6[12]|[7-9]1)\\d{7}", null, null, null, "212345678", null, null, [9]], [null, null, "7[35-9]\\d{7}", null, null, null, "781234567", null, null, [9]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "90[016]\\d{6}", null, null, null, "900123456", null, null, [9]], [null, null, "84[0248]\\d{6}", null, null, null, "840123456", null, null, [9]], [null, null, "878\\d{6}", null, null, null, "878123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], "CH", 41, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-7]|[89]1"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8[047]|9"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["8"], "0$1"]], null, [null, null, "74[0248]\\d{6}", null, null, null, "740123456", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5[18]\\d{7}", null, null, null, "581234567", null, null, [9]], null, null, [null, null, "860\\d{9}", null, null, null, "860123456789", null, null, [12]]],
    CI: [null, [null, null, "[02-8]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "(?:2(?:0[023]|1[02357]|[23][045]|4[03-5])|3(?:0[06]|1[069]|[2-4][07]|5[09]|6[08]))\\d{5}", null, null, null, "21234567"], [null, null, "(?:[07][1-9]|[45]\\d|6[014-9]|8[4-9])\\d{6}", null, null, null, "01234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CI", 225, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[02-8]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CK: [null, [null, null, "[2-8]\\d{4}", null, null, null, null, null, null, [5]], [null, null, "(?:2\\d|3[13-7]|4[1-5])\\d{3}", null, null, null, "21234"], [null, null, "[5-8]\\d{4}", null, null, null, "71234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CK", 682, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{3})", "$1 $2", ["[2-8]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CL: [null, [null, null, "(?:1230|[2-57-9]\\d|6\\d{1,3})\\d{7}", null, null, null, null, null, null, [9, 10, 11]], [null, null, "(?:2(?:1962|(?:2\\d\\d|32[0-46-8])\\d)|(?:(?:3[2-5]|[47][1-35]|5[1-3578]|6[13-57]|9[2-9])\\d|8(?:0[1-9]|[1-9]\\d))\\d\\d)\\d{4}", null, null, null, "221234567", null, null, [9]], [null, null, "(?:2(?:1962|(?:2\\d\\d|32[0-46-8])\\d)|(?:(?:3[2-5]|[47][1-35]|5[1-3578]|6[13-57]|9[2-9])\\d|8(?:0[1-9]|[1-9]\\d))\\d\\d)\\d{4}", null, null, null, "221234567", null, null, [9]], [null, null, "(?:1230\\d|800)\\d{6}", null, null, null, "800123456", null, null, [9, 11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "600\\d{7,8}", null, null, null, "6001234567", null, null, [10, 11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "44\\d{7}", null, null, null, "441234567", null, null, [9]], "CL", 56, "(?:0|1(?:1[0-69]|2[0-57]|5[13-58]|69|7[0167]|8[018]))0", null, null, null, null, null, null, 1, [[null, "(\\d{4})", "$1", ["1(?:[03-58]|[29]1)"]], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["2(?:2|32)", "2(?:2|32[0-46-8])"], "($1)"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["3[2-5]|[47][1-35]|5[1-3578]|6[13-57]|8(?:0[1-9]|[1-9])"], "($1)"], [null, "(\\d{5})(\\d{4})", "$1 $2", ["2"], "($1)"], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["9[2-9]"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["44"]], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[68]00"]], [null, "(\\d{3})(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["600"]], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"]]], [[null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["2(?:2|32)", "2(?:2|32[0-46-8])"], "($1)"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["3[2-5]|[47][1-35]|5[1-3578]|6[13-57]|8(?:0[1-9]|[1-9])"], "($1)"], [null, "(\\d{5})(\\d{4})", "$1 $2", ["2"], "($1)"], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["9[2-9]"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["44"]], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[68]00"]], [null, "(\\d{3})(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["600"]], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"]]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "600\\d{7,8}", null, null, null, null, null, null, [10, 11]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CM: [null, [null, null, "(?:[26]\\d\\d|88)\\d{6}", null, null, null, null, null, null, [8, 9]], [null, null, "2(?:22|33|4[23])\\d{6}", null, null, null, "222123456", null, null, [9]], [null, null, "6[5-9]\\d{7}", null, null, null, "671234567", null, null, [9]], [null, null, "88\\d{6}", null, null, null, "88012345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CM", 237, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["88"]], [null, "(\\d)(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["[26]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CN: [null, [null, null, "(?:(?:(?:1[03-68]|2\\d)\\d\\d|[3-79])\\d|8[0-57-9])\\d{7}|[1-579]\\d{10}|8[0-57-9]\\d{8,9}|[1-79]\\d{9}|[1-9]\\d{7}|[12]\\d{6}", null, null, null, null, null, null, [7, 8, 9, 10, 11, 12], [5, 6]], [null, null, "21(?:100\\d{2}|95\\d{3,4}|\\d{8,10})|(?:10|2[02-57-9]|3(?:11|7[179])|4(?:[15]1|3[1-35])|5(?:1\\d|2[37]|3[12]|51|7[13-79]|9[15])|7(?:31|5[457]|6[09]|91)|8(?:[57]1|98))(?:100\\d{2}|95\\d{3,4}|\\d{8})|(?:3(?:1[02-9]|35|49|5\\d|7[02-68]|9[1-68])|4(?:1[02-9]|2[179]|3[3-9]|5[2-9]|6[4789]|7\\d|8[23])|5(?:3[03-9]|4[36]|5[02-9]|6[1-46]|7[028]|80|9[2-46-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[17]\\d|2[248]|3[04-9]|4[3-6]|5[0-4689]|6[2368]|9[02-9])|8(?:078|1[236-8]|2[5-7]|3\\d|5[1-9]|7[02-9]|8[3678]|9[1-7])|9(?:0[1-3689]|1[1-79]|[379]\\d|4[13]|5[1-5]))(?:100\\d{2}|95\\d{3,4}|\\d{7})", null, null, null, "1012345678", null, null, null, [5, 6]], [null, null, "1(?:[38]\\d{3}|4[57]\\d{2}|5[0-35-9]\\d{2}|6[267]\\d{2}|7(?:[0-35-8]\\d{2}|40[0-5])|9[189]\\d{2})\\d{6}", null, null, null, "13123456789", null, null, [11]], [null, null, "(?:10)?800\\d{7}", null, null, null, "8001234567", null, null, [10, 12]], [null, null, "16[08]\\d{5}", null, null, null, "16812345", null, null, [8]], [null, null, "400\\d{7}|950\\d{7,8}|(?:10|2[0-57-9]|3(?:[157]\\d|35|49|9[1-68])|4(?:[17]\\d|2[179]|[35][1-9]|6[4789]|8[23])|5(?:[1357]\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\d|5[14-9]|8[3678]|9[1-8])|9(?:0[1-3689]|1[1-79]|[379]\\d|4[13]|5[1-5]))96\\d{3,4}", null, null, null, "4001234567", null, null, [7, 8, 9, 10, 11], [5, 6]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CN", 86, "(?:1(?:[12]\\d{3}|79\\d{2}|9[0-7]\\d{2}))?00", "0", null, null, "0|(1(?:[12]\\d{3}|79\\d{2}|9[0-7]\\d{2}))", null, "00", null, [[null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[48]00"]], [null, "(\\d{5,6})", "$1", ["100|95"]], [null, "(\\d{2})(\\d{5,6})", "$1 $2", ["(?:10|2\\d)[19]", "(?:10|2\\d)(?:10|9[56])", "(?:10|2\\d)(?:100|9[56])"], "0$1", "$CC $1"], [null, "(\\d{3})(\\d{5,6})", "$1 $2", ["[3-9]", "[3-9]\\d\\d[19]", "[3-9]\\d\\d(?:10|9[56])"], "0$1", "$CC $1"], [null, "(\\d{3,4})(\\d{4})", "$1 $2", ["[2-9]"]], [null, "(\\d{2})(\\d{4})(\\d{4,6})", "$1 $2 $3", ["21"], "0$1", "$CC $1", 1], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["10[1-9]|2[02-9]", "10[1-9]|2[02-9]", "10(?:[1-79]|8(?:0[1-9]|[1-9]))|2[02-9]"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["3(?:1[02-9]|35|49|5|7[02-68]|9[1-68])|4(?:1[02-9]|2[179]|[35][2-9]|6[47-9]|7|8[23])|5(?:3[03-9]|4[36]|5[02-9]|6[1-46]|7[028]|80|9[2-46-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]|2[248]|3[04-9]|4[3-6]|6[2368])|8(?:1[236-8]|2[5-7]|3|5[1-9]|7[02-9]|8[36-8]|9[1-7])|9(?:0[1-3689]|1[1-79]|[379]|4[13]|5[1-5])"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["3(?:11|7[179])|4(?:[15]1|3[1-35])|5(?:1|2[37]|3[12]|51|7[13-79]|9[15])|7(?:[39]1|5[457]|6[09])|8(?:[57]1|98)"], "0$1", "$CC $1", 1], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["807", "8078"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["1(?:[3-57-9]|6[267])"], null, "$CC $1"], [null, "(\\d{5})(\\d{3})(\\d{4})", "$1 $2 $3", ["108", "1080", "10800"]], [null, "(\\d{3})(\\d{7,8})", "$1 $2", ["950"]]], [[null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[48]00"]], [null, "(\\d{2})(\\d{5,6})", "$1 $2", ["(?:10|2\\d)[19]", "(?:10|2\\d)(?:10|9[56])", "(?:10|2\\d)(?:100|9[56])"], "0$1", "$CC $1"], [null, "(\\d{3})(\\d{5,6})", "$1 $2", ["[3-9]", "[3-9]\\d\\d[19]", "[3-9]\\d\\d(?:10|9[56])"], "0$1", "$CC $1"], [null, "(\\d{2})(\\d{4})(\\d{4,6})", "$1 $2 $3", ["21"], "0$1", "$CC $1", 1], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["10[1-9]|2[02-9]", "10[1-9]|2[02-9]", "10(?:[1-79]|8(?:0[1-9]|[1-9]))|2[02-9]"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["3(?:1[02-9]|35|49|5|7[02-68]|9[1-68])|4(?:1[02-9]|2[179]|[35][2-9]|6[47-9]|7|8[23])|5(?:3[03-9]|4[36]|5[02-9]|6[1-46]|7[028]|80|9[2-46-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]|2[248]|3[04-9]|4[3-6]|6[2368])|8(?:1[236-8]|2[5-7]|3|5[1-9]|7[02-9]|8[36-8]|9[1-7])|9(?:0[1-3689]|1[1-79]|[379]|4[13]|5[1-5])"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["3(?:11|7[179])|4(?:[15]1|3[1-35])|5(?:1|2[37]|3[12]|51|7[13-79]|9[15])|7(?:[39]1|5[457]|6[09])|8(?:[57]1|98)"], "0$1", "$CC $1", 1], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["807", "8078"], "0$1", "$CC $1", 1], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["1(?:[3-57-9]|6[267])"], null, "$CC $1"], [null, "(\\d{5})(\\d{3})(\\d{4})", "$1 $2 $3", ["108", "1080", "10800"]], [null, "(\\d{3})(\\d{7,8})", "$1 $2", ["950"]]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "(?:4|(?:10)?8)00\\d{7}|950\\d{7,8}", null, null, null, null, null, null, [10, 11, 12]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CO: [null, [null, null, "(?:1\\d|3)\\d{9}|[124-8]\\d{7}", null, null, null, null, null, null, [8, 10, 11], [7]], [null, null, "[124-8][2-9]\\d{6}", null, null, null, "12345678", null, null, [8], [7]], [null, null, "3(?:0[0-5]|1\\d|2[0-3]|5[01])\\d{7}", null, null, null, "3211234567", null, null, [10]], [null, null, "1800\\d{7}", null, null, null, "18001234567", null, null, [11]], [null, null, "19(?:0[01]|4[78])\\d{7}", null, null, null, "19001234567", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CO", 57, "00(?:4(?:[14]4|56)|[579])", "0", null, null, "0([3579]|4(?:[14]4|56))?", null, null, null, [[null, "(\\d)(\\d{7})", "$1 $2", ["1(?:[2-79]|8[2-9])|[24-8]"], "($1)", "0$CC $1"], [null, "(\\d{3})(\\d{7})", "$1 $2", ["3"], null, "0$CC $1"], [null, "(\\d)(\\d{3})(\\d{7})", "$1-$2-$3", ["1(?:80|9)", "1(?:800|9)"], "0$1"]], [[null, "(\\d)(\\d{7})", "$1 $2", ["1(?:[2-79]|8[2-9])|[24-8]"], "($1)", "0$CC $1"], [null, "(\\d{3})(\\d{7})", "$1 $2", ["3"], null, "0$CC $1"], [null, "(\\d)(\\d{3})(\\d{7})", "$1 $2 $3", ["1(?:80|9)", "1(?:800|9)"]]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CR: [null, [null, null, "(?:8\\d|90)\\d{8}|[24-8]\\d{7}", null, null, null, null, null, null, [8, 10]], [null, null, "2(?:[024-7]\\d\\d|1(?:0[7-9]|[1-9]\\d))\\d{4}", null, null, null, "22123456", null, null, [8]], [null, null, "(?:(?:5(?:0[01]|7[0-3])|(?:7[0-3]|8[3-9])\\d)\\d\\d|6(?:[0-4]\\d{3}|500[01]))\\d{3}", null, null, null, "83123456", null, null, [8]], [null, null, "800\\d{7}", null, null, null, "8001234567", null, null, [10]], [null, null, "90[059]\\d{7}", null, null, null, "9001234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:210[0-6]|4\\d{3}|5100)\\d{4}", null, null, null, "40001234", null, null, [8]], "CR", 506, "00", null, null, null, "(19(?:0[0-2468]|1[09]|20|66|77|99))", null, null, null, [[null, "(\\d{4})(\\d{4})", "$1 $2", ["[24-7]|8[3-9]"], null, "$CC $1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["[89]"], null, "$CC $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CU: [null, [null, null, "[2-57]\\d{7}|[2-47]\\d{6}|[34]\\d{5}", null, null, null, null, null, null, [6, 7, 8], [4, 5]], [null, null, "(?:2[1-4]|7\\d)\\d{5,6}|(?:3[1-3]|4[1-35-8])\\d{6}|3[23]\\d{4,5}|4[12578]\\d{5}|4[78]\\d{4}", null, null, null, "71234567", null, null, null, [4, 5]], [null, null, "5\\d{7}", null, null, null, "51234567", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CU", 53, "119", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{4,6})", "$1 $2", ["[2-4]"], "(0$1)"], [null, "(\\d)(\\d{6,7})", "$1 $2", ["7"], "(0$1)"], [null, "(\\d)(\\d{7})", "$1 $2", ["5"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CV: [null, [null, null, "[2-59]\\d{6}", null, null, null, null, null, null, [7]], [null, null, "2(?:2[1-7]|3[0-8]|4[12]|5[1256]|6\\d|7[1-3]|8[1-5])\\d{4}", null, null, null, "2211234"], [null, null, "(?:[34][36]|5[1-389]|9\\d)\\d{5}", null, null, null, "9911234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CV", 238, "0", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["[2-59]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CW: [null, [null, null, "(?:[34]1|60|(?:7|9\\d)\\d)\\d{5}", null, null, null, null, null, null, [7, 8]], [null, null, "9(?:(?:[48]\\d|50)\\d|7(?:2[0-24]|[34]\\d|6[35-7]|77|8[7-9]))\\d{4}", null, null, null, "94151234"], [null, null, "9(?:5(?:[12467]\\d|3[01])|6(?:[15-9]\\d|3[01]))\\d{4}", null, null, null, "95181234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "60[0-2]\\d{4}", null, null, null, "6001234", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "CW", 599, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[3467]"]], [null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["9[4-8]"]]], null, [null, null, "955\\d{5}", null, null, null, "95581234", null, null, [8]], 1, "[69]", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CX: [null, [null, null, "1\\d{5,9}|(?:[48]\\d\\d|550)\\d{6}", null, null, null, null, null, null, [6, 7, 8, 9, 10]], [null, null, "8(?:51(?:0(?:01|30|59)|117)|91(?:00[6-9]|1(?:[28]1|49|78)|2(?:09|63)|3(?:12|26|75)|4(?:56|97)|64\\d|7(?:0[01]|1[0-2])|958))\\d{3}", null, null, null, "891641234", null, null, [9], [8]], [null, null, "4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[6-9]|7[02-9]|8[0-2457-9]|9[017-9])\\d{6}", null, null, null, "412345678", null, null, [9]], [null, null, "180(?:0\\d{3}|2)\\d{3}", null, null, null, "1800123456", null, null, [7, 10]], [null, null, "190[0-26]\\d{6}", null, null, null, "1900123456", null, null, [10]], [null, null, "13(?:00\\d{3}|45[0-4])\\d{3}|13\\d{4}", null, null, null, "1300123456", null, null, [6, 8, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:14(?:5\\d|71)|550\\d)\\d{5}", null, null, null, "550123456", null, null, [9]], "CX", 61, "001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011", "0", null, null, "0|([59]\\d{7})$", "8$1", "0011", null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CY: [null, [null, null, "(?:[279]\\d|[58]0)\\d{6}", null, null, null, null, null, null, [8]], [null, null, "2[2-6]\\d{6}", null, null, null, "22345678"], [null, null, "9[4-79]\\d{6}", null, null, null, "96123456"], [null, null, "800\\d{5}", null, null, null, "80001234"], [null, null, "90[09]\\d{5}", null, null, null, "90012345"], [null, null, "80[1-9]\\d{5}", null, null, null, "80112345"], [null, null, "700\\d{5}", null, null, null, "70012345"], [null, null, null, null, null, null, null, null, null, [-1]], "CY", 357, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{6})", "$1 $2", ["[257-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:50|77)\\d{6}", null, null, null, "77123456"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    CZ: [null, [null, null, "(?:[2-578]\\d|60|9\\d{1,4})\\d{7}", null, null, null, null, null, null, [9, 10, 11, 12]], [null, null, "(?:2\\d|3[1257-9]|4[16-9]|5[13-9])\\d{7}", null, null, null, "212345678", null, null, [9]], [null, null, "(?:60[1-8]|7(?:0[2-5]|[2379]\\d))\\d{6}", null, null, null, "601123456", null, null, [9]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "9(?:0[05689]|76)\\d{6}", null, null, null, "900123456", null, null, [9]], [null, null, "8[134]\\d{7}", null, null, null, "811234567", null, null, [9]], [null, null, "70[01]\\d{6}", null, null, null, "700123456", null, null, [9]], [null, null, "9[17]0\\d{6}", null, null, null, "910123456", null, null, [9]], "CZ", 420, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[2-8]|9[015-7]"]], [null, "(\\d{2})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["9[36]"]], [null, "(\\d{3})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["96"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "9(?:5\\d|7[2-4])\\d{6}", null, null, null, "972123456", null, null, [9]], null, null, [null, null, "9(?:3\\d{9}|6\\d{7,10})", null, null, null, "93123456789"]],
    DE: [null, [null, null, "(?:1|[235-9]\\d{11}|4(?:[0-8]\\d{2,10}|9(?:[05]\\d{7}|[46][1-8]\\d{2,6})))\\d{3}|[1-35-9]\\d{6,13}|49(?:(?:[0-25]\\d|3[1-689])\\d{4,8}|4[1-8]\\d{4}|6[0-8]\\d{3,4}|7[1-7]\\d{5,8})|497[0-7]\\d{4}|49(?:[0-2579]\\d|[34][1-9])\\d{3}|[1-9]\\d{5}|[13468]\\d{4}", null, null, null, null, null, null, [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], [3]], [null, null, "(?:2(?:0[1-689]|[1-3569]\\d|4[0-8]|7[1-7]|8[0-7])|5(?:0[2-8]|[124-6]\\d|[38][0-8]|[79][0-7])|6(?:0[02-9]|[1-3589]\\d|[47][0-8]|6[1-9])|7(?:0[2-8]|1[1-9]|[27][0-7]|3\\d|[4-6][0-8]|8[0-5]|9[013-7])|8(?:0[2-9]|1[0-79]|[29]\\d|3[0-46-9]|4[0-6]|5[013-9]|6[1-8]|7[0-8]|8[0-24-6])|9(?:0[6-9]|[1-4]\\d|[589][0-7]|6[0-8]|7[0-467]))\\d{4,12}|3(?:(?:[03569]\\d|4[0-79]|7[1-7]|8[1-8])\\d{4,12}|2\\d{9})|4(?:(?:[02-48]\\d|1[02-9]|5[0-6]|6[0-8]|7[0-79])\\d{4,12}|9(?:[0-37]\\d{4,9}|[4-6]\\d{4,10}))|(?:2(?:0[1-389]|1[124]|2[18]|3[14]|[4-9]1)|3(?:0\\d?|[35-9][15]|4[015])|4(?:0\\d?|[2-9]1)|[57][1-9]1|[68](?:[1-8]1|9\\d?)|9(?:06|[1-9]1))\\d{3}", null, null, null, "30123456", null, null, [5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], [3, 4]], [null, null, "1(?:5[0-25-9]\\d{8}|(?:6[023]|7\\d)\\d{7,8})", null, null, null, "15123456789", null, null, [10, 11]], [null, null, "800\\d{7,12}", null, null, null, "8001234567890", null, null, [10, 11, 12, 13, 14, 15]], [null, null, "(?:137[7-9]|900(?:[135]|9\\d))\\d{6}", null, null, null, "9001234567", null, null, [10, 11]], [null, null, "1(?:3(?:7[1-6]\\d\\d|8)|80\\d{1,7})\\d{4}", null, null, null, "18012345", null, null, [7, 8, 9, 10, 11, 12, 13, 14]], [null, null, "700\\d{8}", null, null, null, "70012345678", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], "DE", 49, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3,13})", "$1 $2", ["3[02]|40|[68]9"], "0$1"], [null, "(\\d{3})(\\d{3,12})", "$1 $2", ["2(?:0[1-389]|1[124]|2[18]|3[14]|[4-9]1)|3(?:[35-9][15]|4[015])|(?:4[2-9]|[57][1-9]|[68][1-8])1|9(?:06|[1-9]1)", "2(?:0[1-389]|1(?:[14]|2[0-8])|2[18]|3[14]|[4-9]1)|3(?:[35-9][15]|4[015])|(?:4[2-9]|[57][1-9]|[68][1-8])1|9(?:06|[1-9]1)"], "0$1"], [null, "(\\d{3})(\\d{4})", "$1 $2", ["138"], "0$1"], [null, "(\\d{4})(\\d{3,11})", "$1 $2", ["[24-6]|3(?:[3569][02-46-9]|4[2-4679]|7[2-467]|8[2-46-8])|7(?:0[2-8]|[1-9])|8(?:0[2-9]|[1-8])|9(?:0[7-9]|[1-9])", "[24-6]|3(?:3(?:0[1-467]|2[127-9]|3[124578]|[46][1246]|7[1257-9]|8[1256]|9[145])|4(?:2[135]|3[1357]|4[13578]|6[1246]|7[1356]|9[1346])|5(?:0[14]|2[1-3589]|3[1357]|[49][1246]|6[1-4]|7[13468]|8[13568])|6(?:0[1356]|2[1-489]|3[124-6]|4[1347]|6[13]|7[12579]|8[1-356]|9[135])|7(?:2[1-7]|3[1357]|4[145]|6[1-5]|7[1-4])|8(?:21|3[1468]|4[1347]|6|7[1467]|8[136])|9(?:0[12479]|2[1358]|3[1357]|4[134679]|6[1-9]|7[136]|8[147]|9[1468]))|7(?:0[2-8]|[1-9])|8(?:0[2-9]|[1-8])|9(?:0[7-9]|[1-9])"], "0$1"], [null, "(\\d{3})(\\d{5,11})", "$1 $2", ["181"], "0$1"], [null, "(\\d{3})(\\d)(\\d{4,10})", "$1 $2 $3", ["1(?:3|80)|9"], "0$1"], [null, "(\\d{5})(\\d{3,10})", "$1 $2", ["3"], "0$1"], [null, "(\\d{3})(\\d{7,8})", "$1 $2", ["1(?:6[02-489]|7)"], "0$1"], [null, "(\\d{3})(\\d{7,12})", "$1 $2", ["8"], "0$1"], [null, "(\\d{4})(\\d{7})", "$1 $2", ["15[1279]"], "0$1"], [null, "(\\d{5})(\\d{6})", "$1 $2", ["15[0568]"], "0$1"], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["7"], "0$1"], [null, "(\\d{3})(\\d{8})", "$1 $2", ["18[2-579]", "18[2-579]", "18(?:[2-479]|5(?:0[1-9]|[1-9]))"], "0$1"], [null, "(\\d{4})(\\d{7})", "$1 $2", ["18[68]"], "0$1"], [null, "(\\d{5})(\\d{6})", "$1 $2", ["18"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{7,8})", "$1 $2 $3", ["1(?:6[023]|7)"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{8})", "$1 $2 $3", ["15[013-68]"], "0$1"], [null, "(\\d{4})(\\d{2})(\\d{7})", "$1 $2 $3", ["15"], "0$1"]], null, [null, null, "16(?:4\\d{1,10}|[89]\\d{1,11})", null, null, null, "16412345", null, null, [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "18(?:1\\d{5,11}|[2-9]\\d{8})", null, null, null, "18500123456", null, null, [8, 9, 10, 11, 12, 13, 14]], null, null, [null, null, "1(?:5(?:(?:[03-68]00|113)\\d|2\\d55|7\\d99|9\\d33)|(?:6(?:013|255|399)|7(?:(?:[015]1|[69]3)3|[2-4]55|[78]99))\\d?)\\d{7}", null, null, null, "177991234567", null, null, [12, 13]]],
    DJ: [null, [null, null, "(?:2\\d|77)\\d{6}", null, null, null, null, null, null, [8]], [null, null, "2(?:1[2-5]|7[45])\\d{5}", null, null, null, "21360003"], [null, null, "77\\d{6}", null, null, null, "77831001"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "DJ", 253, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[27]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    DK: [null, [null, null, "[2-9]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "(?:[2-7]\\d|8[126-9]|9[1-36-9])\\d{6}", null, null, null, "32123456"], [null, null, "(?:[2-7]\\d|8[126-9]|9[1-36-9])\\d{6}", null, null, null, "32123456"], [null, null, "80\\d{6}", null, null, null, "80123456"], [null, null, "90\\d{6}", null, null, null, "90123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "DK", 45, "00", null, null, null, null, null, null, 1, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    DM: [null, [null, null, "(?:[58]\\d\\d|767|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "767(?:2(?:55|66)|4(?:2[01]|4[0-25-9])|50[0-4]|70[1-3])\\d{4}", null, null, null, "7674201234", null, null, null, [7]], [null, null, "767(?:2(?:[2-4689]5|7[5-7])|31[5-7]|61[1-7])\\d{4}", null, null, null, "7672251234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "DM", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "767", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    DO: [null, [null, null, "(?:[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "8(?:[04]9[2-9]\\d\\d|29(?:2(?:[0-59]\\d|6[04-9]|7[0-27]|8[0237-9])|3(?:[0-35-9]\\d|4[7-9])|[45]\\d\\d|6(?:[0-27-9]\\d|[3-5][1-9]|6[0135-8])|7(?:0[013-9]|[1-37]\\d|4[1-35689]|5[1-4689]|6[1-57-9]|8[1-79]|9[1-8])|8(?:0[146-9]|1[0-48]|[248]\\d|3[1-79]|5[01589]|6[013-68]|7[124-8]|9[0-8])|9(?:[0-24]\\d|3[02-46-9]|5[0-79]|60|7[0169]|8[57-9]|9[02-9])))\\d{4}", null, null, null, "8092345678", null, null, null, [7]], [null, null, "8[024]9[2-9]\\d{6}", null, null, null, "8092345678", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "DO", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "8[024]9", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    DZ: [null, [null, null, "(?:[1-4]|[5-79]\\d|80)\\d{7}", null, null, null, null, null, null, [8, 9]], [null, null, "(?:(?:1\\d|2[013-79]|3[0-8]|4[0135689])\\d|9619)\\d{5}", null, null, null, "12345678"], [null, null, "(?:(?:5[4-6]|7[7-9])\\d|6(?:[569]\\d|7[0-6]))\\d{6}", null, null, null, "551234567", null, null, [9]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "80[3-689]1\\d{5}", null, null, null, "808123456", null, null, [9]], [null, null, "80[12]1\\d{5}", null, null, null, "801123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "98[23]\\d{6}", null, null, null, "983123456", null, null, [9]], "DZ", 213, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[1-4]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[5-8]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["9"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    EC: [null, [null, null, "1800\\d{6,7}|(?:[2-7]|9\\d)\\d{7}", null, null, null, null, null, null, [8, 9, 10, 11], [7]], [null, null, "[2-7][2-7]\\d{6}", null, null, null, "22123456", null, null, [8], [7]], [null, null, "9(?:(?:39|[57][89]|[89]\\d)\\d|6(?:[0-27-9]\\d|30))\\d{5}", null, null, null, "991234567", null, null, [9]], [null, null, "1800\\d{6,7}", null, null, null, "18001234567", null, null, [10, 11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "[2-7]890\\d{4}", null, null, null, "28901234", null, null, [8]], "EC", 593, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{4})", "$1-$2", ["[2-7]"]], [null, "(\\d)(\\d{3})(\\d{4})", "$1 $2-$3", ["[2-7]"], "(0$1)"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["9"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["1"]]], [[null, "(\\d)(\\d{3})(\\d{4})", "$1-$2-$3", ["[2-7]"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["9"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["1"]]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    EE: [null, [null, null, "8\\d{9}|[4578]\\d{7}|(?:[3-8]\\d\\d|900)\\d{4}", null, null, null, null, null, null, [7, 8, 10]], [null, null, "(?:3[23589]|4[3-8]|6\\d|7[1-9]|88)\\d{5}", null, null, null, "3212345", null, null, [7]], [null, null, "(?:5\\d|8[1-4])\\d{6}|5(?:(?:[02]\\d|5[0-478])\\d|1(?:[0-8]\\d|95)|6(?:4[0-4]|5[1-589]))\\d{3}", null, null, null, "51234567", null, null, [7, 8]], [null, null, "800(?:(?:0\\d\\d|1)\\d|[2-9])\\d{3}", null, null, null, "80012345"], [null, null, "(?:40\\d\\d|900)\\d{4}", null, null, null, "9001234", null, null, [7, 8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70[0-2]\\d{5}", null, null, null, "70012345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], "EE", 372, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[369]|4[3-8]|5(?:[0-2]|5[0-478]|6[45])|7[1-9]", "[369]|4[3-8]|5(?:[02]|1(?:[0-8]|95)|5[0-478]|6(?:4[0-4]|5[1-589]))|7[1-9]"]], [null, "(\\d{4})(\\d{3,4})", "$1 $2", ["[45]|8(?:00|[1-4])", "[45]|8(?:00[1-9]|[1-4])"]], [null, "(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3", ["7"]], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["80"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "800[2-9]\\d{3}", null, null, null, null, null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    EG: [null, [null, null, "(?:[189]\\d?|[24-6])\\d{8}|[13]\\d{7}", null, null, null, null, null, null, [8, 9, 10], [6, 7]], [null, null, "(?:1(?:3[23]|5\\d?)|(?:2[2-4]|3)\\d|4(?:0[2-5]|[578][23]|64)|5(?:0[2-7]|5\\d|7[23])|6[24-689]3|8(?:2[2-57]|4[26]|6[237]|8[2-4])|9(?:2[27]|3[24]|52|6[2356]|7[2-4]))\\d{6}", null, null, null, "234567890", null, null, [8, 9], [6, 7]], [null, null, "1[0-25]\\d{8}", null, null, null, "1001234567", null, null, [10]], [null, null, "800\\d{7}", null, null, null, "8001234567", null, null, [10]], [null, null, "900\\d{7}", null, null, null, "9001234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "EG", 20, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{7,8})", "$1 $2", ["[23]"], "0$1"], [null, "(\\d{2})(\\d{6,7})", "$1 $2", ["1[35]|[4-6]|8[2468]|9[235-7]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[189]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    EH: [null, [null, null, "[5-8]\\d{8}", null, null, null, null, null, null, [9]], [null, null, "528[89]\\d{5}", null, null, null, "528812345"], [null, null, "(?:6(?:[0-79]\\d|8[0-247-9])|7(?:0[067]|6[1267]|7[017]))\\d{6}", null, null, null, "650123456"], [null, null, "80\\d{7}", null, null, null, "801234567"], [null, null, "89\\d{7}", null, null, null, "891234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5924[01]\\d{4}", null, null, null, "592401234"], "EH", 212, "00", "0", null, null, "0", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "528[89]", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    ER: [null, [null, null, "[178]\\d{6}", null, null, null, null, null, null, [7], [6]], [null, null, "(?:1(?:1[12568]|[24]0|55|6[146])|8\\d\\d)\\d{4}", null, null, null, "8370362", null, null, null, [6]], [null, null, "(?:17[1-3]|7\\d\\d)\\d{4}", null, null, null, "7123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "ER", 291, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[178]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    ES: [null, [null, null, "(?:51|[6-9]\\d)\\d{7}", null, null, null, null, null, null, [9]], [null, null, "(?:8(?:[1356]\\d|[28][0-8]|[47][1-9])\\d{4}|9(?:(?:(?:[135]\\d|[28][0-8]|4[1-9])\\d\\d|7(?:[124-9]\\d\\d|3(?:[0-8]\\d|9[1-9])))\\d\\d|6(?:[0-8]\\d{4}|9(?:0(?:[0-57-9]\\d\\d|6(?:0[0-8]|1[1-9]|[2-9]\\d))|[1-9]\\d{3}))))\\d\\d", null, null, null, "810123456"], [null, null, "(?:(?:6\\d|7[1-48])\\d{5}|9(?:6906(?:09|10)|7390\\d\\d))\\d\\d", null, null, null, "612345678"], [null, null, "[89]00\\d{6}", null, null, null, "800123456"], [null, null, "80[367]\\d{6}", null, null, null, "803123456"], [null, null, "90[12]\\d{6}", null, null, null, "901123456"], [null, null, "70\\d{7}", null, null, null, "701234567"], [null, null, null, null, null, null, null, null, null, [-1]], "ES", 34, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[89]00"]], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[568]|7[0-48]|9(?:0[12]|[1-8])"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "51\\d{7}", null, null, null, "511234567"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    ET: [null, [null, null, "(?:11|[2-59]\\d)\\d{7}", null, null, null, null, null, null, [9], [7]], [null, null, "(?:11(?:1(?:1[124]|2[2-57]|3[1-5]|5[5-8]|8[6-8])|2(?:13|3[6-8]|5[89]|7[05-9]|8[2-6])|3(?:2[01]|3[0-289]|4[1289]|7[1-4]|87)|4(?:1[69]|3[2-49]|4[0-3]|6[5-8])|5(?:1[578]|44|5[0-4])|6(?:18|2[69]|39|4[5-7]|5[1-5]|6[0-59]|8[015-8]))|2(?:2(?:11[1-9]|22[0-7]|33\\d|44[1467]|66[1-68])|5(?:11[124-6]|33[2-8]|44[1467]|55[14]|66[1-3679]|77[124-79]|880))|3(?:3(?:11[0-46-8]|(?:22|55)[0-6]|33[0134689]|44[04]|66[01467])|4(?:44[0-8]|55[0-69]|66[0-3]|77[1-5]))|4(?:6(?:22[0-24-7]|33[1-5]|44[13-69]|55[14-689]|660|88[1-4])|7(?:(?:11|22)[1-9]|33[13-7]|44[13-6]|55[1-689]))|5(?:7(?:227|55[05]|(?:66|77)[14-8])|8(?:11[149]|22[013-79]|33[0-68]|44[013-8]|550|66[1-5]|77\\d)))\\d{4}", null, null, null, "111112345", null, null, null, [7]], [null, null, "9\\d{8}", null, null, null, "911234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "ET", 251, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[1-59]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FI: [null, [null, null, "(?:[124-7]\\d|3[0-46-9])\\d{8}|[1-9]\\d{5,8}|[1-35689]\\d{4}", null, null, null, null, null, null, [5, 6, 7, 8, 9, 10]], [null, null, "(?:1[3-79][1-8]|[235689][1-8]\\d)\\d{2,6}", null, null, null, "131234567", null, null, [5, 6, 7, 8, 9]], [null, null, "(?:4[0-8]|50)\\d{4,8}", null, null, null, "412345678", null, null, [6, 7, 8, 9, 10]], [null, null, "800\\d{4,6}", null, null, null, "800123456", null, null, [7, 8, 9]], [null, null, "[67]00\\d{5,6}", null, null, null, "600123456", null, null, [8, 9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "FI", 358, "00|99(?:[01469]|5(?:[14]1|3[23]|5[59]|77|88|9[09]))", "0", null, null, "0", null, "00", null, [[null, "(\\d{5})", "$1", ["7"], "0$1"], [null, "(\\d)(\\d{4,9})", "$1 $2", ["[2568][1-8]|3(?:0[1-9]|[1-9])|9"], "0$1"], [null, "(\\d{2})(\\d{4,8})", "$1 $2", ["1(?:0[1-9]|[3-79][1-8]|8)|2(?:0[1-9]|9)|[45]|7[135]"], "0$1"], [null, "(\\d{3})(\\d{3,7})", "$1 $2", ["(?:1|20)0|[36-8]"], "0$1"]], [[null, "(\\d)(\\d{4,9})", "$1 $2", ["[2568][1-8]|3(?:0[1-9]|[1-9])|9"], "0$1"], [null, "(\\d{2})(\\d{4,8})", "$1 $2", ["1(?:0[1-9]|[3-79][1-8]|8)|2(?:0[1-9]|9)|[45]|7[135]"], "0$1"], [null, "(\\d{3})(\\d{3,7})", "$1 $2", ["(?:1|20)0|[36-8]"], "0$1"]], [null, null, null, null, null, null, null, null, null, [-1]], 1, "1[03-79]|[2-9]", [null, null, "[13]00\\d{3,7}|20(?:0\\d{3,7}|(?:2[023]|9[89])\\d{1,6})|60(?:[12]\\d{5,6}|6\\d{7})|7(?:(?:1|3\\d)\\d{7}|5[03-9]\\d{3,7})"], [null, null, "(?:10|[23][09])\\d{4,8}|60(?:[12]\\d{5,6}|6\\d{7})|7(?:(?:1|3\\d)\\d{7}|5[03-9]\\d{3,7})|20[2-59]\\d\\d", null, null, null, "10112345"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FJ: [null, [null, null, "(?:(?:0800\\d|[235-9])\\d|45)\\d{5}", null, null, null, null, null, null, [7, 11]], [null, null, "(?:(?:3[0-5]|8[58])\\d|6(?:03|[25-7]\\d))\\d{4}", null, null, null, "3212345", null, null, [7]], [null, null, "(?:[279]\\d|45|5[01568]|8[034679])\\d{5}", null, null, null, "7012345", null, null, [7]], [null, null, "0800\\d{7}", null, null, null, "08001234567", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "FJ", 679, "0(?:0|52)", null, null, null, null, null, "00", null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[235-9]|45"]], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["0"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FK: [null, [null, null, "[2-7]\\d{4}", null, null, null, null, null, null, [5]], [null, null, "[2-47]\\d{4}", null, null, null, "31234"], [null, null, "[56]\\d{4}", null, null, null, "51234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "FK", 500, "00", null, null, null, null, null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FM: [null, [null, null, "[39]\\d{6}", null, null, null, null, null, null, [7]], [null, null, "(?:3[2357]0[1-9]|9[2-6]\\d\\d)\\d{3}", null, null, null, "3201234"], [null, null, "(?:3[2357]0[1-9]|9[2-7]\\d\\d)\\d{3}", null, null, null, "3501234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "FM", 691, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["3(?:20|[357])|9", "3(?:20[1-9]|[357])|9"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FO: [null, [null, null, "(?:[2-8]\\d|90)\\d{4}", null, null, null, null, null, null, [6]], [null, null, "(?:20|[34]\\d|8[19])\\d{4}", null, null, null, "201234"], [null, null, "(?:[27][1-9]|5\\d)\\d{4}", null, null, null, "211234"], [null, null, "80[257-9]\\d{3}", null, null, null, "802123"], [null, null, "90(?:[13-5][15-7]|2[125-7]|99)\\d\\d", null, null, null, "901123"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:6[0-36]|88)\\d{4}", null, null, null, "601234"], "FO", 298, "00", null, null, null, "(10(?:01|[12]0|88))", null, null, null, [[null, "(\\d{6})", "$1", ["[2-9]"], null, "$CC $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    FR: [null, [null, null, "[1-9]\\d{8}", null, null, null, null, null, null, [9]], [null, null, "[1-5]\\d{8}", null, null, null, "123456789"], [null, null, "(?:6\\d\\d|7(?:00|[3-9]\\d))\\d{6}", null, null, null, "612345678"], [null, null, "80[0-5]\\d{6}", null, null, null, "801234567"], [null, null, "8[129]\\d{7}", null, null, null, "891123456"], [null, null, "884\\d{6}", null, null, null, "884012345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "9\\d{8}", null, null, null, "912345678"], "FR", 33, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3})", "$1 $2", ["11"]], [null, "(\\d)(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["[1-79]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"], "0 $1"]], [[null, "(\\d)(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["[1-79]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"], "0 $1"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "80[6-9]\\d{6}", null, null, null, "806123456"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GA: [null, [null, null, "(?:0\\d|[2-7])\\d{6}", null, null, null, null, null, null, [7, 8]], [null, null, "01\\d{6}", null, null, null, "01441234", null, null, [8]], [null, null, "(?:0[2-7]|[2-7])\\d{6}", null, null, null, "06031234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GA", 241, "00", null, null, null, null, null, null, null, [[null, "(\\d)(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-7]"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["0"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GB: [null, [null, null, "[1-357-9]\\d{9}|[18]\\d{8}|8\\d{6}", null, null, null, null, null, null, [7, 9, 10], [4, 5, 6, 8]], [null, null, "(?:1(?:1(?:3[0-58]|4[0-5]|5[0-26-9]|6[0-4]|[78][0-49])|2(?:0[024-9]|1[0-7]|2[3-9]|3[3-79]|4[1-689]|[58][02-9]|6[0-47-9]|7[013-9]|9\\d)|3(?:0\\d|1[0-8]|[25][02-9]|3[02-579]|[468][0-46-9]|7[1-35-79]|9[2-578])|4(?:0[03-9]|[137]\\d|[28][02-57-9]|4[02-69]|5[0-8]|[69][0-79])|5(?:0[1-35-9]|[16]\\d|2[024-9]|3[015689]|4[02-9]|5[03-9]|7[0-35-9]|8[0-468]|9[0-57-9])|6(?:0[034689]|1\\d|2[0-35689]|[38][013-9]|4[1-467]|5[0-69]|6[13-9]|7[0-8]|9[0-24578])|7(?:0[0246-9]|2\\d|3[0236-8]|4[03-9]|5[0-46-9]|6[013-9]|7[0-35-9]|8[024-9]|9[02-9])|8(?:0[35-9]|2[1-57-9]|3[02-578]|4[0-578]|5[124-9]|6[2-69]|7\\d|8[02-9]|9[02569])|9(?:0[02-589]|[18]\\d|2[02-689]|3[1-57-9]|4[2-9]|5[0-579]|6[2-47-9]|7[0-24578]|9[2-57]))|2(?:0[01378]|3[0189]|4[017]|8[0-46-9]|9[0-2])\\d)\\d{6}|1(?:(?:2(?:0(?:46[1-4]|87[2-9])|545[1-79]|76(?:2\\d|3[1-8]|6[1-6])|9(?:7(?:2[0-4]|3[2-5])|8(?:2[2-8]|7[0-47-9]|8[3-5])))|3(?:6(?:38[2-5]|47[23])|8(?:47[04-9]|64[0157-9]))|4(?:044[1-7]|20(?:2[23]|8\\d)|6(?:0(?:30|5[2-57]|6[1-8]|7[2-8])|140)|8(?:052|87[1-3]))|5(?:2(?:4(?:3[2-79]|6\\d)|76\\d)|6(?:26[06-9]|686))|6(?:06(?:4\\d|7[4-79])|295[5-7]|35[34]\\d|47(?:24|61)|59(?:5[08]|6[67]|74)|9(?:55[0-4]|77[23]))|8(?:27[56]\\d|37(?:5[2-5]|8[239])|843[2-58])|9(?:0(?:0(?:6[1-8]|85)|52\\d)|3583|4(?:66[1-8]|9(?:2[01]|81))|63(?:23|3[1-4])|9561))\\d|7(?:(?:26(?:6[13-9]|7[0-7])|442\\d|50(?:2[0-3]|[3-68]2|76))\\d|6888[2-46-8]))\\d\\d", null, null, null, "1212345678", null, null, [9, 10], [4, 5, 6, 7, 8]], [null, null, "7(?:(?:[1-3]\\d\\d|5(?:0[0-8]|[13-9]\\d|2[0-35-9])|8(?:[014-9]\\d|[23][0-8]))\\d|4(?:[0-46-9]\\d\\d|5(?:[0-689]\\d|7[0-57-9]))|7(?:0(?:0[01]|[1-9]\\d)|(?:[1-7]\\d|8[02-9]|9[0-689])\\d)|9(?:(?:[024-9]\\d|3[0-689])\\d|1(?:[02-9]\\d|1[028])))\\d{5}", null, null, null, "7400123456", null, null, [10]], [null, null, "80[08]\\d{7}|800\\d{6}|8001111", null, null, null, "8001234567"], [null, null, "(?:8(?:4[2-5]|7[0-3])|9(?:[01]\\d|8[2-49]))\\d{7}|845464\\d", null, null, null, "9012345678", null, null, [7, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70\\d{8}", null, null, null, "7012345678", null, null, [10]], [null, null, "56\\d{8}", null, null, null, "5612345678", null, null, [10]], "GB", 44, "00", "0", " x", null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["845", "8454", "84546", "845464"], "0$1"], [null, "(\\d{3})(\\d{4})", "$1 $2", ["800", "8001", "80011", "800111", "8001111"], "0$1"], [null, "(\\d{3})(\\d{6})", "$1 $2", ["800"], "0$1"], [null, "(\\d{4})(\\d{5,6})", "$1 $2", ["1(?:[2-79][02-9]|8)", "1(?:[24][02-9]|3(?:[02-79]|8[0-46-9])|5(?:[04-9]|2[024-9]|3[014-689])|6(?:[02-8]|9[0-24578])|7(?:[02-57-9]|6[013-9])|8|9(?:[0235-9]|4[2-9]))", "1(?:[24][02-9]|3(?:[02-79]|8(?:[0-4689]|7[0-24-9]))|5(?:[04-9]|2(?:[025-9]|4[013-9])|3(?:[014-68]|9[0-37-9]))|6(?:[02-8]|9(?:[0-2458]|7[0-25689]))|7(?:[02-57-9]|6(?:[013-79]|8[0-25689]))|8|9(?:[0235-9]|4(?:[2-57-9]|6[0-689])))"], "0$1"], [null, "(\\d{5})(\\d{4,5})", "$1 $2", ["1(?:38|5[23]|69|7|94)"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["[25]|7(?:0|6[024-9])", "[25]|7(?:0|6(?:[04-9]|2[356]))"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[1389]"], "0$1"], [null, "(\\d{4})(\\d{6})", "$1 $2", ["7"], "0$1"]], null, [null, null, "76(?:0[0-2]|2[356]|4[0134]|5[49]|6[0-369]|77|81|9[39])\\d{6}", null, null, null, "7640123456", null, null, [10]], 1, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:3[0347]|55)\\d{8}", null, null, null, "5512345678", null, null, [10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GD: [null, [null, null, "(?:473|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "473(?:2(?:3[0-2]|69)|3(?:2[89]|86)|4(?:[06]8|3[5-9]|4[0-49]|5[5-79]|73|90)|63[68]|7(?:58|84)|800|938)\\d{4}", null, null, null, "4732691234", null, null, null, [7]], [null, null, "473(?:4(?:0[2-79]|1[04-9]|2[0-5]|58)|5(?:2[01]|3[3-8])|901)\\d{4}", null, null, null, "4734031234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "GD", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "473", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GE: [null, [null, null, "(?:[3-57]\\d\\d|800)\\d{6}", null, null, null, null, null, null, [9], [6]], [null, null, "(?:3(?:[256]\\d|4[124-9]|7[0-4])|4(?:1\\d|2[2-7]|3[1-79]|4[2-8]|7[239]|9[1-7]))\\d{6}", null, null, null, "322123456", null, null, null, [6]], [null, null, "(?:5(?:[14]4|5[0157-9]|68|7[0147-9]|9[1-35-9])|790)\\d{6}", null, null, null, "555123456"], [null, null, "800\\d{6}", null, null, null, "800123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "706\\d{6}", null, null, null, "706123456"], "GE", 995, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[348]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["5|79"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["7"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "706\\d{6}"], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GF: [null, [null, null, "[56]94\\d{6}", null, null, null, null, null, null, [9]], [null, null, "594(?:[023]\\d|1[01]|4[03-9]|5[6-9]|6[0-3]|80|9[014])\\d{4}", null, null, null, "594101234"], [null, null, "694(?:[0-249]\\d|3[0-48])\\d{4}", null, null, null, "694201234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GF", 594, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[56]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GG: [null, [null, null, "(?:1481|[357-9]\\d{3})\\d{6}|8\\d{6}(?:\\d{2})?", null, null, null, null, null, null, [7, 9, 10], [6]], [null, null, "1481[25-9]\\d{5}", null, null, null, "1481256789", null, null, [10], [6]], [null, null, "7(?:(?:781|839)\\d|911[17])\\d{5}", null, null, null, "7781123456", null, null, [10]], [null, null, "80[08]\\d{7}|800\\d{6}|8001111", null, null, null, "8001234567"], [null, null, "(?:8(?:4[2-5]|7[0-3])|9(?:[01]\\d|8[0-3]))\\d{7}|845464\\d", null, null, null, "9012345678", null, null, [7, 10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70\\d{8}", null, null, null, "7012345678", null, null, [10]], [null, null, "56\\d{8}", null, null, null, "5612345678", null, null, [10]], "GG", 44, "00", "0", null, null, "0|([25-9]\\d{5})$", "1481$1", null, null, null, null, [null, null, "76(?:0[0-2]|2[356]|4[0134]|5[49]|6[0-369]|77|81|9[39])\\d{6}", null, null, null, "7640123456", null, null, [10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:3[0347]|55)\\d{8}", null, null, null, "5512345678", null, null, [10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GH: [null, [null, null, "(?:[235]\\d{3}|800)\\d{5}", null, null, null, null, null, null, [8, 9], [7]], [null, null, "3(?:0(?:[237]\\d|80)|[167](?:2[0-6]|7\\d|80)|2(?:2[0-5]|7\\d|80)|3(?:2[0-3]|7\\d|80)|4(?:2[013-9]|3[01]|7\\d|80)|5(?:2[0-7]|7\\d|80)|8(?:2[0-2]|7\\d|80)|9(?:[28]0|7\\d))\\d{5}", null, null, null, "302345678", null, null, [9], [7]], [null, null, "(?:2[0346-8]\\d|5(?:[0457]\\d|6[01]))\\d{6}", null, null, null, "231234567", null, null, [9]], [null, null, "800\\d{5}", null, null, null, "80012345", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GH", 233, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[237]|80"]], [null, "(\\d{3})(\\d{5})", "$1 $2", ["8"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[235]"], "0$1"]], [[null, "(\\d{3})(\\d{5})", "$1 $2", ["8"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[235]"], "0$1"]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "800\\d{5}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GI: [null, [null, null, "(?:[25]\\d\\d|629)\\d{5}", null, null, null, null, null, null, [8]], [null, null, "2(?:(?:00\\d|2(?:2[2457]|50))\\d|1(?:6[24-7]\\d|90[0-2]))\\d{3}", null, null, null, "20012345"], [null, null, "(?:5[46-8]\\d|629)\\d{5}", null, null, null, "57123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GI", 350, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{5})", "$1 $2", ["2"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GL: [null, [null, null, "(?:19|[2-689]\\d)\\d{4}", null, null, null, null, null, null, [6]], [null, null, "(?:19|3[1-7]|6[14689]|8[14-79]|9\\d)\\d{4}", null, null, null, "321000"], [null, null, "(?:[25][1-9]|4[2-9])\\d{4}", null, null, null, "221234"], [null, null, "80\\d{4}", null, null, null, "801234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "3[89]\\d{4}", null, null, null, "381234"], "GL", 299, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["19|[2-689]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GM: [null, [null, null, "[2-9]\\d{6}", null, null, null, null, null, null, [7]], [null, null, "(?:4(?:[23]\\d\\d|4(?:1[024679]|[6-9]\\d))|5(?:54[0-7]|6[67]\\d|7(?:1[04]|2[035]|3[58]|48))|8\\d{3})\\d{3}", null, null, null, "5661234"], [null, null, "[23679]\\d{6}", null, null, null, "3012345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GM", 220, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GN: [null, [null, null, "(?:30|6\\d\\d|722)\\d{6}", null, null, null, null, null, null, [8, 9]], [null, null, "30(?:24|3[12]|4[1-35-7]|5[13]|6[189]|[78]1|9[1478])\\d{4}", null, null, null, "30241234", null, null, [8]], [null, null, "6[02356]\\d{7}", null, null, null, "601123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "722\\d{6}", null, null, null, "722123456", null, null, [9]], "GN", 224, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["3"]], [null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[67]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GP: [null, [null, null, "(?:590|69\\d)\\d{6}", null, null, null, null, null, null, [9]], [null, null, "590(?:0[1-68]|1[0-2]|2[0-68]|3[1289]|4[0-24-9]|5[3-579]|6[0189]|7[08]|8[0-689]|9\\d)\\d{4}", null, null, null, "590201234"], [null, null, "69(?:0\\d\\d|1(?:2[29]|3[0-5]))\\d{4}", null, null, null, "690001234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GP", 590, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[56]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], 1, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GQ: [null, [null, null, "(?:222|(?:3\\d|55|[89]0)\\d)\\d{6}", null, null, null, null, null, null, [9]], [null, null, "3(?:3(?:[0-24-9]\\d[46]|3\\d[7-9])|5\\d\\d[7-9])\\d{4}", null, null, null, "333091234"], [null, null, "(?:222|55[015])\\d{6}", null, null, null, "222123456"], [null, null, "80\\d[1-9]\\d{5}", null, null, null, "800123456"], [null, null, "90\\d[1-9]\\d{5}", null, null, null, "900123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GQ", 240, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[235]"]], [null, "(\\d{3})(\\d{6})", "$1 $2", ["[89]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GR: [null, [null, null, "(?:[268]\\d|[79]0)\\d{8}", null, null, null, null, null, null, [10]], [null, null, "2(?:1\\d\\d|2(?:2[1-46-9]|[36][1-8]|4[1-7]|5[1-4]|7[1-5]|[89][1-9])|3(?:1\\d|2[1-57]|[35][1-3]|4[13]|7[1-7]|8[124-6]|9[1-79])|4(?:1\\d|2[1-8]|3[1-4]|4[13-5]|6[1-578]|9[1-5])|5(?:1\\d|[29][1-4]|3[1-5]|4[124]|5[1-6])|6(?:1\\d|[269][1-6]|3[1245]|4[1-7]|5[13-9]|7[14]|8[1-5])|7(?:1\\d|2[1-5]|3[1-6]|4[1-7]|5[1-57]|6[135]|9[125-7])|8(?:1\\d|2[1-5]|[34][1-4]|9[1-57]))\\d{6}", null, null, null, "2123456789"], [null, null, "6(?:8[57-9]|9\\d)\\d{7}", null, null, null, "6912345678"], [null, null, "800\\d{7}", null, null, null, "8001234567"], [null, null, "90[19]\\d{7}", null, null, null, "9091234567"], [null, null, "8(?:0[16]|12|25)\\d{7}", null, null, null, "8011234567"], [null, null, "70\\d{8}", null, null, null, "7012345678"], [null, null, null, null, null, null, null, null, null, [-1]], "GR", 30, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["21|7"]], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["2[3-8]1|[689]"]], [null, "(\\d{4})(\\d{6})", "$1 $2", ["2"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GT: [null, [null, null, "(?:1\\d{3}|[2-7])\\d{7}", null, null, null, null, null, null, [8, 11]], [null, null, "[267][2-9]\\d{6}", null, null, null, "22456789", null, null, [8]], [null, null, "[3-5]\\d{7}", null, null, null, "51234567", null, null, [8]], [null, null, "18[01]\\d{8}", null, null, null, "18001112222", null, null, [11]], [null, null, "19\\d{9}", null, null, null, "19001112222", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GT", 502, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{4})", "$1 $2", ["[2-7]"]], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GU: [null, [null, null, "(?:[58]\\d\\d|671|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "671(?:3(?:00|3[39]|4[349]|55|6[26])|4(?:00|56|7[1-9]|8[0236-9])|5(?:55|6[2-5]|88)|6(?:3[2-578]|4[24-9]|5[34]|78|8[235-9])|7(?:[0479]7|2[0167]|3[45]|8[7-9])|8(?:[2-57-9]8|6[48])|9(?:2[29]|6[79]|7[1279]|8[7-9]|9[78]))\\d{4}", null, null, null, "6713001234", null, null, null, [7]], [null, null, "671(?:3(?:00|3[39]|4[349]|55|6[26])|4(?:00|56|7[1-9]|8[0236-9])|5(?:55|6[2-5]|88)|6(?:3[2-578]|4[24-9]|5[34]|78|8[235-9])|7(?:[0479]7|2[0167]|3[45]|8[7-9])|8(?:[2-57-9]8|6[48])|9(?:2[29]|6[79]|7[1279]|8[7-9]|9[78]))\\d{4}", null, null, null, "6713001234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "GU", 1, "011", "1", null, null, "1", null, null, 1, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "671", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GW: [null, [null, null, "[49]\\d{8}|4\\d{6}", null, null, null, null, null, null, [7, 9]], [null, null, "443\\d{6}", null, null, null, "443201234", null, null, [9]], [null, null, "9(?:5\\d|6[569]|77)\\d{6}", null, null, null, "955012345", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "40\\d{5}", null, null, null, "4012345", null, null, [7]], "GW", 245, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["40"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[49]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    GY: [null, [null, null, "(?:(?:(?:[2-46]\\d|77)\\d|862)\\d|9008)\\d{3}", null, null, null, null, null, null, [7]], [null, null, "(?:2(?:1[6-9]|2[0-35-9]|3[1-4]|5[3-9]|6\\d|7[0-24-79])|3(?:2[25-9]|3\\d)|4(?:4[0-24]|5[56])|77[1-57])\\d{4}", null, null, null, "2201234"], [null, null, "6\\d{6}", null, null, null, "6091234"], [null, null, "(?:289|862)\\d{4}", null, null, null, "2891234"], [null, null, "9008\\d{3}", null, null, null, "9008123"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "GY", 592, "001", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[2-46-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    HK: [null, [null, null, "8[0-46-9]\\d{6,7}|9\\d{4}(?:\\d(?:\\d(?:\\d{4})?)?)?|(?:[235-79]\\d|46)\\d{6}", null, null, null, null, null, null, [5, 6, 7, 8, 9, 11]], [null, null, "(?:2(?:[13-8]\\d|2[013-9]|9[0-24-9])\\d|3(?:(?:[1569][0-24-9]|4[0-246-9]|7[0-24-69])\\d|8(?:4[04]|9\\d))|58(?:0[1-8]|1[2-9]))\\d{4}", null, null, null, "21234567", null, null, [8]], [null, null, "(?:46(?:0[0-6]|10|4[0-57-9])|5(?:(?:[1-59][0-46-9]|6[0-4689])\\d|7(?:[0-2469]\\d|30))|6(?:(?:0[1-9]|[13-59]\\d|[68][0-57-9]|7[0-79])\\d|2(?:[0-57-9]\\d|6[01]))|707[1-5]|8480|9(?:(?:0[1-9]|1[02-9]|[358][0-8]|[467]\\d)\\d|2(?:[0-8]\\d|9[03-9])))\\d{4}", null, null, null, "51234567", null, null, [8]], [null, null, "800\\d{6}", null, null, null, "800123456", null, null, [9]], [null, null, "900(?:[0-24-9]\\d{7}|3\\d{1,4})", null, null, null, "90012345678", null, null, [5, 6, 7, 8, 11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "8(?:1[0-4679]\\d|2(?:[0-36]\\d|7[0-4])|3(?:[034]\\d|2[09]|70))\\d{4}", null, null, null, "81123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], "HK", 852, "00(?:30|5[09]|[126-9]?)", null, null, null, null, null, "00", null, [[null, "(\\d{3})(\\d{2,5})", "$1 $2", ["900", "9003"]], [null, "(\\d{4})(\\d{4})", "$1 $2", ["[2-7]|8[1-4]|9(?:0[1-9]|[1-8])"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"]], [null, "(\\d{3})(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["9"]]], null, [null, null, "7(?:1(?:0[0-38]|1[0-3679]|3[013]|69|9[136])|2(?:[02389]\\d|1[18]|7[27-9])|3(?:[0-38]\\d|7[0-369]|9[2357-9])|47\\d|5(?:[178]\\d|5[0-5])|6(?:0[0-7]|2[236-9]|[35]\\d)|7(?:[27]\\d|8[7-9])|8(?:[23689]\\d|7[1-9])|9(?:[025]\\d|6[0-246-8]|7[0-36-9]|8[238]))\\d{4}", null, null, null, "71123456", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "30(?:0[1-9]|[15-7]\\d|2[047]|89)\\d{4}", null, null, null, "30161234", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    HN: [null, [null, null, "[237-9]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "2(?:2(?:0[019]|1[1-36]|[23]\\d|4[04-6]|5[57]|64|7[0135689]|8[01346-9]|9[0-2])|4(?:07|2[3-59]|3[13-689]|4[0-68]|5[1-35])|5(?:08|16|4[03-5]|5\\d|6[4-6]|74|80)|6(?:[056]\\d|17|3[04]|4[0-378]|[78][0-8]|9[01])|7(?:6[46-9]|7[02-9]|8[034])|8(?:79|8[0-357-9]|9[1-57-9]))\\d{4}", null, null, null, "22123456"], [null, null, "[37-9]\\d{7}", null, null, null, "91234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "HN", 504, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{4})", "$1-$2", ["[237-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    HR: [null, [null, null, "(?:[24-69]\\d|3[0-79])\\d{7}|80\\d{5,7}|[1-79]\\d{7}|6\\d{5,6}", null, null, null, null, null, null, [6, 7, 8, 9]], [null, null, "1\\d{7}|(?:2[0-3]|3[1-5]|4[02-47-9]|5[1-3])\\d{6,7}", null, null, null, "12345678", null, null, [8, 9], [6, 7]], [null, null, "9(?:(?:01|[12589]\\d)\\d|7(?:[0679]\\d|51))\\d{5}|98\\d{6}", null, null, null, "921234567", null, null, [8, 9]], [null, null, "80[01]\\d{4,6}", null, null, null, "800123456", null, null, [7, 8, 9]], [null, null, "6[01459]\\d{6}|6[01]\\d{4,5}", null, null, null, "611234", null, null, [6, 7, 8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "7[45]\\d{6}", null, null, null, "74123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], "HR", 385, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{2,3})", "$1 $2 $3", ["6[01]"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{2,3})", "$1 $2 $3", ["8"], "0$1"], [null, "(\\d)(\\d{4})(\\d{3})", "$1 $2 $3", ["1"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2-5]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[67]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["9"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:62\\d?|72)\\d{6}", null, null, null, "62123456", null, null, [8, 9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    HT: [null, [null, null, "[2-489]\\d{7}", null, null, null, null, null, null, [8]], [null, null, "2(?:2\\d|5[1-5]|81|9[149])\\d{5}", null, null, null, "22453300"], [null, null, "[34]\\d{7}", null, null, null, "34101234"], [null, null, "8\\d{7}", null, null, null, "80012345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "9(?:[67][0-4]|8[0-3589]|9\\d)\\d{5}", null, null, null, "98901234"], "HT", 509, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3", ["[2-489]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    HU: [null, [null, null, "[2357]\\d{8}|[1-9]\\d{7}", null, null, null, null, null, null, [8, 9], [6, 7]], [null, null, "(?:1\\d|[27][2-9]|3[2-7]|4[24-9]|5[2-79]|6[23689]|8[2-57-9]|9[2-69])\\d{6}", null, null, null, "12345678", null, null, [8], [6, 7]], [null, null, "(?:[257]0|3[01])\\d{7}", null, null, null, "201234567", null, null, [9]], [null, null, "[48]0\\d{6}", null, null, null, "80123456", null, null, [8]], [null, null, "9[01]\\d{6}", null, null, null, "90123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "21\\d{7}", null, null, null, "211234567", null, null, [9]], "HU", 36, "00", "06", null, null, "06", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "($1)"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2-9]"], "($1)"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "[48]0\\d{6}", null, null, null, null, null, null, [8]], [null, null, "38\\d{7}", null, null, null, "381234567", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    ID: [null, [null, null, "(?:[1-36]|8\\d{5})\\d{6}|[1-9]\\d{8,10}|[2-9]\\d{7}", null, null, null, null, null, null, [7, 8, 9, 10, 11, 12], [5, 6]], [null, null, "2(?:[124]\\d{7,8}|(?:[35][1-4]|6[0-8]|7[1-6]|8\\d|9[1-8])\\d{5,8})|(?:3(?:1|[25][1-8]|3[1-68]|4[1-3]|6[1-3568]|7[0-469]|8\\d)|4(?:0[1-589]|1[01347-9]|2[0-36-8]|3[0-24-68]|43|5[1-378]|6[1-5]|7[134]|8[1245])|5(?:1[1-35-9]|2[25-8]|3[124-9]|4[1-3589]|5[1-46]|6[1-8])|7(?:02|[125][1-9]|[36]\\d|4[1-8]|7[0-36-9])|9(?:0[12]|1[013-8]|2[0-479]|5[125-8]|6[23679]|7[159]|8[01346]))\\d{5,8}|6(?:1(?:[0-8]\\d{4,7}|9\\d{4,8})|(?:[25]\\d|3[1-69]|4[1-6])\\d{5,8})|2(?:1(?:14|500)|2\\d{3})\\d{3}", null, null, null, "218350123", null, null, [7, 8, 9, 10, 11], [5, 6]], [null, null, "8[1-35-9]\\d{7,10}", null, null, null, "812345678", null, null, [9, 10, 11, 12]], [null, null, "(?:177\\d|800)\\d{5,7}", null, null, null, "8001234567", null, null, [8, 9, 10, 11]], [null, null, "809\\d{7}", null, null, null, "8091234567", null, null, [10]], [null, null, "804\\d{7}", null, null, null, "8041234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "ID", 62, "0(?:0[17-9]|10(?:00|1[67]))", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["15"]], [null, "(\\d{2})(\\d{5,9})", "$1 $2", ["2[124]|[36]1"], "(0$1)"], [null, "(\\d{3})(\\d{5,7})", "$1 $2", ["800"], "0$1"], [null, "(\\d{3})(\\d{5,8})", "$1 $2", ["[2-79]"], "(0$1)"], [null, "(\\d{3})(\\d{3,4})(\\d{3})", "$1-$2-$3", ["8[1-35-9]"], "0$1"], [null, "(\\d{3})(\\d{6,8})", "$1 $2", ["1"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["804"], "0$1"], [null, "(\\d{3})(\\d)(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["80"], "0$1"], [null, "(\\d{3})(\\d{4})(\\d{4,5})", "$1-$2-$3", ["8"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "8071\\d{6}", null, null, null, null, null, null, [10]], [null, null, "(?:1500|8071\\d{3})\\d{3}", null, null, null, "8071123456", null, null, [7, 10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IE: [null, [null, null, "[148]\\d{9}|[124-9]\\d{8}|[124-69]\\d{7}|[24-69]\\d{6}", null, null, null, null, null, null, [7, 8, 9, 10], [5, 6]], [null, null, "(?:1\\d{2,3}|2(?:[13]\\d\\d|[24-9])|4(?:0[24]|(?:(?:[1-469]|8[0-46-9])\\d|5)\\d|7)|5(?:0[45]|(?:1|[23679]\\d)\\d|8)|6(?:[237-9]|[4-6]\\d\\d)|7[14]\\d\\d|9(?:[04]\\d\\d|[35-9]))\\d{5}|[269]1\\d{6}", null, null, null, "2212345", null, null, null, [5, 6]], [null, null, "8(?:22|[35-9]\\d)\\d{6}", null, null, null, "850123456", null, null, [9]], [null, null, "1800\\d{6}", null, null, null, "1800123456", null, null, [10]], [null, null, "15(?:1[2-8]|[2-8]0|9[089])\\d{6}", null, null, null, "1520123456", null, null, [10]], [null, null, "18[59]0\\d{6}", null, null, null, "1850123456", null, null, [10]], [null, null, "700\\d{6}", null, null, null, "700123456", null, null, [9]], [null, null, "76\\d{7}", null, null, null, "761234567", null, null, [9]], "IE", 353, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{5})", "$1 $2", ["2[24-9]|47|58|6[237-9]|9[35-9]"], "(0$1)"], [null, "(\\d{3})(\\d{5})", "$1 $2", ["[45]0"], "(0$1)"], [null, "(\\d)(\\d{3,4})(\\d{4})", "$1 $2 $3", ["1"], "(0$1)"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2569]|4[1-69]|7[14]"], "(0$1)"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["76|8[235-9]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["7"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["81"], "(0$1)"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["4"], "(0$1)"], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1"]], [null, "(\\d{2})(\\d)(\\d{3})(\\d{4})", "$1 $2 $3 $4", ["8"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "18[59]0\\d{6}", null, null, null, null, null, null, [10]], [null, null, "818\\d{6}", null, null, null, "818123456", null, null, [9]], null, null, [null, null, "8[35-9]5\\d{7}", null, null, null, "8551234567", null, null, [10]]],
    IL: [null, [null, null, "1\\d{6}(?:\\d{3,5})?|[57]\\d{8}|[1-489]\\d{7}", null, null, null, null, null, null, [7, 8, 9, 10, 11, 12]], [null, null, "(?:153\\d\\d?|[2-489])\\d{7}", null, null, null, "21234567", null, null, [8, 11, 12], [7]], [null, null, "5(?:(?:[0-489][2-9]|6\\d)\\d|5(?:01|2[2-5]|3[23]|4[45]|5[05689]|6[6-8]|7[0-267]|8[7-9]|9[1-9]))\\d{5}", null, null, null, "502345678", null, null, [9]], [null, null, "1(?:255|80[019]\\d{3})\\d{3}", null, null, null, "1800123456", null, null, [7, 10]], [null, null, "1(?:2(?:00\\d\\d|12)|9(?:0[01]|19)\\d\\d)\\d{4}", null, null, null, "1919123456", null, null, [8, 10]], [null, null, "1700\\d{6}", null, null, null, "1700123456", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "7(?:(?:18|2[23]|3[237]|47|6[58]|7\\d|9[2357-9])\\d|8(?:2\\d|33|55|77|81))\\d{5}", null, null, null, "771234567", null, null, [9]], "IL", 972, "0(?:0|1[2-9])", "0", null, null, "0", null, null, null, [[null, "(\\d{4})(\\d{3})", "$1-$2", ["125"]], [null, "(\\d)(\\d{3})(\\d{4})", "$1-$2-$3", ["[2-489]"], "0$1"], [null, "(\\d{4})(\\d{2})(\\d{2})", "$1-$2-$3", ["121"]], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["[57]"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1-$2-$3", ["12"]], [null, "(\\d{4})(\\d{6})", "$1-$2", ["159"]], [null, "(\\d)(\\d{3})(\\d{3})(\\d{3})", "$1-$2-$3-$4", ["1[7-9]"]], [null, "(\\d{3})(\\d{1,2})(\\d{3})(\\d{4})", "$1-$2 $3-$4", ["1"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "1700\\d{6}", null, null, null, null, null, null, [10]], [null, null, "1599\\d{6}", null, null, null, "1599123456", null, null, [10]], null, null, [null, null, "151\\d{8,9}", null, null, null, "15112340000", null, null, [11, 12]]],
    IM: [null, [null, null, "(?:1624|(?:[3578]\\d|90)\\d\\d)\\d{6}", null, null, null, null, null, null, [10], [6]], [null, null, "1624[5-8]\\d{5}", null, null, null, "1624756789", null, null, null, [6]], [null, null, "7(?:4576|[59]24\\d|624[0-4689])\\d{5}", null, null, null, "7924123456"], [null, null, "808162\\d{4}", null, null, null, "8081624567"], [null, null, "(?:8(?:4(?:40[49]06|5624\\d)|7(?:0624|2299)\\d)|90[0167]624\\d)\\d{3}", null, null, null, "9016247890"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "70\\d{8}", null, null, null, "7012345678"], [null, null, "56\\d{8}", null, null, null, "5612345678"], "IM", 44, "00", "0", null, null, "0|([5-8]\\d{5})$", "1624$1", null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:3(?:(?:08162|3\\d{4}|7(?:0624|2299))\\d|4(?:40[49]06|5624\\d))|55\\d{5})\\d{3}", null, null, null, "5512345678"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IN: [null, [null, null, "(?:00800|1\\d{0,5}|[2-9]\\d\\d)\\d{7}", null, null, null, null, null, null, [8, 9, 10, 11, 12, 13], [6, 7]], [null, null, "(?:1(?:1[2-7]\\d\\d|2(?:[0-249][2-7]\\d|[35-8]\\d[2-7])|3(?:[0-25][2-7]\\d|[346-9]\\d[2-7])|4(?:[145][2-7]\\d|[236-9]\\d[2-7])|[59](?:[0235-9]\\d[2-7]|[14][2-7]\\d)|6(?:[014][2-7]\\d|[235-9]\\d[2-7])|7(?:(?:0[24]|[1257][2-7])\\d|[34689]\\d[2-7])|8(?:[01346][2-7]\\d|[257-9]\\d[2-7]))|2(?:[02][2-7]\\d\\d|1(?:[134689]\\d[2-7]|[257][2-7]\\d)|3(?:[013][2-7]\\d|[24-8]\\d[2-7])|4(?:[01][2-7]\\d|[2-8]\\d[2-7])|5(?:[0137][2-7]\\d|[25689]\\d[2-7])|6(?:[0158][2-7]\\d|[2-4679]\\d[2-7])|7(?:[13-79]\\d[2-7]|8[2-7]\\d)|8(?:(?:0[13468]|[1568][2-7])\\d|[2-479]\\d[2-7])|9(?:(?:0\\d|[14][2-7])\\d|[235-9]\\d[2-7]))|3(?:(?:01|1[79])\\d[2-7]|2(?:[1-5]\\d[2-7]|6[2-7]\\d)|3[2-7]\\d\\d|4(?:[13][2-7]\\d|2(?:[0189][2-7]|[2-7]\\d)|[5-8]\\d[2-7])|5(?:[125689]\\d[2-7]|[34][2-7]\\d)|6(?:[01489][2-7]\\d|[235-7]\\d[2-7])|7(?:[02-46][2-7]\\d|[157-9]\\d[2-7])|8(?:(?:0\\d|[159][2-7])\\d|[2-46-8]\\d[2-7]))|4(?:[04][2-7]\\d\\d|1(?:[14578]\\d[2-7]|[36][2-7]\\d)|2(?:(?:0[24]|[1-47][2-7])\\d|[5689]\\d[2-7])|3(?:[15][2-7]\\d|[2-467]\\d[2-7])|5(?:[12][2-7]\\d|[4-7]\\d[2-7])|6(?:[0-26-9][2-7]\\d|[35]\\d[2-7])|7(?:(?:[014-9][2-7]|2[2-8])\\d|3\\d[2-7])|8(?:[013-57][2-7]\\d|[2689]\\d[2-7])|9(?:[014-7][2-7]\\d|[2389]\\d[2-7]))|5(?:1(?:[025][2-7]\\d|[146-9]\\d[2-7])|2(?:[14-8]\\d[2-7]|2[2-7]\\d)|3(?:[1346]\\d[2-7]|[25][2-7]\\d)|4(?:[14-69]\\d[2-7]|[28][2-7]\\d)|5(?:(?:1[2-7]|2[1-7])\\d|[46]\\d[2-7])|6(?:[146-9]\\d[2-7]|[25][2-7]\\d)|7(?:1[2-7]\\d|[2-4]\\d[2-7])|8(?:1[2-7]\\d|[2-8]\\d[2-7])|9(?:[15][2-7]\\d|[246]\\d[2-7]))|6(?:1(?:[1358]\\d[2-7]|2[2-7]\\d)|2(?:1[2-7]\\d|[2457]\\d[2-7])|3(?:1[2-7]\\d|[2-4]\\d[2-7])|4(?:1[2-7]\\d|[235-7]\\d[2-7])|5(?:[17][2-7]\\d|[2-689]\\d[2-7])|6(?:[13][2-7]\\d|[24578]\\d[2-7])|7(?:1[2-7]\\d|[235689]\\d[2-7]|4(?:[0189][2-7]|[2-7]\\d))|8(?:0[2-7]\\d|[1-6]\\d[2-7]))|7(?:1(?:[013-9]\\d[2-7]|2[2-7]\\d)|2(?:[0235-9]\\d[2-7]|[14][2-7]\\d)|3(?:[134][2-7]\\d|[2679]\\d[2-7])|4(?:[1-35689]\\d[2-7]|[47][2-7]\\d)|5(?:[15][2-7]\\d|[2-46-9]\\d[2-7])|[67](?:[02-9]\\d[2-7]|1[2-7]\\d)|8(?:(?:[013-7]\\d|2[0-6])[2-7]|8(?:[0189][2-7]|[2-7]\\d))|9(?:[0189]\\d[2-7]|[2-7]\\d\\d))|8(?:0[2-7]\\d\\d|1(?:[1357-9]\\d[2-7]|6[2-7]\\d)|2(?:[014][2-7]\\d|[235-8]\\d[2-7])|3(?:[03-57-9]\\d[2-7]|[126][2-7]\\d)|(?:4[0-24-9]|5\\d)\\d[2-7]|6(?:[136][2-7]\\d|[2457-9]\\d[2-7])|7(?:[078][2-7]\\d|[1-6]\\d[2-7])|8(?:[1256]\\d[2-7]|[34][2-7]\\d)|9(?:1[2-7]\\d|[2-4]\\d[2-7])))\\d{5}", null, null, null, "7410410123", null, null, [10], [6, 7, 8]], [null, null, "(?:6(?:(?:0(?:0[0-3569]|26|33)|2(?:[06]\\d|3[02589]|8[0-479]|9[0-79])|9(?:0[019]|13))\\d|1279|3(?:(?:0[0-79]|6[0-4679]|7[0-24-9]|[89]\\d)\\d|5(?:0[0-6]|[1-9]\\d)))|7(?:(?:0\\d\\d|19[0-5])\\d|2(?:(?:[0235-79]\\d|[14][017-9])\\d|8(?:[0-59]\\d|[6-8][089]))|3(?:(?:[05-8]\\d|3[017-9])\\d|1(?:[089]\\d|11|7[02-8])|2(?:[0-49][089]|[5-8]\\d)|4(?:[07-9]\\d|11)|9(?:[016-9]\\d|[2-5][089]))|4(?:0\\d\\d|1(?:[015-9]\\d|[2-4][089])|[29](?:[0-7][089]|[89]\\d)|3(?:[0-8][089]|9\\d)|[47](?:[089]\\d|11|7[02-8])|[56]\\d[089]|8(?:[0-24-7][089]|[389]\\d))|5(?:(?:[0346-8]\\d|5[017-9])\\d|1(?:[07-9]\\d|11)|2(?:[04-9]\\d|[1-3][089])|9(?:[0-6][089]|[7-9]\\d))|6(?:0(?:[0-47]\\d|[5689][089])|(?:1[0-257-9]|[6-9]\\d)\\d|2(?:[0-4]\\d|[5-9][089])|3(?:[02-8][089]|[19]\\d)|4\\d[089]|5(?:[0-367][089]|[4589]\\d))|7(?:0(?:0[02-9]|[13-7][089]|[289]\\d)|[1-9]\\d\\d)|8(?:[0-79]\\d\\d|8(?:[089]\\d|11|7[02-9]))|9(?:[089]\\d\\d|313|7(?:[02-8]\\d|9[07-9])))|8(?:0(?:(?:[01589]\\d|6[67])\\d|7(?:[02-8]\\d|9[04-9]))|1(?:[0-57-9]\\d\\d|6(?:[089]\\d|7[02-8]))|2(?:[014](?:[089]\\d|7[02-8])|[235-9]\\d\\d)|3(?:[03-57-9]\\d\\d|[126](?:[089]\\d|7[02-8]))|[45]\\d{3}|6(?:[02457-9]\\d\\d|[136](?:[089]\\d|7[02-8]))|7(?:(?:0[07-9]|[1-69]\\d)\\d|[78](?:[089]\\d|7[02-8]))|8(?:[0-25-9]\\d\\d|3(?:[089]\\d|7[02-8])|4(?:[0489]\\d|7[02-8]))|9(?:[02-9]\\d\\d|1(?:[0289]\\d|7[02-8])))|9\\d{4})\\d{5}", null, null, null, "8123456789", null, null, [10]], [null, null, "(?:00800\\d|1(?:600|80[03]\\d{3}))\\d{6}|1800\\d{4,8}", null, null, null, "1800123456"], [null, null, "186[12]\\d{9}", null, null, null, "1861123456789", null, null, [13]], [null, null, "1860\\d{7}", null, null, null, "18603451234", null, null, [11]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "IN", 91, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{8})", "$1", ["5[0236-8]"], null, null, 1], [null, "(\\d{4})(\\d{4,5})", "$1 $2", ["180", "1800"], null, null, 1], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["11|2[02]|33|4[04]|79[1-7]|80[2-46]", "11|2[02]|33|4[04]|79(?:[1-6]|7[19])|80(?:[2-4]|6[0-589])", "11|2[02]|33|4[04]|79(?:[124-6]|3(?:[02-9]|1[0-24-9])|7(?:1|9[1-6]))|80(?:[2-4]|6[0-589])"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["1(?:2[0-249]|3[0-25]|4[145]|[59][14]|[68]|7[1257])|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5[12]|[78]1|9[15])|6(?:12|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|2[14]|3[134]|4[47]|5[15]|61|88)|8(?:16|2[014]|3[126]|6[136]|7[078]|8[34]|91)", "1(?:2[0-249]|3[0-25]|4[145]|[59][14]|6(?:0[2-7]|[1-9])|7[1257]|8(?:[06][2-7]|[1-57-9]))|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5(?:1|2[2-7])|[78]1|9[15])|6(?:12[2-7]|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|(?:2[14]|5[15])[2-6]|3(?:1[2-7]|[34][2-6])|4[47][2-7]|61[346]|88[0-8])|8(?:(?:16|2[014]|3[126]|6[136])[2-7]|7(?:0[2-6]|[78][2-7])|8(?:3[2-7]|4[235-7])|91[3-7])", "1(?:2[0-249]|3[0-25]|4[145]|[59][14]|6(?:0[2-7]|[1-9])|7[1257]|8(?:[06][2-7]|[1-57-9]))|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5(?:1|2[2-7])|[78]1|9[15])|6(?:12(?:[2-6]|7[0-8])|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|(?:2[14]|5[15])[2-6]|3(?:1(?:[2-6]|71)|[34][2-6])|4[47](?:[2-6]|7[19])|61[346]|88(?:[01][2-7]|[2-7]|82))|8(?:(?:16|2[014]|3[126]|6[136])(?:[2-6]|7[19])|7(?:0[2-6]|[78](?:[2-6]|7[19]))|8(?:3(?:[2-6]|7[19])|4(?:[2356]|7[19]))|91(?:[3-6]|7[19]))"], "0$1", null, 1], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2[2457-9]|3[2-5]|[4-8])|7(?:1[013-9]|28|3[129]|4[1-35689]|5[29]|6[02-5]|70)|807", "1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2(?:[2457]|84|95)|3(?:[2-4]|55)|[4-8])|7(?:1(?:[013-8]|9[6-9])|28[6-8]|3(?:17|2[0-49]|9[2-57])|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4|5[0-367])|70[13-7])|807[19]", "1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2(?:[2457]|84|95)|3(?:[2-4]|55)|[4-8])|7(?:1(?:[013-8]|9[6-9])|(?:28[6-8]|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]\\d|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4\\d|5[0-367])|70[13-7])[2-7]|3(?:179|(?:2[0-49]|9[2-57])[2-7]))|807(?:1|9[1-3])"], "0$1", null, 1], [null, "(\\d{5})(\\d{5})", "$1 $2", ["[6-9]"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["14"], null, null, 1], [null, "(\\d{4})(\\d{2,4})(\\d{4})", "$1 $2 $3", ["1(?:6|8[06])", "1(?:6|8[06]0)"], null, null, 1], [null, "(\\d{2})(\\d{3})(\\d{4})(\\d{3})", "$1 $2 $3 $4", ["0"], "0$1", null, 1], [null, "(\\d{4})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["1"], null, null, 1]], [[null, "(\\d{8})", "$1", ["5[0236-8]"], null, null, 1], [null, "(\\d{4})(\\d{4,5})", "$1 $2", ["180", "1800"], null, null, 1], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["11|2[02]|33|4[04]|79[1-7]|80[2-46]", "11|2[02]|33|4[04]|79(?:[1-6]|7[19])|80(?:[2-4]|6[0-589])", "11|2[02]|33|4[04]|79(?:[124-6]|3(?:[02-9]|1[0-24-9])|7(?:1|9[1-6]))|80(?:[2-4]|6[0-589])"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["1(?:2[0-249]|3[0-25]|4[145]|[59][14]|[68]|7[1257])|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5[12]|[78]1|9[15])|6(?:12|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|2[14]|3[134]|4[47]|5[15]|61|88)|8(?:16|2[014]|3[126]|6[136]|7[078]|8[34]|91)", "1(?:2[0-249]|3[0-25]|4[145]|[59][14]|6(?:0[2-7]|[1-9])|7[1257]|8(?:[06][2-7]|[1-57-9]))|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5(?:1|2[2-7])|[78]1|9[15])|6(?:12[2-7]|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|(?:2[14]|5[15])[2-6]|3(?:1[2-7]|[34][2-6])|4[47][2-7]|61[346]|88[0-8])|8(?:(?:16|2[014]|3[126]|6[136])[2-7]|7(?:0[2-6]|[78][2-7])|8(?:3[2-7]|4[235-7])|91[3-7])", "1(?:2[0-249]|3[0-25]|4[145]|[59][14]|6(?:0[2-7]|[1-9])|7[1257]|8(?:[06][2-7]|[1-57-9]))|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5(?:1|2[2-7])|[78]1|9[15])|6(?:12(?:[2-6]|7[0-8])|[2-4]1|5[17]|6[13]|7[14]|80)|7(?:12|(?:2[14]|5[15])[2-6]|3(?:1(?:[2-6]|71)|[34][2-6])|4[47](?:[2-6]|7[19])|61[346]|88(?:[01][2-7]|[2-7]|82))|8(?:(?:16|2[014]|3[126]|6[136])(?:[2-6]|7[19])|7(?:0[2-6]|[78](?:[2-6]|7[19]))|8(?:3(?:[2-6]|7[19])|4(?:[2356]|7[19]))|91(?:[3-6]|7[19]))"], "0$1", null, 1], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2[2457-9]|3[2-5]|[4-8])|7(?:1[013-9]|28|3[129]|4[1-35689]|5[29]|6[02-5]|70)|807", "1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2(?:[2457]|84|95)|3(?:[2-4]|55)|[4-8])|7(?:1(?:[013-8]|9[6-9])|28[6-8]|3(?:17|2[0-49]|9[2-57])|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4|5[0-367])|70[13-7])|807[19]", "1(?:[23579]|4[236-9])|[2-5]|6(?:1[1358]|2(?:[2457]|84|95)|3(?:[2-4]|55)|[4-8])|7(?:1(?:[013-8]|9[6-9])|(?:28[6-8]|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]\\d|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4\\d|5[0-367])|70[13-7])[2-7]|3(?:179|(?:2[0-49]|9[2-57])[2-7]))|807(?:1|9[1-3])"], "0$1", null, 1], [null, "(\\d{5})(\\d{5})", "$1 $2", ["[6-9]"], "0$1", null, 1], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["14"], null, null, 1], [null, "(\\d{4})(\\d{2,4})(\\d{4})", "$1 $2 $3", ["1(?:6|8[06])", "1(?:6|8[06]0)"], null, null, 1], [null, "(\\d{4})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["1"], null, null, 1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "(?:00800\\d|1(?:600|8(?:0[03]\\d\\d|6(?:0|[12]\\d\\d))\\d))\\d{6}|1800\\d{4,8}"], [null, null, "140\\d{7}", null, null, null, "1409305260", null, null, [10]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IO: [null, [null, null, "3\\d{6}", null, null, null, null, null, null, [7]], [null, null, "37\\d{5}", null, null, null, "3709100"], [null, null, "38\\d{5}", null, null, null, "3801234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "IO", 246, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["3"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IQ: [null, [null, null, "(?:1|[2-6]\\d?|7\\d\\d)\\d{7}", null, null, null, null, null, null, [8, 9, 10], [6, 7]], [null, null, "1\\d{7}|(?:2[13-5]|3[02367]|4[023]|5[03]|6[026])\\d{6,7}", null, null, null, "12345678", null, null, [8, 9], [6, 7]], [null, null, "7[3-9]\\d{8}", null, null, null, "7912345678", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "IQ", 964, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2-6]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["7"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IR: [null, [null, null, "[1-9]\\d{9}|(?:[1-8]\\d\\d|9)\\d{3,4}", null, null, null, null, null, null, [4, 5, 6, 7, 10], [8]], [null, null, "(?:(?:1[137]|2[13-68]|3[1458]|4[145]|5[1468]|6[16]|7[1467]|8[13467])\\d{4}|94(?:(?:000|(?:11|2\\d)\\d|30[01])\\d|4(?:111|40\\d)))\\d{4}|(?:1[137]|2[13-68]|3[1458]|4[145]|5[1468]|6[16]|7[1467]|8[13467])(?:[16]|[289]\\d?)\\d{3}", null, null, null, "2123456789", null, null, [6, 7, 10], [4, 5, 8]], [null, null, "9(?:(?:0(?:[1-35]\\d|44)|(?:[13]\\d|2[0-2])\\d)\\d|9(?:(?:[01]\\d|44)\\d|510|8(?:1[01]|88)|9(?:0[013]|1[0134]|21|77|9[6-9])))\\d{5}", null, null, null, "9123456789", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "993\\d{7}", null, null, null, "9932123456", null, null, [10]], "IR", 98, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{4,5})", "$1", ["96"], "0$1"], [null, "(\\d{2})(\\d{4,5})", "$1 $2", ["(?:1[137]|2[13-68]|3[1458]|4[145]|5[1468]|6[16]|7[1467]|8[13467])[12689]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["9"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["[1-8]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "9(?:4(?:11[1-7]|440)\\d{5}|6(?:0[12]|2[16-8]|3(?:08|[14]5|[23]|66)|4(?:0|80)|5[01]|6[89]|86|9[19]))", null, null, null, null, null, null, [4, 5, 10]], [null, null, "96(?:0[12]|2[16-8]|3(?:08|[14]5|[23]|66)|4(?:0|80)|5[01]|6[89]|86|9[19])", null, null, null, "9601", null, null, [4, 5]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    IS: [null, [null, null, "(?:38\\d|[4-9])\\d{6}", null, null, null, null, null, null, [7, 9]], [null, null, "(?:4(?:1[0-24-69]|2[0-7]|[37][0-8]|4[0-245]|5[0-68]|6\\d|8[0-36-8])|5(?:05|[156]\\d|2[02578]|3[0-579]|4[03-7]|7[0-2578]|8[0-35-9]|9[013-689])|87[23])\\d{4}", null, null, null, "4101234", null, null, [7]], [null, null, "(?:38[589]\\d\\d|6(?:1[1-8]|2[0-6]|3[027-9]|4[014679]|5[0159]|6[0-69]|70|8[06-8]|9\\d)|7(?:5[057]|[6-8]\\d|9[0-3])|8(?:2[0-59]|[3469]\\d|5[1-9]|8[28]))\\d{4}", null, null, null, "6111234"], [null, null, "800\\d{4}", null, null, null, "8001234", null, null, [7]], [null, null, "90\\d{5}", null, null, null, "9011234", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "49\\d{5}", null, null, null, "4921234", null, null, [7]], "IS", 354, "00|1(?:0(?:01|[12]0)|100)", null, null, null, null, null, "00", null, [[null, "(\\d{3})(\\d{4})", "$1 $2", ["[4-9]"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["3"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "809\\d{4}", null, null, null, "8091234", null, null, [7]], null, null, [null, null, "(?:689|8(?:7[0189]|80)|95[48])\\d{4}", null, null, null, "6891234", null, null, [7]]],
    IT: [null, [null, null, "0\\d{6}(?:\\d{4})?|3[0-8]\\d{9}|(?:[0138]\\d?|55)\\d{8}|[08]\\d{5}(?:\\d{2})?", null, null, null, null, null, null, [6, 7, 8, 9, 10, 11]], [null, null, "0(?:(?:1(?:[0159]\\d|[27][1-5]|31|4[1-4]|6[1356]|8[2-57])|2\\d\\d|3(?:[0159]\\d|2[1-4]|3[12]|[48][1-6]|6[2-59]|7[1-7])|4(?:[0159]\\d|[23][1-9]|4[245]|6[1-5]|7[1-4]|81)|5(?:[0159]\\d|2[1-5]|3[2-6]|4[1-79]|6[4-6]|7[1-578]|8[3-8])|7(?:[0159]\\d|2[12]|3[1-7]|4[2-46]|6[13569]|7[13-6]|8[1-59])|8(?:[0159]\\d|2[3-578]|3[1-356]|[6-8][1-5])|9(?:[0159]\\d|[238][1-5]|4[12]|6[1-8]|7[1-6]))\\d|6(?:[0-57-9]\\d\\d|6(?:[0-8]\\d|9[0-79])))\\d{1,6}", null, null, null, "0212345678"], [null, null, "33\\d{9}|3[1-9]\\d{8}|3[2-9]\\d{7}", null, null, null, "3123456789", null, null, [9, 10, 11]], [null, null, "80(?:0\\d{3}|3)\\d{3}", null, null, null, "800123456", null, null, [6, 9]], [null, null, "(?:(?:0878|1(?:44|6[346])\\d)\\d\\d|89(?:2|(?:4[5-9]|(?:5[5-9]|9)\\d\\d)\\d))\\d{3}|89[45][0-4]\\d\\d", null, null, null, "899123456", null, null, [6, 8, 9, 10]], [null, null, "84(?:[08]\\d{3}|[17])\\d{3}", null, null, null, "848123456", null, null, [6, 9]], [null, null, "1(?:78\\d|99)\\d{6}", null, null, null, "1781234567", null, null, [9, 10]], [null, null, "55\\d{8}", null, null, null, "5512345678", null, null, [10]], "IT", 39, "00", null, null, null, null, null, null, null, [[null, "(\\d{2})(\\d{4,6})", "$1 $2", ["0[26]"]], [null, "(\\d{3})(\\d{3,6})", "$1 $2", ["0[13-57-9][0159]|8(?:03|4[17]|9[245])", "0[13-57-9][0159]|8(?:03|4[17]|9(?:2|[45][0-4]))"]], [null, "(\\d{4})(\\d{2,6})", "$1 $2", ["0(?:[13-579][2-46-8]|8[236-8])"]], [null, "(\\d{4})(\\d{4})", "$1 $2", ["894"]], [null, "(\\d{2})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["0[26]|5"]], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["1(?:44|[67]|99)|[38]"]], [null, "(\\d{3})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["0[13-57-9][0159]"]], [null, "(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["3"]], [null, "(\\d{2})(\\d{4})(\\d{5})", "$1 $2 $3", ["0[26]"]], [null, "(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["0"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], 1, null, [null, null, "848\\d{6}", null, null, null, null, null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    JE: [null, [null, null, "(?:1534|(?:[3578]\\d|90)\\d\\d)\\d{6}", null, null, null, null, null, null, [10], [6]], [null, null, "1534[0-24-8]\\d{5}", null, null, null, "1534456789", null, null, null, [6]], [null, null, "7(?:(?:(?:50|82)9|937)\\d|7(?:00[378]|97[7-9]))\\d{5}", null, null, null, "7797712345"], [null, null, "80(?:07(?:35|81)|8901)\\d{4}", null, null, null, "8007354567"], [null, null, "(?:8(?:4(?:4(?:4(?:05|42|69)|703)|5(?:041|800))|7(?:0002|1206))|90(?:066[59]|1810|71(?:07|55)))\\d{4}", null, null, null, "9018105678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "701511\\d{4}", null, null, null, "7015115678"], [null, null, "56\\d{8}", null, null, null, "5612345678"], "JE", 44, "00", "0", null, null, "0|([0-24-8]\\d{5})$", "1534$1", null, null, null, null, [null, null, "76(?:0[0-2]|2[356]|4[0134]|5[49]|6[0-369]|77|81|9[39])\\d{6}", null, null, null, "7640123456"], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "(?:3(?:0(?:07(?:35|81)|8901)|3\\d{4}|4(?:4(?:4(?:05|42|69)|703)|5(?:041|800))|7(?:0002|1206))|55\\d{4})\\d{4}", null, null, null, "5512345678"], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    JM: [null, [null, null, "(?:[58]\\d\\d|658|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "(?:658[2-9]\\d\\d|876(?:5(?:0[12]|1[0-468]|2[35]|63)|6(?:0[1-3579]|1[0237-9]|[23]\\d|40|5[06]|6[2-589]|7[05]|8[04]|9[4-9])|7(?:0[2-689]|[1-6]\\d|8[056]|9[45])|9(?:0[1-8]|1[02378]|[2-8]\\d|9[2-468])))\\d{4}", null, null, null, "8765230123", null, null, null, [7]], [null, null, "876(?:(?:2[14-9]|[348]\\d)\\d|5(?:0[3-9]|[2-57-9]\\d|6[0-24-9])|7(?:0[07]|7\\d|8[1-47-9]|9[0-36-9])|9(?:[01]9|9[0579]))\\d{4}", null, null, null, "8762101234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "JM", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "658|876", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    JO: [null, [null, null, "(?:(?:(?:[268]|7\\d)\\d|32|53)\\d|900)\\d{5}", null, null, null, null, null, null, [8, 9]], [null, null, "(?:2(?:6(?:2[0-35-9]|3[0-578]|4[24-7]|5[0-24-8]|[6-8][023]|9[0-3])|7(?:0[1-79]|10|2[014-7]|3[0-689]|4[019]|5[0-3578]))|32(?:0[1-69]|1[1-35-7]|2[024-7]|3\\d|4[0-3]|[57][023]|6[03])|53(?:0[0-3]|[13][023]|2[0-59]|49|5[0-35-9]|6[15]|7[45]|8[1-6]|9[0-36-9])|6(?:2[05]0|3(?:00|33)|4(?:0[0-25]|1[2-7]|2[0569]|[38][07-9]|4[025689]|6[0-589]|7\\d|9[0-2])|5(?:[01][056]|2[034]|3[0-57-9]|4[178]|5[0-69]|6[0-35-9]|7[1-379]|8[0-68]|9[0239]))|87(?:[029]0|7[08]))\\d{4}", null, null, null, "62001234", null, null, [8]], [null, null, "7(?:55[0-49]|(?:7[025-9]|[89][0-25-9])\\d)\\d{5}", null, null, null, "790123456", null, null, [9]], [null, null, "80\\d{6}", null, null, null, "80012345", null, null, [8]], [null, null, "900\\d{5}", null, null, null, "90012345", null, null, [8]], [null, null, "85\\d{6}", null, null, null, "85012345", null, null, [8]], [null, null, "70\\d{7}", null, null, null, "700123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], "JO", 962, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["[2356]|87"], "(0$1)"], [null, "(\\d{3})(\\d{5,6})", "$1 $2", ["[89]"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["7[457-9]"], "0$1"], [null, "(\\d{2})(\\d{7})", "$1 $2", ["7"], "0$1"]], null, [null, null, "74(?:66|77)\\d{5}", null, null, null, "746612345", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "8(?:10|8\\d)\\d{5}", null, null, null, "88101234", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    JP: [null, [null, null, "00[1-9]\\d{6,14}|[257-9]\\d{9}|(?:00|[1-9]\\d\\d)\\d{6}", null, null, null, null, null, null, [8, 9, 10, 11, 12, 13, 14, 15, 16, 17]], [null, null, "(?:1(?:1[235-8]|2[3-6]|3[3-9]|4[2-6]|[58][2-8]|6[2-7]|7[2-9]|9[1-9])|(?:2[2-9]|[36][1-9])\\d|4(?:[2-578]\\d|6[02-8]|9[2-59])|5(?:[2-589]\\d|6[1-9]|7[2-8])|7(?:[25-9]\\d|3[4-9]|4[02-9])|8(?:[2679]\\d|3[2-9]|4[5-9]|5[1-9]|8[03-9])|9(?:[2-58]\\d|[679][1-9]))\\d{6}", null, null, null, "312345678", null, null, [9]], [null, null, "[7-9]0[1-9]\\d{7}", null, null, null, "9012345678", null, null, [10]], [null, null, "(?:00(?:(?:37|66)\\d{4,11}|777(?:[01]|(?:5|8\\d)\\d)|882[1245]\\d\\d)|(?:120|800\\d)\\d{4})\\d\\d", null, null, null, "120123456"], [null, null, "990\\d{6}", null, null, null, "990123456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "60\\d{7}", null, null, null, "601234567", null, null, [9]], [null, null, "50[1-9]\\d{7}", null, null, null, "5012345678", null, null, [10]], "JP", 81, "010", "0", null, null, "0", null, null, null, [[null, "(\\d{4})(\\d{4})", "$1-$2", ["007", "0077", "00777", "00777[01]"]], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1-$2-$3", ["(?:12|57|99)0"], "0$1"], [null, "(\\d{4})(\\d)(\\d{4})", "$1-$2-$3", ["1(?:26|3[79]|4[56]|5[4-68]|6[3-5])|499|5(?:76|97)|746|8(?:3[89]|47|51|63)|9(?:49|80|9[16])", "1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:76|97)9|7468|8(?:3(?:8[78]|96)|477|51[24]|636)|9(?:496|802|9(?:1[23]|69))", "1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:769|979[2-69])|7468|8(?:3(?:8[78]|96[2457-9])|477|51[24]|636[2-57-9])|9(?:496|802|9(?:1[23]|69))"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{4})", "$1-$2-$3", ["1(?:[2-46]|5[2-8]|7[2-689]|8[2-7]|9[1-578])|2(?:2[03-689]|3[3-58]|4[0-468]|5[04-8]|6[013-8]|7[06-9]|8[02-57-9]|9[13])|4(?:2[28]|3[689]|6[035-7]|7[05689]|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9[4-9])|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9[014-9])|8(?:2[49]|3[3-8]|4[5-8]|5[2-9]|6[35-9]|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9[3-7])", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9[2-8])|3(?:[3-6][2-9]|7[2-6]|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5[4-7]|6[2-9]|8[2-8]|9[236-9])|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3[34]|4[2-69]|[5-7]))", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6[56]))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6(?:5[25]|60)))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["1|2(?:2[37]|5[5-9]|64|78|8[39]|91)|4(?:2[2689]|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93)", "1|2(?:2[37]|5(?:[57]|[68]0|9[19])|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93[34])", "1|2(?:2[37]|5(?:[57]|[68]0|9(?:17|99))|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93[34])"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{4})", "$1-$2-$3", ["2(?:[34]7|[56]9|74|9[14-79])|82|993"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1-$2-$3", ["[36]|4(?:2[09]|7[01])"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["2[2-9]|4|7[235-9]|9[49]"], "0$1"], [null, "(\\d{4})(\\d{2})(\\d{3,4})", "$1-$2-$3", ["007"]], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["800"], "0$1"], [null, "(\\d{4})(\\d{2})(\\d{4})", "$1-$2-$3", ["008"]], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1-$2-$3", ["[2579]|80"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3,4})", "$1-$2-$3", ["0"]], [null, "(\\d{4})(\\d{4})(\\d{4,5})", "$1-$2-$3", ["0"]], [null, "(\\d{4})(\\d{5})(\\d{5,6})", "$1-$2-$3", ["0"]], [null, "(\\d{4})(\\d{6})(\\d{6,7})", "$1-$2-$3", ["0"]]], [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1-$2-$3", ["(?:12|57|99)0"], "0$1"], [null, "(\\d{4})(\\d)(\\d{4})", "$1-$2-$3", ["1(?:26|3[79]|4[56]|5[4-68]|6[3-5])|499|5(?:76|97)|746|8(?:3[89]|47|51|63)|9(?:49|80|9[16])", "1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:76|97)9|7468|8(?:3(?:8[78]|96)|477|51[24]|636)|9(?:496|802|9(?:1[23]|69))", "1(?:267|3(?:7[247]|9[278])|4(?:5[67]|66)|5(?:47|58|64|8[67])|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:769|979[2-69])|7468|8(?:3(?:8[78]|96[2457-9])|477|51[24]|636[2-57-9])|9(?:496|802|9(?:1[23]|69))"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{4})", "$1-$2-$3", ["1(?:[2-46]|5[2-8]|7[2-689]|8[2-7]|9[1-578])|2(?:2[03-689]|3[3-58]|4[0-468]|5[04-8]|6[013-8]|7[06-9]|8[02-57-9]|9[13])|4(?:2[28]|3[689]|6[035-7]|7[05689]|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9[4-9])|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9[014-9])|8(?:2[49]|3[3-8]|4[5-8]|5[2-9]|6[35-9]|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9[3-7])", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9[2-8])|3(?:[3-6][2-9]|7[2-6]|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5[4-7]|6[2-9]|8[2-8]|9[236-9])|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3[34]|4[2-69]|[5-7]))", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6[56]))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))", "1(?:[2-46]|5(?:[236-8]|[45][2-69])|7[2-689]|8[2-7]|9[1-578])|2(?:2(?:[04-689]|3[23])|3[3-58]|4[0-468]|5(?:[0468][2-9]|5[78]|7[2-4])|6(?:[0135-8]|4[2-5])|7(?:[0679]|8[2-7])|8(?:[024578]|3[25-9]|9[6-9])|9(?:11|3[2-4]))|4(?:2(?:2[2-9]|8[237-9])|3[689]|6[035-7]|7(?:[059][2-8]|[68])|80|9[3-5])|5(?:3[1-36-9]|4[4578]|5[013-8]|[67]|8[14-7]|9(?:[4-7]|[89][2-8]))|7(?:2[15]|3[5-9]|4|6[135-8]|7[0-4689]|9(?:[017-9]|4[6-8]|5[2-478]|6[2-589]))|8(?:2(?:4[4-8]|9(?:20|[3578]|4[04-9]|6(?:5[25]|60)))|3(?:[3-6][2-9]|7(?:[2-5]|6[0-59])|8[2-5])|4[5-8]|5[2-9]|6(?:[37]|5(?:[467]|5[014-9])|6(?:[2-8]|9[02-69])|8[2-8]|9(?:[236-8]|9[23]))|7[579]|8[03-579]|9[2-8])|9(?:[23]0|4[02-46-9]|5[024-79]|6[4-9]|7[2-47-9]|8[02-7]|9(?:3(?:3[02-9]|4[0-24689])|4[2-69]|[5-7]))"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["1|2(?:2[37]|5[5-9]|64|78|8[39]|91)|4(?:2[2689]|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93)", "1|2(?:2[37]|5(?:[57]|[68]0|9[19])|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93[34])", "1|2(?:2[37]|5(?:[57]|[68]0|9(?:17|99))|64|78|8[39]|917)|4(?:2(?:20|[68]|9[178])|64|7[347])|5[2-589]|60|8(?:2[124589]|3[279]|[46-9])|9(?:[235-8]|93[34])"], "0$1"], [null, "(\\d{3})(\\d{2})(\\d{4})", "$1-$2-$3", ["2(?:[34]7|[56]9|74|9[14-79])|82|993"], "0$1"], [null, "(\\d)(\\d{4})(\\d{4})", "$1-$2-$3", ["[36]|4(?:2[09]|7[01])"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["2[2-9]|4|7[235-9]|9[49]"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["800"], "0$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1-$2-$3", ["[2579]|80"], "0$1"]], [null, null, "20\\d{8}", null, null, null, "2012345678", null, null, [10]], null, null, [null, null, "00(?:(?:37|66)\\d{4,11}|777(?:[01]|(?:5|8\\d)\\d)|882[1245]\\d\\d)\\d\\d"], [null, null, "570\\d{6}", null, null, null, "570123456", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KE: [null, [null, null, "(?:(?:2|80)0\\d?|[4-7]\\d\\d|900)\\d{6}|[4-6]\\d{6,7}", null, null, null, null, null, null, [7, 8, 9, 10]], [null, null, "20\\d{6,7}|(?:4[0-6]|5\\d|6[0-24-9])\\d{7}|(?:4[0245]|6[014-9])\\d{6}|5[1-79]\\d{5,6}|(?:4[245]|6[01457-9])\\d{5}", null, null, null, "202012345", null, null, [7, 8, 9]], [null, null, "7\\d{8}", null, null, null, "712123456", null, null, [9]], [null, null, "800[24-8]\\d{5,6}", null, null, null, "800223456", null, null, [9, 10]], [null, null, "900[02-9]\\d{5}", null, null, null, "900223456", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KE", 254, "000", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{5,7})", "$1 $2", ["[24-6]"], "0$1"], [null, "(\\d{3})(\\d{6})", "$1 $2", ["7"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[89]"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KG: [null, [null, null, "(?:[235-7]\\d|99)\\d{7}|800\\d{6,7}", null, null, null, null, null, null, [9, 10], [5, 6]], [null, null, "(?:3(?:1(?:[256]\\d|3[1-9]|47)|2(?:22|3[0-479]|6[0-7])|4(?:22|5[6-9]|6\\d)|5(?:22|3[4-7]|59|6\\d)|6(?:22|5[35-7]|6\\d)|7(?:22|3[468]|4[1-9]|59|[67]\\d)|9(?:22|4[1-8]|6\\d))|6(?:09|12|2[2-4])\\d)\\d{5}", null, null, null, "312123456", null, null, [9], [5, 6]], [null, null, "(?:2(?:0[0-35]|2\\d)|5[0-24-7]\\d|7(?:[07]\\d|55)|99[69])\\d{6}", null, null, null, "700123456", null, null, [9]], [null, null, "800\\d{6,7}", null, null, null, "800123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KG", 996, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[25-79]|31[25]"], "0$1"], [null, "(\\d{4})(\\d{5})", "$1 $2", ["3"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d)(\\d{2,3})", "$1 $2 $3 $4", ["8"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KH: [null, [null, null, "1\\d{9}|[1-9]\\d{7,8}", null, null, null, null, null, null, [8, 9, 10], [6, 7]], [null, null, "(?:2(?:3(?:4(?:[2-4]|[56]\\d)|[568]\\d\\d)|[4-6](?:4[56]|[56]\\d)\\d)|(?:3[2-6]|4[2-4]|[5-7][2-5])(?:4[56]|[56]\\d)\\d)\\d{4}|(?:2[3-6]|3[2-6]|4[2-4]|[5-7][2-5])[236-9]\\d{5}", null, null, null, "23756789", null, null, [8, 9], [6, 7]], [null, null, "(?:(?:(?:1[28]|9[67])\\d|8(?:[013-79]|8\\d))\\d|(?:2[3-6]|4[2-4]|[56][2-5])48|3(?:[18]\\d\\d|[2-6]48)|7(?:(?:[07-9]|[16]\\d)\\d|[2-5]48))\\d{5}|(?:1\\d|6[016-9]|9[0-57-9])\\d{6}", null, null, null, "91234567", null, null, [8, 9]], [null, null, "1800(?:1\\d|2[019])\\d{4}", null, null, null, "1800123456", null, null, [10]], [null, null, "1900(?:1\\d|2[09])\\d{4}", null, null, null, "1900123456", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KH", 855, "00[14-9]", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[1-9]"], "0$1"], [null, "(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KI: [null, [null, null, "(?:[37]\\d|6[0-79])\\d{6}|(?:[2-48]\\d|50)\\d{3}", null, null, null, null, null, null, [5, 8]], [null, null, "(?:[24]\\d|3[1-9]|50|65(?:02[12]|12[56]|22[89]|[3-5]00)|7(?:27\\d\\d|3100|5(?:02[12]|12[56]|22[89]|[34](?:00|81)|500))|8[0-5])\\d{3}", null, null, null, "31234"], [null, null, "(?:6(?:200[01]|30[01]\\d)|7(?:200[01]|3(?:0[0-5]\\d|140)))\\d{3}", null, null, null, "72001234", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "30(?:0[01]\\d\\d|12(?:11|20))\\d\\d", null, null, null, "30010000", null, null, [8]], "KI", 686, "00", "0", null, null, "0", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KM: [null, [null, null, "[3478]\\d{6}", null, null, null, null, null, null, [7]], [null, null, "7[4-7]\\d{5}", null, null, null, "7712345"], [null, null, "[34]\\d{6}", null, null, null, "3212345"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "8\\d{6}", null, null, null, "8001234"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KM", 269, "00", null, null, null, null, null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["[3478]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KN: [null, [null, null, "(?:[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "869(?:2(?:29|36)|302|4(?:6[015-9]|70))\\d{4}", null, null, null, "8692361234", null, null, null, [7]], [null, null, "869(?:5(?:5[6-8]|6[5-7])|66\\d|76[02-7])\\d{4}", null, null, null, "8697652917", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "KN", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "869", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KP: [null, [null, null, "(?:(?:19\\d|2)\\d|85)\\d{6}", null, null, null, null, null, null, [8, 10], [6, 7]], [null, null, "(?:2\\d|85)\\d{6}", null, null, null, "21234567", null, null, [8], [6, 7]], [null, null, "19[1-3]\\d{7}", null, null, null, "1921234567", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KP", 850, "00|99", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["2"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"], "0$1"], [null, "(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, "2(?:[0-24-9]\\d\\d|3(?:[0-79]\\d|8[02-9]))\\d{4}", null, null, null, null, null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KR: [null, [null, null, "(?:00[1-9]\\d{2,4}|[12]|5\\d{3})\\d{7}|(?:(?:00|[13-6])\\d|70)\\d{8}|(?:[1-6]\\d|80)\\d{7}|[3-6]\\d{4,5}", null, null, null, null, null, null, [5, 6, 8, 9, 10, 11, 12, 13, 14], [3, 7]], [null, null, "2[1-9]\\d{6,7}|(?:3[1-3]|[46][1-4]|5[1-5])(?:1\\d{2,3}|[1-9]\\d{6,7})", null, null, null, "22123456", null, null, [5, 6, 8, 9, 10], [3, 7]], [null, null, "1[0-26-9]\\d{7,8}", null, null, null, "1000000000", null, null, [9, 10]], [null, null, "(?:00(?:3(?:08|68\\d)|798\\d{1,3})|80\\d)\\d{6}", null, null, null, "801234567", null, null, [9, 11, 12, 13, 14]], [null, null, "60[2-9]\\d{6}", null, null, null, "602345678", null, null, [9]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "50\\d{8,9}", null, null, null, "5012345678", null, null, [10, 11]], [null, null, "70\\d{8}", null, null, null, "7012345678", null, null, [10]], "KR", 82, "00(?:[125689]|3(?:[46]5|91)|7(?:00|27|3|55|6[126]))", "0", null, null, "0(8[1-46-8]|85\\d{2})?", null, null, null, [[null, "(\\d{2})(\\d{3,4})", "$1-$2", ["(?:3[1-3]|[46][1-4]|5[1-5])1"], "0$1", "0$CC-$1"], [null, "(\\d{4})(\\d{4})", "$1-$2", ["1(?:5[246-9]|6[046-8]|8[03579])", "1(?:5(?:22|44|66|77|88|99)|6(?:[07]0|44|6[16]|88)|8(?:00|33|55|77|99))"], "$1", "0$CC-$1"], [null, "(\\d{5})", "$1", ["1[016-9]1", "1[016-9]11", "1[016-9]114"], "0$1", "0$CC-$1"], [null, "(\\d)(\\d{3,4})(\\d{4})", "$1-$2-$3", ["2[1-9]"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["60[2-9]|80"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{3,4})(\\d{4})", "$1-$2-$3", ["1[0-25-9]|(?:3[1-3]|[46][1-4]|5[1-5])[1-9]"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1-$2-$3", ["[57]0"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{5})(\\d{4})", "$1-$2-$3", ["50"], "0$1", "0$CC-$1"], [null, "(\\d{5})(\\d{3})(\\d{3})", "$1 $2 $3", ["003", "0030", "00308"], "$1", "0$CC-$1"], [null, "(\\d{5})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["00[37]", "00(?:36|79)", "00(?:36|79)8"], "$1", "0$CC-$1"], [null, "(\\d{5})(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3 $4", ["007", "0079", "00798"], "$1", "0$CC-$1"]], [[null, "(\\d{2})(\\d{3,4})", "$1-$2", ["(?:3[1-3]|[46][1-4]|5[1-5])1"], "0$1", "0$CC-$1"], [null, "(\\d{4})(\\d{4})", "$1-$2", ["1(?:5[246-9]|6[046-8]|8[03579])", "1(?:5(?:22|44|66|77|88|99)|6(?:[07]0|44|6[16]|88)|8(?:00|33|55|77|99))"], "$1", "0$CC-$1"], [null, "(\\d{5})", "$1", ["1[016-9]1", "1[016-9]11", "1[016-9]114"], "0$1", "0$CC-$1"], [null, "(\\d)(\\d{3,4})(\\d{4})", "$1-$2-$3", ["2[1-9]"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["60[2-9]|80"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{3,4})(\\d{4})", "$1-$2-$3", ["1[0-25-9]|(?:3[1-3]|[46][1-4]|5[1-5])[1-9]"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{4})(\\d{4})", "$1-$2-$3", ["[57]0"], "0$1", "0$CC-$1"], [null, "(\\d{2})(\\d{5})(\\d{4})", "$1-$2-$3", ["50"], "0$1", "0$CC-$1"]], [null, null, "15\\d{7,8}", null, null, null, "1523456789", null, null, [9, 10]], null, null, [null, null, "00(?:3(?:08|68\\d)|798\\d{1,3})\\d{6}", null, null, null, null, null, null, [11, 12, 13, 14]], [null, null, "1(?:5(?:22|44|66|77|88|99)|6(?:00|44|6[16]|70|88)|8(?:00|33|55|77|99))\\d{4}", null, null, null, "15441234", null, null, [8]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KW: [null, [null, null, "(?:18|[2569]\\d\\d)\\d{5}", null, null, null, null, null, null, [7, 8]], [null, null, "2(?:[23]\\d\\d|4(?:[1-35-9]\\d|44)|5(?:0[034]|[2-46]\\d|5[1-3]|7[1-7]))\\d{4}", null, null, null, "22345678", null, null, [8]], [null, null, "(?:5(?:(?:[05]\\d|1[0-7]|6[56])\\d|2(?:22|5[25]))|6(?:(?:0[034679]|5[015-9]|6\\d)\\d|222|7(?:0[013-9]|[67]\\d)|9(?:[069]\\d|3[039]))|9(?:(?:0[09]|22|4[01479]|55|6[0679]|8[057-9]|9\\d)\\d|11[01]|7(?:02|[1-9]\\d)))\\d{4}", null, null, null, "50012345", null, null, [8]], [null, null, "18\\d{5}", null, null, null, "1801234", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "KW", 965, "00", null, null, null, null, null, null, null, [[null, "(\\d{4})(\\d{3,4})", "$1 $2", ["[169]|2(?:[235]|4[1-35-9])|52"]], [null, "(\\d{3})(\\d{5})", "$1 $2", ["[25]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KY: [null, [null, null, "(?:345|[58]\\d\\d|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "345(?:2(?:22|44)|444|6(?:23|38|40)|7(?:4[35-79]|6[6-9]|77)|8(?:00|1[45]|25|[48]8)|9(?:14|4[035-9]))\\d{4}", null, null, null, "3452221234", null, null, null, [7]], [null, null, "345(?:32[1-9]|5(?:1[67]|2[5-79]|4[6-9]|50|76)|649|9(?:1[67]|2[2-9]|3[689]))\\d{4}", null, null, null, "3453231234", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002345678"], [null, null, "(?:345976|900[2-9]\\d\\d)\\d{4}", null, null, null, "9002345678"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "KY", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, "345849\\d{4}", null, null, null, "3458491234"], null, "345", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    KZ: [null, [null, null, "(?:33622|(?:7\\d|80)\\d{3})\\d{5}", null, null, null, null, null, null, [10]], [null, null, "(?:33622|7(?:1(?:0(?:[23]\\d|4[0-3]|59|63)|1(?:[23]\\d|4[0-79]|59)|2(?:[23]\\d|59)|3(?:2\\d|3[0-79]|4[0-35-9]|59)|4(?:[24]\\d|3[013-9]|5[1-9])|5(?:2\\d|3[1-9]|4[0-7]|59)|6(?:[2-4]\\d|5[19]|61)|72\\d|8(?:[27]\\d|3[1-46-9]|4[0-5]))|2(?:1(?:[23]\\d|4[46-9]|5[3469])|2(?:2\\d|3[0679]|46|5[12679])|3(?:[2-4]\\d|5[139])|4(?:2\\d|3[1-35-9]|59)|5(?:[23]\\d|4[0-246-8]|59|61)|6(?:2\\d|3[1-9]|4[0-4]|59)|7(?:[2379]\\d|40|5[279])|8(?:[23]\\d|4[0-3]|59)|9(?:2\\d|3[124578]|59))))\\d{5}", null, null, null, "7123456789"], [null, null, "7(?:0[0-2578]|47|6[02-4]|7[15-8]|85)\\d{7}", null, null, null, "7710009998"], [null, null, "800\\d{7}", null, null, null, "8001234567"], [null, null, "809\\d{7}", null, null, null, "8091234567"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "808\\d{7}", null, null, null, "8081234567"], [null, null, "751\\d{7}", null, null, null, "7511234567"], "KZ", 7, "810", "8", null, null, "8", null, "8~10", null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "33|7", [null, null, "751\\d{7}"], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LA: [null, [null, null, "(?:2\\d|3)\\d{8}|(?:[235-8]\\d|41)\\d{6}", null, null, null, null, null, null, [8, 9, 10], [6]], [null, null, "(?:2[13]|[35-7][14]|41|8[1468])\\d{6}", null, null, null, "21212862", null, null, [8], [6]], [null, null, "20(?:2[2389]|5[24-689]|7[6-8]|9[1-35-9])\\d{6}", null, null, null, "2023123456", null, null, [10]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "LA", 856, "00", "0", null, null, "0", null, null, null, [[null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["2[13]|3[14]|[4-8]"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["3"], "0$1"], [null, "(\\d{2})(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["2"], "0$1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "30\\d{7}", null, null, null, "301234567", null, null, [9]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LB: [null, [null, null, "[7-9]\\d{7}|[13-9]\\d{6}", null, null, null, null, null, null, [7, 8]], [null, null, "(?:(?:[14-69]\\d|8[02-9])\\d|7(?:[2-57]\\d|62|8[0-7]|9[04-9]))\\d{4}", null, null, null, "1123456", null, null, [7]], [null, null, "(?:(?:3|81)\\d|7(?:[01]\\d|6[013-9]|8[89]|9[1-3]))\\d{5}", null, null, null, "71123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "9[01]\\d{6}", null, null, null, "90123456", null, null, [8]], [null, null, "80\\d{6}", null, null, null, "80123456", null, null, [8]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "LB", 961, "00", "0", null, null, "0", null, null, null, [[null, "(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[13-69]|7(?:[2-57]|62|8[0-7]|9[04-9])|8[02-9]"], "0$1"], [null, "(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[7-9]"]]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LC: [null, [null, null, "(?:[58]\\d\\d|758|900)\\d{7}", null, null, null, null, null, null, [10], [7]], [null, null, "758(?:4(?:30|5\\d|6[2-9]|8[0-2])|57[0-2]|638)\\d{4}", null, null, null, "7584305678", null, null, null, [7]], [null, null, "758(?:28[4-7]|384|4(?:6[01]|8[4-9])|5(?:1[89]|20|84)|7(?:1[2-9]|2\\d|3[01]))\\d{4}", null, null, null, "7582845678", null, null, null, [7]], [null, null, "8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", null, null, null, "8002123456"], [null, null, "900[2-9]\\d{6}", null, null, null, "9002123456"], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "5(?:00|2[12]|33|44|66|77|88)[2-9]\\d{6}", null, null, null, "5002345678"], [null, null, null, null, null, null, null, null, null, [-1]], "LC", 1, "011", "1", null, null, "1", null, null, null, null, null, [null, null, null, null, null, null, null, null, null, [-1]], null, "758", [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]]],
    LI: [null, [null, null, "(?:(?:[2378]|6\\d\\d)\\d|90)\\d{5}", null, null, null, null, null, null, [7, 9]], [null, null, "(?:2(?:01|1[27]|3\\d|6[02-578]|96)|3(?:7[0135-7]|8[048]|9[0269]))\\d{4}", null, null, null, "2345678", null, null, [7]], [null, null, "(?:6(?:5(?:09|1\\d|20)|6(?:0[0-6]|10|2[06-9]|39))\\d|7(?:[37-9]\\d|42|56))\\d{4}", null, null, null, "660234567"], [null, null, "80(?:02[28]|9\\d\\d)\\d\\d", null, null, null, "8002222", null, null, [7]], [null, null, "90(?:02[258]|1(?:23|3[14])|66[136])\\d\\d", null, null, null, "9002222", null, null, [7]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], [null, null, null, null, null, null, null, null, null, [-1]], "LI", 423, "00", "0", null, null, "0|(10(?:01|20|66))", null, null, null, [[null, "(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["[237-9]"], null, "$CC $1"], [null, "(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["6[56]"], null, "$CC $1"], [null, "(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["6"], null, "$CC $1"]], null, [null, null, null, null, null, null, null, null, null, [-1]], null, null, [null, null, null, null, null, null, null, null, null, [-1]], [null, null, "870(?:28|87)\\d\\d", null, null, null, "8702812", null, null, [7]], null, null, [null, null, "697(?:42|56|[78]\\d)\\d{4}", null, null, null, "697861234", null, null, [9]]],
    LK: [null, [null, null, "(?:[1-7]\\d|[89]1)\\d{7}", null, null, null, null, null, null, [9], [7]], [null, null, "(?:[189]1|2[13-7]|3[1-8]|4[157]|5[12457]|6[35-7])[2-57]\\d{6}", null, null, null, "112345678", null, null, null, [7]], [null, null, "7[0-25-8]\