# Documentation

## Structure

Technical documentation for Duplicator Pro - a premium WordPress plugin for website backups, migrations, and cloning.

## Documentation Files

### 1. Architecture
- **[01_1_ARCH_overview.md](01_1_ARCH_overview.md)** - System overview, core concepts, and technology stack

### 2. Package Creation
- **[02_1_PACKAGE_build-process.md](02_1_PACKAGE_build-process.md)** - Package build process, database export, and archive creation

### 3. User Interface
- **[03_1_UI_mvc-templates.md](03_1_UI_mvc-templates.md)** - Admin pages, MVC pattern, controllers, and template system

### 4. Storage System
- **[04_1_STORAGE_providers.md](04_1_STORAGE_providers.md)** - Storage providers and upload flow

### 5. Installer
- **[05_1_INSTALLER_restoration.md](05_1_INSTALLER_restoration.md)** - Standalone installer and restoration process

### 6. Security
- **[06_1_SECURITY_practices.md](06_1_SECURITY_practices.md)** - Input validation, capabilities, nonces, and SQL injection prevention

### 7. Development Utilities
- **[07_1_DEV_chunking-system.md](07_1_DEV_chunking-system.md)** - Chunking system, persistence adapters, and resumable operations

### 99. Appendix
- **[99_1_APPENDIX_doc-writing-guide.md](99_1_APPENDIX_doc-writing-guide.md)** - Standards for writing verifiable documentation
- **[99_2_APPENDIX_write-tests-guide.md](99_2_APPENDIX_write-tests-guide.md)** - Test writing standards and best practices
