<?php

// SPDX-FileCopyrightText: 2018-2026 Ovation S.r.l. <help@dynamic.ooo>
// SPDX-License-Identifier: GPL-3.0-or-later
namespace DynamicContentForElementor\JsLocalization;

if (!\defined('ABSPATH')) {
    exit;
}
/**
 * Custom Editor Localized Strings
 *
 * Provides translatable strings for the Custom Editor JavaScript components.
 */
class CustomEditor extends \DynamicContentForElementor\JsLocalization\Base
{
    /** @var string */
    protected static string $script_handle = 'dce-custom-editor-app';
    /** @var string */
    protected static string $js_object_name = 'dceCustomEditorStrings';
    /**
     * Get all localized strings for the custom editor
     *
     * @return array<string,string>
     */
    protected static function get_strings() : array
    {
        return [
            // Dialog labels
            'detectedFormat' => __('Detected format:', 'dynamic-content-for-elementor'),
            'alternativeFormats' => __('Also possible:', 'dynamic-content-for-elementor'),
            'isFormatCorrect' => __('Is this format correct?', 'dynamic-content-for-elementor'),
            'analyzed' => __('analyzed', 'dynamic-content-for-elementor'),
            'samples' => __('samples', 'dynamic-content-for-elementor'),
            // Dialog header
            'dialogHeader' => __('Auto-Detect Date Format', 'dynamic-content-for-elementor'),
            // Dialog buttons
            'yesApply' => __('Yes, apply it', 'dynamic-content-for-elementor'),
            'noManual' => __("No, I'll enter manually", 'dynamic-content-for-elementor'),
            // Toast messages
            'selectMetaFirst' => __('Please select a meta field first', 'dynamic-content-for-elementor'),
            'analyzingFormat' => __('Analyzing date format...', 'dynamic-content-for-elementor'),
            'formatApplied' => __('Format "%s" applied automatically', 'dynamic-content-for-elementor'),
            'enterManually' => __('Please enter format manually', 'dynamic-content-for-elementor'),
            'couldNotDetect' => __('Could not auto-detect date format.', 'dynamic-content-for-elementor'),
            'couldNotDetectFor' => __('Could not detect format for value:', 'dynamic-content-for-elementor'),
            'pleaseEnterManually' => __('Please enter manually.', 'dynamic-content-for-elementor'),
        ];
    }
}
