<?php

// SPDX-FileCopyrightText: 2018-2026 Ovation S.r.l. <help@dynamic.ooo>
// SPDX-License-Identifier: GPL-3.0-or-later
namespace DynamicContentForElementor\PageSettings;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use DynamicContentForElementor\Helper;
if (!\defined('ABSPATH')) {
    exit;
    // Exit if accessed directly
}
class PageScroll extends \DynamicContentForElementor\PageSettings\PageSettingPrototype
{
    public $name = 'Scrolling';
    protected $is_common = \true;
    public function get_script_depends()
    {
        return ['imagesloaded', 'dce-velocity', 'dce-inertia-scroll', 'jquery-easing', 'dce-scrollify', 'dce-lax-lib', 'dce-scrolling'];
    }
    public function get_style_depends()
    {
        return ['dce-pageScroll'];
    }
    protected function add_common_sections_actions()
    {
        // Activate sections for document
        add_action('elementor/documents/register_controls', function ($element) {
            $this->add_common_sections($element);
        }, 10, 1);
    }
    private function add_controls($document, $args)
    {
        $document->add_control('enable_dceScrolling', ['label' => esc_html__('Scrolling settings', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'render_type' => 'template', 'frontend_available' => \true]);
        $document->add_control('scroll_id_page', ['label' => esc_html__('ID Page', 'dynamic-content-for-elementor'), 'type' => \Elementor\Controls_Manager::HIDDEN, 'default' => Helper::get_the_id(), 'frontend_available' => \true, 'condition' => ['enable_dceScrolling!' => '']]);
        // ----------------------------------- EFFECTS --------------------------
        $document->add_control('enable_scrollEffects', ['label' => esc_html__('Effects Scroll', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'render_type' => 'template', 'frontend_available' => \true, 'separator' => 'before', 'condition' => ['enable_dceScrolling!' => '']]);
        $document->add_control('animation_effects', ['label' => esc_html__('Animation Effects', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SELECT2, 'multiple' => \true, 'label_block' => \true, 'options' => ['' => esc_html__('None', 'dynamic-content-for-elementor'), 'scaleDown' => esc_html__('Scale Down', 'dynamic-content-for-elementor'), 'opacity' => esc_html__('Opacity', 'dynamic-content-for-elementor'), 'fixed' => esc_html__('Fixed', 'dynamic-content-for-elementor'), 'rotation' => esc_html__('Rotation', 'dynamic-content-for-elementor'), 'lazy' => esc_html__('Lazy', 'dynamic-content-for-elementor'), 'eager' => esc_html__('Eger', 'dynamic-content-for-elementor'), 'slalom' => esc_html__('Slalom', 'dynamic-content-for-elementor'), 'spin' => esc_html__('Spin', 'dynamic-content-for-elementor'), 'spinRev' => esc_html__('Spin Rev', 'dynamic-content-for-elementor'), 'driftLeft' => esc_html__('Drift Left', 'dynamic-content-for-elementor'), 'driftRight' => esc_html__('Drift Right', 'dynamic-content-for-elementor'), 'leftToRight' => esc_html__('Left To Right', 'dynamic-content-for-elementor'), 'rightToLeft' => esc_html__('Right To Left', 'dynamic-content-for-elementor'), 'zoomInOut' => esc_html__('Zoom In Out', 'dynamic-content-for-elementor'), 'zoomIn' => esc_html__('Zoom In', 'dynamic-content-for-elementor'), 'zoomOut' => esc_html__('Zoom Out', 'dynamic-content-for-elementor'), 'swing' => esc_html__('Swing', 'dynamic-content-for-elementor'), 'speedy' => esc_html__('Speedy', 'dynamic-content-for-elementor')], 'default' => ['scaleDown'], 'frontend_available' => \true, 'render_type' => 'template', 'condition' => ['enable_scrollEffects!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('remove_first_scrollEffects', ['label' => esc_html__('Remove Effect on first row', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'render_type' => 'template', 'frontend_available' => \true, 'condition' => ['enable_scrollEffects!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('custom_class_section', ['label' => esc_html__('Custom section class', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => '', 'frontend_available' => \true, 'separator' => 'before', 'dynamic' => ['active' => \false], 'condition' => ['enable_scrollEffects!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('responsive_scrollEffects', ['label' => esc_html__('Apply Scroll Effects', 'dynamic-content-for-elementor'), 'description' => esc_html__('Responsive mode will take place on preview or live pages only, not while editing in Elementor.', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SELECT2, 'multiple' => \true, 'separator' => 'before', 'label_block' => \true, 'options' => \array_combine(Helper::get_active_devices_list(), Helper::get_active_devices_list()), 'default' => ['desktop', 'tablet', 'mobile'], 'frontend_available' => \true, 'render_type' => 'template', 'condition' => ['enable_dceScrolling!' => '', 'enable_scrollEffects!' => '']]);
        // ----------------------------------- SNAP --------------------------
        $document->add_control('enable_scrollify', ['label' => esc_html__('Snap Scroll', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'frontend_available' => \true, 'separator' => 'before', 'condition' => ['enable_dceScrolling!' => '']]);
        $document->add_control('custom_class_section_sfy', ['label' => esc_html__('Custom section class', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => '', 'frontend_available' => \true, 'label_block' => \true, 'dynamic' => ['active' => \false], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('interstitialSection', ['label' => esc_html__('Interstitial Section', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::TEXT, 'placeholder' => 'header, footer', 'frontend_available' => \true, 'label_block' => \true, 'dynamic' => ['active' => \false], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('scrollSpeed', ['label' => esc_html__('Scroll Speed', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'default' => ['size' => 1000], 'range' => ['px' => ['min' => 500, 'max' => 2400, 'step' => 10]], 'size_units' => ['ms'], 'frontend_available' => \true, 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('offset', ['label' => esc_html__('Offset', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'default' => ['size' => 0], 'range' => ['px' => ['min' => -500, 'max' => 500, 'step' => 1]], 'size_units' => ['px'], 'frontend_available' => \true, 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('setHeights', ['label' => esc_html__('Set section height to full screen', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'frontend_available' => \true, 'default' => 'yes', 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('overflowScroll', ['label' => esc_html__('Overflow Scroll', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'frontend_available' => \true, 'default' => 'yes', 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('updateHash', ['label' => esc_html__('Update Hash', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'frontend_available' => \true, 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('scrollBars', ['label' => esc_html__('Show scrollbar', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes', 'frontend_available' => \true, 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('touchScroll', ['label' => esc_html__('Touch Scroll', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes', 'frontend_available' => \true, 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('enable_scrollify_nav', ['label' => esc_html__('Enable navigation', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes', 'frontend_available' => \true, 'render_type' => 'template', 'separator' => 'before', 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '']]);
        $document->add_control('snapscroll_nav_style', ['label' => esc_html__('Navigation style', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SELECT, 'default' => 'default', 'options' => [
            'default' => esc_html__('Dynamic', 'dynamic-content-for-elementor'),
            // the one that already exists, similar to Maxamed
            'shamso' => esc_html__('Dots', 'dynamic-content-for-elementor'),
            // Shamso
            'xusni' => esc_html__('Bars', 'dynamic-content-for-elementor'),
            // Xusni oppure Beca
            'etefu' => esc_html__('Vertical Bars', 'dynamic-content-for-elementor'),
            // Etefu
            'magool' => esc_html__('Lines (without title)', 'dynamic-content-for-elementor'),
            // Magool
            'ubax' => esc_html__('Squares', 'dynamic-content-for-elementor'),
            // Ubax
            'timiro' => esc_html__('Circles', 'dynamic-content-for-elementor'),
            // Timiro
            'ayana' => esc_html__('Circles line (SVG)', 'dynamic-content-for-elementor'),
            // Ayana
            'desta' => esc_html__('Triangles', 'dynamic-content-for-elementor'),
            // Desta
            'totit' => esc_html__('Icons', 'dynamic-content-for-elementor'),
        ], 'render_type' => 'template', 'frontend_available' => \true, 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '']]);
        $document->add_control('snapscroll_nav_title_style', ['label' => esc_html__('Show section\'s title', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SELECT, 'separator' => 'before', 'default' => 'none', 'options' => ['none' => esc_html__('None', 'dynamic-content-for-elementor'), 'number' => esc_html__('Number', 'dynamic-content-for-elementor'), 'classid' => esc_html__('Section CSS ID', 'dynamic-content-for-elementor')], 'frontend_available' => \true, 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style!' => ['magool', 'timiro']]]);
        $document->add_control('sectionid_info', ['label' => esc_html__('Section class-id info', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::RAW_HTML, 'show_label' => \false, 'default' => '', 'raw' => esc_html__('You should write the class ID on the sections first and then apply this option to see the result. The name on the ID must not contain spaces or use (-) or (_) to separate words, in the result they will be converted into spaces.', 'dynamic-content-for-elementor'), 'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning', 'separator' => 'after', 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_title_style' => 'classid']]);
        $document->add_group_control(Group_Control_Typography::get_type(), ['name' => 'nav_title_typography', 'label' => esc_html__('Title Typography', 'dynamic-content-for-elementor'), 'selector' => '{{WRAPPER}} .nav__item-title', 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_title_style!' => 'none']]);
        $document->add_control('nav_title_color', ['label' => esc_html__('Title Color', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::COLOR, 'default' => '', 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination .nav__item--current .nav__item-title' => 'color: {{VALUE}}'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_title_style!' => 'none']]);
        $document->add_control('scrollify_nav_icon', ['label' => esc_html__('Icon', 'dynamic-content-for-elementor'), 'type' => 'icons', 'default' => ['value' => 'fas fa-star', 'library' => 'solid'], 'frontend_available' => \true, 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'totit']]);
        $document->add_responsive_control('scrollify_nav_size', ['label' => esc_html__('Size', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'separator' => 'before', 'default' => ['size' => 10], 'range' => ['px' => ['min' => 0, 'max' => 80, 'step' => 1]], 'size_units' => ['px'], 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a:after, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--magool .nav__item, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--shamso .nav__item, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--xusni .nav__item, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--etefu .nav__item, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--ayana .nav__item,
					{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--totit .nav__item,
					{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--totit .nav__item-title,.dce-scrollify-pagination.nav--ubax .nav__item,
					{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--desta .nav__icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--totit .nav__item .fas' => 'font-size: {{SIZE}}{{UNIT}};', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--desta .nav__item-title' => 'padding-right: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--totit .nav__item-title,.dce-scrollify-pagination.nav--ubax .nav__item-title' => 'right: {{SIZE}}{{UNIT}};'], 'render-type' => 'ui', 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '']]);
        $document->add_responsive_control('scrollify_nav_iconsize', ['label' => esc_html__('Icon size', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'size_units' => ['px', 'em', 'rem', 'vw', 'custom'], 'range' => ['px' => ['min' => 0, 'max' => 80, 'step' => 1], 'em' => ['min' => 0, 'max' => 10], 'rem' => ['min' => 0, 'max' => 10]], 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--totit .nav__item .fas' => 'font-size: {{SIZE}}{{UNIT}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'totit']]);
        $document->add_responsive_control('scrollify_nav_space', ['label' => esc_html__('Space', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'default' => ['size' => 10], 'range' => ['px' => ['min' => 0, 'max' => 100, 'step' => 1]], 'size_units' => ['px'], 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination li:not(first-child)' => 'padding-top: {{SIZE}}{{UNIT}}'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '']]);
        $document->add_responsive_control('scrollify_nav_side', ['label' => esc_html__('Side space', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'default' => ['size' => 10, 'unit' => 'px'], 'size_units' => ['px', '%', 'vw'], 'range' => ['px' => ['min' => 0, 'max' => 80, 'step' => 1], '%' => ['min' => 0, 'max' => 100, 'step' => 1], 'vw' => ['min' => 0, 'max' => 100, 'step' => 1]], 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination' => 'right: {{SIZE}}{{UNIT}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '']]);
        $document->add_control('scrollify_nav_style_color', ['label' => esc_html__('Color', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::COLOR, 'separator' => 'before', 'default' => '', 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--shamso .nav__item::before, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--xusni .nav__item::before, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--etefu .nav__item-inner, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--magool .nav__item::after, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--ubax .nav__item::after, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--timiro .nav__item, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--totit .nav__item::before' => 'background: {{VALUE}};', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--shamso .nav__item::after' => 'box-shadow: inset 0 0 0 3px {{VALUE}};', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--ayana .nav__icon' => 'stroke: {{VALUE}};', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--desta .nav__icon' => 'fill: {{VALUE}}', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--totit .nav__item--current .fas' => 'color: {{VALUE}}'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style!' => 'default']]);
        $document->add_control('scrollify_nav_style_active_color', ['label' => esc_html__('Active Color', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::COLOR, 'separator' => 'before', 'default' => '', 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--shamso .nav__item--current::after' => 'box-shadow: inset 0 0 0 3px {{VALUE}};', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--xusni .nav__item--current::before' => 'background-color: {{VALUE}};', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination .nav__item--current' => 'color: {{VALUE}};', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--ubax .nav__item--current::after' => 'border-color: {{VALUE}}', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--etefu .nav__item-inner::before, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--magool .nav__item--current::after,
					{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--ubax .nav__item--current::after,
					{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--ubax .nav__item:not(.nav__item--current):focus::after, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--ubax .nav__item:not(.nav__item--current):hover::after, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--timiro .nav__item::before, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--ayana .nav__item::before' => 'background-color: {{VALUE}};', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--desta .nav__item--current .nav__icon, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--desta .nav__item:not(.nav__item--current):focus .nav__icon, {{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--desta .nav__item:not(.nav__item--current):hover .nav__icon ' => 'fill: {{VALUE}};', '{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--totit .nav__item--current .fas' => 'color: {{VALUE}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style!' => 'default']]);
        $document->add_control('scrollify_nav_style_active_bordercolor', ['label' => esc_html__('Active Border Color', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::COLOR, 'separator' => 'before', 'default' => '', 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--ubax .nav__item--current::after' => 'border-color: {{VALUE}}'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'ubax']]);
        $document->start_controls_tabs('nav_colors');
        $document->start_controls_tab('nav_colors_normal', ['label' => esc_html__('Normal', 'dynamic-content-for-elementor'), 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->add_control('scrollify_nav_bgcolor', ['label' => esc_html__('Color', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::COLOR, 'default' => '', 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a:after' => 'background-color: {{VALUE}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->add_control('scrollify_nav_color', ['label' => esc_html__('Border color', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::COLOR, 'default' => '#444444', 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a:after' => 'border-color: {{VALUE}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->add_control('scrollify_nav_border_size', ['label' => esc_html__('Border size', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'default' => ['size' => ''], 'range' => ['px' => ['min' => 0, 'max' => 20, 'step' => 1]], 'size_units' => ['px'], 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a:after' => 'border-width: {{SIZE}}{{UNIT}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->end_controls_tab();
        $document->start_controls_tab('nav_colors_hover', ['label' => esc_html__('Hover', 'dynamic-content-for-elementor'), 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->add_control('scrollify_nav_bgcolor_hover', ['label' => esc_html__('Color', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::COLOR, 'default' => '', 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a:hover:after' => 'background-color: {{VALUE}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->add_control('scrollify_nav_color_hover', ['label' => esc_html__('Border color', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::COLOR, 'default' => '', 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a:hover:after' => 'border-color: {{VALUE}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->add_responsive_control('scrollify_nav_hover_size', ['label' => esc_html__('Size (&)', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'default' => ['size' => ''], 'range' => ['px' => ['min' => 0, 'max' => 10, 'step' => 0.1]], 'size_units' => ['px'], 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a:hover:after' => 'transform: scale({{SIZE}});'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->add_control('scrollify_nav_border_hover_size', ['label' => esc_html__('Border size', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'default' => ['size' => ''], 'range' => ['px' => ['min' => 0, 'max' => 20, 'step' => 1]], 'size_units' => ['px'], 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a:hover:after' => 'border-width: {{SIZE}}{{UNIT}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->end_controls_tab();
        $document->start_controls_tab('nav_colors_active', ['label' => esc_html__('Active', 'dynamic-content-for-elementor'), 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->add_control('scrollify_nav_bgcolor_active', ['label' => esc_html__('Color', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::COLOR, 'default' => '', 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a.nav__item--current:after' => 'background-color: {{VALUE}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->add_control('scrollify_nav_color_active', ['label' => esc_html__('Border color', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::COLOR, 'default' => '', 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a.nav__item--current:after' => 'border-color: {{VALUE}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->add_responsive_control('scrollify_nav_active_size', ['label' => esc_html__('Size (%)', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'default' => ['size' => ''], 'range' => ['px' => ['min' => 0, 'max' => 10, 'step' => 0.1]], 'size_units' => ['px'], 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a.nav__item--current:after' => 'transform: scale({{SIZE}});'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->add_control('scrollify_nav_border_active_size', ['label' => esc_html__('Border size', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'default' => ['size' => ''], 'range' => ['px' => ['min' => 0, 'max' => 20, 'step' => 1]], 'size_units' => ['px'], 'selectors' => ['{{WRAPPER}}.dce-scrollify .dce-scrollify-pagination.nav--default a.nav__item--current:after' => 'border-width: {{SIZE}}{{UNIT}};'], 'condition' => ['enable_scrollify!' => '', 'enable_dceScrolling!' => '', 'enable_scrollify_nav!' => '', 'snapscroll_nav_style' => 'default']]);
        $document->end_controls_tab();
        $document->end_controls_tabs();
        $document->add_control('responsive_snapScroll', ['label' => esc_html__('Apply Snap Scroll on', 'dynamic-content-for-elementor'), 'description' => esc_html__('Responsive mode will take place on preview or live pages only, not while editing in Elementor.', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SELECT2, 'multiple' => \true, 'separator' => 'before', 'label_block' => \true, 'options' => \array_combine(Helper::get_active_devices_list(), Helper::get_active_devices_list()), 'default' => ['desktop', 'tablet', 'mobile'], 'frontend_available' => \true, 'render_type' => 'template', 'condition' => ['enable_dceScrolling!' => '', 'enable_scrollify!' => '']]);
        // ----------------------------------- INERTIA --------------------------
        $document->add_control('enable_inertiaScroll', ['label' => esc_html__('Inertia Scroll', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'separator' => 'before', 'frontend_available' => \true, 'condition' => ['enable_dceScrolling!' => '']]);
        $document->add_control('scroll_info', ['label' => esc_html__('Settings Scroll', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::RAW_HTML, 'show_label' => \false, 'default' => '', 'raw' => esc_html__('Scrolling management compromises various elements of the page (not just Elementor). In order to function correctly and obtain the transformations, it is necessary to indicate the CSS selectors of the theme used. By default we indicate the elements for OceanWP theme.', 'dynamic-content-for-elementor'), 'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning', 'separator' => 'after', 'condition' => ['enable_dceScrolling!' => '', 'enable_inertiaScroll!' => '']]);
        $document->add_control('automatic_wrapper', ['label' => esc_html__('Automatic Wrapper', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SWITCHER, 'frontend_available' => \true, 'render_type' => 'template', 'condition' => ['enable_dceScrolling!' => '', 'enable_inertiaScroll!' => '']]);
        $document->add_control('scroll_viewport', ['label' => esc_html__('Viewport', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => '#outer-wrap', 'frontend_available' => \true, 'dynamic' => ['active' => \false], 'condition' => ['enable_dceScrolling!' => '', 'enable_inertiaScroll!' => '', 'automatic_wrapper' => '']]);
        $document->add_control('scroll_contentScroll', ['label' => esc_html__('Content Scroll', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => '#wrap', 'frontend_available' => \true, 'dynamic' => ['active' => \false], 'condition' => ['enable_dceScrolling!' => '', 'enable_inertiaScroll!' => '', 'automatic_wrapper' => '']]);
        $document->add_control('coefSpeed_inertiaScroll', ['label' => esc_html__('Speed coefficient', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'separator' => 'before', 'default' => ['size' => '0.05'], 'range' => ['px' => ['max' => 0.5, 'min' => 0, 'step' => 0.01]], 'frontend_available' => \true, 'condition' => ['enable_dceScrolling!' => '', 'enable_inertiaScroll!' => '']]);
        $document->add_control('bounce_inertiaScroll', ['label' => esc_html__('Bounce', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'default' => ['size' => '0'], 'range' => ['px' => ['max' => 0.8, 'min' => 0, 'step' => 0.01]], 'frontend_available' => \true, 'condition' => ['enable_dceScrolling!' => '', 'enable_inertiaScroll!' => '']]);
        $document->add_control('skew_inertiaScroll', ['label' => esc_html__('Skew', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SLIDER, 'default' => ['size' => '10'], 'range' => ['px' => ['max' => 20, 'min' => 0, 'step' => 1]], 'frontend_available' => \true, 'condition' => ['enable_dceScrolling!' => '', 'enable_inertiaScroll!' => '']]);
        $document->add_control('directionScroll', ['label' => esc_html__('Scroll Direction', 'dynamic-content-for-elementor'), 'type' => \Elementor\Controls_Manager::SELECT, 'default' => 'vertical', 'options' => ['vertical' => esc_html__('Vertical', 'dynamic-content-for-elementor'), 'horizontal' => esc_html__('Horizontal', 'dynamic-content-for-elementor')], 'frontend_available' => \true, 'condition' => ['enable_dceScrolling!' => '', 'enable_inertiaScroll!' => '']]);
        $document->add_control('responsive_inertiaScroll', ['label' => esc_html__('Apply Inertia Scroll on', 'dynamic-content-for-elementor'), 'description' => esc_html__('Responsive mode will take place on preview or live pages only, not while editing in Elementor.', 'dynamic-content-for-elementor'), 'type' => Controls_Manager::SELECT2, 'multiple' => \true, 'separator' => 'before', 'label_block' => \true, 'options' => \array_combine(Helper::get_active_devices_list(), Helper::get_active_devices_list()), 'default' => ['desktop'], 'frontend_available' => \true, 'render_type' => 'template', 'condition' => ['enable_dceScrolling!' => '', 'enable_inertiaScroll!' => '']]);
    }
    protected function add_actions()
    {
        add_action('elementor/element/wp-post/section_dce_document_scroll/before_section_end', function ($element, $args) {
            $this->add_controls($element, $args);
        }, 10, 2);
        add_action('elementor/element/wp-page/section_dce_document_scroll/before_section_end', function ($element, $args) {
            $this->add_controls($element, $args);
        }, 10, 2);
        add_action('elementor/element/page/section_dce_document_scroll/before_section_end', function ($element, $args) {
            $this->add_controls($element, $args);
        }, 10, 2);
        add_action('elementor/element/section/section_dce_document_scroll/before_section_end', function ($element, $args) {
            $this->add_controls($element, $args);
        }, 10, 2);
        add_action('elementor/frontend/after_enqueue_scripts', function () {
            $post_id = isset($_GET['post']) ? absint($_GET['post']) : get_the_ID();
            $settings = get_post_meta($post_id, '_elementor_page_settings', \true);
            if (empty($settings) || !\is_array($settings)) {
                return;
            }
            if (!empty($settings['enable_dceScrolling'])) {
                $this->enqueue_all();
            }
        });
    }
}
