jQuery(function () {
	jQuery(document).ready(function ($) {
		function filterExamples(query) {
			var rows = document.querySelectorAll(".dynamic-shortcodes-demo tr");
			var getText = function (el) {
				return el.getAttribute("data-tags") || "";
			};
			var toggle = function (el, visible) {
				el.style.display = visible ? "" : "none";
			};
			window.DSHFilters.applyFilter(rows, query, getText, toggle, function () {
				updateRowColors();
			});
		}

		function updateRowColors() {
			jQuery(".dynamic-shortcodes-demo tr").removeClass(
				"odd-row even-row",
			);
			var rows = document.querySelectorAll(
				".dynamic-shortcodes-demo > table > tbody > tr",
			);
			var i = 1;
			Array.prototype.forEach.call(rows, function (row) {
				if (row.style.display === "none") {
					return;
				}
				row.classList.add(i % 2 === 0 ? "odd-row" : "even-row");
				i++;
			});
		}

		$("#tagSearch").on("keyup", function () {
			filterExamples($(this).val());
		});

		$(".quick-search-tag").on("click", function () {
			var tag = $(this).data("tag");
			$("#tagSearch").val(tag);
			filterExamples(tag);
		});
	});
});
