<?php

// SPDX-FileCopyrightText: 2022-2025 Ovation S.r.l. <help@dynamic.ooo>
// SPDX-License-Identifier: LicenseRef-GPL-3.0-with-dynamicooo-additional-terms
namespace DynamicShortcodes\Core\Demo\Types;

use DynamicShortcodes\Core\Demo\BaseDemo;

class Acpt extends BaseDemo {

	/**
	 * @var string
	 */
	protected $type = 'acpt';

	/**
	 * Get Description
	 *
	 * @return string
	 */
	public function get_description() {
		// translators: 1 is a page title
		$message = esc_html__( 'This shortcode is useful for retrieving ACPT Fields. In this example we show you all the custom fields available on the page %1$s.', 'dynamic-shortcodes' );
		return sprintf( $message, '"' . get_the_title() . '"' );
	}

	/**
	 * Get First Steps Examples
	 *
	 * @return string
	 */
	public function get_first_steps_examples() {
		/* translators: 1: syntax example with field name, 2: placeholder for field name, 3: syntax example with @ID, 4: syntax example combining field name with @ID=VALUE, where VALUE is an example post ID. */
		$format = esc_html__( 'To use the syntax, you should write %1$s where %2$s represents the name of a specific box name, %3$s represents the name of a specific field you wish to select from the current post. If you want to select a specific post, you can use %4$s followed by the post\'s identification number. For example, combining box name and field name with post ID, writing %5$s will retrieve the fields related to the post with ID %6$d.', 'dynamic-shortcodes' );

		$example_post_id = 200;
		$field_name      = 'field-name';
		$box_name        = 'box-name';
		return sprintf( $format, self::escape_code( '<code>{' . $this->type . ':' . $box_name . ' ' . $field_name . '}</code>' ), '<code>' . $box_name . '</code>', '<code>' . $field_name . '</code>', '<code>@ID</code>', '<code>' . self::escape_code( '{' . $this->type . ':' . $box_name . ' ' . $field_name . ' @ID=' . $example_post_id . '}' ) . '</code>', $example_post_id );
	}

	/**
	 * Generate sample ID
	 *
	 * @return array<string,string>
	 */
	public function generate_sample_id() {
		return [];
	}
}
