<?php

// SPDX-FileCopyrightText: 2022-2025 Ovation S.r.l. <help@dynamic.ooo>
// SPDX-License-Identifier: LicenseRef-GPL-3.0-with-dynamicooo-additional-terms
namespace DynamicShortcodes\Core\Settings\AdminPages;

use DynamicShortcodes\Plugin;
use DSHDeps\DynamicOOO\PluginUtils\AdminPages\Pages\Base;

class Demo extends Base {

	public function init() {
		add_action( 'wp_ajax_dsh_get_posts', [ $this, 'get_posts_ajax_callback' ] );
	}

	public function render_content() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die();
		}
		add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_admin_scripts' ] );
		$demo_manager = Plugin::instance()->demo_manager;
		$preview_post = null;
		if ( isset( $_GET['demos_post_id'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			$preview_post = get_post( $_GET['demos_post_id'] ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		} else {
			$preview_post = get_posts( [ 'posts_per_page' => 1 ] )[0] ?? null;
		}
		if ( $preview_post ) {
			$GLOBALS['post'] = $preview_post; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
			setup_postdata( $GLOBALS['post'] );
		}
		echo '<div class="wrap dynamic-shortcodes-demo">';

		echo '<ul id=demo-tabs-bar>';
		foreach ( $demo_manager->get_backend_types() as $type ) {
			$class         = $demo_manager->check_plugin_depends( $type ) ? 'disabled' : 'enabled';
			$show_selector = $demo_manager->should_show_preview_post_selector( $type ) ? 'yes' : 'no';
			//phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			echo "<li class=$class><a href='#tab-$type' data-show-post-selector=$show_selector>$type</a></li>";
		}
		echo '</ul>';
		echo '<div class="content-wrapper">';
		echo '<div class="dynamic-shortcodes-demo-tab">';
		$this->render_select2( $preview_post );
		foreach ( $demo_manager->get_backend_types() as $type ) {
			//phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			echo "<div class=dsh-tab id='tab-$type'>";
			//phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			echo Plugin::instance()->shortcodes_manager->expand_shortcodes( "{demo:$type}" );
			echo '</div>';
		}
		echo '</div>';
		echo '</div>';
	}

	protected function render_select2( $selected_post ) {
		echo '<div class=demos-preview-select-wrapper style="display: none"><label for=dsh-demos-post-selector>';
		echo esc_html__( 'Select Preview Post', 'dynamic-shortcodes' );
		echo '</label><br />';
		echo '<select id=dsh-demos-post-selector>';
		if ( $selected_post ) {
			echo '<option value="' . esc_attr( $selected_post->ID ) . '">';
			echo esc_html( $selected_post->post_title ) . '</option>';
		}
		echo '</select></div>';
	}

	public function get_posts_ajax_callback() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_send_json_error( [ 'message' => 'Unauthorized' ] );
		}
		$return = [];
		//phpcs:disable WordPress.Security.NonceVerification.Recommended
		$args = [
			's' => $_GET['q'],
			'post_status' => 'publish',
			'ignore_sticky_posts' => 1,
			'posts_per_page' => 50,
		];
		if ( $_GET['dsh_post_type'] ?? false ) {
			$args['post_type'] = $_GET['dsh_post_type'];
		}
		//phpcs:enable
		$search_results = new \WP_Query( $args );
		while ( $search_results->have_posts() ) {
			$search_results->the_post();
			// shorten the title a little
			$title    = ( mb_strlen( $search_results->post->post_title ) > 50 ) ? mb_substr( $search_results->post->post_title, 0, 49 ) . '...' : $search_results->post->post_title;
			$return[] = [ $search_results->post->ID, $title ];
		}
		echo wp_json_encode( $return );
		die;
	}
}
