<?php

// SPDX-FileCopyrightText: 2022-2025 Ovation S.r.l. <help@dynamic.ooo>
// SPDX-License-Identifier: LicenseRef-GPL-3.0-with-dynamicooo-additional-terms

namespace DynamicShortcodes\Core\Shortcodes;

/**
 * Interface for shortcodes to declare their metadata statically.
 * This allows extraction of shortcode information without instantiation.
 */
interface ShortcodeMetadataInterface {
	/**
	 * Get the arity constraints for this shortcode.
	 *
	 * @return array{min: int, max: int|false} min and max number of arguments
	 */
	public static function get_arity_constraints();

	/**
	 * Get the allowed keyargs for this shortcode.
	 *
	 * @return array{
	 *   allowed: array<string, array<string>>|false,
	 *   conflicts?: array<array<string>>,
	 *   requirements?: array<string, array<string>>,
	 *   specials_only?: bool
	 * }
	 */
	public static function get_keyargs_config();
}
